/*
*****************************************************************************
   LIBGCP: extension API header file

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


*****************************************************************************
*/


#ifndef _GGI_GCP_H
#define _GGI_GCP_H

#include <ggi/ggi.h>

__BEGIN_DECLS

/* Extension management
 */
int gcpInit(void);
int gcpExit(void);

int gcpAttach(ggi_visual_t vis);
int gcpDetach(ggi_visual_t vis);




/* API functions
 */


typedef ggi_pixel gcp_pixel;

typedef ggi_color gcp_RGBAcolor;
typedef struct { ggi_float y,u,v; } gcp_YUVcolor;
typedef struct { uint16 c,m,y,k; } gcp_CMYKcolor;
typedef struct { ggi_float h,s,v; } gcp_HSVcolor;
typedef struct { uint16 y,c1,c2; } gcp_YCCcolor;


#define GCP_COLOR_PRECISION	GGI_COLOR_PRECISION


/* Color palette manipulation
 */

/* RGBA */
gcp_pixel gcpMapRGBAColor(ggi_visual_t vis, gcp_RGBAcolor *col);
int gcpUnmapRGBAPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_RGBAcolor *col);

int gcpPackRGBAColors(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len);
int gcpUnpackRGBAPixels(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len);

int gcpGetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap);
int gcpSetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap);


/* YUV */
gcp_pixel gcpMapYUVColor(ggi_visual_t vis, gcp_YUVcolor *col);
int gcpUnmapYUVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YUVcolor *col);

int gcpPackYUVColors(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len);
int gcpUnpackYUVPixels(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len);

int gcpGetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap);
int gcpSetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap);


/* CMYK */
gcp_pixel gcpMapCMYKColor(ggi_visual_t vis, gcp_CMYKcolor *col);
int gcpUnmapCMYKPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_CMYKcolor *col);

int gcpPackCMYKColors(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len);
int gcpUnpackCMYKPixels(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len);

int gcpGetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap);
int gcpSetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap);


/* HSV */
gcp_pixel gcpMapHSVColor(ggi_visual_t vis, gcp_HSVcolor *col);
int gcpUnmapHSVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_HSVcolor *col);

int gcpPackHSVColors(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len);
int gcpUnpackHSVPixels(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len);

int gcpGetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap);
int gcpSetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap);


/* Kodak PhotoCD */
gcp_pixel gcpMapYCCColor(ggi_visual_t vis, gcp_YCCcolor *col);
int gcpUnmapYCCPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YCCcolor *col);

int gcpPackYCCColors(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len);
int gcpUnpackYCCPixels(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len);

int gcpGetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap);
int gcpSetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap);



int gcpSetColorfulPalette(ggi_visual_t vis);

#define GCP_PALETTE_DONTCARE	GGI_PALETTE_DONTCARE



/* Gamma map manipulation
 */

/* RGBA */
int gcpGetRGBAGamma(ggi_visual_t vis,ggi_float *r,ggi_float *g,ggi_float *b);
int gcpSetRGBAGamma(ggi_visual_t vis,ggi_float r,ggi_float g,ggi_float b);

int gcpGetRGBAGammaMap(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap);
int gcpSetRGBAGammaMap(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap);


/* YUV */
int gcpGetYUVGamma(ggi_visual_t vis,ggi_float *y,ggi_float *u,ggi_float *v);
int gcpSetYUVGamma(ggi_visual_t vis,ggi_float y,ggi_float u,ggi_float v);

int gcpGetYUVGammaMap(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap);
int gcpSetYUVGammaMap(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap);


/* CMYK */
int gcpGetCMYKGamma(ggi_visual_t vis,ggi_float *c,ggi_float *m,ggi_float *y,ggi_float *k);
int gcpSetCMYKGamma(ggi_visual_t vis,ggi_float c,ggi_float m,ggi_float y,ggi_float k);

int gcpGetCMYKGammaMap(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap);
int gcpSetCMYKGammaMap(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap);


/* HSV */
int gcpGetHSVGamma(ggi_visual_t vis,ggi_float *h,ggi_float *s,ggi_float *v);
int gcpSetHSVGamma(ggi_visual_t vis,ggi_float h,ggi_float s,ggi_float v);

int gcpGetHSVGammaMap(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap);
int gcpSetHSVGammaMap(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap);


/* Kodak PhotoCD */
int gcpGetYCCGamma(ggi_visual_t vis,ggi_float *y,ggi_float *c1,ggi_float *c2);
int gcpSetYCCGamma(ggi_visual_t vis,ggi_float y,ggi_float c1,ggi_float c2);

int gcpGetYCCGammaMap(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap);
int gcpSetYCCGammaMap(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap);


/* Blending manipulation
 *   Note: You can also use this for transluency effects
 */

/* Color blending */
gcp_pixel gcpBlendColor(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *pix2, uint16 alpha);



/* Luminance manipulation
 */

ggi_float gcpGetLuminance(ggi_visual_t vis, const gcp_pixel pix);


/* Lightness manipulation
 */

gcp_pixel gcpSetIntensity(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *light_color);
gcp_pixel gcpGetIntensity(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *pix2);


__END_DECLS

#endif /* _GGI_GCP_H */
