dnl ---------------------
dnl Check whether usleep returns void, and #define GG_USLEEP_VOID in
dnl that case.  
AC_DEFUN([AC_USLEEP_VOID],
[AC_CACHE_CHECK([whether usleep returns void], [ac_cv_usleep_void],
[AC_COMPILE_IFELSE(
[AC_LANG_PROGRAM(
[AC_INCLUDES_DEFAULT()],[int i; i = usleep(1); return(0);])],
[ac_cv_usleep_void=no],[ac_cv_usleep_void=yes])])
if test $ac_cv_usleep_void = yes; then
  AC_DEFINE(GG_USLEEP_VOID, 1,
            [Define to 1 if the `usleep' function returns void.])
fi
])


dnl ---------------------
dnl Check whether usleep limits value of usecs, and #define GG_USLEEP_999999
dnl in that case.
AC_DEFUN([AC_USLEEP_999999],
[AC_CACHE_CHECK([whether usleep limits usecs], [ac_cv_usleep_999999],
[AC_RUN_IFELSE(
[AC_LANG_PROGRAM(
[AC_INCLUDES_DEFAULT()
#include <errno.h>
],
[int i; i = usleep(1000001); 
 if (i == 0 || i == EINTR) return(-1);
 return 0;])],
[ac_cv_usleep_999999=yes],
[ac_cv_usleep_999999=no],
[ac_cv_usleep_999999=no])])
if test $ac_cv_usleep_999999 = yes; then
  AC_DEFINE(GG_USLEEP_999999, 1,
            [Define to 1 if the `usleep' function limits usecs value.])
fi
])


