/* -*- mode: C -*- Time-stamp: "08/07/28 22:26:40 jemarch"
 *
 *       File:         pdf-text-ucd-case.c
 *       Date:         Sun Mar 09 12:59:01 2008
 *
 *       GNU PDF Library - Unicode Character Database - Case Algorithms
 *
 *    WARNING! The contents of the arrays in this file are self-generated
 *     from the UnicodeData.txt and SpecialCasing.txt files, using the
 *     `pdf_text_generate_ucd' utility
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <pdf-text-ucd-case.h>
#include <pdf-text-ucd-combclass.h>
#include <pdf-text-ucd-wordbreak.h>
#include <pdf-text-ucd-gencat.h>
#include <pdf-text-ucd-proplist.h>


/* Structure to contain the case information of each unicode point.
 */
#define PDF_TEXT_MNSC 3
typedef struct _unicode_case_info_s {
  pdf_u32_t unicode_point;
  pdf_u32_t uppercase_point;
  pdf_u32_t lowercase_point;
  pdf_u32_t titlecase_point;
  pdf_i16_t special_case_indexes[PDF_TEXT_MNSC];
} unicode_case_info_t;


/* Structure to contain the interval information. All the unicode points in a
 *  given interval (between `interval_start' and `interval_stop', both included) 
 *  have the same `deltaToIndex' value. If this delta is applied to the 32bit 
 *  Unicode value itself, the INDEX of the unicode point in the 
 *  `unicode_case_info' array is obtained, for a direct access to the case
 *  information */
typedef struct _unicode_case_interval_s {
  pdf_u32_t interval_start;
  pdf_u32_t interval_stop;
  long deltaToIndex;
} unicode_case_interval_t;


/* Structure to contain the special case information of each unicode point. */
typedef struct _unicode_special_case_info_s {
  pdf_u32_t unicode_point;
  pdf_u32_t lowercase_point[UCD_SC_MAX_EXPAND];
  pdf_u32_t uppercase_point[UCD_SC_MAX_EXPAND];
  pdf_u32_t titlecase_point[UCD_SC_MAX_EXPAND];
  const char *condition_list;
} unicode_special_case_info_t;


/* Specific type for the Casing Context used in casing algorithms */
typedef struct _pdf_text_ucd_context_s {
  pdf_char_t *context_start;    /* Pointer to the first byte of the first point
                                 *  in the context */
  pdf_char_t *context_stop;     /* Pointer to the first byte of the last point
                                 *  in the context */
  pdf_char_t *unicode_point;    /* Pointer to the first byte of the point within
                                 *  the context */
  pdf_char_t locale[2];         /* Specific language ID for special casing */
} pdf_text_ucd_context_t;


/*************** START OF SELF-GENERATED DATA *********************************/

/* Constant length of arrays */
#define UCD_C_INFO_N    2099
#define UCD_C_INT_N     99
#define UCD_SC_INFO_N   119

/* Array containing the case information for each unicode point (really only for
 *  those which actually have some case information) */
static unicode_case_info_t unicode_case_info[UCD_C_INFO_N] = {
	{ 0x0041, 0x0041, 0x0061, 0x0041, { -1, -1, -1 } }, /* index: 0 */
	{ 0x0042, 0x0042, 0x0062, 0x0042, { -1, -1, -1 } }, /* index: 1 */
	{ 0x0043, 0x0043, 0x0063, 0x0043, { -1, -1, -1 } }, /* index: 2 */
	{ 0x0044, 0x0044, 0x0064, 0x0044, { -1, -1, -1 } }, /* index: 3 */
	{ 0x0045, 0x0045, 0x0065, 0x0045, { -1, -1, -1 } }, /* index: 4 */
	{ 0x0046, 0x0046, 0x0066, 0x0046, { -1, -1, -1 } }, /* index: 5 */
	{ 0x0047, 0x0047, 0x0067, 0x0047, { -1, -1, -1 } }, /* index: 6 */
	{ 0x0048, 0x0048, 0x0068, 0x0048, { -1, -1, -1 } }, /* index: 7 */
	{ 0x0049, 0x0049, 0x0069, 0x0049, { 105, 115, 116 } }, /* index: 8 */
	{ 0x004A, 0x004A, 0x006A, 0x004A, { 106, -1, -1 } }, /* index: 9 */
	{ 0x004B, 0x004B, 0x006B, 0x004B, { -1, -1, -1 } }, /* index: 10 */
	{ 0x004C, 0x004C, 0x006C, 0x004C, { -1, -1, -1 } }, /* index: 11 */
	{ 0x004D, 0x004D, 0x006D, 0x004D, { -1, -1, -1 } }, /* index: 12 */
	{ 0x004E, 0x004E, 0x006E, 0x004E, { -1, -1, -1 } }, /* index: 13 */
	{ 0x004F, 0x004F, 0x006F, 0x004F, { -1, -1, -1 } }, /* index: 14 */
	{ 0x0050, 0x0050, 0x0070, 0x0050, { -1, -1, -1 } }, /* index: 15 */
	{ 0x0051, 0x0051, 0x0071, 0x0051, { -1, -1, -1 } }, /* index: 16 */
	{ 0x0052, 0x0052, 0x0072, 0x0052, { -1, -1, -1 } }, /* index: 17 */
	{ 0x0053, 0x0053, 0x0073, 0x0053, { -1, -1, -1 } }, /* index: 18 */
	{ 0x0054, 0x0054, 0x0074, 0x0054, { -1, -1, -1 } }, /* index: 19 */
	{ 0x0055, 0x0055, 0x0075, 0x0055, { -1, -1, -1 } }, /* index: 20 */
	{ 0x0056, 0x0056, 0x0076, 0x0056, { -1, -1, -1 } }, /* index: 21 */
	{ 0x0057, 0x0057, 0x0077, 0x0057, { -1, -1, -1 } }, /* index: 22 */
	{ 0x0058, 0x0058, 0x0078, 0x0058, { -1, -1, -1 } }, /* index: 23 */
	{ 0x0059, 0x0059, 0x0079, 0x0059, { -1, -1, -1 } }, /* index: 24 */
	{ 0x005A, 0x005A, 0x007A, 0x005A, { -1, -1, -1 } }, /* index: 25 */
	{ 0x0061, 0x0041, 0x0061, 0x0041, { -1, -1, -1 } }, /* index: 26 */
	{ 0x0062, 0x0042, 0x0062, 0x0042, { -1, -1, -1 } }, /* index: 27 */
	{ 0x0063, 0x0043, 0x0063, 0x0043, { -1, -1, -1 } }, /* index: 28 */
	{ 0x0064, 0x0044, 0x0064, 0x0044, { -1, -1, -1 } }, /* index: 29 */
	{ 0x0065, 0x0045, 0x0065, 0x0045, { -1, -1, -1 } }, /* index: 30 */
	{ 0x0066, 0x0046, 0x0066, 0x0046, { -1, -1, -1 } }, /* index: 31 */
	{ 0x0067, 0x0047, 0x0067, 0x0047, { -1, -1, -1 } }, /* index: 32 */
	{ 0x0068, 0x0048, 0x0068, 0x0048, { -1, -1, -1 } }, /* index: 33 */
	{ 0x0069, 0x0049, 0x0069, 0x0049, { 117, 118, -1 } }, /* index: 34 */
	{ 0x006A, 0x004A, 0x006A, 0x004A, { -1, -1, -1 } }, /* index: 35 */
	{ 0x006B, 0x004B, 0x006B, 0x004B, { -1, -1, -1 } }, /* index: 36 */
	{ 0x006C, 0x004C, 0x006C, 0x004C, { -1, -1, -1 } }, /* index: 37 */
	{ 0x006D, 0x004D, 0x006D, 0x004D, { -1, -1, -1 } }, /* index: 38 */
	{ 0x006E, 0x004E, 0x006E, 0x004E, { -1, -1, -1 } }, /* index: 39 */
	{ 0x006F, 0x004F, 0x006F, 0x004F, { -1, -1, -1 } }, /* index: 40 */
	{ 0x0070, 0x0050, 0x0070, 0x0050, { -1, -1, -1 } }, /* index: 41 */
	{ 0x0071, 0x0051, 0x0071, 0x0051, { -1, -1, -1 } }, /* index: 42 */
	{ 0x0072, 0x0052, 0x0072, 0x0052, { -1, -1, -1 } }, /* index: 43 */
	{ 0x0073, 0x0053, 0x0073, 0x0053, { -1, -1, -1 } }, /* index: 44 */
	{ 0x0074, 0x0054, 0x0074, 0x0054, { -1, -1, -1 } }, /* index: 45 */
	{ 0x0075, 0x0055, 0x0075, 0x0055, { -1, -1, -1 } }, /* index: 46 */
	{ 0x0076, 0x0056, 0x0076, 0x0056, { -1, -1, -1 } }, /* index: 47 */
	{ 0x0077, 0x0057, 0x0077, 0x0057, { -1, -1, -1 } }, /* index: 48 */
	{ 0x0078, 0x0058, 0x0078, 0x0058, { -1, -1, -1 } }, /* index: 49 */
	{ 0x0079, 0x0059, 0x0079, 0x0059, { -1, -1, -1 } }, /* index: 50 */
	{ 0x007A, 0x005A, 0x007A, 0x005A, { -1, -1, -1 } }, /* index: 51 */
	{ 0x00B5, 0x039C, 0x00B5, 0x039C, { -1, -1, -1 } }, /* index: 52 */
	{ 0x00C0, 0x00C0, 0x00E0, 0x00C0, { -1, -1, -1 } }, /* index: 53 */
	{ 0x00C1, 0x00C1, 0x00E1, 0x00C1, { -1, -1, -1 } }, /* index: 54 */
	{ 0x00C2, 0x00C2, 0x00E2, 0x00C2, { -1, -1, -1 } }, /* index: 55 */
	{ 0x00C3, 0x00C3, 0x00E3, 0x00C3, { -1, -1, -1 } }, /* index: 56 */
	{ 0x00C4, 0x00C4, 0x00E4, 0x00C4, { -1, -1, -1 } }, /* index: 57 */
	{ 0x00C5, 0x00C5, 0x00E5, 0x00C5, { -1, -1, -1 } }, /* index: 58 */
	{ 0x00C6, 0x00C6, 0x00E6, 0x00C6, { -1, -1, -1 } }, /* index: 59 */
	{ 0x00C7, 0x00C7, 0x00E7, 0x00C7, { -1, -1, -1 } }, /* index: 60 */
	{ 0x00C8, 0x00C8, 0x00E8, 0x00C8, { -1, -1, -1 } }, /* index: 61 */
	{ 0x00C9, 0x00C9, 0x00E9, 0x00C9, { -1, -1, -1 } }, /* index: 62 */
	{ 0x00CA, 0x00CA, 0x00EA, 0x00CA, { -1, -1, -1 } }, /* index: 63 */
	{ 0x00CB, 0x00CB, 0x00EB, 0x00CB, { -1, -1, -1 } }, /* index: 64 */
	{ 0x00CC, 0x00CC, 0x00EC, 0x00CC, { 108, -1, -1 } }, /* index: 65 */
	{ 0x00CD, 0x00CD, 0x00ED, 0x00CD, { 109, -1, -1 } }, /* index: 66 */
	{ 0x00CE, 0x00CE, 0x00EE, 0x00CE, { -1, -1, -1 } }, /* index: 67 */
	{ 0x00CF, 0x00CF, 0x00EF, 0x00CF, { -1, -1, -1 } }, /* index: 68 */
	{ 0x00D0, 0x00D0, 0x00F0, 0x00D0, { -1, -1, -1 } }, /* index: 69 */
	{ 0x00D1, 0x00D1, 0x00F1, 0x00D1, { -1, -1, -1 } }, /* index: 70 */
	{ 0x00D2, 0x00D2, 0x00F2, 0x00D2, { -1, -1, -1 } }, /* index: 71 */
	{ 0x00D3, 0x00D3, 0x00F3, 0x00D3, { -1, -1, -1 } }, /* index: 72 */
	{ 0x00D4, 0x00D4, 0x00F4, 0x00D4, { -1, -1, -1 } }, /* index: 73 */
	{ 0x00D5, 0x00D5, 0x00F5, 0x00D5, { -1, -1, -1 } }, /* index: 74 */
	{ 0x00D6, 0x00D6, 0x00F6, 0x00D6, { -1, -1, -1 } }, /* index: 75 */
	{ 0x00D8, 0x00D8, 0x00F8, 0x00D8, { -1, -1, -1 } }, /* index: 76 */
	{ 0x00D9, 0x00D9, 0x00F9, 0x00D9, { -1, -1, -1 } }, /* index: 77 */
	{ 0x00DA, 0x00DA, 0x00FA, 0x00DA, { -1, -1, -1 } }, /* index: 78 */
	{ 0x00DB, 0x00DB, 0x00FB, 0x00DB, { -1, -1, -1 } }, /* index: 79 */
	{ 0x00DC, 0x00DC, 0x00FC, 0x00DC, { -1, -1, -1 } }, /* index: 80 */
	{ 0x00DD, 0x00DD, 0x00FD, 0x00DD, { -1, -1, -1 } }, /* index: 81 */
	{ 0x00DE, 0x00DE, 0x00FE, 0x00DE, { -1, -1, -1 } }, /* index: 82 */
	{ 0x00DF, 0x00DF, 0x00DF, 0x00DF, { 0, -1, -1 } }, /* index: 83 */
	{ 0x00E0, 0x00C0, 0x00E0, 0x00C0, { -1, -1, -1 } }, /* index: 84 */
	{ 0x00E1, 0x00C1, 0x00E1, 0x00C1, { -1, -1, -1 } }, /* index: 85 */
	{ 0x00E2, 0x00C2, 0x00E2, 0x00C2, { -1, -1, -1 } }, /* index: 86 */
	{ 0x00E3, 0x00C3, 0x00E3, 0x00C3, { -1, -1, -1 } }, /* index: 87 */
	{ 0x00E4, 0x00C4, 0x00E4, 0x00C4, { -1, -1, -1 } }, /* index: 88 */
	{ 0x00E5, 0x00C5, 0x00E5, 0x00C5, { -1, -1, -1 } }, /* index: 89 */
	{ 0x00E6, 0x00C6, 0x00E6, 0x00C6, { -1, -1, -1 } }, /* index: 90 */
	{ 0x00E7, 0x00C7, 0x00E7, 0x00C7, { -1, -1, -1 } }, /* index: 91 */
	{ 0x00E8, 0x00C8, 0x00E8, 0x00C8, { -1, -1, -1 } }, /* index: 92 */
	{ 0x00E9, 0x00C9, 0x00E9, 0x00C9, { -1, -1, -1 } }, /* index: 93 */
	{ 0x00EA, 0x00CA, 0x00EA, 0x00CA, { -1, -1, -1 } }, /* index: 94 */
	{ 0x00EB, 0x00CB, 0x00EB, 0x00CB, { -1, -1, -1 } }, /* index: 95 */
	{ 0x00EC, 0x00CC, 0x00EC, 0x00CC, { -1, -1, -1 } }, /* index: 96 */
	{ 0x00ED, 0x00CD, 0x00ED, 0x00CD, { -1, -1, -1 } }, /* index: 97 */
	{ 0x00EE, 0x00CE, 0x00EE, 0x00CE, { -1, -1, -1 } }, /* index: 98 */
	{ 0x00EF, 0x00CF, 0x00EF, 0x00CF, { -1, -1, -1 } }, /* index: 99 */
	{ 0x00F0, 0x00D0, 0x00F0, 0x00D0, { -1, -1, -1 } }, /* index: 100 */
	{ 0x00F1, 0x00D1, 0x00F1, 0x00D1, { -1, -1, -1 } }, /* index: 101 */
	{ 0x00F2, 0x00D2, 0x00F2, 0x00D2, { -1, -1, -1 } }, /* index: 102 */
	{ 0x00F3, 0x00D3, 0x00F3, 0x00D3, { -1, -1, -1 } }, /* index: 103 */
	{ 0x00F4, 0x00D4, 0x00F4, 0x00D4, { -1, -1, -1 } }, /* index: 104 */
	{ 0x00F5, 0x00D5, 0x00F5, 0x00D5, { -1, -1, -1 } }, /* index: 105 */
	{ 0x00F6, 0x00D6, 0x00F6, 0x00D6, { -1, -1, -1 } }, /* index: 106 */
	{ 0x00F8, 0x00D8, 0x00F8, 0x00D8, { -1, -1, -1 } }, /* index: 107 */
	{ 0x00F9, 0x00D9, 0x00F9, 0x00D9, { -1, -1, -1 } }, /* index: 108 */
	{ 0x00FA, 0x00DA, 0x00FA, 0x00DA, { -1, -1, -1 } }, /* index: 109 */
	{ 0x00FB, 0x00DB, 0x00FB, 0x00DB, { -1, -1, -1 } }, /* index: 110 */
	{ 0x00FC, 0x00DC, 0x00FC, 0x00DC, { -1, -1, -1 } }, /* index: 111 */
	{ 0x00FD, 0x00DD, 0x00FD, 0x00DD, { -1, -1, -1 } }, /* index: 112 */
	{ 0x00FE, 0x00DE, 0x00FE, 0x00DE, { -1, -1, -1 } }, /* index: 113 */
	{ 0x00FF, 0x0178, 0x00FF, 0x0178, { -1, -1, -1 } }, /* index: 114 */
	{ 0x0100, 0x0100, 0x0101, 0x0100, { -1, -1, -1 } }, /* index: 115 */
	{ 0x0101, 0x0100, 0x0101, 0x0100, { -1, -1, -1 } }, /* index: 116 */
	{ 0x0102, 0x0102, 0x0103, 0x0102, { -1, -1, -1 } }, /* index: 117 */
	{ 0x0103, 0x0102, 0x0103, 0x0102, { -1, -1, -1 } }, /* index: 118 */
	{ 0x0104, 0x0104, 0x0105, 0x0104, { -1, -1, -1 } }, /* index: 119 */
	{ 0x0105, 0x0104, 0x0105, 0x0104, { -1, -1, -1 } }, /* index: 120 */
	{ 0x0106, 0x0106, 0x0107, 0x0106, { -1, -1, -1 } }, /* index: 121 */
	{ 0x0107, 0x0106, 0x0107, 0x0106, { -1, -1, -1 } }, /* index: 122 */
	{ 0x0108, 0x0108, 0x0109, 0x0108, { -1, -1, -1 } }, /* index: 123 */
	{ 0x0109, 0x0108, 0x0109, 0x0108, { -1, -1, -1 } }, /* index: 124 */
	{ 0x010A, 0x010A, 0x010B, 0x010A, { -1, -1, -1 } }, /* index: 125 */
	{ 0x010B, 0x010A, 0x010B, 0x010A, { -1, -1, -1 } }, /* index: 126 */
	{ 0x010C, 0x010C, 0x010D, 0x010C, { -1, -1, -1 } }, /* index: 127 */
	{ 0x010D, 0x010C, 0x010D, 0x010C, { -1, -1, -1 } }, /* index: 128 */
	{ 0x010E, 0x010E, 0x010F, 0x010E, { -1, -1, -1 } }, /* index: 129 */
	{ 0x010F, 0x010E, 0x010F, 0x010E, { -1, -1, -1 } }, /* index: 130 */
	{ 0x0110, 0x0110, 0x0111, 0x0110, { -1, -1, -1 } }, /* index: 131 */
	{ 0x0111, 0x0110, 0x0111, 0x0110, { -1, -1, -1 } }, /* index: 132 */
	{ 0x0112, 0x0112, 0x0113, 0x0112, { -1, -1, -1 } }, /* index: 133 */
	{ 0x0113, 0x0112, 0x0113, 0x0112, { -1, -1, -1 } }, /* index: 134 */
	{ 0x0114, 0x0114, 0x0115, 0x0114, { -1, -1, -1 } }, /* index: 135 */
	{ 0x0115, 0x0114, 0x0115, 0x0114, { -1, -1, -1 } }, /* index: 136 */
	{ 0x0116, 0x0116, 0x0117, 0x0116, { -1, -1, -1 } }, /* index: 137 */
	{ 0x0117, 0x0116, 0x0117, 0x0116, { -1, -1, -1 } }, /* index: 138 */
	{ 0x0118, 0x0118, 0x0119, 0x0118, { -1, -1, -1 } }, /* index: 139 */
	{ 0x0119, 0x0118, 0x0119, 0x0118, { -1, -1, -1 } }, /* index: 140 */
	{ 0x011A, 0x011A, 0x011B, 0x011A, { -1, -1, -1 } }, /* index: 141 */
	{ 0x011B, 0x011A, 0x011B, 0x011A, { -1, -1, -1 } }, /* index: 142 */
	{ 0x011C, 0x011C, 0x011D, 0x011C, { -1, -1, -1 } }, /* index: 143 */
	{ 0x011D, 0x011C, 0x011D, 0x011C, { -1, -1, -1 } }, /* index: 144 */
	{ 0x011E, 0x011E, 0x011F, 0x011E, { -1, -1, -1 } }, /* index: 145 */
	{ 0x011F, 0x011E, 0x011F, 0x011E, { -1, -1, -1 } }, /* index: 146 */
	{ 0x0120, 0x0120, 0x0121, 0x0120, { -1, -1, -1 } }, /* index: 147 */
	{ 0x0121, 0x0120, 0x0121, 0x0120, { -1, -1, -1 } }, /* index: 148 */
	{ 0x0122, 0x0122, 0x0123, 0x0122, { -1, -1, -1 } }, /* index: 149 */
	{ 0x0123, 0x0122, 0x0123, 0x0122, { -1, -1, -1 } }, /* index: 150 */
	{ 0x0124, 0x0124, 0x0125, 0x0124, { -1, -1, -1 } }, /* index: 151 */
	{ 0x0125, 0x0124, 0x0125, 0x0124, { -1, -1, -1 } }, /* index: 152 */
	{ 0x0126, 0x0126, 0x0127, 0x0126, { -1, -1, -1 } }, /* index: 153 */
	{ 0x0127, 0x0126, 0x0127, 0x0126, { -1, -1, -1 } }, /* index: 154 */
	{ 0x0128, 0x0128, 0x0129, 0x0128, { 110, -1, -1 } }, /* index: 155 */
	{ 0x0129, 0x0128, 0x0129, 0x0128, { -1, -1, -1 } }, /* index: 156 */
	{ 0x012A, 0x012A, 0x012B, 0x012A, { -1, -1, -1 } }, /* index: 157 */
	{ 0x012B, 0x012A, 0x012B, 0x012A, { -1, -1, -1 } }, /* index: 158 */
	{ 0x012C, 0x012C, 0x012D, 0x012C, { -1, -1, -1 } }, /* index: 159 */
	{ 0x012D, 0x012C, 0x012D, 0x012C, { -1, -1, -1 } }, /* index: 160 */
	{ 0x012E, 0x012E, 0x012F, 0x012E, { 107, -1, -1 } }, /* index: 161 */
	{ 0x012F, 0x012E, 0x012F, 0x012E, { -1, -1, -1 } }, /* index: 162 */
	{ 0x0130, 0x0130, 0x0069, 0x0130, { 1, 111, 112 } }, /* index: 163 */
	{ 0x0131, 0x0049, 0x0131, 0x0049, { -1, -1, -1 } }, /* index: 164 */
	{ 0x0132, 0x0132, 0x0133, 0x0132, { -1, -1, -1 } }, /* index: 165 */
	{ 0x0133, 0x0132, 0x0133, 0x0132, { -1, -1, -1 } }, /* index: 166 */
	{ 0x0134, 0x0134, 0x0135, 0x0134, { -1, -1, -1 } }, /* index: 167 */
	{ 0x0135, 0x0134, 0x0135, 0x0134, { -1, -1, -1 } }, /* index: 168 */
	{ 0x0136, 0x0136, 0x0137, 0x0136, { -1, -1, -1 } }, /* index: 169 */
	{ 0x0137, 0x0136, 0x0137, 0x0136, { -1, -1, -1 } }, /* index: 170 */
	{ 0x0139, 0x0139, 0x013A, 0x0139, { -1, -1, -1 } }, /* index: 171 */
	{ 0x013A, 0x0139, 0x013A, 0x0139, { -1, -1, -1 } }, /* index: 172 */
	{ 0x013B, 0x013B, 0x013C, 0x013B, { -1, -1, -1 } }, /* index: 173 */
	{ 0x013C, 0x013B, 0x013C, 0x013B, { -1, -1, -1 } }, /* index: 174 */
	{ 0x013D, 0x013D, 0x013E, 0x013D, { -1, -1, -1 } }, /* index: 175 */
	{ 0x013E, 0x013D, 0x013E, 0x013D, { -1, -1, -1 } }, /* index: 176 */
	{ 0x013F, 0x013F, 0x0140, 0x013F, { -1, -1, -1 } }, /* index: 177 */
	{ 0x0140, 0x013F, 0x0140, 0x013F, { -1, -1, -1 } }, /* index: 178 */
	{ 0x0141, 0x0141, 0x0142, 0x0141, { -1, -1, -1 } }, /* index: 179 */
	{ 0x0142, 0x0141, 0x0142, 0x0141, { -1, -1, -1 } }, /* index: 180 */
	{ 0x0143, 0x0143, 0x0144, 0x0143, { -1, -1, -1 } }, /* index: 181 */
	{ 0x0144, 0x0143, 0x0144, 0x0143, { -1, -1, -1 } }, /* index: 182 */
	{ 0x0145, 0x0145, 0x0146, 0x0145, { -1, -1, -1 } }, /* index: 183 */
	{ 0x0146, 0x0145, 0x0146, 0x0145, { -1, -1, -1 } }, /* index: 184 */
	{ 0x0147, 0x0147, 0x0148, 0x0147, { -1, -1, -1 } }, /* index: 185 */
	{ 0x0148, 0x0147, 0x0148, 0x0147, { -1, -1, -1 } }, /* index: 186 */
	{ 0x0149, 0x0149, 0x0149, 0x0149, { 15, -1, -1 } }, /* index: 187 */
	{ 0x014A, 0x014A, 0x014B, 0x014A, { -1, -1, -1 } }, /* index: 188 */
	{ 0x014B, 0x014A, 0x014B, 0x014A, { -1, -1, -1 } }, /* index: 189 */
	{ 0x014C, 0x014C, 0x014D, 0x014C, { -1, -1, -1 } }, /* index: 190 */
	{ 0x014D, 0x014C, 0x014D, 0x014C, { -1, -1, -1 } }, /* index: 191 */
	{ 0x014E, 0x014E, 0x014F, 0x014E, { -1, -1, -1 } }, /* index: 192 */
	{ 0x014F, 0x014E, 0x014F, 0x014E, { -1, -1, -1 } }, /* index: 193 */
	{ 0x0150, 0x0150, 0x0151, 0x0150, { -1, -1, -1 } }, /* index: 194 */
	{ 0x0151, 0x0150, 0x0151, 0x0150, { -1, -1, -1 } }, /* index: 195 */
	{ 0x0152, 0x0152, 0x0153, 0x0152, { -1, -1, -1 } }, /* index: 196 */
	{ 0x0153, 0x0152, 0x0153, 0x0152, { -1, -1, -1 } }, /* index: 197 */
	{ 0x0154, 0x0154, 0x0155, 0x0154, { -1, -1, -1 } }, /* index: 198 */
	{ 0x0155, 0x0154, 0x0155, 0x0154, { -1, -1, -1 } }, /* index: 199 */
	{ 0x0156, 0x0156, 0x0157, 0x0156, { -1, -1, -1 } }, /* index: 200 */
	{ 0x0157, 0x0156, 0x0157, 0x0156, { -1, -1, -1 } }, /* index: 201 */
	{ 0x0158, 0x0158, 0x0159, 0x0158, { -1, -1, -1 } }, /* index: 202 */
	{ 0x0159, 0x0158, 0x0159, 0x0158, { -1, -1, -1 } }, /* index: 203 */
	{ 0x015A, 0x015A, 0x015B, 0x015A, { -1, -1, -1 } }, /* index: 204 */
	{ 0x015B, 0x015A, 0x015B, 0x015A, { -1, -1, -1 } }, /* index: 205 */
	{ 0x015C, 0x015C, 0x015D, 0x015C, { -1, -1, -1 } }, /* index: 206 */
	{ 0x015D, 0x015C, 0x015D, 0x015C, { -1, -1, -1 } }, /* index: 207 */
	{ 0x015E, 0x015E, 0x015F, 0x015E, { -1, -1, -1 } }, /* index: 208 */
	{ 0x015F, 0x015E, 0x015F, 0x015E, { -1, -1, -1 } }, /* index: 209 */
	{ 0x0160, 0x0160, 0x0161, 0x0160, { -1, -1, -1 } }, /* index: 210 */
	{ 0x0161, 0x0160, 0x0161, 0x0160, { -1, -1, -1 } }, /* index: 211 */
	{ 0x0162, 0x0162, 0x0163, 0x0162, { -1, -1, -1 } }, /* index: 212 */
	{ 0x0163, 0x0162, 0x0163, 0x0162, { -1, -1, -1 } }, /* index: 213 */
	{ 0x0164, 0x0164, 0x0165, 0x0164, { -1, -1, -1 } }, /* index: 214 */
	{ 0x0165, 0x0164, 0x0165, 0x0164, { -1, -1, -1 } }, /* index: 215 */
	{ 0x0166, 0x0166, 0x0167, 0x0166, { -1, -1, -1 } }, /* index: 216 */
	{ 0x0167, 0x0166, 0x0167, 0x0166, { -1, -1, -1 } }, /* index: 217 */
	{ 0x0168, 0x0168, 0x0169, 0x0168, { -1, -1, -1 } }, /* index: 218 */
	{ 0x0169, 0x0168, 0x0169, 0x0168, { -1, -1, -1 } }, /* index: 219 */
	{ 0x016A, 0x016A, 0x016B, 0x016A, { -1, -1, -1 } }, /* index: 220 */
	{ 0x016B, 0x016A, 0x016B, 0x016A, { -1, -1, -1 } }, /* index: 221 */
	{ 0x016C, 0x016C, 0x016D, 0x016C, { -1, -1, -1 } }, /* index: 222 */
	{ 0x016D, 0x016C, 0x016D, 0x016C, { -1, -1, -1 } }, /* index: 223 */
	{ 0x016E, 0x016E, 0x016F, 0x016E, { -1, -1, -1 } }, /* index: 224 */
	{ 0x016F, 0x016E, 0x016F, 0x016E, { -1, -1, -1 } }, /* index: 225 */
	{ 0x0170, 0x0170, 0x0171, 0x0170, { -1, -1, -1 } }, /* index: 226 */
	{ 0x0171, 0x0170, 0x0171, 0x0170, { -1, -1, -1 } }, /* index: 227 */
	{ 0x0172, 0x0172, 0x0173, 0x0172, { -1, -1, -1 } }, /* index: 228 */
	{ 0x0173, 0x0172, 0x0173, 0x0172, { -1, -1, -1 } }, /* index: 229 */
	{ 0x0174, 0x0174, 0x0175, 0x0174, { -1, -1, -1 } }, /* index: 230 */
	{ 0x0175, 0x0174, 0x0175, 0x0174, { -1, -1, -1 } }, /* index: 231 */
	{ 0x0176, 0x0176, 0x0177, 0x0176, { -1, -1, -1 } }, /* index: 232 */
	{ 0x0177, 0x0176, 0x0177, 0x0176, { -1, -1, -1 } }, /* index: 233 */
	{ 0x0178, 0x0178, 0x00FF, 0x0178, { -1, -1, -1 } }, /* index: 234 */
	{ 0x0179, 0x0179, 0x017A, 0x0179, { -1, -1, -1 } }, /* index: 235 */
	{ 0x017A, 0x0179, 0x017A, 0x0179, { -1, -1, -1 } }, /* index: 236 */
	{ 0x017B, 0x017B, 0x017C, 0x017B, { -1, -1, -1 } }, /* index: 237 */
	{ 0x017C, 0x017B, 0x017C, 0x017B, { -1, -1, -1 } }, /* index: 238 */
	{ 0x017D, 0x017D, 0x017E, 0x017D, { -1, -1, -1 } }, /* index: 239 */
	{ 0x017E, 0x017D, 0x017E, 0x017D, { -1, -1, -1 } }, /* index: 240 */
	{ 0x017F, 0x0053, 0x017F, 0x0053, { -1, -1, -1 } }, /* index: 241 */
	{ 0x0180, 0x0243, 0x0180, 0x0243, { -1, -1, -1 } }, /* index: 242 */
	{ 0x0181, 0x0181, 0x0253, 0x0181, { -1, -1, -1 } }, /* index: 243 */
	{ 0x0182, 0x0182, 0x0183, 0x0182, { -1, -1, -1 } }, /* index: 244 */
	{ 0x0183, 0x0182, 0x0183, 0x0182, { -1, -1, -1 } }, /* index: 245 */
	{ 0x0184, 0x0184, 0x0185, 0x0184, { -1, -1, -1 } }, /* index: 246 */
	{ 0x0185, 0x0184, 0x0185, 0x0184, { -1, -1, -1 } }, /* index: 247 */
	{ 0x0186, 0x0186, 0x0254, 0x0186, { -1, -1, -1 } }, /* index: 248 */
	{ 0x0187, 0x0187, 0x0188, 0x0187, { -1, -1, -1 } }, /* index: 249 */
	{ 0x0188, 0x0187, 0x0188, 0x0187, { -1, -1, -1 } }, /* index: 250 */
	{ 0x0189, 0x0189, 0x0256, 0x0189, { -1, -1, -1 } }, /* index: 251 */
	{ 0x018A, 0x018A, 0x0257, 0x018A, { -1, -1, -1 } }, /* index: 252 */
	{ 0x018B, 0x018B, 0x018C, 0x018B, { -1, -1, -1 } }, /* index: 253 */
	{ 0x018C, 0x018B, 0x018C, 0x018B, { -1, -1, -1 } }, /* index: 254 */
	{ 0x018E, 0x018E, 0x01DD, 0x018E, { -1, -1, -1 } }, /* index: 255 */
	{ 0x018F, 0x018F, 0x0259, 0x018F, { -1, -1, -1 } }, /* index: 256 */
	{ 0x0190, 0x0190, 0x025B, 0x0190, { -1, -1, -1 } }, /* index: 257 */
	{ 0x0191, 0x0191, 0x0192, 0x0191, { -1, -1, -1 } }, /* index: 258 */
	{ 0x0192, 0x0191, 0x0192, 0x0191, { -1, -1, -1 } }, /* index: 259 */
	{ 0x0193, 0x0193, 0x0260, 0x0193, { -1, -1, -1 } }, /* index: 260 */
	{ 0x0194, 0x0194, 0x0263, 0x0194, { -1, -1, -1 } }, /* index: 261 */
	{ 0x0195, 0x01F6, 0x0195, 0x01F6, { -1, -1, -1 } }, /* index: 262 */
	{ 0x0196, 0x0196, 0x0269, 0x0196, { -1, -1, -1 } }, /* index: 263 */
	{ 0x0197, 0x0197, 0x0268, 0x0197, { -1, -1, -1 } }, /* index: 264 */
	{ 0x0198, 0x0198, 0x0199, 0x0198, { -1, -1, -1 } }, /* index: 265 */
	{ 0x0199, 0x0198, 0x0199, 0x0198, { -1, -1, -1 } }, /* index: 266 */
	{ 0x019A, 0x023D, 0x019A, 0x023D, { -1, -1, -1 } }, /* index: 267 */
	{ 0x019C, 0x019C, 0x026F, 0x019C, { -1, -1, -1 } }, /* index: 268 */
	{ 0x019D, 0x019D, 0x0272, 0x019D, { -1, -1, -1 } }, /* index: 269 */
	{ 0x019E, 0x0220, 0x019E, 0x0220, { -1, -1, -1 } }, /* index: 270 */
	{ 0x019F, 0x019F, 0x0275, 0x019F, { -1, -1, -1 } }, /* index: 271 */
	{ 0x01A0, 0x01A0, 0x01A1, 0x01A0, { -1, -1, -1 } }, /* index: 272 */
	{ 0x01A1, 0x01A0, 0x01A1, 0x01A0, { -1, -1, -1 } }, /* index: 273 */
	{ 0x01A2, 0x01A2, 0x01A3, 0x01A2, { -1, -1, -1 } }, /* index: 274 */
	{ 0x01A3, 0x01A2, 0x01A3, 0x01A2, { -1, -1, -1 } }, /* index: 275 */
	{ 0x01A4, 0x01A4, 0x01A5, 0x01A4, { -1, -1, -1 } }, /* index: 276 */
	{ 0x01A5, 0x01A4, 0x01A5, 0x01A4, { -1, -1, -1 } }, /* index: 277 */
	{ 0x01A6, 0x01A6, 0x0280, 0x01A6, { -1, -1, -1 } }, /* index: 278 */
	{ 0x01A7, 0x01A7, 0x01A8, 0x01A7, { -1, -1, -1 } }, /* index: 279 */
	{ 0x01A8, 0x01A7, 0x01A8, 0x01A7, { -1, -1, -1 } }, /* index: 280 */
	{ 0x01A9, 0x01A9, 0x0283, 0x01A9, { -1, -1, -1 } }, /* index: 281 */
	{ 0x01AC, 0x01AC, 0x01AD, 0x01AC, { -1, -1, -1 } }, /* index: 282 */
	{ 0x01AD, 0x01AC, 0x01AD, 0x01AC, { -1, -1, -1 } }, /* index: 283 */
	{ 0x01AE, 0x01AE, 0x0288, 0x01AE, { -1, -1, -1 } }, /* index: 284 */
	{ 0x01AF, 0x01AF, 0x01B0, 0x01AF, { -1, -1, -1 } }, /* index: 285 */
	{ 0x01B0, 0x01AF, 0x01B0, 0x01AF, { -1, -1, -1 } }, /* index: 286 */
	{ 0x01B1, 0x01B1, 0x028A, 0x01B1, { -1, -1, -1 } }, /* index: 287 */
	{ 0x01B2, 0x01B2, 0x028B, 0x01B2, { -1, -1, -1 } }, /* index: 288 */
	{ 0x01B3, 0x01B3, 0x01B4, 0x01B3, { -1, -1, -1 } }, /* index: 289 */
	{ 0x01B4, 0x01B3, 0x01B4, 0x01B3, { -1, -1, -1 } }, /* index: 290 */
	{ 0x01B5, 0x01B5, 0x01B6, 0x01B5, { -1, -1, -1 } }, /* index: 291 */
	{ 0x01B6, 0x01B5, 0x01B6, 0x01B5, { -1, -1, -1 } }, /* index: 292 */
	{ 0x01B7, 0x01B7, 0x0292, 0x01B7, { -1, -1, -1 } }, /* index: 293 */
	{ 0x01B8, 0x01B8, 0x01B9, 0x01B8, { -1, -1, -1 } }, /* index: 294 */
	{ 0x01B9, 0x01B8, 0x01B9, 0x01B8, { -1, -1, -1 } }, /* index: 295 */
	{ 0x01BC, 0x01BC, 0x01BD, 0x01BC, { -1, -1, -1 } }, /* index: 296 */
	{ 0x01BD, 0x01BC, 0x01BD, 0x01BC, { -1, -1, -1 } }, /* index: 297 */
	{ 0x01BF, 0x01F7, 0x01BF, 0x01F7, { -1, -1, -1 } }, /* index: 298 */
	{ 0x01C4, 0x01C4, 0x01C6, 0x01C5, { -1, -1, -1 } }, /* index: 299 */
	{ 0x01C5, 0x01C4, 0x01C6, 0x01C5, { -1, -1, -1 } }, /* index: 300 */
	{ 0x01C6, 0x01C4, 0x01C6, 0x01C5, { -1, -1, -1 } }, /* index: 301 */
	{ 0x01C7, 0x01C7, 0x01C9, 0x01C8, { -1, -1, -1 } }, /* index: 302 */
	{ 0x01C8, 0x01C7, 0x01C9, 0x01C8, { -1, -1, -1 } }, /* index: 303 */
	{ 0x01C9, 0x01C7, 0x01C9, 0x01C8, { -1, -1, -1 } }, /* index: 304 */
	{ 0x01CA, 0x01CA, 0x01CC, 0x01CB, { -1, -1, -1 } }, /* index: 305 */
	{ 0x01CB, 0x01CA, 0x01CC, 0x01CB, { -1, -1, -1 } }, /* index: 306 */
	{ 0x01CC, 0x01CA, 0x01CC, 0x01CB, { -1, -1, -1 } }, /* index: 307 */
	{ 0x01CD, 0x01CD, 0x01CE, 0x01CD, { -1, -1, -1 } }, /* index: 308 */
	{ 0x01CE, 0x01CD, 0x01CE, 0x01CD, { -1, -1, -1 } }, /* index: 309 */
	{ 0x01CF, 0x01CF, 0x01D0, 0x01CF, { -1, -1, -1 } }, /* index: 310 */
	{ 0x01D0, 0x01CF, 0x01D0, 0x01CF, { -1, -1, -1 } }, /* index: 311 */
	{ 0x01D1, 0x01D1, 0x01D2, 0x01D1, { -1, -1, -1 } }, /* index: 312 */
	{ 0x01D2, 0x01D1, 0x01D2, 0x01D1, { -1, -1, -1 } }, /* index: 313 */
	{ 0x01D3, 0x01D3, 0x01D4, 0x01D3, { -1, -1, -1 } }, /* index: 314 */
	{ 0x01D4, 0x01D3, 0x01D4, 0x01D3, { -1, -1, -1 } }, /* index: 315 */
	{ 0x01D5, 0x01D5, 0x01D6, 0x01D5, { -1, -1, -1 } }, /* index: 316 */
	{ 0x01D6, 0x01D5, 0x01D6, 0x01D5, { -1, -1, -1 } }, /* index: 317 */
	{ 0x01D7, 0x01D7, 0x01D8, 0x01D7, { -1, -1, -1 } }, /* index: 318 */
	{ 0x01D8, 0x01D7, 0x01D8, 0x01D7, { -1, -1, -1 } }, /* index: 319 */
	{ 0x01D9, 0x01D9, 0x01DA, 0x01D9, { -1, -1, -1 } }, /* index: 320 */
	{ 0x01DA, 0x01D9, 0x01DA, 0x01D9, { -1, -1, -1 } }, /* index: 321 */
	{ 0x01DB, 0x01DB, 0x01DC, 0x01DB, { -1, -1, -1 } }, /* index: 322 */
	{ 0x01DC, 0x01DB, 0x01DC, 0x01DB, { -1, -1, -1 } }, /* index: 323 */
	{ 0x01DD, 0x018E, 0x01DD, 0x018E, { -1, -1, -1 } }, /* index: 324 */
	{ 0x01DE, 0x01DE, 0x01DF, 0x01DE, { -1, -1, -1 } }, /* index: 325 */
	{ 0x01DF, 0x01DE, 0x01DF, 0x01DE, { -1, -1, -1 } }, /* index: 326 */
	{ 0x01E0, 0x01E0, 0x01E1, 0x01E0, { -1, -1, -1 } }, /* index: 327 */
	{ 0x01E1, 0x01E0, 0x01E1, 0x01E0, { -1, -1, -1 } }, /* index: 328 */
	{ 0x01E2, 0x01E2, 0x01E3, 0x01E2, { -1, -1, -1 } }, /* index: 329 */
	{ 0x01E3, 0x01E2, 0x01E3, 0x01E2, { -1, -1, -1 } }, /* index: 330 */
	{ 0x01E4, 0x01E4, 0x01E5, 0x01E4, { -1, -1, -1 } }, /* index: 331 */
	{ 0x01E5, 0x01E4, 0x01E5, 0x01E4, { -1, -1, -1 } }, /* index: 332 */
	{ 0x01E6, 0x01E6, 0x01E7, 0x01E6, { -1, -1, -1 } }, /* index: 333 */
	{ 0x01E7, 0x01E6, 0x01E7, 0x01E6, { -1, -1, -1 } }, /* index: 334 */
	{ 0x01E8, 0x01E8, 0x01E9, 0x01E8, { -1, -1, -1 } }, /* index: 335 */
	{ 0x01E9, 0x01E8, 0x01E9, 0x01E8, { -1, -1, -1 } }, /* index: 336 */
	{ 0x01EA, 0x01EA, 0x01EB, 0x01EA, { -1, -1, -1 } }, /* index: 337 */
	{ 0x01EB, 0x01EA, 0x01EB, 0x01EA, { -1, -1, -1 } }, /* index: 338 */
	{ 0x01EC, 0x01EC, 0x01ED, 0x01EC, { -1, -1, -1 } }, /* index: 339 */
	{ 0x01ED, 0x01EC, 0x01ED, 0x01EC, { -1, -1, -1 } }, /* index: 340 */
	{ 0x01EE, 0x01EE, 0x01EF, 0x01EE, { -1, -1, -1 } }, /* index: 341 */
	{ 0x01EF, 0x01EE, 0x01EF, 0x01EE, { -1, -1, -1 } }, /* index: 342 */
	{ 0x01F0, 0x01F0, 0x01F0, 0x01F0, { 18, -1, -1 } }, /* index: 343 */
	{ 0x01F1, 0x01F1, 0x01F3, 0x01F2, { -1, -1, -1 } }, /* index: 344 */
	{ 0x01F2, 0x01F1, 0x01F3, 0x01F2, { -1, -1, -1 } }, /* index: 345 */
	{ 0x01F3, 0x01F1, 0x01F3, 0x01F2, { -1, -1, -1 } }, /* index: 346 */
	{ 0x01F4, 0x01F4, 0x01F5, 0x01F4, { -1, -1, -1 } }, /* index: 347 */
	{ 0x01F5, 0x01F4, 0x01F5, 0x01F4, { -1, -1, -1 } }, /* index: 348 */
	{ 0x01F6, 0x01F6, 0x0195, 0x01F6, { -1, -1, -1 } }, /* index: 349 */
	{ 0x01F7, 0x01F7, 0x01BF, 0x01F7, { -1, -1, -1 } }, /* index: 350 */
	{ 0x01F8, 0x01F8, 0x01F9, 0x01F8, { -1, -1, -1 } }, /* index: 351 */
	{ 0x01F9, 0x01F8, 0x01F9, 0x01F8, { -1, -1, -1 } }, /* index: 352 */
	{ 0x01FA, 0x01FA, 0x01FB, 0x01FA, { -1, -1, -1 } }, /* index: 353 */
	{ 0x01FB, 0x01FA, 0x01FB, 0x01FA, { -1, -1, -1 } }, /* index: 354 */
	{ 0x01FC, 0x01FC, 0x01FD, 0x01FC, { -1, -1, -1 } }, /* index: 355 */
	{ 0x01FD, 0x01FC, 0x01FD, 0x01FC, { -1, -1, -1 } }, /* index: 356 */
	{ 0x01FE, 0x01FE, 0x01FF, 0x01FE, { -1, -1, -1 } }, /* index: 357 */
	{ 0x01FF, 0x01FE, 0x01FF, 0x01FE, { -1, -1, -1 } }, /* index: 358 */
	{ 0x0200, 0x0200, 0x0201, 0x0200, { -1, -1, -1 } }, /* index: 359 */
	{ 0x0201, 0x0200, 0x0201, 0x0200, { -1, -1, -1 } }, /* index: 360 */
	{ 0x0202, 0x0202, 0x0203, 0x0202, { -1, -1, -1 } }, /* index: 361 */
	{ 0x0203, 0x0202, 0x0203, 0x0202, { -1, -1, -1 } }, /* index: 362 */
	{ 0x0204, 0x0204, 0x0205, 0x0204, { -1, -1, -1 } }, /* index: 363 */
	{ 0x0205, 0x0204, 0x0205, 0x0204, { -1, -1, -1 } }, /* index: 364 */
	{ 0x0206, 0x0206, 0x0207, 0x0206, { -1, -1, -1 } }, /* index: 365 */
	{ 0x0207, 0x0206, 0x0207, 0x0206, { -1, -1, -1 } }, /* index: 366 */
	{ 0x0208, 0x0208, 0x0209, 0x0208, { -1, -1, -1 } }, /* index: 367 */
	{ 0x0209, 0x0208, 0x0209, 0x0208, { -1, -1, -1 } }, /* index: 368 */
	{ 0x020A, 0x020A, 0x020B, 0x020A, { -1, -1, -1 } }, /* index: 369 */
	{ 0x020B, 0x020A, 0x020B, 0x020A, { -1, -1, -1 } }, /* index: 370 */
	{ 0x020C, 0x020C, 0x020D, 0x020C, { -1, -1, -1 } }, /* index: 371 */
	{ 0x020D, 0x020C, 0x020D, 0x020C, { -1, -1, -1 } }, /* index: 372 */
	{ 0x020E, 0x020E, 0x020F, 0x020E, { -1, -1, -1 } }, /* index: 373 */
	{ 0x020F, 0x020E, 0x020F, 0x020E, { -1, -1, -1 } }, /* index: 374 */
	{ 0x0210, 0x0210, 0x0211, 0x0210, { -1, -1, -1 } }, /* index: 375 */
	{ 0x0211, 0x0210, 0x0211, 0x0210, { -1, -1, -1 } }, /* index: 376 */
	{ 0x0212, 0x0212, 0x0213, 0x0212, { -1, -1, -1 } }, /* index: 377 */
	{ 0x0213, 0x0212, 0x0213, 0x0212, { -1, -1, -1 } }, /* index: 378 */
	{ 0x0214, 0x0214, 0x0215, 0x0214, { -1, -1, -1 } }, /* index: 379 */
	{ 0x0215, 0x0214, 0x0215, 0x0214, { -1, -1, -1 } }, /* index: 380 */
	{ 0x0216, 0x0216, 0x0217, 0x0216, { -1, -1, -1 } }, /* index: 381 */
	{ 0x0217, 0x0216, 0x0217, 0x0216, { -1, -1, -1 } }, /* index: 382 */
	{ 0x0218, 0x0218, 0x0219, 0x0218, { -1, -1, -1 } }, /* index: 383 */
	{ 0x0219, 0x0218, 0x0219, 0x0218, { -1, -1, -1 } }, /* index: 384 */
	{ 0x021A, 0x021A, 0x021B, 0x021A, { -1, -1, -1 } }, /* index: 385 */
	{ 0x021B, 0x021A, 0x021B, 0x021A, { -1, -1, -1 } }, /* index: 386 */
	{ 0x021C, 0x021C, 0x021D, 0x021C, { -1, -1, -1 } }, /* index: 387 */
	{ 0x021D, 0x021C, 0x021D, 0x021C, { -1, -1, -1 } }, /* index: 388 */
	{ 0x021E, 0x021E, 0x021F, 0x021E, { -1, -1, -1 } }, /* index: 389 */
	{ 0x021F, 0x021E, 0x021F, 0x021E, { -1, -1, -1 } }, /* index: 390 */
	{ 0x0220, 0x0220, 0x019E, 0x0220, { -1, -1, -1 } }, /* index: 391 */
	{ 0x0222, 0x0222, 0x0223, 0x0222, { -1, -1, -1 } }, /* index: 392 */
	{ 0x0223, 0x0222, 0x0223, 0x0222, { -1, -1, -1 } }, /* index: 393 */
	{ 0x0224, 0x0224, 0x0225, 0x0224, { -1, -1, -1 } }, /* index: 394 */
	{ 0x0225, 0x0224, 0x0225, 0x0224, { -1, -1, -1 } }, /* index: 395 */
	{ 0x0226, 0x0226, 0x0227, 0x0226, { -1, -1, -1 } }, /* index: 396 */
	{ 0x0227, 0x0226, 0x0227, 0x0226, { -1, -1, -1 } }, /* index: 397 */
	{ 0x0228, 0x0228, 0x0229, 0x0228, { -1, -1, -1 } }, /* index: 398 */
	{ 0x0229, 0x0228, 0x0229, 0x0228, { -1, -1, -1 } }, /* index: 399 */
	{ 0x022A, 0x022A, 0x022B, 0x022A, { -1, -1, -1 } }, /* index: 400 */
	{ 0x022B, 0x022A, 0x022B, 0x022A, { -1, -1, -1 } }, /* index: 401 */
	{ 0x022C, 0x022C, 0x022D, 0x022C, { -1, -1, -1 } }, /* index: 402 */
	{ 0x022D, 0x022C, 0x022D, 0x022C, { -1, -1, -1 } }, /* index: 403 */
	{ 0x022E, 0x022E, 0x022F, 0x022E, { -1, -1, -1 } }, /* index: 404 */
	{ 0x022F, 0x022E, 0x022F, 0x022E, { -1, -1, -1 } }, /* index: 405 */
	{ 0x0230, 0x0230, 0x0231, 0x0230, { -1, -1, -1 } }, /* index: 406 */
	{ 0x0231, 0x0230, 0x0231, 0x0230, { -1, -1, -1 } }, /* index: 407 */
	{ 0x0232, 0x0232, 0x0233, 0x0232, { -1, -1, -1 } }, /* index: 408 */
	{ 0x0233, 0x0232, 0x0233, 0x0232, { -1, -1, -1 } }, /* index: 409 */
	{ 0x023A, 0x023A, 0x2C65, 0x023A, { -1, -1, -1 } }, /* index: 410 */
	{ 0x023B, 0x023B, 0x023C, 0x023B, { -1, -1, -1 } }, /* index: 411 */
	{ 0x023C, 0x023B, 0x023C, 0x023B, { -1, -1, -1 } }, /* index: 412 */
	{ 0x023D, 0x023D, 0x019A, 0x023D, { -1, -1, -1 } }, /* index: 413 */
	{ 0x023E, 0x023E, 0x2C66, 0x023E, { -1, -1, -1 } }, /* index: 414 */
	{ 0x0241, 0x0241, 0x0242, 0x0241, { -1, -1, -1 } }, /* index: 415 */
	{ 0x0242, 0x0241, 0x0242, 0x0241, { -1, -1, -1 } }, /* index: 416 */
	{ 0x0243, 0x0243, 0x0180, 0x0243, { -1, -1, -1 } }, /* index: 417 */
	{ 0x0244, 0x0244, 0x0289, 0x0244, { -1, -1, -1 } }, /* index: 418 */
	{ 0x0245, 0x0245, 0x028C, 0x0245, { -1, -1, -1 } }, /* index: 419 */
	{ 0x0246, 0x0246, 0x0247, 0x0246, { -1, -1, -1 } }, /* index: 420 */
	{ 0x0247, 0x0246, 0x0247, 0x0246, { -1, -1, -1 } }, /* index: 421 */
	{ 0x0248, 0x0248, 0x0249, 0x0248, { -1, -1, -1 } }, /* index: 422 */
	{ 0x0249, 0x0248, 0x0249, 0x0248, { -1, -1, -1 } }, /* index: 423 */
	{ 0x024A, 0x024A, 0x024B, 0x024A, { -1, -1, -1 } }, /* index: 424 */
	{ 0x024B, 0x024A, 0x024B, 0x024A, { -1, -1, -1 } }, /* index: 425 */
	{ 0x024C, 0x024C, 0x024D, 0x024C, { -1, -1, -1 } }, /* index: 426 */
	{ 0x024D, 0x024C, 0x024D, 0x024C, { -1, -1, -1 } }, /* index: 427 */
	{ 0x024E, 0x024E, 0x024F, 0x024E, { -1, -1, -1 } }, /* index: 428 */
	{ 0x024F, 0x024E, 0x024F, 0x024E, { -1, -1, -1 } }, /* index: 429 */
	{ 0x0250, 0x2C6F, 0x0250, 0x2C6F, { -1, -1, -1 } }, /* index: 430 */
	{ 0x0251, 0x2C6D, 0x0251, 0x2C6D, { -1, -1, -1 } }, /* index: 431 */
	{ 0x0253, 0x0181, 0x0253, 0x0181, { -1, -1, -1 } }, /* index: 432 */
	{ 0x0254, 0x0186, 0x0254, 0x0186, { -1, -1, -1 } }, /* index: 433 */
	{ 0x0256, 0x0189, 0x0256, 0x0189, { -1, -1, -1 } }, /* index: 434 */
	{ 0x0257, 0x018A, 0x0257, 0x018A, { -1, -1, -1 } }, /* index: 435 */
	{ 0x0259, 0x018F, 0x0259, 0x018F, { -1, -1, -1 } }, /* index: 436 */
	{ 0x025B, 0x0190, 0x025B, 0x0190, { -1, -1, -1 } }, /* index: 437 */
	{ 0x0260, 0x0193, 0x0260, 0x0193, { -1, -1, -1 } }, /* index: 438 */
	{ 0x0263, 0x0194, 0x0263, 0x0194, { -1, -1, -1 } }, /* index: 439 */
	{ 0x0268, 0x0197, 0x0268, 0x0197, { -1, -1, -1 } }, /* index: 440 */
	{ 0x0269, 0x0196, 0x0269, 0x0196, { -1, -1, -1 } }, /* index: 441 */
	{ 0x026B, 0x2C62, 0x026B, 0x2C62, { -1, -1, -1 } }, /* index: 442 */
	{ 0x026F, 0x019C, 0x026F, 0x019C, { -1, -1, -1 } }, /* index: 443 */
	{ 0x0271, 0x2C6E, 0x0271, 0x2C6E, { -1, -1, -1 } }, /* index: 444 */
	{ 0x0272, 0x019D, 0x0272, 0x019D, { -1, -1, -1 } }, /* index: 445 */
	{ 0x0275, 0x019F, 0x0275, 0x019F, { -1, -1, -1 } }, /* index: 446 */
	{ 0x027D, 0x2C64, 0x027D, 0x2C64, { -1, -1, -1 } }, /* index: 447 */
	{ 0x0280, 0x01A6, 0x0280, 0x01A6, { -1, -1, -1 } }, /* index: 448 */
	{ 0x0283, 0x01A9, 0x0283, 0x01A9, { -1, -1, -1 } }, /* index: 449 */
	{ 0x0288, 0x01AE, 0x0288, 0x01AE, { -1, -1, -1 } }, /* index: 450 */
	{ 0x0289, 0x0244, 0x0289, 0x0244, { -1, -1, -1 } }, /* index: 451 */
	{ 0x028A, 0x01B1, 0x028A, 0x01B1, { -1, -1, -1 } }, /* index: 452 */
	{ 0x028B, 0x01B2, 0x028B, 0x01B2, { -1, -1, -1 } }, /* index: 453 */
	{ 0x028C, 0x0245, 0x028C, 0x0245, { -1, -1, -1 } }, /* index: 454 */
	{ 0x0292, 0x01B7, 0x0292, 0x01B7, { -1, -1, -1 } }, /* index: 455 */
	{ 0x0307, 0x0307, 0x0307, 0x0307, { 104, 113, 114 } }, /* index: 456 */
	{ 0x0345, 0x0399, 0x0345, 0x0399, { -1, -1, -1 } }, /* index: 457 */
	{ 0x0370, 0x0370, 0x0371, 0x0370, { -1, -1, -1 } }, /* index: 458 */
	{ 0x0371, 0x0370, 0x0371, 0x0370, { -1, -1, -1 } }, /* index: 459 */
	{ 0x0372, 0x0372, 0x0373, 0x0372, { -1, -1, -1 } }, /* index: 460 */
	{ 0x0373, 0x0372, 0x0373, 0x0372, { -1, -1, -1 } }, /* index: 461 */
	{ 0x0376, 0x0376, 0x0377, 0x0376, { -1, -1, -1 } }, /* index: 462 */
	{ 0x0377, 0x0376, 0x0377, 0x0376, { -1, -1, -1 } }, /* index: 463 */
	{ 0x037B, 0x03FD, 0x037B, 0x03FD, { -1, -1, -1 } }, /* index: 464 */
	{ 0x037C, 0x03FE, 0x037C, 0x03FE, { -1, -1, -1 } }, /* index: 465 */
	{ 0x037D, 0x03FF, 0x037D, 0x03FF, { -1, -1, -1 } }, /* index: 466 */
	{ 0x0386, 0x0386, 0x03AC, 0x0386, { -1, -1, -1 } }, /* index: 467 */
	{ 0x0388, 0x0388, 0x03AD, 0x0388, { -1, -1, -1 } }, /* index: 468 */
	{ 0x0389, 0x0389, 0x03AE, 0x0389, { -1, -1, -1 } }, /* index: 469 */
	{ 0x038A, 0x038A, 0x03AF, 0x038A, { -1, -1, -1 } }, /* index: 470 */
	{ 0x038C, 0x038C, 0x03CC, 0x038C, { -1, -1, -1 } }, /* index: 471 */
	{ 0x038E, 0x038E, 0x03CD, 0x038E, { -1, -1, -1 } }, /* index: 472 */
	{ 0x038F, 0x038F, 0x03CE, 0x038F, { -1, -1, -1 } }, /* index: 473 */
	{ 0x0390, 0x0390, 0x0390, 0x0390, { 16, -1, -1 } }, /* index: 474 */
	{ 0x0391, 0x0391, 0x03B1, 0x0391, { -1, -1, -1 } }, /* index: 475 */
	{ 0x0392, 0x0392, 0x03B2, 0x0392, { -1, -1, -1 } }, /* index: 476 */
	{ 0x0393, 0x0393, 0x03B3, 0x0393, { -1, -1, -1 } }, /* index: 477 */
	{ 0x0394, 0x0394, 0x03B4, 0x0394, { -1, -1, -1 } }, /* index: 478 */
	{ 0x0395, 0x0395, 0x03B5, 0x0395, { -1, -1, -1 } }, /* index: 479 */
	{ 0x0396, 0x0396, 0x03B6, 0x0396, { -1, -1, -1 } }, /* index: 480 */
	{ 0x0397, 0x0397, 0x03B7, 0x0397, { -1, -1, -1 } }, /* index: 481 */
	{ 0x0398, 0x0398, 0x03B8, 0x0398, { -1, -1, -1 } }, /* index: 482 */
	{ 0x0399, 0x0399, 0x03B9, 0x0399, { -1, -1, -1 } }, /* index: 483 */
	{ 0x039A, 0x039A, 0x03BA, 0x039A, { -1, -1, -1 } }, /* index: 484 */
	{ 0x039B, 0x039B, 0x03BB, 0x039B, { -1, -1, -1 } }, /* index: 485 */
	{ 0x039C, 0x039C, 0x03BC, 0x039C, { -1, -1, -1 } }, /* index: 486 */
	{ 0x039D, 0x039D, 0x03BD, 0x039D, { -1, -1, -1 } }, /* index: 487 */
	{ 0x039E, 0x039E, 0x03BE, 0x039E, { -1, -1, -1 } }, /* index: 488 */
	{ 0x039F, 0x039F, 0x03BF, 0x039F, { -1, -1, -1 } }, /* index: 489 */
	{ 0x03A0, 0x03A0, 0x03C0, 0x03A0, { -1, -1, -1 } }, /* index: 490 */
	{ 0x03A1, 0x03A1, 0x03C1, 0x03A1, { -1, -1, -1 } }, /* index: 491 */
	{ 0x03A3, 0x03A3, 0x03C3, 0x03A3, { 103, -1, -1 } }, /* index: 492 */
	{ 0x03A4, 0x03A4, 0x03C4, 0x03A4, { -1, -1, -1 } }, /* index: 493 */
	{ 0x03A5, 0x03A5, 0x03C5, 0x03A5, { -1, -1, -1 } }, /* index: 494 */
	{ 0x03A6, 0x03A6, 0x03C6, 0x03A6, { -1, -1, -1 } }, /* index: 495 */
	{ 0x03A7, 0x03A7, 0x03C7, 0x03A7, { -1, -1, -1 } }, /* index: 496 */
	{ 0x03A8, 0x03A8, 0x03C8, 0x03A8, { -1, -1, -1 } }, /* index: 497 */
	{ 0x03A9, 0x03A9, 0x03C9, 0x03A9, { -1, -1, -1 } }, /* index: 498 */
	{ 0x03AA, 0x03AA, 0x03CA, 0x03AA, { -1, -1, -1 } }, /* index: 499 */
	{ 0x03AB, 0x03AB, 0x03CB, 0x03AB, { -1, -1, -1 } }, /* index: 500 */
	{ 0x03AC, 0x0386, 0x03AC, 0x0386, { -1, -1, -1 } }, /* index: 501 */
	{ 0x03AD, 0x0388, 0x03AD, 0x0388, { -1, -1, -1 } }, /* index: 502 */
	{ 0x03AE, 0x0389, 0x03AE, 0x0389, { -1, -1, -1 } }, /* index: 503 */
	{ 0x03AF, 0x038A, 0x03AF, 0x038A, { -1, -1, -1 } }, /* index: 504 */
	{ 0x03B0, 0x03B0, 0x03B0, 0x03B0, { 17, -1, -1 } }, /* index: 505 */
	{ 0x03B1, 0x0391, 0x03B1, 0x0391, { -1, -1, -1 } }, /* index: 506 */
	{ 0x03B2, 0x0392, 0x03B2, 0x0392, { -1, -1, -1 } }, /* index: 507 */
	{ 0x03B3, 0x0393, 0x03B3, 0x0393, { -1, -1, -1 } }, /* index: 508 */
	{ 0x03B4, 0x0394, 0x03B4, 0x0394, { -1, -1, -1 } }, /* index: 509 */
	{ 0x03B5, 0x0395, 0x03B5, 0x0395, { -1, -1, -1 } }, /* index: 510 */
	{ 0x03B6, 0x0396, 0x03B6, 0x0396, { -1, -1, -1 } }, /* index: 511 */
	{ 0x03B7, 0x0397, 0x03B7, 0x0397, { -1, -1, -1 } }, /* index: 512 */
	{ 0x03B8, 0x0398, 0x03B8, 0x0398, { -1, -1, -1 } }, /* index: 513 */
	{ 0x03B9, 0x0399, 0x03B9, 0x0399, { -1, -1, -1 } }, /* index: 514 */
	{ 0x03BA, 0x039A, 0x03BA, 0x039A, { -1, -1, -1 } }, /* index: 515 */
	{ 0x03BB, 0x039B, 0x03BB, 0x039B, { -1, -1, -1 } }, /* index: 516 */
	{ 0x03BC, 0x039C, 0x03BC, 0x039C, { -1, -1, -1 } }, /* index: 517 */
	{ 0x03BD, 0x039D, 0x03BD, 0x039D, { -1, -1, -1 } }, /* index: 518 */
	{ 0x03BE, 0x039E, 0x03BE, 0x039E, { -1, -1, -1 } }, /* index: 519 */
	{ 0x03BF, 0x039F, 0x03BF, 0x039F, { -1, -1, -1 } }, /* index: 520 */
	{ 0x03C0, 0x03A0, 0x03C0, 0x03A0, { -1, -1, -1 } }, /* index: 521 */
	{ 0x03C1, 0x03A1, 0x03C1, 0x03A1, { -1, -1, -1 } }, /* index: 522 */
	{ 0x03C2, 0x03A3, 0x03C2, 0x03A3, { -1, -1, -1 } }, /* index: 523 */
	{ 0x03C3, 0x03A3, 0x03C3, 0x03A3, { -1, -1, -1 } }, /* index: 524 */
	{ 0x03C4, 0x03A4, 0x03C4, 0x03A4, { -1, -1, -1 } }, /* index: 525 */
	{ 0x03C5, 0x03A5, 0x03C5, 0x03A5, { -1, -1, -1 } }, /* index: 526 */
	{ 0x03C6, 0x03A6, 0x03C6, 0x03A6, { -1, -1, -1 } }, /* index: 527 */
	{ 0x03C7, 0x03A7, 0x03C7, 0x03A7, { -1, -1, -1 } }, /* index: 528 */
	{ 0x03C8, 0x03A8, 0x03C8, 0x03A8, { -1, -1, -1 } }, /* index: 529 */
	{ 0x03C9, 0x03A9, 0x03C9, 0x03A9, { -1, -1, -1 } }, /* index: 530 */
	{ 0x03CA, 0x03AA, 0x03CA, 0x03AA, { -1, -1, -1 } }, /* index: 531 */
	{ 0x03CB, 0x03AB, 0x03CB, 0x03AB, { -1, -1, -1 } }, /* index: 532 */
	{ 0x03CC, 0x038C, 0x03CC, 0x038C, { -1, -1, -1 } }, /* index: 533 */
	{ 0x03CD, 0x038E, 0x03CD, 0x038E, { -1, -1, -1 } }, /* index: 534 */
	{ 0x03CE, 0x038F, 0x03CE, 0x038F, { -1, -1, -1 } }, /* index: 535 */
	{ 0x03CF, 0x03CF, 0x03D7, 0x03CF, { -1, -1, -1 } }, /* index: 536 */
	{ 0x03D0, 0x0392, 0x03D0, 0x0392, { -1, -1, -1 } }, /* index: 537 */
	{ 0x03D1, 0x0398, 0x03D1, 0x0398, { -1, -1, -1 } }, /* index: 538 */
	{ 0x03D5, 0x03A6, 0x03D5, 0x03A6, { -1, -1, -1 } }, /* index: 539 */
	{ 0x03D6, 0x03A0, 0x03D6, 0x03A0, { -1, -1, -1 } }, /* index: 540 */
	{ 0x03D7, 0x03CF, 0x03D7, 0x03CF, { -1, -1, -1 } }, /* index: 541 */
	{ 0x03D8, 0x03D8, 0x03D9, 0x03D8, { -1, -1, -1 } }, /* index: 542 */
	{ 0x03D9, 0x03D8, 0x03D9, 0x03D8, { -1, -1, -1 } }, /* index: 543 */
	{ 0x03DA, 0x03DA, 0x03DB, 0x03DA, { -1, -1, -1 } }, /* index: 544 */
	{ 0x03DB, 0x03DA, 0x03DB, 0x03DA, { -1, -1, -1 } }, /* index: 545 */
	{ 0x03DC, 0x03DC, 0x03DD, 0x03DC, { -1, -1, -1 } }, /* index: 546 */
	{ 0x03DD, 0x03DC, 0x03DD, 0x03DC, { -1, -1, -1 } }, /* index: 547 */
	{ 0x03DE, 0x03DE, 0x03DF, 0x03DE, { -1, -1, -1 } }, /* index: 548 */
	{ 0x03DF, 0x03DE, 0x03DF, 0x03DE, { -1, -1, -1 } }, /* index: 549 */
	{ 0x03E0, 0x03E0, 0x03E1, 0x03E0, { -1, -1, -1 } }, /* index: 550 */
	{ 0x03E1, 0x03E0, 0x03E1, 0x03E0, { -1, -1, -1 } }, /* index: 551 */
	{ 0x03E2, 0x03E2, 0x03E3, 0x03E2, { -1, -1, -1 } }, /* index: 552 */
	{ 0x03E3, 0x03E2, 0x03E3, 0x03E2, { -1, -1, -1 } }, /* index: 553 */
	{ 0x03E4, 0x03E4, 0x03E5, 0x03E4, { -1, -1, -1 } }, /* index: 554 */
	{ 0x03E5, 0x03E4, 0x03E5, 0x03E4, { -1, -1, -1 } }, /* index: 555 */
	{ 0x03E6, 0x03E6, 0x03E7, 0x03E6, { -1, -1, -1 } }, /* index: 556 */
	{ 0x03E7, 0x03E6, 0x03E7, 0x03E6, { -1, -1, -1 } }, /* index: 557 */
	{ 0x03E8, 0x03E8, 0x03E9, 0x03E8, { -1, -1, -1 } }, /* index: 558 */
	{ 0x03E9, 0x03E8, 0x03E9, 0x03E8, { -1, -1, -1 } }, /* index: 559 */
	{ 0x03EA, 0x03EA, 0x03EB, 0x03EA, { -1, -1, -1 } }, /* index: 560 */
	{ 0x03EB, 0x03EA, 0x03EB, 0x03EA, { -1, -1, -1 } }, /* index: 561 */
	{ 0x03EC, 0x03EC, 0x03ED, 0x03EC, { -1, -1, -1 } }, /* index: 562 */
	{ 0x03ED, 0x03EC, 0x03ED, 0x03EC, { -1, -1, -1 } }, /* index: 563 */
	{ 0x03EE, 0x03EE, 0x03EF, 0x03EE, { -1, -1, -1 } }, /* index: 564 */
	{ 0x03EF, 0x03EE, 0x03EF, 0x03EE, { -1, -1, -1 } }, /* index: 565 */
	{ 0x03F0, 0x039A, 0x03F0, 0x039A, { -1, -1, -1 } }, /* index: 566 */
	{ 0x03F1, 0x03A1, 0x03F1, 0x03A1, { -1, -1, -1 } }, /* index: 567 */
	{ 0x03F2, 0x03F9, 0x03F2, 0x03F9, { -1, -1, -1 } }, /* index: 568 */
	{ 0x03F4, 0x03F4, 0x03B8, 0x03F4, { -1, -1, -1 } }, /* index: 569 */
	{ 0x03F5, 0x0395, 0x03F5, 0x0395, { -1, -1, -1 } }, /* index: 570 */
	{ 0x03F7, 0x03F7, 0x03F8, 0x03F7, { -1, -1, -1 } }, /* index: 571 */
	{ 0x03F8, 0x03F7, 0x03F8, 0x03F7, { -1, -1, -1 } }, /* index: 572 */
	{ 0x03F9, 0x03F9, 0x03F2, 0x03F9, { -1, -1, -1 } }, /* index: 573 */
	{ 0x03FA, 0x03FA, 0x03FB, 0x03FA, { -1, -1, -1 } }, /* index: 574 */
	{ 0x03FB, 0x03FA, 0x03FB, 0x03FA, { -1, -1, -1 } }, /* index: 575 */
	{ 0x03FD, 0x03FD, 0x037B, 0x03FD, { -1, -1, -1 } }, /* index: 576 */
	{ 0x03FE, 0x03FE, 0x037C, 0x03FE, { -1, -1, -1 } }, /* index: 577 */
	{ 0x03FF, 0x03FF, 0x037D, 0x03FF, { -1, -1, -1 } }, /* index: 578 */
	{ 0x0400, 0x0400, 0x0450, 0x0400, { -1, -1, -1 } }, /* index: 579 */
	{ 0x0401, 0x0401, 0x0451, 0x0401, { -1, -1, -1 } }, /* index: 580 */
	{ 0x0402, 0x0402, 0x0452, 0x0402, { -1, -1, -1 } }, /* index: 581 */
	{ 0x0403, 0x0403, 0x0453, 0x0403, { -1, -1, -1 } }, /* index: 582 */
	{ 0x0404, 0x0404, 0x0454, 0x0404, { -1, -1, -1 } }, /* index: 583 */
	{ 0x0405, 0x0405, 0x0455, 0x0405, { -1, -1, -1 } }, /* index: 584 */
	{ 0x0406, 0x0406, 0x0456, 0x0406, { -1, -1, -1 } }, /* index: 585 */
	{ 0x0407, 0x0407, 0x0457, 0x0407, { -1, -1, -1 } }, /* index: 586 */
	{ 0x0408, 0x0408, 0x0458, 0x0408, { -1, -1, -1 } }, /* index: 587 */
	{ 0x0409, 0x0409, 0x0459, 0x0409, { -1, -1, -1 } }, /* index: 588 */
	{ 0x040A, 0x040A, 0x045A, 0x040A, { -1, -1, -1 } }, /* index: 589 */
	{ 0x040B, 0x040B, 0x045B, 0x040B, { -1, -1, -1 } }, /* index: 590 */
	{ 0x040C, 0x040C, 0x045C, 0x040C, { -1, -1, -1 } }, /* index: 591 */
	{ 0x040D, 0x040D, 0x045D, 0x040D, { -1, -1, -1 } }, /* index: 592 */
	{ 0x040E, 0x040E, 0x045E, 0x040E, { -1, -1, -1 } }, /* index: 593 */
	{ 0x040F, 0x040F, 0x045F, 0x040F, { -1, -1, -1 } }, /* index: 594 */
	{ 0x0410, 0x0410, 0x0430, 0x0410, { -1, -1, -1 } }, /* index: 595 */
	{ 0x0411, 0x0411, 0x0431, 0x0411, { -1, -1, -1 } }, /* index: 596 */
	{ 0x0412, 0x0412, 0x0432, 0x0412, { -1, -1, -1 } }, /* index: 597 */
	{ 0x0413, 0x0413, 0x0433, 0x0413, { -1, -1, -1 } }, /* index: 598 */
	{ 0x0414, 0x0414, 0x0434, 0x0414, { -1, -1, -1 } }, /* index: 599 */
	{ 0x0415, 0x0415, 0x0435, 0x0415, { -1, -1, -1 } }, /* index: 600 */
	{ 0x0416, 0x0416, 0x0436, 0x0416, { -1, -1, -1 } }, /* index: 601 */
	{ 0x0417, 0x0417, 0x0437, 0x0417, { -1, -1, -1 } }, /* index: 602 */
	{ 0x0418, 0x0418, 0x0438, 0x0418, { -1, -1, -1 } }, /* index: 603 */
	{ 0x0419, 0x0419, 0x0439, 0x0419, { -1, -1, -1 } }, /* index: 604 */
	{ 0x041A, 0x041A, 0x043A, 0x041A, { -1, -1, -1 } }, /* index: 605 */
	{ 0x041B, 0x041B, 0x043B, 0x041B, { -1, -1, -1 } }, /* index: 606 */
	{ 0x041C, 0x041C, 0x043C, 0x041C, { -1, -1, -1 } }, /* index: 607 */
	{ 0x041D, 0x041D, 0x043D, 0x041D, { -1, -1, -1 } }, /* index: 608 */
	{ 0x041E, 0x041E, 0x043E, 0x041E, { -1, -1, -1 } }, /* index: 609 */
	{ 0x041F, 0x041F, 0x043F, 0x041F, { -1, -1, -1 } }, /* index: 610 */
	{ 0x0420, 0x0420, 0x0440, 0x0420, { -1, -1, -1 } }, /* index: 611 */
	{ 0x0421, 0x0421, 0x0441, 0x0421, { -1, -1, -1 } }, /* index: 612 */
	{ 0x0422, 0x0422, 0x0442, 0x0422, { -1, -1, -1 } }, /* index: 613 */
	{ 0x0423, 0x0423, 0x0443, 0x0423, { -1, -1, -1 } }, /* index: 614 */
	{ 0x0424, 0x0424, 0x0444, 0x0424, { -1, -1, -1 } }, /* index: 615 */
	{ 0x0425, 0x0425, 0x0445, 0x0425, { -1, -1, -1 } }, /* index: 616 */
	{ 0x0426, 0x0426, 0x0446, 0x0426, { -1, -1, -1 } }, /* index: 617 */
	{ 0x0427, 0x0427, 0x0447, 0x0427, { -1, -1, -1 } }, /* index: 618 */
	{ 0x0428, 0x0428, 0x0448, 0x0428, { -1, -1, -1 } }, /* index: 619 */
	{ 0x0429, 0x0429, 0x0449, 0x0429, { -1, -1, -1 } }, /* index: 620 */
	{ 0x042A, 0x042A, 0x044A, 0x042A, { -1, -1, -1 } }, /* index: 621 */
	{ 0x042B, 0x042B, 0x044B, 0x042B, { -1, -1, -1 } }, /* index: 622 */
	{ 0x042C, 0x042C, 0x044C, 0x042C, { -1, -1, -1 } }, /* index: 623 */
	{ 0x042D, 0x042D, 0x044D, 0x042D, { -1, -1, -1 } }, /* index: 624 */
	{ 0x042E, 0x042E, 0x044E, 0x042E, { -1, -1, -1 } }, /* index: 625 */
	{ 0x042F, 0x042F, 0x044F, 0x042F, { -1, -1, -1 } }, /* index: 626 */
	{ 0x0430, 0x0410, 0x0430, 0x0410, { -1, -1, -1 } }, /* index: 627 */
	{ 0x0431, 0x0411, 0x0431, 0x0411, { -1, -1, -1 } }, /* index: 628 */
	{ 0x0432, 0x0412, 0x0432, 0x0412, { -1, -1, -1 } }, /* index: 629 */
	{ 0x0433, 0x0413, 0x0433, 0x0413, { -1, -1, -1 } }, /* index: 630 */
	{ 0x0434, 0x0414, 0x0434, 0x0414, { -1, -1, -1 } }, /* index: 631 */
	{ 0x0435, 0x0415, 0x0435, 0x0415, { -1, -1, -1 } }, /* index: 632 */
	{ 0x0436, 0x0416, 0x0436, 0x0416, { -1, -1, -1 } }, /* index: 633 */
	{ 0x0437, 0x0417, 0x0437, 0x0417, { -1, -1, -1 } }, /* index: 634 */
	{ 0x0438, 0x0418, 0x0438, 0x0418, { -1, -1, -1 } }, /* index: 635 */
	{ 0x0439, 0x0419, 0x0439, 0x0419, { -1, -1, -1 } }, /* index: 636 */
	{ 0x043A, 0x041A, 0x043A, 0x041A, { -1, -1, -1 } }, /* index: 637 */
	{ 0x043B, 0x041B, 0x043B, 0x041B, { -1, -1, -1 } }, /* index: 638 */
	{ 0x043C, 0x041C, 0x043C, 0x041C, { -1, -1, -1 } }, /* index: 639 */
	{ 0x043D, 0x041D, 0x043D, 0x041D, { -1, -1, -1 } }, /* index: 640 */
	{ 0x043E, 0x041E, 0x043E, 0x041E, { -1, -1, -1 } }, /* index: 641 */
	{ 0x043F, 0x041F, 0x043F, 0x041F, { -1, -1, -1 } }, /* index: 642 */
	{ 0x0440, 0x0420, 0x0440, 0x0420, { -1, -1, -1 } }, /* index: 643 */
	{ 0x0441, 0x0421, 0x0441, 0x0421, { -1, -1, -1 } }, /* index: 644 */
	{ 0x0442, 0x0422, 0x0442, 0x0422, { -1, -1, -1 } }, /* index: 645 */
	{ 0x0443, 0x0423, 0x0443, 0x0423, { -1, -1, -1 } }, /* index: 646 */
	{ 0x0444, 0x0424, 0x0444, 0x0424, { -1, -1, -1 } }, /* index: 647 */
	{ 0x0445, 0x0425, 0x0445, 0x0425, { -1, -1, -1 } }, /* index: 648 */
	{ 0x0446, 0x0426, 0x0446, 0x0426, { -1, -1, -1 } }, /* index: 649 */
	{ 0x0447, 0x0427, 0x0447, 0x0427, { -1, -1, -1 } }, /* index: 650 */
	{ 0x0448, 0x0428, 0x0448, 0x0428, { -1, -1, -1 } }, /* index: 651 */
	{ 0x0449, 0x0429, 0x0449, 0x0429, { -1, -1, -1 } }, /* index: 652 */
	{ 0x044A, 0x042A, 0x044A, 0x042A, { -1, -1, -1 } }, /* index: 653 */
	{ 0x044B, 0x042B, 0x044B, 0x042B, { -1, -1, -1 } }, /* index: 654 */
	{ 0x044C, 0x042C, 0x044C, 0x042C, { -1, -1, -1 } }, /* index: 655 */
	{ 0x044D, 0x042D, 0x044D, 0x042D, { -1, -1, -1 } }, /* index: 656 */
	{ 0x044E, 0x042E, 0x044E, 0x042E, { -1, -1, -1 } }, /* index: 657 */
	{ 0x044F, 0x042F, 0x044F, 0x042F, { -1, -1, -1 } }, /* index: 658 */
	{ 0x0450, 0x0400, 0x0450, 0x0400, { -1, -1, -1 } }, /* index: 659 */
	{ 0x0451, 0x0401, 0x0451, 0x0401, { -1, -1, -1 } }, /* index: 660 */
	{ 0x0452, 0x0402, 0x0452, 0x0402, { -1, -1, -1 } }, /* index: 661 */
	{ 0x0453, 0x0403, 0x0453, 0x0403, { -1, -1, -1 } }, /* index: 662 */
	{ 0x0454, 0x0404, 0x0454, 0x0404, { -1, -1, -1 } }, /* index: 663 */
	{ 0x0455, 0x0405, 0x0455, 0x0405, { -1, -1, -1 } }, /* index: 664 */
	{ 0x0456, 0x0406, 0x0456, 0x0406, { -1, -1, -1 } }, /* index: 665 */
	{ 0x0457, 0x0407, 0x0457, 0x0407, { -1, -1, -1 } }, /* index: 666 */
	{ 0x0458, 0x0408, 0x0458, 0x0408, { -1, -1, -1 } }, /* index: 667 */
	{ 0x0459, 0x0409, 0x0459, 0x0409, { -1, -1, -1 } }, /* index: 668 */
	{ 0x045A, 0x040A, 0x045A, 0x040A, { -1, -1, -1 } }, /* index: 669 */
	{ 0x045B, 0x040B, 0x045B, 0x040B, { -1, -1, -1 } }, /* index: 670 */
	{ 0x045C, 0x040C, 0x045C, 0x040C, { -1, -1, -1 } }, /* index: 671 */
	{ 0x045D, 0x040D, 0x045D, 0x040D, { -1, -1, -1 } }, /* index: 672 */
	{ 0x045E, 0x040E, 0x045E, 0x040E, { -1, -1, -1 } }, /* index: 673 */
	{ 0x045F, 0x040F, 0x045F, 0x040F, { -1, -1, -1 } }, /* index: 674 */
	{ 0x0460, 0x0460, 0x0461, 0x0460, { -1, -1, -1 } }, /* index: 675 */
	{ 0x0461, 0x0460, 0x0461, 0x0460, { -1, -1, -1 } }, /* index: 676 */
	{ 0x0462, 0x0462, 0x0463, 0x0462, { -1, -1, -1 } }, /* index: 677 */
	{ 0x0463, 0x0462, 0x0463, 0x0462, { -1, -1, -1 } }, /* index: 678 */
	{ 0x0464, 0x0464, 0x0465, 0x0464, { -1, -1, -1 } }, /* index: 679 */
	{ 0x0465, 0x0464, 0x0465, 0x0464, { -1, -1, -1 } }, /* index: 680 */
	{ 0x0466, 0x0466, 0x0467, 0x0466, { -1, -1, -1 } }, /* index: 681 */
	{ 0x0467, 0x0466, 0x0467, 0x0466, { -1, -1, -1 } }, /* index: 682 */
	{ 0x0468, 0x0468, 0x0469, 0x0468, { -1, -1, -1 } }, /* index: 683 */
	{ 0x0469, 0x0468, 0x0469, 0x0468, { -1, -1, -1 } }, /* index: 684 */
	{ 0x046A, 0x046A, 0x046B, 0x046A, { -1, -1, -1 } }, /* index: 685 */
	{ 0x046B, 0x046A, 0x046B, 0x046A, { -1, -1, -1 } }, /* index: 686 */
	{ 0x046C, 0x046C, 0x046D, 0x046C, { -1, -1, -1 } }, /* index: 687 */
	{ 0x046D, 0x046C, 0x046D, 0x046C, { -1, -1, -1 } }, /* index: 688 */
	{ 0x046E, 0x046E, 0x046F, 0x046E, { -1, -1, -1 } }, /* index: 689 */
	{ 0x046F, 0x046E, 0x046F, 0x046E, { -1, -1, -1 } }, /* index: 690 */
	{ 0x0470, 0x0470, 0x0471, 0x0470, { -1, -1, -1 } }, /* index: 691 */
	{ 0x0471, 0x0470, 0x0471, 0x0470, { -1, -1, -1 } }, /* index: 692 */
	{ 0x0472, 0x0472, 0x0473, 0x0472, { -1, -1, -1 } }, /* index: 693 */
	{ 0x0473, 0x0472, 0x0473, 0x0472, { -1, -1, -1 } }, /* index: 694 */
	{ 0x0474, 0x0474, 0x0475, 0x0474, { -1, -1, -1 } }, /* index: 695 */
	{ 0x0475, 0x0474, 0x0475, 0x0474, { -1, -1, -1 } }, /* index: 696 */
	{ 0x0476, 0x0476, 0x0477, 0x0476, { -1, -1, -1 } }, /* index: 697 */
	{ 0x0477, 0x0476, 0x0477, 0x0476, { -1, -1, -1 } }, /* index: 698 */
	{ 0x0478, 0x0478, 0x0479, 0x0478, { -1, -1, -1 } }, /* index: 699 */
	{ 0x0479, 0x0478, 0x0479, 0x0478, { -1, -1, -1 } }, /* index: 700 */
	{ 0x047A, 0x047A, 0x047B, 0x047A, { -1, -1, -1 } }, /* index: 701 */
	{ 0x047B, 0x047A, 0x047B, 0x047A, { -1, -1, -1 } }, /* index: 702 */
	{ 0x047C, 0x047C, 0x047D, 0x047C, { -1, -1, -1 } }, /* index: 703 */
	{ 0x047D, 0x047C, 0x047D, 0x047C, { -1, -1, -1 } }, /* index: 704 */
	{ 0x047E, 0x047E, 0x047F, 0x047E, { -1, -1, -1 } }, /* index: 705 */
	{ 0x047F, 0x047E, 0x047F, 0x047E, { -1, -1, -1 } }, /* index: 706 */
	{ 0x0480, 0x0480, 0x0481, 0x0480, { -1, -1, -1 } }, /* index: 707 */
	{ 0x0481, 0x0480, 0x0481, 0x0480, { -1, -1, -1 } }, /* index: 708 */
	{ 0x048A, 0x048A, 0x048B, 0x048A, { -1, -1, -1 } }, /* index: 709 */
	{ 0x048B, 0x048A, 0x048B, 0x048A, { -1, -1, -1 } }, /* index: 710 */
	{ 0x048C, 0x048C, 0x048D, 0x048C, { -1, -1, -1 } }, /* index: 711 */
	{ 0x048D, 0x048C, 0x048D, 0x048C, { -1, -1, -1 } }, /* index: 712 */
	{ 0x048E, 0x048E, 0x048F, 0x048E, { -1, -1, -1 } }, /* index: 713 */
	{ 0x048F, 0x048E, 0x048F, 0x048E, { -1, -1, -1 } }, /* index: 714 */
	{ 0x0490, 0x0490, 0x0491, 0x0490, { -1, -1, -1 } }, /* index: 715 */
	{ 0x0491, 0x0490, 0x0491, 0x0490, { -1, -1, -1 } }, /* index: 716 */
	{ 0x0492, 0x0492, 0x0493, 0x0492, { -1, -1, -1 } }, /* index: 717 */
	{ 0x0493, 0x0492, 0x0493, 0x0492, { -1, -1, -1 } }, /* index: 718 */
	{ 0x0494, 0x0494, 0x0495, 0x0494, { -1, -1, -1 } }, /* index: 719 */
	{ 0x0495, 0x0494, 0x0495, 0x0494, { -1, -1, -1 } }, /* index: 720 */
	{ 0x0496, 0x0496, 0x0497, 0x0496, { -1, -1, -1 } }, /* index: 721 */
	{ 0x0497, 0x0496, 0x0497, 0x0496, { -1, -1, -1 } }, /* index: 722 */
	{ 0x0498, 0x0498, 0x0499, 0x0498, { -1, -1, -1 } }, /* index: 723 */
	{ 0x0499, 0x0498, 0x0499, 0x0498, { -1, -1, -1 } }, /* index: 724 */
	{ 0x049A, 0x049A, 0x049B, 0x049A, { -1, -1, -1 } }, /* index: 725 */
	{ 0x049B, 0x049A, 0x049B, 0x049A, { -1, -1, -1 } }, /* index: 726 */
	{ 0x049C, 0x049C, 0x049D, 0x049C, { -1, -1, -1 } }, /* index: 727 */
	{ 0x049D, 0x049C, 0x049D, 0x049C, { -1, -1, -1 } }, /* index: 728 */
	{ 0x049E, 0x049E, 0x049F, 0x049E, { -1, -1, -1 } }, /* index: 729 */
	{ 0x049F, 0x049E, 0x049F, 0x049E, { -1, -1, -1 } }, /* index: 730 */
	{ 0x04A0, 0x04A0, 0x04A1, 0x04A0, { -1, -1, -1 } }, /* index: 731 */
	{ 0x04A1, 0x04A0, 0x04A1, 0x04A0, { -1, -1, -1 } }, /* index: 732 */
	{ 0x04A2, 0x04A2, 0x04A3, 0x04A2, { -1, -1, -1 } }, /* index: 733 */
	{ 0x04A3, 0x04A2, 0x04A3, 0x04A2, { -1, -1, -1 } }, /* index: 734 */
	{ 0x04A4, 0x04A4, 0x04A5, 0x04A4, { -1, -1, -1 } }, /* index: 735 */
	{ 0x04A5, 0x04A4, 0x04A5, 0x04A4, { -1, -1, -1 } }, /* index: 736 */
	{ 0x04A6, 0x04A6, 0x04A7, 0x04A6, { -1, -1, -1 } }, /* index: 737 */
	{ 0x04A7, 0x04A6, 0x04A7, 0x04A6, { -1, -1, -1 } }, /* index: 738 */
	{ 0x04A8, 0x04A8, 0x04A9, 0x04A8, { -1, -1, -1 } }, /* index: 739 */
	{ 0x04A9, 0x04A8, 0x04A9, 0x04A8, { -1, -1, -1 } }, /* index: 740 */
	{ 0x04AA, 0x04AA, 0x04AB, 0x04AA, { -1, -1, -1 } }, /* index: 741 */
	{ 0x04AB, 0x04AA, 0x04AB, 0x04AA, { -1, -1, -1 } }, /* index: 742 */
	{ 0x04AC, 0x04AC, 0x04AD, 0x04AC, { -1, -1, -1 } }, /* index: 743 */
	{ 0x04AD, 0x04AC, 0x04AD, 0x04AC, { -1, -1, -1 } }, /* index: 744 */
	{ 0x04AE, 0x04AE, 0x04AF, 0x04AE, { -1, -1, -1 } }, /* index: 745 */
	{ 0x04AF, 0x04AE, 0x04AF, 0x04AE, { -1, -1, -1 } }, /* index: 746 */
	{ 0x04B0, 0x04B0, 0x04B1, 0x04B0, { -1, -1, -1 } }, /* index: 747 */
	{ 0x04B1, 0x04B0, 0x04B1, 0x04B0, { -1, -1, -1 } }, /* index: 748 */
	{ 0x04B2, 0x04B2, 0x04B3, 0x04B2, { -1, -1, -1 } }, /* index: 749 */
	{ 0x04B3, 0x04B2, 0x04B3, 0x04B2, { -1, -1, -1 } }, /* index: 750 */
	{ 0x04B4, 0x04B4, 0x04B5, 0x04B4, { -1, -1, -1 } }, /* index: 751 */
	{ 0x04B5, 0x04B4, 0x04B5, 0x04B4, { -1, -1, -1 } }, /* index: 752 */
	{ 0x04B6, 0x04B6, 0x04B7, 0x04B6, { -1, -1, -1 } }, /* index: 753 */
	{ 0x04B7, 0x04B6, 0x04B7, 0x04B6, { -1, -1, -1 } }, /* index: 754 */
	{ 0x04B8, 0x04B8, 0x04B9, 0x04B8, { -1, -1, -1 } }, /* index: 755 */
	{ 0x04B9, 0x04B8, 0x04B9, 0x04B8, { -1, -1, -1 } }, /* index: 756 */
	{ 0x04BA, 0x04BA, 0x04BB, 0x04BA, { -1, -1, -1 } }, /* index: 757 */
	{ 0x04BB, 0x04BA, 0x04BB, 0x04BA, { -1, -1, -1 } }, /* index: 758 */
	{ 0x04BC, 0x04BC, 0x04BD, 0x04BC, { -1, -1, -1 } }, /* index: 759 */
	{ 0x04BD, 0x04BC, 0x04BD, 0x04BC, { -1, -1, -1 } }, /* index: 760 */
	{ 0x04BE, 0x04BE, 0x04BF, 0x04BE, { -1, -1, -1 } }, /* index: 761 */
	{ 0x04BF, 0x04BE, 0x04BF, 0x04BE, { -1, -1, -1 } }, /* index: 762 */
	{ 0x04C0, 0x04C0, 0x04CF, 0x04C0, { -1, -1, -1 } }, /* index: 763 */
	{ 0x04C1, 0x04C1, 0x04C2, 0x04C1, { -1, -1, -1 } }, /* index: 764 */
	{ 0x04C2, 0x04C1, 0x04C2, 0x04C1, { -1, -1, -1 } }, /* index: 765 */
	{ 0x04C3, 0x04C3, 0x04C4, 0x04C3, { -1, -1, -1 } }, /* index: 766 */
	{ 0x04C4, 0x04C3, 0x04C4, 0x04C3, { -1, -1, -1 } }, /* index: 767 */
	{ 0x04C5, 0x04C5, 0x04C6, 0x04C5, { -1, -1, -1 } }, /* index: 768 */
	{ 0x04C6, 0x04C5, 0x04C6, 0x04C5, { -1, -1, -1 } }, /* index: 769 */
	{ 0x04C7, 0x04C7, 0x04C8, 0x04C7, { -1, -1, -1 } }, /* index: 770 */
	{ 0x04C8, 0x04C7, 0x04C8, 0x04C7, { -1, -1, -1 } }, /* index: 771 */
	{ 0x04C9, 0x04C9, 0x04CA, 0x04C9, { -1, -1, -1 } }, /* index: 772 */
	{ 0x04CA, 0x04C9, 0x04CA, 0x04C9, { -1, -1, -1 } }, /* index: 773 */
	{ 0x04CB, 0x04CB, 0x04CC, 0x04CB, { -1, -1, -1 } }, /* index: 774 */
	{ 0x04CC, 0x04CB, 0x04CC, 0x04CB, { -1, -1, -1 } }, /* index: 775 */
	{ 0x04CD, 0x04CD, 0x04CE, 0x04CD, { -1, -1, -1 } }, /* index: 776 */
	{ 0x04CE, 0x04CD, 0x04CE, 0x04CD, { -1, -1, -1 } }, /* index: 777 */
	{ 0x04CF, 0x04C0, 0x04CF, 0x04C0, { -1, -1, -1 } }, /* index: 778 */
	{ 0x04D0, 0x04D0, 0x04D1, 0x04D0, { -1, -1, -1 } }, /* index: 779 */
	{ 0x04D1, 0x04D0, 0x04D1, 0x04D0, { -1, -1, -1 } }, /* index: 780 */
	{ 0x04D2, 0x04D2, 0x04D3, 0x04D2, { -1, -1, -1 } }, /* index: 781 */
	{ 0x04D3, 0x04D2, 0x04D3, 0x04D2, { -1, -1, -1 } }, /* index: 782 */
	{ 0x04D4, 0x04D4, 0x04D5, 0x04D4, { -1, -1, -1 } }, /* index: 783 */
	{ 0x04D5, 0x04D4, 0x04D5, 0x04D4, { -1, -1, -1 } }, /* index: 784 */
	{ 0x04D6, 0x04D6, 0x04D7, 0x04D6, { -1, -1, -1 } }, /* index: 785 */
	{ 0x04D7, 0x04D6, 0x04D7, 0x04D6, { -1, -1, -1 } }, /* index: 786 */
	{ 0x04D8, 0x04D8, 0x04D9, 0x04D8, { -1, -1, -1 } }, /* index: 787 */
	{ 0x04D9, 0x04D8, 0x04D9, 0x04D8, { -1, -1, -1 } }, /* index: 788 */
	{ 0x04DA, 0x04DA, 0x04DB, 0x04DA, { -1, -1, -1 } }, /* index: 789 */
	{ 0x04DB, 0x04DA, 0x04DB, 0x04DA, { -1, -1, -1 } }, /* index: 790 */
	{ 0x04DC, 0x04DC, 0x04DD, 0x04DC, { -1, -1, -1 } }, /* index: 791 */
	{ 0x04DD, 0x04DC, 0x04DD, 0x04DC, { -1, -1, -1 } }, /* index: 792 */
	{ 0x04DE, 0x04DE, 0x04DF, 0x04DE, { -1, -1, -1 } }, /* index: 793 */
	{ 0x04DF, 0x04DE, 0x04DF, 0x04DE, { -1, -1, -1 } }, /* index: 794 */
	{ 0x04E0, 0x04E0, 0x04E1, 0x04E0, { -1, -1, -1 } }, /* index: 795 */
	{ 0x04E1, 0x04E0, 0x04E1, 0x04E0, { -1, -1, -1 } }, /* index: 796 */
	{ 0x04E2, 0x04E2, 0x04E3, 0x04E2, { -1, -1, -1 } }, /* index: 797 */
	{ 0x04E3, 0x04E2, 0x04E3, 0x04E2, { -1, -1, -1 } }, /* index: 798 */
	{ 0x04E4, 0x04E4, 0x04E5, 0x04E4, { -1, -1, -1 } }, /* index: 799 */
	{ 0x04E5, 0x04E4, 0x04E5, 0x04E4, { -1, -1, -1 } }, /* index: 800 */
	{ 0x04E6, 0x04E6, 0x04E7, 0x04E6, { -1, -1, -1 } }, /* index: 801 */
	{ 0x04E7, 0x04E6, 0x04E7, 0x04E6, { -1, -1, -1 } }, /* index: 802 */
	{ 0x04E8, 0x04E8, 0x04E9, 0x04E8, { -1, -1, -1 } }, /* index: 803 */
	{ 0x04E9, 0x04E8, 0x04E9, 0x04E8, { -1, -1, -1 } }, /* index: 804 */
	{ 0x04EA, 0x04EA, 0x04EB, 0x04EA, { -1, -1, -1 } }, /* index: 805 */
	{ 0x04EB, 0x04EA, 0x04EB, 0x04EA, { -1, -1, -1 } }, /* index: 806 */
	{ 0x04EC, 0x04EC, 0x04ED, 0x04EC, { -1, -1, -1 } }, /* index: 807 */
	{ 0x04ED, 0x04EC, 0x04ED, 0x04EC, { -1, -1, -1 } }, /* index: 808 */
	{ 0x04EE, 0x04EE, 0x04EF, 0x04EE, { -1, -1, -1 } }, /* index: 809 */
	{ 0x04EF, 0x04EE, 0x04EF, 0x04EE, { -1, -1, -1 } }, /* index: 810 */
	{ 0x04F0, 0x04F0, 0x04F1, 0x04F0, { -1, -1, -1 } }, /* index: 811 */
	{ 0x04F1, 0x04F0, 0x04F1, 0x04F0, { -1, -1, -1 } }, /* index: 812 */
	{ 0x04F2, 0x04F2, 0x04F3, 0x04F2, { -1, -1, -1 } }, /* index: 813 */
	{ 0x04F3, 0x04F2, 0x04F3, 0x04F2, { -1, -1, -1 } }, /* index: 814 */
	{ 0x04F4, 0x04F4, 0x04F5, 0x04F4, { -1, -1, -1 } }, /* index: 815 */
	{ 0x04F5, 0x04F4, 0x04F5, 0x04F4, { -1, -1, -1 } }, /* index: 816 */
	{ 0x04F6, 0x04F6, 0x04F7, 0x04F6, { -1, -1, -1 } }, /* index: 817 */
	{ 0x04F7, 0x04F6, 0x04F7, 0x04F6, { -1, -1, -1 } }, /* index: 818 */
	{ 0x04F8, 0x04F8, 0x04F9, 0x04F8, { -1, -1, -1 } }, /* index: 819 */
	{ 0x04F9, 0x04F8, 0x04F9, 0x04F8, { -1, -1, -1 } }, /* index: 820 */
	{ 0x04FA, 0x04FA, 0x04FB, 0x04FA, { -1, -1, -1 } }, /* index: 821 */
	{ 0x04FB, 0x04FA, 0x04FB, 0x04FA, { -1, -1, -1 } }, /* index: 822 */
	{ 0x04FC, 0x04FC, 0x04FD, 0x04FC, { -1, -1, -1 } }, /* index: 823 */
	{ 0x04FD, 0x04FC, 0x04FD, 0x04FC, { -1, -1, -1 } }, /* index: 824 */
	{ 0x04FE, 0x04FE, 0x04FF, 0x04FE, { -1, -1, -1 } }, /* index: 825 */
	{ 0x04FF, 0x04FE, 0x04FF, 0x04FE, { -1, -1, -1 } }, /* index: 826 */
	{ 0x0500, 0x0500, 0x0501, 0x0500, { -1, -1, -1 } }, /* index: 827 */
	{ 0x0501, 0x0500, 0x0501, 0x0500, { -1, -1, -1 } }, /* index: 828 */
	{ 0x0502, 0x0502, 0x0503, 0x0502, { -1, -1, -1 } }, /* index: 829 */
	{ 0x0503, 0x0502, 0x0503, 0x0502, { -1, -1, -1 } }, /* index: 830 */
	{ 0x0504, 0x0504, 0x0505, 0x0504, { -1, -1, -1 } }, /* index: 831 */
	{ 0x0505, 0x0504, 0x0505, 0x0504, { -1, -1, -1 } }, /* index: 832 */
	{ 0x0506, 0x0506, 0x0507, 0x0506, { -1, -1, -1 } }, /* index: 833 */
	{ 0x0507, 0x0506, 0x0507, 0x0506, { -1, -1, -1 } }, /* index: 834 */
	{ 0x0508, 0x0508, 0x0509, 0x0508, { -1, -1, -1 } }, /* index: 835 */
	{ 0x0509, 0x0508, 0x0509, 0x0508, { -1, -1, -1 } }, /* index: 836 */
	{ 0x050A, 0x050A, 0x050B, 0x050A, { -1, -1, -1 } }, /* index: 837 */
	{ 0x050B, 0x050A, 0x050B, 0x050A, { -1, -1, -1 } }, /* index: 838 */
	{ 0x050C, 0x050C, 0x050D, 0x050C, { -1, -1, -1 } }, /* index: 839 */
	{ 0x050D, 0x050C, 0x050D, 0x050C, { -1, -1, -1 } }, /* index: 840 */
	{ 0x050E, 0x050E, 0x050F, 0x050E, { -1, -1, -1 } }, /* index: 841 */
	{ 0x050F, 0x050E, 0x050F, 0x050E, { -1, -1, -1 } }, /* index: 842 */
	{ 0x0510, 0x0510, 0x0511, 0x0510, { -1, -1, -1 } }, /* index: 843 */
	{ 0x0511, 0x0510, 0x0511, 0x0510, { -1, -1, -1 } }, /* index: 844 */
	{ 0x0512, 0x0512, 0x0513, 0x0512, { -1, -1, -1 } }, /* index: 845 */
	{ 0x0513, 0x0512, 0x0513, 0x0512, { -1, -1, -1 } }, /* index: 846 */
	{ 0x0514, 0x0514, 0x0515, 0x0514, { -1, -1, -1 } }, /* index: 847 */
	{ 0x0515, 0x0514, 0x0515, 0x0514, { -1, -1, -1 } }, /* index: 848 */
	{ 0x0516, 0x0516, 0x0517, 0x0516, { -1, -1, -1 } }, /* index: 849 */
	{ 0x0517, 0x0516, 0x0517, 0x0516, { -1, -1, -1 } }, /* index: 850 */
	{ 0x0518, 0x0518, 0x0519, 0x0518, { -1, -1, -1 } }, /* index: 851 */
	{ 0x0519, 0x0518, 0x0519, 0x0518, { -1, -1, -1 } }, /* index: 852 */
	{ 0x051A, 0x051A, 0x051B, 0x051A, { -1, -1, -1 } }, /* index: 853 */
	{ 0x051B, 0x051A, 0x051B, 0x051A, { -1, -1, -1 } }, /* index: 854 */
	{ 0x051C, 0x051C, 0x051D, 0x051C, { -1, -1, -1 } }, /* index: 855 */
	{ 0x051D, 0x051C, 0x051D, 0x051C, { -1, -1, -1 } }, /* index: 856 */
	{ 0x051E, 0x051E, 0x051F, 0x051E, { -1, -1, -1 } }, /* index: 857 */
	{ 0x051F, 0x051E, 0x051F, 0x051E, { -1, -1, -1 } }, /* index: 858 */
	{ 0x0520, 0x0520, 0x0521, 0x0520, { -1, -1, -1 } }, /* index: 859 */
	{ 0x0521, 0x0520, 0x0521, 0x0520, { -1, -1, -1 } }, /* index: 860 */
	{ 0x0522, 0x0522, 0x0523, 0x0522, { -1, -1, -1 } }, /* index: 861 */
	{ 0x0523, 0x0522, 0x0523, 0x0522, { -1, -1, -1 } }, /* index: 862 */
	{ 0x0531, 0x0531, 0x0561, 0x0531, { -1, -1, -1 } }, /* index: 863 */
	{ 0x0532, 0x0532, 0x0562, 0x0532, { -1, -1, -1 } }, /* index: 864 */
	{ 0x0533, 0x0533, 0x0563, 0x0533, { -1, -1, -1 } }, /* index: 865 */
	{ 0x0534, 0x0534, 0x0564, 0x0534, { -1, -1, -1 } }, /* index: 866 */
	{ 0x0535, 0x0535, 0x0565, 0x0535, { -1, -1, -1 } }, /* index: 867 */
	{ 0x0536, 0x0536, 0x0566, 0x0536, { -1, -1, -1 } }, /* index: 868 */
	{ 0x0537, 0x0537, 0x0567, 0x0537, { -1, -1, -1 } }, /* index: 869 */
	{ 0x0538, 0x0538, 0x0568, 0x0538, { -1, -1, -1 } }, /* index: 870 */
	{ 0x0539, 0x0539, 0x0569, 0x0539, { -1, -1, -1 } }, /* index: 871 */
	{ 0x053A, 0x053A, 0x056A, 0x053A, { -1, -1, -1 } }, /* index: 872 */
	{ 0x053B, 0x053B, 0x056B, 0x053B, { -1, -1, -1 } }, /* index: 873 */
	{ 0x053C, 0x053C, 0x056C, 0x053C, { -1, -1, -1 } }, /* index: 874 */
	{ 0x053D, 0x053D, 0x056D, 0x053D, { -1, -1, -1 } }, /* index: 875 */
	{ 0x053E, 0x053E, 0x056E, 0x053E, { -1, -1, -1 } }, /* index: 876 */
	{ 0x053F, 0x053F, 0x056F, 0x053F, { -1, -1, -1 } }, /* index: 877 */
	{ 0x0540, 0x0540, 0x0570, 0x0540, { -1, -1, -1 } }, /* index: 878 */
	{ 0x0541, 0x0541, 0x0571, 0x0541, { -1, -1, -1 } }, /* index: 879 */
	{ 0x0542, 0x0542, 0x0572, 0x0542, { -1, -1, -1 } }, /* index: 880 */
	{ 0x0543, 0x0543, 0x0573, 0x0543, { -1, -1, -1 } }, /* index: 881 */
	{ 0x0544, 0x0544, 0x0574, 0x0544, { -1, -1, -1 } }, /* index: 882 */
	{ 0x0545, 0x0545, 0x0575, 0x0545, { -1, -1, -1 } }, /* index: 883 */
	{ 0x0546, 0x0546, 0x0576, 0x0546, { -1, -1, -1 } }, /* index: 884 */
	{ 0x0547, 0x0547, 0x0577, 0x0547, { -1, -1, -1 } }, /* index: 885 */
	{ 0x0548, 0x0548, 0x0578, 0x0548, { -1, -1, -1 } }, /* index: 886 */
	{ 0x0549, 0x0549, 0x0579, 0x0549, { -1, -1, -1 } }, /* index: 887 */
	{ 0x054A, 0x054A, 0x057A, 0x054A, { -1, -1, -1 } }, /* index: 888 */
	{ 0x054B, 0x054B, 0x057B, 0x054B, { -1, -1, -1 } }, /* index: 889 */
	{ 0x054C, 0x054C, 0x057C, 0x054C, { -1, -1, -1 } }, /* index: 890 */
	{ 0x054D, 0x054D, 0x057D, 0x054D, { -1, -1, -1 } }, /* index: 891 */
	{ 0x054E, 0x054E, 0x057E, 0x054E, { -1, -1, -1 } }, /* index: 892 */
	{ 0x054F, 0x054F, 0x057F, 0x054F, { -1, -1, -1 } }, /* index: 893 */
	{ 0x0550, 0x0550, 0x0580, 0x0550, { -1, -1, -1 } }, /* index: 894 */
	{ 0x0551, 0x0551, 0x0581, 0x0551, { -1, -1, -1 } }, /* index: 895 */
	{ 0x0552, 0x0552, 0x0582, 0x0552, { -1, -1, -1 } }, /* index: 896 */
	{ 0x0553, 0x0553, 0x0583, 0x0553, { -1, -1, -1 } }, /* index: 897 */
	{ 0x0554, 0x0554, 0x0584, 0x0554, { -1, -1, -1 } }, /* index: 898 */
	{ 0x0555, 0x0555, 0x0585, 0x0555, { -1, -1, -1 } }, /* index: 899 */
	{ 0x0556, 0x0556, 0x0586, 0x0556, { -1, -1, -1 } }, /* index: 900 */
	{ 0x0561, 0x0531, 0x0561, 0x0531, { -1, -1, -1 } }, /* index: 901 */
	{ 0x0562, 0x0532, 0x0562, 0x0532, { -1, -1, -1 } }, /* index: 902 */
	{ 0x0563, 0x0533, 0x0563, 0x0533, { -1, -1, -1 } }, /* index: 903 */
	{ 0x0564, 0x0534, 0x0564, 0x0534, { -1, -1, -1 } }, /* index: 904 */
	{ 0x0565, 0x0535, 0x0565, 0x0535, { -1, -1, -1 } }, /* index: 905 */
	{ 0x0566, 0x0536, 0x0566, 0x0536, { -1, -1, -1 } }, /* index: 906 */
	{ 0x0567, 0x0537, 0x0567, 0x0537, { -1, -1, -1 } }, /* index: 907 */
	{ 0x0568, 0x0538, 0x0568, 0x0538, { -1, -1, -1 } }, /* index: 908 */
	{ 0x0569, 0x0539, 0x0569, 0x0539, { -1, -1, -1 } }, /* index: 909 */
	{ 0x056A, 0x053A, 0x056A, 0x053A, { -1, -1, -1 } }, /* index: 910 */
	{ 0x056B, 0x053B, 0x056B, 0x053B, { -1, -1, -1 } }, /* index: 911 */
	{ 0x056C, 0x053C, 0x056C, 0x053C, { -1, -1, -1 } }, /* index: 912 */
	{ 0x056D, 0x053D, 0x056D, 0x053D, { -1, -1, -1 } }, /* index: 913 */
	{ 0x056E, 0x053E, 0x056E, 0x053E, { -1, -1, -1 } }, /* index: 914 */
	{ 0x056F, 0x053F, 0x056F, 0x053F, { -1, -1, -1 } }, /* index: 915 */
	{ 0x0570, 0x0540, 0x0570, 0x0540, { -1, -1, -1 } }, /* index: 916 */
	{ 0x0571, 0x0541, 0x0571, 0x0541, { -1, -1, -1 } }, /* index: 917 */
	{ 0x0572, 0x0542, 0x0572, 0x0542, { -1, -1, -1 } }, /* index: 918 */
	{ 0x0573, 0x0543, 0x0573, 0x0543, { -1, -1, -1 } }, /* index: 919 */
	{ 0x0574, 0x0544, 0x0574, 0x0544, { -1, -1, -1 } }, /* index: 920 */
	{ 0x0575, 0x0545, 0x0575, 0x0545, { -1, -1, -1 } }, /* index: 921 */
	{ 0x0576, 0x0546, 0x0576, 0x0546, { -1, -1, -1 } }, /* index: 922 */
	{ 0x0577, 0x0547, 0x0577, 0x0547, { -1, -1, -1 } }, /* index: 923 */
	{ 0x0578, 0x0548, 0x0578, 0x0548, { -1, -1, -1 } }, /* index: 924 */
	{ 0x0579, 0x0549, 0x0579, 0x0549, { -1, -1, -1 } }, /* index: 925 */
	{ 0x057A, 0x054A, 0x057A, 0x054A, { -1, -1, -1 } }, /* index: 926 */
	{ 0x057B, 0x054B, 0x057B, 0x054B, { -1, -1, -1 } }, /* index: 927 */
	{ 0x057C, 0x054C, 0x057C, 0x054C, { -1, -1, -1 } }, /* index: 928 */
	{ 0x057D, 0x054D, 0x057D, 0x054D, { -1, -1, -1 } }, /* index: 929 */
	{ 0x057E, 0x054E, 0x057E, 0x054E, { -1, -1, -1 } }, /* index: 930 */
	{ 0x057F, 0x054F, 0x057F, 0x054F, { -1, -1, -1 } }, /* index: 931 */
	{ 0x0580, 0x0550, 0x0580, 0x0550, { -1, -1, -1 } }, /* index: 932 */
	{ 0x0581, 0x0551, 0x0581, 0x0551, { -1, -1, -1 } }, /* index: 933 */
	{ 0x0582, 0x0552, 0x0582, 0x0552, { -1, -1, -1 } }, /* index: 934 */
	{ 0x0583, 0x0553, 0x0583, 0x0553, { -1, -1, -1 } }, /* index: 935 */
	{ 0x0584, 0x0554, 0x0584, 0x0554, { -1, -1, -1 } }, /* index: 936 */
	{ 0x0585, 0x0555, 0x0585, 0x0555, { -1, -1, -1 } }, /* index: 937 */
	{ 0x0586, 0x0556, 0x0586, 0x0556, { -1, -1, -1 } }, /* index: 938 */
	{ 0x0587, 0x0587, 0x0587, 0x0587, { 9, -1, -1 } }, /* index: 939 */
	{ 0x10A0, 0x10A0, 0x2D00, 0x10A0, { -1, -1, -1 } }, /* index: 940 */
	{ 0x10A1, 0x10A1, 0x2D01, 0x10A1, { -1, -1, -1 } }, /* index: 941 */
	{ 0x10A2, 0x10A2, 0x2D02, 0x10A2, { -1, -1, -1 } }, /* index: 942 */
	{ 0x10A3, 0x10A3, 0x2D03, 0x10A3, { -1, -1, -1 } }, /* index: 943 */
	{ 0x10A4, 0x10A4, 0x2D04, 0x10A4, { -1, -1, -1 } }, /* index: 944 */
	{ 0x10A5, 0x10A5, 0x2D05, 0x10A5, { -1, -1, -1 } }, /* index: 945 */
	{ 0x10A6, 0x10A6, 0x2D06, 0x10A6, { -1, -1, -1 } }, /* index: 946 */
	{ 0x10A7, 0x10A7, 0x2D07, 0x10A7, { -1, -1, -1 } }, /* index: 947 */
	{ 0x10A8, 0x10A8, 0x2D08, 0x10A8, { -1, -1, -1 } }, /* index: 948 */
	{ 0x10A9, 0x10A9, 0x2D09, 0x10A9, { -1, -1, -1 } }, /* index: 949 */
	{ 0x10AA, 0x10AA, 0x2D0A, 0x10AA, { -1, -1, -1 } }, /* index: 950 */
	{ 0x10AB, 0x10AB, 0x2D0B, 0x10AB, { -1, -1, -1 } }, /* index: 951 */
	{ 0x10AC, 0x10AC, 0x2D0C, 0x10AC, { -1, -1, -1 } }, /* index: 952 */
	{ 0x10AD, 0x10AD, 0x2D0D, 0x10AD, { -1, -1, -1 } }, /* index: 953 */
	{ 0x10AE, 0x10AE, 0x2D0E, 0x10AE, { -1, -1, -1 } }, /* index: 954 */
	{ 0x10AF, 0x10AF, 0x2D0F, 0x10AF, { -1, -1, -1 } }, /* index: 955 */
	{ 0x10B0, 0x10B0, 0x2D10, 0x10B0, { -1, -1, -1 } }, /* index: 956 */
	{ 0x10B1, 0x10B1, 0x2D11, 0x10B1, { -1, -1, -1 } }, /* index: 957 */
	{ 0x10B2, 0x10B2, 0x2D12, 0x10B2, { -1, -1, -1 } }, /* index: 958 */
	{ 0x10B3, 0x10B3, 0x2D13, 0x10B3, { -1, -1, -1 } }, /* index: 959 */
	{ 0x10B4, 0x10B4, 0x2D14, 0x10B4, { -1, -1, -1 } }, /* index: 960 */
	{ 0x10B5, 0x10B5, 0x2D15, 0x10B5, { -1, -1, -1 } }, /* index: 961 */
	{ 0x10B6, 0x10B6, 0x2D16, 0x10B6, { -1, -1, -1 } }, /* index: 962 */
	{ 0x10B7, 0x10B7, 0x2D17, 0x10B7, { -1, -1, -1 } }, /* index: 963 */
	{ 0x10B8, 0x10B8, 0x2D18, 0x10B8, { -1, -1, -1 } }, /* index: 964 */
	{ 0x10B9, 0x10B9, 0x2D19, 0x10B9, { -1, -1, -1 } }, /* index: 965 */
	{ 0x10BA, 0x10BA, 0x2D1A, 0x10BA, { -1, -1, -1 } }, /* index: 966 */
	{ 0x10BB, 0x10BB, 0x2D1B, 0x10BB, { -1, -1, -1 } }, /* index: 967 */
	{ 0x10BC, 0x10BC, 0x2D1C, 0x10BC, { -1, -1, -1 } }, /* index: 968 */
	{ 0x10BD, 0x10BD, 0x2D1D, 0x10BD, { -1, -1, -1 } }, /* index: 969 */
	{ 0x10BE, 0x10BE, 0x2D1E, 0x10BE, { -1, -1, -1 } }, /* index: 970 */
	{ 0x10BF, 0x10BF, 0x2D1F, 0x10BF, { -1, -1, -1 } }, /* index: 971 */
	{ 0x10C0, 0x10C0, 0x2D20, 0x10C0, { -1, -1, -1 } }, /* index: 972 */
	{ 0x10C1, 0x10C1, 0x2D21, 0x10C1, { -1, -1, -1 } }, /* index: 973 */
	{ 0x10C2, 0x10C2, 0x2D22, 0x10C2, { -1, -1, -1 } }, /* index: 974 */
	{ 0x10C3, 0x10C3, 0x2D23, 0x10C3, { -1, -1, -1 } }, /* index: 975 */
	{ 0x10C4, 0x10C4, 0x2D24, 0x10C4, { -1, -1, -1 } }, /* index: 976 */
	{ 0x10C5, 0x10C5, 0x2D25, 0x10C5, { -1, -1, -1 } }, /* index: 977 */
	{ 0x1D79, 0xA77D, 0x1D79, 0xA77D, { -1, -1, -1 } }, /* index: 978 */
	{ 0x1D7D, 0x2C63, 0x1D7D, 0x2C63, { -1, -1, -1 } }, /* index: 979 */
	{ 0x1E00, 0x1E00, 0x1E01, 0x1E00, { -1, -1, -1 } }, /* index: 980 */
	{ 0x1E01, 0x1E00, 0x1E01, 0x1E00, { -1, -1, -1 } }, /* index: 981 */
	{ 0x1E02, 0x1E02, 0x1E03, 0x1E02, { -1, -1, -1 } }, /* index: 982 */
	{ 0x1E03, 0x1E02, 0x1E03, 0x1E02, { -1, -1, -1 } }, /* index: 983 */
	{ 0x1E04, 0x1E04, 0x1E05, 0x1E04, { -1, -1, -1 } }, /* index: 984 */
	{ 0x1E05, 0x1E04, 0x1E05, 0x1E04, { -1, -1, -1 } }, /* index: 985 */
	{ 0x1E06, 0x1E06, 0x1E07, 0x1E06, { -1, -1, -1 } }, /* index: 986 */
	{ 0x1E07, 0x1E06, 0x1E07, 0x1E06, { -1, -1, -1 } }, /* index: 987 */
	{ 0x1E08, 0x1E08, 0x1E09, 0x1E08, { -1, -1, -1 } }, /* index: 988 */
	{ 0x1E09, 0x1E08, 0x1E09, 0x1E08, { -1, -1, -1 } }, /* index: 989 */
	{ 0x1E0A, 0x1E0A, 0x1E0B, 0x1E0A, { -1, -1, -1 } }, /* index: 990 */
	{ 0x1E0B, 0x1E0A, 0x1E0B, 0x1E0A, { -1, -1, -1 } }, /* index: 991 */
	{ 0x1E0C, 0x1E0C, 0x1E0D, 0x1E0C, { -1, -1, -1 } }, /* index: 992 */
	{ 0x1E0D, 0x1E0C, 0x1E0D, 0x1E0C, { -1, -1, -1 } }, /* index: 993 */
	{ 0x1E0E, 0x1E0E, 0x1E0F, 0x1E0E, { -1, -1, -1 } }, /* index: 994 */
	{ 0x1E0F, 0x1E0E, 0x1E0F, 0x1E0E, { -1, -1, -1 } }, /* index: 995 */
	{ 0x1E10, 0x1E10, 0x1E11, 0x1E10, { -1, -1, -1 } }, /* index: 996 */
	{ 0x1E11, 0x1E10, 0x1E11, 0x1E10, { -1, -1, -1 } }, /* index: 997 */
	{ 0x1E12, 0x1E12, 0x1E13, 0x1E12, { -1, -1, -1 } }, /* index: 998 */
	{ 0x1E13, 0x1E12, 0x1E13, 0x1E12, { -1, -1, -1 } }, /* index: 999 */
	{ 0x1E14, 0x1E14, 0x1E15, 0x1E14, { -1, -1, -1 } }, /* index: 1000 */
	{ 0x1E15, 0x1E14, 0x1E15, 0x1E14, { -1, -1, -1 } }, /* index: 1001 */
	{ 0x1E16, 0x1E16, 0x1E17, 0x1E16, { -1, -1, -1 } }, /* index: 1002 */
	{ 0x1E17, 0x1E16, 0x1E17, 0x1E16, { -1, -1, -1 } }, /* index: 1003 */
	{ 0x1E18, 0x1E18, 0x1E19, 0x1E18, { -1, -1, -1 } }, /* index: 1004 */
	{ 0x1E19, 0x1E18, 0x1E19, 0x1E18, { -1, -1, -1 } }, /* index: 1005 */
	{ 0x1E1A, 0x1E1A, 0x1E1B, 0x1E1A, { -1, -1, -1 } }, /* index: 1006 */
	{ 0x1E1B, 0x1E1A, 0x1E1B, 0x1E1A, { -1, -1, -1 } }, /* index: 1007 */
	{ 0x1E1C, 0x1E1C, 0x1E1D, 0x1E1C, { -1, -1, -1 } }, /* index: 1008 */
	{ 0x1E1D, 0x1E1C, 0x1E1D, 0x1E1C, { -1, -1, -1 } }, /* index: 1009 */
	{ 0x1E1E, 0x1E1E, 0x1E1F, 0x1E1E, { -1, -1, -1 } }, /* index: 1010 */
	{ 0x1E1F, 0x1E1E, 0x1E1F, 0x1E1E, { -1, -1, -1 } }, /* index: 1011 */
	{ 0x1E20, 0x1E20, 0x1E21, 0x1E20, { -1, -1, -1 } }, /* index: 1012 */
	{ 0x1E21, 0x1E20, 0x1E21, 0x1E20, { -1, -1, -1 } }, /* index: 1013 */
	{ 0x1E22, 0x1E22, 0x1E23, 0x1E22, { -1, -1, -1 } }, /* index: 1014 */
	{ 0x1E23, 0x1E22, 0x1E23, 0x1E22, { -1, -1, -1 } }, /* index: 1015 */
	{ 0x1E24, 0x1E24, 0x1E25, 0x1E24, { -1, -1, -1 } }, /* index: 1016 */
	{ 0x1E25, 0x1E24, 0x1E25, 0x1E24, { -1, -1, -1 } }, /* index: 1017 */
	{ 0x1E26, 0x1E26, 0x1E27, 0x1E26, { -1, -1, -1 } }, /* index: 1018 */
	{ 0x1E27, 0x1E26, 0x1E27, 0x1E26, { -1, -1, -1 } }, /* index: 1019 */
	{ 0x1E28, 0x1E28, 0x1E29, 0x1E28, { -1, -1, -1 } }, /* index: 1020 */
	{ 0x1E29, 0x1E28, 0x1E29, 0x1E28, { -1, -1, -1 } }, /* index: 1021 */
	{ 0x1E2A, 0x1E2A, 0x1E2B, 0x1E2A, { -1, -1, -1 } }, /* index: 1022 */
	{ 0x1E2B, 0x1E2A, 0x1E2B, 0x1E2A, { -1, -1, -1 } }, /* index: 1023 */
	{ 0x1E2C, 0x1E2C, 0x1E2D, 0x1E2C, { -1, -1, -1 } }, /* index: 1024 */
	{ 0x1E2D, 0x1E2C, 0x1E2D, 0x1E2C, { -1, -1, -1 } }, /* index: 1025 */
	{ 0x1E2E, 0x1E2E, 0x1E2F, 0x1E2E, { -1, -1, -1 } }, /* index: 1026 */
	{ 0x1E2F, 0x1E2E, 0x1E2F, 0x1E2E, { -1, -1, -1 } }, /* index: 1027 */
	{ 0x1E30, 0x1E30, 0x1E31, 0x1E30, { -1, -1, -1 } }, /* index: 1028 */
	{ 0x1E31, 0x1E30, 0x1E31, 0x1E30, { -1, -1, -1 } }, /* index: 1029 */
	{ 0x1E32, 0x1E32, 0x1E33, 0x1E32, { -1, -1, -1 } }, /* index: 1030 */
	{ 0x1E33, 0x1E32, 0x1E33, 0x1E32, { -1, -1, -1 } }, /* index: 1031 */
	{ 0x1E34, 0x1E34, 0x1E35, 0x1E34, { -1, -1, -1 } }, /* index: 1032 */
	{ 0x1E35, 0x1E34, 0x1E35, 0x1E34, { -1, -1, -1 } }, /* index: 1033 */
	{ 0x1E36, 0x1E36, 0x1E37, 0x1E36, { -1, -1, -1 } }, /* index: 1034 */
	{ 0x1E37, 0x1E36, 0x1E37, 0x1E36, { -1, -1, -1 } }, /* index: 1035 */
	{ 0x1E38, 0x1E38, 0x1E39, 0x1E38, { -1, -1, -1 } }, /* index: 1036 */
	{ 0x1E39, 0x1E38, 0x1E39, 0x1E38, { -1, -1, -1 } }, /* index: 1037 */
	{ 0x1E3A, 0x1E3A, 0x1E3B, 0x1E3A, { -1, -1, -1 } }, /* index: 1038 */
	{ 0x1E3B, 0x1E3A, 0x1E3B, 0x1E3A, { -1, -1, -1 } }, /* index: 1039 */
	{ 0x1E3C, 0x1E3C, 0x1E3D, 0x1E3C, { -1, -1, -1 } }, /* index: 1040 */
	{ 0x1E3D, 0x1E3C, 0x1E3D, 0x1E3C, { -1, -1, -1 } }, /* index: 1041 */
	{ 0x1E3E, 0x1E3E, 0x1E3F, 0x1E3E, { -1, -1, -1 } }, /* index: 1042 */
	{ 0x1E3F, 0x1E3E, 0x1E3F, 0x1E3E, { -1, -1, -1 } }, /* index: 1043 */
	{ 0x1E40, 0x1E40, 0x1E41, 0x1E40, { -1, -1, -1 } }, /* index: 1044 */
	{ 0x1E41, 0x1E40, 0x1E41, 0x1E40, { -1, -1, -1 } }, /* index: 1045 */
	{ 0x1E42, 0x1E42, 0x1E43, 0x1E42, { -1, -1, -1 } }, /* index: 1046 */
	{ 0x1E43, 0x1E42, 0x1E43, 0x1E42, { -1, -1, -1 } }, /* index: 1047 */
	{ 0x1E44, 0x1E44, 0x1E45, 0x1E44, { -1, -1, -1 } }, /* index: 1048 */
	{ 0x1E45, 0x1E44, 0x1E45, 0x1E44, { -1, -1, -1 } }, /* index: 1049 */
	{ 0x1E46, 0x1E46, 0x1E47, 0x1E46, { -1, -1, -1 } }, /* index: 1050 */
	{ 0x1E47, 0x1E46, 0x1E47, 0x1E46, { -1, -1, -1 } }, /* index: 1051 */
	{ 0x1E48, 0x1E48, 0x1E49, 0x1E48, { -1, -1, -1 } }, /* index: 1052 */
	{ 0x1E49, 0x1E48, 0x1E49, 0x1E48, { -1, -1, -1 } }, /* index: 1053 */
	{ 0x1E4A, 0x1E4A, 0x1E4B, 0x1E4A, { -1, -1, -1 } }, /* index: 1054 */
	{ 0x1E4B, 0x1E4A, 0x1E4B, 0x1E4A, { -1, -1, -1 } }, /* index: 1055 */
	{ 0x1E4C, 0x1E4C, 0x1E4D, 0x1E4C, { -1, -1, -1 } }, /* index: 1056 */
	{ 0x1E4D, 0x1E4C, 0x1E4D, 0x1E4C, { -1, -1, -1 } }, /* index: 1057 */
	{ 0x1E4E, 0x1E4E, 0x1E4F, 0x1E4E, { -1, -1, -1 } }, /* index: 1058 */
	{ 0x1E4F, 0x1E4E, 0x1E4F, 0x1E4E, { -1, -1, -1 } }, /* index: 1059 */
	{ 0x1E50, 0x1E50, 0x1E51, 0x1E50, { -1, -1, -1 } }, /* index: 1060 */
	{ 0x1E51, 0x1E50, 0x1E51, 0x1E50, { -1, -1, -1 } }, /* index: 1061 */
	{ 0x1E52, 0x1E52, 0x1E53, 0x1E52, { -1, -1, -1 } }, /* index: 1062 */
	{ 0x1E53, 0x1E52, 0x1E53, 0x1E52, { -1, -1, -1 } }, /* index: 1063 */
	{ 0x1E54, 0x1E54, 0x1E55, 0x1E54, { -1, -1, -1 } }, /* index: 1064 */
	{ 0x1E55, 0x1E54, 0x1E55, 0x1E54, { -1, -1, -1 } }, /* index: 1065 */
	{ 0x1E56, 0x1E56, 0x1E57, 0x1E56, { -1, -1, -1 } }, /* index: 1066 */
	{ 0x1E57, 0x1E56, 0x1E57, 0x1E56, { -1, -1, -1 } }, /* index: 1067 */
	{ 0x1E58, 0x1E58, 0x1E59, 0x1E58, { -1, -1, -1 } }, /* index: 1068 */
	{ 0x1E59, 0x1E58, 0x1E59, 0x1E58, { -1, -1, -1 } }, /* index: 1069 */
	{ 0x1E5A, 0x1E5A, 0x1E5B, 0x1E5A, { -1, -1, -1 } }, /* index: 1070 */
	{ 0x1E5B, 0x1E5A, 0x1E5B, 0x1E5A, { -1, -1, -1 } }, /* index: 1071 */
	{ 0x1E5C, 0x1E5C, 0x1E5D, 0x1E5C, { -1, -1, -1 } }, /* index: 1072 */
	{ 0x1E5D, 0x1E5C, 0x1E5D, 0x1E5C, { -1, -1, -1 } }, /* index: 1073 */
	{ 0x1E5E, 0x1E5E, 0x1E5F, 0x1E5E, { -1, -1, -1 } }, /* index: 1074 */
	{ 0x1E5F, 0x1E5E, 0x1E5F, 0x1E5E, { -1, -1, -1 } }, /* index: 1075 */
	{ 0x1E60, 0x1E60, 0x1E61, 0x1E60, { -1, -1, -1 } }, /* index: 1076 */
	{ 0x1E61, 0x1E60, 0x1E61, 0x1E60, { -1, -1, -1 } }, /* index: 1077 */
	{ 0x1E62, 0x1E62, 0x1E63, 0x1E62, { -1, -1, -1 } }, /* index: 1078 */
	{ 0x1E63, 0x1E62, 0x1E63, 0x1E62, { -1, -1, -1 } }, /* index: 1079 */
	{ 0x1E64, 0x1E64, 0x1E65, 0x1E64, { -1, -1, -1 } }, /* index: 1080 */
	{ 0x1E65, 0x1E64, 0x1E65, 0x1E64, { -1, -1, -1 } }, /* index: 1081 */
	{ 0x1E66, 0x1E66, 0x1E67, 0x1E66, { -1, -1, -1 } }, /* index: 1082 */
	{ 0x1E67, 0x1E66, 0x1E67, 0x1E66, { -1, -1, -1 } }, /* index: 1083 */
	{ 0x1E68, 0x1E68, 0x1E69, 0x1E68, { -1, -1, -1 } }, /* index: 1084 */
	{ 0x1E69, 0x1E68, 0x1E69, 0x1E68, { -1, -1, -1 } }, /* index: 1085 */
	{ 0x1E6A, 0x1E6A, 0x1E6B, 0x1E6A, { -1, -1, -1 } }, /* index: 1086 */
	{ 0x1E6B, 0x1E6A, 0x1E6B, 0x1E6A, { -1, -1, -1 } }, /* index: 1087 */
	{ 0x1E6C, 0x1E6C, 0x1E6D, 0x1E6C, { -1, -1, -1 } }, /* index: 1088 */
	{ 0x1E6D, 0x1E6C, 0x1E6D, 0x1E6C, { -1, -1, -1 } }, /* index: 1089 */
	{ 0x1E6E, 0x1E6E, 0x1E6F, 0x1E6E, { -1, -1, -1 } }, /* index: 1090 */
	{ 0x1E6F, 0x1E6E, 0x1E6F, 0x1E6E, { -1, -1, -1 } }, /* index: 1091 */
	{ 0x1E70, 0x1E70, 0x1E71, 0x1E70, { -1, -1, -1 } }, /* index: 1092 */
	{ 0x1E71, 0x1E70, 0x1E71, 0x1E70, { -1, -1, -1 } }, /* index: 1093 */
	{ 0x1E72, 0x1E72, 0x1E73, 0x1E72, { -1, -1, -1 } }, /* index: 1094 */
	{ 0x1E73, 0x1E72, 0x1E73, 0x1E72, { -1, -1, -1 } }, /* index: 1095 */
	{ 0x1E74, 0x1E74, 0x1E75, 0x1E74, { -1, -1, -1 } }, /* index: 1096 */
	{ 0x1E75, 0x1E74, 0x1E75, 0x1E74, { -1, -1, -1 } }, /* index: 1097 */
	{ 0x1E76, 0x1E76, 0x1E77, 0x1E76, { -1, -1, -1 } }, /* index: 1098 */
	{ 0x1E77, 0x1E76, 0x1E77, 0x1E76, { -1, -1, -1 } }, /* index: 1099 */
	{ 0x1E78, 0x1E78, 0x1E79, 0x1E78, { -1, -1, -1 } }, /* index: 1100 */
	{ 0x1E79, 0x1E78, 0x1E79, 0x1E78, { -1, -1, -1 } }, /* index: 1101 */
	{ 0x1E7A, 0x1E7A, 0x1E7B, 0x1E7A, { -1, -1, -1 } }, /* index: 1102 */
	{ 0x1E7B, 0x1E7A, 0x1E7B, 0x1E7A, { -1, -1, -1 } }, /* index: 1103 */
	{ 0x1E7C, 0x1E7C, 0x1E7D, 0x1E7C, { -1, -1, -1 } }, /* index: 1104 */
	{ 0x1E7D, 0x1E7C, 0x1E7D, 0x1E7C, { -1, -1, -1 } }, /* index: 1105 */
	{ 0x1E7E, 0x1E7E, 0x1E7F, 0x1E7E, { -1, -1, -1 } }, /* index: 1106 */
	{ 0x1E7F, 0x1E7E, 0x1E7F, 0x1E7E, { -1, -1, -1 } }, /* index: 1107 */
	{ 0x1E80, 0x1E80, 0x1E81, 0x1E80, { -1, -1, -1 } }, /* index: 1108 */
	{ 0x1E81, 0x1E80, 0x1E81, 0x1E80, { -1, -1, -1 } }, /* index: 1109 */
	{ 0x1E82, 0x1E82, 0x1E83, 0x1E82, { -1, -1, -1 } }, /* index: 1110 */
	{ 0x1E83, 0x1E82, 0x1E83, 0x1E82, { -1, -1, -1 } }, /* index: 1111 */
	{ 0x1E84, 0x1E84, 0x1E85, 0x1E84, { -1, -1, -1 } }, /* index: 1112 */
	{ 0x1E85, 0x1E84, 0x1E85, 0x1E84, { -1, -1, -1 } }, /* index: 1113 */
	{ 0x1E86, 0x1E86, 0x1E87, 0x1E86, { -1, -1, -1 } }, /* index: 1114 */
	{ 0x1E87, 0x1E86, 0x1E87, 0x1E86, { -1, -1, -1 } }, /* index: 1115 */
	{ 0x1E88, 0x1E88, 0x1E89, 0x1E88, { -1, -1, -1 } }, /* index: 1116 */
	{ 0x1E89, 0x1E88, 0x1E89, 0x1E88, { -1, -1, -1 } }, /* index: 1117 */
	{ 0x1E8A, 0x1E8A, 0x1E8B, 0x1E8A, { -1, -1, -1 } }, /* index: 1118 */
	{ 0x1E8B, 0x1E8A, 0x1E8B, 0x1E8A, { -1, -1, -1 } }, /* index: 1119 */
	{ 0x1E8C, 0x1E8C, 0x1E8D, 0x1E8C, { -1, -1, -1 } }, /* index: 1120 */
	{ 0x1E8D, 0x1E8C, 0x1E8D, 0x1E8C, { -1, -1, -1 } }, /* index: 1121 */
	{ 0x1E8E, 0x1E8E, 0x1E8F, 0x1E8E, { -1, -1, -1 } }, /* index: 1122 */
	{ 0x1E8F, 0x1E8E, 0x1E8F, 0x1E8E, { -1, -1, -1 } }, /* index: 1123 */
	{ 0x1E90, 0x1E90, 0x1E91, 0x1E90, { -1, -1, -1 } }, /* index: 1124 */
	{ 0x1E91, 0x1E90, 0x1E91, 0x1E90, { -1, -1, -1 } }, /* index: 1125 */
	{ 0x1E92, 0x1E92, 0x1E93, 0x1E92, { -1, -1, -1 } }, /* index: 1126 */
	{ 0x1E93, 0x1E92, 0x1E93, 0x1E92, { -1, -1, -1 } }, /* index: 1127 */
	{ 0x1E94, 0x1E94, 0x1E95, 0x1E94, { -1, -1, -1 } }, /* index: 1128 */
	{ 0x1E95, 0x1E94, 0x1E95, 0x1E94, { -1, -1, -1 } }, /* index: 1129 */
	{ 0x1E96, 0x1E96, 0x1E96, 0x1E96, { 19, -1, -1 } }, /* index: 1130 */
	{ 0x1E97, 0x1E97, 0x1E97, 0x1E97, { 20, -1, -1 } }, /* index: 1131 */
	{ 0x1E98, 0x1E98, 0x1E98, 0x1E98, { 21, -1, -1 } }, /* index: 1132 */
	{ 0x1E99, 0x1E99, 0x1E99, 0x1E99, { 22, -1, -1 } }, /* index: 1133 */
	{ 0x1E9A, 0x1E9A, 0x1E9A, 0x1E9A, { 23, -1, -1 } }, /* index: 1134 */
	{ 0x1E9B, 0x1E60, 0x1E9B, 0x1E60, { -1, -1, -1 } }, /* index: 1135 */
	{ 0x1E9E, 0x1E9E, 0x00DF, 0x1E9E, { -1, -1, -1 } }, /* index: 1136 */
	{ 0x1EA0, 0x1EA0, 0x1EA1, 0x1EA0, { -1, -1, -1 } }, /* index: 1137 */
	{ 0x1EA1, 0x1EA0, 0x1EA1, 0x1EA0, { -1, -1, -1 } }, /* index: 1138 */
	{ 0x1EA2, 0x1EA2, 0x1EA3, 0x1EA2, { -1, -1, -1 } }, /* index: 1139 */
	{ 0x1EA3, 0x1EA2, 0x1EA3, 0x1EA2, { -1, -1, -1 } }, /* index: 1140 */
	{ 0x1EA4, 0x1EA4, 0x1EA5, 0x1EA4, { -1, -1, -1 } }, /* index: 1141 */
	{ 0x1EA5, 0x1EA4, 0x1EA5, 0x1EA4, { -1, -1, -1 } }, /* index: 1142 */
	{ 0x1EA6, 0x1EA6, 0x1EA7, 0x1EA6, { -1, -1, -1 } }, /* index: 1143 */
	{ 0x1EA7, 0x1EA6, 0x1EA7, 0x1EA6, { -1, -1, -1 } }, /* index: 1144 */
	{ 0x1EA8, 0x1EA8, 0x1EA9, 0x1EA8, { -1, -1, -1 } }, /* index: 1145 */
	{ 0x1EA9, 0x1EA8, 0x1EA9, 0x1EA8, { -1, -1, -1 } }, /* index: 1146 */
	{ 0x1EAA, 0x1EAA, 0x1EAB, 0x1EAA, { -1, -1, -1 } }, /* index: 1147 */
	{ 0x1EAB, 0x1EAA, 0x1EAB, 0x1EAA, { -1, -1, -1 } }, /* index: 1148 */
	{ 0x1EAC, 0x1EAC, 0x1EAD, 0x1EAC, { -1, -1, -1 } }, /* index: 1149 */
	{ 0x1EAD, 0x1EAC, 0x1EAD, 0x1EAC, { -1, -1, -1 } }, /* index: 1150 */
	{ 0x1EAE, 0x1EAE, 0x1EAF, 0x1EAE, { -1, -1, -1 } }, /* index: 1151 */
	{ 0x1EAF, 0x1EAE, 0x1EAF, 0x1EAE, { -1, -1, -1 } }, /* index: 1152 */
	{ 0x1EB0, 0x1EB0, 0x1EB1, 0x1EB0, { -1, -1, -1 } }, /* index: 1153 */
	{ 0x1EB1, 0x1EB0, 0x1EB1, 0x1EB0, { -1, -1, -1 } }, /* index: 1154 */
	{ 0x1EB2, 0x1EB2, 0x1EB3, 0x1EB2, { -1, -1, -1 } }, /* index: 1155 */
	{ 0x1EB3, 0x1EB2, 0x1EB3, 0x1EB2, { -1, -1, -1 } }, /* index: 1156 */
	{ 0x1EB4, 0x1EB4, 0x1EB5, 0x1EB4, { -1, -1, -1 } }, /* index: 1157 */
	{ 0x1EB5, 0x1EB4, 0x1EB5, 0x1EB4, { -1, -1, -1 } }, /* index: 1158 */
	{ 0x1EB6, 0x1EB6, 0x1EB7, 0x1EB6, { -1, -1, -1 } }, /* index: 1159 */
	{ 0x1EB7, 0x1EB6, 0x1EB7, 0x1EB6, { -1, -1, -1 } }, /* index: 1160 */
	{ 0x1EB8, 0x1EB8, 0x1EB9, 0x1EB8, { -1, -1, -1 } }, /* index: 1161 */
	{ 0x1EB9, 0x1EB8, 0x1EB9, 0x1EB8, { -1, -1, -1 } }, /* index: 1162 */
	{ 0x1EBA, 0x1EBA, 0x1EBB, 0x1EBA, { -1, -1, -1 } }, /* index: 1163 */
	{ 0x1EBB, 0x1EBA, 0x1EBB, 0x1EBA, { -1, -1, -1 } }, /* index: 1164 */
	{ 0x1EBC, 0x1EBC, 0x1EBD, 0x1EBC, { -1, -1, -1 } }, /* index: 1165 */
	{ 0x1EBD, 0x1EBC, 0x1EBD, 0x1EBC, { -1, -1, -1 } }, /* index: 1166 */
	{ 0x1EBE, 0x1EBE, 0x1EBF, 0x1EBE, { -1, -1, -1 } }, /* index: 1167 */
	{ 0x1EBF, 0x1EBE, 0x1EBF, 0x1EBE, { -1, -1, -1 } }, /* index: 1168 */
	{ 0x1EC0, 0x1EC0, 0x1EC1, 0x1EC0, { -1, -1, -1 } }, /* index: 1169 */
	{ 0x1EC1, 0x1EC0, 0x1EC1, 0x1EC0, { -1, -1, -1 } }, /* index: 1170 */
	{ 0x1EC2, 0x1EC2, 0x1EC3, 0x1EC2, { -1, -1, -1 } }, /* index: 1171 */
	{ 0x1EC3, 0x1EC2, 0x1EC3, 0x1EC2, { -1, -1, -1 } }, /* index: 1172 */
	{ 0x1EC4, 0x1EC4, 0x1EC5, 0x1EC4, { -1, -1, -1 } }, /* index: 1173 */
	{ 0x1EC5, 0x1EC4, 0x1EC5, 0x1EC4, { -1, -1, -1 } }, /* index: 1174 */
	{ 0x1EC6, 0x1EC6, 0x1EC7, 0x1EC6, { -1, -1, -1 } }, /* index: 1175 */
	{ 0x1EC7, 0x1EC6, 0x1EC7, 0x1EC6, { -1, -1, -1 } }, /* index: 1176 */
	{ 0x1EC8, 0x1EC8, 0x1EC9, 0x1EC8, { -1, -1, -1 } }, /* index: 1177 */
	{ 0x1EC9, 0x1EC8, 0x1EC9, 0x1EC8, { -1, -1, -1 } }, /* index: 1178 */
	{ 0x1ECA, 0x1ECA, 0x1ECB, 0x1ECA, { -1, -1, -1 } }, /* index: 1179 */
	{ 0x1ECB, 0x1ECA, 0x1ECB, 0x1ECA, { -1, -1, -1 } }, /* index: 1180 */
	{ 0x1ECC, 0x1ECC, 0x1ECD, 0x1ECC, { -1, -1, -1 } }, /* index: 1181 */
	{ 0x1ECD, 0x1ECC, 0x1ECD, 0x1ECC, { -1, -1, -1 } }, /* index: 1182 */
	{ 0x1ECE, 0x1ECE, 0x1ECF, 0x1ECE, { -1, -1, -1 } }, /* index: 1183 */
	{ 0x1ECF, 0x1ECE, 0x1ECF, 0x1ECE, { -1, -1, -1 } }, /* index: 1184 */
	{ 0x1ED0, 0x1ED0, 0x1ED1, 0x1ED0, { -1, -1, -1 } }, /* index: 1185 */
	{ 0x1ED1, 0x1ED0, 0x1ED1, 0x1ED0, { -1, -1, -1 } }, /* index: 1186 */
	{ 0x1ED2, 0x1ED2, 0x1ED3, 0x1ED2, { -1, -1, -1 } }, /* index: 1187 */
	{ 0x1ED3, 0x1ED2, 0x1ED3, 0x1ED2, { -1, -1, -1 } }, /* index: 1188 */
	{ 0x1ED4, 0x1ED4, 0x1ED5, 0x1ED4, { -1, -1, -1 } }, /* index: 1189 */
	{ 0x1ED5, 0x1ED4, 0x1ED5, 0x1ED4, { -1, -1, -1 } }, /* index: 1190 */
	{ 0x1ED6, 0x1ED6, 0x1ED7, 0x1ED6, { -1, -1, -1 } }, /* index: 1191 */
	{ 0x1ED7, 0x1ED6, 0x1ED7, 0x1ED6, { -1, -1, -1 } }, /* index: 1192 */
	{ 0x1ED8, 0x1ED8, 0x1ED9, 0x1ED8, { -1, -1, -1 } }, /* index: 1193 */
	{ 0x1ED9, 0x1ED8, 0x1ED9, 0x1ED8, { -1, -1, -1 } }, /* index: 1194 */
	{ 0x1EDA, 0x1EDA, 0x1EDB, 0x1EDA, { -1, -1, -1 } }, /* index: 1195 */
	{ 0x1EDB, 0x1EDA, 0x1EDB, 0x1EDA, { -1, -1, -1 } }, /* index: 1196 */
	{ 0x1EDC, 0x1EDC, 0x1EDD, 0x1EDC, { -1, -1, -1 } }, /* index: 1197 */
	{ 0x1EDD, 0x1EDC, 0x1EDD, 0x1EDC, { -1, -1, -1 } }, /* index: 1198 */
	{ 0x1EDE, 0x1EDE, 0x1EDF, 0x1EDE, { -1, -1, -1 } }, /* index: 1199 */
	{ 0x1EDF, 0x1EDE, 0x1EDF, 0x1EDE, { -1, -1, -1 } }, /* index: 1200 */
	{ 0x1EE0, 0x1EE0, 0x1EE1, 0x1EE0, { -1, -1, -1 } }, /* index: 1201 */
	{ 0x1EE1, 0x1EE0, 0x1EE1, 0x1EE0, { -1, -1, -1 } }, /* index: 1202 */
	{ 0x1EE2, 0x1EE2, 0x1EE3, 0x1EE2, { -1, -1, -1 } }, /* index: 1203 */
	{ 0x1EE3, 0x1EE2, 0x1EE3, 0x1EE2, { -1, -1, -1 } }, /* index: 1204 */
	{ 0x1EE4, 0x1EE4, 0x1EE5, 0x1EE4, { -1, -1, -1 } }, /* index: 1205 */
	{ 0x1EE5, 0x1EE4, 0x1EE5, 0x1EE4, { -1, -1, -1 } }, /* index: 1206 */
	{ 0x1EE6, 0x1EE6, 0x1EE7, 0x1EE6, { -1, -1, -1 } }, /* index: 1207 */
	{ 0x1EE7, 0x1EE6, 0x1EE7, 0x1EE6, { -1, -1, -1 } }, /* index: 1208 */
	{ 0x1EE8, 0x1EE8, 0x1EE9, 0x1EE8, { -1, -1, -1 } }, /* index: 1209 */
	{ 0x1EE9, 0x1EE8, 0x1EE9, 0x1EE8, { -1, -1, -1 } }, /* index: 1210 */
	{ 0x1EEA, 0x1EEA, 0x1EEB, 0x1EEA, { -1, -1, -1 } }, /* index: 1211 */
	{ 0x1EEB, 0x1EEA, 0x1EEB, 0x1EEA, { -1, -1, -1 } }, /* index: 1212 */
	{ 0x1EEC, 0x1EEC, 0x1EED, 0x1EEC, { -1, -1, -1 } }, /* index: 1213 */
	{ 0x1EED, 0x1EEC, 0x1EED, 0x1EEC, { -1, -1, -1 } }, /* index: 1214 */
	{ 0x1EEE, 0x1EEE, 0x1EEF, 0x1EEE, { -1, -1, -1 } }, /* index: 1215 */
	{ 0x1EEF, 0x1EEE, 0x1EEF, 0x1EEE, { -1, -1, -1 } }, /* index: 1216 */
	{ 0x1EF0, 0x1EF0, 0x1EF1, 0x1EF0, { -1, -1, -1 } }, /* index: 1217 */
	{ 0x1EF1, 0x1EF0, 0x1EF1, 0x1EF0, { -1, -1, -1 } }, /* index: 1218 */
	{ 0x1EF2, 0x1EF2, 0x1EF3, 0x1EF2, { -1, -1, -1 } }, /* index: 1219 */
	{ 0x1EF3, 0x1EF2, 0x1EF3, 0x1EF2, { -1, -1, -1 } }, /* index: 1220 */
	{ 0x1EF4, 0x1EF4, 0x1EF5, 0x1EF4, { -1, -1, -1 } }, /* index: 1221 */
	{ 0x1EF5, 0x1EF4, 0x1EF5, 0x1EF4, { -1, -1, -1 } }, /* index: 1222 */
	{ 0x1EF6, 0x1EF6, 0x1EF7, 0x1EF6, { -1, -1, -1 } }, /* index: 1223 */
	{ 0x1EF7, 0x1EF6, 0x1EF7, 0x1EF6, { -1, -1, -1 } }, /* index: 1224 */
	{ 0x1EF8, 0x1EF8, 0x1EF9, 0x1EF8, { -1, -1, -1 } }, /* index: 1225 */
	{ 0x1EF9, 0x1EF8, 0x1EF9, 0x1EF8, { -1, -1, -1 } }, /* index: 1226 */
	{ 0x1EFA, 0x1EFA, 0x1EFB, 0x1EFA, { -1, -1, -1 } }, /* index: 1227 */
	{ 0x1EFB, 0x1EFA, 0x1EFB, 0x1EFA, { -1, -1, -1 } }, /* index: 1228 */
	{ 0x1EFC, 0x1EFC, 0x1EFD, 0x1EFC, { -1, -1, -1 } }, /* index: 1229 */
	{ 0x1EFD, 0x1EFC, 0x1EFD, 0x1EFC, { -1, -1, -1 } }, /* index: 1230 */
	{ 0x1EFE, 0x1EFE, 0x1EFF, 0x1EFE, { -1, -1, -1 } }, /* index: 1231 */
	{ 0x1EFF, 0x1EFE, 0x1EFF, 0x1EFE, { -1, -1, -1 } }, /* index: 1232 */
	{ 0x1F00, 0x1F08, 0x1F00, 0x1F08, { -1, -1, -1 } }, /* index: 1233 */
	{ 0x1F01, 0x1F09, 0x1F01, 0x1F09, { -1, -1, -1 } }, /* index: 1234 */
	{ 0x1F02, 0x1F0A, 0x1F02, 0x1F0A, { -1, -1, -1 } }, /* index: 1235 */
	{ 0x1F03, 0x1F0B, 0x1F03, 0x1F0B, { -1, -1, -1 } }, /* index: 1236 */
	{ 0x1F04, 0x1F0C, 0x1F04, 0x1F0C, { -1, -1, -1 } }, /* index: 1237 */
	{ 0x1F05, 0x1F0D, 0x1F05, 0x1F0D, { -1, -1, -1 } }, /* index: 1238 */
	{ 0x1F06, 0x1F0E, 0x1F06, 0x1F0E, { -1, -1, -1 } }, /* index: 1239 */
	{ 0x1F07, 0x1F0F, 0x1F07, 0x1F0F, { -1, -1, -1 } }, /* index: 1240 */
	{ 0x1F08, 0x1F08, 0x1F00, 0x1F08, { -1, -1, -1 } }, /* index: 1241 */
	{ 0x1F09, 0x1F09, 0x1F01, 0x1F09, { -1, -1, -1 } }, /* index: 1242 */
	{ 0x1F0A, 0x1F0A, 0x1F02, 0x1F0A, { -1, -1, -1 } }, /* index: 1243 */
	{ 0x1F0B, 0x1F0B, 0x1F03, 0x1F0B, { -1, -1, -1 } }, /* index: 1244 */
	{ 0x1F0C, 0x1F0C, 0x1F04, 0x1F0C, { -1, -1, -1 } }, /* index: 1245 */
	{ 0x1F0D, 0x1F0D, 0x1F05, 0x1F0D, { -1, -1, -1 } }, /* index: 1246 */
	{ 0x1F0E, 0x1F0E, 0x1F06, 0x1F0E, { -1, -1, -1 } }, /* index: 1247 */
	{ 0x1F0F, 0x1F0F, 0x1F07, 0x1F0F, { -1, -1, -1 } }, /* index: 1248 */
	{ 0x1F10, 0x1F18, 0x1F10, 0x1F18, { -1, -1, -1 } }, /* index: 1249 */
	{ 0x1F11, 0x1F19, 0x1F11, 0x1F19, { -1, -1, -1 } }, /* index: 1250 */
	{ 0x1F12, 0x1F1A, 0x1F12, 0x1F1A, { -1, -1, -1 } }, /* index: 1251 */
	{ 0x1F13, 0x1F1B, 0x1F13, 0x1F1B, { -1, -1, -1 } }, /* index: 1252 */
	{ 0x1F14, 0x1F1C, 0x1F14, 0x1F1C, { -1, -1, -1 } }, /* index: 1253 */
	{ 0x1F15, 0x1F1D, 0x1F15, 0x1F1D, { -1, -1, -1 } }, /* index: 1254 */
	{ 0x1F18, 0x1F18, 0x1F10, 0x1F18, { -1, -1, -1 } }, /* index: 1255 */
	{ 0x1F19, 0x1F19, 0x1F11, 0x1F19, { -1, -1, -1 } }, /* index: 1256 */
	{ 0x1F1A, 0x1F1A, 0x1F12, 0x1F1A, { -1, -1, -1 } }, /* index: 1257 */
	{ 0x1F1B, 0x1F1B, 0x1F13, 0x1F1B, { -1, -1, -1 } }, /* index: 1258 */
	{ 0x1F1C, 0x1F1C, 0x1F14, 0x1F1C, { -1, -1, -1 } }, /* index: 1259 */
	{ 0x1F1D, 0x1F1D, 0x1F15, 0x1F1D, { -1, -1, -1 } }, /* index: 1260 */
	{ 0x1F20, 0x1F28, 0x1F20, 0x1F28, { -1, -1, -1 } }, /* index: 1261 */
	{ 0x1F21, 0x1F29, 0x1F21, 0x1F29, { -1, -1, -1 } }, /* index: 1262 */
	{ 0x1F22, 0x1F2A, 0x1F22, 0x1F2A, { -1, -1, -1 } }, /* index: 1263 */
	{ 0x1F23, 0x1F2B, 0x1F23, 0x1F2B, { -1, -1, -1 } }, /* index: 1264 */
	{ 0x1F24, 0x1F2C, 0x1F24, 0x1F2C, { -1, -1, -1 } }, /* index: 1265 */
	{ 0x1F25, 0x1F2D, 0x1F25, 0x1F2D, { -1, -1, -1 } }, /* index: 1266 */
	{ 0x1F26, 0x1F2E, 0x1F26, 0x1F2E, { -1, -1, -1 } }, /* index: 1267 */
	{ 0x1F27, 0x1F2F, 0x1F27, 0x1F2F, { -1, -1, -1 } }, /* index: 1268 */
	{ 0x1F28, 0x1F28, 0x1F20, 0x1F28, { -1, -1, -1 } }, /* index: 1269 */
	{ 0x1F29, 0x1F29, 0x1F21, 0x1F29, { -1, -1, -1 } }, /* index: 1270 */
	{ 0x1F2A, 0x1F2A, 0x1F22, 0x1F2A, { -1, -1, -1 } }, /* index: 1271 */
	{ 0x1F2B, 0x1F2B, 0x1F23, 0x1F2B, { -1, -1, -1 } }, /* index: 1272 */
	{ 0x1F2C, 0x1F2C, 0x1F24, 0x1F2C, { -1, -1, -1 } }, /* index: 1273 */
	{ 0x1F2D, 0x1F2D, 0x1F25, 0x1F2D, { -1, -1, -1 } }, /* index: 1274 */
	{ 0x1F2E, 0x1F2E, 0x1F26, 0x1F2E, { -1, -1, -1 } }, /* index: 1275 */
	{ 0x1F2F, 0x1F2F, 0x1F27, 0x1F2F, { -1, -1, -1 } }, /* index: 1276 */
	{ 0x1F30, 0x1F38, 0x1F30, 0x1F38, { -1, -1, -1 } }, /* index: 1277 */
	{ 0x1F31, 0x1F39, 0x1F31, 0x1F39, { -1, -1, -1 } }, /* index: 1278 */
	{ 0x1F32, 0x1F3A, 0x1F32, 0x1F3A, { -1, -1, -1 } }, /* index: 1279 */
	{ 0x1F33, 0x1F3B, 0x1F33, 0x1F3B, { -1, -1, -1 } }, /* index: 1280 */
	{ 0x1F34, 0x1F3C, 0x1F34, 0x1F3C, { -1, -1, -1 } }, /* index: 1281 */
	{ 0x1F35, 0x1F3D, 0x1F35, 0x1F3D, { -1, -1, -1 } }, /* index: 1282 */
	{ 0x1F36, 0x1F3E, 0x1F36, 0x1F3E, { -1, -1, -1 } }, /* index: 1283 */
	{ 0x1F37, 0x1F3F, 0x1F37, 0x1F3F, { -1, -1, -1 } }, /* index: 1284 */
	{ 0x1F38, 0x1F38, 0x1F30, 0x1F38, { -1, -1, -1 } }, /* index: 1285 */
	{ 0x1F39, 0x1F39, 0x1F31, 0x1F39, { -1, -1, -1 } }, /* index: 1286 */
	{ 0x1F3A, 0x1F3A, 0x1F32, 0x1F3A, { -1, -1, -1 } }, /* index: 1287 */
	{ 0x1F3B, 0x1F3B, 0x1F33, 0x1F3B, { -1, -1, -1 } }, /* index: 1288 */
	{ 0x1F3C, 0x1F3C, 0x1F34, 0x1F3C, { -1, -1, -1 } }, /* index: 1289 */
	{ 0x1F3D, 0x1F3D, 0x1F35, 0x1F3D, { -1, -1, -1 } }, /* index: 1290 */
	{ 0x1F3E, 0x1F3E, 0x1F36, 0x1F3E, { -1, -1, -1 } }, /* index: 1291 */
	{ 0x1F3F, 0x1F3F, 0x1F37, 0x1F3F, { -1, -1, -1 } }, /* index: 1292 */
	{ 0x1F40, 0x1F48, 0x1F40, 0x1F48, { -1, -1, -1 } }, /* index: 1293 */
	{ 0x1F41, 0x1F49, 0x1F41, 0x1F49, { -1, -1, -1 } }, /* index: 1294 */
	{ 0x1F42, 0x1F4A, 0x1F42, 0x1F4A, { -1, -1, -1 } }, /* index: 1295 */
	{ 0x1F43, 0x1F4B, 0x1F43, 0x1F4B, { -1, -1, -1 } }, /* index: 1296 */
	{ 0x1F44, 0x1F4C, 0x1F44, 0x1F4C, { -1, -1, -1 } }, /* index: 1297 */
	{ 0x1F45, 0x1F4D, 0x1F45, 0x1F4D, { -1, -1, -1 } }, /* index: 1298 */
	{ 0x1F48, 0x1F48, 0x1F40, 0x1F48, { -1, -1, -1 } }, /* index: 1299 */
	{ 0x1F49, 0x1F49, 0x1F41, 0x1F49, { -1, -1, -1 } }, /* index: 1300 */
	{ 0x1F4A, 0x1F4A, 0x1F42, 0x1F4A, { -1, -1, -1 } }, /* index: 1301 */
	{ 0x1F4B, 0x1F4B, 0x1F43, 0x1F4B, { -1, -1, -1 } }, /* index: 1302 */
	{ 0x1F4C, 0x1F4C, 0x1F44, 0x1F4C, { -1, -1, -1 } }, /* index: 1303 */
	{ 0x1F4D, 0x1F4D, 0x1F45, 0x1F4D, { -1, -1, -1 } }, /* index: 1304 */
	{ 0x1F50, 0x1F50, 0x1F50, 0x1F50, { 24, -1, -1 } }, /* index: 1305 */
	{ 0x1F51, 0x1F59, 0x1F51, 0x1F59, { -1, -1, -1 } }, /* index: 1306 */
	{ 0x1F52, 0x1F52, 0x1F52, 0x1F52, { 25, -1, -1 } }, /* index: 1307 */
	{ 0x1F53, 0x1F5B, 0x1F53, 0x1F5B, { -1, -1, -1 } }, /* index: 1308 */
	{ 0x1F54, 0x1F54, 0x1F54, 0x1F54, { 26, -1, -1 } }, /* index: 1309 */
	{ 0x1F55, 0x1F5D, 0x1F55, 0x1F5D, { -1, -1, -1 } }, /* index: 1310 */
	{ 0x1F56, 0x1F56, 0x1F56, 0x1F56, { 27, -1, -1 } }, /* index: 1311 */
	{ 0x1F57, 0x1F5F, 0x1F57, 0x1F5F, { -1, -1, -1 } }, /* index: 1312 */
	{ 0x1F59, 0x1F59, 0x1F51, 0x1F59, { -1, -1, -1 } }, /* index: 1313 */
	{ 0x1F5B, 0x1F5B, 0x1F53, 0x1F5B, { -1, -1, -1 } }, /* index: 1314 */
	{ 0x1F5D, 0x1F5D, 0x1F55, 0x1F5D, { -1, -1, -1 } }, /* index: 1315 */
	{ 0x1F5F, 0x1F5F, 0x1F57, 0x1F5F, { -1, -1, -1 } }, /* index: 1316 */
	{ 0x1F60, 0x1F68, 0x1F60, 0x1F68, { -1, -1, -1 } }, /* index: 1317 */
	{ 0x1F61, 0x1F69, 0x1F61, 0x1F69, { -1, -1, -1 } }, /* index: 1318 */
	{ 0x1F62, 0x1F6A, 0x1F62, 0x1F6A, { -1, -1, -1 } }, /* index: 1319 */
	{ 0x1F63, 0x1F6B, 0x1F63, 0x1F6B, { -1, -1, -1 } }, /* index: 1320 */
	{ 0x1F64, 0x1F6C, 0x1F64, 0x1F6C, { -1, -1, -1 } }, /* index: 1321 */
	{ 0x1F65, 0x1F6D, 0x1F65, 0x1F6D, { -1, -1, -1 } }, /* index: 1322 */
	{ 0x1F66, 0x1F6E, 0x1F66, 0x1F6E, { -1, -1, -1 } }, /* index: 1323 */
	{ 0x1F67, 0x1F6F, 0x1F67, 0x1F6F, { -1, -1, -1 } }, /* index: 1324 */
	{ 0x1F68, 0x1F68, 0x1F60, 0x1F68, { -1, -1, -1 } }, /* index: 1325 */
	{ 0x1F69, 0x1F69, 0x1F61, 0x1F69, { -1, -1, -1 } }, /* index: 1326 */
	{ 0x1F6A, 0x1F6A, 0x1F62, 0x1F6A, { -1, -1, -1 } }, /* index: 1327 */
	{ 0x1F6B, 0x1F6B, 0x1F63, 0x1F6B, { -1, -1, -1 } }, /* index: 1328 */
	{ 0x1F6C, 0x1F6C, 0x1F64, 0x1F6C, { -1, -1, -1 } }, /* index: 1329 */
	{ 0x1F6D, 0x1F6D, 0x1F65, 0x1F6D, { -1, -1, -1 } }, /* index: 1330 */
	{ 0x1F6E, 0x1F6E, 0x1F66, 0x1F6E, { -1, -1, -1 } }, /* index: 1331 */
	{ 0x1F6F, 0x1F6F, 0x1F67, 0x1F6F, { -1, -1, -1 } }, /* index: 1332 */
	{ 0x1F70, 0x1FBA, 0x1F70, 0x1FBA, { -1, -1, -1 } }, /* index: 1333 */
	{ 0x1F71, 0x1FBB, 0x1F71, 0x1FBB, { -1, -1, -1 } }, /* index: 1334 */
	{ 0x1F72, 0x1FC8, 0x1F72, 0x1FC8, { -1, -1, -1 } }, /* index: 1335 */
	{ 0x1F73, 0x1FC9, 0x1F73, 0x1FC9, { -1, -1, -1 } }, /* index: 1336 */
	{ 0x1F74, 0x1FCA, 0x1F74, 0x1FCA, { -1, -1, -1 } }, /* index: 1337 */
	{ 0x1F75, 0x1FCB, 0x1F75, 0x1FCB, { -1, -1, -1 } }, /* index: 1338 */
	{ 0x1F76, 0x1FDA, 0x1F76, 0x1FDA, { -1, -1, -1 } }, /* index: 1339 */
	{ 0x1F77, 0x1FDB, 0x1F77, 0x1FDB, { -1, -1, -1 } }, /* index: 1340 */
	{ 0x1F78, 0x1FF8, 0x1F78, 0x1FF8, { -1, -1, -1 } }, /* index: 1341 */
	{ 0x1F79, 0x1FF9, 0x1F79, 0x1FF9, { -1, -1, -1 } }, /* index: 1342 */
	{ 0x1F7A, 0x1FEA, 0x1F7A, 0x1FEA, { -1, -1, -1 } }, /* index: 1343 */
	{ 0x1F7B, 0x1FEB, 0x1F7B, 0x1FEB, { -1, -1, -1 } }, /* index: 1344 */
	{ 0x1F7C, 0x1FFA, 0x1F7C, 0x1FFA, { -1, -1, -1 } }, /* index: 1345 */
	{ 0x1F7D, 0x1FFB, 0x1F7D, 0x1FFB, { -1, -1, -1 } }, /* index: 1346 */
	{ 0x1F80, 0x1F88, 0x1F80, 0x1F88, { 40, -1, -1 } }, /* index: 1347 */
	{ 0x1F81, 0x1F89, 0x1F81, 0x1F89, { 41, -1, -1 } }, /* index: 1348 */
	{ 0x1F82, 0x1F8A, 0x1F82, 0x1F8A, { 42, -1, -1 } }, /* index: 1349 */
	{ 0x1F83, 0x1F8B, 0x1F83, 0x1F8B, { 43, -1, -1 } }, /* index: 1350 */
	{ 0x1F84, 0x1F8C, 0x1F84, 0x1F8C, { 44, -1, -1 } }, /* index: 1351 */
	{ 0x1F85, 0x1F8D, 0x1F85, 0x1F8D, { 45, -1, -1 } }, /* index: 1352 */
	{ 0x1F86, 0x1F8E, 0x1F86, 0x1F8E, { 46, -1, -1 } }, /* index: 1353 */
	{ 0x1F87, 0x1F8F, 0x1F87, 0x1F8F, { 47, -1, -1 } }, /* index: 1354 */
	{ 0x1F88, 0x1F88, 0x1F80, 0x1F88, { 48, -1, -1 } }, /* index: 1355 */
	{ 0x1F89, 0x1F89, 0x1F81, 0x1F89, { 49, -1, -1 } }, /* index: 1356 */
	{ 0x1F8A, 0x1F8A, 0x1F82, 0x1F8A, { 50, -1, -1 } }, /* index: 1357 */
	{ 0x1F8B, 0x1F8B, 0x1F83, 0x1F8B, { 51, -1, -1 } }, /* index: 1358 */
	{ 0x1F8C, 0x1F8C, 0x1F84, 0x1F8C, { 52, -1, -1 } }, /* index: 1359 */
	{ 0x1F8D, 0x1F8D, 0x1F85, 0x1F8D, { 53, -1, -1 } }, /* index: 1360 */
	{ 0x1F8E, 0x1F8E, 0x1F86, 0x1F8E, { 54, -1, -1 } }, /* index: 1361 */
	{ 0x1F8F, 0x1F8F, 0x1F87, 0x1F8F, { 55, -1, -1 } }, /* index: 1362 */
	{ 0x1F90, 0x1F98, 0x1F90, 0x1F98, { 56, -1, -1 } }, /* index: 1363 */
	{ 0x1F91, 0x1F99, 0x1F91, 0x1F99, { 57, -1, -1 } }, /* index: 1364 */
	{ 0x1F92, 0x1F9A, 0x1F92, 0x1F9A, { 58, -1, -1 } }, /* index: 1365 */
	{ 0x1F93, 0x1F9B, 0x1F93, 0x1F9B, { 59, -1, -1 } }, /* index: 1366 */
	{ 0x1F94, 0x1F9C, 0x1F94, 0x1F9C, { 60, -1, -1 } }, /* index: 1367 */
	{ 0x1F95, 0x1F9D, 0x1F95, 0x1F9D, { 61, -1, -1 } }, /* index: 1368 */
	{ 0x1F96, 0x1F9E, 0x1F96, 0x1F9E, { 62, -1, -1 } }, /* index: 1369 */
	{ 0x1F97, 0x1F9F, 0x1F97, 0x1F9F, { 63, -1, -1 } }, /* index: 1370 */
	{ 0x1F98, 0x1F98, 0x1F90, 0x1F98, { 64, -1, -1 } }, /* index: 1371 */
	{ 0x1F99, 0x1F99, 0x1F91, 0x1F99, { 65, -1, -1 } }, /* index: 1372 */
	{ 0x1F9A, 0x1F9A, 0x1F92, 0x1F9A, { 66, -1, -1 } }, /* index: 1373 */
	{ 0x1F9B, 0x1F9B, 0x1F93, 0x1F9B, { 67, -1, -1 } }, /* index: 1374 */
	{ 0x1F9C, 0x1F9C, 0x1F94, 0x1F9C, { 68, -1, -1 } }, /* index: 1375 */
	{ 0x1F9D, 0x1F9D, 0x1F95, 0x1F9D, { 69, -1, -1 } }, /* index: 1376 */
	{ 0x1F9E, 0x1F9E, 0x1F96, 0x1F9E, { 70, -1, -1 } }, /* index: 1377 */
	{ 0x1F9F, 0x1F9F, 0x1F97, 0x1F9F, { 71, -1, -1 } }, /* index: 1378 */
	{ 0x1FA0, 0x1FA8, 0x1FA0, 0x1FA8, { 72, -1, -1 } }, /* index: 1379 */
	{ 0x1FA1, 0x1FA9, 0x1FA1, 0x1FA9, { 73, -1, -1 } }, /* index: 1380 */
	{ 0x1FA2, 0x1FAA, 0x1FA2, 0x1FAA, { 74, -1, -1 } }, /* index: 1381 */
	{ 0x1FA3, 0x1FAB, 0x1FA3, 0x1FAB, { 75, -1, -1 } }, /* index: 1382 */
	{ 0x1FA4, 0x1FAC, 0x1FA4, 0x1FAC, { 76, -1, -1 } }, /* index: 1383 */
	{ 0x1FA5, 0x1FAD, 0x1FA5, 0x1FAD, { 77, -1, -1 } }, /* index: 1384 */
	{ 0x1FA6, 0x1FAE, 0x1FA6, 0x1FAE, { 78, -1, -1 } }, /* index: 1385 */
	{ 0x1FA7, 0x1FAF, 0x1FA7, 0x1FAF, { 79, -1, -1 } }, /* index: 1386 */
	{ 0x1FA8, 0x1FA8, 0x1FA0, 0x1FA8, { 80, -1, -1 } }, /* index: 1387 */
	{ 0x1FA9, 0x1FA9, 0x1FA1, 0x1FA9, { 81, -1, -1 } }, /* index: 1388 */
	{ 0x1FAA, 0x1FAA, 0x1FA2, 0x1FAA, { 82, -1, -1 } }, /* index: 1389 */
	{ 0x1FAB, 0x1FAB, 0x1FA3, 0x1FAB, { 83, -1, -1 } }, /* index: 1390 */
	{ 0x1FAC, 0x1FAC, 0x1FA4, 0x1FAC, { 84, -1, -1 } }, /* index: 1391 */
	{ 0x1FAD, 0x1FAD, 0x1FA5, 0x1FAD, { 85, -1, -1 } }, /* index: 1392 */
	{ 0x1FAE, 0x1FAE, 0x1FA6, 0x1FAE, { 86, -1, -1 } }, /* index: 1393 */
	{ 0x1FAF, 0x1FAF, 0x1FA7, 0x1FAF, { 87, -1, -1 } }, /* index: 1394 */
	{ 0x1FB0, 0x1FB8, 0x1FB0, 0x1FB8, { -1, -1, -1 } }, /* index: 1395 */
	{ 0x1FB1, 0x1FB9, 0x1FB1, 0x1FB9, { -1, -1, -1 } }, /* index: 1396 */
	{ 0x1FB2, 0x1FB2, 0x1FB2, 0x1FB2, { 94, -1, -1 } }, /* index: 1397 */
	{ 0x1FB3, 0x1FBC, 0x1FB3, 0x1FBC, { 88, -1, -1 } }, /* index: 1398 */
	{ 0x1FB4, 0x1FB4, 0x1FB4, 0x1FB4, { 95, -1, -1 } }, /* index: 1399 */
	{ 0x1FB6, 0x1FB6, 0x1FB6, 0x1FB6, { 28, -1, -1 } }, /* index: 1400 */
	{ 0x1FB7, 0x1FB7, 0x1FB7, 0x1FB7, { 100, -1, -1 } }, /* index: 1401 */
	{ 0x1FB8, 0x1FB8, 0x1FB0, 0x1FB8, { -1, -1, -1 } }, /* index: 1402 */
	{ 0x1FB9, 0x1FB9, 0x1FB1, 0x1FB9, { -1, -1, -1 } }, /* index: 1403 */
	{ 0x1FBA, 0x1FBA, 0x1F70, 0x1FBA, { -1, -1, -1 } }, /* index: 1404 */
	{ 0x1FBB, 0x1FBB, 0x1F71, 0x1FBB, { -1, -1, -1 } }, /* index: 1405 */
	{ 0x1FBC, 0x1FBC, 0x1FB3, 0x1FBC, { 89, -1, -1 } }, /* index: 1406 */
	{ 0x1FBE, 0x0399, 0x1FBE, 0x0399, { -1, -1, -1 } }, /* index: 1407 */
	{ 0x1FC2, 0x1FC2, 0x1FC2, 0x1FC2, { 96, -1, -1 } }, /* index: 1408 */
	{ 0x1FC3, 0x1FCC, 0x1FC3, 0x1FCC, { 90, -1, -1 } }, /* index: 1409 */
	{ 0x1FC4, 0x1FC4, 0x1FC4, 0x1FC4, { 97, -1, -1 } }, /* index: 1410 */
	{ 0x1FC6, 0x1FC6, 0x1FC6, 0x1FC6, { 29, -1, -1 } }, /* index: 1411 */
	{ 0x1FC7, 0x1FC7, 0x1FC7, 0x1FC7, { 101, -1, -1 } }, /* index: 1412 */
	{ 0x1FC8, 0x1FC8, 0x1F72, 0x1FC8, { -1, -1, -1 } }, /* index: 1413 */
	{ 0x1FC9, 0x1FC9, 0x1F73, 0x1FC9, { -1, -1, -1 } }, /* index: 1414 */
	{ 0x1FCA, 0x1FCA, 0x1F74, 0x1FCA, { -1, -1, -1 } }, /* index: 1415 */
	{ 0x1FCB, 0x1FCB, 0x1F75, 0x1FCB, { -1, -1, -1 } }, /* index: 1416 */
	{ 0x1FCC, 0x1FCC, 0x1FC3, 0x1FCC, { 91, -1, -1 } }, /* index: 1417 */
	{ 0x1FD0, 0x1FD8, 0x1FD0, 0x1FD8, { -1, -1, -1 } }, /* index: 1418 */
	{ 0x1FD1, 0x1FD9, 0x1FD1, 0x1FD9, { -1, -1, -1 } }, /* index: 1419 */
	{ 0x1FD2, 0x1FD2, 0x1FD2, 0x1FD2, { 30, -1, -1 } }, /* index: 1420 */
	{ 0x1FD3, 0x1FD3, 0x1FD3, 0x1FD3, { 31, -1, -1 } }, /* index: 1421 */
	{ 0x1FD6, 0x1FD6, 0x1FD6, 0x1FD6, { 32, -1, -1 } }, /* index: 1422 */
	{ 0x1FD7, 0x1FD7, 0x1FD7, 0x1FD7, { 33, -1, -1 } }, /* index: 1423 */
	{ 0x1FD8, 0x1FD8, 0x1FD0, 0x1FD8, { -1, -1, -1 } }, /* index: 1424 */
	{ 0x1FD9, 0x1FD9, 0x1FD1, 0x1FD9, { -1, -1, -1 } }, /* index: 1425 */
	{ 0x1FDA, 0x1FDA, 0x1F76, 0x1FDA, { -1, -1, -1 } }, /* index: 1426 */
	{ 0x1FDB, 0x1FDB, 0x1F77, 0x1FDB, { -1, -1, -1 } }, /* index: 1427 */
	{ 0x1FE0, 0x1FE8, 0x1FE0, 0x1FE8, { -1, -1, -1 } }, /* index: 1428 */
	{ 0x1FE1, 0x1FE9, 0x1FE1, 0x1FE9, { -1, -1, -1 } }, /* index: 1429 */
	{ 0x1FE2, 0x1FE2, 0x1FE2, 0x1FE2, { 34, -1, -1 } }, /* index: 1430 */
	{ 0x1FE3, 0x1FE3, 0x1FE3, 0x1FE3, { 35, -1, -1 } }, /* index: 1431 */
	{ 0x1FE4, 0x1FE4, 0x1FE4, 0x1FE4, { 36, -1, -1 } }, /* index: 1432 */
	{ 0x1FE5, 0x1FEC, 0x1FE5, 0x1FEC, { -1, -1, -1 } }, /* index: 1433 */
	{ 0x1FE6, 0x1FE6, 0x1FE6, 0x1FE6, { 37, -1, -1 } }, /* index: 1434 */
	{ 0x1FE7, 0x1FE7, 0x1FE7, 0x1FE7, { 38, -1, -1 } }, /* index: 1435 */
	{ 0x1FE8, 0x1FE8, 0x1FE0, 0x1FE8, { -1, -1, -1 } }, /* index: 1436 */
	{ 0x1FE9, 0x1FE9, 0x1FE1, 0x1FE9, { -1, -1, -1 } }, /* index: 1437 */
	{ 0x1FEA, 0x1FEA, 0x1F7A, 0x1FEA, { -1, -1, -1 } }, /* index: 1438 */
	{ 0x1FEB, 0x1FEB, 0x1F7B, 0x1FEB, { -1, -1, -1 } }, /* index: 1439 */
	{ 0x1FEC, 0x1FEC, 0x1FE5, 0x1FEC, { -1, -1, -1 } }, /* index: 1440 */
	{ 0x1FF2, 0x1FF2, 0x1FF2, 0x1FF2, { 98, -1, -1 } }, /* index: 1441 */
	{ 0x1FF3, 0x1FFC, 0x1FF3, 0x1FFC, { 92, -1, -1 } }, /* index: 1442 */
	{ 0x1FF4, 0x1FF4, 0x1FF4, 0x1FF4, { 99, -1, -1 } }, /* index: 1443 */
	{ 0x1FF6, 0x1FF6, 0x1FF6, 0x1FF6, { 39, -1, -1 } }, /* index: 1444 */
	{ 0x1FF7, 0x1FF7, 0x1FF7, 0x1FF7, { 102, -1, -1 } }, /* index: 1445 */
	{ 0x1FF8, 0x1FF8, 0x1F78, 0x1FF8, { -1, -1, -1 } }, /* index: 1446 */
	{ 0x1FF9, 0x1FF9, 0x1F79, 0x1FF9, { -1, -1, -1 } }, /* index: 1447 */
	{ 0x1FFA, 0x1FFA, 0x1F7C, 0x1FFA, { -1, -1, -1 } }, /* index: 1448 */
	{ 0x1FFB, 0x1FFB, 0x1F7D, 0x1FFB, { -1, -1, -1 } }, /* index: 1449 */
	{ 0x1FFC, 0x1FFC, 0x1FF3, 0x1FFC, { 93, -1, -1 } }, /* index: 1450 */
	{ 0x2126, 0x2126, 0x03C9, 0x2126, { -1, -1, -1 } }, /* index: 1451 */
	{ 0x212A, 0x212A, 0x006B, 0x212A, { -1, -1, -1 } }, /* index: 1452 */
	{ 0x212B, 0x212B, 0x00E5, 0x212B, { -1, -1, -1 } }, /* index: 1453 */
	{ 0x2132, 0x2132, 0x214E, 0x2132, { -1, -1, -1 } }, /* index: 1454 */
	{ 0x214E, 0x2132, 0x214E, 0x2132, { -1, -1, -1 } }, /* index: 1455 */
	{ 0x2160, 0x2160, 0x2170, 0x2160, { -1, -1, -1 } }, /* index: 1456 */
	{ 0x2161, 0x2161, 0x2171, 0x2161, { -1, -1, -1 } }, /* index: 1457 */
	{ 0x2162, 0x2162, 0x2172, 0x2162, { -1, -1, -1 } }, /* index: 1458 */
	{ 0x2163, 0x2163, 0x2173, 0x2163, { -1, -1, -1 } }, /* index: 1459 */
	{ 0x2164, 0x2164, 0x2174, 0x2164, { -1, -1, -1 } }, /* index: 1460 */
	{ 0x2165, 0x2165, 0x2175, 0x2165, { -1, -1, -1 } }, /* index: 1461 */
	{ 0x2166, 0x2166, 0x2176, 0x2166, { -1, -1, -1 } }, /* index: 1462 */
	{ 0x2167, 0x2167, 0x2177, 0x2167, { -1, -1, -1 } }, /* index: 1463 */
	{ 0x2168, 0x2168, 0x2178, 0x2168, { -1, -1, -1 } }, /* index: 1464 */
	{ 0x2169, 0x2169, 0x2179, 0x2169, { -1, -1, -1 } }, /* index: 1465 */
	{ 0x216A, 0x216A, 0x217A, 0x216A, { -1, -1, -1 } }, /* index: 1466 */
	{ 0x216B, 0x216B, 0x217B, 0x216B, { -1, -1, -1 } }, /* index: 1467 */
	{ 0x216C, 0x216C, 0x217C, 0x216C, { -1, -1, -1 } }, /* index: 1468 */
	{ 0x216D, 0x216D, 0x217D, 0x216D, { -1, -1, -1 } }, /* index: 1469 */
	{ 0x216E, 0x216E, 0x217E, 0x216E, { -1, -1, -1 } }, /* index: 1470 */
	{ 0x216F, 0x216F, 0x217F, 0x216F, { -1, -1, -1 } }, /* index: 1471 */
	{ 0x2170, 0x2160, 0x2170, 0x2160, { -1, -1, -1 } }, /* index: 1472 */
	{ 0x2171, 0x2161, 0x2171, 0x2161, { -1, -1, -1 } }, /* index: 1473 */
	{ 0x2172, 0x2162, 0x2172, 0x2162, { -1, -1, -1 } }, /* index: 1474 */
	{ 0x2173, 0x2163, 0x2173, 0x2163, { -1, -1, -1 } }, /* index: 1475 */
	{ 0x2174, 0x2164, 0x2174, 0x2164, { -1, -1, -1 } }, /* index: 1476 */
	{ 0x2175, 0x2165, 0x2175, 0x2165, { -1, -1, -1 } }, /* index: 1477 */
	{ 0x2176, 0x2166, 0x2176, 0x2166, { -1, -1, -1 } }, /* index: 1478 */
	{ 0x2177, 0x2167, 0x2177, 0x2167, { -1, -1, -1 } }, /* index: 1479 */
	{ 0x2178, 0x2168, 0x2178, 0x2168, { -1, -1, -1 } }, /* index: 1480 */
	{ 0x2179, 0x2169, 0x2179, 0x2169, { -1, -1, -1 } }, /* index: 1481 */
	{ 0x217A, 0x216A, 0x217A, 0x216A, { -1, -1, -1 } }, /* index: 1482 */
	{ 0x217B, 0x216B, 0x217B, 0x216B, { -1, -1, -1 } }, /* index: 1483 */
	{ 0x217C, 0x216C, 0x217C, 0x216C, { -1, -1, -1 } }, /* index: 1484 */
	{ 0x217D, 0x216D, 0x217D, 0x216D, { -1, -1, -1 } }, /* index: 1485 */
	{ 0x217E, 0x216E, 0x217E, 0x216E, { -1, -1, -1 } }, /* index: 1486 */
	{ 0x217F, 0x216F, 0x217F, 0x216F, { -1, -1, -1 } }, /* index: 1487 */
	{ 0x2183, 0x2183, 0x2184, 0x2183, { -1, -1, -1 } }, /* index: 1488 */
	{ 0x2184, 0x2183, 0x2184, 0x2183, { -1, -1, -1 } }, /* index: 1489 */
	{ 0x24B6, 0x24B6, 0x24D0, 0x24B6, { -1, -1, -1 } }, /* index: 1490 */
	{ 0x24B7, 0x24B7, 0x24D1, 0x24B7, { -1, -1, -1 } }, /* index: 1491 */
	{ 0x24B8, 0x24B8, 0x24D2, 0x24B8, { -1, -1, -1 } }, /* index: 1492 */
	{ 0x24B9, 0x24B9, 0x24D3, 0x24B9, { -1, -1, -1 } }, /* index: 1493 */
	{ 0x24BA, 0x24BA, 0x24D4, 0x24BA, { -1, -1, -1 } }, /* index: 1494 */
	{ 0x24BB, 0x24BB, 0x24D5, 0x24BB, { -1, -1, -1 } }, /* index: 1495 */
	{ 0x24BC, 0x24BC, 0x24D6, 0x24BC, { -1, -1, -1 } }, /* index: 1496 */
	{ 0x24BD, 0x24BD, 0x24D7, 0x24BD, { -1, -1, -1 } }, /* index: 1497 */
	{ 0x24BE, 0x24BE, 0x24D8, 0x24BE, { -1, -1, -1 } }, /* index: 1498 */
	{ 0x24BF, 0x24BF, 0x24D9, 0x24BF, { -1, -1, -1 } }, /* index: 1499 */
	{ 0x24C0, 0x24C0, 0x24DA, 0x24C0, { -1, -1, -1 } }, /* index: 1500 */
	{ 0x24C1, 0x24C1, 0x24DB, 0x24C1, { -1, -1, -1 } }, /* index: 1501 */
	{ 0x24C2, 0x24C2, 0x24DC, 0x24C2, { -1, -1, -1 } }, /* index: 1502 */
	{ 0x24C3, 0x24C3, 0x24DD, 0x24C3, { -1, -1, -1 } }, /* index: 1503 */
	{ 0x24C4, 0x24C4, 0x24DE, 0x24C4, { -1, -1, -1 } }, /* index: 1504 */
	{ 0x24C5, 0x24C5, 0x24DF, 0x24C5, { -1, -1, -1 } }, /* index: 1505 */
	{ 0x24C6, 0x24C6, 0x24E0, 0x24C6, { -1, -1, -1 } }, /* index: 1506 */
	{ 0x24C7, 0x24C7, 0x24E1, 0x24C7, { -1, -1, -1 } }, /* index: 1507 */
	{ 0x24C8, 0x24C8, 0x24E2, 0x24C8, { -1, -1, -1 } }, /* index: 1508 */
	{ 0x24C9, 0x24C9, 0x24E3, 0x24C9, { -1, -1, -1 } }, /* index: 1509 */
	{ 0x24CA, 0x24CA, 0x24E4, 0x24CA, { -1, -1, -1 } }, /* index: 1510 */
	{ 0x24CB, 0x24CB, 0x24E5, 0x24CB, { -1, -1, -1 } }, /* index: 1511 */
	{ 0x24CC, 0x24CC, 0x24E6, 0x24CC, { -1, -1, -1 } }, /* index: 1512 */
	{ 0x24CD, 0x24CD, 0x24E7, 0x24CD, { -1, -1, -1 } }, /* index: 1513 */
	{ 0x24CE, 0x24CE, 0x24E8, 0x24CE, { -1, -1, -1 } }, /* index: 1514 */
	{ 0x24CF, 0x24CF, 0x24E9, 0x24CF, { -1, -1, -1 } }, /* index: 1515 */
	{ 0x24D0, 0x24B6, 0x24D0, 0x24B6, { -1, -1, -1 } }, /* index: 1516 */
	{ 0x24D1, 0x24B7, 0x24D1, 0x24B7, { -1, -1, -1 } }, /* index: 1517 */
	{ 0x24D2, 0x24B8, 0x24D2, 0x24B8, { -1, -1, -1 } }, /* index: 1518 */
	{ 0x24D3, 0x24B9, 0x24D3, 0x24B9, { -1, -1, -1 } }, /* index: 1519 */
	{ 0x24D4, 0x24BA, 0x24D4, 0x24BA, { -1, -1, -1 } }, /* index: 1520 */
	{ 0x24D5, 0x24BB, 0x24D5, 0x24BB, { -1, -1, -1 } }, /* index: 1521 */
	{ 0x24D6, 0x24BC, 0x24D6, 0x24BC, { -1, -1, -1 } }, /* index: 1522 */
	{ 0x24D7, 0x24BD, 0x24D7, 0x24BD, { -1, -1, -1 } }, /* index: 1523 */
	{ 0x24D8, 0x24BE, 0x24D8, 0x24BE, { -1, -1, -1 } }, /* index: 1524 */
	{ 0x24D9, 0x24BF, 0x24D9, 0x24BF, { -1, -1, -1 } }, /* index: 1525 */
	{ 0x24DA, 0x24C0, 0x24DA, 0x24C0, { -1, -1, -1 } }, /* index: 1526 */
	{ 0x24DB, 0x24C1, 0x24DB, 0x24C1, { -1, -1, -1 } }, /* index: 1527 */
	{ 0x24DC, 0x24C2, 0x24DC, 0x24C2, { -1, -1, -1 } }, /* index: 1528 */
	{ 0x24DD, 0x24C3, 0x24DD, 0x24C3, { -1, -1, -1 } }, /* index: 1529 */
	{ 0x24DE, 0x24C4, 0x24DE, 0x24C4, { -1, -1, -1 } }, /* index: 1530 */
	{ 0x24DF, 0x24C5, 0x24DF, 0x24C5, { -1, -1, -1 } }, /* index: 1531 */
	{ 0x24E0, 0x24C6, 0x24E0, 0x24C6, { -1, -1, -1 } }, /* index: 1532 */
	{ 0x24E1, 0x24C7, 0x24E1, 0x24C7, { -1, -1, -1 } }, /* index: 1533 */
	{ 0x24E2, 0x24C8, 0x24E2, 0x24C8, { -1, -1, -1 } }, /* index: 1534 */
	{ 0x24E3, 0x24C9, 0x24E3, 0x24C9, { -1, -1, -1 } }, /* index: 1535 */
	{ 0x24E4, 0x24CA, 0x24E4, 0x24CA, { -1, -1, -1 } }, /* index: 1536 */
	{ 0x24E5, 0x24CB, 0x24E5, 0x24CB, { -1, -1, -1 } }, /* index: 1537 */
	{ 0x24E6, 0x24CC, 0x24E6, 0x24CC, { -1, -1, -1 } }, /* index: 1538 */
	{ 0x24E7, 0x24CD, 0x24E7, 0x24CD, { -1, -1, -1 } }, /* index: 1539 */
	{ 0x24E8, 0x24CE, 0x24E8, 0x24CE, { -1, -1, -1 } }, /* index: 1540 */
	{ 0x24E9, 0x24CF, 0x24E9, 0x24CF, { -1, -1, -1 } }, /* index: 1541 */
	{ 0x2C00, 0x2C00, 0x2C30, 0x2C00, { -1, -1, -1 } }, /* index: 1542 */
	{ 0x2C01, 0x2C01, 0x2C31, 0x2C01, { -1, -1, -1 } }, /* index: 1543 */
	{ 0x2C02, 0x2C02, 0x2C32, 0x2C02, { -1, -1, -1 } }, /* index: 1544 */
	{ 0x2C03, 0x2C03, 0x2C33, 0x2C03, { -1, -1, -1 } }, /* index: 1545 */
	{ 0x2C04, 0x2C04, 0x2C34, 0x2C04, { -1, -1, -1 } }, /* index: 1546 */
	{ 0x2C05, 0x2C05, 0x2C35, 0x2C05, { -1, -1, -1 } }, /* index: 1547 */
	{ 0x2C06, 0x2C06, 0x2C36, 0x2C06, { -1, -1, -1 } }, /* index: 1548 */
	{ 0x2C07, 0x2C07, 0x2C37, 0x2C07, { -1, -1, -1 } }, /* index: 1549 */
	{ 0x2C08, 0x2C08, 0x2C38, 0x2C08, { -1, -1, -1 } }, /* index: 1550 */
	{ 0x2C09, 0x2C09, 0x2C39, 0x2C09, { -1, -1, -1 } }, /* index: 1551 */
	{ 0x2C0A, 0x2C0A, 0x2C3A, 0x2C0A, { -1, -1, -1 } }, /* index: 1552 */
	{ 0x2C0B, 0x2C0B, 0x2C3B, 0x2C0B, { -1, -1, -1 } }, /* index: 1553 */
	{ 0x2C0C, 0x2C0C, 0x2C3C, 0x2C0C, { -1, -1, -1 } }, /* index: 1554 */
	{ 0x2C0D, 0x2C0D, 0x2C3D, 0x2C0D, { -1, -1, -1 } }, /* index: 1555 */
	{ 0x2C0E, 0x2C0E, 0x2C3E, 0x2C0E, { -1, -1, -1 } }, /* index: 1556 */
	{ 0x2C0F, 0x2C0F, 0x2C3F, 0x2C0F, { -1, -1, -1 } }, /* index: 1557 */
	{ 0x2C10, 0x2C10, 0x2C40, 0x2C10, { -1, -1, -1 } }, /* index: 1558 */
	{ 0x2C11, 0x2C11, 0x2C41, 0x2C11, { -1, -1, -1 } }, /* index: 1559 */
	{ 0x2C12, 0x2C12, 0x2C42, 0x2C12, { -1, -1, -1 } }, /* index: 1560 */
	{ 0x2C13, 0x2C13, 0x2C43, 0x2C13, { -1, -1, -1 } }, /* index: 1561 */
	{ 0x2C14, 0x2C14, 0x2C44, 0x2C14, { -1, -1, -1 } }, /* index: 1562 */
	{ 0x2C15, 0x2C15, 0x2C45, 0x2C15, { -1, -1, -1 } }, /* index: 1563 */
	{ 0x2C16, 0x2C16, 0x2C46, 0x2C16, { -1, -1, -1 } }, /* index: 1564 */
	{ 0x2C17, 0x2C17, 0x2C47, 0x2C17, { -1, -1, -1 } }, /* index: 1565 */
	{ 0x2C18, 0x2C18, 0x2C48, 0x2C18, { -1, -1, -1 } }, /* index: 1566 */
	{ 0x2C19, 0x2C19, 0x2C49, 0x2C19, { -1, -1, -1 } }, /* index: 1567 */
	{ 0x2C1A, 0x2C1A, 0x2C4A, 0x2C1A, { -1, -1, -1 } }, /* index: 1568 */
	{ 0x2C1B, 0x2C1B, 0x2C4B, 0x2C1B, { -1, -1, -1 } }, /* index: 1569 */
	{ 0x2C1C, 0x2C1C, 0x2C4C, 0x2C1C, { -1, -1, -1 } }, /* index: 1570 */
	{ 0x2C1D, 0x2C1D, 0x2C4D, 0x2C1D, { -1, -1, -1 } }, /* index: 1571 */
	{ 0x2C1E, 0x2C1E, 0x2C4E, 0x2C1E, { -1, -1, -1 } }, /* index: 1572 */
	{ 0x2C1F, 0x2C1F, 0x2C4F, 0x2C1F, { -1, -1, -1 } }, /* index: 1573 */
	{ 0x2C20, 0x2C20, 0x2C50, 0x2C20, { -1, -1, -1 } }, /* index: 1574 */
	{ 0x2C21, 0x2C21, 0x2C51, 0x2C21, { -1, -1, -1 } }, /* index: 1575 */
	{ 0x2C22, 0x2C22, 0x2C52, 0x2C22, { -1, -1, -1 } }, /* index: 1576 */
	{ 0x2C23, 0x2C23, 0x2C53, 0x2C23, { -1, -1, -1 } }, /* index: 1577 */
	{ 0x2C24, 0x2C24, 0x2C54, 0x2C24, { -1, -1, -1 } }, /* index: 1578 */
	{ 0x2C25, 0x2C25, 0x2C55, 0x2C25, { -1, -1, -1 } }, /* index: 1579 */
	{ 0x2C26, 0x2C26, 0x2C56, 0x2C26, { -1, -1, -1 } }, /* index: 1580 */
	{ 0x2C27, 0x2C27, 0x2C57, 0x2C27, { -1, -1, -1 } }, /* index: 1581 */
	{ 0x2C28, 0x2C28, 0x2C58, 0x2C28, { -1, -1, -1 } }, /* index: 1582 */
	{ 0x2C29, 0x2C29, 0x2C59, 0x2C29, { -1, -1, -1 } }, /* index: 1583 */
	{ 0x2C2A, 0x2C2A, 0x2C5A, 0x2C2A, { -1, -1, -1 } }, /* index: 1584 */
	{ 0x2C2B, 0x2C2B, 0x2C5B, 0x2C2B, { -1, -1, -1 } }, /* index: 1585 */
	{ 0x2C2C, 0x2C2C, 0x2C5C, 0x2C2C, { -1, -1, -1 } }, /* index: 1586 */
	{ 0x2C2D, 0x2C2D, 0x2C5D, 0x2C2D, { -1, -1, -1 } }, /* index: 1587 */
	{ 0x2C2E, 0x2C2E, 0x2C5E, 0x2C2E, { -1, -1, -1 } }, /* index: 1588 */
	{ 0x2C30, 0x2C00, 0x2C30, 0x2C00, { -1, -1, -1 } }, /* index: 1589 */
	{ 0x2C31, 0x2C01, 0x2C31, 0x2C01, { -1, -1, -1 } }, /* index: 1590 */
	{ 0x2C32, 0x2C02, 0x2C32, 0x2C02, { -1, -1, -1 } }, /* index: 1591 */
	{ 0x2C33, 0x2C03, 0x2C33, 0x2C03, { -1, -1, -1 } }, /* index: 1592 */
	{ 0x2C34, 0x2C04, 0x2C34, 0x2C04, { -1, -1, -1 } }, /* index: 1593 */
	{ 0x2C35, 0x2C05, 0x2C35, 0x2C05, { -1, -1, -1 } }, /* index: 1594 */
	{ 0x2C36, 0x2C06, 0x2C36, 0x2C06, { -1, -1, -1 } }, /* index: 1595 */
	{ 0x2C37, 0x2C07, 0x2C37, 0x2C07, { -1, -1, -1 } }, /* index: 1596 */
	{ 0x2C38, 0x2C08, 0x2C38, 0x2C08, { -1, -1, -1 } }, /* index: 1597 */
	{ 0x2C39, 0x2C09, 0x2C39, 0x2C09, { -1, -1, -1 } }, /* index: 1598 */
	{ 0x2C3A, 0x2C0A, 0x2C3A, 0x2C0A, { -1, -1, -1 } }, /* index: 1599 */
	{ 0x2C3B, 0x2C0B, 0x2C3B, 0x2C0B, { -1, -1, -1 } }, /* index: 1600 */
	{ 0x2C3C, 0x2C0C, 0x2C3C, 0x2C0C, { -1, -1, -1 } }, /* index: 1601 */
	{ 0x2C3D, 0x2C0D, 0x2C3D, 0x2C0D, { -1, -1, -1 } }, /* index: 1602 */
	{ 0x2C3E, 0x2C0E, 0x2C3E, 0x2C0E, { -1, -1, -1 } }, /* index: 1603 */
	{ 0x2C3F, 0x2C0F, 0x2C3F, 0x2C0F, { -1, -1, -1 } }, /* index: 1604 */
	{ 0x2C40, 0x2C10, 0x2C40, 0x2C10, { -1, -1, -1 } }, /* index: 1605 */
	{ 0x2C41, 0x2C11, 0x2C41, 0x2C11, { -1, -1, -1 } }, /* index: 1606 */
	{ 0x2C42, 0x2C12, 0x2C42, 0x2C12, { -1, -1, -1 } }, /* index: 1607 */
	{ 0x2C43, 0x2C13, 0x2C43, 0x2C13, { -1, -1, -1 } }, /* index: 1608 */
	{ 0x2C44, 0x2C14, 0x2C44, 0x2C14, { -1, -1, -1 } }, /* index: 1609 */
	{ 0x2C45, 0x2C15, 0x2C45, 0x2C15, { -1, -1, -1 } }, /* index: 1610 */
	{ 0x2C46, 0x2C16, 0x2C46, 0x2C16, { -1, -1, -1 } }, /* index: 1611 */
	{ 0x2C47, 0x2C17, 0x2C47, 0x2C17, { -1, -1, -1 } }, /* index: 1612 */
	{ 0x2C48, 0x2C18, 0x2C48, 0x2C18, { -1, -1, -1 } }, /* index: 1613 */
	{ 0x2C49, 0x2C19, 0x2C49, 0x2C19, { -1, -1, -1 } }, /* index: 1614 */
	{ 0x2C4A, 0x2C1A, 0x2C4A, 0x2C1A, { -1, -1, -1 } }, /* index: 1615 */
	{ 0x2C4B, 0x2C1B, 0x2C4B, 0x2C1B, { -1, -1, -1 } }, /* index: 1616 */
	{ 0x2C4C, 0x2C1C, 0x2C4C, 0x2C1C, { -1, -1, -1 } }, /* index: 1617 */
	{ 0x2C4D, 0x2C1D, 0x2C4D, 0x2C1D, { -1, -1, -1 } }, /* index: 1618 */
	{ 0x2C4E, 0x2C1E, 0x2C4E, 0x2C1E, { -1, -1, -1 } }, /* index: 1619 */
	{ 0x2C4F, 0x2C1F, 0x2C4F, 0x2C1F, { -1, -1, -1 } }, /* index: 1620 */
	{ 0x2C50, 0x2C20, 0x2C50, 0x2C20, { -1, -1, -1 } }, /* index: 1621 */
	{ 0x2C51, 0x2C21, 0x2C51, 0x2C21, { -1, -1, -1 } }, /* index: 1622 */
	{ 0x2C52, 0x2C22, 0x2C52, 0x2C22, { -1, -1, -1 } }, /* index: 1623 */
	{ 0x2C53, 0x2C23, 0x2C53, 0x2C23, { -1, -1, -1 } }, /* index: 1624 */
	{ 0x2C54, 0x2C24, 0x2C54, 0x2C24, { -1, -1, -1 } }, /* index: 1625 */
	{ 0x2C55, 0x2C25, 0x2C55, 0x2C25, { -1, -1, -1 } }, /* index: 1626 */
	{ 0x2C56, 0x2C26, 0x2C56, 0x2C26, { -1, -1, -1 } }, /* index: 1627 */
	{ 0x2C57, 0x2C27, 0x2C57, 0x2C27, { -1, -1, -1 } }, /* index: 1628 */
	{ 0x2C58, 0x2C28, 0x2C58, 0x2C28, { -1, -1, -1 } }, /* index: 1629 */
	{ 0x2C59, 0x2C29, 0x2C59, 0x2C29, { -1, -1, -1 } }, /* index: 1630 */
	{ 0x2C5A, 0x2C2A, 0x2C5A, 0x2C2A, { -1, -1, -1 } }, /* index: 1631 */
	{ 0x2C5B, 0x2C2B, 0x2C5B, 0x2C2B, { -1, -1, -1 } }, /* index: 1632 */
	{ 0x2C5C, 0x2C2C, 0x2C5C, 0x2C2C, { -1, -1, -1 } }, /* index: 1633 */
	{ 0x2C5D, 0x2C2D, 0x2C5D, 0x2C2D, { -1, -1, -1 } }, /* index: 1634 */
	{ 0x2C5E, 0x2C2E, 0x2C5E, 0x2C2E, { -1, -1, -1 } }, /* index: 1635 */
	{ 0x2C60, 0x2C60, 0x2C61, 0x2C60, { -1, -1, -1 } }, /* index: 1636 */
	{ 0x2C61, 0x2C60, 0x2C61, 0x2C60, { -1, -1, -1 } }, /* index: 1637 */
	{ 0x2C62, 0x2C62, 0x026B, 0x2C62, { -1, -1, -1 } }, /* index: 1638 */
	{ 0x2C63, 0x2C63, 0x1D7D, 0x2C63, { -1, -1, -1 } }, /* index: 1639 */
	{ 0x2C64, 0x2C64, 0x027D, 0x2C64, { -1, -1, -1 } }, /* index: 1640 */
	{ 0x2C65, 0x023A, 0x2C65, 0x023A, { -1, -1, -1 } }, /* index: 1641 */
	{ 0x2C66, 0x023E, 0x2C66, 0x023E, { -1, -1, -1 } }, /* index: 1642 */
	{ 0x2C67, 0x2C67, 0x2C68, 0x2C67, { -1, -1, -1 } }, /* index: 1643 */
	{ 0x2C68, 0x2C67, 0x2C68, 0x2C67, { -1, -1, -1 } }, /* index: 1644 */
	{ 0x2C69, 0x2C69, 0x2C6A, 0x2C69, { -1, -1, -1 } }, /* index: 1645 */
	{ 0x2C6A, 0x2C69, 0x2C6A, 0x2C69, { -1, -1, -1 } }, /* index: 1646 */
	{ 0x2C6B, 0x2C6B, 0x2C6C, 0x2C6B, { -1, -1, -1 } }, /* index: 1647 */
	{ 0x2C6C, 0x2C6B, 0x2C6C, 0x2C6B, { -1, -1, -1 } }, /* index: 1648 */
	{ 0x2C6D, 0x2C6D, 0x0251, 0x2C6D, { -1, -1, -1 } }, /* index: 1649 */
	{ 0x2C6E, 0x2C6E, 0x0271, 0x2C6E, { -1, -1, -1 } }, /* index: 1650 */
	{ 0x2C6F, 0x2C6F, 0x0250, 0x2C6F, { -1, -1, -1 } }, /* index: 1651 */
	{ 0x2C72, 0x2C72, 0x2C73, 0x2C72, { -1, -1, -1 } }, /* index: 1652 */
	{ 0x2C73, 0x2C72, 0x2C73, 0x2C72, { -1, -1, -1 } }, /* index: 1653 */
	{ 0x2C75, 0x2C75, 0x2C76, 0x2C75, { -1, -1, -1 } }, /* index: 1654 */
	{ 0x2C76, 0x2C75, 0x2C76, 0x2C75, { -1, -1, -1 } }, /* index: 1655 */
	{ 0x2C80, 0x2C80, 0x2C81, 0x2C80, { -1, -1, -1 } }, /* index: 1656 */
	{ 0x2C81, 0x2C80, 0x2C81, 0x2C80, { -1, -1, -1 } }, /* index: 1657 */
	{ 0x2C82, 0x2C82, 0x2C83, 0x2C82, { -1, -1, -1 } }, /* index: 1658 */
	{ 0x2C83, 0x2C82, 0x2C83, 0x2C82, { -1, -1, -1 } }, /* index: 1659 */
	{ 0x2C84, 0x2C84, 0x2C85, 0x2C84, { -1, -1, -1 } }, /* index: 1660 */
	{ 0x2C85, 0x2C84, 0x2C85, 0x2C84, { -1, -1, -1 } }, /* index: 1661 */
	{ 0x2C86, 0x2C86, 0x2C87, 0x2C86, { -1, -1, -1 } }, /* index: 1662 */
	{ 0x2C87, 0x2C86, 0x2C87, 0x2C86, { -1, -1, -1 } }, /* index: 1663 */
	{ 0x2C88, 0x2C88, 0x2C89, 0x2C88, { -1, -1, -1 } }, /* index: 1664 */
	{ 0x2C89, 0x2C88, 0x2C89, 0x2C88, { -1, -1, -1 } }, /* index: 1665 */
	{ 0x2C8A, 0x2C8A, 0x2C8B, 0x2C8A, { -1, -1, -1 } }, /* index: 1666 */
	{ 0x2C8B, 0x2C8A, 0x2C8B, 0x2C8A, { -1, -1, -1 } }, /* index: 1667 */
	{ 0x2C8C, 0x2C8C, 0x2C8D, 0x2C8C, { -1, -1, -1 } }, /* index: 1668 */
	{ 0x2C8D, 0x2C8C, 0x2C8D, 0x2C8C, { -1, -1, -1 } }, /* index: 1669 */
	{ 0x2C8E, 0x2C8E, 0x2C8F, 0x2C8E, { -1, -1, -1 } }, /* index: 1670 */
	{ 0x2C8F, 0x2C8E, 0x2C8F, 0x2C8E, { -1, -1, -1 } }, /* index: 1671 */
	{ 0x2C90, 0x2C90, 0x2C91, 0x2C90, { -1, -1, -1 } }, /* index: 1672 */
	{ 0x2C91, 0x2C90, 0x2C91, 0x2C90, { -1, -1, -1 } }, /* index: 1673 */
	{ 0x2C92, 0x2C92, 0x2C93, 0x2C92, { -1, -1, -1 } }, /* index: 1674 */
	{ 0x2C93, 0x2C92, 0x2C93, 0x2C92, { -1, -1, -1 } }, /* index: 1675 */
	{ 0x2C94, 0x2C94, 0x2C95, 0x2C94, { -1, -1, -1 } }, /* index: 1676 */
	{ 0x2C95, 0x2C94, 0x2C95, 0x2C94, { -1, -1, -1 } }, /* index: 1677 */
	{ 0x2C96, 0x2C96, 0x2C97, 0x2C96, { -1, -1, -1 } }, /* index: 1678 */
	{ 0x2C97, 0x2C96, 0x2C97, 0x2C96, { -1, -1, -1 } }, /* index: 1679 */
	{ 0x2C98, 0x2C98, 0x2C99, 0x2C98, { -1, -1, -1 } }, /* index: 1680 */
	{ 0x2C99, 0x2C98, 0x2C99, 0x2C98, { -1, -1, -1 } }, /* index: 1681 */
	{ 0x2C9A, 0x2C9A, 0x2C9B, 0x2C9A, { -1, -1, -1 } }, /* index: 1682 */
	{ 0x2C9B, 0x2C9A, 0x2C9B, 0x2C9A, { -1, -1, -1 } }, /* index: 1683 */
	{ 0x2C9C, 0x2C9C, 0x2C9D, 0x2C9C, { -1, -1, -1 } }, /* index: 1684 */
	{ 0x2C9D, 0x2C9C, 0x2C9D, 0x2C9C, { -1, -1, -1 } }, /* index: 1685 */
	{ 0x2C9E, 0x2C9E, 0x2C9F, 0x2C9E, { -1, -1, -1 } }, /* index: 1686 */
	{ 0x2C9F, 0x2C9E, 0x2C9F, 0x2C9E, { -1, -1, -1 } }, /* index: 1687 */
	{ 0x2CA0, 0x2CA0, 0x2CA1, 0x2CA0, { -1, -1, -1 } }, /* index: 1688 */
	{ 0x2CA1, 0x2CA0, 0x2CA1, 0x2CA0, { -1, -1, -1 } }, /* index: 1689 */
	{ 0x2CA2, 0x2CA2, 0x2CA3, 0x2CA2, { -1, -1, -1 } }, /* index: 1690 */
	{ 0x2CA3, 0x2CA2, 0x2CA3, 0x2CA2, { -1, -1, -1 } }, /* index: 1691 */
	{ 0x2CA4, 0x2CA4, 0x2CA5, 0x2CA4, { -1, -1, -1 } }, /* index: 1692 */
	{ 0x2CA5, 0x2CA4, 0x2CA5, 0x2CA4, { -1, -1, -1 } }, /* index: 1693 */
	{ 0x2CA6, 0x2CA6, 0x2CA7, 0x2CA6, { -1, -1, -1 } }, /* index: 1694 */
	{ 0x2CA7, 0x2CA6, 0x2CA7, 0x2CA6, { -1, -1, -1 } }, /* index: 1695 */
	{ 0x2CA8, 0x2CA8, 0x2CA9, 0x2CA8, { -1, -1, -1 } }, /* index: 1696 */
	{ 0x2CA9, 0x2CA8, 0x2CA9, 0x2CA8, { -1, -1, -1 } }, /* index: 1697 */
	{ 0x2CAA, 0x2CAA, 0x2CAB, 0x2CAA, { -1, -1, -1 } }, /* index: 1698 */
	{ 0x2CAB, 0x2CAA, 0x2CAB, 0x2CAA, { -1, -1, -1 } }, /* index: 1699 */
	{ 0x2CAC, 0x2CAC, 0x2CAD, 0x2CAC, { -1, -1, -1 } }, /* index: 1700 */
	{ 0x2CAD, 0x2CAC, 0x2CAD, 0x2CAC, { -1, -1, -1 } }, /* index: 1701 */
	{ 0x2CAE, 0x2CAE, 0x2CAF, 0x2CAE, { -1, -1, -1 } }, /* index: 1702 */
	{ 0x2CAF, 0x2CAE, 0x2CAF, 0x2CAE, { -1, -1, -1 } }, /* index: 1703 */
	{ 0x2CB0, 0x2CB0, 0x2CB1, 0x2CB0, { -1, -1, -1 } }, /* index: 1704 */
	{ 0x2CB1, 0x2CB0, 0x2CB1, 0x2CB0, { -1, -1, -1 } }, /* index: 1705 */
	{ 0x2CB2, 0x2CB2, 0x2CB3, 0x2CB2, { -1, -1, -1 } }, /* index: 1706 */
	{ 0x2CB3, 0x2CB2, 0x2CB3, 0x2CB2, { -1, -1, -1 } }, /* index: 1707 */
	{ 0x2CB4, 0x2CB4, 0x2CB5, 0x2CB4, { -1, -1, -1 } }, /* index: 1708 */
	{ 0x2CB5, 0x2CB4, 0x2CB5, 0x2CB4, { -1, -1, -1 } }, /* index: 1709 */
	{ 0x2CB6, 0x2CB6, 0x2CB7, 0x2CB6, { -1, -1, -1 } }, /* index: 1710 */
	{ 0x2CB7, 0x2CB6, 0x2CB7, 0x2CB6, { -1, -1, -1 } }, /* index: 1711 */
	{ 0x2CB8, 0x2CB8, 0x2CB9, 0x2CB8, { -1, -1, -1 } }, /* index: 1712 */
	{ 0x2CB9, 0x2CB8, 0x2CB9, 0x2CB8, { -1, -1, -1 } }, /* index: 1713 */
	{ 0x2CBA, 0x2CBA, 0x2CBB, 0x2CBA, { -1, -1, -1 } }, /* index: 1714 */
	{ 0x2CBB, 0x2CBA, 0x2CBB, 0x2CBA, { -1, -1, -1 } }, /* index: 1715 */
	{ 0x2CBC, 0x2CBC, 0x2CBD, 0x2CBC, { -1, -1, -1 } }, /* index: 1716 */
	{ 0x2CBD, 0x2CBC, 0x2CBD, 0x2CBC, { -1, -1, -1 } }, /* index: 1717 */
	{ 0x2CBE, 0x2CBE, 0x2CBF, 0x2CBE, { -1, -1, -1 } }, /* index: 1718 */
	{ 0x2CBF, 0x2CBE, 0x2CBF, 0x2CBE, { -1, -1, -1 } }, /* index: 1719 */
	{ 0x2CC0, 0x2CC0, 0x2CC1, 0x2CC0, { -1, -1, -1 } }, /* index: 1720 */
	{ 0x2CC1, 0x2CC0, 0x2CC1, 0x2CC0, { -1, -1, -1 } }, /* index: 1721 */
	{ 0x2CC2, 0x2CC2, 0x2CC3, 0x2CC2, { -1, -1, -1 } }, /* index: 1722 */
	{ 0x2CC3, 0x2CC2, 0x2CC3, 0x2CC2, { -1, -1, -1 } }, /* index: 1723 */
	{ 0x2CC4, 0x2CC4, 0x2CC5, 0x2CC4, { -1, -1, -1 } }, /* index: 1724 */
	{ 0x2CC5, 0x2CC4, 0x2CC5, 0x2CC4, { -1, -1, -1 } }, /* index: 1725 */
	{ 0x2CC6, 0x2CC6, 0x2CC7, 0x2CC6, { -1, -1, -1 } }, /* index: 1726 */
	{ 0x2CC7, 0x2CC6, 0x2CC7, 0x2CC6, { -1, -1, -1 } }, /* index: 1727 */
	{ 0x2CC8, 0x2CC8, 0x2CC9, 0x2CC8, { -1, -1, -1 } }, /* index: 1728 */
	{ 0x2CC9, 0x2CC8, 0x2CC9, 0x2CC8, { -1, -1, -1 } }, /* index: 1729 */
	{ 0x2CCA, 0x2CCA, 0x2CCB, 0x2CCA, { -1, -1, -1 } }, /* index: 1730 */
	{ 0x2CCB, 0x2CCA, 0x2CCB, 0x2CCA, { -1, -1, -1 } }, /* index: 1731 */
	{ 0x2CCC, 0x2CCC, 0x2CCD, 0x2CCC, { -1, -1, -1 } }, /* index: 1732 */
	{ 0x2CCD, 0x2CCC, 0x2CCD, 0x2CCC, { -1, -1, -1 } }, /* index: 1733 */
	{ 0x2CCE, 0x2CCE, 0x2CCF, 0x2CCE, { -1, -1, -1 } }, /* index: 1734 */
	{ 0x2CCF, 0x2CCE, 0x2CCF, 0x2CCE, { -1, -1, -1 } }, /* index: 1735 */
	{ 0x2CD0, 0x2CD0, 0x2CD1, 0x2CD0, { -1, -1, -1 } }, /* index: 1736 */
	{ 0x2CD1, 0x2CD0, 0x2CD1, 0x2CD0, { -1, -1, -1 } }, /* index: 1737 */
	{ 0x2CD2, 0x2CD2, 0x2CD3, 0x2CD2, { -1, -1, -1 } }, /* index: 1738 */
	{ 0x2CD3, 0x2CD2, 0x2CD3, 0x2CD2, { -1, -1, -1 } }, /* index: 1739 */
	{ 0x2CD4, 0x2CD4, 0x2CD5, 0x2CD4, { -1, -1, -1 } }, /* index: 1740 */
	{ 0x2CD5, 0x2CD4, 0x2CD5, 0x2CD4, { -1, -1, -1 } }, /* index: 1741 */
	{ 0x2CD6, 0x2CD6, 0x2CD7, 0x2CD6, { -1, -1, -1 } }, /* index: 1742 */
	{ 0x2CD7, 0x2CD6, 0x2CD7, 0x2CD6, { -1, -1, -1 } }, /* index: 1743 */
	{ 0x2CD8, 0x2CD8, 0x2CD9, 0x2CD8, { -1, -1, -1 } }, /* index: 1744 */
	{ 0x2CD9, 0x2CD8, 0x2CD9, 0x2CD8, { -1, -1, -1 } }, /* index: 1745 */
	{ 0x2CDA, 0x2CDA, 0x2CDB, 0x2CDA, { -1, -1, -1 } }, /* index: 1746 */
	{ 0x2CDB, 0x2CDA, 0x2CDB, 0x2CDA, { -1, -1, -1 } }, /* index: 1747 */
	{ 0x2CDC, 0x2CDC, 0x2CDD, 0x2CDC, { -1, -1, -1 } }, /* index: 1748 */
	{ 0x2CDD, 0x2CDC, 0x2CDD, 0x2CDC, { -1, -1, -1 } }, /* index: 1749 */
	{ 0x2CDE, 0x2CDE, 0x2CDF, 0x2CDE, { -1, -1, -1 } }, /* index: 1750 */
	{ 0x2CDF, 0x2CDE, 0x2CDF, 0x2CDE, { -1, -1, -1 } }, /* index: 1751 */
	{ 0x2CE0, 0x2CE0, 0x2CE1, 0x2CE0, { -1, -1, -1 } }, /* index: 1752 */
	{ 0x2CE1, 0x2CE0, 0x2CE1, 0x2CE0, { -1, -1, -1 } }, /* index: 1753 */
	{ 0x2CE2, 0x2CE2, 0x2CE3, 0x2CE2, { -1, -1, -1 } }, /* index: 1754 */
	{ 0x2CE3, 0x2CE2, 0x2CE3, 0x2CE2, { -1, -1, -1 } }, /* index: 1755 */
	{ 0x2D00, 0x10A0, 0x2D00, 0x10A0, { -1, -1, -1 } }, /* index: 1756 */
	{ 0x2D01, 0x10A1, 0x2D01, 0x10A1, { -1, -1, -1 } }, /* index: 1757 */
	{ 0x2D02, 0x10A2, 0x2D02, 0x10A2, { -1, -1, -1 } }, /* index: 1758 */
	{ 0x2D03, 0x10A3, 0x2D03, 0x10A3, { -1, -1, -1 } }, /* index: 1759 */
	{ 0x2D04, 0x10A4, 0x2D04, 0x10A4, { -1, -1, -1 } }, /* index: 1760 */
	{ 0x2D05, 0x10A5, 0x2D05, 0x10A5, { -1, -1, -1 } }, /* index: 1761 */
	{ 0x2D06, 0x10A6, 0x2D06, 0x10A6, { -1, -1, -1 } }, /* index: 1762 */
	{ 0x2D07, 0x10A7, 0x2D07, 0x10A7, { -1, -1, -1 } }, /* index: 1763 */
	{ 0x2D08, 0x10A8, 0x2D08, 0x10A8, { -1, -1, -1 } }, /* index: 1764 */
	{ 0x2D09, 0x10A9, 0x2D09, 0x10A9, { -1, -1, -1 } }, /* index: 1765 */
	{ 0x2D0A, 0x10AA, 0x2D0A, 0x10AA, { -1, -1, -1 } }, /* index: 1766 */
	{ 0x2D0B, 0x10AB, 0x2D0B, 0x10AB, { -1, -1, -1 } }, /* index: 1767 */
	{ 0x2D0C, 0x10AC, 0x2D0C, 0x10AC, { -1, -1, -1 } }, /* index: 1768 */
	{ 0x2D0D, 0x10AD, 0x2D0D, 0x10AD, { -1, -1, -1 } }, /* index: 1769 */
	{ 0x2D0E, 0x10AE, 0x2D0E, 0x10AE, { -1, -1, -1 } }, /* index: 1770 */
	{ 0x2D0F, 0x10AF, 0x2D0F, 0x10AF, { -1, -1, -1 } }, /* index: 1771 */
	{ 0x2D10, 0x10B0, 0x2D10, 0x10B0, { -1, -1, -1 } }, /* index: 1772 */
	{ 0x2D11, 0x10B1, 0x2D11, 0x10B1, { -1, -1, -1 } }, /* index: 1773 */
	{ 0x2D12, 0x10B2, 0x2D12, 0x10B2, { -1, -1, -1 } }, /* index: 1774 */
	{ 0x2D13, 0x10B3, 0x2D13, 0x10B3, { -1, -1, -1 } }, /* index: 1775 */
	{ 0x2D14, 0x10B4, 0x2D14, 0x10B4, { -1, -1, -1 } }, /* index: 1776 */
	{ 0x2D15, 0x10B5, 0x2D15, 0x10B5, { -1, -1, -1 } }, /* index: 1777 */
	{ 0x2D16, 0x10B6, 0x2D16, 0x10B6, { -1, -1, -1 } }, /* index: 1778 */
	{ 0x2D17, 0x10B7, 0x2D17, 0x10B7, { -1, -1, -1 } }, /* index: 1779 */
	{ 0x2D18, 0x10B8, 0x2D18, 0x10B8, { -1, -1, -1 } }, /* index: 1780 */
	{ 0x2D19, 0x10B9, 0x2D19, 0x10B9, { -1, -1, -1 } }, /* index: 1781 */
	{ 0x2D1A, 0x10BA, 0x2D1A, 0x10BA, { -1, -1, -1 } }, /* index: 1782 */
	{ 0x2D1B, 0x10BB, 0x2D1B, 0x10BB, { -1, -1, -1 } }, /* index: 1783 */
	{ 0x2D1C, 0x10BC, 0x2D1C, 0x10BC, { -1, -1, -1 } }, /* index: 1784 */
	{ 0x2D1D, 0x10BD, 0x2D1D, 0x10BD, { -1, -1, -1 } }, /* index: 1785 */
	{ 0x2D1E, 0x10BE, 0x2D1E, 0x10BE, { -1, -1, -1 } }, /* index: 1786 */
	{ 0x2D1F, 0x10BF, 0x2D1F, 0x10BF, { -1, -1, -1 } }, /* index: 1787 */
	{ 0x2D20, 0x10C0, 0x2D20, 0x10C0, { -1, -1, -1 } }, /* index: 1788 */
	{ 0x2D21, 0x10C1, 0x2D21, 0x10C1, { -1, -1, -1 } }, /* index: 1789 */
	{ 0x2D22, 0x10C2, 0x2D22, 0x10C2, { -1, -1, -1 } }, /* index: 1790 */
	{ 0x2D23, 0x10C3, 0x2D23, 0x10C3, { -1, -1, -1 } }, /* index: 1791 */
	{ 0x2D24, 0x10C4, 0x2D24, 0x10C4, { -1, -1, -1 } }, /* index: 1792 */
	{ 0x2D25, 0x10C5, 0x2D25, 0x10C5, { -1, -1, -1 } }, /* index: 1793 */
	{ 0xA640, 0xA640, 0xA641, 0xA640, { -1, -1, -1 } }, /* index: 1794 */
	{ 0xA641, 0xA640, 0xA641, 0xA640, { -1, -1, -1 } }, /* index: 1795 */
	{ 0xA642, 0xA642, 0xA643, 0xA642, { -1, -1, -1 } }, /* index: 1796 */
	{ 0xA643, 0xA642, 0xA643, 0xA642, { -1, -1, -1 } }, /* index: 1797 */
	{ 0xA644, 0xA644, 0xA645, 0xA644, { -1, -1, -1 } }, /* index: 1798 */
	{ 0xA645, 0xA644, 0xA645, 0xA644, { -1, -1, -1 } }, /* index: 1799 */
	{ 0xA646, 0xA646, 0xA647, 0xA646, { -1, -1, -1 } }, /* index: 1800 */
	{ 0xA647, 0xA646, 0xA647, 0xA646, { -1, -1, -1 } }, /* index: 1801 */
	{ 0xA648, 0xA648, 0xA649, 0xA648, { -1, -1, -1 } }, /* index: 1802 */
	{ 0xA649, 0xA648, 0xA649, 0xA648, { -1, -1, -1 } }, /* index: 1803 */
	{ 0xA64A, 0xA64A, 0xA64B, 0xA64A, { -1, -1, -1 } }, /* index: 1804 */
	{ 0xA64B, 0xA64A, 0xA64B, 0xA64A, { -1, -1, -1 } }, /* index: 1805 */
	{ 0xA64C, 0xA64C, 0xA64D, 0xA64C, { -1, -1, -1 } }, /* index: 1806 */
	{ 0xA64D, 0xA64C, 0xA64D, 0xA64C, { -1, -1, -1 } }, /* index: 1807 */
	{ 0xA64E, 0xA64E, 0xA64F, 0xA64E, { -1, -1, -1 } }, /* index: 1808 */
	{ 0xA64F, 0xA64E, 0xA64F, 0xA64E, { -1, -1, -1 } }, /* index: 1809 */
	{ 0xA650, 0xA650, 0xA651, 0xA650, { -1, -1, -1 } }, /* index: 1810 */
	{ 0xA651, 0xA650, 0xA651, 0xA650, { -1, -1, -1 } }, /* index: 1811 */
	{ 0xA652, 0xA652, 0xA653, 0xA652, { -1, -1, -1 } }, /* index: 1812 */
	{ 0xA653, 0xA652, 0xA653, 0xA652, { -1, -1, -1 } }, /* index: 1813 */
	{ 0xA654, 0xA654, 0xA655, 0xA654, { -1, -1, -1 } }, /* index: 1814 */
	{ 0xA655, 0xA654, 0xA655, 0xA654, { -1, -1, -1 } }, /* index: 1815 */
	{ 0xA656, 0xA656, 0xA657, 0xA656, { -1, -1, -1 } }, /* index: 1816 */
	{ 0xA657, 0xA656, 0xA657, 0xA656, { -1, -1, -1 } }, /* index: 1817 */
	{ 0xA658, 0xA658, 0xA659, 0xA658, { -1, -1, -1 } }, /* index: 1818 */
	{ 0xA659, 0xA658, 0xA659, 0xA658, { -1, -1, -1 } }, /* index: 1819 */
	{ 0xA65A, 0xA65A, 0xA65B, 0xA65A, { -1, -1, -1 } }, /* index: 1820 */
	{ 0xA65B, 0xA65A, 0xA65B, 0xA65A, { -1, -1, -1 } }, /* index: 1821 */
	{ 0xA65C, 0xA65C, 0xA65D, 0xA65C, { -1, -1, -1 } }, /* index: 1822 */
	{ 0xA65D, 0xA65C, 0xA65D, 0xA65C, { -1, -1, -1 } }, /* index: 1823 */
	{ 0xA65E, 0xA65E, 0xA65F, 0xA65E, { -1, -1, -1 } }, /* index: 1824 */
	{ 0xA65F, 0xA65E, 0xA65F, 0xA65E, { -1, -1, -1 } }, /* index: 1825 */
	{ 0xA662, 0xA662, 0xA663, 0xA662, { -1, -1, -1 } }, /* index: 1826 */
	{ 0xA663, 0xA662, 0xA663, 0xA662, { -1, -1, -1 } }, /* index: 1827 */
	{ 0xA664, 0xA664, 0xA665, 0xA664, { -1, -1, -1 } }, /* index: 1828 */
	{ 0xA665, 0xA664, 0xA665, 0xA664, { -1, -1, -1 } }, /* index: 1829 */
	{ 0xA666, 0xA666, 0xA667, 0xA666, { -1, -1, -1 } }, /* index: 1830 */
	{ 0xA667, 0xA666, 0xA667, 0xA666, { -1, -1, -1 } }, /* index: 1831 */
	{ 0xA668, 0xA668, 0xA669, 0xA668, { -1, -1, -1 } }, /* index: 1832 */
	{ 0xA669, 0xA668, 0xA669, 0xA668, { -1, -1, -1 } }, /* index: 1833 */
	{ 0xA66A, 0xA66A, 0xA66B, 0xA66A, { -1, -1, -1 } }, /* index: 1834 */
	{ 0xA66B, 0xA66A, 0xA66B, 0xA66A, { -1, -1, -1 } }, /* index: 1835 */
	{ 0xA66C, 0xA66C, 0xA66D, 0xA66C, { -1, -1, -1 } }, /* index: 1836 */
	{ 0xA66D, 0xA66C, 0xA66D, 0xA66C, { -1, -1, -1 } }, /* index: 1837 */
	{ 0xA680, 0xA680, 0xA681, 0xA680, { -1, -1, -1 } }, /* index: 1838 */
	{ 0xA681, 0xA680, 0xA681, 0xA680, { -1, -1, -1 } }, /* index: 1839 */
	{ 0xA682, 0xA682, 0xA683, 0xA682, { -1, -1, -1 } }, /* index: 1840 */
	{ 0xA683, 0xA682, 0xA683, 0xA682, { -1, -1, -1 } }, /* index: 1841 */
	{ 0xA684, 0xA684, 0xA685, 0xA684, { -1, -1, -1 } }, /* index: 1842 */
	{ 0xA685, 0xA684, 0xA685, 0xA684, { -1, -1, -1 } }, /* index: 1843 */
	{ 0xA686, 0xA686, 0xA687, 0xA686, { -1, -1, -1 } }, /* index: 1844 */
	{ 0xA687, 0xA686, 0xA687, 0xA686, { -1, -1, -1 } }, /* index: 1845 */
	{ 0xA688, 0xA688, 0xA689, 0xA688, { -1, -1, -1 } }, /* index: 1846 */
	{ 0xA689, 0xA688, 0xA689, 0xA688, { -1, -1, -1 } }, /* index: 1847 */
	{ 0xA68A, 0xA68A, 0xA68B, 0xA68A, { -1, -1, -1 } }, /* index: 1848 */
	{ 0xA68B, 0xA68A, 0xA68B, 0xA68A, { -1, -1, -1 } }, /* index: 1849 */
	{ 0xA68C, 0xA68C, 0xA68D, 0xA68C, { -1, -1, -1 } }, /* index: 1850 */
	{ 0xA68D, 0xA68C, 0xA68D, 0xA68C, { -1, -1, -1 } }, /* index: 1851 */
	{ 0xA68E, 0xA68E, 0xA68F, 0xA68E, { -1, -1, -1 } }, /* index: 1852 */
	{ 0xA68F, 0xA68E, 0xA68F, 0xA68E, { -1, -1, -1 } }, /* index: 1853 */
	{ 0xA690, 0xA690, 0xA691, 0xA690, { -1, -1, -1 } }, /* index: 1854 */
	{ 0xA691, 0xA690, 0xA691, 0xA690, { -1, -1, -1 } }, /* index: 1855 */
	{ 0xA692, 0xA692, 0xA693, 0xA692, { -1, -1, -1 } }, /* index: 1856 */
	{ 0xA693, 0xA692, 0xA693, 0xA692, { -1, -1, -1 } }, /* index: 1857 */
	{ 0xA694, 0xA694, 0xA695, 0xA694, { -1, -1, -1 } }, /* index: 1858 */
	{ 0xA695, 0xA694, 0xA695, 0xA694, { -1, -1, -1 } }, /* index: 1859 */
	{ 0xA696, 0xA696, 0xA697, 0xA696, { -1, -1, -1 } }, /* index: 1860 */
	{ 0xA697, 0xA696, 0xA697, 0xA696, { -1, -1, -1 } }, /* index: 1861 */
	{ 0xA722, 0xA722, 0xA723, 0xA722, { -1, -1, -1 } }, /* index: 1862 */
	{ 0xA723, 0xA722, 0xA723, 0xA722, { -1, -1, -1 } }, /* index: 1863 */
	{ 0xA724, 0xA724, 0xA725, 0xA724, { -1, -1, -1 } }, /* index: 1864 */
	{ 0xA725, 0xA724, 0xA725, 0xA724, { -1, -1, -1 } }, /* index: 1865 */
	{ 0xA726, 0xA726, 0xA727, 0xA726, { -1, -1, -1 } }, /* index: 1866 */
	{ 0xA727, 0xA726, 0xA727, 0xA726, { -1, -1, -1 } }, /* index: 1867 */
	{ 0xA728, 0xA728, 0xA729, 0xA728, { -1, -1, -1 } }, /* index: 1868 */
	{ 0xA729, 0xA728, 0xA729, 0xA728, { -1, -1, -1 } }, /* index: 1869 */
	{ 0xA72A, 0xA72A, 0xA72B, 0xA72A, { -1, -1, -1 } }, /* index: 1870 */
	{ 0xA72B, 0xA72A, 0xA72B, 0xA72A, { -1, -1, -1 } }, /* index: 1871 */
	{ 0xA72C, 0xA72C, 0xA72D, 0xA72C, { -1, -1, -1 } }, /* index: 1872 */
	{ 0xA72D, 0xA72C, 0xA72D, 0xA72C, { -1, -1, -1 } }, /* index: 1873 */
	{ 0xA72E, 0xA72E, 0xA72F, 0xA72E, { -1, -1, -1 } }, /* index: 1874 */
	{ 0xA72F, 0xA72E, 0xA72F, 0xA72E, { -1, -1, -1 } }, /* index: 1875 */
	{ 0xA732, 0xA732, 0xA733, 0xA732, { -1, -1, -1 } }, /* index: 1876 */
	{ 0xA733, 0xA732, 0xA733, 0xA732, { -1, -1, -1 } }, /* index: 1877 */
	{ 0xA734, 0xA734, 0xA735, 0xA734, { -1, -1, -1 } }, /* index: 1878 */
	{ 0xA735, 0xA734, 0xA735, 0xA734, { -1, -1, -1 } }, /* index: 1879 */
	{ 0xA736, 0xA736, 0xA737, 0xA736, { -1, -1, -1 } }, /* index: 1880 */
	{ 0xA737, 0xA736, 0xA737, 0xA736, { -1, -1, -1 } }, /* index: 1881 */
	{ 0xA738, 0xA738, 0xA739, 0xA738, { -1, -1, -1 } }, /* index: 1882 */
	{ 0xA739, 0xA738, 0xA739, 0xA738, { -1, -1, -1 } }, /* index: 1883 */
	{ 0xA73A, 0xA73A, 0xA73B, 0xA73A, { -1, -1, -1 } }, /* index: 1884 */
	{ 0xA73B, 0xA73A, 0xA73B, 0xA73A, { -1, -1, -1 } }, /* index: 1885 */
	{ 0xA73C, 0xA73C, 0xA73D, 0xA73C, { -1, -1, -1 } }, /* index: 1886 */
	{ 0xA73D, 0xA73C, 0xA73D, 0xA73C, { -1, -1, -1 } }, /* index: 1887 */
	{ 0xA73E, 0xA73E, 0xA73F, 0xA73E, { -1, -1, -1 } }, /* index: 1888 */
	{ 0xA73F, 0xA73E, 0xA73F, 0xA73E, { -1, -1, -1 } }, /* index: 1889 */
	{ 0xA740, 0xA740, 0xA741, 0xA740, { -1, -1, -1 } }, /* index: 1890 */
	{ 0xA741, 0xA740, 0xA741, 0xA740, { -1, -1, -1 } }, /* index: 1891 */
	{ 0xA742, 0xA742, 0xA743, 0xA742, { -1, -1, -1 } }, /* index: 1892 */
	{ 0xA743, 0xA742, 0xA743, 0xA742, { -1, -1, -1 } }, /* index: 1893 */
	{ 0xA744, 0xA744, 0xA745, 0xA744, { -1, -1, -1 } }, /* index: 1894 */
	{ 0xA745, 0xA744, 0xA745, 0xA744, { -1, -1, -1 } }, /* index: 1895 */
	{ 0xA746, 0xA746, 0xA747, 0xA746, { -1, -1, -1 } }, /* index: 1896 */
	{ 0xA747, 0xA746, 0xA747, 0xA746, { -1, -1, -1 } }, /* index: 1897 */
	{ 0xA748, 0xA748, 0xA749, 0xA748, { -1, -1, -1 } }, /* index: 1898 */
	{ 0xA749, 0xA748, 0xA749, 0xA748, { -1, -1, -1 } }, /* index: 1899 */
	{ 0xA74A, 0xA74A, 0xA74B, 0xA74A, { -1, -1, -1 } }, /* index: 1900 */
	{ 0xA74B, 0xA74A, 0xA74B, 0xA74A, { -1, -1, -1 } }, /* index: 1901 */
	{ 0xA74C, 0xA74C, 0xA74D, 0xA74C, { -1, -1, -1 } }, /* index: 1902 */
	{ 0xA74D, 0xA74C, 0xA74D, 0xA74C, { -1, -1, -1 } }, /* index: 1903 */
	{ 0xA74E, 0xA74E, 0xA74F, 0xA74E, { -1, -1, -1 } }, /* index: 1904 */
	{ 0xA74F, 0xA74E, 0xA74F, 0xA74E, { -1, -1, -1 } }, /* index: 1905 */
	{ 0xA750, 0xA750, 0xA751, 0xA750, { -1, -1, -1 } }, /* index: 1906 */
	{ 0xA751, 0xA750, 0xA751, 0xA750, { -1, -1, -1 } }, /* index: 1907 */
	{ 0xA752, 0xA752, 0xA753, 0xA752, { -1, -1, -1 } }, /* index: 1908 */
	{ 0xA753, 0xA752, 0xA753, 0xA752, { -1, -1, -1 } }, /* index: 1909 */
	{ 0xA754, 0xA754, 0xA755, 0xA754, { -1, -1, -1 } }, /* index: 1910 */
	{ 0xA755, 0xA754, 0xA755, 0xA754, { -1, -1, -1 } }, /* index: 1911 */
	{ 0xA756, 0xA756, 0xA757, 0xA756, { -1, -1, -1 } }, /* index: 1912 */
	{ 0xA757, 0xA756, 0xA757, 0xA756, { -1, -1, -1 } }, /* index: 1913 */
	{ 0xA758, 0xA758, 0xA759, 0xA758, { -1, -1, -1 } }, /* index: 1914 */
	{ 0xA759, 0xA758, 0xA759, 0xA758, { -1, -1, -1 } }, /* index: 1915 */
	{ 0xA75A, 0xA75A, 0xA75B, 0xA75A, { -1, -1, -1 } }, /* index: 1916 */
	{ 0xA75B, 0xA75A, 0xA75B, 0xA75A, { -1, -1, -1 } }, /* index: 1917 */
	{ 0xA75C, 0xA75C, 0xA75D, 0xA75C, { -1, -1, -1 } }, /* index: 1918 */
	{ 0xA75D, 0xA75C, 0xA75D, 0xA75C, { -1, -1, -1 } }, /* index: 1919 */
	{ 0xA75E, 0xA75E, 0xA75F, 0xA75E, { -1, -1, -1 } }, /* index: 1920 */
	{ 0xA75F, 0xA75E, 0xA75F, 0xA75E, { -1, -1, -1 } }, /* index: 1921 */
	{ 0xA760, 0xA760, 0xA761, 0xA760, { -1, -1, -1 } }, /* index: 1922 */
	{ 0xA761, 0xA760, 0xA761, 0xA760, { -1, -1, -1 } }, /* index: 1923 */
	{ 0xA762, 0xA762, 0xA763, 0xA762, { -1, -1, -1 } }, /* index: 1924 */
	{ 0xA763, 0xA762, 0xA763, 0xA762, { -1, -1, -1 } }, /* index: 1925 */
	{ 0xA764, 0xA764, 0xA765, 0xA764, { -1, -1, -1 } }, /* index: 1926 */
	{ 0xA765, 0xA764, 0xA765, 0xA764, { -1, -1, -1 } }, /* index: 1927 */
	{ 0xA766, 0xA766, 0xA767, 0xA766, { -1, -1, -1 } }, /* index: 1928 */
	{ 0xA767, 0xA766, 0xA767, 0xA766, { -1, -1, -1 } }, /* index: 1929 */
	{ 0xA768, 0xA768, 0xA769, 0xA768, { -1, -1, -1 } }, /* index: 1930 */
	{ 0xA769, 0xA768, 0xA769, 0xA768, { -1, -1, -1 } }, /* index: 1931 */
	{ 0xA76A, 0xA76A, 0xA76B, 0xA76A, { -1, -1, -1 } }, /* index: 1932 */
	{ 0xA76B, 0xA76A, 0xA76B, 0xA76A, { -1, -1, -1 } }, /* index: 1933 */
	{ 0xA76C, 0xA76C, 0xA76D, 0xA76C, { -1, -1, -1 } }, /* index: 1934 */
	{ 0xA76D, 0xA76C, 0xA76D, 0xA76C, { -1, -1, -1 } }, /* index: 1935 */
	{ 0xA76E, 0xA76E, 0xA76F, 0xA76E, { -1, -1, -1 } }, /* index: 1936 */
	{ 0xA76F, 0xA76E, 0xA76F, 0xA76E, { -1, -1, -1 } }, /* index: 1937 */
	{ 0xA779, 0xA779, 0xA77A, 0xA779, { -1, -1, -1 } }, /* index: 1938 */
	{ 0xA77A, 0xA779, 0xA77A, 0xA779, { -1, -1, -1 } }, /* index: 1939 */
	{ 0xA77B, 0xA77B, 0xA77C, 0xA77B, { -1, -1, -1 } }, /* index: 1940 */
	{ 0xA77C, 0xA77B, 0xA77C, 0xA77B, { -1, -1, -1 } }, /* index: 1941 */
	{ 0xA77D, 0xA77D, 0x1D79, 0xA77D, { -1, -1, -1 } }, /* index: 1942 */
	{ 0xA77E, 0xA77E, 0xA77F, 0xA77E, { -1, -1, -1 } }, /* index: 1943 */
	{ 0xA77F, 0xA77E, 0xA77F, 0xA77E, { -1, -1, -1 } }, /* index: 1944 */
	{ 0xA780, 0xA780, 0xA781, 0xA780, { -1, -1, -1 } }, /* index: 1945 */
	{ 0xA781, 0xA780, 0xA781, 0xA780, { -1, -1, -1 } }, /* index: 1946 */
	{ 0xA782, 0xA782, 0xA783, 0xA782, { -1, -1, -1 } }, /* index: 1947 */
	{ 0xA783, 0xA782, 0xA783, 0xA782, { -1, -1, -1 } }, /* index: 1948 */
	{ 0xA784, 0xA784, 0xA785, 0xA784, { -1, -1, -1 } }, /* index: 1949 */
	{ 0xA785, 0xA784, 0xA785, 0xA784, { -1, -1, -1 } }, /* index: 1950 */
	{ 0xA786, 0xA786, 0xA787, 0xA786, { -1, -1, -1 } }, /* index: 1951 */
	{ 0xA787, 0xA786, 0xA787, 0xA786, { -1, -1, -1 } }, /* index: 1952 */
	{ 0xA78B, 0xA78B, 0xA78C, 0xA78B, { -1, -1, -1 } }, /* index: 1953 */
	{ 0xA78C, 0xA78B, 0xA78C, 0xA78B, { -1, -1, -1 } }, /* index: 1954 */
	{ 0xFB00, 0xFB00, 0xFB00, 0xFB00, { 2, -1, -1 } }, /* index: 1955 */
	{ 0xFB01, 0xFB01, 0xFB01, 0xFB01, { 3, -1, -1 } }, /* index: 1956 */
	{ 0xFB02, 0xFB02, 0xFB02, 0xFB02, { 4, -1, -1 } }, /* index: 1957 */
	{ 0xFB03, 0xFB03, 0xFB03, 0xFB03, { 5, -1, -1 } }, /* index: 1958 */
	{ 0xFB04, 0xFB04, 0xFB04, 0xFB04, { 6, -1, -1 } }, /* index: 1959 */
	{ 0xFB05, 0xFB05, 0xFB05, 0xFB05, { 7, -1, -1 } }, /* index: 1960 */
	{ 0xFB06, 0xFB06, 0xFB06, 0xFB06, { 8, -1, -1 } }, /* index: 1961 */
	{ 0xFB13, 0xFB13, 0xFB13, 0xFB13, { 10, -1, -1 } }, /* index: 1962 */
	{ 0xFB14, 0xFB14, 0xFB14, 0xFB14, { 11, -1, -1 } }, /* index: 1963 */
	{ 0xFB15, 0xFB15, 0xFB15, 0xFB15, { 12, -1, -1 } }, /* index: 1964 */
	{ 0xFB16, 0xFB16, 0xFB16, 0xFB16, { 13, -1, -1 } }, /* index: 1965 */
	{ 0xFB17, 0xFB17, 0xFB17, 0xFB17, { 14, -1, -1 } }, /* index: 1966 */
	{ 0xFF21, 0xFF21, 0xFF41, 0xFF21, { -1, -1, -1 } }, /* index: 1967 */
	{ 0xFF22, 0xFF22, 0xFF42, 0xFF22, { -1, -1, -1 } }, /* index: 1968 */
	{ 0xFF23, 0xFF23, 0xFF43, 0xFF23, { -1, -1, -1 } }, /* index: 1969 */
	{ 0xFF24, 0xFF24, 0xFF44, 0xFF24, { -1, -1, -1 } }, /* index: 1970 */
	{ 0xFF25, 0xFF25, 0xFF45, 0xFF25, { -1, -1, -1 } }, /* index: 1971 */
	{ 0xFF26, 0xFF26, 0xFF46, 0xFF26, { -1, -1, -1 } }, /* index: 1972 */
	{ 0xFF27, 0xFF27, 0xFF47, 0xFF27, { -1, -1, -1 } }, /* index: 1973 */
	{ 0xFF28, 0xFF28, 0xFF48, 0xFF28, { -1, -1, -1 } }, /* index: 1974 */
	{ 0xFF29, 0xFF29, 0xFF49, 0xFF29, { -1, -1, -1 } }, /* index: 1975 */
	{ 0xFF2A, 0xFF2A, 0xFF4A, 0xFF2A, { -1, -1, -1 } }, /* index: 1976 */
	{ 0xFF2B, 0xFF2B, 0xFF4B, 0xFF2B, { -1, -1, -1 } }, /* index: 1977 */
	{ 0xFF2C, 0xFF2C, 0xFF4C, 0xFF2C, { -1, -1, -1 } }, /* index: 1978 */
	{ 0xFF2D, 0xFF2D, 0xFF4D, 0xFF2D, { -1, -1, -1 } }, /* index: 1979 */
	{ 0xFF2E, 0xFF2E, 0xFF4E, 0xFF2E, { -1, -1, -1 } }, /* index: 1980 */
	{ 0xFF2F, 0xFF2F, 0xFF4F, 0xFF2F, { -1, -1, -1 } }, /* index: 1981 */
	{ 0xFF30, 0xFF30, 0xFF50, 0xFF30, { -1, -1, -1 } }, /* index: 1982 */
	{ 0xFF31, 0xFF31, 0xFF51, 0xFF31, { -1, -1, -1 } }, /* index: 1983 */
	{ 0xFF32, 0xFF32, 0xFF52, 0xFF32, { -1, -1, -1 } }, /* index: 1984 */
	{ 0xFF33, 0xFF33, 0xFF53, 0xFF33, { -1, -1, -1 } }, /* index: 1985 */
	{ 0xFF34, 0xFF34, 0xFF54, 0xFF34, { -1, -1, -1 } }, /* index: 1986 */
	{ 0xFF35, 0xFF35, 0xFF55, 0xFF35, { -1, -1, -1 } }, /* index: 1987 */
	{ 0xFF36, 0xFF36, 0xFF56, 0xFF36, { -1, -1, -1 } }, /* index: 1988 */
	{ 0xFF37, 0xFF37, 0xFF57, 0xFF37, { -1, -1, -1 } }, /* index: 1989 */
	{ 0xFF38, 0xFF38, 0xFF58, 0xFF38, { -1, -1, -1 } }, /* index: 1990 */
	{ 0xFF39, 0xFF39, 0xFF59, 0xFF39, { -1, -1, -1 } }, /* index: 1991 */
	{ 0xFF3A, 0xFF3A, 0xFF5A, 0xFF3A, { -1, -1, -1 } }, /* index: 1992 */
	{ 0xFF41, 0xFF21, 0xFF41, 0xFF21, { -1, -1, -1 } }, /* index: 1993 */
	{ 0xFF42, 0xFF22, 0xFF42, 0xFF22, { -1, -1, -1 } }, /* index: 1994 */
	{ 0xFF43, 0xFF23, 0xFF43, 0xFF23, { -1, -1, -1 } }, /* index: 1995 */
	{ 0xFF44, 0xFF24, 0xFF44, 0xFF24, { -1, -1, -1 } }, /* index: 1996 */
	{ 0xFF45, 0xFF25, 0xFF45, 0xFF25, { -1, -1, -1 } }, /* index: 1997 */
	{ 0xFF46, 0xFF26, 0xFF46, 0xFF26, { -1, -1, -1 } }, /* index: 1998 */
	{ 0xFF47, 0xFF27, 0xFF47, 0xFF27, { -1, -1, -1 } }, /* index: 1999 */
	{ 0xFF48, 0xFF28, 0xFF48, 0xFF28, { -1, -1, -1 } }, /* index: 2000 */
	{ 0xFF49, 0xFF29, 0xFF49, 0xFF29, { -1, -1, -1 } }, /* index: 2001 */
	{ 0xFF4A, 0xFF2A, 0xFF4A, 0xFF2A, { -1, -1, -1 } }, /* index: 2002 */
	{ 0xFF4B, 0xFF2B, 0xFF4B, 0xFF2B, { -1, -1, -1 } }, /* index: 2003 */
	{ 0xFF4C, 0xFF2C, 0xFF4C, 0xFF2C, { -1, -1, -1 } }, /* index: 2004 */
	{ 0xFF4D, 0xFF2D, 0xFF4D, 0xFF2D, { -1, -1, -1 } }, /* index: 2005 */
	{ 0xFF4E, 0xFF2E, 0xFF4E, 0xFF2E, { -1, -1, -1 } }, /* index: 2006 */
	{ 0xFF4F, 0xFF2F, 0xFF4F, 0xFF2F, { -1, -1, -1 } }, /* index: 2007 */
	{ 0xFF50, 0xFF30, 0xFF50, 0xFF30, { -1, -1, -1 } }, /* index: 2008 */
	{ 0xFF51, 0xFF31, 0xFF51, 0xFF31, { -1, -1, -1 } }, /* index: 2009 */
	{ 0xFF52, 0xFF32, 0xFF52, 0xFF32, { -1, -1, -1 } }, /* index: 2010 */
	{ 0xFF53, 0xFF33, 0xFF53, 0xFF33, { -1, -1, -1 } }, /* index: 2011 */
	{ 0xFF54, 0xFF34, 0xFF54, 0xFF34, { -1, -1, -1 } }, /* index: 2012 */
	{ 0xFF55, 0xFF35, 0xFF55, 0xFF35, { -1, -1, -1 } }, /* index: 2013 */
	{ 0xFF56, 0xFF36, 0xFF56, 0xFF36, { -1, -1, -1 } }, /* index: 2014 */
	{ 0xFF57, 0xFF37, 0xFF57, 0xFF37, { -1, -1, -1 } }, /* index: 2015 */
	{ 0xFF58, 0xFF38, 0xFF58, 0xFF38, { -1, -1, -1 } }, /* index: 2016 */
	{ 0xFF59, 0xFF39, 0xFF59, 0xFF39, { -1, -1, -1 } }, /* index: 2017 */
	{ 0xFF5A, 0xFF3A, 0xFF5A, 0xFF3A, { -1, -1, -1 } }, /* index: 2018 */
	{ 0x10400, 0x10400, 0x10428, 0x10400, { -1, -1, -1 } }, /* index: 2019 */
	{ 0x10401, 0x10401, 0x10429, 0x10401, { -1, -1, -1 } }, /* index: 2020 */
	{ 0x10402, 0x10402, 0x1042A, 0x10402, { -1, -1, -1 } }, /* index: 2021 */
	{ 0x10403, 0x10403, 0x1042B, 0x10403, { -1, -1, -1 } }, /* index: 2022 */
	{ 0x10404, 0x10404, 0x1042C, 0x10404, { -1, -1, -1 } }, /* index: 2023 */
	{ 0x10405, 0x10405, 0x1042D, 0x10405, { -1, -1, -1 } }, /* index: 2024 */
	{ 0x10406, 0x10406, 0x1042E, 0x10406, { -1, -1, -1 } }, /* index: 2025 */
	{ 0x10407, 0x10407, 0x1042F, 0x10407, { -1, -1, -1 } }, /* index: 2026 */
	{ 0x10408, 0x10408, 0x10430, 0x10408, { -1, -1, -1 } }, /* index: 2027 */
	{ 0x10409, 0x10409, 0x10431, 0x10409, { -1, -1, -1 } }, /* index: 2028 */
	{ 0x1040A, 0x1040A, 0x10432, 0x1040A, { -1, -1, -1 } }, /* index: 2029 */
	{ 0x1040B, 0x1040B, 0x10433, 0x1040B, { -1, -1, -1 } }, /* index: 2030 */
	{ 0x1040C, 0x1040C, 0x10434, 0x1040C, { -1, -1, -1 } }, /* index: 2031 */
	{ 0x1040D, 0x1040D, 0x10435, 0x1040D, { -1, -1, -1 } }, /* index: 2032 */
	{ 0x1040E, 0x1040E, 0x10436, 0x1040E, { -1, -1, -1 } }, /* index: 2033 */
	{ 0x1040F, 0x1040F, 0x10437, 0x1040F, { -1, -1, -1 } }, /* index: 2034 */
	{ 0x10410, 0x10410, 0x10438, 0x10410, { -1, -1, -1 } }, /* index: 2035 */
	{ 0x10411, 0x10411, 0x10439, 0x10411, { -1, -1, -1 } }, /* index: 2036 */
	{ 0x10412, 0x10412, 0x1043A, 0x10412, { -1, -1, -1 } }, /* index: 2037 */
	{ 0x10413, 0x10413, 0x1043B, 0x10413, { -1, -1, -1 } }, /* index: 2038 */
	{ 0x10414, 0x10414, 0x1043C, 0x10414, { -1, -1, -1 } }, /* index: 2039 */
	{ 0x10415, 0x10415, 0x1043D, 0x10415, { -1, -1, -1 } }, /* index: 2040 */
	{ 0x10416, 0x10416, 0x1043E, 0x10416, { -1, -1, -1 } }, /* index: 2041 */
	{ 0x10417, 0x10417, 0x1043F, 0x10417, { -1, -1, -1 } }, /* index: 2042 */
	{ 0x10418, 0x10418, 0x10440, 0x10418, { -1, -1, -1 } }, /* index: 2043 */
	{ 0x10419, 0x10419, 0x10441, 0x10419, { -1, -1, -1 } }, /* index: 2044 */
	{ 0x1041A, 0x1041A, 0x10442, 0x1041A, { -1, -1, -1 } }, /* index: 2045 */
	{ 0x1041B, 0x1041B, 0x10443, 0x1041B, { -1, -1, -1 } }, /* index: 2046 */
	{ 0x1041C, 0x1041C, 0x10444, 0x1041C, { -1, -1, -1 } }, /* index: 2047 */
	{ 0x1041D, 0x1041D, 0x10445, 0x1041D, { -1, -1, -1 } }, /* index: 2048 */
	{ 0x1041E, 0x1041E, 0x10446, 0x1041E, { -1, -1, -1 } }, /* index: 2049 */
	{ 0x1041F, 0x1041F, 0x10447, 0x1041F, { -1, -1, -1 } }, /* index: 2050 */
	{ 0x10420, 0x10420, 0x10448, 0x10420, { -1, -1, -1 } }, /* index: 2051 */
	{ 0x10421, 0x10421, 0x10449, 0x10421, { -1, -1, -1 } }, /* index: 2052 */
	{ 0x10422, 0x10422, 0x1044A, 0x10422, { -1, -1, -1 } }, /* index: 2053 */
	{ 0x10423, 0x10423, 0x1044B, 0x10423, { -1, -1, -1 } }, /* index: 2054 */
	{ 0x10424, 0x10424, 0x1044C, 0x10424, { -1, -1, -1 } }, /* index: 2055 */
	{ 0x10425, 0x10425, 0x1044D, 0x10425, { -1, -1, -1 } }, /* index: 2056 */
	{ 0x10426, 0x10426, 0x1044E, 0x10426, { -1, -1, -1 } }, /* index: 2057 */
	{ 0x10427, 0x10427, 0x1044F, 0x10427, { -1, -1, -1 } }, /* index: 2058 */
	{ 0x10428, 0x10400, 0x10428, 0x10400, { -1, -1, -1 } }, /* index: 2059 */
	{ 0x10429, 0x10401, 0x10429, 0x10401, { -1, -1, -1 } }, /* index: 2060 */
	{ 0x1042A, 0x10402, 0x1042A, 0x10402, { -1, -1, -1 } }, /* index: 2061 */
	{ 0x1042B, 0x10403, 0x1042B, 0x10403, { -1, -1, -1 } }, /* index: 2062 */
	{ 0x1042C, 0x10404, 0x1042C, 0x10404, { -1, -1, -1 } }, /* index: 2063 */
	{ 0x1042D, 0x10405, 0x1042D, 0x10405, { -1, -1, -1 } }, /* index: 2064 */
	{ 0x1042E, 0x10406, 0x1042E, 0x10406, { -1, -1, -1 } }, /* index: 2065 */
	{ 0x1042F, 0x10407, 0x1042F, 0x10407, { -1, -1, -1 } }, /* index: 2066 */
	{ 0x10430, 0x10408, 0x10430, 0x10408, { -1, -1, -1 } }, /* index: 2067 */
	{ 0x10431, 0x10409, 0x10431, 0x10409, { -1, -1, -1 } }, /* index: 2068 */
	{ 0x10432, 0x1040A, 0x10432, 0x1040A, { -1, -1, -1 } }, /* index: 2069 */
	{ 0x10433, 0x1040B, 0x10433, 0x1040B, { -1, -1, -1 } }, /* index: 2070 */
	{ 0x10434, 0x1040C, 0x10434, 0x1040C, { -1, -1, -1 } }, /* index: 2071 */
	{ 0x10435, 0x1040D, 0x10435, 0x1040D, { -1, -1, -1 } }, /* index: 2072 */
	{ 0x10436, 0x1040E, 0x10436, 0x1040E, { -1, -1, -1 } }, /* index: 2073 */
	{ 0x10437, 0x1040F, 0x10437, 0x1040F, { -1, -1, -1 } }, /* index: 2074 */
	{ 0x10438, 0x10410, 0x10438, 0x10410, { -1, -1, -1 } }, /* index: 2075 */
	{ 0x10439, 0x10411, 0x10439, 0x10411, { -1, -1, -1 } }, /* index: 2076 */
	{ 0x1043A, 0x10412, 0x1043A, 0x10412, { -1, -1, -1 } }, /* index: 2077 */
	{ 0x1043B, 0x10413, 0x1043B, 0x10413, { -1, -1, -1 } }, /* index: 2078 */
	{ 0x1043C, 0x10414, 0x1043C, 0x10414, { -1, -1, -1 } }, /* index: 2079 */
	{ 0x1043D, 0x10415, 0x1043D, 0x10415, { -1, -1, -1 } }, /* index: 2080 */
	{ 0x1043E, 0x10416, 0x1043E, 0x10416, { -1, -1, -1 } }, /* index: 2081 */
	{ 0x1043F, 0x10417, 0x1043F, 0x10417, { -1, -1, -1 } }, /* index: 2082 */
	{ 0x10440, 0x10418, 0x10440, 0x10418, { -1, -1, -1 } }, /* index: 2083 */
	{ 0x10441, 0x10419, 0x10441, 0x10419, { -1, -1, -1 } }, /* index: 2084 */
	{ 0x10442, 0x1041A, 0x10442, 0x1041A, { -1, -1, -1 } }, /* index: 2085 */
	{ 0x10443, 0x1041B, 0x10443, 0x1041B, { -1, -1, -1 } }, /* index: 2086 */
	{ 0x10444, 0x1041C, 0x10444, 0x1041C, { -1, -1, -1 } }, /* index: 2087 */
	{ 0x10445, 0x1041D, 0x10445, 0x1041D, { -1, -1, -1 } }, /* index: 2088 */
	{ 0x10446, 0x1041E, 0x10446, 0x1041E, { -1, -1, -1 } }, /* index: 2089 */
	{ 0x10447, 0x1041F, 0x10447, 0x1041F, { -1, -1, -1 } }, /* index: 2090 */
	{ 0x10448, 0x10420, 0x10448, 0x10420, { -1, -1, -1 } }, /* index: 2091 */
	{ 0x10449, 0x10421, 0x10449, 0x10421, { -1, -1, -1 } }, /* index: 2092 */
	{ 0x1044A, 0x10422, 0x1044A, 0x10422, { -1, -1, -1 } }, /* index: 2093 */
	{ 0x1044B, 0x10423, 0x1044B, 0x10423, { -1, -1, -1 } }, /* index: 2094 */
	{ 0x1044C, 0x10424, 0x1044C, 0x10424, { -1, -1, -1 } }, /* index: 2095 */
	{ 0x1044D, 0x10425, 0x1044D, 0x10425, { -1, -1, -1 } }, /* index: 2096 */
	{ 0x1044E, 0x10426, 0x1044E, 0x10426, { -1, -1, -1 } }, /* index: 2097 */
	{ 0x1044F, 0x10427, 0x1044F, 0x10427, { -1, -1, -1 } }, /* index: 2098 */
};


/* Array containing the list of different intervals related to case information
 *  in the Unicode Character Database. */
static unicode_case_interval_t unicode_case_int[UCD_C_INT_N] = {
  { 0x000041, 0x00005A, 65 }, /* index: 0 */
  { 0x000061, 0x00007A, 71 }, /* index: 1 */
  { 0x0000B5, 0x0000B5, 129 }, /* index: 2 */
  { 0x0000C0, 0x0000D6, 139 }, /* index: 3 */
  { 0x0000D8, 0x0000F6, 140 }, /* index: 4 */
  { 0x0000F8, 0x000137, 141 }, /* index: 5 */
  { 0x000139, 0x00018C, 142 }, /* index: 6 */
  { 0x00018E, 0x00019A, 143 }, /* index: 7 */
  { 0x00019C, 0x0001A9, 144 }, /* index: 8 */
  { 0x0001AC, 0x0001B9, 146 }, /* index: 9 */
  { 0x0001BC, 0x0001BD, 148 }, /* index: 10 */
  { 0x0001BF, 0x0001BF, 149 }, /* index: 11 */
  { 0x0001C4, 0x000220, 153 }, /* index: 12 */
  { 0x000222, 0x000233, 154 }, /* index: 13 */
  { 0x00023A, 0x00023E, 160 }, /* index: 14 */
  { 0x000241, 0x000251, 162 }, /* index: 15 */
  { 0x000253, 0x000254, 163 }, /* index: 16 */
  { 0x000256, 0x000257, 164 }, /* index: 17 */
  { 0x000259, 0x000259, 165 }, /* index: 18 */
  { 0x00025B, 0x00025B, 166 }, /* index: 19 */
  { 0x000260, 0x000260, 170 }, /* index: 20 */
  { 0x000263, 0x000263, 172 }, /* index: 21 */
  { 0x000268, 0x000269, 176 }, /* index: 22 */
  { 0x00026B, 0x00026B, 177 }, /* index: 23 */
  { 0x00026F, 0x00026F, 180 }, /* index: 24 */
  { 0x000271, 0x000272, 181 }, /* index: 25 */
  { 0x000275, 0x000275, 183 }, /* index: 26 */
  { 0x00027D, 0x00027D, 190 }, /* index: 27 */
  { 0x000280, 0x000280, 192 }, /* index: 28 */
  { 0x000283, 0x000283, 194 }, /* index: 29 */
  { 0x000288, 0x00028C, 198 }, /* index: 30 */
  { 0x000292, 0x000292, 203 }, /* index: 31 */
  { 0x000307, 0x000307, 319 }, /* index: 32 */
  { 0x000345, 0x000345, 380 }, /* index: 33 */
  { 0x000370, 0x000373, 422 }, /* index: 34 */
  { 0x000376, 0x000377, 424 }, /* index: 35 */
  { 0x00037B, 0x00037D, 427 }, /* index: 36 */
  { 0x000386, 0x000386, 435 }, /* index: 37 */
  { 0x000388, 0x00038A, 436 }, /* index: 38 */
  { 0x00038C, 0x00038C, 437 }, /* index: 39 */
  { 0x00038E, 0x0003A1, 438 }, /* index: 40 */
  { 0x0003A3, 0x0003D1, 439 }, /* index: 41 */
  { 0x0003D5, 0x0003F2, 442 }, /* index: 42 */
  { 0x0003F4, 0x0003F5, 443 }, /* index: 43 */
  { 0x0003F7, 0x0003FB, 444 }, /* index: 44 */
  { 0x0003FD, 0x000481, 445 }, /* index: 45 */
  { 0x00048A, 0x000523, 453 }, /* index: 46 */
  { 0x000531, 0x000556, 466 }, /* index: 47 */
  { 0x000561, 0x000587, 476 }, /* index: 48 */
  { 0x0010A0, 0x0010C5, 3316 }, /* index: 49 */
  { 0x001D79, 0x001D79, 6567 }, /* index: 50 */
  { 0x001D7D, 0x001D7D, 6570 }, /* index: 51 */
  { 0x001E00, 0x001E9B, 6700 }, /* index: 52 */
  { 0x001E9E, 0x001E9E, 6702 }, /* index: 53 */
  { 0x001EA0, 0x001F15, 6703 }, /* index: 54 */
  { 0x001F18, 0x001F1D, 6705 }, /* index: 55 */
  { 0x001F20, 0x001F45, 6707 }, /* index: 56 */
  { 0x001F48, 0x001F4D, 6709 }, /* index: 57 */
  { 0x001F50, 0x001F57, 6711 }, /* index: 58 */
  { 0x001F59, 0x001F59, 6712 }, /* index: 59 */
  { 0x001F5B, 0x001F5B, 6713 }, /* index: 60 */
  { 0x001F5D, 0x001F5D, 6714 }, /* index: 61 */
  { 0x001F5F, 0x001F7D, 6715 }, /* index: 62 */
  { 0x001F80, 0x001FB4, 6717 }, /* index: 63 */
  { 0x001FB6, 0x001FBC, 6718 }, /* index: 64 */
  { 0x001FBE, 0x001FBE, 6719 }, /* index: 65 */
  { 0x001FC2, 0x001FC4, 6722 }, /* index: 66 */
  { 0x001FC6, 0x001FCC, 6723 }, /* index: 67 */
  { 0x001FD0, 0x001FD3, 6726 }, /* index: 68 */
  { 0x001FD6, 0x001FDB, 6728 }, /* index: 69 */
  { 0x001FE0, 0x001FEC, 6732 }, /* index: 70 */
  { 0x001FF2, 0x001FF4, 6737 }, /* index: 71 */
  { 0x001FF6, 0x001FFC, 6738 }, /* index: 72 */
  { 0x002126, 0x002126, 7035 }, /* index: 73 */
  { 0x00212A, 0x00212B, 7038 }, /* index: 74 */
  { 0x002132, 0x002132, 7044 }, /* index: 75 */
  { 0x00214E, 0x00214E, 7071 }, /* index: 76 */
  { 0x002160, 0x00217F, 7088 }, /* index: 77 */
  { 0x002183, 0x002184, 7091 }, /* index: 78 */
  { 0x0024B6, 0x0024E9, 7908 }, /* index: 79 */
  { 0x002C00, 0x002C2E, 9722 }, /* index: 80 */
  { 0x002C30, 0x002C5E, 9723 }, /* index: 81 */
  { 0x002C60, 0x002C6F, 9724 }, /* index: 82 */
  { 0x002C72, 0x002C73, 9726 }, /* index: 83 */
  { 0x002C75, 0x002C76, 9727 }, /* index: 84 */
  { 0x002C80, 0x002CE3, 9736 }, /* index: 85 */
  { 0x002D00, 0x002D25, 9764 }, /* index: 86 */
  { 0x00A640, 0x00A65F, 40766 }, /* index: 87 */
  { 0x00A662, 0x00A66D, 40768 }, /* index: 88 */
  { 0x00A680, 0x00A697, 40786 }, /* index: 89 */
  { 0x00A722, 0x00A72F, 40924 }, /* index: 90 */
  { 0x00A732, 0x00A76F, 40926 }, /* index: 91 */
  { 0x00A779, 0x00A787, 40935 }, /* index: 92 */
  { 0x00A78B, 0x00A78C, 40938 }, /* index: 93 */
  { 0x00FB00, 0x00FB06, 62301 }, /* index: 94 */
  { 0x00FB13, 0x00FB17, 62313 }, /* index: 95 */
  { 0x00FF21, 0x00FF3A, 63346 }, /* index: 96 */
  { 0x00FF41, 0x00FF5A, 63352 }, /* index: 97 */
  { 0x010400, 0x01044F, 64541 }, /* index: 98 */
};


/* Array containing the special case information for each unicode point (really 
 *  only for those which actually have some special case information) */
static unicode_special_case_info_t unicode_special_case_info[UCD_SC_INFO_N] = {
  {  /* index: 0 */ 
    0x00DF,
    { 0x00DF, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0053, 0x0053, 0x0000 }, /* uppercase */ 
    { 0x0053, 0x0073, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 1 */ 
    0x0130,
    { 0x0069, 0x0307, 0x0000 }, /* lowercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 2 */ 
    0xFB00,
    { 0xFB00, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0046, 0x0046, 0x0000 }, /* uppercase */ 
    { 0x0046, 0x0066, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 3 */ 
    0xFB01,
    { 0xFB01, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0046, 0x0049, 0x0000 }, /* uppercase */ 
    { 0x0046, 0x0069, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 4 */ 
    0xFB02,
    { 0xFB02, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0046, 0x004C, 0x0000 }, /* uppercase */ 
    { 0x0046, 0x006C, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 5 */ 
    0xFB03,
    { 0xFB03, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0046, 0x0046, 0x0049 }, /* uppercase */ 
    { 0x0046, 0x0066, 0x0069 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 6 */ 
    0xFB04,
    { 0xFB04, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0046, 0x0046, 0x004C }, /* uppercase */ 
    { 0x0046, 0x0066, 0x006C }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 7 */ 
    0xFB05,
    { 0xFB05, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0053, 0x0054, 0x0000 }, /* uppercase */ 
    { 0x0053, 0x0074, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 8 */ 
    0xFB06,
    { 0xFB06, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0053, 0x0054, 0x0000 }, /* uppercase */ 
    { 0x0053, 0x0074, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 9 */ 
    0x0587,
    { 0x0587, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0535, 0x0552, 0x0000 }, /* uppercase */ 
    { 0x0535, 0x0582, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 10 */ 
    0xFB13,
    { 0xFB13, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0544, 0x0546, 0x0000 }, /* uppercase */ 
    { 0x0544, 0x0576, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 11 */ 
    0xFB14,
    { 0xFB14, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0544, 0x0535, 0x0000 }, /* uppercase */ 
    { 0x0544, 0x0565, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 12 */ 
    0xFB15,
    { 0xFB15, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0544, 0x053B, 0x0000 }, /* uppercase */ 
    { 0x0544, 0x056B, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 13 */ 
    0xFB16,
    { 0xFB16, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x054E, 0x0546, 0x0000 }, /* uppercase */ 
    { 0x054E, 0x0576, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 14 */ 
    0xFB17,
    { 0xFB17, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0544, 0x053D, 0x0000 }, /* uppercase */ 
    { 0x0544, 0x056D, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 15 */ 
    0x0149,
    { 0x0149, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x02BC, 0x004E, 0x0000 }, /* uppercase */ 
    { 0x02BC, 0x004E, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 16 */ 
    0x0390,
    { 0x0390, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0399, 0x0308, 0x0301 }, /* uppercase */ 
    { 0x0399, 0x0308, 0x0301 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 17 */ 
    0x03B0,
    { 0x03B0, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0308, 0x0301 }, /* uppercase */ 
    { 0x03A5, 0x0308, 0x0301 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 18 */ 
    0x01F0,
    { 0x01F0, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x004A, 0x030C, 0x0000 }, /* uppercase */ 
    { 0x004A, 0x030C, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 19 */ 
    0x1E96,
    { 0x1E96, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0048, 0x0331, 0x0000 }, /* uppercase */ 
    { 0x0048, 0x0331, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 20 */ 
    0x1E97,
    { 0x1E97, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0054, 0x0308, 0x0000 }, /* uppercase */ 
    { 0x0054, 0x0308, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 21 */ 
    0x1E98,
    { 0x1E98, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0057, 0x030A, 0x0000 }, /* uppercase */ 
    { 0x0057, 0x030A, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 22 */ 
    0x1E99,
    { 0x1E99, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0059, 0x030A, 0x0000 }, /* uppercase */ 
    { 0x0059, 0x030A, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 23 */ 
    0x1E9A,
    { 0x1E9A, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0041, 0x02BE, 0x0000 }, /* uppercase */ 
    { 0x0041, 0x02BE, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 24 */ 
    0x1F50,
    { 0x1F50, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0313, 0x0000 }, /* uppercase */ 
    { 0x03A5, 0x0313, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 25 */ 
    0x1F52,
    { 0x1F52, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0313, 0x0300 }, /* uppercase */ 
    { 0x03A5, 0x0313, 0x0300 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 26 */ 
    0x1F54,
    { 0x1F54, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0313, 0x0301 }, /* uppercase */ 
    { 0x03A5, 0x0313, 0x0301 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 27 */ 
    0x1F56,
    { 0x1F56, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0313, 0x0342 }, /* uppercase */ 
    { 0x03A5, 0x0313, 0x0342 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 28 */ 
    0x1FB6,
    { 0x1FB6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0391, 0x0342, 0x0000 }, /* uppercase */ 
    { 0x0391, 0x0342, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 29 */ 
    0x1FC6,
    { 0x1FC6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0397, 0x0342, 0x0000 }, /* uppercase */ 
    { 0x0397, 0x0342, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 30 */ 
    0x1FD2,
    { 0x1FD2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0399, 0x0308, 0x0300 }, /* uppercase */ 
    { 0x0399, 0x0308, 0x0300 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 31 */ 
    0x1FD3,
    { 0x1FD3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0399, 0x0308, 0x0301 }, /* uppercase */ 
    { 0x0399, 0x0308, 0x0301 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 32 */ 
    0x1FD6,
    { 0x1FD6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0399, 0x0342, 0x0000 }, /* uppercase */ 
    { 0x0399, 0x0342, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 33 */ 
    0x1FD7,
    { 0x1FD7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0399, 0x0308, 0x0342 }, /* uppercase */ 
    { 0x0399, 0x0308, 0x0342 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 34 */ 
    0x1FE2,
    { 0x1FE2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0308, 0x0300 }, /* uppercase */ 
    { 0x03A5, 0x0308, 0x0300 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 35 */ 
    0x1FE3,
    { 0x1FE3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0308, 0x0301 }, /* uppercase */ 
    { 0x03A5, 0x0308, 0x0301 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 36 */ 
    0x1FE4,
    { 0x1FE4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A1, 0x0313, 0x0000 }, /* uppercase */ 
    { 0x03A1, 0x0313, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 37 */ 
    0x1FE6,
    { 0x1FE6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0342, 0x0000 }, /* uppercase */ 
    { 0x03A5, 0x0342, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 38 */ 
    0x1FE7,
    { 0x1FE7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A5, 0x0308, 0x0342 }, /* uppercase */ 
    { 0x03A5, 0x0308, 0x0342 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 39 */ 
    0x1FF6,
    { 0x1FF6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A9, 0x0342, 0x0000 }, /* uppercase */ 
    { 0x03A9, 0x0342, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 40 */ 
    0x1F80,
    { 0x1F80, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F08, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F88, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 41 */ 
    0x1F81,
    { 0x1F81, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F09, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F89, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 42 */ 
    0x1F82,
    { 0x1F82, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8A, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 43 */ 
    0x1F83,
    { 0x1F83, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8B, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 44 */ 
    0x1F84,
    { 0x1F84, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8C, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 45 */ 
    0x1F85,
    { 0x1F85, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8D, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 46 */ 
    0x1F86,
    { 0x1F86, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8E, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 47 */ 
    0x1F87,
    { 0x1F87, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8F, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 48 */ 
    0x1F88,
    { 0x1F80, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F08, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F88, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 49 */ 
    0x1F89,
    { 0x1F81, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F09, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F89, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 50 */ 
    0x1F8A,
    { 0x1F82, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8A, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 51 */ 
    0x1F8B,
    { 0x1F83, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8B, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 52 */ 
    0x1F8C,
    { 0x1F84, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8C, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 53 */ 
    0x1F8D,
    { 0x1F85, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8D, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 54 */ 
    0x1F8E,
    { 0x1F86, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8E, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 55 */ 
    0x1F8F,
    { 0x1F87, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F0F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F8F, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 56 */ 
    0x1F90,
    { 0x1F90, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F28, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F98, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 57 */ 
    0x1F91,
    { 0x1F91, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F29, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F99, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 58 */ 
    0x1F92,
    { 0x1F92, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9A, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 59 */ 
    0x1F93,
    { 0x1F93, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9B, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 60 */ 
    0x1F94,
    { 0x1F94, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9C, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 61 */ 
    0x1F95,
    { 0x1F95, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9D, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 62 */ 
    0x1F96,
    { 0x1F96, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9E, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 63 */ 
    0x1F97,
    { 0x1F97, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9F, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 64 */ 
    0x1F98,
    { 0x1F90, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F28, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F98, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 65 */ 
    0x1F99,
    { 0x1F91, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F29, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F99, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 66 */ 
    0x1F9A,
    { 0x1F92, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9A, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 67 */ 
    0x1F9B,
    { 0x1F93, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9B, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 68 */ 
    0x1F9C,
    { 0x1F94, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9C, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 69 */ 
    0x1F9D,
    { 0x1F95, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9D, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 70 */ 
    0x1F9E,
    { 0x1F96, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9E, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 71 */ 
    0x1F9F,
    { 0x1F97, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F2F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1F9F, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 72 */ 
    0x1FA0,
    { 0x1FA0, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F68, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FA8, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 73 */ 
    0x1FA1,
    { 0x1FA1, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F69, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FA9, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 74 */ 
    0x1FA2,
    { 0x1FA2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAA, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 75 */ 
    0x1FA3,
    { 0x1FA3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAB, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 76 */ 
    0x1FA4,
    { 0x1FA4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 77 */ 
    0x1FA5,
    { 0x1FA5, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAD, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 78 */ 
    0x1FA6,
    { 0x1FA6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAE, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 79 */ 
    0x1FA7,
    { 0x1FA7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAF, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 80 */ 
    0x1FA8,
    { 0x1FA0, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F68, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FA8, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 81 */ 
    0x1FA9,
    { 0x1FA1, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F69, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FA9, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 82 */ 
    0x1FAA,
    { 0x1FA2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6A, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAA, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 83 */ 
    0x1FAB,
    { 0x1FA3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6B, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAB, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 84 */ 
    0x1FAC,
    { 0x1FA4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6C, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 85 */ 
    0x1FAD,
    { 0x1FA5, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6D, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAD, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 86 */ 
    0x1FAE,
    { 0x1FA6, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6E, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAE, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 87 */ 
    0x1FAF,
    { 0x1FA7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1F6F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FAF, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 88 */ 
    0x1FB3,
    { 0x1FB3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0391, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FBC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 89 */ 
    0x1FBC,
    { 0x1FB3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0391, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FBC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 90 */ 
    0x1FC3,
    { 0x1FC3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0397, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FCC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 91 */ 
    0x1FCC,
    { 0x1FC3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0397, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FCC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 92 */ 
    0x1FF3,
    { 0x1FF3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A9, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FFC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 93 */ 
    0x1FFC,
    { 0x1FF3, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A9, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FFC, 0x0000, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 94 */ 
    0x1FB2,
    { 0x1FB2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1FBA, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FBA, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 95 */ 
    0x1FB4,
    { 0x1FB4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0386, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x0386, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 96 */ 
    0x1FC2,
    { 0x1FC2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1FCA, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FCA, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 97 */ 
    0x1FC4,
    { 0x1FC4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0389, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x0389, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 98 */ 
    0x1FF2,
    { 0x1FF2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x1FFA, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x1FFA, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 99 */ 
    0x1FF4,
    { 0x1FF4, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x038F, 0x0399, 0x0000 }, /* uppercase */ 
    { 0x038F, 0x0345, 0x0000 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 100 */ 
    0x1FB7,
    { 0x1FB7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0391, 0x0342, 0x0399 }, /* uppercase */ 
    { 0x0391, 0x0342, 0x0345 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 101 */ 
    0x1FC7,
    { 0x1FC7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0397, 0x0342, 0x0399 }, /* uppercase */ 
    { 0x0397, 0x0342, 0x0345 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 102 */ 
    0x1FF7,
    { 0x1FF7, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A9, 0x0342, 0x0399 }, /* uppercase */ 
    { 0x03A9, 0x0342, 0x0345 }, /* titlecase */ 
    "" /* conditions */ 
  },
  {  /* index: 103 */ 
    0x03A3,
    { 0x03C2, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x03A3, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x03A3, 0x0000, 0x0000 }, /* titlecase */ 
    "Final_Sigma" /* conditions */ 
  },
  {  /* index: 104 */ 
    0x0307,
    { 0x0307, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0000, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0000, 0x0000, 0x0000 }, /* titlecase */ 
    "lt After_Soft_Dotted" /* conditions */ 
  },
  {  /* index: 105 */ 
    0x0049,
    { 0x0069, 0x0307, 0x0000 }, /* lowercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* titlecase */ 
    "lt More_Above" /* conditions */ 
  },
  {  /* index: 106 */ 
    0x004A,
    { 0x006A, 0x0307, 0x0000 }, /* lowercase */ 
    { 0x004A, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x004A, 0x0000, 0x0000 }, /* titlecase */ 
    "lt More_Above" /* conditions */ 
  },
  {  /* index: 107 */ 
    0x012E,
    { 0x012F, 0x0307, 0x0000 }, /* lowercase */ 
    { 0x012E, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x012E, 0x0000, 0x0000 }, /* titlecase */ 
    "lt More_Above" /* conditions */ 
  },
  {  /* index: 108 */ 
    0x00CC,
    { 0x0069, 0x0307, 0x0300 }, /* lowercase */ 
    { 0x00CC, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x00CC, 0x0000, 0x0000 }, /* titlecase */ 
    "lt" /* conditions */ 
  },
  {  /* index: 109 */ 
    0x00CD,
    { 0x0069, 0x0307, 0x0301 }, /* lowercase */ 
    { 0x00CD, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x00CD, 0x0000, 0x0000 }, /* titlecase */ 
    "lt" /* conditions */ 
  },
  {  /* index: 110 */ 
    0x0128,
    { 0x0069, 0x0307, 0x0303 }, /* lowercase */ 
    { 0x0128, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0128, 0x0000, 0x0000 }, /* titlecase */ 
    "lt" /* conditions */ 
  },
  {  /* index: 111 */ 
    0x0130,
    { 0x0069, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* titlecase */ 
    "tr" /* conditions */ 
  },
  {  /* index: 112 */ 
    0x0130,
    { 0x0069, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* titlecase */ 
    "az" /* conditions */ 
  },
  {  /* index: 113 */ 
    0x0307,
    { 0x0000, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0307, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0307, 0x0000, 0x0000 }, /* titlecase */ 
    "tr After_I" /* conditions */ 
  },
  {  /* index: 114 */ 
    0x0307,
    { 0x0000, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0307, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0307, 0x0000, 0x0000 }, /* titlecase */ 
    "az After_I" /* conditions */ 
  },
  {  /* index: 115 */ 
    0x0049,
    { 0x0131, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* titlecase */ 
    "tr Not_Before_Dot" /* conditions */ 
  },
  {  /* index: 116 */ 
    0x0049,
    { 0x0131, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0049, 0x0000, 0x0000 }, /* titlecase */ 
    "az Not_Before_Dot" /* conditions */ 
  },
  {  /* index: 117 */ 
    0x0069,
    { 0x0069, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* titlecase */ 
    "tr" /* conditions */ 
  },
  {  /* index: 118 */ 
    0x0069,
    { 0x0069, 0x0000, 0x0000 }, /* lowercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* uppercase */ 
    { 0x0130, 0x0000, 0x0000 }, /* titlecase */ 
    "az" /* conditions */ 
  },
};


/***************** END OF SELF-GENERATED DATA *********************************/


/* Final_Sigma condition in Special Case algorithms
 *  When the given character is preceded by a sequence consisting of a
 *  cased unicode point (with case information) and a case-ignorable
 *  (without case information) sequence of points. The given character
 *  must no be followed by a sequence consisting of a case-ignorable
 *  sequence and a cased letter. */
static pdf_bool_t
pdf_text_ucd_Final_Sigma(const pdf_text_ucd_context_t *context)
{
  pdf_char_t *walker;
  short stop;
  int n_case_ignorable;
  int cased_found;

  if((context->unicode_point < context->context_start) || \
     (context->unicode_point > context->context_stop))
    {
      PDF_DEBUG_BASE("Unicode point outside context interval");
      /* The unicode point must not be outside the context interval */
      return PDF_FALSE;
    }

  if(context->unicode_point == context->context_start)
    {
      /* If the unicode point is the start of the context, then it is impossible
       *  to have a sequence before it */
      return PDF_FALSE;
    }

  /*----- Check backward -----*/
  
  n_case_ignorable = 0;
  walker = (pdf_char_t *)(context->unicode_point - 4); 
  stop = 0;
  cased_found = 0;
  while(!stop)
    {
      if(walker < context->context_start)
        {
          /* Arrived to context start, stop loop */
          stop = 1;
        }
      else
        {
          pdf_u32_t aux_point;
          memcpy(&aux_point, walker, 4);
          if(pdf_text_ucd_is_case_ignorable(aux_point))
            {
              n_case_ignorable++;
            }
          else if(pdf_text_ucd_is_cased(aux_point))
            {
              cased_found = 1;  /* Cased char found, stop loop */
              stop = 1;
            }
          if(!stop)
            {
              walker -= 4; /* Point to previous UTF-32 char */
            }
        }
    }
  
  /* Check status of previous characters */ 
  if((cased_found == 1) && \
     (n_case_ignorable >= 0))
    {
      /*----- Check forward -----*/
      
      walker = (pdf_char_t *)(context->unicode_point + 4); 
      stop = 0;
      cased_found = 0;
      n_case_ignorable = 0;
      while(!stop)
        {
          if(walker > context->context_stop)
            {
              /* Arrived to context end, stop loop */
              stop = 1;
            }
          else
            {
              pdf_u32_t aux_point;
              memcpy(&aux_point, walker, 4);
              if(pdf_text_ucd_is_case_ignorable(aux_point))
                {
                  n_case_ignorable++;
                }
              else if(pdf_text_ucd_is_cased(aux_point))
                {
                  cased_found = 1;  /* Cased char found, stop loop */
                  stop = 1;
                }
              if(!stop)
                {
                  walker += 4; /* Point to next UTF-32 char */
                }
            }
        }
      
      /* Check status of next characters */ 
      if((cased_found == 0) && \
         (n_case_ignorable == 0))
        {
          return PDF_TRUE;
        }
    }

  return PDF_FALSE;
}


/* After_Soft_Dotted condition in Special Case algorithms
 *  There is a character with the Soft_Dotted property before the character to
 *  convert, with no intervening character of combining class 0 or 230.
 */
static pdf_bool_t
pdf_text_ucd_After_Soft_Dotted(const pdf_text_ucd_context_t *context)
{
  pdf_char_t *walker;
  short stop;
  int n_combclass230;
  int n_combclass0;
  int soft_dotted_found;
  
  if((context->unicode_point < context->context_start) || \
     (context->unicode_point > context->context_stop))
    {
      PDF_DEBUG_BASE("Unicode point outside context interval");
      /* The unicode point must not be outside the context interval */
      return PDF_FALSE;
    }
  
  if(context->unicode_point == context->context_start)
    {
      PDF_DEBUG_BASE("Unicode point is context start");
      /* If the unicode point is the start of the context, then it is impossible
       *  to have a sequence before it */
      return PDF_FALSE;
    }
  
  /*----- Check backward -----*/
  
  n_combclass0 = 0;
  n_combclass230 = 0;
  soft_dotted_found = 0;
  walker = (pdf_char_t *)(context->unicode_point - 4);
  stop = 0;
  while(!stop)
    {
      if(walker < context->context_start)
        {
          /* Arrived to context start, stop loop */
          stop = 1;
        }
      else
        {
          pdf_u32_t aux_point;
          memcpy(&aux_point, walker, 4);
          
          /* Check for point being Soft_Dotted before checking combining class,
           * as the Soft_Dotted character can also be of combining class 0 */
          if(pdf_text_ucd_pl_is_Soft_Dotted(aux_point))
            {
              soft_dotted_found = 1;
              stop = 1;
            }
          else
            {
              pdf_u8_t comb_class;
              comb_class = pdf_text_ucd_get_combining_class(aux_point);
              switch(comb_class)
              {
                case 0:
                  n_combclass0++;
                  break;
                case 230:
                  n_combclass230++;
                  break;
                default:
                  break;
              }
            }

          if(!stop)
            {
              walker -= 4; /* Point to previous UTF-32 char */
            }
        }
    }

  return (((soft_dotted_found) && \
           (n_combclass0 == 0) && \
           (n_combclass230 == 0)) ? PDF_TRUE : PDF_FALSE);
}

/* More_Above condition in Special Case algorithms
 *  The character is followed by a character of combining class 230 (Above)
 *  with no intervening character of combining class 0.
 */
static pdf_bool_t
pdf_text_ucd_More_Above(const pdf_text_ucd_context_t *context)
{
  pdf_char_t *walker;
  short stop;
  int combclass230found;
  int n_combclass0;
  
  if((context->unicode_point < context->context_start) || \
     (context->unicode_point > context->context_stop))
    {
      PDF_DEBUG_BASE("Unicode point outside context interval");
      /* The unicode point must not be outside the context interval */
      return PDF_FALSE;
    }
  
  if(context->unicode_point == context->context_stop)
    {
      /* If the unicode point is the start of the context, then it is impossible
       *  to have a sequence before it */
      return PDF_FALSE;
    }
  
  /*----- Check forward -----*/
  
  walker = (pdf_char_t *)(context->unicode_point + 4); 
  stop = 0;
  combclass230found = 0;
  n_combclass0 = 0;
  while(!stop)
    {
      if(walker > context->context_stop)
        {
          /* Arrived to context end, stop loop */
          stop = 1;
        }
      else
        {
          pdf_u8_t combining_class = 0;
          pdf_u32_t aux_point;
          memcpy(&aux_point, walker, 4);
          combining_class = pdf_text_ucd_get_combining_class(aux_point);
          
          if(combining_class == 0)
            {
              n_combclass0++;
            }
          else if(combining_class == 230)
            {
              combclass230found = 1;
              stop = 1;
            }
          if(!stop)
            {
              walker += 4; /* Point to next UTF-32 char */
            }
        }
    }

  return (((combclass230found) && \
           (n_combclass0 == 0)) ? PDF_TRUE : PDF_FALSE);
}

/* Before_Dot condition in Special Case algorithms
 *  The character is followed by COMBINING DOT ABOVE (U+0307). Any sequence of
 *  characters with a combining class that is neither 0 nor 230 may intervene
 *  between the current character and the combining dot above.
 */
static pdf_bool_t
pdf_text_ucd_Before_Dot(const pdf_text_ucd_context_t *context)
{
  pdf_char_t *walker;
  short stop;
  int dotAbovefound;
  int n_combclass0or230;
  
  if((context->unicode_point < context->context_start) || \
     (context->unicode_point > context->context_stop))
    {
      PDF_DEBUG_BASE("Unicode point outside context interval");
      /* The unicode point must not be outside the context interval */
      return PDF_FALSE;
    }
  
  if(context->unicode_point == context->context_stop)
    {
      /* If the unicode point is the start of the context, then it is impossible
       *  to have a sequence before it */
      return PDF_FALSE;
    }
  
  /*----- Check forward -----*/
  
  walker = (pdf_char_t *)(context->unicode_point + 4); 
  stop = 0;
  dotAbovefound = 0;
  n_combclass0or230 = 0;
  while(!stop)
    {
      if(walker > context->context_stop)
        {
          /* Arrived to context end, stop loop */
          stop = 1;
        }
      else
        {
          pdf_u32_t aux_point;
          memcpy(&aux_point, walker, 4);
          if(aux_point == 0x0307)
            {
              dotAbovefound = 1;
              stop = 1;
            }
          else
            {
              pdf_u8_t combining_class;
              combining_class = pdf_text_ucd_get_combining_class(aux_point);
              if((combining_class == 0) || \
                 (combining_class == 230))
                {
                  n_combclass0or230++;
                }
            }
          if(!stop)
            {
              walker += 4; /* Point to next UTF-32 char */
            }
        }
    }

  return (((dotAbovefound) && \
           (n_combclass0or230 == 0)) ? PDF_TRUE : PDF_FALSE);
}

/* After_I condition in Special Case algorithms
 *  There is an uppercase I before the character, and there is no intervening
 *  combining character class 230 (Above) or 0.
 */
static pdf_bool_t
pdf_text_ucd_After_I(const pdf_text_ucd_context_t *context)
{
  pdf_char_t *walker;
  short stop;
  int n_combclass230;
  int n_combclass0;
  int upper_i_found;
  
  if((context->unicode_point < context->context_start) || \
     (context->unicode_point > context->context_stop))
    {
      PDF_DEBUG_BASE("Unicode point outside context interval");
      /* The unicode point must not be outside the context interval */
      return PDF_FALSE;
    }
  
  if(context->unicode_point == context->context_start)
    {
      /* If the unicode point is the start of the context, then it is impossible
       *  to have a sequence before it */
      return PDF_FALSE;
    }
  
  /*----- Check backward -----*/
  
  n_combclass0 = 0;
  n_combclass230 = 0;
  upper_i_found = 0;
  walker = (pdf_char_t *)(context->unicode_point - 4);
  stop = 0;
  while(!stop)
    {
      if(walker < context->context_start)
        {
          /* Arrived to context start, stop loop */
          stop = 1;
        }
      else
        {
          pdf_u32_t aux_point;
          memcpy(&aux_point, walker, 4);
          
          /* Check for character being I before checking combining class, as
           * code point I has a 0 value combining class... */
          if(aux_point == 0x49) /* 0x49 == 'I' */
            {
              upper_i_found = 1;
              stop = 1;
            }
          else
            {
              switch(pdf_text_ucd_get_combining_class(aux_point))
              {
                case 0:
                  n_combclass0++;
                  break;
                case 230:
                  n_combclass230++;
                  break;
                default:
                  break;
              }
            }
          
          if(!stop)
            {
              walker -= 4; /* Point to previous UTF-32 char */
            }
        }
    }

  return (((upper_i_found) && \
           (n_combclass0 == 0) && \
           (n_combclass230 == 0)) ? PDF_TRUE : PDF_FALSE);
}


static pdf_bool_t
pdf_text_ucd_check_lang(const pdf_char_t *text,
                        const pdf_text_ucd_context_t *context)
{
  if((text!=NULL) && \
     (context != NULL) && \
     (strncmp((char *)text, (char *)(&context->locale[0]), 2) == 0))
    {
      return PDF_TRUE;
    }
  else
    {
      return PDF_FALSE;
    }
}


#define UCD_SC_COND_N    5
typedef struct _pdf_text_ucd_condition_s {
  pdf_char_t *cond_name;
  pdf_bool_t (*cond_func) (const pdf_text_ucd_context_t *context);
} pdf_text_ucd_condition_t;

static const pdf_text_ucd_condition_t ucd_condition_list[UCD_SC_COND_N] = {
  { (pdf_char_t *)"Final_Sigma",        pdf_text_ucd_Final_Sigma        },
  { (pdf_char_t *)"After_Soft_Dotted",  pdf_text_ucd_After_Soft_Dotted  },
  { (pdf_char_t *)"More_Above",         pdf_text_ucd_More_Above         },
  { (pdf_char_t *)"Before_Dot",         pdf_text_ucd_Before_Dot         },
  { (pdf_char_t *)"After_I",            pdf_text_ucd_After_I            }  
};


/* Get pointers to next condition start. It also creates a NUL terminated 
 * string by putting a '\0' at the end of the condition. Returns PDF_TRUE if
 * last condition. */
static pdf_bool_t
pdf_text_ucd_special_case_get_next_condition(pdf_char_t **condition_start,
                                             pdf_char_t **condition_stop)
{
  pdf_char_t *field_start;
  pdf_char_t *field_stop;
  
  if((condition_start == NULL) || \
     (condition_stop == NULL))
    {
      return PDF_FALSE;
    }

  /* Initiate field start */
  field_start = *condition_start;

  /* Skip leading white chars, if any */
  while(*field_start == ' ')
    {
      field_start++;
    }
  
  /* Look for field stop */
  field_stop = field_start;
  while((*field_stop != ' ') && (*field_stop != '\0'))
    {
      field_stop++;
    }
  
  /* Set output pointers */
  *condition_start = field_start;
  *condition_stop = field_stop;

  
  /* Reset field end and create NUL-terminated string (if not already) */
  if(*field_stop == ' ')
    {
      *field_stop = '\0';
      return PDF_FALSE;
    }
  else
    {
      /* Last condition found */
      return PDF_TRUE;
    }
}


/* Check a single given condition (NUL-terminate string) against the casing
 * context */
static pdf_status_t
pdf_text_ucd_special_case_check_single(const pdf_text_ucd_context_t *context,
                                       const pdf_char_t *condition,
                                       pdf_bool_t *p_fulfilled)
{
  extern const pdf_text_ucd_condition_t ucd_condition_list[UCD_SC_COND_N];
  pdf_bool_t negate_condition = PDF_FALSE;
  pdf_char_t *walker = (pdf_char_t *)condition;
  
  /* Check if it is a Negative condition (Preceded by 'Not_') */
  if((strlen((char *)walker) > 4) && \
     (strncmp((char *)walker, "Not_", 4) == 0))
    {
      negate_condition = PDF_TRUE;
      walker += 4;
    }
  
  /* Check if what we have is a LANGUAGE ID (2 characters) */
  if(strlen((char *)walker) == 2)
    {
      pdf_bool_t condition_ok;
      condition_ok = pdf_text_ucd_check_lang(walker, context);
      /* Condition fulfilled if only one of condition_ok and negate_condition
       *  is true (XOR). */
      *p_fulfilled = condition_ok ^ negate_condition;
      return PDF_OK;
    }
  else
    {
      /* Check conditions depending on CONTEXT */
      short i = 0;
      while(i < UCD_SC_COND_N)
        {
          if(strcmp((char *)walker,(char *)ucd_condition_list[i].cond_name)==0)
            {
              pdf_bool_t condition_ok;
              /* Condition found! */
              condition_ok = ucd_condition_list[i].cond_func(context);
              /* Condition fulfilled if only one of condition_ok and 
               *  negate_condition is true (XOR). */
              *p_fulfilled = condition_ok ^ negate_condition;
              return PDF_OK;
            }
          /* Update condition walker to check the next one... */
          ++i;
        }
    }

  /* Received condition is not valid */
  return PDF_EBADTEXT;
}


/* Function to parse the condition list from the UCD, and check the found
 * conditions against the given casing context */
static pdf_bool_t
pdf_text_ucd_special_case_conditions(const pdf_text_ucd_context_t *context,
                                     const pdf_char_t *condition_list)
{
  pdf_char_t *walker;
  pdf_char_t *internal_condition_list;
  pdf_bool_t is_last;
  pdf_size_t condition_list_size;

  if((condition_list == NULL) || \
     (context == NULL) || \
     (context->unicode_point == NULL) || \
     (strlen((char *)condition_list) == 0))
    {
      return PDF_FALSE; /* Default is the condition not being fulfilled */ 
    }
  
  /* Copy condition list, as this function will modify it to create NUL
   * terminated strings per condition */
  condition_list_size = strlen((char *)condition_list);
  internal_condition_list = (pdf_char_t *)pdf_alloc(condition_list_size+1);
  if(internal_condition_list == NULL)
    {
      PDF_DEBUG_BASE("Problem dupping condition list");
      return PDF_FALSE;
    }
  memcpy(internal_condition_list,condition_list,condition_list_size);
  internal_condition_list[condition_list_size] = '\0';

  /* Initiate walker */
  walker = internal_condition_list;

  /* Walk the whole character string, until last NUL char */
  is_last = 0;
  while((!is_last) && \
        (*walker != '\0'))
    {
      pdf_char_t *field_end;
      pdf_bool_t fulfilled;
      
      /* Get NUL-terminated string to next condition */
      is_last = pdf_text_ucd_special_case_get_next_condition(&walker, \
                                                             &field_end);
      
      
      /* Check single condition */
      if(pdf_text_ucd_special_case_check_single(context, \
                                                walker, \
                                                &fulfilled) != PDF_OK)
        {
          /* Invalid condition!!! */
          PDF_DEBUG_BASE("Invalid condition in Special Case check: '%s'",
                         (char *)walker);
          return PDF_FALSE;
        }
      /* Check if single condition was fulfilled */
      if(!fulfilled)
        {
          pdf_dealloc(internal_condition_list);
          return PDF_FALSE;
        }

      /* Update walker if not last */
      if(!is_last)
        {
          walker = field_end+1;
        }
    }

  /* If arrived here, this means that all the conditions were fulfilled */
  pdf_dealloc(internal_condition_list);
  return PDF_TRUE;
}

static pdf_bool_t
pdf_text_ucd_special_case(pdf_u32_t to_he[UCD_SC_MAX_EXPAND],
                          pdf_size_t *p_n_points,
                          const pdf_u32_t from_he,
                          const pdf_i32_t index_in_array,
                          const pdf_text_ucd_context_t *context,
                          const enum unicode_case_type to_case)
{
  extern unicode_case_info_t unicode_case_info[UCD_C_INFO_N];
  extern unicode_special_case_info_t unicode_special_case_info[UCD_SC_INFO_N];
  
  int index = 0;
  pdf_char_t *condition_list = NULL;

  while(index < PDF_TEXT_MNSC)
    {
      /* Check if a special case is available for this unicode point */
      if(unicode_case_info[index_in_array].special_case_indexes[index] == -1)
        {
          /* Return 0 if no special case was found... */
          return PDF_FALSE;
        }
      else
        {
          pdf_i32_t index_in_sc_array = unicode_case_info[index_in_array].special_case_indexes[index];
          /* Sanity check to see if we really found the correct unicode point */
          if(from_he != unicode_special_case_info[index_in_sc_array].unicode_point)
            {
              PDF_DEBUG_BASE("Invalid search was done in the Special "
                             "Casing array! (%lu vs %lu). "
                             "index_in_sc_array: %ld, index_in_array: %ld",
                             (unsigned long)from_he,
                             (unsigned long)unicode_special_case_info[index_in_sc_array].unicode_point,
                             (long)index_in_sc_array,
                             (long)index_in_array);
              return PDF_FALSE;
            }
          
          /* Ok, there is a special case */
          /* Get conditions list in Special Case, if any */
          condition_list = (pdf_char_t *)unicode_special_case_info[index_in_sc_array].condition_list;
          
          /* Check special case conditions */
          if(((strlen((char *)condition_list)>0) && \
              (pdf_text_ucd_special_case_conditions(context, condition_list)))||
             (strlen((char *)condition_list) == 0))
            {
              pdf_u32_t *dest = NULL;
              /* If conditions fullfiled, or there was no condition.... */
              
              /* Delta is the good one! */
              switch(to_case)
              {
                case UNICODE_CASE_INFO_UPPER_CASE:
                  dest = &(unicode_special_case_info[index_in_sc_array].uppercase_point[0]);
                  break;
                case UNICODE_CASE_INFO_LOWER_CASE:
                  dest = &(unicode_special_case_info[index_in_sc_array].lowercase_point[0]);
                  break;
                case UNICODE_CASE_INFO_TITLE_CASE:
                  dest = &(unicode_special_case_info[index_in_sc_array].titlecase_point[0]);
                  break;
                default:
                  /* Will never happen */
                  return PDF_FALSE;
              }
              /* Copy contents */
              memcpy(&to_he[0], dest, UCD_SC_MAX_EXPAND*4);
              
              /* Compute number of valid points */
              if(p_n_points != NULL)
                {
                  if(to_he[2] != 0)
                    {
                      *p_n_points = (pdf_size_t)3;
                    }
                  else if(to_he[1] != 0)
                    {
                      *p_n_points = (pdf_size_t)2;
                    }
                  else if(to_he[0] != 0)
                    {
                      *p_n_points = (pdf_size_t)1;
                    }
                  else
                    {
                      /* It can really happen that a given Unicode point MUST 
                       *  dissappear when converting to uppercase or titlecase, 
                       *  for example combining marks. E.g: 0x0307 */
                      *p_n_points = (pdf_size_t)0;
                    }
                }
              return PDF_TRUE; /* Conversion was done... */
            }
          /* check next condition, if any */
          index++;
        }
    }

  /* else, just return a not found flag */
  return PDF_FALSE;
}

static pdf_bool_t
pdf_text_ucd_simple_case(pdf_u32_t *to_he,
                         const pdf_u32_t from_he,
                         const pdf_i32_t index_in_array,
                         const enum unicode_case_type to_case)
{
  extern unicode_case_info_t unicode_case_info[UCD_C_INFO_N];
  
  /* Sanity check to see if we really found the correct unicode point */
  if(from_he != unicode_case_info[index_in_array].unicode_point)
    {
      PDF_DEBUG_BASE("Invalid search was done in the "
                     "Casing array! (%lu vs %lu)",
                     (unsigned long)from_he,
                     (unsigned long)unicode_case_info[index_in_array].unicode_point);
      return PDF_FALSE;
    }
  
  switch(to_case)
  {
    case UNICODE_CASE_INFO_UPPER_CASE:
    {
      *to_he = unicode_case_info[index_in_array].uppercase_point;
      break;
    }
    case UNICODE_CASE_INFO_LOWER_CASE:
    {
      *to_he = unicode_case_info[index_in_array].lowercase_point;
      break;
    }
    case UNICODE_CASE_INFO_TITLE_CASE:
    {
      *to_he = unicode_case_info[index_in_array].titlecase_point;
      break;
    }
    default:
    {
      *to_he = unicode_case_info[index_in_array].unicode_point;
      break;
    }
  }
  return PDF_TRUE;
}


static pdf_i32_t
pdf_text_ucd_find_case_index(const pdf_u32_t from_he)
{
  extern unicode_case_interval_t unicode_case_int[UCD_C_INT_N];
  
  pdf_bool_t found;
  int index;
  long delta = 0;
  
  /* Look for input unicode point in intervals */
  index = 0;
  found = PDF_FALSE;
  while((!found) && \
        (index < UCD_C_INT_N))
    {
      /* First, check if the input point is not within the interval, but between
       *  two given intervals */
      if(from_he < unicode_case_int[index].interval_start)
        {
          /* Ok, no case information for this point, return the same one. Force
           *  loop exit without having found the point */
          index = UCD_C_INT_N;
        }
      else if(from_he <= unicode_case_int[index].interval_stop)
        {
          /* Found!! Set deltaToIndex */
          found = PDF_TRUE;
          delta = unicode_case_int[index].deltaToIndex;
        }
      else
        {
          index++;
        }
    }

  /* Return index of the Unicode point in the unicode_case_info array, only if
   *  it was found */
  return (found ? (from_he - delta) : -1);
}


static pdf_size_t
pdf_text_ucd_to_case(pdf_u32_t dest[UCD_SC_MAX_EXPAND], pdf_u32_t origin,
                     const pdf_text_ucd_context_t *context,
                     const enum unicode_case_type to_case)
{
  pdf_i32_t unicode_point_index = -1;
  pdf_size_t n_points = 0;
  
  /* Completely clear output array */
  memset(&dest[0],0,sizeof(pdf_u32_t)*UCD_SC_MAX_EXPAND);
  
  /* Get index of unicode point in casing info array */
  unicode_point_index = pdf_text_ucd_find_case_index(origin);
  
  /* If point was not found in casing info array, return the same point... */
  if(unicode_point_index < 0)
    {
      dest[0] = origin;
      return 1; /* Return number of output unicode points */
    }

  /* Try special cases first */
  if(pdf_text_ucd_special_case(dest,
                               &n_points,
                               origin,
                               unicode_point_index,
                               context,
                               to_case))
    {
      /* Special case correctly processed */
      return n_points;
    }
  else
    {
      /* Get simple case */
      return ((pdf_text_ucd_simple_case(&dest[0],
                                        origin,
                                        unicode_point_index,
                                        to_case)) ? 1 : 0);
    }
}



static pdf_status_t
pdf_text_ucd_create_case_context(pdf_text_ucd_context_t *context,
                                 const pdf_char_t *word,
                                 const pdf_size_t length,
                                 const pdf_char_t *language)
{
  /* Check word length. As it comes in bytes, it must be multiple of 4! */
  if(length % 4 != 0)
    {
      PDF_DEBUG_BASE("Invalid word length");
      return PDF_EBADDATA;
    }
  
  /* Set context start as the first character in the word */
  context->context_start = (pdf_char_t *)word;
  /* Set context stop as the last character in the word. Length is coming in 
   *  bytes! */
  context->context_stop = (pdf_char_t *)&(word[length -4]);
  /* Set language code, if any */
  if(strlen((char *)language) == 2)
    {
      strncpy((char *)&(context->locale[0]), (char *)language, 2);
    }
  else
    {
      strncpy((char *)&(context->locale[0]), "  ", 2);
    }
  
  return PDF_OK;
}

/* Convert a given UTF-32HE word to specified case.
 *  Warning!!! The destination word MUST contain enough space for the WORST
 *  conversion case, this is, for each unicode point, 3 unicode points are
 *  generated after the conversion!!! */
pdf_status_t
pdf_text_ucd_word_change_case(pdf_char_t *destination_word,
                              pdf_size_t *p_destination_length,
                              enum unicode_case_type destination_case,
                              const pdf_char_t *origin_word,
                              const pdf_size_t origin_length,
                              const pdf_char_t *origin_lang)
{
  pdf_text_ucd_context_t context;
  pdf_size_t i = 0; /* Index in the original word */
  pdf_size_t j = 0; /* Index in the destination word */
  pdf_char_t new_length;
  pdf_size_t new_char_size = 0;
  
  if((destination_word == NULL) || \
     (origin_word == NULL) || \
     (origin_lang == NULL) || \
     (p_destination_length == NULL))
    {
      PDF_DEBUG_BASE("Invalid inputs");
      return PDF_EBADDATA;
    }

  /* Create context for this word */
  if(pdf_text_ucd_create_case_context(&context,
                                      origin_word,
                                      origin_length,
                                      origin_lang) != PDF_OK)
    {
      PDF_DEBUG_BASE("Error creating casing context");
      return PDF_EBADDATA;
    }
  
  new_length = 0;
  for(i = 0; i < origin_length; i+=4, j+=new_char_size)
    {
      enum unicode_case_type new_case;
      pdf_u32_t dest_character[UCD_SC_MAX_EXPAND];
      pdf_u32_t  character;
      new_char_size = 0;
      
      /* In title case, only title-case the first character, and lower-case all
       *  the others */
      new_case = ((destination_case==UNICODE_CASE_INFO_TITLE_CASE)&&(i>0)) ? \
                  UNICODE_CASE_INFO_LOWER_CASE : destination_case;
      
      /* Store pointer to character within the context */
      context.unicode_point = (pdf_char_t *)(&origin_word[i]);
      /* Store language info in context */
      if(strlen((char *)origin_lang) == 2)
        {
          memcpy(&context.locale[0],origin_lang,2);
        }
      else
        {
          memset(&context.locale[0],0,2);
        }
      
      /* Store character */
      memcpy(&character, &origin_word[i], 4);
      /* Perform conversion */
      new_char_size = pdf_text_ucd_to_case(dest_character,
                                           character,
                                           &context,
                                           new_case);
      /* Remember that after casing, a given character can even disappear, so
       * new_char_size could also be 0 */
      if(new_char_size > UCD_SC_MAX_EXPAND)
        {
          PDF_DEBUG_BASE("Invalid length for case converted char: %u\n",
                         (unsigned int) new_char_size);
          return PDF_ETEXTENC;
        }
      else if(new_char_size > 0)
        {
          /* Convert new char size to bytes */
          new_char_size*=4;
          /* Update length of new word (in bytes!) */
          new_length += new_char_size;
          /* Store case-converted character */
          memcpy(&destination_word[j], &dest_character[0], new_char_size);
        }
    }
  
  /* Set output data length of word, in bytes! */
  *p_destination_length = new_length;

  return PDF_OK;  
}


pdf_bool_t
pdf_text_ucd_is_case_ignorable(const pdf_u32_t character)
{
  /* If character has the MidLetter or MidNumLet property value in Word_Break...
   *   (List of chars obtained from WordBreakProperty.txt UCD file */
  
  if(pdf_text_ucd_wb_is_midletter(character) || \
     pdf_text_ucd_wb_is_midnumlet(character))
    {
      return PDF_TRUE;
    }
  
  /* Ok, so continue checking... Now if General Category is one of:
   *    Mn, Me, Cf, Lm, Sk
   *  then is case ignorable
   */
  switch(pdf_text_ucd_get_general_category(character))
  {
    case UNICODE_GENCAT_Mn:
    case UNICODE_GENCAT_Me:
    case UNICODE_GENCAT_Cf:
    case UNICODE_GENCAT_Lm:
    case UNICODE_GENCAT_Sk:
      return PDF_TRUE;
    default:
      return PDF_FALSE;
  }
}


pdf_bool_t
pdf_text_ucd_is_cased(const pdf_u32_t character)
{
  /* The character is cased if the General Category is one of:
   *  Lu, Ll, Lt
   */
  switch(pdf_text_ucd_get_general_category(character))
  {
    case UNICODE_GENCAT_Lu:
    case UNICODE_GENCAT_Ll:
    case UNICODE_GENCAT_Lt:
      return PDF_TRUE;
    default:
      return PDF_FALSE;
  }
}

/* End of pdf-text-ucd-case.c */

