=begin
= Random Number Generation

== GSL::Rng class

--- GSL::Rng.alloc(rng_type[, seed])
    This method returns a GSL::Rng object of a random number generator of type 
    ((|rng_type|)) with a seed ((|seed|)). These two arguments can be omitted, 
    and the generator 'gsl_rng_mt19937' and a seed 0 are used as defaults.
    The GSL library provides a number of random number generator types, 
    and one can choose with a constant (({GSL::RNG_xxx})) or a String, as

      * (({GSL::Rng::MT19937})) or (({"gsl_rng_mt19937"})) or (({"mt19937"}))
      * (({GSL::Rng::RANLXS0}))  or (({"gsl_rng_ranlsx0"}))  or (({"ranlxs0"})) 
      * (({GSL::Rng::ZUF}))  or (({"gsl_rng_zuf"}))  or (({"zuf"})) 
      * ...

    See the ((<GSL reference manual|URL:http://www.gnu.org/software/gsl/manual/html_node/Random-number-generator-algorithms.html#Random-number-generator-algorithms>)) for the complete list. 
    The following demonstrates how to use this class,

      require 'gsl'

      r = Rng.alloc(Rng::TAUS, 1)
      r2 = Rng.alloc("ran0", 2)
      p r.name                <- "taus"
      p r.get                 <- get an integer
      p r2.uniform            <- get a float of [0, 1)

    A generator of the type ((|gsl_rng_taus|)) is created with seed 1,
    and ((|gsl_rng_ran0|)) with seed 2. The
    method ((|get|)) returns a random integer. 
    The method ((|uniform|)) returns
    a floating number uniformly distributed in the range [0, 1).

    If the package ((<rngextra|URL:http://www.network-theory.co.uk/download/rngextra/>)) is installed, additional
    two generators are available, 
      * (({GSL::Rng::RNGEXTRA_RNG1})), (({"rngextra_rng1"}))
      * (({GSL::Rng::RNGEXTRA_RNG2})), (({"rngextra_rng2"}))

    They are created as

      r1 = Rng.alloc(Rng::RNGEXTRA_RNG1)
      p r1.name                <- "rng1"

      r2 = Rng.alloc("rngextra_rng2")
      p r2.name                <- "rng2"

--- GSL::Rng.default_seed
    Returns the default seed
--- GSL::Rng.set_default_seed(seed)
--- GSL::Rng.default_seed=(seed)
    Override the default seed by ((|seed|)).

--- GSL::Rng.env_setup()

--- GSL::Rng.types_setup()
    Returns an array of all the available generators' names. 

--- GSK::Rng.memcpy(dest, src)
    Copies the random number generator ((|src|))) into the pre-existing generator 
    ((|dest|)), making dest into an exact copy of ((|src|)). 
    The two generators must be of the same type.

== Instance methods

=== Generator Initialization
--- GSL::Rng#set(s)
    This method initializes the random number generator with a given seed ((|s|)).

=== Sampling from a random number generator

--- GSL::Rng#get
    This returns a random integer from the reciever generator.

--- GSL::Rng#uniform
    This method returns a double precision floating point number uniformly 
    distributed in the range [0,1). 

--- GSL::Rng#uniform_pos
    This returns a positive double precision floating point number uniformly 
    distributed in the range (0,1), excluding both 0.0 and 1.0.

--- GSL::Rng#uniform_int(n)
    This method returns a random integer from 0 to n-1 inclusive. 

=== Auxiliary random number generator functions

--- GSL::Rng#name
    This method returns a Sting object of the name of the generator.

--- GSL::Rng#max
--- GSL::Rng#min
    These method return the largest/smallest value that the method 
    ((|get|)) can return. 

--- GSL::Rng#clone
--- GSL::Rng#duplicate
    Return a newly created generator which is an exact copy of the generator ((|self|)).

((<prev|URL:integration.html>))
((<next|URL:qrng.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))
=end
