/*******************************************************************************************************************************************
 clayout.c
*******************************************************************************************************************************************/

#include "clayout.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CLayout);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CLayout::CLayout    (CContainer *inOwner, const CWidgetListener *inListener)
	:CContainer (inOwner, inListener)
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CLayout::~CLayout ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// expected owner type
//------------------------------------------------------------------------------------------------------------------------------------------
CMetaClasses CLayout::OwnerMustBe () const
{
	return __metaclasses(CContainer);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// control at point
//------------------------------------------------------------------------------------------------------------------------------------------
CControl * CLayout::GetControlAtPoint (const TPoint &inRelativePoint) const
{
	// get all of the layout widgets direct children
	CWidgets inWidgets (GetGtkChildren());

	// go through the list
	for (size_t i=inWidgets.GetLength(), j=0; i>0; i--, j++)
	{
		// get the current child widget and get its relative bounds
		CWidget *inWidget = *inWidgets[j]; TBounds inBounds (inWidget -> GetBounds());

		// check the given point coordinates
		if (inRelativePoint.x >= inBounds.x && 
		    inRelativePoint.y >= inBounds.y && 
		   (inRelativePoint.x <= (inBounds.x + inBounds.w)) &&
		   (inRelativePoint.y <= (inBounds.y + inBounds.h)))
			return inWidget;
	}

	// not found, defaults to this instance !
	return const_cast <CLayout *> (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// max handled children
//------------------------------------------------------------------------------------------------------------------------------------------
SInt16 CLayout::GetGtkChildrenNumberLeft () const
{
	return -1;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// drop site index
//------------------------------------------------------------------------------------------------------------------------------------------
SInt16 CLayout::GetDropIndexAtPoint (const TPoint &inRelativePoint, const CControl *) const
{
	// get the reference control at specified point
	CControl *inReference = GetControlAtPoint (inRelativePoint);

	// check the reference class type
	if (inReference == NULL || !inReference -> ClassIs (__metaclass(CWidget))) return -1;

	// get the in owner reference widget index
	SInt16 outIndex = CContainer::GetGtkInOwnerIndex (this, static_cast <const CWidget *> (inReference));

	// ok, output a relative append index
	return outIndex < 0 ? outIndex : outIndex+1;
}

