/*******************************************************************************************************************************************
 cvpaned.c
*******************************************************************************************************************************************/

#include "cvpaned.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CVPaned);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVPaned::CVPaned (CContainer *inOwner, const CWidgetListener *inListener)
	:CPaned	 (inOwner, inListener)
{
	// initiate the gtk instanciation process
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CVPaned::~CVPaned ()
{
	// gtk / gtkol deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CVPaned::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_vpaned_new ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// return the insertion index of specified potential candidate
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CVPaned::GetDropIndexAtPoint (const TPoint &inRelativePoint, const CControl *inCandidate) const
{
	// get the child at point
	CControl *inControl = GetControlAtPoint (inRelativePoint);

	// check pointers
	if (inCandidate == NULL || inControl == NULL || !inControl -> ClassIs (__metaclass(CWidget)) || 
	    inControl == const_cast <CVPaned *> (this)) return -1;

	// get the control in owner index
	SInt16 outIndex = CContainer::GetGtkInOwnerIndex (this, static_cast <CWidget *> (inControl));

	// check the index
	if (outIndex < 0) return outIndex;

	// get the control bounds
	TBounds inBounds (inControl -> GetBounds()); 

	// if the candidate and the target control have the same owner, just overwritte the target position
	if (!inCandidate -> HasSibling (inControl))
	
		// analyse the point place
		if (inRelativePoint.y > (inBounds.y + inBounds.h/2)) outIndex++;
	
	// ok
	return outIndex;
}



