/***************************************************************************
 $RCSfile: ahc.c,v $
                             -------------------
    cvs         : $Id: ahc.c,v 1.7 2005/06/28 15:15:58 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "args.h"
#include "typemaker_p.h"
#include <gwenhywfar/debug.h>
#include <gwenhywfar/logger.h>
#include <gwenhywfar/xml.h>
#include <gwenhywfar/bufferedio.h>

#include <stdlib.h>
#include <assert.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>




int write_ha_file_c(ARGUMENTS *args, GWEN_XMLNODE *node) {
  int rv;
  const char *f;
  GWEN_BUFFER *fname;
  GWEN_BUFFER *hbuf;
  const char *s;
  int fd;
  const char *nacc;
  GWEN_BUFFEREDIO *bio;
  GWEN_ERRORCODE err;
  GWEN_XMLNODE *n;
  const char *id;
  const char *prefix;

  id=get_struct_property(node, "id", 0);
  if (!id) {
    DBG_ERROR(0, "No id for struct");
    return -1;
  }

  prefix=get_struct_property(node, "prefix", 0);
  if (!prefix) {
    DBG_ERROR(0, "No prefix for struct");
    return -1;
  }

  f=get_struct_property(node, "filename", 0);
  if (!f) {
    DBG_ERROR(0, "No filename given");
    return -1;
  }

  nacc=get_struct_property(node, "access", "public");

  fname=GWEN_Buffer_new(0, 256, 0, 1);
  GWEN_Buffer_AppendString(fname, f);
  GWEN_Buffer_AppendString(fname, ".h");
  fd=open(GWEN_Buffer_GetStart(fname),
	  O_RDWR|O_CREAT|O_TRUNC,
	  S_IRUSR|S_IWUSR);
  if (fd==-1) {
    DBG_ERROR(0, "open(%s): %s",
	      GWEN_Buffer_GetStart(fname),
	      strerror(errno));
    GWEN_Buffer_free(fname);
    return -1;
  }
  GWEN_Buffer_free(fname);

  bio=GWEN_BufferedIO_File_new(fd);
  GWEN_BufferedIO_SetWriteBuffer(bio, 0, 1024);

  /* Insert the auto-generation warning */
  GWEN_BufferedIO_Write(bio, "/* This file is auto-generated from \"");
  GWEN_BufferedIO_Write(bio, f);
  GWEN_BufferedIO_WriteLine(bio, ".xml\" by the typemaker");
  GWEN_BufferedIO_WriteLine(bio, "   tool of Gwenhywfar. ");
  GWEN_BufferedIO_WriteLine(bio, "   Do not edit this file -- all changes will be lost! */");

  hbuf=GWEN_Buffer_new(0, 256, 0, 1);
  s=f;
  while(*s) {
    GWEN_Buffer_AppendByte(hbuf, toupper(*s));
    s++;
  }
  GWEN_Buffer_AppendString(hbuf, "_H");

  GWEN_BufferedIO_Write(bio, "#ifndef ");
  GWEN_BufferedIO_WriteLine(bio, GWEN_Buffer_GetStart(hbuf));
  GWEN_BufferedIO_Write(bio, "#define ");
  GWEN_BufferedIO_WriteLine(bio, GWEN_Buffer_GetStart(hbuf));
  GWEN_BufferedIO_WriteLine(bio, "");

  rv=write_apidoc_c(args, node, bio, "public");
  if (rv)
    return rv;

  if (strcasecmp(nacc, "public")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
    GWEN_BufferedIO_WriteLine(bio, "extern \"C\" {");
    GWEN_BufferedIO_WriteLine(bio, "#endif");
    GWEN_BufferedIO_WriteLine(bio, "");
    GWEN_BufferedIO_Write(bio, "typedef struct ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, ";");
    GWEN_BufferedIO_WriteLine(bio, "");
    GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
    GWEN_BufferedIO_WriteLine(bio, "} /* __cplusplus */");
    GWEN_BufferedIO_WriteLine(bio, "#endif");
    GWEN_BufferedIO_WriteLine(bio, "");
  }

  GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/db.h>");

  if (strcasecmp(get_struct_property(node, "inherit", ""),
                 "public")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/inherit.h>");
  }

  if (strcasecmp(get_struct_property(node, "list", ""),
                 "public")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/misc.h>");
  }

  if (strcasecmp(get_struct_property(node, "list2", ""),
                 "public")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/list2.h>");
  }

  n=GWEN_XMLNode_FindFirstTag(node, "headers", 0, 0);
  if (n) {
    GWEN_XMLNODE *nn;

    nn=GWEN_XMLNode_GetFirstTag(n);
    while(nn) {
      rv=write_hp_group_c(args, nn, bio);
      if (rv) {
	GWEN_Buffer_free(hbuf);
	return -1;
      }
      nn=GWEN_XMLNode_GetNextTag(nn);
    } /* while */
  }
  GWEN_BufferedIO_WriteLine(bio, "");

  GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
  GWEN_BufferedIO_WriteLine(bio, "extern \"C\" {");
  GWEN_BufferedIO_WriteLine(bio, "#endif");
  GWEN_BufferedIO_WriteLine(bio, "");

  if (write_h_enums(args, node, bio, "public")) {
    DBG_ERROR(0, "Error writing enum types");
    return -1;
  }

  if (strcasecmp(get_struct_property(node, "inherit", ""),
                 "public")==0) {
    if (args->domain)
      GWEN_BufferedIO_Write(bio, "GWEN_INHERIT_FUNCTION_LIB_DEFS(");
    else
      GWEN_BufferedIO_Write(bio, "GWEN_INHERIT_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, ", ");
      GWEN_BufferedIO_Write(bio, args->domain);
    }

    err = GWEN_BufferedIO_WriteLine(bio, ")");
    if (!GWEN_Error_IsOk(err)) {
      DBG_ERROR_ERR(0, err);
      GWEN_Buffer_free(hbuf);
      return -1;
    }
  }

  if (strcasecmp(get_struct_property(node, "list", ""),
                 "public")==0) {
    if (args->domain)
      GWEN_BufferedIO_Write(bio, "GWEN_LIST_FUNCTION_LIB_DEFS(");
    else
      GWEN_BufferedIO_Write(bio, "GWEN_LIST_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, ", ");
    GWEN_BufferedIO_Write(bio, prefix);
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, ", ");
      GWEN_BufferedIO_Write(bio, args->domain);
    }
    GWEN_BufferedIO_WriteLine(bio, ")");

    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, "_LIST *");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_List_dup(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "_LIST *stl);");

    GWEN_BufferedIO_WriteLine(bio, "");
  }

  if (strcasecmp(get_struct_property(node, "list2", ""),
                 "public")==0) {
    if (args->domain)
      GWEN_BufferedIO_Write(bio, "GWEN_LIST2_FUNCTION_LIB_DEFS(");
    else
      GWEN_BufferedIO_Write(bio, "GWEN_LIST2_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, ", ");
    GWEN_BufferedIO_Write(bio, prefix);
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, ", ");
      GWEN_BufferedIO_Write(bio, args->domain);
    }
    GWEN_BufferedIO_WriteLine(bio, ")");
    GWEN_BufferedIO_WriteLine(bio, "");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Destroys all objects stored in the given "
                              "LIST2 and the list itself");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_List2_freeAll(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "_LIST2 *stl);");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Creates a deep copy of the given LIST2.");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, "_LIST2 *");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_List2_dup(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "_LIST2 *stl);");

    GWEN_BufferedIO_WriteLine(bio, "");
  }

  if (strcasecmp(nacc, "public")==0) {
    GWEN_BufferedIO_WriteLine(bio,
                              "/** Creates a new object.");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_WriteLine(bio, "_new();");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Destroys the given object.");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_free(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Increments the usage counter of the "
                              "given object, so an additional free() is"
                              " needed to destroy the object.");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_Attach(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    /* dup */
    GWEN_BufferedIO_WriteLine(bio,
                              "/** Creates and returns a deep copy of the"
                              "given object.");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_dup(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "*st);");

    /* FromDb */
    GWEN_BufferedIO_WriteLine(bio,
                              "/** Creates an object from the data in the"
                              " given GWEN_DB_NODE");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_WriteLine(bio, "_fromDb(GWEN_DB_NODE *db);");

    /* ToDb */
    GWEN_BufferedIO_WriteLine(bio,
                              "/** Stores an object in the"
                              " given GWEN_DB_NODE");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "int ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_toDb(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "*st, GWEN_DB_NODE *db);");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Returns 0 if this object has not been"
                              " modified, !=0 otherwise");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "int ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_IsModified(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    GWEN_BufferedIO_WriteLine(bio,
                              "/** Sets the modified state of the given "
                              "object");
    GWEN_BufferedIO_WriteLine(bio, "*/");
    if (args->domain) {
      GWEN_BufferedIO_Write(bio, args->domain);
      GWEN_BufferedIO_Write(bio, " ");
    }
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_SetModified(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st, int i);");
  }

  rv=write_h_setget_c(args, node, bio, "public");
  if (rv) {
    GWEN_Buffer_free(hbuf);
    GWEN_BufferedIO_Abandon(bio);
    GWEN_BufferedIO_free(bio);
    return rv;
  }

  err=GWEN_BufferedIO_WriteLine(bio, "");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  err=GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }
  err=GWEN_BufferedIO_WriteLine(bio, "} /* __cplusplus */");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }
  err=GWEN_BufferedIO_WriteLine(bio, "#endif");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }
  err=GWEN_BufferedIO_WriteLine(bio, "");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  /* write trailing endif */
  err=GWEN_BufferedIO_WriteLine(bio, "");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  err=GWEN_BufferedIO_Write(bio, "#endif /* ");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }
  err=GWEN_BufferedIO_Write(bio, GWEN_Buffer_GetStart(hbuf));
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }
  err=GWEN_BufferedIO_WriteLine(bio, " */");
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  err=GWEN_BufferedIO_Close(bio);
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    GWEN_BufferedIO_free(bio);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  GWEN_Buffer_free(hbuf);
  return 0;
}



int write_ha_files_c(ARGUMENTS *args, GWEN_XMLNODE *node) {
  GWEN_XMLNODE *n;
  int rv;

  n=GWEN_XMLNode_FindFirstTag(node, "type", 0, 0);
  while (n) {
    const char *nacc;

    nacc=get_struct_property(n, "access", "public");
    if (strcasecmp(nacc, "public")==0) {
      rv=write_ha_file_c(args, n);
      if (rv)
	return rv;
    }
    n=GWEN_XMLNode_FindNextTag(n, "type", 0, 0);
  }
  return 0;
}








