/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2010, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 */
package org.hibernate.test.collection.set;

import java.util.HashSet;

import junit.framework.Test;

import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.collection.PersistentSet;
import org.hibernate.junit.functional.FunctionalTestCase;
import org.hibernate.junit.functional.FunctionalTestClassTestSuite;
import org.hibernate.stat.CollectionStatistics;

/**
 *
 * @author Gail Badner
 */
public class PersistentSetNonLazyTest extends PersistentSetTest {
	public PersistentSetNonLazyTest(String name) {
		super( name );
	}

	public String[] getMappings() {
		return new String[] { "collection/set/MappingsNonLazy.hbm.xml" };
	}

	public static Test suite() {
		return new FunctionalTestClassTestSuite( PersistentSetNonLazyTest.class );
	}

	public void testLoadChildCheckParentContainsChildCache() {
		reportSkip( "known to fail with non-lazy collection using query cache",
				"support for non-lazy collections using query cache"
		);
	}

	public void testLoadChildCheckParentContainsChildCacheFailureExpected() {
		 super.testLoadChildCheckParentContainsChildCache();
	}
}