/* iksemel (XML parser for Jabber)
** Copyright (C) 2000-2003 Gurer Ozen <madcat@e-kolay.net>
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include "iksemel.h"

const char test[] = "madcat has a bad feeling about this.";

void
test_strcat (int chunksize)
{
	ikstack *s;
	char *tmp;
	int i;

	s = iks_stack_new (chunksize);
	for (i = 0; i < 64; i++) {
		iks_stack_strcat (s, "madcat", 0);
		iks_stack_strcat (s, " ", 1);
		iks_stack_strcatv (s, "has ", "a", " bad feelin", "g ", "about ", "this.", s);
		tmp = iks_stack_print (s);
		if (strcmp (tmp, test) != 0) {
			printf ("strcat test (%d)\n Expecting: [%s]\n Got: [%s]\n",
				chunksize, test, tmp);
			exit (1);
		}
	}
	iks_stack_delete (s);
}

int
main (int argc, char *argv[])
{
	test_strcat (16);
	test_strcat (17);
	test_strcat (256);
	test_strcat (789);
	test_strcat (4096);

	return 0;
}
