/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDPROGRESSCALLBACK_H
#define ISDPROGRESSCALLBACK_H

/**
 * If you want to monitor the progress of an action
 * subclass this class, implement the procentDone() method and pass
 * an object of the class to the method that does the calculations.
 * The procentDone() method will be called regularly.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <string>

#include <libinstrudeo/isdobject.h>

using namespace std;

class ISDProgressCallback : public ISDObject
{
 public:
    virtual ~ISDProgressCallback() {};

    //-----METHODS-----
    /**
     * This method will be called regularly, reporting
     * the percentage of the action that is done.
     * Overload this method in your subclass to receive
     * these updates.
     *
     * @param procent The percentage that was processed.
     */
    virtual void procentDone(float procent) = 0;

    /**
     * Overload this method in your subclass to enable
     * cancelling-reporting, back to the calculation method.
     * The method will call this regularly to check if 
     * the user cancelled the calculation.
     *
     * @return true if the calculations were aborted.
     */
    virtual bool wasCancelled() {return false;};
};

#endif
