package com.itextpdf.text;

import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;

import java.util.HashMap;
import java.util.UUID;

public class ListBody implements IAccessibleElement {

    protected PdfName role = PdfName.LBODY;
    private UUID id = null;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    protected ListItem parentItem = null;

    protected ListBody(final ListItem parentItem) {
        this.parentItem = parentItem;
    }

    public PdfObject getAccessibleAttribute(final PdfName key) {
        if (accessibleAttributes != null)
            return accessibleAttributes.get(key);
        else
            return null;
    }

    public void setAccessibleAttribute(final PdfName key, final PdfObject value) {
        if (accessibleAttributes == null)
            accessibleAttributes = new HashMap<PdfName, PdfObject>();
        accessibleAttributes.put(key, value);
    }

    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return accessibleAttributes;
    }

    public PdfName getRole() {
        return role;
    }

    public void setRole(final PdfName role) {
        this.role = role;
    }

    public UUID getId() {
        if (id == null)
            id = UUID.randomUUID();
        return id;
    }

    public void setId(final UUID id) {
        this.id = id;
    }

}
