/*!
 * \file 
 * \brief Include file for the IT++ base library
 * \author Tony Ottosson
 *
 * $Date$
 * $Revision$
 *
 * -------------------------------------------------------------------------
 *
 * IT++ - C++ library of mathematical, signal processing, speech processing,
 *        and communications classes and functions
 *
 * Copyright (C) 1995-2007  (see AUTHORS file for a list of contributors)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * -------------------------------------------------------------------------
 */

#ifndef ITBASE_H
#define ITBASE_H

#include <itpp/base/itassert.h>
#include <itpp/base/itpp_version.h>
#include <itpp/base/array.h>
#include <itpp/base/timing.h>
#include <itpp/base/parser.h>
#include <itpp/base/binfile.h>
#include <itpp/base/itfile.h>
#include <itpp/base/machdep.h>
#include <itpp/base/scalfunc.h>
#include <itpp/base/binary.h>
#include <itpp/base/vec.h>
#include <itpp/base/mat.h>
#include <itpp/base/smat.h>
#include <itpp/base/elmatfunc.h>
#include <itpp/base/matfunc.h>
#include <itpp/base/specmat.h>
#include <itpp/base/sort.h>
#include <itpp/base/cholesky.h>
#include <itpp/base/lu.h>
#include <itpp/base/det.h>
#include <itpp/base/inv.h>
#include <itpp/base/svd.h>
#include <itpp/base/qr.h>
#include <itpp/base/ls_solve.h>
#include <itpp/base/converters.h>
#include <itpp/base/operators.h>
#include <itpp/base/fastmath.h>
#include <itpp/base/eigen.h>
#include <itpp/base/bessel.h>
#include <itpp/base/random.h>
#include <itpp/base/source.h>
#include <itpp/base/stack.h>
#include <itpp/base/filter.h>
#include <itpp/base/transforms.h>
#include <itpp/base/sigfun.h>
#include <itpp/base/circular_buffer.h>
#include <itpp/base/factory.h>
#include <itpp/base/stat.h>
#include <itpp/base/fastica.h>
#include <itpp/base/integration.h>
#include <itpp/base/freq_filt.h>
#include <itpp/base/gf2mat.h>
#include <itpp/base/poly.h>
#include <itpp/base/window.h>
#include <itpp/base/filter_design.h>
#include <itpp/base/schur.h>
#include <itpp/base/newton_search.h>

#endif // #ifndef ITBASE_H
