/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import org.apache.tools.ant.BuildException;

/**
 * A task that will unset variables.
 *
 * @version <pre>$Id: Unset.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class Unset
    extends VariableTask
{
    /**
     * Default to references.
     */
    public Unset() {
        type = REFERENCE;
    }

    /**
     * Execute the task, unset the variable in name.
     */
    public void execute() throws BuildException {
        if (name == null)
            throw new MissingAttributeException("name", this);
        
        switch (type) {
          case PROPERTY:
        	  getProject().getProperties().remove(name);
              log.verbose("unset property: " + name);
              break;
              
          case USER_PROPERTY:
        	  getProject().getUserProperties().remove(name);
              log.verbose("unset user property: " + name);
              break;

          case SYSTEM_PROPERTY:
              System.getProperties().remove(name);
              log.verbose("unset system property: " + name);
              break;
              
          case REFERENCE:
        	  getProject().getReferences().remove(name);
              log.verbose("unset reference: " + name);
              break;
        }
    }
}
