@echo off
rem
rem  Invokes the 'build.sh' script from the 'tools' module with
rem  the ASH shell provided by the 'tools-win32' module.
rem
rem  @author Jason Dillon <jason@planet57.com>
rem

rem $Id: ubuild.bat 21628 2008-08-19 22:06:02Z pgier $

setlocal

set PROGNAME=%~nx0
set DIRNAME=%~dp0

rem Legacy shell support
if x%PROGNAME%==x set PROGNAME=build.bat
if x%DIRNAME%==x set DIRNAME=.\

rem If not started by the loader script then setup some values
if x%TOOLS_ROOT%==x set TOOLS_ROOT=%DIRNAME%..
if x%MODULE_ROOT%==x set MODULE_ROOT=.

set SHELL=%TOOLS_ROOT%\win32\ash.exe
set SHELL_OPTS=
if not x%TRACE%==x set SHELL_OPTS=-x

set BUILD_SH=%TOOLS_ROOT%\bin\build.sh
set FALLBACK_BUILD_BAT=%TOOLS_ROOT%\bin\fb-build.bat
set ARGS=%*

rem Setup the command search path to include our binaries
set PATH=%TOOLS_ROOT%\win32;%TOOLS_ROOT%\bin;%PATH%

rem Start'er up yo
goto main

:debug
if not x%DEBUG%==x echo %PROGNAME%: %*
goto :EOF

:main
call :debug PROGNAME=%PROGNAME%
call :debug DIRNAME=%DIRNAME%
call :debug TOOLS_ROOT=%TOOLS_ROOT%
call :debug MODULE_ROOT=%MODULE_ROOT%
call :debug SHELL=%SHELL%
call :debug PATH=%PATH%

if exist %SHELL% goto :check-script & goto :EOF
rem else fail, we can not go on (might consider just calling ant here 
rem %FALLBACK_BUILD_BAT%)

echo %PROGNAME%: *ERROR* The command shell does not exist:
echo %PROGNAME%:
echo %PROGNAME%:    %SHELL%
echo %PROGNAME%:
echo %PROGNAME%: Please make sure you have checked out the 'tools-win32' 
echo %PROGNAME%: module and make sure it is up to date.
goto :EOF

:check-script
call :debug BUILD_SH=%BUILD_SH%
if exist %BUILD_SH% goto :execute-shell & goto :EOF
rem else fail, we can not go on

echo %PROGNAME%: *ERROR* The target script does not exist:
echo %PROGNAME%:
echo %PROGNAME%:    %BUILD_SH%
echo %PROGNAME%:
echo %PROGNAME%: Please make sure you have checked out the 'tools' 
echo %PROGNAME%: module and make sure it is up to date.
goto :EOF

:execute-shell
call :debug Executing %SHELL% %SHELL_OPTS% %BUILD_SH% %ARGS%
%SHELL% %SHELL_OPTS% %BUILD_SH% %ARGS%

if x%NOPAUSE%==x pause

goto :EOF
