package org.jboss.cache.marshall;

import org.jboss.cache.Fqn;

/**
 * A return value that holds region information, so that the marshaller knows which region to use (and hence which
 * class loader to use) when marshalling this return value.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.1.1
 */
class RegionalizedReturnValue
{
   final Object returnValue;
   final Fqn region;

   /**
    * Creates this value object.
    *
    * @param returnValue            return value to marshall
    * @param regionalizedMethodCall method call that requested this return value.
    */
   RegionalizedReturnValue(Object returnValue, RegionalizedMethodCall regionalizedMethodCall)
   {
      this.returnValue = returnValue;
      this.region = regionalizedMethodCall.region;
   }
}
