package jdepend.framework;

import java.io.*;

import junit.framework.*;

/**
 * The <code>JDependTestCase</code> is the base 
 * <code>TestCase</code> for all JDepend tests. 
 *
 * @author <b>Mike Clark</b> (mike@clarkware.com)
 * @author Clarkware Consulting, Inc.
 */
 
public class JDependTestCase extends TestCase {

	private String homeDir;
	private String testDataDir;
	private String testDir;
	private String srcDir;
	private String classesDir;
    private String libDir;
	private String originalUserHome;
	
	public JDependTestCase(String name) {
		super(name);
	}

	protected void setUp() {
	    
        homeDir = System.getProperty("jdepend.home");
        if (homeDir == null) {
            fail("Property 'jdepend.home' not defined");
        }
        homeDir = homeDir + File.separator;
        
        testDir = homeDir +  "tests" + File.separator;
        testDataDir = testDir + "data" + File.separator;
        srcDir = homeDir + "src" + File.separator;
        classesDir = homeDir + "build" + File.separator;
        libDir = homeDir + "lib" + File.separator;
        originalUserHome = System.getProperty("user.home");
	}
	
	protected void tearDown() {
        System.setProperty("user.home", originalUserHome);
	}
	
    public String getHomeDir() {
        return homeDir;
    }
	
    public String getTestDir() {
        return testDir;
    }
    
	public String getTestDataDir() {
	    return testDataDir;
	}
	
    public String getSrcDir() {
        return srcDir;
    }
	
    public String getClassesDir() {
        return classesDir;
    }
    
    public String getLibDir() {
        return libDir;
    }
}
