#!/bin/sh

BUILDDIR=`pwd`
GCJDIR=`dirname $0`

if test "$BUILDDIR" -ef "$GCJDIR"; then
  echo "You cannot build this library in this directory."
  echo "Make a separate directory and run this script from there."
  exit 1
fi

mkdir -p com/jcraft/jzlib
mkdir -p org/metastatic/jessie/https
mkdir -p org/metastatic/jessie/provider
mkdir -p org/metastatic/callbacks
mkdir -p javax/net/ssl
mkdir -p javax/security/cert

(cd $GCJDIR
 cp -rf ../com/jcraft/jzlib/*.java $BUILDDIR/com/jcraft/jzlib
 cp -rf ../javax/net/*.java $BUILDDIR/javax/net/
 cp -rf ../javax/net/ssl/*.java $BUILDDIR/javax/net/ssl/
 cp -rf ../javax/security/cert/*.java $BUILDDIR/javax/security/cert/
 cp -rf ../org/metastatic/callbacks/*.java $BUILDDIR/org/metastatic/callbacks/
 cp -rf ../org/metastatic/callbacks/*.properties $BUILDDIR/org/metastatic/callbacks/
 cp -rf ../org/metastatic/jessie/*.java $BUILDDIR/org/metastatic/jessie/
 cp -rf ../org/metastatic/jessie/https/*.java $BUILDDIR/org/metastatic/jessie/https/
 cp -rf ../org/metastatic/jessie/provider/*.java $BUILDDIR/org/metastatic/jessie/provider/
 cp -f ../org/metastatic/jessie/provider/Jessie.java.in $BUILDDIR/org/metastatic/jessie/provider/
 cp -f ../acinclude.m4 Makefile.am Makefile.in aclocal.m4 config.guess config.sub \
     configure.ac configure depcomp install-sh ltcf-c.sh ltcf-cxx.sh ltcf-gcj.sh \
     ltconfig ltmain.sh missing mkinstalldirs $BUILDDIR
)

echo "Files copied; use \`./configure' then \`make' to build Jessie"
