/* Constructed.java -- constructed type.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.io.IOException;
import java.io.OutputStream;

/**
 * The base interface to SSL constructed types.
 */
interface Constructed
{

  /**
   * Writes this structure's encoded form to the given output stream.
   *
   * @param out The output stream.
   * @throws IOException If an I/O error occurs.
   */
  void write(OutputStream out) throws IOException;
}
