#!/bin/bash
set -x

#Initialize basic scructure
DIRNAME=`dirname $0`
cd ${DIRNAME}
TRUNK_NIGHTLY_DIRNAME=`pwd`
export BUILD_DESC=6.7.1
source init.sh

rm -rf $DIST

if [ ! -z $WORKSPACE ]; then
    #I'm under hudson and have sources here, I need to clone them
    #Clean obsolete sources first
    rm -rf $NB_ALL
    hg clone $WORKSPACE $NB_ALL
fi

###################################################################
#
# Build all the components
#
###################################################################

cd $TRUNK_NIGHTLY_DIRNAME
bash build-all-components.sh
ERROR_CODE=$?

if [ $ERROR_CODE != 0 ]; then
    echo "ERROR: $ERROR_CODE - Build failed"
    exit $ERROR_CODE;
fi

###################################################################
#
# Pack all the components
#
###################################################################

cd $TRUNK_NIGHTLY_DIRNAME
bash pack-all-components.sh
ERROR_CODE=$?

if [ $ERROR_CODE != 0 ]; then
    echo "ERROR: $ERROR_CODE - Packaging failed"
    exit $ERROR_CODE;
fi

###################################################################
#
# Deploy bits to the storage server
#
###################################################################

if [ -n $BUILD_ID ]; then
    mkdir -p $DIST_SERVER2/${BUILD_ID}
    cp -rp $DIST/*  $DIST_SERVER2/${BUILD_ID}
    if [ -n "${TESTING_SCRIPT}" ]; then
        cd $NB_ALL
        TIP_REV=`hg tip --template "{node}"`
        ssh $TESTING_SCRIPT $TIP_REV
        cd $DIRNAME
    fi
fi

if [ $UPLOAD_ML == 1 ]; then
    mv $DIST/jnlp $DIST/ml/
    mv $DIST/javadoc $DIST/ml/
    cp $DIST/zip/$BASENAME-platform-src.zip $DIST/ml/zip/
    cp $DIST/zip/$BASENAME-src.zip $DIST/ml/zip/
    cp $DIST/zip/$BASENAME-javadoc.zip $DIST/ml/zip/
    cp $DIST/zip/hg-l10n-$BUILDNUMBER.zip $DIST/ml/zip/
    cp $DIST/zip/ide-l10n-$BUILDNUMBER.zip $DIST/ml/zip/
    cp $DIST/zip/stable-UC-l10n-$BUILDNUMBER.zip $DIST/ml/zip/
    cp $DIST/zip/testdist-$BUILDNUMBER.zip $DIST/ml/zip/
fi

cd $TRUNK_NIGHTLY_DIRNAME
## No installers build for sustaining builds
if [ "${SUSTAINING_BUILD}" == 1 ]; then
   echo "This is sustaining build, installers are not produced"
else
   bash build-nbi.sh
   ERROR_CODE=$?

   if [ $ERROR_CODE != 0 ]; then
      echo "ERROR: $ERROR_CODE - NBI installers build failed"
      exit $ERROR_CODE;
   fi
fi

if [ -n $BUILD_ID ]; then
    mkdir -p $DIST_SERVER2/${BUILD_ID}
    cp -rp $DIST/*  $DIST_SERVER2/${BUILD_ID}
    mv $DIST_SERVER2/latest $DIST_SERVER2/latest.old
    ln -s $DIST_SERVER2/${BUILD_ID} $DIST_SERVER2/latest
    if [ $UPLOAD_ML == 0 -a ML_BUILD != 0 ]; then
        rm -r $DIST/ml
    fi
fi

## Sustaining build deploys only NBMs to bits.netbeans.org
if [ "${SUSTAINING_BUILD}" == 1 ]; then
   mkdir -p $DIST/deploy
   mv $DIST/uc* $DIST/deploy/
   mkdir -p $DIST/deploy/ml
   mv $DIST/ml/uc* $DIST/deploy/ml/

   cp $DIST_SERVER2/latest/zip/netbeans-$BUILDNUM.zip $TEST_LOCATION/NetBeans.zip
   cp $DIST_SERVER2/latest/zip/netbeans-$BUILDNUM-java.zip $TEST_LOCATION/NetBeansJavaEE.zip
   cp $DIST_SERVER2/latest/zip/testdist-*.zip $TEST_LOCATION/testdist.zip
fi

if [ -z $DIST_SERVER ]; then
    exit 0;
fi

cd $TRUNK_NIGHTLY_DIRNAME
bash upload-bits.sh
