//
// nnfile.hh
//
// Made by Guillaume Stordeur
// Login   <kami@GrayArea.Masaq>
//
// Started on  Sat Apr  5 16:40:45 2003 Guillaume Stordeur
// Last update Mon May  5 21:49:06 2003 Guillaume Stordeur
//

#ifndef   	NNFILE_HH_
# define   	NNFILE_HH_

# include <cassert>
# include "neuralnet.hh"

namespace NeuralNet
{

class NNFile
{
public:
  // Constructor
  NNFile() { _type = _type_out = ACT_SIGMOID; }

  // Destructor
  ~NNFile() {}

  // Output to file
  void	outputFile(const std::string		filen,
		   ActivationFunctionType	type,
		   ActivationFunctionType	type_out,
		   const std::vector<t_layer>	&layers);

  // Input a neural net description file
  void	inputFile(const std::string	&filen);

  // Get the layer vector
  const std::vector<unsigned int>	&getLayers() const { return _layers; }

  // Get activation function type
  ActivationFunctionType	getType() const { return _type; }

  // Get activation function type for output layer
  ActivationFunctionType	getTypeOut() const { return _type_out; }

  // Get connections
  const std::vector<std::vector<float> > &getConnects() const { return _connects; }

  // Get thresholds
  const std::vector<std::vector<float> > &getThresholds() const { return _thresholds; }

  // Get fixed neurons
  const std::vector<std::vector<unsigned int> > &getFixed() const { return _fixed; }

  // Get timeLagged neurons
  const std::vector<std::vector<unsigned int> > &getTimeLagged() const { return _timeLagged; }

protected:

  // Neural net activation type
  ActivationFunctionType	_type, _type_out;

  // Layer vector
  std::vector<unsigned int>	_layers;

  // Thresholds
  std::vector<std::vector<float> > _thresholds;

  // Connections
  std::vector<std::vector<float> > _connects;

  // Fixed neurons
  std::vector<std::vector<unsigned int> > _fixed, _timeLagged;


  // Input functions
  void	_inputLayers(const std::string &line);
  void	_inputHiddenActivation(const std::string &line);
  void	_inputOutputActivation(const std::string &line);
  void	_inputConnect(const std::string &line);
  void	_inputThreshold(const std::string &line);
  void	_inputFixed(const std::string &line);
  void	_inputTimeLagged(const std::string &line);
  std::vector<unsigned int> _getLayerIndices(char *layer);
  void	_makeCombinations(unsigned int srcLayer,
			  unsigned int srcNeuron,
			  const std::vector<unsigned int> &dstLayerIdx,
			  int dnidx, int random, float value);
  // Dump activation function type
  void	_dumpActivation(std::ofstream &file);

  // Dump header
  void	_dumpHeader(std::ofstream &file);

  // Dump threshold values
  void	_dumpThresholds(std::ofstream &file,
			const std::vector<t_layer>	&layers);
  // Dump fixed neurons
  void	_dumpFixed(std::ofstream &file,
		   const std::vector<t_layer>	&layers);
  // Dump timeLagged neurons
  void	_dumpTimeLagged(std::ofstream &file,
			const std::vector<t_layer>	&layers);
  // Dump layer info
  void	_dumpLayers(std::ofstream &file,
		    const std::vector<t_layer>	&layers);
  // Dump connection weights
  void	_dumpWeights(std::ofstream &file,
		     const std::vector<t_layer>	&layers);
  // Get neurons connected to neuron
  // returns a vector of (layer, neuron, weight) vectors
  std::vector<std::vector<float> > _getConnect(const std::vector<t_layer> &layers,
					       Neuron *neuron);

};

} //end NeuralNet namespace

#endif	    /* !NNFILE_HH_ */
