//
// trainer.cc
//  
// Made by Guillaume Stordeur
// Login   <kami@GrayArea.Masaq>
// 
// Started on  Sun May  18 15:55:03 2002 Guillaume Stordeur
// Last update Sun May  18 16:02:12 2002 Guillaume Stordeur
//

#include <stdlib.h>
#include <iostream>
#include <vector>
#include "neuralnet.hh"
#include <exception/exception.hh>
#include <data/csvloader.hh>

//
// Main
//
int	main(int argc, char *argv[])
{  
  srand(time(NULL));

  if (argc < 4)
    {
      std::cerr << "Usage: tester network.nn data.csv separator outputColumn [outputColumn2, ...]\n";
      return 1;
    }

  // Init cvsloader and get cols
  std::string csvfile(argv[2]);
  Data::CsvLoader	loader;
  std::vector<Data::Column*>	cols;
  cols = loader.read_file(csvfile, argv[3][0]);

  // Init neural net
  NeuralNet::NeuralNet	nn(argv[1]);
 
  // Build the outputCols vector
  std::vector<std::string> outputCols;
  for (unsigned int i = 4; i < argc; i++)
    outputCols.push_back(argv[i]);
  
  // Check that the outputColumns are in the data
  unsigned int out = 0;
  for (unsigned int j = 0; j < outputCols.size(); j++)
    for (unsigned int i = 0; i < cols.size(); i++)
      {
	if (!strcmp(cols[i]->get_name().c_str(), outputCols[j].c_str()))
	  {
	    std::cerr << "Found the output variable: " << outputCols[j] << std::endl;
	    out++;
	    break;
	  }
      }
  // Check for size differences inputs/outputs with the nn
  if (out != outputCols.size())
    {
      std::cerr << "ERROR: Could not find all output variables in " << csvfile << std::endl;
      return 1;
    }
  if (nn.getNbInputNeurons() != (cols.size() - out))
    {
      std::cerr << "ERROR: Data inputs do not match number of input neurons:" << std::endl;
      std::cerr << "       nbInputNeurons = " << nn.getNbInputNeurons() << std::endl;
      std::cerr << "       nbDataInputs   = " << cols.size() - out << std::endl;
      return 1;
    }
  if (nn.getNbOutputNeurons() != out)
    {
      std::cerr << "ERROR: Data outputs do not match number of output neurons:" << std::endl;
      std::cerr << "       nbOutputNeurons = " << nn.getNbOutputNeurons() << std::endl;
      std::cerr << "       nbDataOutputs   = " << out << std::endl;
      return 1;
    }
  
  // Make Training Pattern (inputs, results)
  float error = 0;
  std::vector<float> dres, input, output;
  std::vector<std::vector<float> > inputs, results;

  for (unsigned int j = 0; j < cols[0]->get_size(); j++)
    {
      input.clear();
      dres.clear();
      for (unsigned int i = 0; i < cols.size(); i++)
	{
	  if (cols[i]->get_type() == Data::STRING)
	    {
	      std::cerr << "ERROR: This tester does not support strings,";
	      std::cerr << "please discretize the data first." << std::endl;
	      return 1;
	    }
	  int out = 0;
	  float value;
	  if (cols[i]->get_type() == Data::INT)
	    value = (float) (dynamic_cast<Data::ColumnTyped<int>*> (cols[i]))->get_value(j);
	  else if (cols[i]->get_type() == Data::FLOAT)
	    value = (dynamic_cast<Data::ColumnTyped<float>*> (cols[i]))->get_value(j);
	  
	  for (unsigned k = 0; k < outputCols.size(); k++)
	    if (!strcmp(cols[i]->get_name().c_str(), outputCols[k].c_str()))
	      out = 1;
	  if (out)
	    dres.push_back(value);
	  else
	    input.push_back(value);
	}
      output = nn.output(input);
      for (unsigned int k = 0; k < output.size(); k++)
	error += (output[k] - dres[k]) * (output[k] - dres[k]) * 0.5; 
    }
  std::cout << "Mean Square Error: " << error << std::endl;
  return 0;
}
