# Web::Persistent::Store::GDBM
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'gdbm'

module Web
  class Persistent
    module Store
      class GDBM < DBM
        def initialize(persistent_id, options={})
          @dir = options[:dir] || '/tmp'
          @path = ::File.join(@dir, persistent_id)
          @dbm = nil
        end
        
        def key_limit
          1024
        end
        
        def data_limit
          65536 - 1024 
        end
        
        def open
          @dbm = ::GDBM.open(@path)
        end
        
      end # GDBM
    end # Store
  end # Persistent
end # Web
