$:.unshift '../lib'
require 'test/unit'
require "stringio"
require 'web/agent/robots'

class TC_Robots < Test::Unit::TestCase
  def setup
    robots=StringIO.new(<<-EOS)
User-agent: robots1
Disallow: /tmp

User-agent: robots2
Disallow: /tmp/

User-agent: robots3
Disallow: /a%3cd.html

User-agent: robots4
Disallow: /a%3Cd.html

User-agent: robots5
Disallow: /a%2fb.html

User-agent: robots6
Disallow: /a/b.html

User-agent: robots7
Disallow: /%7ejoe/index.html

User-agent: robots8
Disallow: /~joe/index.html

# /robots.txt for http://www.fict.org/
# comments to webmaster@fict.org

User-agent: unhipbot
Disallow: /

User-agent: webcrawler
User-agent: excite
Disallow: 

User-agent: *
Disallow: /org/plans.html
Allow: /org/
Allow: /serv
Allow: /~mak
Disallow: /

EOS
    @r = Web::Agent::Robots.new
    @r.parse(robots)
  end

  # def teardown
  # end

  def test_robots1
    assert_equal(true,  @r.disallowed?('robots1','/tmp'))
    assert_equal(true,  @r.disallowed?('robots1','/tmp.html'))
    assert_equal(true,  @r.disallowed?('robots1','/tmp/a.html'))
  end

  def test_robots2
    assert_equal(false, @r.disallowed?('robots2','/tmp'))
    assert_equal(true,  @r.disallowed?('robots2','/tmp/'))
    assert_equal(true,  @r.disallowed?('robots2','/tmp/a.html'))
  end

  def test_robots3
    assert_equal(true,  @r.disallowed?('robots3','/a%3cd.html'))
    assert_equal(true,  @r.disallowed?('robots3','/a%3Cd.html'))
  end

  def test_robots4
    assert_equal(true,  @r.disallowed?('robots4','/a%3cd.html'))
    assert_equal(true,  @r.disallowed?('robots4','/a%3Cd.html'))
  end

  def test_robots5
    assert_equal(true,  @r.disallowed?('robots5','/a%2fb.html'))
    assert_equal(false, @r.disallowed?('robots5','/a/b.html'))
  end

  def test_robots6
    assert_equal(false, @r.disallowed?('robots6','/a%2fb.html'))
    assert_equal(true,  @r.disallowed?('robots6','/a/b.html'))
  end

  def test_robots7
    assert_equal(true,  @r.disallowed?('robots7','/~joe/index.html'))
  end

  def test_robots8
    assert_equal(true,  @r.disallowed?('robots8','/%7Ejoe/index.html'))
  end

  def test_unhipbot
    assert_equal(false, @r.allowed?('unhipbot','/'))
    assert_equal(false, @r.allowed?('unhipbot','/index.html'))
    assert_equal(true,  @r.allowed?('unhipbot','/robots.txt'))
    assert_equal(false, @r.allowed?('unhipbot','/server.html'))
    assert_equal(false, @r.allowed?('unhipbot','/services/fast.html'))
    assert_equal(false, @r.allowed?('unhipbot','/services/slow.html'))
    assert_equal(false, @r.allowed?('unhipbot','/orgo.gif'))
    assert_equal(false, @r.allowed?('unhipbot','/org/about.html'))
    assert_equal(false, @r.allowed?('unhipbot','/org/plans.html'))
    assert_equal(false, @r.allowed?('unhipbot','/%7Ejim/jim.html'))
    assert_equal(false, @r.allowed?('unhipbot','/%7Emak/mak.html'))
  end

  def test_webcrawler
    assert_equal(true,  @r.allowed?('webcrawler','/'))
    assert_equal(true,  @r.allowed?('webcrawler','/index.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/robots.txt'))
    assert_equal(true,  @r.allowed?('webcrawler','/server.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/services/fast.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/services/slow.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/orgo.gif'))
    assert_equal(true,  @r.allowed?('webcrawler','/org/about.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/org/plans.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/%7Ejim/jim.html'))
    assert_equal(true,  @r.allowed?('webcrawler','/%7Emak/mak.html'))
  end

  def test_excite
    assert_equal(true,  @r.allowed?('excite','/'))
    assert_equal(true,  @r.allowed?('excite','/index.html'))
    assert_equal(true,  @r.allowed?('excite','/robots.txt'))
    assert_equal(true,  @r.allowed?('excite','/server.html'))
    assert_equal(true,  @r.allowed?('excite','/services/fast.html'))
    assert_equal(true,  @r.allowed?('excite','/services/slow.html'))
    assert_equal(true,  @r.allowed?('excite','/orgo.gif'))
    assert_equal(true,  @r.allowed?('excite','/org/about.html'))
    assert_equal(true,  @r.allowed?('excite','/org/plans.html'))
    assert_equal(true,  @r.allowed?('excite','/%7Ejim/jim.html'))
    assert_equal(true,  @r.allowed?('excite','/%7Emak/mak.html'))
  end

  def test_other
    assert_equal(false, @r.allowed?('other','/'))
    assert_equal(false, @r.allowed?('other','/index.html'))
    assert_equal(true,  @r.allowed?('other','/robots.txt'))
    assert_equal(true,  @r.allowed?('other','/server.html'))
    assert_equal(true,  @r.allowed?('other','/services/fast.html'))
    assert_equal(true,  @r.allowed?('other','/services/slow.html'))
    assert_equal(false, @r.allowed?('other','/orgo.gif'))
    assert_equal(true,  @r.allowed?('other','/org/about.html'))
    assert_equal(false, @r.allowed?('other','/org/plans.html'))
    assert_equal(false, @r.allowed?('other','/%7Ejim/jim.html'))
    assert_equal(true,  @r.allowed?('other','/%7Emak/mak.html'))
  end
end
