package ru.novosoft.uml.gen;
import java.util.*;
import java.io.*;
import ru.novosoft.uml.gen.mmm.*;

public class GenMMClassImpl extends GenMMWriter
{
  MClass thisClass;
  
  GenMMClassImpl(GenMM g, MClass c) throws IOException
  {
    super(g, getPackage(c), iname(c)+".java");
    try
    {
      thisClass = c;
      prolog();
      line("package "+getPackage(c)+";");
      println();

      imports(c);
      println();

      line("import java.lang.reflect.Method;");
      println();

      sline("public ");
      if (c.isAbstract())
      {
        print("abstract ");
      }
      print("class "+iname(c));
      Iterator i = c.getSuperClasses().iterator();
      MClass sc = null;
      if (i.hasNext())
      {
        sc = (MClass)i.next();
        print(" extends "); print(iname(sc));
      }
      else
      {
        //System.out.println("ERROR: Class does not have superclass: "+c.getName());
        //throw new RuntimeException("ERROR: Class does not have superclass: "+c.getName());
      }
      print(" implements "+cname(c));
      if ("Base".equals(c.getName()))
      {
        print(", java.io.Serializable");
      }
      println();
      sblock();
      HashSet all = new HashSet();
      HashSet sc1 = new HashSet();
      getSuperclasses(c, all);
      getSuperclasses(sc, sc1);
      HashSet notImpl = new HashSet(all);
      notImpl.removeAll(sc1);
      notImpl.remove(sc);
      notImpl.add(c);
      i = notImpl.iterator();
      while (i.hasNext())
      {
        MClass ic = (MClass)i.next();
        line("// ------------ code for class "+ic.getName()+" -----------------");
        generateStructure(ic);
      }
      generateCleanup(notImpl);

      println();
      line("public String getUMLClassName()");
      sblock();
      line("return \"" + c.getName() + "\";");
      eblock();

      println();
      line("// Reflective API");
      println();

      generateReflective(notImpl);

      generateCompositionSupport(notImpl);

      //generateConstructors();

      i = notImpl.iterator();
      while (i.hasNext())
      {
        MClass ic = (MClass)i.next();
        appendResource(getPackage(ic), iname(ic) + ".user");
      }

      appendResource(getPackage(c), iname(c) + ".create");

      eblock();
    }
    finally
    {
      close();
    }
  }

  // Constructors

  void generateConstructors()
  {
    sline("public "); print(iname(thisClass)); println("()");
    sblock();
    line("super();");
    eblock();
    println();

    sline("public "); print(iname(thisClass)); println("(String uuid)");
    sblock();
    line("super(uuid);");
    eblock();
  }

  // Reflective API

  void generateReflective(Set notImpl)
  {
    generateReflectiveGetValue(notImpl);
    println();
    generateReflectiveSetValue(notImpl);
    println();
    generateReflectiveAddValue(notImpl);
    println();
    generateReflectiveRemoveValue(notImpl);

    println();
    generateReflectiveGetValue2(notImpl);
    println();
    generateReflectiveSetValue2(notImpl);
    println();
    generateReflectiveAddValue2(notImpl);
    println();
    generateReflectiveRemoveValue2(notImpl);
  }

  String convertExpressionToObject(MClass p_cls, String p_expression)
  { 
    String cnm = cname(p_cls);

    if (cnm.equals("boolean"))
    {
      return "new Boolean(" + p_expression + ")";
    }

    if (cnm.equals("int"))
    {
      return "new Integer(" + p_expression + ")";
    }

    return p_expression;
  }

  String convertObjectToExpression(MClass p_cls, String p_object)
  { 
    String cnm = cname(p_cls);

    if (cnm.equals("boolean"))
    {
      return "((Boolean)" + p_object + ").booleanValue()";
    }

    if (cnm.equals("int"))
    {
      return "((Integer)" + p_object + ").intValue()";
    }

    return "(" + cnm + ")" + p_object;
  }

  void generateCompositionSupport(Set notImpl)
  {
    line("public Collection getModelElementContents()");
    sblock();

    if (thisClass.getSuperClasses().size()<1)
    {
      sline("Collection ret = new "); print(ibag); println("();");
    }
    else
    {
      line("Collection ret = super.getModelElementContents();");
    }

    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();

      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        if (tr.isComposite())
        {
          if (or.getKind().equals("ref"))
          {
            sline("ret.add("); print(rgetter(or)); println(");");
          }
          else if (or.getKind().equals("bag"))
          {
            sline("ret.addAll("); print(bgetter(or)); println(");");
          }
          else if (or.getKind().equals("list"))
          {
            sline("ret.addAll("); print(bgetter(or)); println(");");
          }
        }
      }
    }

    line("return ret;");

    eblock();
  }

  void generateReflectiveGetValue(Set notImpl)
  {
    line("public Object reflectiveGetValue(String feature)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();

      Iterator i = c.getAttributes().iterator();
      while (i.hasNext())
      {
        MAttribute at = (MAttribute)i.next();
        sif("\"" + at.getName() + "\".equals(feature)");
        sline("return "); print(convertExpressionToObject(at.getType(), agetter(at))); println(";");
        eif();
      }

      i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        if (or.getKind().equals("ref"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline("return "); print(rgetter(or)); println(";");
          eif();
        }
        else if (or.getKind().equals("bag"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline("return "); print(bgetter(or)); println(";");
          eif();
        }
        else if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline("return "); print(bgetter(or)); println(";");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("return super.reflectiveGetValue(feature);");
    }

    eblock();
  }

  void generateReflectiveSetValue(Set notImpl)
  {
    line("public void reflectiveSetValue(String feature, Object obj)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();

      Iterator i = c.getAttributes().iterator();
      while (i.hasNext())
      {
        MAttribute at = (MAttribute)i.next();
        sif("\"" + at.getName() + "\".equals(feature)");
        sline(asetter(at, convertObjectToExpression(at.getType(), "obj"))); println(";");
        line("return;");
        eif();
      }

      i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        if (or.getKind().equals("ref"))
        {
          String otype = cname(or.getType());
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(rsetter(or, "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
        else if (or.getKind().equals("bag"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(bsetter(or, "(" + bag + ")obj")); println(";");
          line("return;");
          eif();
        }
        else if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(bsetter(or, "(" + list + ")obj")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveSetValue(feature, obj);");
    }

    eblock();
  }

  void generateReflectiveAddValue(Set notImpl)
  {
    line("public void reflectiveAddValue(String feature, Object obj)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String otype = cname(or.getType());
        if (or.getKind().equals("bag"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(badder(or, "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
        else if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(badder(or, "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveAddValue(feature, obj);");
    }

    eblock();
  }

  void generateReflectiveRemoveValue(Set notImpl)
  {
    line("public void reflectiveRemoveValue(String feature, Object obj)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String otype = cname(or.getType());
        if (or.getKind().equals("bag"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(bremover(or, "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
        else if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(bremover(or, "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveRemoveValue(feature, obj);");
    }

    eblock();
  }

  // Reflective API for pos

  void generateReflectiveGetValue2(Set notImpl)
  {
    line("public Object reflectiveGetValue(String feature, int pos)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline("return "); print(lgetter(or, "pos")); println(";");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("return super.reflectiveGetValue(feature, pos);");
    }

    eblock();
  }

  void generateReflectiveSetValue2(Set notImpl)
  {
    line("public void reflectiveSetValue(String feature, int pos, Object obj)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String otype = cname(or.getType());
        if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(lsetter(or, "pos", "(" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveSetValue(feature, pos, obj);");
    }

    eblock();
  }

  void generateReflectiveAddValue2(Set notImpl)
  {
    line("public void reflectiveAddValue(String feature, int pos, Object obj)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String otype = cname(or.getType());
        if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(badder(or, "pos, (" + otype + ")obj")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveAddValue(feature, pos, obj);");
    }

    eblock();
  }

  void generateReflectiveRemoveValue2(Set notImpl)
  {
    line("public void reflectiveRemoveValue(String feature, int pos)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String otype = cname(or.getType());
        if (or.getKind().equals("list"))
        {
          sif("\"" + or.getName() + "\".equals(feature)");
          sline(lremover(or, "pos")); println(";");
          line("return;");
          eif();
        }
      }
    }

    println();
    if (thisClass.getSuperClasses().size()<1)
    {
      line("throw new IllegalArgumentException();");
    }
    else
    {
      line("super.reflectiveRemoveValue(feature, pos);");
    }

    eblock();
  }

  void generateCleanup(Set notImpl)
  {
    line("protected void cleanup(Collection scheduledForRemove)");
    sblock();
    Iterator j = notImpl.iterator();
    while (j.hasNext())
    {
      MClass c = (MClass)j.next();
      Iterator i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        String vnm = vname(or.getName());
        line("// opposite role: "+or.getName()+" this role: "+tr.getName());
        if (or.getKind().equals("ref"))
        {
          sif(vnm+" != null ");
          if (tr.isComposite())
          {
            line("scheduledForRemove.add("+vnm+");");
          }
          line(rsetter(or,"null")+";");
          eif();
        }
        else if (or.getKind().equals("bag"))
        {
          sif(vnm+".size() != 0");
          if (tr.isComposite())
          {
            line("scheduledForRemove.addAll("+vnm+");");
          }
          line(bsetter(or,"Collections.EMPTY_LIST")+";");
          eif();
        }
        else if (or.getKind().equals("list"))
        {
          sif(vnm+".size() != 0");
          if (tr.isComposite())
          {
            line("scheduledForRemove.addAll("+vnm+");");
          }
          line(bsetter(or,"Collections.EMPTY_LIST")+";");
          eif();
        }
      }
    }
    if (thisClass.getSuperClasses().size()>0)
    {
      line("super.cleanup(scheduledForRemove);");
    }
    eblock();

  }

  void generateStructure(MClass c)
  {
    line("// generating attributes");
    Iterator i = c.getAttributes().iterator();
    while (i.hasNext())
    {
      MAttribute at = (MAttribute)i.next();
      line("// attribute: "+at.getName());
      generateAttribute(at);
    }
    line("// generating associations");
    i = c.getRoles().iterator();
    while (i.hasNext())
    {
      MRole tr = (MRole)i.next();
      MRole or = oppositeRole(tr);
      line("// opposite role: "+or.getName()+" this role: "+tr.getName());
      if (or.getKind().equals("ref"))
      {
        generateRefRole(tr,or);
      }
      else if (or.getKind().equals("bag"))
      {
        generateBagRole(tr,or);
      }
      else if (or.getKind().equals("list"))
      {
        generateListRole(tr,or);
      }
    }
  }


  void generateAttribute(MAttribute at)
  {
    String type = cname(at.getType());
    String vnm = vname(at.getName());
    // variable definition
    line("private final static Method "+vnm+"_setMethod = getMethod1("+iname(thisClass)+".class, \""+asetterName(at)+"\", "+type+".class);");
    line(type+" "+vnm+";");
    line("public final "+type+" "+agetter(at));
    sblock();
    line("checkExists();");
    line("return "+vnm+";");
    eblock();
    line("public final "+"void "+asetter(at, type+" __arg"));
    smodifier();
    line("checkExists();");
    line("logAttrSet("+vnm+"_setMethod, "+vnm+", __arg);");
    line("fireAttrSet(\""+at.getName()+"\", "+vnm+", __arg);");
    line(vnm+" = __arg;");
    emodifier();
  }


  void generateRefRole(MRole tr, MRole or)
  {
    String otype = cname(or.getType());
    String onm = or.getName();
    String vnm = vname(onm);
    // variable definition
    if (!"list".equals(tr.getKind()))
    {
      line("private final static Method "+vnm+"_setMethod = getMethod1("+iname(thisClass)+".class, \""+rsetterName(or)+"\", "+otype+".class);");
    }
    line(otype+" "+vnm+";");
    line("public final "+otype+" "+rgetter(or));
    sblock();
    line("checkExists();");
    line("return "+vnm+";");
    eblock();
    line("public final void "+rsetter(or,otype+" __arg"));
    smodifier();
    line("checkExists();");
    if ("list".equals(tr.getKind()))
    {
      sif(vnm+" != __arg");
      sif(vnm+" != null");
      line(vnm+"."+bremover(tr,"this")+";");
      eif();
      sif("__arg != null");
      line("__arg."+badder(tr,"this")+";");
      eif();
      eif();
    }
    else
    {
      line(otype+" __saved = "+vnm+";");
      sif(vnm+" != __arg");
      sif("__saved != null");
      line(unrefThis(tr,"__saved"));
      eif();
      sif("__arg != null");
      line(refThis(tr,"__arg"));
      eif();
      line("logRefSet("+vnm+"_setMethod, __saved, __arg);");
      line("fireRefSet(\""+or.getName()+"\", __saved, __arg);");
      line(vnm+" = __arg;");
      if (or.isComposite())
      {
        sline("setModelElementContainer("); print(vnm); println(", \"" + or.getName() + "\");");
      }
      eif();
    }
    emodifier();
    line("public final void "+ref(or,otype+" __arg"));
    sblock();
    line(otype+" __saved = "+vnm+";");
    if ("ref".equals(tr.getKind()))
    {
      sif("__saved != null");
      line("__saved."+rsetter(tr,"null")+";");
      eif();
    }
    else //bag or list role
    {
      sif(vnm+" != null");
      line(vnm+"."+bremover(tr,"this")+";");
      eif();
    }
    line("fireRefSet(\""+or.getName()+"\", __saved, __arg);");
    line(vnm+" = __arg;");
    if (or.isComposite())
    {
      sline("setModelElementContainer("); print(vnm); println(", \"" + or.getName() + "\");");
    }
    eblock();
    line("public final void "+unref(or,otype+" __arg"));
    sblock();
    line("fireRefSet(\""+or.getName()+"\", "+vnm+", null);");
    line(vnm+" = null;");
    if (or.isComposite())
    {
      line("setModelElementContainer(null, null);");
    }
    eblock();
  }

  void generateBagRole(MRole tr, MRole or)
  {
    String otype = cname(or.getType());
    String onm = or.getName();
    String vnm = vname(onm);
    if (!"list".equals(tr.getKind()))
    {
      line("private final static Method "+vnm+"_setMethod = getMethod1("+iname(thisClass)+".class, \""+bsetterName(or)+"\", "+bag+".class);");
      line("private final static Method "+vnm+"_addMethod = getMethod1("+iname(thisClass)+".class, \""+badderName(or)+"\", "+otype+".class);");
      line("private final static Method "+vnm+"_removeMethod = getMethod1("+iname(thisClass)+".class, \""+bremoverName(or)+"\", "+otype+".class);");
    }

    // variable definition
    line(bag+" "+vnm+" = Collections.EMPTY_LIST;");
    line(bag+" "+vnm+"_ucopy = Collections.EMPTY_LIST;");

    // bgetter
    line("public final "+bag+" "+bgetter(or));
    sblock();
    line("checkExists();");
    sif("null == " + vnm + "_ucopy");
    line(vnm + "_ucopy = ucopy(" + vnm + ");");
    eif();
    line("return "+vnm+"_ucopy;");
    eblock();

    // bsetter
    line("public final void "+bsetter(or,bag+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    if (!"list".equals(tr.getKind()))
    {
      line("final boolean sendEvent = needEvent();");
      line("final boolean logForUndo = needUndo();");
      line(bag + " old = null;");
      sif("sendEvent || logForUndo");
      sline("old = "); print(bgetter(or)); println(";");
      eif();
      line(vnm + "_ucopy = null;");
    }
    line(bag+" __added = bagdiff(__arg,"+vnm+");");
    line(bag+" __removed = bagdiff("+vnm+", __arg);");
    if ("list".equals(tr.getKind()))
    {
      sforeach("__removed",otype,"o");
      line("o."+bremover(tr,"this")+";");
      eforeach();
      sforeach("__added",otype,"o");
      line("o."+badder(tr,"this")+";");
      eforeach();
    }
    else
    {
      sforeach("__removed",otype,"o");
      line(unrefThis(tr,"o"));
      eforeach();
      sforeach("__added",otype,"o");
      line(refThis(tr,"o"));
      eforeach();
      line(vnm+" = new "+ibag+"(__arg);");
      sif("logForUndo");
      line("logBagSet("+vnm+"_setMethod, old, "+bgetter(or)+");");
      eif();
      sif("sendEvent");
      line("fireBagSet(\""+or.getName()+"\", old, "+bgetter(or)+");");
      eif();
    }
    emodifier();

    //badder
    line("public final void "+badder(or,otype+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    if ("list".equals(tr.getKind()))
    {
      line("__arg."+badder(tr,"this")+";");
    }
    else
    {
      line("final boolean sendEvent = needEvent();");
      line(bag + " old = null;");
      sif("sendEvent");
      sline("old = "); print(bgetter(or)); println(";");
      eif();
      sif("null != " + vnm + "_ucopy");
      //line(vnm + " = (" + bag + ")((" + ibag + ")" + vnm + ").clone();");
      line(vnm + " = new " + ibag + "(" + vnm + ");");
      line(vnm + "_ucopy = null;");
      eif();
      line(refThis(tr,"__arg"));
      line(vnm+".add(__arg);");
      line("logBagAdd("+vnm+"_addMethod, "+vnm+"_removeMethod, __arg);");
      sif("sendEvent");
      line("fireBagAdd(\""+or.getName()+"\", old, "+bgetter(or)+", __arg);");
      eif();
    }
    emodifier();

    //bremover
    line("public final void "+bremover(or,otype+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    if ("list".equals(tr.getKind()))
    {
      line("__arg."+bremover(tr,"this")+";");
    }
    else
    {
      line("final boolean sendEvent = needEvent();");
      line(bag + " old = null;");
      sif("sendEvent");
      sline("old = "); print(bgetter(or)); println(";");
      eif();
      sif("null != " + vnm + "_ucopy");
      line(vnm + " = new " + ibag + "(" + vnm + ");");
      //line(vnm + " = (" + bag + ")((" + ibag + ")" + vnm + ").clone();");
      line(vnm + "_ucopy = null;");
      eif();
      sif("!" + vnm+".remove(__arg)");
      line("throw new RuntimeException(\"removing not added object\");");
      eif();
      line(unrefThis(tr,"__arg"));
      line("logBagRemove("+vnm+"_removeMethod, "+vnm+"_addMethod, __arg);");
      sif("sendEvent");
      line("fireBagRemove(\""+or.getName()+"\", old, "+bgetter(or)+", __arg);");
      eif();
    }
    emodifier();

    line("public final void "+ref(or,otype+" __arg"));
    sblock();
    line("final boolean sendEvent = needEvent();");
    line(bag + " old = null;");
    sif("sendEvent");
    sline("old = "); print(bgetter(or)); println(";");
    eif();
    sif("null != " + vnm + "_ucopy");
    //line(vnm + " = (" + bag + ")((" + ibag + ")" + vnm + ").clone();");
    line(vnm + " = new " + ibag + "(" + vnm + ");");
    line(vnm + "_ucopy = null;");
    eif();
    line(vnm+".add(__arg);");
    sif("sendEvent");
    line("fireBagAdd(\""+or.getName()+"\", old, "+bgetter(or)+", __arg);");
    eif();
    eblock();

    line("public final void "+unref(or,otype+" __arg"));
    sblock();
    line("final boolean sendEvent = needEvent();");
    line(bag + " old = null;");
    sif("sendEvent");
    sline("old = "); print(bgetter(or)); println(";");
    eif();
    sif("null != " + vnm + "_ucopy");
    //line(vnm + " = (" + bag + ")((" + ibag + ")" + vnm + ").clone();");
    line(vnm + " = new " + ibag + "(" + vnm + ");");
    line(vnm + "_ucopy = null;");
    eif();
    line(vnm+".remove(__arg);");
    sif("sendEvent");
    line("fireBagRemove(\""+or.getName()+"\", old, "+bgetter(or)+", __arg);");
    eif();
    eblock();
  }

  void generateListRole(MRole tr, MRole or)
  {
    String otype = cname(or.getType());
    String onm = or.getName();
    String vnm = vname(onm);

    // variable definition
    line("private final static Method "+vnm+"_setMethod = getMethod1("+iname(thisClass)+".class, \""+bsetterName(or)+"\", "+list+".class);");
    line("private final static Method "+vnm+"_removeMethod = getMethod1("+iname(thisClass)+".class, \""+lremoverName(or)+"\", int.class);");
    line("private final static Method "+vnm+"_addMethod = getMethod2("+iname(thisClass)+".class, \""+ladderName(or)+"\", int.class, "+otype+".class);");
    line("private final static Method "+vnm+"_listSetMethod = getMethod2("+iname(thisClass)+".class, \""+lsetterName(or)+"\", int.class, "+otype+".class);");

    line(list+" "+vnm+" = Collections.EMPTY_LIST;");
    line(list+" "+vnm+"_ucopy = Collections.EMPTY_LIST;");

    // bgetter
    line("public final "+list+" "+bgetter(or));
    sblock();
    line("checkExists();");
    sif("null == " + vnm + "_ucopy");
    line(vnm + "_ucopy = ucopy(" + vnm + ");");
    eif();
    line("return "+vnm+"_ucopy;");
    eblock();

    // bsetter
    line("public final void "+bsetter(or,list+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    line("final boolean sendEvent = needEvent();");
    line("final boolean logForUndo = needUndo();");
    line(list + " old = null;");
    sif("sendEvent || logForUndo");
    sline("old = "); print(bgetter(or)); println(";");
    eif();

    line(vnm + "_ucopy = null;");
    line(bag+" __added = bagdiff(__arg,"+vnm+");");
    line(bag+" __removed = bagdiff("+vnm+", __arg);");
    sforeach("__removed",otype,"o");
    line(unrefThis(tr,"o"));
    eforeach();
    sforeach("__added",otype,"o");
    line(refThis(tr,"o"));
    eforeach();
    line(vnm+" = new "+ilist+"(__arg);");
    sif("logForUndo");
    line("logBagSet("+vnm+"_setMethod, old, "+bgetter(or)+");");
    eif();
    sif("sendEvent");
    line("fireListSet(\""+or.getName()+"\", old, "+bgetter(or)+");");
    eif();
    emodifier();

    //badder
    line("public final void "+badder(or,otype+" __arg"));
    sblock();
    line(ladder(or,vnm+".size()", "__arg")+";");
    eblock();

    //bremover
    line("public final void "+bremover(or,otype+" __arg"));
    sblock();
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    line("int __pos = "+vnm+".indexOf(__arg);");
    line(lremover(or, "__pos")+";");
    eblock();

    //ladder
    line("public final void "+ladder(or,"int __pos",otype+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    line("final boolean sendEvent = needEvent();");
    line(list + " old = null;");
    sif("sendEvent");
    sline("old = "); print(bgetter(or)); println(";");
    eif();
    sif("null != " + vnm + "_ucopy");
    //line(vnm + " = (" + list + ")((" + ilist + ")" + vnm + ").clone();");
    line(vnm + " = new " + ilist + "(" + vnm + ");");
    line(vnm + "_ucopy = null;");
    eif();
    line(vnm+".add(__pos, __arg);");
    line(refThis(tr,"__arg"));
    line("logListAdd("+vnm+"_addMethod, "+vnm+"_removeMethod, __arg, __pos);");
    sif("sendEvent");
    line("fireListAdd(\""+or.getName()+"\", old, "+bgetter(or)+", __arg, __pos);");
    eif();
    emodifier();

    //lremover
    line("public final void "+lremover(or,"int __pos"));
    smodifier();
    line("checkExists();");
    line("final boolean sendEvent = needEvent();");
    line(list + " old = null;");
    sif("sendEvent");
    sline("old = "); print(bgetter(or)); println(";");
    eif();
    sif("null != " + vnm + "_ucopy");
    //line(vnm + " = (" + list + ")((" + ilist + ")" + vnm + ").clone();");
    line(vnm + " = new " + ilist + "(" + vnm + ");");
    line(vnm + "_ucopy = null;");
    eif();
    line(otype+" __arg = ("+otype+")"+vnm+".remove(__pos);");
    line(unrefThis(tr,"__arg"));
    line("logListRemove("+vnm+"_removeMethod, "+vnm+"_addMethod, __arg, __pos);");
    sif("sendEvent");
    line("fireListRemove(\""+or.getName()+"\", old, "+bgetter(or)+", __arg, __pos);");
    eif();
    emodifier();

    //lsetter
    line("public final void "+lsetter(or,"int __pos",otype+" __arg"));
    smodifier();
    line("checkExists();");
    sif("__arg == null");
    line("throw new NullPointerException();");
    eif();
    line("final boolean sendEvent = needEvent();");
    line(list + " old = null;");
    sif("sendEvent");
    sline("old = "); print(bgetter(or)); println(";");
    eif();
    sif("null != " + vnm + "_ucopy");
    //line(vnm + " = (" + list + ")(" + list + ")((" + ilist + ")" + vnm + ").clone();");
    line(vnm + " = new " + ilist + "(" + vnm + ");");
    line(vnm + "_ucopy = null;");
    eif();
    line(otype+" __old = ("+otype+")"+vnm+".get(__pos);");
    line(unrefThis(tr,"__old"));
    line(refThis(tr,"__arg"));
    line(vnm+".set(__pos,__arg);");
    line("logListSet("+vnm+"_listSetMethod, __old, __arg, __pos);");
    sif("sendEvent");
    line("fireListItemSet(\""+or.getName()+"\", old, "+bgetter(or)+", __old, __arg, __pos);");
    eif();
    emodifier();

    //lgetter
    line("public final "+otype+" "+lgetter(or,"int __pos"));
    sblock();
    line("checkExists();");
    line("return ("+otype+")"+vnm+".get(__pos);");
    eblock();
  }

  void smodifier()
  {
    sblock();
    line("operationStarted();");
    line("try");
    sblock();
  }
  void emodifier()
  {
    eblock();
    line("finally");
    sblock();
    line("operationFinished();");
    eblock();
    eblock();
  }
}
