Building
========

You are strongly encouraged to build in a different directory than your source.

    $ pwd
    $ /path/to/nunc-stans
    $ mkdir ../nsbuild ; cd ../nsbuild
    $ CFLAGS="-my -flags" ../nunc-stans/configure [--options]
    $ make [install]

If you want a typical Linux FHS layout on a 64-bit system, use

    ../nunc-stans.git/configure --with-fhs --libdir=/usr/lib64

You can also build in a private area

    ../nunc-stans.git/configure --prefix=$HOME/nunc-stans

If you need to change `configure.ac`, `Makefile.am`, a `.m4` file, or some other
autoconf related file, use `autogen.sh` to regenerate those files.

Versioning
----------

Change `configure.ac` to bump the version, then `autogen.sh` to refresh the
other autoconf related files.


Tests
-----

Use `make check` to run the tests.


Docs
----

By default, nunc-stans doxygen is configured to produce man pages and HTML
docs.  `make install` will build the `doxygen` docs.  HTML docs will be in
`$htmldir` and man pages in `$mandir`.
