MODULE VO:ScrollerPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT ISD := VO:Dlg:ImgSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       S   := VO:Scroller,
       T   := VO:Text,
       TA  := VO:Tab,
       VI  := VO:VecImage;

TYPE
  Item*     = POINTER TO ItemDesc;

  (**
   TODO
   Make it only use one ImgSelDlg.
  **)

  ItemDesc* = RECORD (GP.PrefsItemDesc)
                image,
                up,
                down,
                left,
                right       : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Scroller";

    d.SetPrefs(S.prefs);
            
    d.image:=V.CreateIntModel();
    d.up:=V.CreateIntModel();
    d.down:=V.CreateIntModel();
    d.left:=V.CreateIntModel();
    d.right:=V.CreateIntModel();
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : ISD.ImgSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreateVPanel();

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Images");

        label:=L.CreateLabel();

          combo:=ISD.CreateImgSelCombo();
          combo.SetModel(d.up);
        label.AddTextLabel("Up image",combo);

          combo:=ISD.CreateImgSelCombo();
          combo.SetModel(d.down);
        label.AddTextLabel("Down image",combo);

          combo:=ISD.CreateImgSelCombo();
          combo.SetModel(d.left);
        label.AddTextLabel("Left image",combo);

          combo:=ISD.CreateImgSelCombo();
          combo.SetModel(d.right);
        label.AddTextLabel("Right image",combo);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.Refresh^;

    p.up.SetLongint(S.prefs.up);
    p.down.SetLongint(S.prefs.down);
    p.left.SetLongint(S.prefs.left);
    p.right.SetLongint(S.prefs.right);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    S.prefs.up:=p.up.GetLongint();
    S.prefs.down:=p.down.GetLongint();
    S.prefs.left:=p.left.GetLongint();
    S.prefs.right:=p.right.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;

  BEGIN
    p.LoadPrefs^(top);

    IF top.GetStringEntry("up",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.up:=pos;
      ELSE
        p.ErrorWrongData("up",buffer);
      END;
    END;

    IF top.GetStringEntry("down",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.down:=pos;
      ELSE
        p.ErrorWrongData("down",buffer);
      END;
    END;

    IF top.GetStringEntry("left",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.left:=pos;
      ELSE
        p.ErrorWrongData("left",buffer);
      END;
    END;

    IF top.GetStringEntry("right",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.right:=pos;
      ELSE
        p.ErrorWrongData("right",buffer);
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("up",VI.images[S.prefs.up]);
    block.AddItemValue("down",VI.images[S.prefs.down]);
    block.AddItemValue("left",VI.images[S.prefs.left]);
    block.AddItemValue("right",VI.images[S.prefs.right]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:ScrollerPrefs.