/***************************************************************************
 $RCSfile: simpleconfig.cpp,v $
                             -------------------
    cvs         : $Id: simpleconfig.cpp,v 1.5 2003/07/02 18:22:24 aquamaniac Exp $
    begin       : Fri Dec 21 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/




/*
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "simpleconfig.h"

#include <stdio.h>
#include "parser.h"
#include "filestream.h"


namespace HBCI {

SimpleConfig::SimpleConfig():Config(){
}


SimpleConfig::~SimpleConfig(){
}


void SimpleConfig::setVariable(const string &name, 
				 const string &value,
                                 Tree<ConfigNode>::iterator where){
    Tree<ConfigNode>::iterator it;

    if ((mode() & CONFIG_MODE_CREATE_EMPTY_VARS) || !value.empty()) {
	it=createVar(name,where);
	if (!it.isValid())
	    throw Error("SimpleConfig::setVariable()",
			ERROR_LEVEL_NORMAL,
			0,
			ERROR_ADVISE_DONTKNOW,
			"Could not create/select variable "+name);
	it.addChild(ConfigValue(value));
    }
}


void SimpleConfig::setIntVariable(const string &name, int value,
                                    Tree<ConfigNode>::iterator where){
    char buffer[256];

#ifdef HAVE_SNPRINTF
    snprintf(buffer,sizeof(buffer),"%i",value);
#else
    sprintf(buffer,"%i",value);
#endif
    setVariable(name,buffer,where);
}


void SimpleConfig::setFloatVariable(const string &name, float value,
                                      Tree<ConfigNode>::iterator where){
    char buffer[256];

#ifdef HAVE_SNPRINTF
    snprintf(buffer,sizeof(buffer),"%f",value);
#else
    sprintf(buffer,"%f",value);
#endif
    setVariable(name,buffer,where);
}


void SimpleConfig::setBoolVariable(const string &name, bool value,
                                     Tree<ConfigNode>::iterator where){
    setVariable(name,value?"YES":"NO",where);
}


const string &
SimpleConfig::getVariable(const string &name, 
			    const string &defval,
			    Tree<ConfigNode>::const_iterator where) const 
{
    Tree<ConfigNode>::const_iterator it;

    it=findVariable(name,where);
    if (!it.isValid())
        return defval;
    it.child();
    if (!it.isValid())
        return defval;
    return (*it).data;
}


int SimpleConfig::getIntVariable(const string &name, 
				   int defval,
                                   Tree<ConfigNode>::const_iterator where) 
    const 
{
    string v;
    int r;

    v=getVariable(name,"",where);
    if (v.empty())
        return defval;
    r=atoi(v.c_str());
    return r;
}


float SimpleConfig::getFloatVariable(const string &name, 
				       float defval,
                                       Tree<ConfigNode>::const_iterator where)
const 
{
    string v;
    float r;

    v=getVariable(name,"",where);
    if (v.empty())
        return defval;
    if (1!=sscanf(v.c_str(),"%f",&r))
        return defval;
    return r;
}


bool SimpleConfig::getBoolVariable(const string &name, 
				     bool defval,
                                     Tree<ConfigNode>::const_iterator where) 
const {
    string v;
    v=getVariable(name,"",where);
    if (v.empty())
        return defval;
    if ((-1!=parser::cmpPattern(v,"true", false)) ||
        (-1!=parser::cmpPattern(v,"yes", false)) ||
        (-1!=parser::cmpPattern(v,"ja", false)) ||
        (-1!=parser::cmpPattern(v,"jepp", false)) ||
        (-1!=parser::cmpPattern(v,"1", false)) ||
        (-1!=parser::cmpPattern(v,"absolutely", false)) ||
        (-1!=parser::cmpPattern(v,"on", false)) ||
        (-1!=parser::cmpPattern(v,"enable", false)) ||
        (-1!=parser::cmpPattern(v,"enabled", false)))
        return true;
    else if ((-1!=parser::cmpPattern(v,"false", false)) ||
             (-1!=parser::cmpPattern(v,"no", false)) ||
             (-1!=parser::cmpPattern(v,"nope", false)) ||
             (-1!=parser::cmpPattern(v,"nein", false)) ||
             (-1!=parser::cmpPattern(v,"nee", false)) ||
             (-1!=parser::cmpPattern(v,"0", false)) ||
             (-1!=parser::cmpPattern(v,"noe", false)) ||
             (-1!=parser::cmpPattern(v,"disable", false)) ||
             (-1!=parser::cmpPattern(v,"disabled", false)))
        return false;
    else
        return defval;
}


Error SimpleConfig::readFile(const string &name,
			     int access){
    Pointer<FileStream> pf;
    Error err;

    pf.setDescription("SimpleConfig::FileStream pf");
    pf=new FileStream(name);

    err=(*pf).openFile(access);
    if (!err.isOk())
        return err;
    err=readFromStream(&(*pf),root());
    if (!err.isOk())
        return err;
    err=(*pf).closeFile();
    return err;
}


Error SimpleConfig::readFile(File::StdType typ) {
  Pointer<FileStream> pf;

  pf.setDescription("SimpleConfig::FileStream pf");
  pf=new FileStream(typ);

  return readFromStream(&(*pf),root());
}


Error SimpleConfig::writeFile(const string &name,
			      int access,
			      int mode){
  Pointer<FileStream> pf;
  Error err;

  pf.setDescription("SimpleConfig::FileStream pf");
  pf=new FileStream(name);

  err=(*pf).createFile(access,mode);
  if (!err.isOk())
    return err;
  err=writeToStream(&(*pf),root());
  if (!err.isOk())
    return err;
  (*pf).flushBuffer();
  err=(*pf).closeFile();
  return Error("SimpleConfig::writeFile(name)", err);
}


Error SimpleConfig::writeFile(File::StdType typ) {
  Pointer<FileStream> pf;
  Error err;

  pf.setDescription("SimpleConfig::FileStream pf");
  pf=new FileStream(typ);

  err=writeToStream(&(*pf),root());
  try {
    pf.ref().flushBuffer();
  }
  catch (Error xerr) {
    err=Error("SimpleConfig::writeFile",xerr);
  }
  return Error("SimpleConfig::writeFile(typ)", err);
}

} // namespace HBCI
