/***************************************************************************
  $RCSfile: pluginfile.h,v $
  -------------------
  cvs         : $Id: pluginfile.h,v 1.5 2003/05/11 16:56:09 aquamaniac Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PLUGINFILE_H
#define PLUGINFILE_H

#ifdef __cplusplus
namespace HBCI {
  class PluginFile;
};
#endif


#include <openhbci/libloader.h>
#include <openhbci/error.h>


#ifdef __cplusplus
namespace HBCI {
class API;

/**
 * This is the only exported function of a plugin.
 */
typedef Error (*REGISTER_YOURSELF_PTR)(API *api);


/**
 * This is the base class for a plugin file.
 * The file whose name is given to the constructor is loaded and the
 * address of the function "registerYourSelf" is resolved.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class PluginFile: public LibLoader {
private:
  REGISTER_YOURSELF_PTR _registerYourSelf;

public:
  PluginFile(const string &name, const string &prefix);
  virtual ~PluginFile();

  Error registerYourSelf(API *api);

};


}; /* namespace */

#endif /* __cplusplus */

#endif

