/* captureFrom.h
 */
#ifndef _MOVE_capture_from_H
#define _MOVE_capture_from_H
#include "osl/position.h"
#include "osl/player.h"
#include "osl/ptype.h"
#include "osl/move_action/concept.h"
#include "osl/move_generator/capture_.h"

namespace osl
{
  namespace move_action
  {
    
    /**
     * from に利きのある手を取る
     */
    template<Player P,class OrigAction>
    struct CaptureFrom
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;

    public:
      CaptureFrom(const NumEffectState& s, OrigAction & action)
	:
	state(s), action(action)
      {
      }

      template <Player PP>
      void doAction (Piece const& p, Position const& /*to*/)
      {
	move_generator::Capture<OrigAction>::
	  template generate<PlayerTraits<PP>::opponent>(state, p.position(), action);
      
      }

      void simpleMove(Position from,Position to,Ptype ptype,
		      bool isPromote,Player p,Move move)
      {
	assert(p == P);
	move_generator::Capture<OrigAction>::
	  generate<PlayerTraits<P>::opponent >(state, from, action);
      
      }
      void unknownMove(Position from,Position to,Piece p1,Ptype ptype,
		       bool isPromote,Player p,Move move)
      {
	assert(p == P);
	move_generator::Capture<OrigAction>::
	  generate<PlayerTraits<P>::opponent >(state, from, action);
      }
      /**
       * dropMove では取れない
       */
      void dropMove(Position to,Ptype ptype,Player p,Move move){
	assert(p == P);
	return;
      }
      // old interfaces
      void simpleMove(Position from,Position to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,Move());
      }
      void unknownMove(Position from,Position to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,Move());
      }
      void dropMove(Position to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,Move());
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* _MOVE_capture_from_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
