/* openMidEndingEval.h
 */

#ifndef EVAL_ML_OPENMIDENDINGEVAL_H
#define EVAL_ML_OPENMIDENDINGEVAL_H

#include "osl/eval/ml/weights.h"
#include "osl/eval/ml/pieceEval.h"
#include "osl/eval/ml/evalStagePair.h"
#include "osl/eval/evalTraits.h"
#include "osl/eval/pieceEval.h"
#include "osl/state/numEffectState.h"
#include "osl/progress/progress32.h"
#include "osl/progress/effect5x3.h"
#include "osl/progress/ml/newProgress.h"
#include "osl/container/tripleInt.h"

#define USE_TEST_PROGRESS
// NewProgressが学習可能な場合に定義 (現在はosl側に変更はないので常に定義)
#define LEARN_TEST_PROGRESS

namespace osl
{
  namespace eval
  {
    namespace ml
    {
      using namespace osl::progress::ml;
      class OpenMidEndingPtypeTable : public PtypeEvalTable
      {
      public:
	OpenMidEndingPtypeTable();
      };

      struct OpenMidEndingEvalDebugInfo
      {
	enum
	{
	  EVAL, OPENING, ENDGAME, PROGRESS_INDEPENDENT,
	  PROGRESS,
	  // progress independent
	  PIECE, ROOK_MOBILITY, BISHOP_MOBILITY, LANCE_MOBILITY,
	  PIECE_PAIR, KING25_EFFECT,
	  // opening and ending
	  KING_PIECE_OPENING, KING_PIECE_ENDING,
	  PIECE_STAND_OPENING, PIECE_STAND_ENDING,
	  PAWN_DROP_OPENING, PAWN_DROP_ENDING,
	  PTYPE_X_OPENING, PTYPE_X_ENDING,
	  PTYPE_Y_OPENING, PTYPE_Y_ENDING,
	  KING25_EACH_OPENING, KING25_EACH_ENDING,
	  NO_PAWN_OPENING, NO_PAWN_ENDING,
	  GOLD_RETREAT_OPENING, GOLD_RETREAT_ENDING,
	  SILVER_RETREAT_OPENING, SILVER_RETREAT_ENDING,
	  KNIGHT_BLOCKED_OPENING, KNIGHT_BLOCKED_ENDING,
	  KINGX_BLOCKED_OPENING, KINGX_BLOCKED_ENDING,
	  ROOK_PAWN_OPENING, ROOK_PAWN_ENDING,
	  PIN_OPENING, PIN_ENDING,
	  ALL_GOLD_OPENING, ALL_GOLD_ENDING,
	  ANAGUMA_EMPTY_OPENING, ANAGUMA_EMPTY_ENDING,
	  STAND_EXCEPT_PAWN_OPENING, STAND_EXCEPT_PAWN_ENDING,
	  FEATURE_LIMIT
	};
	CArray<int, FEATURE_LIMIT> values;
      };

      class OpenMidEndingEval
      {
      private:
	enum { INVALID=EvalTraits<BLACK>::MAX_VALUE+1 };
	enum {
	  /** one should attack king after when he captured almost all pieces */
	  ProgressIndependentValueLimit = 4000
	};
	enum LoadStatus { Zero=0, Loaded, Random };
	static volatile LoadStatus initialized_flag;
	static Weights piece_pair_weights;
#ifdef USE_TEST_PROGRESS
	typedef osl::progress::ml::NewProgress progress_t;
#else
	typedef osl::progress::Effect5x3 progress_t;
#endif
	progress_t progress;
	MultiIntPair kingx_blocked, king25_effect_each;
	MultiIntPair king25_both_side,king_rook_bishop;
	MultiIntPair piece_stand_turn, non_pawn_attacked,
	  non_pawn_attacked_ptype, piece_fork_turn;
	MultiInt ptypey, ptypex, king_table_value;
	MultiInt piece_stand_value, recalculated_stage_value, pawn_advance;
	MultiInt rook_mobility, bishop_mobility, lance_mobility;
	MultiInt knight_advance, pawn_drop, promoted_minor_piece, rook_pawn,
	  rook_effect, bishop_effect, bishop_head, nosupport, ptype_yy, king3pieces;
	MultiInt rook_promote_defense;
	MultiInt piece_stand_combination, piece_stand_y, knight_check,
	  knight_head, pawn_ptypeo, ptype_count_value, lance_effect_piece,
	  ptype_y_pawn_y, bishop_and_king;
	CArray<BoardMask, 2> knight_fork_squares;
	CArray<PieceMask, 2> effect25; // index: owner of king
	CArray<PieceMask, 2> effect25_supported; // index: owner of king
	CArray<PieceMask, 2> effected_mask;
	CArray<PieceMask, 2> effected_mask_for_attacked;
	CArray<PieceMask, 40> attacked_mask;
	CArray<int, 5>  black_vertical, white_vertical,
	  black_king_vertical, white_king_vertical;
	// flat
	CArray<int,2> piece_pair_king_value;
	CArray<int, 2> non_pawn_stand_count;
	CArray2d<int, 2, 3> gs_near_king_count;
	CArray2d<int, 2, PTYPE_SIZE> ptype_count, ptype_board_count;
	CArray<std::pair<Square,int>, 2> knight_drop, silver_drop, bishop_drop, rook_drop;
	CArray2d<int, 2, 9> pawns;
	int progress_independent_value, // should be renamed to piece
	  recalculated_value, piece_pair_value;
	int black_pawn_count;
	int black_major_count, black_gold_count;
	int black_attack_effect, black_attack_piece,
	  white_attack_effect, white_attack_piece,
	  black_attack_supported_piece, white_attack_supported_piece;
	int black_defense_effect, black_defense_piece,
	  white_defense_effect, white_defense_piece;
	mutable int cache;
	Player turn;
	unsigned int ptypeo_mask;
	CArray<bool, 2> can_check; // king is defense
	bool use_progress_independent_value_limit;
	static const int ROUND_UP = 2;
	static int roundUp(int v)
	{
	  return v & (~(ROUND_UP-1)); 
	}
	void updateGoldSilverNearKing(const NumEffectState &state)
	{
	  const CArray<Square,2> kings = {{ 
	      state.kingSquare(BLACK),
	      state.kingSquare(WHITE),
	    }};
	  gs_near_king_count.fill(0);
	  for (int i = PtypeTraits<GOLD>::indexMin;
	       i < PtypeTraits<GOLD>::indexLimit; ++i)
	  {
	    const Piece p = state.pieceOf(i);
	    if (p.isOnBoard())
	    {
	      const Square pos = p.square();
	      const int y_diff = std::abs(pos.y() - kings[p.owner()].y());
	      const int x_diff = std::abs(pos.x() - kings[p.owner()].x());
	      if (y_diff <= 2 && x_diff <= 3)
	      {
		++gs_near_king_count[p.owner()][std::max(x_diff, y_diff) - 1];
	      }
	    }
	  }
	  for (int i = PtypeTraits<SILVER>::indexMin;
	       i < PtypeTraits<SILVER>::indexLimit; ++i)
	  {
	    const Piece p = state.pieceOf(i);
	    if (p.isOnBoard())
	    {
	      const Square pos = p.square();
	      const int y_diff = std::abs(pos.y() - kings[p.owner()].y());
	      const int x_diff = std::abs(pos.x() - kings[p.owner()].x());
	      if (y_diff <= 2 && x_diff <= 3)
	      {
		++gs_near_king_count[p.owner()][std::max(x_diff, y_diff) - 1];
	      }
	    }
	  }
	}
      public:
	OpenMidEndingEval(const NumEffectState &state);
	void changeTurn() { }
	static bool initialized()
	{
	  return initialized_flag;
	}
	static bool setUp(const char *filename);
	static bool setUp();
	int progressIndependentValue() const 
	{
	  return progress_independent_value + recalculated_value + piece_pair_value
	    + piece_pair_king_value[BLACK] + piece_pair_king_value[WHITE];
	}
	void debug() const;
	MultiInt stageValue() const 
	{
	  return king_table_value + piece_stand_value +
	    king25_effect_each[BLACK] + king25_effect_each[WHITE] +
	    ptypex + ptypey + rook_mobility + bishop_mobility + lance_mobility +
	    rook_effect + bishop_effect +
	    piece_stand_combination + piece_stand_turn[turn] +
	    rook_pawn + pawn_drop + piece_stand_y + knight_check +
	    pawn_advance + pawn_ptypeo + promoted_minor_piece +
	    nosupport +
	    non_pawn_attacked[turn] + non_pawn_attacked_ptype[turn] +
	    ptype_yy + king3pieces + bishop_head + knight_head
	    + rook_promote_defense +
	    ptype_count_value + lance_effect_piece + ptype_y_pawn_y +
	    bishop_and_king + piece_fork_turn[turn] + recalculated_stage_value;
	}
	int openingValue() const 
	{
	  return (king_table_value[0] +
		  piece_stand_value[0] +
		  king25_effect_each[BLACK][0] + king25_effect_each[WHITE][0] +
		  ptypex[0] +
		  ptypey[0] +
 		  rook_mobility[0] +
 		  bishop_mobility[0] +
 		  lance_mobility[0] +
		  rook_effect[0] +
		  bishop_effect[0] +
		  piece_stand_combination[0] + 
		  piece_stand_turn[turn][0] +
		  rook_pawn[0] +
		  pawn_drop[0] +
		  piece_stand_y[0] +
		  knight_check[0] +
		  pawn_advance[0] +
		  pawn_ptypeo[0] +
		  promoted_minor_piece[0] +
		  nosupport[0] +
		  non_pawn_attacked[turn][0] +
		  non_pawn_attacked_ptype[turn][0] +
		  ptype_yy[0] +
		  king3pieces[0] +
		  bishop_head[0] +
		  knight_head[0] +
		  rook_promote_defense[0] +
		  ptype_count_value[0] +
		  lance_effect_piece[0] +
		  ptype_y_pawn_y[0] +
		  bishop_and_king[0] +
		  piece_fork_turn[turn][0] +
		  recalculated_stage_value[0]);
	}
	int midgameValue() const 
	{
	  return (king_table_value[1] +
		  piece_stand_value[1] +
		  king25_effect_each[BLACK][1] + king25_effect_each[WHITE][1] +
		  ptypex[1] +
		  ptypey[1] +
 		  rook_mobility[1] +
 		  bishop_mobility[1] +
 		  lance_mobility[1] +
		  rook_effect[1] +
		  bishop_effect[1] +
		  piece_stand_combination[1] + 
		  piece_stand_turn[turn][1] +
		  rook_pawn[1] +
		  pawn_drop[1] +
		  piece_stand_y[1] +
		  knight_check[1] +
		  pawn_advance[1] +
		  pawn_ptypeo[1] +
		  promoted_minor_piece[1] +
		  nosupport[1] +
		  non_pawn_attacked[turn][1] +
		  non_pawn_attacked_ptype[turn][1] +
		  ptype_yy[1] +
		  king3pieces[1] +
		  bishop_head[1] +
		  knight_head[1] +
		  rook_promote_defense[1] +
		  ptype_count_value[1] +
		  lance_effect_piece[1] +
		  ptype_y_pawn_y[1] +
		  bishop_and_king[1] +
		  piece_fork_turn[turn][1] +
		  recalculated_stage_value[1]);
	}
	int midgame2Value() const 
	{
	  return (king_table_value[2] +
		  piece_stand_value[2] +
		  king25_effect_each[BLACK][2] + king25_effect_each[WHITE][2] +
		  ptypex[2] +
		  ptypey[2] +
 		  rook_mobility[2] +
 		  bishop_mobility[2] +
 		  lance_mobility[2] +
		  rook_effect[2] +
		  bishop_effect[2] +
		  piece_stand_combination[2] + 
		  piece_stand_turn[turn][2] +
		  rook_pawn[2] +
		  pawn_drop[2] +
		  piece_stand_y[2] +
		  knight_check[2] +
		  pawn_advance[2] +
		  pawn_ptypeo[2] +
		  promoted_minor_piece[2] +
		  nosupport[2] +
		  non_pawn_attacked[turn][2] +
		  non_pawn_attacked_ptype[turn][2] +
		  ptype_yy[2] +
		  king3pieces[2] +
		  bishop_head[2] +
		  knight_head[2] +
		  rook_promote_defense[2] +
		  ptype_count_value[2] +
		  lance_effect_piece[2] +
		  ptype_y_pawn_y[2] +
		  bishop_and_king[2] +
		  piece_fork_turn[turn][2] +
		  recalculated_stage_value[2]);
	}
	int endgameValue() const 
	{
	  return (king_table_value[EndgameIndex] +
		  piece_stand_value[EndgameIndex] +
		  king25_effect_each[BLACK][EndgameIndex] + king25_effect_each[WHITE][EndgameIndex] +
		  ptypex[EndgameIndex] +
		  ptypey[EndgameIndex] +
 		  rook_mobility[EndgameIndex] +
 		  bishop_mobility[EndgameIndex] +
 		  lance_mobility[EndgameIndex] +
		  rook_effect[EndgameIndex] +
		  bishop_effect[EndgameIndex] +
		  piece_stand_combination[EndgameIndex] + 
		  piece_stand_turn[turn][EndgameIndex] +
		  rook_pawn[EndgameIndex] +
		  pawn_drop[EndgameIndex] +
		  piece_stand_y[EndgameIndex] +
		  pawn_advance[EndgameIndex] +
		  knight_check[EndgameIndex] +
		  pawn_ptypeo[EndgameIndex] +
		  promoted_minor_piece[EndgameIndex] +
		  nosupport[EndgameIndex] +
		  non_pawn_attacked[turn][EndgameIndex] +
		  non_pawn_attacked_ptype[turn][EndgameIndex] +
		  ptype_yy[EndgameIndex] +
		  king3pieces[EndgameIndex] +
		  bishop_head[EndgameIndex] +
		  knight_head[EndgameIndex] +
		  rook_promote_defense[EndgameIndex] +
		  ptype_count_value[EndgameIndex] +
		  lance_effect_piece[EndgameIndex] +
		  ptype_y_pawn_y[EndgameIndex] +
		  bishop_and_king[EndgameIndex] +
		  piece_fork_turn[turn][EndgameIndex] +
		  recalculated_stage_value[EndgameIndex]);
	}
	void invalidateCache() { cache=INVALID; }
	static int progressIndependentValueAdjusted(int value, int progress,
						    int progress_max)
	{
	  if (value > ProgressIndependentValueLimit) {
	    int diff = value - ProgressIndependentValueLimit;
	    value = ProgressIndependentValueLimit
	      + diff * progress/progress_max;
	  }
	  else if (value < -ProgressIndependentValueLimit) {
	    int diff = value + ProgressIndependentValueLimit;
	    value = -ProgressIndependentValueLimit
	      + diff * progress/progress_max;
	  }
	  return value;
	}
	int composeOpenMidEndgame() const
	{
	  const int progress_max = NewProgress::maxProgress(), c = progress_max/2;
	  const int progress = this->progress.progress();
	  int progress_independent = use_progress_independent_value_limit
	    ? progressIndependentValueAdjusted
	    (progressIndependentValue(), progress, progress_max)
	    : progressIndependentValue();
	  int sum = progress_independent * progress_max;
	  if (progress < c) 
	  {
	    sum += openingValue() * 2*(c - progress);
	    sum += midgameValue() * 2*progress;
	  }
	  else 
	  {
	    sum += midgameValue() * 2*(progress_max - progress);
	    sum += endgameValue() * 2*(progress - c);
	  }
	  return sum;
	}
#ifdef EVAL_QUAD
	int composeOpenMid2Endgame() const
	{
	  const int progress_max = NewProgress::maxProgress();
	  const int progress = this->progress.progress();
	  const int c0 = progress_max/3, c1 = c0*2;
#ifndef NDEBUG
	  const int w2 = progress_max - c1;
#endif
	  assert(c0 == w2);
	  int progress_independent = progressIndependentValueAdjusted
	    (progressIndependentValue(), progress, progress_max);
	  int sum = progress_independent * c0;
	  const MultiInt stage_sum = stageValue();
	  if (progress < c0) 
	  {
	    sum += stage_sum[0] * (c0 - progress);
	    sum += stage_sum[1] * progress;
	  }
	  else if (progress < c1) 
	  {
	    sum += stage_sum[1] * (c1 - progress);
	    sum += stage_sum[2] * (progress-c0);
	  }
	  else 
	  {
	    sum += stage_sum[2] * (progress_max - progress);
	    sum += stage_sum[3] * (progress - c1);
	  }
	  return sum;
	}
#endif
	int value() const
	{
	  if (cache==INVALID) 
	  {
#ifdef USE_TEST_PROGRESS
#  ifdef EVAL_QUAD
	    cache = roundUp(composeOpenMid2Endgame());
#  else
	    cache = roundUp(composeOpenMidEndgame());
#  endif
#else
#  ifdef EVAL_QUAD
#    error "not supported"
#  else
	    cache = roundUp(progressIndependentValue() * 16 +
			    openingValue() * (16 - progress.progress16().value()) + 
			    endgameValue() * progress.progress16().value());
#  endif
#endif
	  }
	  return cache;
	}
	const Move suggestMove(const NumEffectState& state) const
	{
	  assert(turn == state.turn());
	  Move suggest;
	  int best_value = 0;
	  if (! rook_drop[turn].first.isPieceStand()) {
	    assert(state.hasPieceOnStand(turn, ROOK));
	    suggest = Move(rook_drop[turn].first, ROOK, turn);
	    best_value = rook_drop[turn].second;
	  }
	  assert(best_value >= 0);
	  if (bishop_drop[turn].second > best_value) {
	    assert(! bishop_drop[turn].first.isPieceStand());
	    assert(state.hasPieceOnStand(turn, BISHOP));
	    suggest = Move(bishop_drop[turn].first, BISHOP, turn);
	    best_value = bishop_drop[turn].second;
	  }
	  if (silver_drop[turn].second > best_value) {
	    assert(! silver_drop[turn].first.isPieceStand());
	    assert(state.hasPieceOnStand(turn, SILVER));
	    suggest = Move(silver_drop[turn].first, SILVER, turn);
	    best_value = silver_drop[turn].second;
	  }
	  if (knight_drop[turn].second > best_value
	      && state.hasPieceOnStand(turn, KNIGHT)) {
	    assert(! knight_drop[turn].first.isPieceStand());
	    suggest = Move(knight_drop[turn].first, KNIGHT, turn);
	    best_value = knight_drop[turn].second;
	  }
	  return suggest;
	}
	int expect(const NumEffectState &state, Move move) const;
	template<Player P>
	void updateSub(const NumEffectState &new_state, Move last_move);
	void update(const NumEffectState &new_state, Move last_move);
	const Progress32 progress32() const
	{ 
	  return Progress32(progress.progress16(BLACK).value()
			    + progress.progress16(WHITE).value()); 
	}
	const Progress16 progress16() const { return progress.progress16(); }
      public:
	static int infty()
	{
#ifdef USE_TEST_PROGRESS
#  ifdef EVAL_QUAD
	  assert(NewProgress::maxProgress() % 3 == 0);
	  return 57984 * (NewProgress::maxProgress()/3);
#  else
	  return 57984 * NewProgress::maxProgress();
#  endif
#else
	  return 57984 * 16;
#endif
	}
	static int captureValue(PtypeO ptypeO) {
	  assert(isValidPtypeO(ptypeO));
	  return roundUp((-PieceEval::value(ptypeO) +
			  PieceEval::value(captured(ptypeO))) * seeScale());
	}
	static int seeScale() {
#ifdef USE_TEST_PROGRESS
#  ifdef EVAL_QUAD
	  assert(NewProgress::maxProgress() % 3 == 0);
	  return (NewProgress::maxProgress()/3);
#  else
	  return NewProgress::maxProgress();
#  endif
#else
	  return 16;
#endif
	}

	OpenMidEndingEvalDebugInfo debugInfo(const NumEffectState &state);
	static void setRandom();
	static const OpenMidEndingPtypeTable Piece_Value;
      };
    }
  }
}

#endif // EVAL_ML_OPENMIDENDINGEVAL_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
