#ifndef _CSA_H
#define _CSA_H

#include "osl/piece.h"
#include "osl/move.h"
#include <string>
#include <iosfwd>
namespace osl
{
  namespace state
  {
    class SimpleState;
  }
  namespace record
  {
    /**
     * CSA形式.
     * CSA形式の定義 http://www.computer-shogi.org/wcsc12/record.html
     */
    namespace csa
    {
      struct CsaIOError;

      const Move strToMove(const std::string& s,const state::SimpleState& st);
      Player charToPlayer(char c);
      const Square strToPos(const std::string& s);
      Ptype strToPtype(const std::string& s);

      const std::string show(Move);
      const std::string fancyShow(Move);
      const std::string show(Square);
      const std::string show(Ptype);
      const std::string show(Piece);
      const std::string show(Player);

      const std::string show(Move, std::string& buf);
      const std::string show(Square, std::string& buf, size_t offset=0);
      const std::string show(Ptype, std::string& buf, size_t offset=0);
      const std::string show(Player, std::string& buf, size_t offset=0);
    } // namespace csa
  } // namespace record

  // obsolete functions,
  // only for backward compatibility
  std::ostream& csaShow(std::ostream& os, Move move);
  std::ostream& csaShow(std::ostream&, Square);
  std::ostream& csaShow(std::ostream& os, Piece piece);
  std::ostream& csaShow(std::ostream& os, Ptype ptype);

} // namespace osl
#endif /* _CSA_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
