/* hash_set.h
 */
#ifndef HASH_SET_H
#define HASH_SET_H

#include "osl/stl/hash.h"
#include "osl/stl/pool_allocator.h"
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
#  include <tr1/unordered_set>
#elif __GNUC__
#  include <ext/hash_set>
#else
#  include <boost/unordered_set.hpp>
#endif
#include <cstddef>
namespace osl
{
  namespace stl
  {
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
    template<class Value, class HashFun=osl::stl::hash<Value>,
	     class Equal=std::equal_to<Value> >
    struct hash_set
      : public std::tr1::unordered_set<Value, HashFun, Equal, pool_allocator<Value> >
    {
      typedef std::tr1::unordered_set<Value, HashFun, Equal, pool_allocator<Value> > base_t;
      hash_set() {}
      hash_set(size_t s) : base_t(s)
      {
      }
    };
#elif defined __GNUC__
    template<class Value, class HashFun=osl::stl::hash<Value>,
	     class Equal=std::equal_to<Value> >
    struct hash_set
      : public __gnu_cxx::hash_set<Value, HashFun, Equal, pool_allocator<Value> >
    {
      typedef __gnu_cxx::hash_set<Value, HashFun, Equal,
				  pool_allocator<Value> > base_t;
      hash_set() {}
      hash_set(size_t s) : base_t(s)
      {
      }
    };
#else
    template<class Value, class HashFun=osl::stl::hash<Value>,
	     class Equal=std::equal_to<Value> >
    struct hash_set
      : public boost::unordered_set<Value, HashFun, Equal, pool_allocator<Value> >
    {
      typedef boost::unordered_set<Value, HashFun, Equal, pool_allocator<Value> > base_t;
      hash_set() {}
      hash_set(size_t s) : base_t(s)
      {
      }
    };
#endif
  } // namespace stl
  using stl::hash_set;
} // namespace stl

#endif /* HASH_SET_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
