#include "osl/eval/endgame/kingPieceTable.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <boost/scoped_ptr.hpp>

using namespace osl;
using namespace osl::eval;
using namespace osl::eval::endgame;

class KingPieceTableTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(KingPieceTableTest);
  CPPUNIT_TEST(testLoad);
  CPPUNIT_TEST_SUITE_END();
public:
  void testLoad();
};

CPPUNIT_TEST_SUITE_REGISTRATION(KingPieceTableTest);

class KingPieceTableA : public KingPieceTable
{
public:
  KingPieceTableA()
  {
  }
};

void KingPieceTableTest::testLoad()
{
  boost::scoped_ptr<KingPieceTableA> t1(new KingPieceTableA),
    t2(new KingPieceTableA);
  t1->randomize();
  CPPUNIT_ASSERT(! (*t1 == *t2));
  t1->saveText("KingPieceTableTest.txt");
  sleep(1);
  t2->loadText("KingPieceTableTest.txt");
  CPPUNIT_ASSERT(*t1 == *t2);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
