---
title: PostgreSQL JDBC Driver 42.2.6 Released
date: 2019-06-19 00:06:55 +0300
categories:
  - new_release
version: 42.2.6
---
**Notable changes**

### Changed
- Change IS_GENERATED to IS_GENERATEDCOLUMN as per spec [PR 1485](https://github.com/pgjdbc/pgjdbc/pull/1485)
- Fix missing metadata columns, and misspelled columns in PgDatabaseMetaData#getTables [PR 1323](https://github.com/pgjdbc/pgjdbc/pull/1323)

### Added
- CI tests with Java 11, and Java EA
- Support temporary replication slots in ReplicationCreateSlotBuilder [PR 1306](https://github.com/pgjdbc/pgjdbc/pull/1306)
- Support PostgreSQL 11, 12
- Return function (PostgreSQL 11) columns in PgDatabaseMetaData#getFunctionColumns
- Return information on create replication slot, now the snapshot_name is exported
  to allow a consistent snapshot in some uses cases. [PR 1335](https://github.com/pgjdbc/pgjdbc/pull/1335)

### Fixed
- Fixed async copy performance (1ms per op) in SSL mode [PR 1314](https://github.com/pgjdbc/pgjdbc/pull/1314)
- Return Double.NaN for 'NaN'::numeric [PR 1304](https://github.com/pgjdbc/pgjdbc/pull/1304)
- Performance issue in PgDatabaseMetaData#getTypeInfo with lots of types in DB [PR 1302](https://github.com/pgjdbc/pgjdbc/pull/1302)
- PGCopyInputStream#read should cap values to [0, 255], -1 [PR 1349](https://github.com/pgjdbc/pgjdbc/pull/1349)
- Fixes LocalDateTime handling of BC dates [PR 1388](https://github.com/pgjdbc/pgjdbc/pull/1388)
- Release savepoints in autosave mode to prevent out of shared memory errors at the server side [PR 1409](https://github.com/pgjdbc/pgjdbc/pull/1409)
- Fix execution with big decimal in simple query mode. [PR 1463](https://github.com/pgjdbc/pgjdbc/pull/1463)
- Fix rounding for timestamps truncated to dates before 1970 [PR 1502](https://github.com/pgjdbc/pgjdbc/pull/1502)

### Known issues
- Microseconds in timestamps might be truncated when transferred in binary mode
- 24:00 time handling is not consistent [issue 1385](https://github.com/pgjdbc/pgjdbc/issues/1385)
- Unexpected packet type during stream replication [issue 1466](https://github.com/pgjdbc/pgjdbc/issues/1466)
- Driver goes missing after OSGi bundle restart [issue 1476](https://github.com/pgjdbc/pgjdbc/issues/1476)


<!--more-->

**Commits by author**

Adam Brusselback (1):

* Add method alias's for each property which didn't use the conventiona… [PR 1436](https://github.com/pgjdbc/pgjdbc/pull/1436) [0efcf81c](https://github.com/pgjdbc/pgjdbc/commit/0efcf81c62ff8397c363c3d07d4d72e725e63772)

AlexElin (6):

* chore: add .editorconfig [PR 1410](https://github.com/pgjdbc/pgjdbc/pull/1410) [61cc2756](https://github.com/pgjdbc/pgjdbc/commit/61cc2756bac7eb809c62ebbd9ed5537589bed08d)
* style: enable checkstyle modules for name checking [PR 1411](https://github.com/pgjdbc/pgjdbc/pull/1411) [6b124a05](https://github.com/pgjdbc/pgjdbc/commit/6b124a054074e3aa85787314390b633adfe073ca)
* test: add tests for Driver and PgConnection [PR 1402](https://github.com/pgjdbc/pgjdbc/pull/1402) [7b52b0c9](https://github.com/pgjdbc/pgjdbc/commit/7b52b0c9e5b9aa9a9c655bb68f23bf4ec57fd51c)
* chore: add EmptyStatement checkstyle rule [PR 1400](https://github.com/pgjdbc/pgjdbc/pull/1400) [4cd3f05a](https://github.com/pgjdbc/pgjdbc/commit/4cd3f05a4697ff61ff01d80828888bfbe086e8c5)
* chore: add StaticVariableName checkstyle rule [PR 1414](https://github.com/pgjdbc/pgjdbc/pull/1414) [ddb38e57](https://github.com/pgjdbc/pgjdbc/commit/ddb38e572690f9366ba392a63f1a73711821ae1d)
* chore: enable AtclauseOrder checkstyle rule [PR 1417](https://github.com/pgjdbc/pgjdbc/pull/1417) [7ae1e833](https://github.com/pgjdbc/pgjdbc/commit/7ae1e833cda9966c79fc84ebe633f8492b3e5f3d)

Andrew Guibert (1):

* Fix inconsistent javadoc for setDefaultAutoCommit [PR 1472](https://github.com/pgjdbc/pgjdbc/pull/1472) [fac5e09c](https://github.com/pgjdbc/pgjdbc/commit/fac5e09c3851537c25254d0c635c6e2f02943ca3)

Craig Ringer (2):

* fix: NPE in PGXAConnection$ConnectionHandler.invoke() of .equals(null) [PR 1365](https://github.com/pgjdbc/pgjdbc/pull/1365) [cea5231b](https://github.com/pgjdbc/pgjdbc/commit/cea5231ba794c362cbd5285b299ba3f82ad29e73)
* Update waffle-jna to new artifact coordinates [PR 1383](https://github.com/pgjdbc/pgjdbc/pull/1383) [72dc692e](https://github.com/pgjdbc/pgjdbc/commit/72dc692e1104a726385a9df10a4778f4e7e73020)

Dave Cramer (31):

* docs: update README.md for SSL tests [1fff6043](https://github.com/pgjdbc/pgjdbc/commit/1fff60434ba703b91a9ff47ccfc812a06262aff2)
* Update mailinglist.html [556c93d3](https://github.com/pgjdbc/pgjdbc/commit/556c93d35cc7f27abf2a98f087a85a76e7363c55)
* chore: add jdk11 and jdk12-ea tests to travis [b53eedf6](https://github.com/pgjdbc/pgjdbc/commit/b53eedf672c00be6d340b2eb776e6c6e3c586384)
* fix: autosave being overwritten in BaseDataSource by setUrl [PR 1309](https://github.com/pgjdbc/pgjdbc/pull/1309) [10201f61](https://github.com/pgjdbc/pgjdbc/commit/10201f61727868bd6f64ce3ab6c197a11bee78f4)
* perf: ignore tables for PgDatabaseMetaData.getTypeInfo [PR 1302](https://github.com/pgjdbc/pgjdbc/pull/1302) [e44e4e89](https://github.com/pgjdbc/pgjdbc/commit/e44e4e8972ec41bf05dddd4ac6dcfbc42a9842cf)
* Update issue_template.md [f3ade07d](https://github.com/pgjdbc/pgjdbc/commit/f3ade07d7758f134fd137db3ebab544f2211e290)
* Remove tests that use oids fixes [PR 1347](https://github.com/pgjdbc/pgjdbc/pull/1347) (#1348) [da4d6577](https://github.com/pgjdbc/pgjdbc/commit/da4d6577f4c0acaadb703b40d267395bb45418f8)
* Fix setURL in BaseDataSource [PR 1341](https://github.com/pgjdbc/pgjdbc/pull/1341) [2ad1ac3f](https://github.com/pgjdbc/pgjdbc/commit/2ad1ac3fc0e07edce957aaed51167240a970b1f1)
* Add support for version 11 and version 12 [PR 1332](https://github.com/pgjdbc/pgjdbc/pull/1332) [7f0e200a](https://github.com/pgjdbc/pgjdbc/commit/7f0e200affbf4b6504bfafccaf6cfcdbe3b0219e)
* fix missing metadata columns, and misspelled columns [PR 1323](https://github.com/pgjdbc/pgjdbc/pull/1323) [0ed0e8f2](https://github.com/pgjdbc/pgjdbc/commit/0ed0e8f2dcd0ae4bbb5caee27b7057cef182c146)
* fix: Incorrect return value for bytes [128-255] in stream.read [PR 1349](https://github.com/pgjdbc/pgjdbc/pull/1349) [325e63b4](https://github.com/pgjdbc/pgjdbc/commit/325e63b4c8b7f0c923e8cb9b73795672f21c1fe5)
* fix: as of v12 recovery.conf is no longer used for standby recovery. … [PR 1355](https://github.com/pgjdbc/pgjdbc/pull/1355) [c4656b32](https://github.com/pgjdbc/pgjdbc/commit/c4656b323f0dc3090926c0f14cd219461e534576)
* Update pull_request_template.md [PR 1367](https://github.com/pgjdbc/pgjdbc/pull/1367) [be23262b](https://github.com/pgjdbc/pgjdbc/commit/be23262b14378dd2282161733fdc2d345a8b8629)
* Update README.md [2a639fd6](https://github.com/pgjdbc/pgjdbc/commit/2a639fd6ef4b47559cd4c0c71fb9116640e88c94)
* Fix formatting [c0f6b9bd](https://github.com/pgjdbc/pgjdbc/commit/c0f6b9bdddaff5a3e489769528b09ef22e224706)
* Update README.md [PR 1404](https://github.com/pgjdbc/pgjdbc/pull/1404) [65f7ea6f](https://github.com/pgjdbc/pgjdbc/commit/65f7ea6f93f30f3e9d9d3faeca8e0e3b0a055195)
* add matrix including master to test [PR 1408](https://github.com/pgjdbc/pgjdbc/pull/1408) [5965f399](https://github.com/pgjdbc/pgjdbc/commit/5965f3996b285992df2e13e0260858537b31c3d6)
* Fix:save points causing server to run out of resources [PR 1409](https://github.com/pgjdbc/pgjdbc/pull/1409) [af8f8836](https://github.com/pgjdbc/pgjdbc/commit/af8f8836d004d7227017774dff895c1ee706c03d)
* use postgres column type name in error message [PR 1422](https://github.com/pgjdbc/pgjdbc/pull/1422) [fe7eda3d](https://github.com/pgjdbc/pgjdbc/commit/fe7eda3d2e56d70b83294b7534d6386501599c37)
* fix:Test Case HostSpecTest , tests testShouldResolveWithEmptySocksProxyHost and testShouldResolveWithWhiteSpaceSocksProxyHost [PR 1424](https://github.com/pgjdbc/pgjdbc/pull/1424) [0c5cf475](https://github.com/pgjdbc/pgjdbc/commit/0c5cf475d35fb73d921eac922089cf4406e48c9d)
* Update checkstyle to 8.18 [PR 1447](https://github.com/pgjdbc/pgjdbc/pull/1447) [ed5f750b](https://github.com/pgjdbc/pgjdbc/commit/ed5f750beb387a8846e5aa79a775e2d49b48b3c4)
* fix javadoc for defaultAutoCommit to default to true [PR 1465](https://github.com/pgjdbc/pgjdbc/pull/1465) [0a4f078e](https://github.com/pgjdbc/pgjdbc/commit/0a4f078e2f10e5b3dfec115eaeb6220c57bbee3b)
* autocommit true turns *on* autocommit by default [31bc6e59](https://github.com/pgjdbc/pgjdbc/commit/31bc6e59b090c1d1c1904ca0cda09db2c1afb302)
* remove reference to unknown google group [PR 1429](https://github.com/pgjdbc/pgjdbc/pull/1429) [129960ea](https://github.com/pgjdbc/pgjdbc/commit/129960eaa2916a0177cfb8eec503aacc68d8460f)
* Update backend_protocol_v4_wanted_features.md [95ba7b26](https://github.com/pgjdbc/pgjdbc/commit/95ba7b261e39754674c5817695ae5ebf9a341fae)
* some fixbugs cleanup [PR 1486](https://github.com/pgjdbc/pgjdbc/pull/1486) [8bd9062f](https://github.com/pgjdbc/pgjdbc/commit/8bd9062f1c3dd1c80d096ff8db738dce010f8b46)
* change IS_GENERATED to IS_GENERATEDCOLUMN as per spec [PR 1485](https://github.com/pgjdbc/pgjdbc/pull/1485) [17c4bcfb](https://github.com/pgjdbc/pgjdbc/commit/17c4bcfb59e846c593093752f2e30dd97bb4b338)
* undo part of fixbugs pull request that set returned NULL mistakenly [PR 1489](https://github.com/pgjdbc/pgjdbc/pull/1489) [27b8fcae](https://github.com/pgjdbc/pgjdbc/commit/27b8fcae7aab6bf777ef5c019df31d34db00d69b)
* fix: Error messages cannot be formatted [PR 1492](https://github.com/pgjdbc/pgjdbc/pull/1492) [12ef697a](https://github.com/pgjdbc/pgjdbc/commit/12ef697a3d34b616716ea9c2c8cb4c9447e2c4c3)
* fix [PR 1499](https://github.com/pgjdbc/pgjdbc/pull/1499) rounding for timestamps truncated to dates before 1970 (#1502) [c9a70782](https://github.com/pgjdbc/pgjdbc/commit/c9a70782b3818609ca29e19d1a4aa0af89d96382)
* Fix maven coordinates [PR 1479](https://github.com/pgjdbc/pgjdbc/pull/1479) [45ce14fd](https://github.com/pgjdbc/pgjdbc/commit/45ce14fd170d3b50aed5bbe5e3d25bbd0a3e80a5)

Dmitriy Tseyler (1):

* fix: return Double.NaN for 'NaN'::numeric [PR 1304](https://github.com/pgjdbc/pgjdbc/pull/1304) [265f22b2](https://github.com/pgjdbc/pgjdbc/commit/265f22b28fd7b5511e30a28ad959d5645e9722cd)

Doug Mayer (1):

* Add core type delimiters into cache for array type OIDs. [PR 1416](https://github.com/pgjdbc/pgjdbc/pull/1416) [6a0960a6](https://github.com/pgjdbc/pgjdbc/commit/6a0960a66981a03577221e2d742865526cb2325d)

Harry Chan (1):

* Optimize toArray [PR 1395](https://github.com/pgjdbc/pgjdbc/pull/1395) (#1396) [2341623b](https://github.com/pgjdbc/pgjdbc/commit/2341623b43bf2c9b1b24f41e7ec2eb37acaa6a62)

Ivan Leskin (1):

* Support custom 'options' connection property [PR 1356](https://github.com/pgjdbc/pgjdbc/pull/1356) [7be21fc3](https://github.com/pgjdbc/pgjdbc/commit/7be21fc307fa28781d26a6f3752564236e3f9203)

Jorge Solorzano (2):

* feat: return info on create slot of replication [PR 1335](https://github.com/pgjdbc/pgjdbc/pull/1335) [84e8d90b](https://github.com/pgjdbc/pgjdbc/commit/84e8d90b4bbeecbdccbe7ec4d165cfaf3ef30bf4)
* test: fix misspelled secondaryPort2 build property [PR 1284](https://github.com/pgjdbc/pgjdbc/pull/1284) [2c0f692b](https://github.com/pgjdbc/pgjdbc/commit/2c0f692bf6240465410ea2f6fde729554309f46c)

Kamal Kumlien (1):

* docs: cosmetic fixes on sample settings [PR 1379](https://github.com/pgjdbc/pgjdbc/pull/1379) [d0453b75](https://github.com/pgjdbc/pgjdbc/commit/d0453b7582975438eb889082cffcfd8ebe6e3e4d)

Kevin Wooten (1):

* Fixes `LocalDateTime` handling of BC dates [PR 1388](https://github.com/pgjdbc/pgjdbc/pull/1388) [ebada4af](https://github.com/pgjdbc/pgjdbc/commit/ebada4afb25864bc2d8ba900b433a849c69decf8)

Krzysztof Szafrański (1):

* Fix logging level [PR 1446](https://github.com/pgjdbc/pgjdbc/pull/1446) [f8c112cb](https://github.com/pgjdbc/pgjdbc/commit/f8c112cbeea4f1ceb893678407aa0149a08a8f28)

Marc Dean (1):

* Add DEADLOCK_DETECTED Enumeration [PR 1380](https://github.com/pgjdbc/pgjdbc/pull/1380) [a7f63bff](https://github.com/pgjdbc/pgjdbc/commit/a7f63bff0bbd552666d269251436dbb8e6b25d6a)

Mark Nguyen (1):

* docs: Add DEM format details for `sslkey` [PR 1376](https://github.com/pgjdbc/pgjdbc/pull/1376) [10945e34](https://github.com/pgjdbc/pgjdbc/commit/10945e34a4df2e51566c72fd64e0407c3f358477)

Mykola Nikishov (2):

* Fix link to Test Suite Howto [PR 1369](https://github.com/pgjdbc/pgjdbc/pull/1369) [33ac76d1](https://github.com/pgjdbc/pgjdbc/commit/33ac76d1108d295381b7685c1a17133bb7dd777d)
* refactor: remove unused method encode3to4 from Base64 [PR 1370](https://github.com/pgjdbc/pgjdbc/pull/1370) [bac4bc1a](https://github.com/pgjdbc/pgjdbc/commit/bac4bc1a2c876de82b6a583d144ae5d82bfd6bb0)

Nikolai Ivanov (1):

* fix: improper relative cursor movement [PR 1462](https://github.com/pgjdbc/pgjdbc/pull/1462) [b6ab27c1](https://github.com/pgjdbc/pgjdbc/commit/b6ab27c170ebeb88728f33207924d664ce7f7d77)

Philip Sanetra (1):

* feat: Extend ReplicationCreateSlotBuilder DSL to support temporary replications slots [PR 1306](https://github.com/pgjdbc/pgjdbc/pull/1306) [d514ceb5](https://github.com/pgjdbc/pgjdbc/commit/d514ceb502e7024cb302862880a8403bcd315ba3)

Sehrope Sarkuni (4):

* Fix TestUtil.dropXyz(...) object not exists errors [PR 1359](https://github.com/pgjdbc/pgjdbc/pull/1359) [0999bb78](https://github.com/pgjdbc/pgjdbc/commit/0999bb78ecb0a305f830d8b76ae24f6e64444ec8)
* refactor: Clean up loading of reading of keydata file in LazyKeyManager [PR 1372](https://github.com/pgjdbc/pgjdbc/pull/1372) [9b45e709](https://github.com/pgjdbc/pgjdbc/commit/9b45e709c20623ac1d4233bf1cc0369e8ddbe076)
* Fix metadata test to use explicit PK/FK names [PR 1442](https://github.com/pgjdbc/pgjdbc/pull/1442) [42d6bfa5](https://github.com/pgjdbc/pgjdbc/commit/42d6bfa51929a333c3d2d8c098997a9f01514eac)
* Cleanup encoding [PR 1441](https://github.com/pgjdbc/pgjdbc/pull/1441) [73ec8173](https://github.com/pgjdbc/pgjdbc/commit/73ec817311857756164b1933ce2dfa8127f8dffd)

Sualeh Fatehi (2):

* Fix: getFunctionColumns used to return ProcedureColumns, now returns function columns [b8a86807](https://github.com/pgjdbc/pgjdbc/commit/b8a86807f93b76ff92e6ff2ffacd6fdc44457b21)
* Update testing documents, and point to jackdb/pgjdbc-test-vm [PR 1363](https://github.com/pgjdbc/pgjdbc/pull/1363) [2a715a98](https://github.com/pgjdbc/pgjdbc/commit/2a715a988bead78aeb0a341a37faf86b62df4975)

Tyson Andre (1):

* docs: Fix typos in docs detected by codespell [PR 1361](https://github.com/pgjdbc/pgjdbc/pull/1361) [5b0c05fb](https://github.com/pgjdbc/pgjdbc/commit/5b0c05fb608619ec91afb5e2d2223c3fe1df207d)

Vladimir Sitnikov (9):

* docs: reflect 42.2.5 release in readme.md [d43398a5](https://github.com/pgjdbc/pgjdbc/commit/d43398a5d4c173da40e8f283f9e5fe20a971de5c)
* perf: fix 1ms per async CopyAPI (regression since 42.2.5) [PR 1314](https://github.com/pgjdbc/pgjdbc/pull/1314) [e2623d63](https://github.com/pgjdbc/pgjdbc/commit/e2623d63d4b6fad0b12fb9ace842475e4a9134dc)
* chore: use openjdk7 to boostrap Travis CI images for JDK 6 [PR 1366](https://github.com/pgjdbc/pgjdbc/pull/1366) [cdfd49cf](https://github.com/pgjdbc/pgjdbc/commit/cdfd49cf8040c75d315fb41f7c94ab4f9878a060)
* test: avoid locale-dependent output in SetObject310Test [ef14ceae](https://github.com/pgjdbc/pgjdbc/commit/ef14ceae7598ad854b7af79ec2c1244662ed3fce)
* fix: date rounding errors for dates before 1970 [b5653899](https://github.com/pgjdbc/pgjdbc/commit/b565389920f78702625ee263473bd9b3ec97f764)
* docs: update translation files [9fcaa98e](https://github.com/pgjdbc/pgjdbc/commit/9fcaa98ec1f0018f3877fd2e15ea2c13e60bbd35)
* fix: temporary make LibPQFactory.ConsoleCallbackHandler public [95d8da60](https://github.com/pgjdbc/pgjdbc/commit/95d8da6035b9bcfa622346261e591864111c041b)
* Update pgjdbc-parent-poms to 1.1.6 to use updated waffle-jna [f0a297db](https://github.com/pgjdbc/pgjdbc/commit/f0a297dba4f67b3f80dad7490b3882d0a7385c4b)
* Update changelog for 42.2.6 [8944fa67](https://github.com/pgjdbc/pgjdbc/commit/8944fa67c29c89082bf278c53d342ebe5ef1bcaf)

itchyny (1):

* docs: fix link to pull request 1052 in 42.2.3 changelog [PR 1345](https://github.com/pgjdbc/pgjdbc/pull/1345) [9f248e12](https://github.com/pgjdbc/pgjdbc/commit/9f248e1220338c12798f4a3bec585f4e22f534b4)

jajalvipul (1):

* Added break statement to avoid the additional iterations in for loop [PR 1406](https://github.com/pgjdbc/pgjdbc/pull/1406) [6b13f7b7](https://github.com/pgjdbc/pgjdbc/commit/6b13f7b7af95bd86b0763f8e73395e4d7eebc410)

kaiwangchen (1):

* Fix execution with big decimal in simple query mode. [PR 1463](https://github.com/pgjdbc/pgjdbc/pull/1463) [8e47a303](https://github.com/pgjdbc/pgjdbc/commit/8e47a303a6e89de43bd6983f92f04f3591a385d9)

kazachka (2):

* style: remove extra empty lines [PR 1452](https://github.com/pgjdbc/pgjdbc/pull/1452) [5e48c4d0](https://github.com/pgjdbc/pgjdbc/commit/5e48c4d0714fd656fb1997f29c1fa2d4fee60708)
* style: remove extra empty lines [PR 1454](https://github.com/pgjdbc/pgjdbc/pull/1454) [cb466d1b](https://github.com/pgjdbc/pgjdbc/commit/cb466d1bf74cb18c6444f099862b7e43329e93bf)

maltalex (1):

* Make LogSequenceNumber implement Comparable<LogSequenceNumber> [PR 1494](https://github.com/pgjdbc/pgjdbc/pull/1494) [1970c4a3](https://github.com/pgjdbc/pgjdbc/commit/1970c4a3fb8ebf4cc52f5d8b0d4977388ee713e7)

pbillen (1):

* Allow setFlushedLSN(lsn) and setAppliedLSN(lsn) from outside main loop [PR 1329](https://github.com/pgjdbc/pgjdbc/pull/1329) [381cf45c](https://github.com/pgjdbc/pgjdbc/commit/381cf45cd1029d53ef748731d93361a814f711b6)

rnveach (1):

* fix: improper indentation for javadoc [PR 1434](https://github.com/pgjdbc/pgjdbc/pull/1434) [35df0dde](https://github.com/pgjdbc/pgjdbc/commit/35df0dde43e50ddd1c75e5edb49ceae6daa1491f)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[Adam Brusselback](https://github.com/Tostino)  
[AlexElin](https://github.com/AlexElin)  
[Andrew Guibert](https://github.com/aguibert)  
[Craig Ringer](https://github.com/ringerc)  
[Dave Cramer](davec@postgresintl.com)  
[Dmitriy Tseyler](https://github.com/tseylerd)  
[Doug Mayer](https://github.com/doxavore)  
[Harry Chan](https://github.com/hc-codersatlas)  
[itchyny](https://github.com/itchyny)  
[Ivan Leskin](https://github.com/leskin-in)  
[jajalvipul](https://github.com/jajalvipul)  
[Jorge Solorzano](https://github.com/jorsol)  
[kaiwangchen](https://github.com/kaiwangchen)  
[Kamal Kumlien](https://github.com/kkumlien)  
[kazachka](https://github.com/kazachka)  
[Kevin Wooten](https://github.com/kdubb)  
[Krzysztof Szafrański](https://github.com/kszafran)  
[maltalex](https://github.com/maltalex)  
[Marc Dean](https://github.com/deanmarc25)  
[Mark Nguyen](https://github.com/Mrk-Nguyen)  
[Mykola Nikishov](https://github.com/manandbytes)  
[Nikolai Ivanov](https://github.com/nicktorwald)  
[pbillen](https://github.com/pbillen)  
[Philip Sanetra](https://github.com/PSanetra)  
[rnveach](https://github.com/rnveach)  
[Sehrope Sarkuni](https://github.com/sehrope)  
[Sualeh Fatehi](https://github.com/sualeh)  
[Tyson Andre](https://github.com/TysonAndre)  
[Vladimir Sitnikov](https://github.com/vlsi)  
