#ifndef __INCLUDED_ASSERT_H__
#define __INCLUDED_ASSERT_H__

#ifndef PHIDGETS_INTERNAL
#  error "this file is only supposed to be used from within libphidgets."
#endif // PHIDGETS_INTERNAL

#include <phidgets/phidgets.h>
#include <debug.h>

#define ASSERT(a) if (!a && phidgets_debug_stream && phidgets_debug_level & HID_DEBUG_ASSERTS) \
  fprintf(phidgets_debug_stream, "*** ASSERTION FAILURE in %s() [%s:%d]: %s\n", \
      __FUNCTION__, __FILE__, __LINE__, #a)

#endif // __INCLUDED_DEBUG_H__

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
