#ifndef __INCLUDED_PHIDGETS_QUADSERVO_H__
#define __INCLUDED_PHIDGETS_QUADSERVO_H__

#include <phidgets/servomotor.h>
#include <phidgets/phidgets.h>

typedef enum PhidgetQuadServoSelector_t {
  PHIDGET_QUADSERVO_MOTOR0 = 0,
  PHIDGET_QUADSERVO_MOTOR1 = 1,
  PHIDGET_QUADSERVO_MOTOR2 = 2,
  PHIDGET_QUADSERVO_MOTOR3 = 3
} PhidgetQuadServoSelector;

typedef struct PhidgetQuadServo_t {
  Phidget* phidget;
  PhidgetServoMotor servos[4];
} PhidgetQuadServo;

#ifdef __cplusplus
extern "C" {
#endif
  
PhidgetQuadServo* phidget_new_PhidgetQuadServo();

void phidget_delete_PhidgetQuadServo(PhidgetQuadServo** const qsc);

void phidget_reset_PhidgetQuadServo(PhidgetQuadServo* const qsc);

phidget_return phidget_quadservo_open(PhidgetQuadServo* const qsc,
    unsigned int serial, unsigned short retries);

phidget_return phidget_quadservo_close(PhidgetQuadServo* const qsc);

bool phidget_quadservo_is_opened(PhidgetQuadServo const* const qsc);

phidget_return phidget_quadservo_set_servo_parameters(PhidgetQuadServo* const qsc,
    PhidgetQuadServoSelector const servo, unsigned short const min,
    unsigned short const max, float const factor);

phidget_return phidget_quadservo_set_single_position(PhidgetQuadServo* const qsc,
    PhidgetQuadServoSelector const servo, unsigned int const position);

phidget_return phidget_quadservo_set_all_positions(PhidgetQuadServo* const qsc,
    unsigned int const p0, unsigned int const p1, unsigned int const p2,
    unsigned int const p3);

#ifdef __cplusplus
}
#endif

#endif // __INCLUDED_PHIDGETS_QUADSERVO_H__

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
