/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pxmchem-calcopt.h"






/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmCalcOpt * 
pxmchem_calcopt_new (void)
{
  PxmCalcOpt *calcopt = g_malloc0 (sizeof (PxmCalcOpt));

  pxmchem_calcopt_set_default (calcopt);
  
  return calcopt;
}


PxmCalcOpt * 
pxmchem_calcopt_dup (const PxmCalcOpt *calcopt)
{
  PxmCalcOpt *new_calcopt = g_malloc0 (sizeof (PxmCalcOpt));
  

  g_assert (calcopt != NULL);
  
  new_calcopt->start_idx = calcopt->start_idx;
  new_calcopt->end_idx = calcopt->end_idx;
  new_calcopt->mass_type = calcopt->mass_type;
  new_calcopt->capping = calcopt->capping;
  new_calcopt->mnm_chement = calcopt->mnm_chement;
  new_calcopt->plm_chement = calcopt->plm_chement;

  return new_calcopt;
}




/* UTILITY FUNCTIONS
 */
gboolean
pxmchem_calcopt_set_default (PxmCalcOpt *calcopt)
{
  g_assert (calcopt != NULL);
  
  calcopt->start_idx = -1;
  calcopt->end_idx = -1;
  calcopt->mass_type = PXM_MASS_BOTH;
  calcopt->capping = PXM_CAPPING_BOTH;
  calcopt->mnm_chement = PXMCHEMENT_MNM_NONE;
  calcopt->plm_chement = PXMCHEMENT_PLM_NONE;

  return TRUE;
}




/* XML-format TRANSACTIONS
 */
gchar *
pxmchem_calcopt_format_xml_string_calcopt (PxmCalcOpt *calcopt, 
				       gchar *indent, gint offset)
{
  g_log (G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE,
	_("%s@%d: Not implemented yet\n"),
	 __FILE__, __LINE__);

  return NULL;
}
  


PxmCalcOpt *
pxmchem_calcopt_render_xml_node_calcopt (xmlDocPtr xml_doc,
					  xmlNodePtr xml_node,
					  gpointer user_data)
{
  g_log (G_LOG_DOMAIN, G_LOG_LEVEL_MESSAGE,
	_("%s@%d: Not implemented yet\n"),
	 __FILE__, __LINE__);

  return NULL;
}




/* FREE'ING FUNCTIONS
 */
gboolean
pxmchem_calcopt_free (PxmCalcOpt *calcopt)
{
  g_assert (calcopt != NULL);
  
  g_free (calcopt);
  
  return TRUE;
}



