/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "QImageImage.h"

#include <QImage>

#include "QImageBuffer.h"

#include <GTLCore/PixelDescription.h>
#include <GTLCore/Type.h>

using namespace QtGTL;

QImageImage::QImageImage(const QImage& img) : BufferImage( img.width(), img.height(), new QImageBuffer( img ), imageToPixelDescription( img ) )
{
}

QImageImage::~QImageImage()
{
}

const QImage& QImageImage::image() const
{
  return static_cast<const QImageBuffer*>(buffer())->image();
}

inline std::vector< std::size_t > createPositions( std::size_t _nc )
{
  std::vector< std::size_t > v;
  v.push_back( 2 );
  v.push_back( 1 );
  v.push_back( 0 );
  if( _nc == 4 )
  {
    v.push_back( 3 );
  }
  return v;
}

GTLCore::PixelDescription QImageImage::imageToPixelDescription( const QImage& img )
{
  switch( img.format())
  {
    case QImage::Format_RGB32:
    {
      GTLCore::PixelDescription p = GTLCore::PixelDescription( GTLCore::Type::UnsignedInteger8, 4 );
      p.setChannelPositions( createPositions( 4 ) );
      return p;
    }
    case QImage::Format_ARGB32:
    {
      GTLCore::PixelDescription p = GTLCore::PixelDescription( GTLCore::Type::UnsignedInteger8, 4 );
      p.setChannelPositions( createPositions( 4 ) );
      return p;
    }
    case QImage::Format_RGB888:
    {
      GTLCore::PixelDescription p = GTLCore::PixelDescription( GTLCore::Type::UnsignedInteger8, 3 );
      p.setChannelPositions( createPositions( 3 ) );
      return p;
    }
    default:
      qFatal("Unsupported QImage");
  }
}
