
/*
 * Routine to Decode an AVI CRAM chunk
 */

#include "xanim.h"

extern xaUBYTE  *xa_byte_limit;


#define CRAM_DITH_COL2RGB(_r,_g,_b,_col) { \
_r = (_col & 0x7c00); _g = (_col & 0x03e0); _b = (_col & 0x001f);       \
_r = _r | (_r >> 5);  _g = (_g << 5) | _g; _b = (_b << 10) | (_b << 5); }

#define CRAM_DITH_GET_RGB(_r,_g,_b,_re,_ge,_be,_col) { xaLONG r1,g1,b1; \
  r1 = (xaLONG)rnglimit[(_r + _re) >> 7]; \
  g1 = (xaLONG)rnglimit[(_g + _ge) >> 7]; \
  b1 = (xaLONG)rnglimit[(_b + _be) >> 7]; \
  _col = (r1 & 0xe0) | ((g1 & 0xe0) >> 3) | ((b1 & 0xc0) >> 6); }

#define CRAM_DITH_GET_ERR(_r,_g,_b,_re,_ge,_be,_col,cmap) { \
  _re =  ((xaLONG)(_r) - (xaLONG)(cmap[_col].red   >> 1)) >> 1; \
  _ge =  ((xaLONG)(_g) - (xaLONG)(cmap[_col].green >> 1)) >> 1; \
  _be =  ((xaLONG)(_b) - (xaLONG)(cmap[_col].blue  >> 1)) >> 1; }


#define AVI_CRAM_C1(ip,clr,rdec) { \
 *ip++ = clr; *ip++ = clr; *ip++ = clr; *ip = clr; ip -= rdec; \
 *ip++ = clr; *ip++ = clr; *ip++ = clr; *ip = clr; ip -= rdec; \
 *ip++ = clr; *ip++ = clr; *ip++ = clr; *ip = clr; ip -= rdec; \
 *ip++ = clr; *ip++ = clr; *ip++ = clr; *ip = clr; }

#define AVI_CRAM_C2(ip,flag,cA,cB,rdec) { \
  *ip++ =(flag&0x01)?(cB):(cA); *ip++ =(flag&0x02)?(cB):(cA); \
  *ip++ =(flag&0x04)?(cB):(cA); *ip   =(flag&0x08)?(cB):(cA); ip-=rdec; \
  *ip++ =(flag&0x10)?(cB):(cA); *ip++ =(flag&0x20)?(cB):(cA); \
  *ip++ =(flag&0x40)?(cB):(cA); *ip   =(flag&0x80)?(cB):(cA); }

#define AVI_CRAM_C4(ip,flag,cA0,cA1,cB0,cB1,rdec) { \
  *ip++ =(flag&0x01)?(cB0):(cA0); *ip++ =(flag&0x02)?(cB0):(cA0); \
  *ip++ =(flag&0x04)?(cB1):(cA1); *ip   =(flag&0x08)?(cB1):(cA1); ip-=rdec; \
  *ip++ =(flag&0x10)?(cB0):(cA0); *ip++ =(flag&0x20)?(cB0):(cA0); \
  *ip++ =(flag&0x40)?(cB1):(cA1); *ip   =(flag&0x80)?(cB1):(cA1); }

#define AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y) { \
    if (x < min_x) min_x = x; if (y > max_y) max_y = y; \
    if (x > max_x) max_x = x; if (y < min_y) min_y = y; } 

#define AVI_BLOCK_INC(x,y,imagex) { x += 4; if (x>=imagex) { x=0; y -= 4; } }

#define AVI_GET_16(data,dptr) { data = *dptr++; data |= (*dptr++) << 8; }

#define AVI_CRAM_rgbC1(ip,r,g,b) { \
 *ip++=r; *ip++=g; *ip++=b; *ip++=r; *ip++=g; *ip++=b; \
 *ip++=r; *ip++=g; *ip++=b; *ip++=r; *ip++=g; *ip  =b; }

#define AVI_CRAM_rgbC2(ip,flag,rA,gA,bA,rB,gB,bB) { \
  if (flag&0x01) {*ip++=rB; *ip++=gB; *ip++=bB;} \
  else           {*ip++=rA; *ip++=gA; *ip++=bA;} \
  if (flag&0x02) {*ip++=rB; *ip++=gB; *ip++=bB;} \
  else           {*ip++=rA; *ip++=gA; *ip++=bA;} \
  if (flag&0x04) {*ip++=rB; *ip++=gB; *ip++=bB;} \
  else           {*ip++=rA; *ip++=gA; *ip++=bA;} \
  if (flag&0x08) {*ip++=rB; *ip++=gB; *ip  =bB;} \
  else           {*ip++=rA; *ip++=gA; *ip  =bA;}  }

#define AVI_CRAM_rgbC4(ip,flag,rA,gA,bA,rB,gB,bB) { \
  if (flag&0x01) {*ip++=rB; *ip++=gB; *ip++=bB;} \
  else           {*ip++=rA; *ip++=gA; *ip++=bA;} \
  if (flag&0x02) {*ip++=rB; *ip++=gB; *ip  =bB;} \
  else           {*ip++=rA; *ip++=gA; *ip  =bA;} }

#define AVI_Get_RGBColor(r,g,b,color) \
{ register xaULONG _r,_g,_b; \
  _r = (color >> 10) & 0x1f; r = (_r << 3) | (_r >> 2); \
  _g = (color >>  5) & 0x1f; g = (_g << 3) | (_g >> 2); \
  _b =  color & 0x1f;        b = (_b << 3) | (_b >> 2); \
  if (xa_gamma_flag==xaTRUE) { r = xa_gamma_adj[r]>>8;    \
     g = xa_gamma_adj[g]>>8; b = xa_gamma_adj[b]>>8; } }

xaULONG
AVI_Decode_CRAM(image,delta,dsize,dec_info)
xaUBYTE *image;         /* Image Buffer. */
xaUBYTE *delta;         /* delta data. */
xaULONG dsize;          /* delta size */
XA_DEC_INFO *dec_info;  /* Decoder Info Header */
{ xaLONG imagex = dec_info->imagex;    xaLONG imagey = dec_info->imagey;
  xaULONG map_flag = dec_info->map_flag;        xaULONG *map = dec_info->map;
  xaULONG row_dec,exitflag,changed,block_cnt;
  xaULONG code0,code1;
  xaLONG x,y,min_x,max_x,min_y,max_y;
  xaUBYTE *dptr;

  changed = 0;
  max_x = max_y = 0;    min_x = imagex; min_y = imagey;
  dptr = delta;
  row_dec = imagex + 3;
  x = 0;
  y = imagey - 1;
  exitflag = 0;
  block_cnt = ((imagex * imagey) >> 4) + 1;
  if (map_flag == xaTRUE)
  {
    if (x11_bytes_pixel == 4)
    {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( ((code1==0) && (code0==0) && !block_cnt) || (y<0)) exitflag = 1;
        else
        {
          if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
          { xaULONG skip = ((code1 - 0x84) << 8) + code0;
            block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
          }
          else /* single block encoded */
          {
            if (code1 >= 0x90) /* 8 color quadrant encoding */
            { xaULONG cA0,cA1,cB0,cB1;
              xaULONG *i_ptr = (xaULONG *)(image + ((y * imagex + x) << 2) );
              cB0 = (xaULONG)map[*dptr++];  cA0 = (xaULONG)map[*dptr++];
              cB1 = (xaULONG)map[*dptr++];  cA1 = (xaULONG)map[*dptr++];
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              cB0 = (xaULONG)map[*dptr++];  cA0 = (xaULONG)map[*dptr++];
              cB1 = (xaULONG)map[*dptr++];  cA1 = (xaULONG)map[*dptr++];
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } else if (code1 < 0x80) /* 2 color encoding */
            { register xaULONG clr_A,clr_B;
              xaULONG *i_ptr = (xaULONG *)(image + ((y * imagex + x) << 2) );
              clr_B = (xaULONG)map[*dptr++];   clr_A = (xaULONG)map[*dptr++];
              AVI_CRAM_C2(i_ptr,code0,clr_A,clr_B,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,clr_A,clr_B,row_dec);
            }
            else /* 1 color encoding */
            { xaULONG clr = (xaULONG)map[code0]; 
              xaULONG *i_ptr = (xaULONG *)(image + ((y * imagex + x) << 2) );
              AVI_CRAM_C1(i_ptr,clr,row_dec);
            }
            AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
            changed = 1; AVI_BLOCK_INC(x,y,imagex);
          } /* end of single block */
        } /* end of not term code */
      } /* end of not while exit */
    } /* end of 4 bytes pixel */
    else if (x11_bytes_pixel == 2)
    {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( ((code1==0) && (code0==0) && !block_cnt) || (y<0)) exitflag = 1;
        else
        {
          if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
          { xaULONG skip = ((code1 - 0x84) << 8) + code0;
            block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
          } else /* single block encoded */
          {
            if (code1 >= 0x90) /* 8 color quadrant encoding */
            {
              xaUSHORT cA0,cA1,cB0,cB1;
              xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y * imagex + x) << 1) );
              cB0 = map[*dptr++];  cA0 = map[*dptr++];
              cB1 = map[*dptr++];  cA1 = map[*dptr++];
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              cB0 = map[*dptr++];  cA0 = map[*dptr++];
              cB1 = map[*dptr++];  cA1 = map[*dptr++];
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } /* end of 8 color quadrant encoding */
            else if (code1 < 0x80) /* 2 color encoding */
            { xaUSHORT clr_A,clr_B;
              xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y * imagex + x) << 1) );
              clr_B = (xaUSHORT)map[*dptr++];   clr_A = (xaUSHORT)map[*dptr++];
              AVI_CRAM_C2(i_ptr,code0,clr_A,clr_B,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,clr_A,clr_B,row_dec);
            } /* end of 2 color */
            else /* 1 color encoding */
            { xaUSHORT clr = (xaUSHORT)map[code0];
              xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y * imagex + x) << 1) );
              AVI_CRAM_C1(i_ptr,clr,row_dec);
            }
            AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
            changed = 1; AVI_BLOCK_INC(x,y,imagex);
          } /* end of single block */
        } /* end of not term code */
      } /* end of not while exit */
    } /* end of 2 bytes pixel */
    else /* (x11_bytes_pixel == 1) */
    {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( ((code1==0) && (code0==0) && !block_cnt) || (y<0)) exitflag = 1;
        else
        {
          if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
          { xaULONG skip = ((code1 - 0x84) << 8) + code0;
            block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
          } else /* single block encoded */
          { 
            if (code1 >= 0x90) /* 8 color quadrant encoding */
            { xaUBYTE cA0,cA1,cB0,cB1;
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              cB0 = (xaUBYTE)map[*dptr++];  cA0 = (xaUBYTE)map[*dptr++];
              cB1 = (xaUBYTE)map[*dptr++];  cA1 = (xaUBYTE)map[*dptr++];
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              cB0 = (xaUBYTE)map[*dptr++];  cA0 = (xaUBYTE)map[*dptr++];
              cB1 = (xaUBYTE)map[*dptr++];  cA1 = (xaUBYTE)map[*dptr++];
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } 
            else if (code1 < 0x80) /* 2 color encoding */
            { xaUBYTE clr_A,clr_B;
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              clr_B = (xaUBYTE)map[*dptr++];   clr_A = (xaUBYTE)map[*dptr++];
              AVI_CRAM_C2(i_ptr,code0,clr_A,clr_B,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,clr_A,clr_B,row_dec);
            }
            else /* 1 color encoding */
            { xaUBYTE clr = (xaUBYTE)map[code0];
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              AVI_CRAM_C1(i_ptr,clr,row_dec);
            }
            AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
            changed = 1; AVI_BLOCK_INC(x,y,imagex);
          } /* end of single block */
        } /* end of not term code */
      } /* end of not while exit */
    } /* end of 1 bytes pixel */
  } /* end of map is xaTRUE */
  else
  {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( ((code1==0) && (code0==0) && !block_cnt) || (y<0)) exitflag = 1;
        else
        {
          if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
          { xaULONG skip = ((code1 - 0x84) << 8) + code0;
            block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
          } else /* single block encoded */
          {
            if (code1 >= 0x90) /* 8 color quadrant encoding */
            {
              xaUBYTE cA0,cA1,cB0,cB1;
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              cB0 = (xaUBYTE)*dptr++;  cA0 = (xaUBYTE)*dptr++;
              cB1 = (xaUBYTE)*dptr++;  cA1 = (xaUBYTE)*dptr++;
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              cB0 = (xaUBYTE)*dptr++;  cA0 = (xaUBYTE)*dptr++;
              cB1 = (xaUBYTE)*dptr++;  cA1 = (xaUBYTE)*dptr++;
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } 
            else if (code1 < 0x80) /* 2 color encoding */
            { xaUBYTE clr_A,clr_B;
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              clr_B = (xaUBYTE)*dptr++;   clr_A = (xaUBYTE)*dptr++;
              AVI_CRAM_C2(i_ptr,code0,clr_A,clr_B,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,clr_A,clr_B,row_dec);
            } /* end of 2 color */
            else /* 1 color encoding */
            {
              xaUBYTE clr = (xaUBYTE)code0;
              xaUBYTE *i_ptr = (xaUBYTE *)(image + y * imagex + x);
              AVI_CRAM_C1(i_ptr,clr,row_dec);
            }
            AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
            changed = 1; AVI_BLOCK_INC(x,y,imagex);
          } /* end of single block */
        } /* end of not term code */
      } /* end of not while exit */
  }
  if (xa_optimize_flag == xaTRUE)
  {
    if (changed) { dec_info->xs=min_x; dec_info->ys=min_y - 3;
                        dec_info->xe=max_x + 4; dec_info->ye=max_y + 1; }
    else  { dec_info->xs = dec_info->ys = dec_info->xe = dec_info->ye = 0;
                        return(ACT_DLTA_NOP); }
  }
  else { dec_info->xs = dec_info->ys = 0;
         dec_info->xe = imagex; dec_info->ye = imagey; }
  if (map_flag) return(ACT_DLTA_MAPD);
  else return(ACT_DLTA_NORM);
}

/**************************************************
 * Decode Microsoft Video 1 Depth 16 Video Codec
 * XAPI Rev 0x0001
 *
 *************/
xaULONG AVI_Decode_CRAM16(image,delta,dsize,dec_info)
xaUBYTE *image;         /* Image Buffer. */
xaUBYTE *delta;         /* delta data. */
xaULONG dsize;          /* delta size */
XA_DEC_INFO *dec_info;  /* Decoder Info Header */
{ xaLONG imagex = dec_info->imagex;    xaLONG imagey = dec_info->imagey;
  xaULONG map_flag = dec_info->map_flag;        xaULONG *map = dec_info->map;
  xaULONG special = dec_info->special;
  XA_CHDR *chdr = dec_info->chdr;
  xaULONG row_dec,exitflag,changed,block_cnt;
  xaULONG code0,code1,dither = 0;
  xaLONG x,y,min_x,max_x,min_y,max_y;
  xaUBYTE *dptr;

  if (chdr) { if (chdr->new_chdr) chdr = chdr->new_chdr; }

   /* special case dither routine - fill out a bit */
  if (   (!special) && (x11_bytes_pixel==1)
      && (chdr) && (x11_display_type == XA_PSEUDOCOLOR)
      && (cmap_color_func != 4)
      && (cmap_true_to_332 == xaTRUE) && (x11_cmap_size == 256)
      && (xa_dither_flag==xaTRUE)
     )
     dither = 1;


  changed = 0;
  max_x = max_y = 0;    min_x = imagex; min_y = imagey;
  dptr = delta;
  if (special) row_dec = (3*(imagex+4))-1; else row_dec = imagex + 3; 
  x = 0;
  y = imagey - 1;
  exitflag = 0;
  block_cnt = ((imagex * imagey) >> 4) + 1;

  if (special == 1)
  {
    while(!exitflag)
    {
      code0 =  *dptr++; code1 =  *dptr++;       block_cnt--;
      if ( (code1==0) && (code0==0) && !block_cnt) { exitflag = 1; continue; }
      if (y < 0) {exitflag = 1; continue; }
      if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
      { xaULONG skip = ((code1 - 0x84) << 8) + code0;
        block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
      }
      else /* not skip */
      { xaUBYTE *i_ptr = (xaUBYTE *)(image + 3 * (y * imagex + x) );
        if (code1 < 0x80) /* 2 or 8 color encoding */
        { xaULONG cA,cB; xaUBYTE rA0,gA0,bA0,rB0,gB0,bB0;
          AVI_GET_16(cB,dptr); AVI_Get_RGBColor(rB0,gB0,bB0,cB);
          AVI_GET_16(cA,dptr); AVI_Get_RGBColor(rA0,gA0,bA0,cA); 
          if (cB & 0x8000)   /* Eight Color Encoding */
          { xaUBYTE rA1,gA1,bA1,rB1,gB1,bB1;
            register xaULONG flag = code0;
            AVI_GET_16(cB,dptr); AVI_Get_RGBColor(rB1,gB1,bB1,cB);
            AVI_GET_16(cA,dptr); AVI_Get_RGBColor(rA1,gA1,bA1,cA); 
            AVI_CRAM_rgbC4(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr++; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA1,gA1,bA1,rB1,gB1,bB1); 
            i_ptr -= row_dec; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr++; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA1,gA1,bA1,rB1,gB1,bB1); 
            i_ptr -= row_dec; flag = code1;
            AVI_GET_16(cB,dptr); AVI_Get_RGBColor(rB0,gB0,bB0,cB);
            AVI_GET_16(cA,dptr); AVI_Get_RGBColor(rA0,gA0,bA0,cA); 
            AVI_GET_16(cB,dptr); AVI_Get_RGBColor(rB1,gB1,bB1,cB);
            AVI_GET_16(cA,dptr); AVI_Get_RGBColor(rA1,gA1,bA1,cA); 
            AVI_CRAM_rgbC4(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr++; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA1,gA1,bA1,rB1,gB1,bB1); 
            i_ptr -= row_dec; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr++; flag >>= 2;
            AVI_CRAM_rgbC4(i_ptr,flag,rA1,gA1,bA1,rB1,gB1,bB1); 
          } else /* Two Color Encoding */
          { register xaULONG flag = code0;
            AVI_CRAM_rgbC2(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr -= row_dec; flag >>= 4;
            AVI_CRAM_rgbC2(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr -= row_dec; flag = code1;
            AVI_CRAM_rgbC2(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
            i_ptr -= row_dec; flag >>= 4;
            AVI_CRAM_rgbC2(i_ptr,flag,rA0,gA0,bA0,rB0,gB0,bB0); 
          }
        } /* end of 2 or 8 */
        else /* 1 color encoding (80-83) && (>=88)*/
        { xaULONG cA = (code1<<8) | code0;
          xaUBYTE r,g,b;
          AVI_Get_RGBColor(r,g,b,cA);
          AVI_CRAM_rgbC1(i_ptr,r,g,b);  i_ptr -= row_dec;
          AVI_CRAM_rgbC1(i_ptr,r,g,b);  i_ptr -= row_dec;
          AVI_CRAM_rgbC1(i_ptr,r,g,b);  i_ptr -= row_dec;
          AVI_CRAM_rgbC1(i_ptr,r,g,b);
        }
        changed = 1; AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
        AVI_BLOCK_INC(x,y,imagex);
      } /* end of not skip */
    } /* end of not while exit */
  } /* end of special */
  else
  {
    if (dither)
    { ColorReg *cmap = chdr->cmap;
      xaUBYTE *rnglimit = xa_byte_limit;

      while(!exitflag)
      { code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( (code1==0) && (code0==0) && !block_cnt) { exitflag = 1; continue; }
        if (y < 0) {exitflag = 1; continue; }
        if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
        { xaULONG skip = ((code1 - 0x84) << 8) + code0;
          block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
        }
        else /* not skip */
        { xaUBYTE *ip = (xaUBYTE *)(image + (y * imagex + x) );
          if (code1 < 0x80) /* 2 or 8 color encoding */
          { xaULONG cA,cB;
            AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
            if (cB & 0x8000)   /* Eight Color Encoding */
            { xaUBYTE cA0,cB0, cA1,cB1;
              cB0 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA0 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(ip,code0,cA0,cA1,cB0,cB1,row_dec);
              ip -=row_dec;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB0 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA0 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(ip,code1,cA0,cA1,cB0,cB1,row_dec);
            } else /* Two Color Encoding */
            { xaUBYTE clr0a,clr0b,clr1a,clr1b;
              xaLONG re,ge,be,r,g,b;

              CRAM_DITH_COL2RGB(r,g,b,cA);
              CRAM_DITH_GET_RGB(r,g,b, 0, 0, 0,clr0a);
              if (map_flag) clr0a = map[clr0a];
              CRAM_DITH_GET_ERR(r,g,b,re,ge,be,clr0a,cmap);
              CRAM_DITH_GET_RGB(r,g,b,re,ge,be,clr1a);
              if (map_flag) clr1a = map[clr1a];

              CRAM_DITH_COL2RGB(r,g,b,cB);
              CRAM_DITH_GET_RGB(r,g,b, 0, 0, 0,clr0b);
              if (map_flag) clr0b = map[clr0b];
              CRAM_DITH_GET_ERR(r,g,b,re,ge,be,clr0b,cmap);
              CRAM_DITH_GET_RGB(r,g,b,re,ge,be,clr1b);
              if (map_flag) clr1b = map[clr1b];

  *ip++ =(code0 & 0x01)?(clr0b):(clr0a); *ip++ =(code0 & 0x02)?(clr1b):(clr1a); 
  *ip++ =(code0 & 0x04)?(clr0b):(clr0a); *ip   =(code0 & 0x08)?(clr1b):(clr1a);
  ip -= row_dec; 
  *ip++ =(code0 & 0x10)?(clr1b):(clr1a); *ip++ =(code0 & 0x20)?(clr0b):(clr0a); 
  *ip++ =(code0 & 0x40)?(clr1b):(clr1a); *ip   =(code0 & 0x80)?(clr0b):(clr0a);
  ip -= row_dec;
  *ip++ =(code1 & 0x01)?(clr0b):(clr0a); *ip++ =(code1 & 0x02)?(clr1b):(clr1a); 
  *ip++ =(code1 & 0x04)?(clr0b):(clr0a); *ip   =(code1 & 0x08)?(clr1b):(clr1a);
  ip -= row_dec; 
  *ip++ =(code1 & 0x10)?(clr1b):(clr1a); *ip++ =(code1 & 0x20)?(clr0b):(clr0a); 
  *ip++ =(code1 & 0x40)?(clr1b):(clr1a); *ip   =(code1 & 0x80)?(clr0b):(clr0a);

            }
          } /* end of 2 or 8 */
          else /* 1 color encoding (80-83) && (>=88)*/
          { xaULONG cA = (code1<<8) | code0;
            xaUBYTE clr0,clr1;
            xaLONG re,ge,be,r,g,b;

            CRAM_DITH_COL2RGB(r,g,b,cA);
            CRAM_DITH_GET_RGB(r,g,b, 0, 0, 0,clr0);
            if (map_flag) clr0 = map[clr0];
            CRAM_DITH_GET_ERR(r,g,b,re,ge,be,clr0,cmap);
            CRAM_DITH_GET_RGB(r,g,b,re,ge,be,clr1);
            if (map_flag) clr1 = map[clr1];

 *ip++ = clr0; *ip++ = clr1; *ip++ = clr0; *ip = clr1; ip -= row_dec; 
 *ip++ = clr1; *ip++ = clr0; *ip++ = clr1; *ip = clr0; ip -= row_dec; 
 *ip++ = clr0; *ip++ = clr1; *ip++ = clr0; *ip = clr1; ip -= row_dec; 
 *ip++ = clr1; *ip++ = clr0; *ip++ = clr1; *ip = clr0; 


          }
          changed = 1; AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
          AVI_BLOCK_INC(x,y,imagex);
        } /* end of not skip */
      } /* end of not while exit */
    } /* end of dither */
    else if ( (x11_bytes_pixel == 1) || (map_flag == xaFALSE) )
    {
      while(!exitflag)
      { code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( (code1==0) && (code0==0) && !block_cnt) { exitflag = 1; continue; }
        if (y < 0) {exitflag = 1; continue; }
        if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
        { xaULONG skip = ((code1 - 0x84) << 8) + code0;
          block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
        }
        else /* not skip */
        { xaUBYTE *i_ptr = (xaUBYTE *)(image + (y * imagex + x) );
          if (code1 < 0x80) /* 2 or 8 color encoding */
          { xaULONG cA,cB; xaUBYTE cA0,cB0;
            AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
            cB0 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
            cA0 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
            if (cB & 0x8000)   /* Eight Color Encoding */
            { xaUBYTE cA1,cB1;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB0 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA0 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUBYTE)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } else /* Two Color Encoding */
            { 
              AVI_CRAM_C2(i_ptr,code0,cA0,cB0,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,cA0,cB0,row_dec);
            }
          } /* end of 2 or 8 */
          else /* 1 color encoding (80-83) && (>=88)*/
          { xaULONG cA = (code1<<8) | code0;
            xaUBYTE clr = (xaUBYTE)AVI_Get_Color(cA,map_flag,map,chdr);
            AVI_CRAM_C1(i_ptr,clr,row_dec);
          }
          changed = 1; AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
          AVI_BLOCK_INC(x,y,imagex);
        } /* end of not skip */
      } /* end of not while exit */
    } /* end of 1 bytes pixel */
    else if (x11_bytes_pixel == 2)
    {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( (code1==0) && (code0==0) && !block_cnt) { exitflag = 1; continue; }
        if (y < 0) {exitflag = 1; continue; }
        if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
        { xaULONG skip = ((code1 - 0x84) << 8) + code0;
          block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
        }
        else /* not skip */
        { xaUSHORT *i_ptr = (xaUSHORT *)(image + ((y * imagex + x) << 1) );
          if (code1 < 0x80) /* 2 or 8 color encoding */
          { xaULONG cA,cB; xaUSHORT cA0,cB0;
            AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
            cB0 = (xaUSHORT)AVI_Get_Color(cB,map_flag,map,chdr);
            cA0 = (xaUSHORT)AVI_Get_Color(cA,map_flag,map,chdr);
            if (cB & 0x8000)   /* Eight Color Encoding */
            { xaUSHORT cA1,cB1;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUSHORT)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUSHORT)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB0 = (xaUSHORT)AVI_Get_Color(cB,map_flag,map,chdr);
              cA0 = (xaUSHORT)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = (xaUSHORT)AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = (xaUSHORT)AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } else /* Two Color Encoding */
            { 
              AVI_CRAM_C2(i_ptr,code0,cA0,cB0,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,cA0,cB0,row_dec);
            }
          } /* end of 2 or 8 */
          else /* 1 color encoding (80-83) && (>=88)*/
          { xaULONG cA = (code1<<8) | code0;
            xaUSHORT clr = (xaUSHORT)AVI_Get_Color(cA,map_flag,map,chdr);
            AVI_CRAM_C1(i_ptr,clr,row_dec);
          }
          changed = 1; AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
          AVI_BLOCK_INC(x,y,imagex);
        } /* end of not skip */
      } /* end of not while exit */
    } /* end of 2 bytes pixel */
    else if (x11_bytes_pixel == 4)
    {
      while(!exitflag)
      {
        code0 =  *dptr++;       code1 =  *dptr++;       block_cnt--;
        if ( (code1==0) && (code0==0) && !block_cnt) { exitflag = 1; continue; }
        if (y < 0) {exitflag = 1; continue; }
        if ((code1 >= 0x84) && (code1 <= 0x87)) /* skip */
        { xaULONG skip = ((code1 - 0x84) << 8) + code0;
          block_cnt -= (skip-1); while(skip--) AVI_BLOCK_INC(x,y,imagex);
        }
        else /* not skip */
        { xaULONG *i_ptr = (xaULONG *)(image + ((y * imagex + x) << 2) );
          if (code1 < 0x80) /* 2 or 8 color encoding */
          { xaULONG cA,cB,cA0,cB0;
            AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
            cB0 = AVI_Get_Color(cB,map_flag,map,chdr);
            cA0 = AVI_Get_Color(cA,map_flag,map,chdr);
            if (cB & 0x8000)   /* Eight Color Encoding */
            { xaULONG cA1,cB1;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code0,cA0,cA1,cB0,cB1,row_dec); i_ptr -=row_dec;
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB0 = AVI_Get_Color(cB,map_flag,map,chdr);
              cA0 = AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_GET_16(cB,dptr); AVI_GET_16(cA,dptr);
              cB1 = AVI_Get_Color(cB,map_flag,map,chdr);
              cA1 = AVI_Get_Color(cA,map_flag,map,chdr);
              AVI_CRAM_C4(i_ptr,code1,cA0,cA1,cB0,cB1,row_dec);
            } else /* Two Color Encoding */
            {
              AVI_CRAM_C2(i_ptr,code0,cA0,cB0,row_dec); i_ptr -= row_dec;
              AVI_CRAM_C2(i_ptr,code1,cA0,cB0,row_dec);
            }
          } /* end of 2 or 8 */
          else /* 1 color encoding (80-83) && (>=88)*/
          { xaULONG cA = (code1<<8) | code0;
            xaULONG clr = AVI_Get_Color(cA,map_flag,map,chdr);
            AVI_CRAM_C1(i_ptr,clr,row_dec);
          }
          changed = 1; AVI_MIN_MAX_CHECK(x,y,min_x,max_x,min_y,max_y);
          AVI_BLOCK_INC(x,y,imagex);
        } /* end of not skip */
      } /* end of not while exit */
    } /* end of 4 bytes pixel */
  } /* end of not special */
  if (xa_optimize_flag == xaTRUE)
  {
    if (changed) {      dec_info->xs=min_x;     dec_info->ys=min_y - 3;
                        dec_info->xe=max_x + 4; dec_info->ye=max_y + 1; }
    else  { dec_info->xs = dec_info->ys = dec_info->xe = dec_info->ye = 0;
                                                return(ACT_DLTA_NOP); }
  }
  else { dec_info->xs = dec_info->ys = 0; 
         dec_info->xe = imagex; dec_info->ye = imagey; }
  if (map_flag) return(ACT_DLTA_MAPD);
  else return(ACT_DLTA_NORM);
}
