
#include <memory> // auto_ptr

#include "data_node_io.h"
#include "FlexLexer.h"

#include <S11N_NS/class_loader.h>
namespace S11N_NS {
        namespace io {

                namespace Private {

                        int lex_api_hider_yylex( FlexLexer * f, std::istream & is  )
                        {
                                f->switch_streams( & is );
                                int ret = 0;
                                while( 0 != (ret = f->yylex() ) );
                                return ret;
                        }
                }

                std::string get_magic_cookie( const std::string & src, bool AsFile )
                {
                        if( src.empty() ) return src;
                        std::string ret;
                        typedef std::auto_ptr<std::istream> AP;
                        AP is = AP( S11N_NS::get_istream( src, AsFile ) );
                        if( ! is.get() ) return ret;
                        return ( std::getline( *is, ret ).eof() ? "" : ret ); 
                }

                std::string get_magic_cookie( std::istream & is )
                {
                        std::string ret;
                        if( std::getline( is, ret ).eof() ) return "";
                        return ret;
                }


        } // namespace io
} // namespace S11N_NS
