using System;
using System.Runtime.InteropServices;
 
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An error, warning or other diagnostic.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * When a libSBML operation on SBML content results in an error, or when
 * there is something wrong with the SBML content, the problems are
 * reported as SBMLError objects.  These are generally stored in an
 * SBMLErrorLog object; this log object, in turn, is kept in the
 * SBMLDocument object containing the SBML content.  Applications can
 * obtain the list of logged errors using SBMLDocument::getErrorLog() and
 * then use the methods provided by SBMLErrorLog to access individual
 * SBMLError objects.  (Note that despite the word 'error' in the name,
 * SBMLError objects are used to represent not only 'true' errors, but also
 * warnings and some informational diagnostics.  The name is a historical
 * hold-over from early versions of libSBML, in which the object really was
 * only used to report errors.)
 *
 * @if clike
 * Each SBMLError object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will be listed in one of two enumerations:
 * <a class='el' href='#SBMLErrorCode_t'> SBMLErrorCode_t</a> (described <a
 * class='el' href='#SBMLErrorCode_t'> below</a>) or @link
 * XMLError::XMLErrorCode_t XMLErrorCode_t@endlink (described in the
 * documentation for the class XMLError).  The former enumeration contains
 * all the SBML validation rule numbers listed in the appendices of the
 * SBML specification documents, as well as some additional
 * libSBML-specific error codes.
 * @endif@if java
 * Each SBMLError object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will come from one of two sets of static
 * integer constants defined in the interface class <code><a
 * href='libsbml.libsbml.html'> libsbmlConstants</a></code>: either the
 * SBML error identifiers <a class='el' href='#SBMLErrorCode_t'> (described
 * below)</a> or the XML error identifiers (described in the documentation
 * for the class <code><a href='XMLError.html'> XMLError</a></code>).  The
 * former set of constants includes all the SBML validation rule numbers
 * listed in the appendices of the SBML specification documents, as well as
 * some additional libSBML-specific error codes.
 * @endif@if python
 * Each SBMLError object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will come from one
 * of two sets of static integer constants defined in
 * the interface class @link libsbml libsbml@endlink: either the SBML
 * error identifiers <a
 * class='el' href='#SBMLErrorCode_t'> (described below)</a> or the XML
 * error identifiers (described in the documentation for the class XMLError).
 * The former set of constants
 * includes all the SBML validation rule numbers listed in the appendices
 * of the SBML specification documents, as well as some additional
 * libSBML-specific error codes.
 * @endif
 *
 * Error codes are useful mainly for software.  For human readers,
 * SBMLError also includes text messages that describe the nature of a
 * given problem.  The messages can be accessed using
 * SBMLError::getShortMessage() and SBMLError::getMessage().  The former
 * provides a brief one-line description of the issue, while
 * SBMLError::getMessage() provides a more detailed text, including (if
 * appropriate) references to sections of the SBML specifications where
 * relevant topics are discussed.  These text strings are suitable for
 * displaying to human users.
 *
 * @if clike
 * An SBMLError object also contains a category code; its value may be
 * retrieved using the method SBMLError::getCategory().  Category values
 * are drawn from the enumeration <a class='el'
 * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a> described below.
 * Categories are used to partition errors into distinct conceptual groups.
 * This is principally used by the libSBML validation system to group
 * classes of validation checks.  For example,
 * @link libsbml#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink
 * is the category for tests that check identifier consistency;
 * @link libsbml#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink
 * is the category for MathML consistency checking; and
 * so on.
 * @endif@if java
 * An SBMLError object also contains a category code; its value may be
 * retrieved using the method SBMLError::getCategory().  Category values
 * are drawn from a set of static integer constants
 * defined in <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>,
 * and having names beginning with the characters
 * <code>LIBSBML_CAT_</code>.  The list of possible codes is described in a
 * separate section below.  Categories are used to partition errors into
 * distinct conceptual groups.  This is principally used by the libSBML
 * validation system to group classes of validation checks.  For example,
 * @link libsbml#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink
 * is the category for tests that check identifier consistency;
 * @link libsbml#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink
 * is the category for MathML consistency checking; and
 * so on.
 * @endif@if python
 * An SBMLError object also contains a category code; its value may be
 * retrieved using the method SBMLError::getCategory().  Category values
 * are drawn from a set of static integer constants
 * defined in @link libsbml libsbml@endlink and having names beginning with the characters
 * <code>LIBSBML_CAT_</code>.  The list of possible codes is described in a
 * separate section below.  Categories are used to partition errors into
 * distinct conceptual groups.  This is principally used by the libSBML
 * validation system to group classes of validation checks.  For example,
 * @link libsbml#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink
 * is the category for tests that check identifier consistency;
 * @link libsbml#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink
 * is the category for MathML consistency checking; and
 * so on.
 * @endif
 *
 * In addition, SBMLError also has a severity code.  Its value may be
 * retrieved using the method SBMLError::getSeverity().  The possible
 * severity values are the same as those reported by @if clike XMLError.@endif@if python XMLError.@endif@if java <code><a href='XMLError.html'>XMLError</a></code>.@endif
 * Severity levels currently range from informational
 * (@link libsbml#LIBSBML_SEV_INFO LIBSBML_SEV_INFO@endlink)
 * to fatal errors
 * (@link libsbml#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL@endlink).
 * They can be
 * used by an application to evaluate how serious a given problem
 * is.
 *
 * SBMLError also tracks the Level&nbsp;3 package extension, if any, was
 * responsible for a given warning or error.  Each diagnostic code logged by
 * an libSBML extension for SBML Level&nbsp;3 packages includes a record of
 * the package that logged it.  It can be retrieved using
 * SBMLError::getPackage().  The information is a simple text string; the
 * string will be the nickname of the package, such as @c 'comp' for the
 * Hierarchical %Model Composition package, @c 'fbc' for the Flux Balance
 * Constraints package, and so on.  If the value returned by
 * SBMLError::getPackage() is an empty string or has the value @c 'core',
 * then the error came from libSBML core.
 *
 * Finally, SBMLError records the line and column near where the problem
 * occurred in the SBML content.  The values may be retrieved using the
 * methods SBMLError::getLine() and SBMLError::getColumn().  We say 'near',
 * because a lot of factors affect how accurate the line/column information
 * ultimately is.  For example, different XML parsers have different
 * conventions for which line and column number they report for a
 * particular problem (which makes a difference when a problem involves an
 * opening XML tag on one line and a closing tag on another line).  In some
 * situations, some parsers report invalid line and/or column numbers
 * altogether.  If this occurs, libSBML sets the line and/or column number
 * in the SBMLError object to the the value of the maximum unsigned long
 * integer representable on the platform where libSBML is running.  (This
 * is equal to the constant named <code>ULONG_MAX</code> in C and C++.)
 * The probability that a true line or column number in an SBML model would
 * equal this value is vanishingly small; thus, if an application
 * encounters these values in an XMLError object, it can assume no valid
 * line/column number could be provided by libSBML in that situation.
 *
 * @if clike
 * <h3><a class='anchor' name='SBMLErrorCode_t'>SBMLErrorCode_t</a></h3>
 *
 * #SBMLErrorCode_t is an enumeration of all SBML-level error, warning and
 * informational diagnostic codes.  Every SBMLError object has an error
 * code value that can be either a value from this enumeration, or a value
 * from the #XMLErrorCode_t
 * enumeration (see the documentation for XMLError).  The latter values
 * apply when the error or warning signifies a basic XML issue rather than
 * an SBML issue per se.  The values of #SBMLErrorCode_t are distinguished
 * from those of #XMLErrorCode_t by
 * being numbered 10000 and higher, while the XML layer's codes are 9999 and
 * lower.  The method SBMLError::getErrorId() returns the error code of a
 * given SBMLError object instance.
 *
 * The following is a table of the symbolic names of #SBMLErrorCode_t values
 * and the meaning of each code.  In this table, the right-hand columns
 * titled 'L1V1', 'L1V2', etc. refer to Levels and Versions of the SBML
 * specifications, and the entries in each column refer to whether the
 * severity of the condition in that particular Level+Version of SBML.
 * The codes stand for the following:
 *
 * @endif@if java <h3><a class='anchor'
 * name='SBMLErrorCode_t'>Error codes associated with SBMLError objects</a></h3>
 *
 * The error and warning codes returned by libSBML are listed in the table
 * below.  The method SBMLError::getErrorId() returns the error code of a
 * given SBMLError object instance.  In the libSBML Java language
 * interface, these error identifiers are currently
 * implemented as static integer constants defined in the interface class
 * <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error identifiers.
 *
 * In this table, the right-hand columns titled 'L1V1', 'L1V2', etc. refer
 * to Levels and Versions of the SBML specifications, and the entries in
 * each column refer to whether the severity of the condition in that
 * particular Level+Version of SBML.  The codes stand for the following:
 *
 * @endif@if python <h3><a class='anchor'
 * name='SBMLErrorCode_t'>Error codes associated with SBMLError objects</a></h3>
 *
 * The error and warning codes returned by libSBML are listed in the table
 * below.  The method SBMLError::getErrorId() returns the error code of a
 * given SBMLError object instance.  In the libSBML Python language
 * interface, these error identifiers are currently
 * implemented as static integer constants defined in the interface class
 * @link libsbml libsbml@endlink.
 *
 * In this table, the right-hand columns titled 'L1V1', 'L1V2', etc. refer
 * to Levels and Versions of the SBML specifications, and the entries in
 * each column refer to whether the severity of the condition in that
 * particular Level+Version of SBML.  The codes stand for the following:
 *
 * @endif
 *
 * <table cellspacing='1' cellpadding='2' border='0' class='normal-font'>
 * <tr><td class='s-na'></td><td>= Not applicable</td></tr>
 * <tr><td class='s-warning'></td><td>= Warning</td></tr>
 * <tr><td class='s-error'></td><td>= Error</td></tr>
 * <tr><td class='s-fatal'></td><td>= Fatal</td></tr>
 * </table>
 *
 * The text shown in the 'Meaning' is the text returned by the
 * SBMLError::getShortMessage() method on a given SBMLError object.  A
 * longer and (hopefully) clearer explanation of the issue is returned by
 * SBMLError::getMessage().
 *
 * The error codes come from different lists depending on whether they're
 * from libSBML core or from an SBML Level&nbsp;3 package extension.
 * @if clike The errors below come from #XMLErrorCode_t and #SBMLErrorCode_t
 * (for core), and #CompSBMLErrorCode_t, #FbcSBMLErrorCode_t,
 * #LayoutSBMLErrorCode_t, and #QualSBMLErrorCode_t (for packages).@endif
 * @ifnot clike However, in the language interfaces other than C++, all
 * libSBML error codes are ultimately represented as integer constants rather
 * than separate enumerations lists, and they are all stored in a single
 * interface class.  Codes from different libSBML extensions have names that
 * begin with the package's nickname, such as <code>Qual</code> for
 * the Qualitative Models package, <code>Layout</code> for the Layout
 * package, and so on.  If the name of a code does not begin with one of
 * the package nicknames (<code>%Layout</code>, <code>Fbc</code>,
 * <code>Comp</code>, <code>Qual</code>, etc.), then it is a code
 * from libSBML core.@endif
 *
 *
 * 
<table id='sbmlerror-table'
       class='text-table small-font alt-row-colors'
       width='95%' cellspacing='1' cellpadding='2' border='0'>
 <tr style='background: lightgray' class='normal-font'>
     <th valign='bottom'><strong>Enumerator</strong></th>
     <th valign='bottom'><strong>Meaning</strong></th>
     <th align='center' width='10'>L1 V1</th>
     <th align='center' width='10'>L1 V2</th>
     <th align='center' width='10'>L2 V1</th>
     <th align='center' width='10'>L2 V2</th>
     <th align='center' width='10'>L2 V3</th>
     <th align='center' width='10'>L2 V4</th>
     <th align='center' width='10'>L3 V1</th>
 </tr>
<tr><td class='code'>@link libsbml#XMLUnknownError XMLUnknownError@endlink</td>
<td class='meaning'>Unknown error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLOutOfMemory XMLOutOfMemory@endlink</td>
<td class='meaning'>Out of memory</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLFileUnreadable XMLFileUnreadable@endlink</td>
<td class='meaning'>File unreadable</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLFileUnwritable XMLFileUnwritable@endlink</td>
<td class='meaning'>File unwritable</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLFileOperationError XMLFileOperationError@endlink</td>
<td class='meaning'>File operation error</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLNetworkAccessError XMLNetworkAccessError@endlink</td>
<td class='meaning'>Network access error</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InternalXMLParserError InternalXMLParserError@endlink</td>
<td class='meaning'>Internal XML parser error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#UnrecognizedXMLParserCode UnrecognizedXMLParserCode@endlink</td>
<td class='meaning'>Unrecognized XML parser code</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLTranscoderError XMLTranscoderError@endlink</td>
<td class='meaning'>Transcoder error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingXMLDecl MissingXMLDecl@endlink</td>
<td class='meaning'>Missing XML declaration</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingXMLEncoding MissingXMLEncoding@endlink</td>
<td class='meaning'>Missing XML encoding attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLDecl BadXMLDecl@endlink</td>
<td class='meaning'>Bad XML declaration</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLDOCTYPE BadXMLDOCTYPE@endlink</td>
<td class='meaning'>Bad XML DOCTYPE</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidCharInXML InvalidCharInXML@endlink</td>
<td class='meaning'>Invalid character</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadlyFormedXML BadlyFormedXML@endlink</td>
<td class='meaning'>Badly formed XML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnclosedXMLToken UnclosedXMLToken@endlink</td>
<td class='meaning'>Unclosed token</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidXMLConstruct InvalidXMLConstruct@endlink</td>
<td class='meaning'>Invalid XML construct</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLTagMismatch XMLTagMismatch@endlink</td>
<td class='meaning'>XML tag mismatch</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateXMLAttribute DuplicateXMLAttribute@endlink</td>
<td class='meaning'>Duplicate attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UndefinedXMLEntity UndefinedXMLEntity@endlink</td>
<td class='meaning'>Undefined XML entity</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadProcessingInstruction BadProcessingInstruction@endlink</td>
<td class='meaning'>Bad XML processing instruction</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLPrefix BadXMLPrefix@endlink</td>
<td class='meaning'>Bad XML prefix</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLPrefixValue BadXMLPrefixValue@endlink</td>
<td class='meaning'>Bad XML prefix value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingXMLRequiredAttribute MissingXMLRequiredAttribute@endlink</td>
<td class='meaning'>Missing required attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLAttributeTypeMismatch XMLAttributeTypeMismatch@endlink</td>
<td class='meaning'>Attribute type mismatch</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLBadUTF8Content XMLBadUTF8Content@endlink</td>
<td class='meaning'>Bad UTF8 content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingXMLAttributeValue MissingXMLAttributeValue@endlink</td>
<td class='meaning'>Missing attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLAttributeValue BadXMLAttributeValue@endlink</td>
<td class='meaning'>Bad attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLAttribute BadXMLAttribute@endlink</td>
<td class='meaning'>Bad XML attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnrecognizedXMLElement UnrecognizedXMLElement@endlink</td>
<td class='meaning'>Unrecognized XML element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLComment BadXMLComment@endlink</td>
<td class='meaning'>Bad XML comment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLDeclLocation BadXMLDeclLocation@endlink</td>
<td class='meaning'>Bad XML declaration location</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLUnexpectedEOF XMLUnexpectedEOF@endlink</td>
<td class='meaning'>Unexpected EOF</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLIDValue BadXMLIDValue@endlink</td>
<td class='meaning'>Bad XML ID value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLIDRef BadXMLIDRef@endlink</td>
<td class='meaning'>Bad XML IDREF</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UninterpretableXMLContent UninterpretableXMLContent@endlink</td>
<td class='meaning'>Uninterpretable XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadXMLDocumentStructure BadXMLDocumentStructure@endlink</td>
<td class='meaning'>Bad XML document structure</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidAfterXMLContent InvalidAfterXMLContent@endlink</td>
<td class='meaning'>Invalid content after XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLExpectedQuotedString XMLExpectedQuotedString@endlink</td>
<td class='meaning'>Expected quoted string</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLEmptyValueNotPermitted XMLEmptyValueNotPermitted@endlink</td>
<td class='meaning'>Empty value not permitted</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLBadNumber XMLBadNumber@endlink</td>
<td class='meaning'>Bad number</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLBadColon XMLBadColon@endlink</td>
<td class='meaning'>Colon character not permitted</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingXMLElements MissingXMLElements@endlink</td>
<td class='meaning'>Missing XML elements</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#XMLContentEmpty XMLContentEmpty@endlink</td>
<td class='meaning'>Empty XML content</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnknownError UnknownError@endlink</td>
<td class='meaning'>Encountered unknown internal libSBML error</td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
<td class='s-fatal'></td>
</tr>
<tr><td class='code'>@link libsbml#NotUTF8 NotUTF8@endlink</td>
<td class='meaning'>File does not use UTF-8 encoding</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnrecognizedElement UnrecognizedElement@endlink</td>
<td class='meaning'>Encountered unrecognized element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NotSchemaConformant NotSchemaConformant@endlink</td>
<td class='meaning'>Document does not conform to the SBML XML schema</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#L3NotSchemaConformant L3NotSchemaConformant@endlink</td>
<td class='meaning'>Document is not well-formed XML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidMathElement InvalidMathElement@endlink</td>
<td class='meaning'>Invalid MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedMathMLSymbol DisallowedMathMLSymbol@endlink</td>
<td class='meaning'>Disallowed MathML symbol found</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedMathMLEncodingUse DisallowedMathMLEncodingUse@endlink</td>
<td class='meaning'>Use of the MathML 'encoding' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedDefinitionURLUse DisallowedDefinitionURLUse@endlink</td>
<td class='meaning'>Use of the MathML 'definitionURL' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadCsymbolDefinitionURLValue BadCsymbolDefinitionURLValue@endlink</td>
<td class='meaning'>Invalid <code>&lt;csymbol&gt;</code> 'definitionURL' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedMathTypeAttributeUse DisallowedMathTypeAttributeUse@endlink</td>
<td class='meaning'>Use of the MathML 'type' attribute is not allowed on this element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedMathTypeAttributeValue DisallowedMathTypeAttributeValue@endlink</td>
<td class='meaning'>Disallowed MathML 'type' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LambdaOnlyAllowedInFunctionDef LambdaOnlyAllowedInFunctionDef@endlink</td>
<td class='meaning'>Use of <code>&lt;lambda&gt;</code> not permitted outside of FunctionDefinition objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BooleanOpsNeedBooleanArgs BooleanOpsNeedBooleanArgs@endlink</td>
<td class='meaning'>Non-Boolean argument given to Boolean operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NumericOpsNeedNumericArgs NumericOpsNeedNumericArgs@endlink</td>
<td class='meaning'>Non-numerical argument given to numerical operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ArgsToEqNeedSameType ArgsToEqNeedSameType@endlink</td>
<td class='meaning'>Arguments to <code>&lt;eq&gt;</code> and <code>&lt;neq&gt;</code> must have the same data types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#PiecewiseNeedsConsistentTypes PiecewiseNeedsConsistentTypes@endlink</td>
<td class='meaning'>Terms in a <code>&lt;piecewise&gt;</code> expression must have consistent data types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#PieceNeedsBoolean PieceNeedsBoolean@endlink</td>
<td class='meaning'>The second argument of a <code>&lt;piece&gt;</code> expression must yield a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ApplyCiMustBeUserFunction ApplyCiMustBeUserFunction@endlink</td>
<td class='meaning'>A <code>&lt;ci&gt;</code> element in this context must refer to a function definition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ApplyCiMustBeModelComponent ApplyCiMustBeModelComponent@endlink</td>
<td class='meaning'>A <code>&lt;ci&gt;</code> element in this context must refer to a model component</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#KineticLawParametersAreLocalOnly KineticLawParametersAreLocalOnly@endlink</td>
<td class='meaning'>Cannot use a KineticLaw local parameter outside of its local scope</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MathResultMustBeNumeric MathResultMustBeNumeric@endlink</td>
<td class='meaning'>A formula's result in this context must be a numerical value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OpsNeedCorrectNumberOfArgs OpsNeedCorrectNumberOfArgs@endlink</td>
<td class='meaning'>Incorrect number of arguments given to MathML operator</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidNoArgsPassedToFunctionDef InvalidNoArgsPassedToFunctionDef@endlink</td>
<td class='meaning'>Incorrect number of arguments given to function invocation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DisallowedMathUnitsUse DisallowedMathUnitsUse@endlink</td>
<td class='meaning'>Attribute 'units' is only permitted on <code>&lt;cn&gt;</code> elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidUnitsValue InvalidUnitsValue@endlink</td>
<td class='meaning'>Invalid value given for the 'units' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateComponentId DuplicateComponentId@endlink</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateUnitDefinitionId DuplicateUnitDefinitionId@endlink</td>
<td class='meaning'>Duplicate unit definition 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateLocalParameterId DuplicateLocalParameterId@endlink</td>
<td class='meaning'>Duplicate local parameter 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MultipleAssignmentOrRateRules MultipleAssignmentOrRateRules@endlink</td>
<td class='meaning'>Multiple rules for the same variable are not allowed</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MultipleEventAssignmentsForId MultipleEventAssignmentsForId@endlink</td>
<td class='meaning'>Multiple event assignments for the same variable are not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAndAssignmentRuleForId EventAndAssignmentRuleForId@endlink</td>
<td class='meaning'>An event assignment and an assignment rule must not have the same value for 'variable'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateMetaId DuplicateMetaId@endlink</td>
<td class='meaning'>Duplicate 'metaid' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSBOTermSyntax InvalidSBOTermSyntax@endlink</td>
<td class='meaning'>Invalid syntax for an 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidMetaidSyntax InvalidMetaidSyntax@endlink</td>
<td class='meaning'>Invalid syntax for a 'metaid' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidIdSyntax InvalidIdSyntax@endlink</td>
<td class='meaning'>Invalid syntax for an 'id' attribute value</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidUnitIdSyntax InvalidUnitIdSyntax@endlink</td>
<td class='meaning'>Invalid syntax for the identifier of a unit</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidNameSyntax InvalidNameSyntax@endlink</td>
<td class='meaning'>Invalid syntax for a 'name' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingAnnotationNamespace MissingAnnotationNamespace@endlink</td>
<td class='meaning'>Missing declaration of the XML namespace for the annotation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateAnnotationNamespaces DuplicateAnnotationNamespaces@endlink</td>
<td class='meaning'>Multiple annotations using the same XML namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#SBMLNamespaceInAnnotation SBMLNamespaceInAnnotation@endlink</td>
<td class='meaning'>The SBML XML namespace cannot be used in an Annotation object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#MultipleAnnotations MultipleAnnotations@endlink</td>
<td class='meaning'>Only one Annotation object is permitted under a given SBML object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InconsistentArgUnits InconsistentArgUnits@endlink</td>
<td class='meaning'>The units of the function call's arguments are not consistent with its definition</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InconsistentKineticLawUnitsL3 InconsistentKineticLawUnitsL3@endlink</td>
<td class='meaning'>The kinetic law's units are inconsistent with those of other kinetic laws in the model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AssignRuleCompartmentMismatch AssignRuleCompartmentMismatch@endlink</td>
<td class='meaning'>Mismatched units in assignment rule for compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AssignRuleSpeciesMismatch AssignRuleSpeciesMismatch@endlink</td>
<td class='meaning'>Mismatched units in assignment rule for species</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AssignRuleParameterMismatch AssignRuleParameterMismatch@endlink</td>
<td class='meaning'>Mismatched units in assignment rule for parameter</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AssignRuleStoichiometryMismatch AssignRuleStoichiometryMismatch@endlink</td>
<td class='meaning'>Mismatched units in assignment rule for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InitAssignCompartmenMismatch InitAssignCompartmenMismatch@endlink</td>
<td class='meaning'>Mismatched units in initial assignment to compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InitAssignSpeciesMismatch InitAssignSpeciesMismatch@endlink</td>
<td class='meaning'>Mismatched units in initial assignment to species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InitAssignParameterMismatch InitAssignParameterMismatch@endlink</td>
<td class='meaning'>Mismatched units in initial assignment to parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InitAssignStoichiometryMismatch InitAssignStoichiometryMismatch@endlink</td>
<td class='meaning'>Mismatched units in initial assignment to stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RateRuleCompartmentMismatch RateRuleCompartmentMismatch@endlink</td>
<td class='meaning'>Mismatched units in rate rule for compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RateRuleSpeciesMismatch RateRuleSpeciesMismatch@endlink</td>
<td class='meaning'>Mismatched units in rate rule for species</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RateRuleParameterMismatch RateRuleParameterMismatch@endlink</td>
<td class='meaning'>Mismatched units in rate rule for parameter</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RateRuleStoichiometryMismatch RateRuleStoichiometryMismatch@endlink</td>
<td class='meaning'>Mismatched units in rate rule for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#KineticLawNotSubstancePerTime KineticLawNotSubstancePerTime@endlink</td>
<td class='meaning'>The units of the kinetic law are not 'substance'/'time'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#SpeciesInvalidExtentUnits SpeciesInvalidExtentUnits@endlink</td>
<td class='meaning'>The species' units are not consistent with units of extent</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#DelayUnitsNotTime DelayUnitsNotTime@endlink</td>
<td class='meaning'>The units of the delay expression are not units of time</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAssignCompartmentMismatch EventAssignCompartmentMismatch@endlink</td>
<td class='meaning'>Mismatched units in event assignment for compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAssignSpeciesMismatch EventAssignSpeciesMismatch@endlink</td>
<td class='meaning'>Mismatched units in event assignment for species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAssignParameterMismatch EventAssignParameterMismatch@endlink</td>
<td class='meaning'>Mismatched units in event assignment for parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAssignStoichiometryMismatch EventAssignStoichiometryMismatch@endlink</td>
<td class='meaning'>Mismatched units in event assignment for stoichiometry</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#PriorityUnitsNotDimensionless PriorityUnitsNotDimensionless@endlink</td>
<td class='meaning'>The units of a priority expression must be 'dimensionless'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#OverdeterminedSystem OverdeterminedSystem@endlink</td>
<td class='meaning'>The model is overdetermined</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidModelSBOTerm InvalidModelSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Model object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidFunctionDefSBOTerm InvalidFunctionDefSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a FunctionDefinition object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidParameterSBOTerm InvalidParameterSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Parameter object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidInitAssignSBOTerm InvalidInitAssignSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an InitialAssignment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidRuleSBOTerm InvalidRuleSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Rule object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidConstraintSBOTerm InvalidConstraintSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Constraint object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidReactionSBOTerm InvalidReactionSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Reaction object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesReferenceSBOTerm InvalidSpeciesReferenceSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a SpeciesReference object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidKineticLawSBOTerm InvalidKineticLawSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a KineticLaw object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidEventSBOTerm InvalidEventSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an Event object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidEventAssignmentSBOTerm InvalidEventAssignmentSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an EventAssignment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidCompartmentSBOTerm InvalidCompartmentSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Compartment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesSBOTerm InvalidSpeciesSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a Species object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidCompartmentTypeSBOTerm InvalidCompartmentTypeSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a CompartmentType object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesTypeSBOTerm InvalidSpeciesTypeSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for a SpeciesType object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidTriggerSBOTerm InvalidTriggerSBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an Event Trigger object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidDelaySBOTerm InvalidDelaySBOTerm@endlink</td>
<td class='meaning'>Invalid 'sboTerm' attribute value for an Event Delay object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NotesNotInXHTMLNamespace NotesNotInXHTMLNamespace@endlink</td>
<td class='meaning'>Notes must be placed in the XHTML XML namespace</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NotesContainsXMLDecl NotesContainsXMLDecl@endlink</td>
<td class='meaning'>XML declarations are not permitted in Notes objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NotesContainsDOCTYPE NotesContainsDOCTYPE@endlink</td>
<td class='meaning'>XML DOCTYPE elements are not permitted in Notes objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidNotesContent InvalidNotesContent@endlink</td>
<td class='meaning'>Invalid notes content found</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyOneNotesElementAllowed OnlyOneNotesElementAllowed@endlink</td>
<td class='meaning'>Only one Notes subobject is permitted on a given SBML object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidNamespaceOnSBML InvalidNamespaceOnSBML@endlink</td>
<td class='meaning'>Invalid XML namespace for the SBML container element</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingOrInconsistentLevel MissingOrInconsistentLevel@endlink</td>
<td class='meaning'>Missing or inconsistent value for the 'level' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingOrInconsistentVersion MissingOrInconsistentVersion@endlink</td>
<td class='meaning'>Missing or inconsistent value for the 'version' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#PackageNSMustMatch PackageNSMustMatch@endlink</td>
<td class='meaning'>Inconsistent or invalid SBML Level/Version for the package namespace declaration</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LevelPositiveInteger LevelPositiveInteger@endlink</td>
<td class='meaning'>The 'level' attribute must have a positive integer value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#VersionPositiveInteger VersionPositiveInteger@endlink</td>
<td class='meaning'>The 'version' attribute must have a positive integer value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnSBML AllowedAttributesOnSBML@endlink</td>
<td class='meaning'>Invalid attribute found on the SBML container element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#L3PackageOnLowerSBML L3PackageOnLowerSBML@endlink</td>
<td class='meaning'>An L3 package ns found on the SBML container element</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingModel MissingModel@endlink</td>
<td class='meaning'>No model definition found</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectOrderInModel IncorrectOrderInModel@endlink</td>
<td class='meaning'>Incorrect ordering of components within the Model object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EmptyListElement EmptyListElement@endlink</td>
<td class='meaning'>Empty ListOf___ object found</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NeedCompartmentIfHaveSpecies NeedCompartmentIfHaveSpecies@endlink</td>
<td class='meaning'>The presence of a species requires a compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneOfEachListOf OneOfEachListOf@endlink</td>
<td class='meaning'>Only one of each kind of ListOf___ object is allowed inside a Model object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyFuncDefsInListOfFuncDefs OnlyFuncDefsInListOfFuncDefs@endlink</td>
<td class='meaning'>Only FunctionDefinition, Notes and Annotation objects are allowed in ListOfFunctionDefinitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyUnitDefsInListOfUnitDefs OnlyUnitDefsInListOfUnitDefs@endlink</td>
<td class='meaning'>Only UnitDefinition, Notes and Annotation objects are allowed in ListOfUnitDefinitions objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyCompartmentsInListOfCompartments OnlyCompartmentsInListOfCompartments@endlink</td>
<td class='meaning'>Only Compartment, Notes and Annotation objects are allowed in ListOfCompartments objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlySpeciesInListOfSpecies OnlySpeciesInListOfSpecies@endlink</td>
<td class='meaning'>Only Species, Notes and Annotation objects are allowed in ListOfSpecies objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyParametersInListOfParameters OnlyParametersInListOfParameters@endlink</td>
<td class='meaning'>Only Parameter, Notes and Annotation objects are allowed in ListOfParameters objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyInitAssignsInListOfInitAssigns OnlyInitAssignsInListOfInitAssigns@endlink</td>
<td class='meaning'>Only InitialAssignment, Notes and Annotation objects are allowed in ListOfInitialAssignments objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyRulesInListOfRules OnlyRulesInListOfRules@endlink</td>
<td class='meaning'>Only Rule, Notes and Annotation objects are allowed in ListOfRules objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyConstraintsInListOfConstraints OnlyConstraintsInListOfConstraints@endlink</td>
<td class='meaning'>Only Constraint, Notes and Annotation objects are allowed in ListOfConstraints objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyReactionsInListOfReactions OnlyReactionsInListOfReactions@endlink</td>
<td class='meaning'>Only Reaction, Notes and Annotation objects are allowed in ListOfReactions objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyEventsInListOfEvents OnlyEventsInListOfEvents@endlink</td>
<td class='meaning'>Only Event, Notes and Annotation objects are allowed in ListOfEvents objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#L3ConversionFactorOnModel L3ConversionFactorOnModel@endlink</td>
<td class='meaning'>A 'conversionFactor' attribute value must reference a Parameter object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#L3TimeUnitsOnModel L3TimeUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'timeUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#L3VolumeUnitsOnModel L3VolumeUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'volumeUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#L3AreaUnitsOnModel L3AreaUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'areaUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#L3LengthUnitsOnModel L3LengthUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'lengthUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#L3ExtentUnitsOnModel L3ExtentUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'extentUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnModel AllowedAttributesOnModel@endlink</td>
<td class='meaning'>Invalid attribute found on the Model object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfFuncs AllowedAttributesOnListOfFuncs@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfFunctionDefinitions object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfUnitDefs AllowedAttributesOnListOfUnitDefs@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfUnitDefinitions object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfComps AllowedAttributesOnListOfComps@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfCompartments object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfSpecies AllowedAttributesOnListOfSpecies@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfSpecies object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfParams AllowedAttributesOnListOfParams@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfParameters object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfInitAssign AllowedAttributesOnListOfInitAssign@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfInitialAssignments object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfRules AllowedAttributesOnListOfRules@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfRules object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfConstraints AllowedAttributesOnListOfConstraints@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfConstraints object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfReactions AllowedAttributesOnListOfReactions@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfReactions object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfEvents AllowedAttributesOnListOfEvents@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfEvents object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FunctionDefMathNotLambda FunctionDefMathNotLambda@endlink</td>
<td class='meaning'>Invalid expression found in the function definition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidApplyCiInLambda InvalidApplyCiInLambda@endlink</td>
<td class='meaning'>Invalid forward reference in the MathML <code>&lt;apply&gt;</code><code>&lt;ci&gt;</code>...<code>&lt;/ci&gt;</code><code>&lt;/apply&gt;</code> expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#RecursiveFunctionDefinition RecursiveFunctionDefinition@endlink</td>
<td class='meaning'>Recursive function definitions are not permitted</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidCiInLambda InvalidCiInLambda@endlink</td>
<td class='meaning'>Invalid <code>&lt;ci&gt;</code> reference found inside the <code>&lt;lambda&gt;</code> mathematical formula</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidFunctionDefReturnType InvalidFunctionDefReturnType@endlink</td>
<td class='meaning'>A function's return type must be either a number or a Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathElementPerFunc OneMathElementPerFunc@endlink</td>
<td class='meaning'>A FunctionDefinition object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnFunc AllowedAttributesOnFunc@endlink</td>
<td class='meaning'>Invalid attribute found on the FunctionDefinition object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidUnitDefId InvalidUnitDefId@endlink</td>
<td class='meaning'>Invalid 'id' attribute value for a UnitDefinition object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSubstanceRedefinition InvalidSubstanceRedefinition@endlink</td>
<td class='meaning'>Invalid redefinition of built-in type 'substance'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidLengthRedefinition InvalidLengthRedefinition@endlink</td>
<td class='meaning'>Invalid redefinition of built-in type 'length'</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidAreaRedefinition InvalidAreaRedefinition@endlink</td>
<td class='meaning'>Invalid redefinition of built-in type name 'area'</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidTimeRedefinition InvalidTimeRedefinition@endlink</td>
<td class='meaning'>Invalid redefinition of built-in type name 'time'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidVolumeRedefinition InvalidVolumeRedefinition@endlink</td>
<td class='meaning'>Invalid redefinition of built-in type name 'volume'</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#VolumeLitreDefExponentNotOne VolumeLitreDefExponentNotOne@endlink</td>
<td class='meaning'>Must use 'exponent'=1 when defining 'volume' in terms of litres</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#VolumeMetreDefExponentNot3 VolumeMetreDefExponentNot3@endlink</td>
<td class='meaning'>Must use 'exponent'=3 when defining 'volume' in terms of metres</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EmptyListOfUnits EmptyListOfUnits@endlink</td>
<td class='meaning'>An empty list of Unit objects is not permitted in a UnitDefinition object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidUnitKind InvalidUnitKind@endlink</td>
<td class='meaning'>Invalid value for the 'kind' attribute of a UnitDefinition object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OffsetNoLongerValid OffsetNoLongerValid@endlink</td>
<td class='meaning'>Unit attribute 'offset' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CelsiusNoLongerValid CelsiusNoLongerValid@endlink</td>
<td class='meaning'>Unit name 'Celsius' is not defined in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EmptyUnitListElement EmptyUnitListElement@endlink</td>
<td class='meaning'>A ListOfUnits object must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneListOfUnitsPerUnitDef OneListOfUnitsPerUnitDef@endlink</td>
<td class='meaning'>At most one ListOfUnits object is allowed inside a UnitDefinition object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyUnitsInListOfUnits OnlyUnitsInListOfUnits@endlink</td>
<td class='meaning'>Only Unit, Notes and Annotation objects are allowed in ListOfUnits objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnUnitDefinition AllowedAttributesOnUnitDefinition@endlink</td>
<td class='meaning'>Invalid attribute found on the UnitDefinition object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfUnits AllowedAttributesOnListOfUnits@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfUnits object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnUnit AllowedAttributesOnUnit@endlink</td>
<td class='meaning'>Invalid attribute found on the Unit object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ZeroDimensionalCompartmentSize ZeroDimensionalCompartmentSize@endlink</td>
<td class='meaning'>Invalid use of the 'size' attribute for a zero-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ZeroDimensionalCompartmentUnits ZeroDimensionalCompartmentUnits@endlink</td>
<td class='meaning'>Invalid use of the 'units' attribute for a zero-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ZeroDimensionalCompartmentConst ZeroDimensionalCompartmentConst@endlink</td>
<td class='meaning'>Zero-dimensional compartments must be defined to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#UndefinedOutsideCompartment UndefinedOutsideCompartment@endlink</td>
<td class='meaning'>Invalid value for the 'outside' attribute of a Compartment object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#RecursiveCompartmentContainment RecursiveCompartmentContainment@endlink</td>
<td class='meaning'>Recursive nesting of compartments via the 'outside' attribute is not permitted</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ZeroDCompartmentContainment ZeroDCompartmentContainment@endlink</td>
<td class='meaning'>Invalid nesting of zero-dimensional compartments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#Invalid1DCompartmentUnits Invalid1DCompartmentUnits@endlink</td>
<td class='meaning'>Invalid value for the 'units' attribute of a one-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#Invalid2DCompartmentUnits Invalid2DCompartmentUnits@endlink</td>
<td class='meaning'>Invalid value for the 'units' attribute of a two-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#Invalid3DCompartmentUnits Invalid3DCompartmentUnits@endlink</td>
<td class='meaning'>Invalid value for the 'units' attribute of a three-dimensional compartment</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidCompartmentTypeRef InvalidCompartmentTypeRef@endlink</td>
<td class='meaning'>Invalid value for the 'compartmentType' attribute of a compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OneDimensionalCompartmentUnits OneDimensionalCompartmentUnits@endlink</td>
<td class='meaning'>No units defined for 1-D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#TwoDimensionalCompartmentUnits TwoDimensionalCompartmentUnits@endlink</td>
<td class='meaning'>No units defined for 2-D compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ThreeDimensionalCompartmentUnits ThreeDimensionalCompartmentUnits@endlink</td>
<td class='meaning'>No units defined for 3-D Compartment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnCompartment AllowedAttributesOnCompartment@endlink</td>
<td class='meaning'>Invalid attribute found on Compartment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitsOnCompartment NoUnitsOnCompartment@endlink</td>
<td class='meaning'>No units defined for Compartment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesCompartmentRef InvalidSpeciesCompartmentRef@endlink</td>
<td class='meaning'>Invalid value found for Species 'compartment' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#HasOnlySubsNoSpatialUnits HasOnlySubsNoSpatialUnits@endlink</td>
<td class='meaning'>Attribute 'spatialSizeUnits' must not be set if 'hasOnlySubstanceUnits'='true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpatialUnitsInZeroD NoSpatialUnitsInZeroD@endlink</td>
<td class='meaning'>Attribute 'spatialSizeUnits' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoConcentrationInZeroD NoConcentrationInZeroD@endlink</td>
<td class='meaning'>Attribute 'initialConcentration' must not be set if the compartment is zero-dimensional</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpatialUnitsInOneD SpatialUnitsInOneD@endlink</td>
<td class='meaning'>Invalid value for 'spatialSizeUnits' attribute of a one-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpatialUnitsInTwoD SpatialUnitsInTwoD@endlink</td>
<td class='meaning'>Invalid value for the 'spatialSizeUnits' attribute of a two-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpatialUnitsInThreeD SpatialUnitsInThreeD@endlink</td>
<td class='meaning'>Invalid value for the 'spatialSizeUnits' attribute of a three-dimensional compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesSusbstanceUnits InvalidSpeciesSusbstanceUnits@endlink</td>
<td class='meaning'>Invalid value for a Species 'units' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#BothAmountAndConcentrationSet BothAmountAndConcentrationSet@endlink</td>
<td class='meaning'>Cannot set both 'initialConcentration' and 'initialAmount' attributes simultaneously</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NonBoundarySpeciesAssignedAndUsed NonBoundarySpeciesAssignedAndUsed@endlink</td>
<td class='meaning'>Cannot use a non-boundary species in both reactions and rules simultaneously</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NonConstantSpeciesUsed NonConstantSpeciesUsed@endlink</td>
<td class='meaning'>Cannot use a constant, non-boundary species as a reactant or product</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesTypeRef InvalidSpeciesTypeRef@endlink</td>
<td class='meaning'>Invalid value for the 'speciesType' attribute of a species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#MultSpeciesSameTypeInCompartment MultSpeciesSameTypeInCompartment@endlink</td>
<td class='meaning'>Cannot have multiple species of the same species type in the same compartment</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingSpeciesCompartment MissingSpeciesCompartment@endlink</td>
<td class='meaning'>Missing value for the 'compartment' attribute</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#SpatialSizeUnitsRemoved SpatialSizeUnitsRemoved@endlink</td>
<td class='meaning'>Attribute 'spatialSizeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SubstanceUnitsOnSpecies SubstanceUnitsOnSpecies@endlink</td>
<td class='meaning'>No substance units defined for the species</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ConversionFactorOnSpecies ConversionFactorOnSpecies@endlink</td>
<td class='meaning'>Invalid value for the 'conversionFactor' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnSpecies AllowedAttributesOnSpecies@endlink</td>
<td class='meaning'>Invalid attribute found on Species object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidParameterUnits InvalidParameterUnits@endlink</td>
<td class='meaning'>Invalid value for the 'units' attribute of a Parameter object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ParameterUnits ParameterUnits@endlink</td>
<td class='meaning'>No units defined for the parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ConversionFactorMustConstant ConversionFactorMustConstant@endlink</td>
<td class='meaning'>A conversion factor must reference a Parameter object declared to be a constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnParameter AllowedAttributesOnParameter@endlink</td>
<td class='meaning'>Invalid attribute found on Parameter object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidInitAssignSymbol InvalidInitAssignSymbol@endlink</td>
<td class='meaning'>Invalid value for the 'symbol' attribute of an InitialAssignment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MultipleInitAssignments MultipleInitAssignments@endlink</td>
<td class='meaning'>Multiple initial assignments for the same 'symbol' value are not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InitAssignmentAndRuleForSameId InitAssignmentAndRuleForSameId@endlink</td>
<td class='meaning'>Cannot set a value using both an initial assignment and an assignment rule simultaneously</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathElementPerInitialAssign OneMathElementPerInitialAssign@endlink</td>
<td class='meaning'>An InitialAssignment object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnInitialAssign AllowedAttributesOnInitialAssign@endlink</td>
<td class='meaning'>Invalid attribute found on an InitialAssignment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidAssignRuleVariable InvalidAssignRuleVariable@endlink</td>
<td class='meaning'>Invalid value for the 'variable' attribute of an AssignmentRule object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidRateRuleVariable InvalidRateRuleVariable@endlink</td>
<td class='meaning'>Invalid value for the 'variable' attribute of a RateRule object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AssignmentToConstantEntity AssignmentToConstantEntity@endlink</td>
<td class='meaning'>An assignment rule cannot assign an entity declared to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#RateRuleForConstantEntity RateRuleForConstantEntity@endlink</td>
<td class='meaning'>A rate rule cannot assign an entity declared to be constant</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CircularRuleDependency CircularRuleDependency@endlink</td>
<td class='meaning'>Circular dependencies involving rules and reactions are not permitted</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathElementPerRule OneMathElementPerRule@endlink</td>
<td class='meaning'>A rule object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnAssignRule AllowedAttributesOnAssignRule@endlink</td>
<td class='meaning'>Invalid attribute found on an AssignmentRule object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnRateRule AllowedAttributesOnRateRule@endlink</td>
<td class='meaning'>Invalid attribute found on a RateRule object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnAlgRule AllowedAttributesOnAlgRule@endlink</td>
<td class='meaning'>Invalid attribute found on an AlgebraicRule object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstraintMathNotBoolean ConstraintMathNotBoolean@endlink</td>
<td class='meaning'>A Constraint object's <code>&lt;math&gt;</code> must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectOrderInConstraint IncorrectOrderInConstraint@endlink</td>
<td class='meaning'>Subobjects inside the Constraint object are not in the prescribed order</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstraintNotInXHTMLNamespace ConstraintNotInXHTMLNamespace@endlink</td>
<td class='meaning'>A Constraint's Message subobject must be in the XHTML XML namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstraintContainsXMLDecl ConstraintContainsXMLDecl@endlink</td>
<td class='meaning'>XML declarations are not permitted within Constraint's Message objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstraintContainsDOCTYPE ConstraintContainsDOCTYPE@endlink</td>
<td class='meaning'>XML DOCTYPE elements are not permitted within Constraint's Message objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidConstraintContent InvalidConstraintContent@endlink</td>
<td class='meaning'>Invalid content for a Constraint object's Message object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathElementPerConstraint OneMathElementPerConstraint@endlink</td>
<td class='meaning'>A Constraint object must contain one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMessageElementPerConstraint OneMessageElementPerConstraint@endlink</td>
<td class='meaning'>A Constraint object must contain one Message subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnConstraint AllowedAttributesOnConstraint@endlink</td>
<td class='meaning'>Invalid attribute found on Constraint object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoReactantsOrProducts NoReactantsOrProducts@endlink</td>
<td class='meaning'>Cannot have a reaction with neither reactants nor products</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectOrderInReaction IncorrectOrderInReaction@endlink</td>
<td class='meaning'>Subobjects inside the Reaction object are not in the prescribed order</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EmptyListInReaction EmptyListInReaction@endlink</td>
<td class='meaning'>Reaction components, if present, cannot be empty</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidReactantsProductsList InvalidReactantsProductsList@endlink</td>
<td class='meaning'>Invalid object found in the list of reactants or products</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidModifiersList InvalidModifiersList@endlink</td>
<td class='meaning'>Invalid object found in the list of modifiers</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneSubElementPerReaction OneSubElementPerReaction@endlink</td>
<td class='meaning'>A Reaction object can only contain one of each allowed type of object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompartmentOnReaction CompartmentOnReaction@endlink</td>
<td class='meaning'>Invalid value for the Reaction 'compartment' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnReaction AllowedAttributesOnReaction@endlink</td>
<td class='meaning'>Invalid attribute for a Reaction object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSpeciesReference InvalidSpeciesReference@endlink</td>
<td class='meaning'>Invalid 'species' attribute value in SpeciesReference object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BothStoichiometryAndMath BothStoichiometryAndMath@endlink</td>
<td class='meaning'>The 'stoichiometry' attribute and StoichiometryMath subobject are mutually exclusive</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnSpeciesReference AllowedAttributesOnSpeciesReference@endlink</td>
<td class='meaning'>Invalid attribute found on the SpeciesReference object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnModifier AllowedAttributesOnModifier@endlink</td>
<td class='meaning'>Invalid attribute found on the ModifierSpeciesReference object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredSpeciesRef UndeclaredSpeciesRef@endlink</td>
<td class='meaning'>Unknown species referenced in the kinetic law <code>&lt;math&gt;</code> formula</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectOrderInKineticLaw IncorrectOrderInKineticLaw@endlink</td>
<td class='meaning'>Incorrect ordering of components in the KineticLaw object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EmptyListInKineticLaw EmptyListInKineticLaw@endlink</td>
<td class='meaning'>The list of parameters, if present, cannot be empty</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NonConstantLocalParameter NonConstantLocalParameter@endlink</td>
<td class='meaning'>Parameters local to a KineticLaw object must have a 'constant' attribute value of 'true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SubsUnitsNoLongerValid SubsUnitsNoLongerValid@endlink</td>
<td class='meaning'>Attribute 'substanceUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#TimeUnitsNoLongerValid TimeUnitsNoLongerValid@endlink</td>
<td class='meaning'>Attribute 'timeUnits' is not supported in this Level+Version of SBML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OneListOfPerKineticLaw OneListOfPerKineticLaw@endlink</td>
<td class='meaning'>Only one ListOfLocalParameters object is permitted within a KineticLaw object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyLocalParamsInListOfLocalParams OnlyLocalParamsInListOfLocalParams@endlink</td>
<td class='meaning'>Only LocalParameter, Notes and Annotation objects are allowed in ListOfLocalParameter objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfLocalParam AllowedAttributesOnListOfLocalParam@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfLocalParameters object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathPerKineticLaw OneMathPerKineticLaw@endlink</td>
<td class='meaning'>Only one <code>&lt;math&gt;</code> element is allowed in a KineticLaw object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredSpeciesInStoichMath UndeclaredSpeciesInStoichMath@endlink</td>
<td class='meaning'>Unknown species referenced in the StoichiometryMath object's <code>&lt;math&gt;</code> formula</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnKineticLaw AllowedAttributesOnKineticLaw@endlink</td>
<td class='meaning'>Invalid attribute found on the KineticLaw object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfSpeciesRef AllowedAttributesOnListOfSpeciesRef@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfSpeciesReferences object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfMods AllowedAttributesOnListOfMods@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfModifiers object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnLocalParameter AllowedAttributesOnLocalParameter@endlink</td>
<td class='meaning'>Invalid attribute found on the LocalParameter object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingTriggerInEvent MissingTriggerInEvent@endlink</td>
<td class='meaning'>The Event object is missing a Trigger subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#TriggerMathNotBoolean TriggerMathNotBoolean@endlink</td>
<td class='meaning'>A Trigger object's <code>&lt;math&gt;</code> expression must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MissingEventAssignment MissingEventAssignment@endlink</td>
<td class='meaning'>The Event object is missing an EventAssignment subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#TimeUnitsEvent TimeUnitsEvent@endlink</td>
<td class='meaning'>Units referenced by 'timeUnits' attribute are not compatible with units of time</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectOrderInEvent IncorrectOrderInEvent@endlink</td>
<td class='meaning'>Incorrect ordering of components in Event object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ValuesFromTriggerTimeNeedDelay ValuesFromTriggerTimeNeedDelay@endlink</td>
<td class='meaning'>Attribute 'useValuesFromTriggerTime'='false', but the Event object does not define a delay</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#DelayNeedsValuesFromTriggerTime DelayNeedsValuesFromTriggerTime@endlink</td>
<td class='meaning'>The use of a Delay object requires the Event attribute 'useValuesFromTriggerTime'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathPerTrigger OneMathPerTrigger@endlink</td>
<td class='meaning'>A Trigger object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathPerDelay OneMathPerDelay@endlink</td>
<td class='meaning'>A Delay object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidEventAssignmentVariable InvalidEventAssignmentVariable@endlink</td>
<td class='meaning'>Invalid 'variable' attribute value in Event object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#EventAssignmentForConstantEntity EventAssignmentForConstantEntity@endlink</td>
<td class='meaning'>An EventAssignment object cannot assign to a component having attribute 'constant'='true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathPerEventAssignment OneMathPerEventAssignment@endlink</td>
<td class='meaning'>An EventAssignment object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnEventAssignment AllowedAttributesOnEventAssignment@endlink</td>
<td class='meaning'>Invalid attribute found on the EventAssignment object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyOneDelayPerEvent OnlyOneDelayPerEvent@endlink</td>
<td class='meaning'>An Event object can only have one Delay subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneListOfEventAssignmentsPerEvent OneListOfEventAssignmentsPerEvent@endlink</td>
<td class='meaning'>An Event object can only have one ListOfEventAssignments subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyEventAssignInListOfEventAssign OnlyEventAssignInListOfEventAssign@endlink</td>
<td class='meaning'>Only EventAssignment, Notes and Annotation objects are allowed in ListOfEventAssignments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnListOfEventAssign AllowedAttributesOnListOfEventAssign@endlink</td>
<td class='meaning'>Invalid attribute found on the ListOfEventAssignments object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnEvent AllowedAttributesOnEvent@endlink</td>
<td class='meaning'>Invalid attribute found on the Event object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnTrigger AllowedAttributesOnTrigger@endlink</td>
<td class='meaning'>Invalid attribute found on the Trigger object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnDelay AllowedAttributesOnDelay@endlink</td>
<td class='meaning'>Invalid attribute found on the Delay object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#PersistentNotBoolean PersistentNotBoolean@endlink</td>
<td class='meaning'>The Trigger attribute 'persistent' must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InitialValueNotBoolean InitialValueNotBoolean@endlink</td>
<td class='meaning'>The Trigger attribute 'initialValue' must evaluate to a Boolean value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OnlyOnePriorityPerEvent OnlyOnePriorityPerEvent@endlink</td>
<td class='meaning'>An Event object can only have one Priority subobject</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#OneMathPerPriority OneMathPerPriority@endlink</td>
<td class='meaning'>A Priority object must have one <code>&lt;math&gt;</code> element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AllowedAttributesOnPriority AllowedAttributesOnPriority@endlink</td>
<td class='meaning'>Invalid attribute found on the Priority object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompartmentShouldHaveSize CompartmentShouldHaveSize@endlink</td>
<td class='meaning'>It's best to define a size for every compartment in a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#SpeciesShouldHaveValue SpeciesShouldHaveValue@endlink</td>
<td class='meaning'>It's best to define an initial amount or initial concentration for every species in a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ParameterShouldHaveUnits ParameterShouldHaveUnits@endlink</td>
<td class='meaning'>It's best to declare units for every parameter in a model</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#LocalParameterShadowsId LocalParameterShadowsId@endlink</td>
<td class='meaning'>Local parameters defined within a kinetic law shadow global object symbols</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CannotConvertToL1V1 CannotConvertToL1V1@endlink</td>
<td class='meaning'>Cannot convert to SBML Level 1 Version 1</td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoEventsInL1 NoEventsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support events</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoFunctionDefinitionsInL1 NoFunctionDefinitionsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support function definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoConstraintsInL1 NoConstraintsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support constraints</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoInitialAssignmentsInL1 NoInitialAssignmentsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support initial assignments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesTypesInL1 NoSpeciesTypesInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support species types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoCompartmentTypeInL1 NoCompartmentTypeInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support compartment types</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoNon3DCompartmentsInL1 NoNon3DCompartmentsInL1@endlink</td>
<td class='meaning'>SBML Level 1 only supports three-dimensional compartments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoFancyStoichiometryMathInL1 NoFancyStoichiometryMathInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support non-integer nor non-rational stoichiometry formulas</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoNonIntegerStoichiometryInL1 NoNonIntegerStoichiometryInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support non-integer 'stoichiometry' attribute values</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitMultipliersOrOffsetsInL1 NoUnitMultipliersOrOffsetsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support multipliers or offsets in unit definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#SpeciesCompartmentRequiredInL1 SpeciesCompartmentRequiredInL1@endlink</td>
<td class='meaning'>In SBML Level 1, a value for 'compartment' is mandatory in species definitions</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesSpatialSizeUnitsInL1 NoSpeciesSpatialSizeUnitsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support species 'spatialSizeUnits' settings</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSBOTermsInL1 NoSBOTermsInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictUnitsRequiredInL1 StrictUnitsRequiredInL1@endlink</td>
<td class='meaning'>SBML Level 1 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ConversionFactorNotInL1 ConversionFactorNotInL1@endlink</td>
<td class='meaning'>SBML Level 1 does not support the 'conversionFactor' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompartmentNotOnL1Reaction CompartmentNotOnL1Reaction@endlink</td>
<td class='meaning'>SBML Level 1 does not support the 'compartment' attribute on Reaction objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ExtentUnitsNotSubstance ExtentUnitsNotSubstance@endlink</td>
<td class='meaning'>Units of extent must be compatible with units of substance</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#GlobalUnitsNotDeclared GlobalUnitsNotDeclared@endlink</td>
<td class='meaning'>Global units must be refer to unit kind or unitDefinition.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#HasOnlySubstanceUnitsNotinL1 HasOnlySubstanceUnitsNotinL1@endlink</td>
<td class='meaning'>The concept of hasOnlySubstanceUnits was not available in SBML Level 1.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AvogadroNotSupported AvogadroNotSupported@endlink</td>
<td class='meaning'>Avogadro not supported in Levels 2 and 1.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoConstraintsInL2v1 NoConstraintsInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support Constraint objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoInitialAssignmentsInL2v1 NoInitialAssignmentsInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support InitialAssignment objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesTypeInL2v1 NoSpeciesTypeInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support SpeciesType objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoCompartmentTypeInL2v1 NoCompartmentTypeInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support CompartmentType objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSBOTermsInL2v1 NoSBOTermsInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'sboTerm' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoIdOnSpeciesReferenceInL2v1 NoIdOnSpeciesReferenceInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'id' attribute on SpeciesReference objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoDelayedEventAssignmentInL2v1 NoDelayedEventAssignmentInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictUnitsRequiredInL2v1 StrictUnitsRequiredInL2v1@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#IntegerSpatialDimensions IntegerSpatialDimensions@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 requires that compartments have spatial dimensions of 0-3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#StoichiometryMathNotYetSupported StoichiometryMathNotYetSupported@endlink</td>
<td class='meaning'>Conversion to StoichiometryMath objects not yet supported</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#PriorityLostFromL3 PriorityLostFromL3@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support priorities on Event objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NonPersistentNotSupported NonPersistentNotSupported@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'persistent' attribute on Trigger objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InitialValueFalseEventNotSupported InitialValueFalseEventNotSupported@endlink</td>
<td class='meaning'>SBML Level 2 Version 1 does not support the 'initialValue' attribute on Trigger objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#SBOTermNotUniversalInL2v2 SBOTermNotUniversalInL2v2@endlink</td>
<td class='meaning'>The 'sboTerm' attribute is invalid for this component in SBML Level 2 Version 2</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitOffsetInL2v2 NoUnitOffsetInL2v2@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on Unit objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawTimeUnitsInL2v2 NoKineticLawTimeUnitsInL2v2@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawSubstanceUnitsInL2v2 NoKineticLawSubstanceUnitsInL2v2@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoDelayedEventAssignmentInL2v2 NoDelayedEventAssignmentInL2v2@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ModelSBOBranchChangedBeyondL2v2 ModelSBOBranchChangedBeyondL2v2@endlink</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for Model objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictUnitsRequiredInL2v2 StrictUnitsRequiredInL2v2@endlink</td>
<td class='meaning'>SBML Level 2 Version 2 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictSBORequiredInL2v2 StrictSBORequiredInL2v2@endlink</td>
<td class='meaning'>SBML Level 2 Version 2 requires strict SBO term consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateAnnotationInvalidInL2v2 DuplicateAnnotationInvalidInL2v2@endlink</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 2</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitOffsetInL2v3 NoUnitOffsetInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on Unit objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawTimeUnitsInL2v3 NoKineticLawTimeUnitsInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawSubstanceUnitsInL2v3 NoKineticLawSubstanceUnitsInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesSpatialSizeUnitsInL2v3 NoSpeciesSpatialSizeUnitsInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on Species objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoEventTimeUnitsInL2v3 NoEventTimeUnitsInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on Event objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoDelayedEventAssignmentInL2v3 NoDelayedEventAssignmentInL2v3@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ModelSBOBranchChangedBeyondL2v3 ModelSBOBranchChangedBeyondL2v3@endlink</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for Model objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictUnitsRequiredInL2v3 StrictUnitsRequiredInL2v3@endlink</td>
<td class='meaning'>SBML Level 2 Version 3 requires strict unit consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#StrictSBORequiredInL2v3 StrictSBORequiredInL2v3@endlink</td>
<td class='meaning'>SBML Level 2 Version 3 requires strict SBO term consistency</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateAnnotationInvalidInL2v3 DuplicateAnnotationInvalidInL2v3@endlink</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 3</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitOffsetInL2v4 NoUnitOffsetInL2v4@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on Unit objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawTimeUnitsInL2v4 NoKineticLawTimeUnitsInL2v4@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawSubstanceUnitsInL2v4 NoKineticLawSubstanceUnitsInL2v4@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesSpatialSizeUnitsInL2v4 NoSpeciesSpatialSizeUnitsInL2v4@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on Species objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoEventTimeUnitsInL2v4 NoEventTimeUnitsInL2v4@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on Event objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ModelSBOBranchChangedInL2v4 ModelSBOBranchChangedInL2v4@endlink</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for Model objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateAnnotationInvalidInL2v4 DuplicateAnnotationInvalidInL2v4@endlink</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 2 Version 4</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesTypeInL3v1 NoSpeciesTypeInL3v1@endlink</td>
<td class='meaning'>SBML Level 3 Version 1 does not support SpeciesType objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoCompartmentTypeInL3v1 NoCompartmentTypeInL3v1@endlink</td>
<td class='meaning'>SBML Level 3 Version 1 does not support CompartmentType objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoUnitOffsetInL3v1 NoUnitOffsetInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'offset' attribute on Unit objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawTimeUnitsInL3v1 NoKineticLawTimeUnitsInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoKineticLawSubstanceUnitsInL3v1 NoKineticLawSubstanceUnitsInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'substanceUnits' attribute on KineticLaw objects</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoSpeciesSpatialSizeUnitsInL3v1 NoSpeciesSpatialSizeUnitsInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on Species objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoEventTimeUnitsInL3v1 NoEventTimeUnitsInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on Event objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#ModelSBOBranchChangedInL3v1 ModelSBOBranchChangedInL3v1@endlink</td>
<td class='meaning'>The allowable 'sboTerm' attribute values for Model objects differ for this SBML Level+Version</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#DuplicateAnnotationInvalidInL3v1 DuplicateAnnotationInvalidInL3v1@endlink</td>
<td class='meaning'>Duplicate top-level annotations are invalid in SBML Level 3 Version 1</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoCompartmentOutsideInL3v1 NoCompartmentOutsideInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'outside' attribute on Compartment objects</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NoStoichiometryMathInL3v1 NoStoichiometryMathInL3v1@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the StoichiometryMath object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidSBMLLevelVersion InvalidSBMLLevelVersion@endlink</td>
<td class='meaning'>Unknown Level+Version combination of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#AnnotationNotesNotAllowedLevel1 AnnotationNotesNotAllowedLevel1@endlink</td>
<td class='meaning'>Annotation objects on the SBML container element are not permitted in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidRuleOrdering InvalidRuleOrdering@endlink</td>
<td class='meaning'>Invalid ordering of rules</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#RequiredPackagePresent RequiredPackagePresent@endlink</td>
<td class='meaning'>The SBML document requires an SBML Level 3 package unavailable in this software</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnrequiredPackagePresent UnrequiredPackagePresent@endlink</td>
<td class='meaning'>The SBML document uses an SBML Level 3 package unavailable in this software</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#PackageRequiredShouldBeFalse PackageRequiredShouldBeFalse@endlink</td>
<td class='meaning'>This package expects required to be false</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#SubsUnitsAllowedInKL SubsUnitsAllowedInKL@endlink</td>
<td class='meaning'>Disallowed value for attribute 'substanceUnits' on KineticLaw object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#TimeUnitsAllowedInKL TimeUnitsAllowedInKL@endlink</td>
<td class='meaning'>Disallowed value for attribute 'timeUnits' on KineticLaw object</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#FormulaInLevel1KL FormulaInLevel1KL@endlink</td>
<td class='meaning'>Only predefined functions are allowed in SBML Level 1 formulas</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#L3SubstanceUnitsOnModel L3SubstanceUnitsOnModel@endlink</td>
<td class='meaning'>Invalid 'substanceUnits' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#TimeUnitsRemoved TimeUnitsRemoved@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'timeUnits' attribute on Event objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadMathML BadMathML@endlink</td>
<td class='meaning'>Invalid MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FailedMathMLReadOfDouble FailedMathMLReadOfDouble@endlink</td>
<td class='meaning'>Missing or invalid floating-point number in MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FailedMathMLReadOfInteger FailedMathMLReadOfInteger@endlink</td>
<td class='meaning'>Missing or invalid integer in MathML expression</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FailedMathMLReadOfExponential FailedMathMLReadOfExponential@endlink</td>
<td class='meaning'>Missing or invalid exponential expression in MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FailedMathMLReadOfRational FailedMathMLReadOfRational@endlink</td>
<td class='meaning'>Missing or invalid rational expression in MathML</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#BadMathMLNodeType BadMathMLNodeType@endlink</td>
<td class='meaning'>Invalid MathML element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidMathMLAttribute InvalidMathMLAttribute@endlink</td>
<td class='meaning'>Invalid MathML attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoTimeSymbolInFunctionDef NoTimeSymbolInFunctionDef@endlink</td>
<td class='meaning'>Use of <code>&lt;csymbol&gt;</code> for 'time' not allowed within FunctionDefinition objects</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#NoBodyInFunctionDef NoBodyInFunctionDef@endlink</td>
<td class='meaning'>There must be a <code>&lt;lambda&gt;</code> body within the <code>&lt;math&gt;</code> element of a FunctionDefinition object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#DanglingUnitSIdRef DanglingUnitSIdRef@endlink</td>
<td class='meaning'>Units must refer to valid unit or unitDefinition</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RDFMissingAboutTag RDFMissingAboutTag@endlink</td>
<td class='meaning'>RDF missing the <code>&lt;about&gt;</code> tag</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RDFEmptyAboutTag RDFEmptyAboutTag@endlink</td>
<td class='meaning'>RDF empty <code>&lt;about&gt;</code> tag</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RDFAboutTagNotMetaid RDFAboutTagNotMetaid@endlink</td>
<td class='meaning'>RDF <code>&lt;about&gt;</code> tag is not metaid</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RDFNotCompleteModelHistory RDFNotCompleteModelHistory@endlink</td>
<td class='meaning'>RDF does not contain valid ModelHistory</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#RDFNotModelHistory RDFNotModelHistory@endlink</td>
<td class='meaning'>RDF does not result in a ModelHistory</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#AnnotationNotElement AnnotationNotElement@endlink</td>
<td class='meaning'>Annotation must contain element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredUnits UndeclaredUnits@endlink</td>
<td class='meaning'>Missing unit declarations on parameters or literal numbers in expression</td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredTimeUnitsL3 UndeclaredTimeUnitsL3@endlink</td>
<td class='meaning'>Unable to verify consistency of units: the unit of time has not been declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredExtentUnitsL3 UndeclaredExtentUnitsL3@endlink</td>
<td class='meaning'>Unable to verify consistency of units: the units of reaction extent have not been declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#UndeclaredObjectUnitsL3 UndeclaredObjectUnitsL3@endlink</td>
<td class='meaning'>Unable to verify consistency of units: encountered a model entity with no declared units</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#UnrecognisedSBOTerm UnrecognisedSBOTerm@endlink</td>
<td class='meaning'>Unrecognized 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#ObseleteSBOTerm ObseleteSBOTerm@endlink</td>
<td class='meaning'>Obsolete 'sboTerm' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#IncorrectCompartmentSpatialDimensions IncorrectCompartmentSpatialDimensions@endlink</td>
<td class='meaning'>In SBML Level 1, only three-dimensional compartments are allowed</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CompartmentTypeNotValidAttribute CompartmentTypeNotValidAttribute@endlink</td>
<td class='meaning'>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstantNotValidAttribute ConstantNotValidAttribute@endlink</td>
<td class='meaning'>This Level+Version of SBML does not support the 'constant' attribute on this component</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#MetaIdNotValidAttribute MetaIdNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'metaid' is not available in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SBOTermNotValidAttributeBeforeL2V3 SBOTermNotValidAttributeBeforeL2V3@endlink</td>
<td class='meaning'>The 'sboTerm' attribute is not available on this component before SBML Level 2 Version 3</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidL1CompartmentUnits InvalidL1CompartmentUnits@endlink</td>
<td class='meaning'>Invalid units for a compartment in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#L1V1CompartmentVolumeReqd L1V1CompartmentVolumeReqd@endlink</td>
<td class='meaning'>In SBML Level 1, a compartment's volume must be specified</td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CompartmentTypeNotValidComponent CompartmentTypeNotValidComponent@endlink</td>
<td class='meaning'>CompartmentType objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstraintNotValidComponent ConstraintNotValidComponent@endlink</td>
<td class='meaning'>Constraint objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#EventNotValidComponent EventNotValidComponent@endlink</td>
<td class='meaning'>Event objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SBOTermNotValidAttributeBeforeL2V2 SBOTermNotValidAttributeBeforeL2V2@endlink</td>
<td class='meaning'>The 'sboTerm' attribute is invalid for this component before Level 2 Version 2</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#FuncDefNotValidComponent FuncDefNotValidComponent@endlink</td>
<td class='meaning'>FunctionDefinition objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#InitialAssignNotValidComponent InitialAssignNotValidComponent@endlink</td>
<td class='meaning'>InitialAssignment objects are not available in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#VariableNotValidAttribute VariableNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'variable' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#UnitsNotValidAttribute UnitsNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'units' is not available on this component in this Level+Version of SBML</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#ConstantSpeciesNotValidAttribute ConstantSpeciesNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'constant' is not available on Species objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpatialSizeUnitsNotValidAttribute SpatialSizeUnitsNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'spatialSizeUnits' is not available on Species objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpeciesTypeNotValidAttribute SpeciesTypeNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'speciesType' is not available on Species objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#HasOnlySubsUnitsNotValidAttribute HasOnlySubsUnitsNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'hasOnlySubstanceUnits' is not available on Species objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#IdNotValidAttribute IdNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'id' is not available on SpeciesReference objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#NameNotValidAttribute NameNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'name' is not available on SpeciesReference objects in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#SpeciesTypeNotValidComponent SpeciesTypeNotValidComponent@endlink</td>
<td class='meaning'>The SpeciesType object is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#StoichiometryMathNotValidComponent StoichiometryMathNotValidComponent@endlink</td>
<td class='meaning'>The StoichiometryMath object is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#MultiplierNotValidAttribute MultiplierNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'multiplier' on Unit objects is not supported in SBML Level 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#OffsetNotValidAttribute OffsetNotValidAttribute@endlink</td>
<td class='meaning'>Attribute 'offset' on Unit objects is only available in SBML Level 2 Version 1</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#L3SpatialDimensionsUnset L3SpatialDimensionsUnset@endlink</td>
<td class='meaning'>No value given for 'spatialDimensions' attribute; assuming a value of 3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#PackageConversionNotSupported PackageConversionNotSupported@endlink</td>
<td class='meaning'>Conversion of SBML Level 3 package constructs is not yet supported</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#InvalidTargetLevelVersion InvalidTargetLevelVersion@endlink</td>
<td class='meaning'>The requested SBML Level/Version combination is not known to exist</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#L3NotSupported L3NotSupported@endlink</td>
<td class='meaning'>SBML Level 3 is not yet supported</td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompUnknown CompUnknown@endlink</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CompNSUndeclared CompNSUndeclared@endlink</td>
<td class='meaning'>The comp ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompElementNotInNs CompElementNotInNs@endlink</td>
<td class='meaning'>Element not in comp namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDuplicateComponentId CompDuplicateComponentId@endlink</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompUniqueModelIds CompUniqueModelIds@endlink</td>
<td class='meaning'>Model and ExternalModelDefinitions must have unique ids</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompUniquePortIds CompUniquePortIds@endlink</td>
<td class='meaning'>Ports must have unique ids</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidSIdSyntax CompInvalidSIdSyntax@endlink</td>
<td class='meaning'>Invalid SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidSubmodelRefSyntax CompInvalidSubmodelRefSyntax@endlink</td>
<td class='meaning'>Invalid submodelRef syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidDeletionSyntax CompInvalidDeletionSyntax@endlink</td>
<td class='meaning'>Invalid deletion syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidConversionFactorSyntax CompInvalidConversionFactorSyntax@endlink</td>
<td class='meaning'>Invalid conversionFactor syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidNameSyntax CompInvalidNameSyntax@endlink</td>
<td class='meaning'>Invalid name syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedUnitsShouldMatch CompReplacedUnitsShouldMatch@endlink</td>
<td class='meaning'>Units of replaced elements should match replacement units.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneListOfReplacedElements CompOneListOfReplacedElements@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfReplacedElements&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOReplaceElementsAllowedElements CompLOReplaceElementsAllowedElements@endlink</td>
<td class='meaning'>Allowed children of <code>&lt;listOfReplacedElements&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOReplacedElementsAllowedAttribs CompLOReplacedElementsAllowedAttribs@endlink</td>
<td class='meaning'>Allowed <code>&lt;listOfReplacedElements&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompEmptyLOReplacedElements CompEmptyLOReplacedElements@endlink</td>
<td class='meaning'><code>&lt;listOfReplacedElements&gt;</code> must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneReplacedByElement CompOneReplacedByElement@endlink</td>
<td class='meaning'>Only one <code>&lt;replacedBy&gt;</code> object allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompAttributeRequiredMissing CompAttributeRequiredMissing@endlink</td>
<td class='meaning'>Required comp:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompAttributeRequiredMustBeBoolean CompAttributeRequiredMustBeBoolean@endlink</td>
<td class='meaning'>The comp:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompRequiredTrueIfElementsRemain CompRequiredTrueIfElementsRemain@endlink</td>
<td class='meaning'>The comp:required attribute must be 'true' if math changes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CompRequiredFalseIfAllElementsReplaced CompRequiredFalseIfAllElementsReplaced@endlink</td>
<td class='meaning'>The comp:required attribute must be 'false' if math does not change</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneListOfModelDefinitions CompOneListOfModelDefinitions@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfModelDefinitions&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompEmptyLOModelDefs CompEmptyLOModelDefs@endlink</td>
<td class='meaning'><code>&lt;listOfModelDefinitions&gt;</code> and <code>&lt;listOfExternalModelDefinitions&gt;</code> must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOModelDefsAllowedElements CompLOModelDefsAllowedElements@endlink</td>
<td class='meaning'>Only <code>&lt;modelDefinitions&gt;</code> in <code>&lt;listOfModelDefinitions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOExtModelDefsAllowedElements CompLOExtModelDefsAllowedElements@endlink</td>
<td class='meaning'>Only <code>&lt;externalModelDefinitions&gt;</code> in <code>&lt;listOfExternalModelDefinitions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOModelDefsAllowedAttributes CompLOModelDefsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;listOfModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOExtModDefsAllowedAttributes CompLOExtModDefsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;listOfExternalModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneListOfExtModelDefinitions CompOneListOfExtModelDefinitions@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfExternalModelDefinitions&gt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompAttributeRequiredMustBeTrue CompAttributeRequiredMustBeTrue@endlink</td>
<td class='meaning'>The comp:required attribute must be 'true'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtModDefAllowedCoreAttributes CompExtModDefAllowedCoreAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> core attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtModDefAllowedElements CompExtModDefAllowedElements@endlink</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> elements</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtModDefAllowedAttributes CompExtModDefAllowedAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;externalModelDefinitions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReferenceMustBeL3 CompReferenceMustBeL3@endlink</td>
<td class='meaning'>External models must be L3</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompModReferenceMustIdOfModel CompModReferenceMustIdOfModel@endlink</td>
<td class='meaning'>'modelRef' must be the 'id' of a model in the 'source' document</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtModMd5DoesNotMatch CompExtModMd5DoesNotMatch@endlink</td>
<td class='meaning'>MD5 checksum does not match the 'source' document</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidSourceSyntax CompInvalidSourceSyntax@endlink</td>
<td class='meaning'>The 'comp:source' attribute must be of type 'anyURI'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidModelRefSyntax CompInvalidModelRefSyntax@endlink</td>
<td class='meaning'>The 'comp:modelRef' attribute must have the syntax of 'SId'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidMD5Syntax CompInvalidMD5Syntax@endlink</td>
<td class='meaning'>The 'comp:md5' attribute must have the syntax of 'string'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompCircularExternalModelReference CompCircularExternalModelReference@endlink</td>
<td class='meaning'>Circular reference in <code>&lt;externalModelDefinition&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneListOfOnModel CompOneListOfOnModel@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfSubmodels&gt;</code> and one <code>&lt;listOfPorts&gt;</code> allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompNoEmptyListOfOnModel CompNoEmptyListOfOnModel@endlink</td>
<td class='meaning'>No empty listOf elements allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOSubmodelsAllowedElements CompLOSubmodelsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfSubmodels&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOPortsAllowedElements CompLOPortsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfPorts&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOSubmodelsAllowedAttributes CompLOSubmodelsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on <code>&lt;listOfSubmodels&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLOPortsAllowedAttributes CompLOPortsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on <code>&lt;listOfPorts&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelAllowedCoreAttributes CompSubmodelAllowedCoreAttributes@endlink</td>
<td class='meaning'>Allowed core attributes on <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelAllowedElements CompSubmodelAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneListOfDeletionOnSubmodel CompOneListOfDeletionOnSubmodel@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfDeletions&gt;</code> on a <code>&lt;submodel&gt;</code> allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelNoEmptyLODeletions CompSubmodelNoEmptyLODeletions@endlink</td>
<td class='meaning'>No empty listOfDeletions elements allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLODeletionsAllowedElements CompLODeletionsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on <code>&lt;listOfDeletions&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLODeletionAllowedAttributes CompLODeletionAllowedAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;listOfDeletions&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelAllowedAttributes CompSubmodelAllowedAttributes@endlink</td>
<td class='meaning'>Allowed <code>&lt;submodel&gt;</code> attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompModReferenceSyntax CompModReferenceSyntax@endlink</td>
<td class='meaning'>'comp:modelRef' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidTimeConvFactorSyntax CompInvalidTimeConvFactorSyntax@endlink</td>
<td class='meaning'>'comp:timeConversionFactor' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidExtentConvFactorSyntax CompInvalidExtentConvFactorSyntax@endlink</td>
<td class='meaning'>'comp:extentConversionFactor' must conform to SId syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelMustReferenceModel CompSubmodelMustReferenceModel@endlink</td>
<td class='meaning'>The 'comp:modelRef' attribute must reference a model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSubmodelCannotReferenceSelf CompSubmodelCannotReferenceSelf@endlink</td>
<td class='meaning'>The 'comp:modelRef' attribute cannot reference own model</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompModCannotCircularlyReferenceSelf CompModCannotCircularlyReferenceSelf@endlink</td>
<td class='meaning'><code>&lt;model&gt;</code> may not reference <code>&lt;submodel&gt;</code> that references itself.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompTimeConversionMustBeParameter CompTimeConversionMustBeParameter@endlink</td>
<td class='meaning'>The 'comp:timeConversionFactor' must reference a parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtentConversionMustBeParameter CompExtentConversionMustBeParameter@endlink</td>
<td class='meaning'>The 'comp:extentConversionFactor' must reference a parameter</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompPortRefMustReferencePort CompPortRefMustReferencePort@endlink</td>
<td class='meaning'>The 'comp:portRef' attribute must be the 'id' of a <code>&lt;port&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompIdRefMustReferenceObject CompIdRefMustReferenceObject@endlink</td>
<td class='meaning'>The 'comp:idRef' attribute must be the 'id' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompUnitRefMustReferenceUnitDef CompUnitRefMustReferenceUnitDef@endlink</td>
<td class='meaning'>The 'comp:unitRef' attribute must be the 'id' of a UnitDefinition</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMetaIdRefMustReferenceObject CompMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must be the 'metaid' of an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompParentOfSBRefChildMustBeSubmodel CompParentOfSBRefChildMustBeSubmodel@endlink</td>
<td class='meaning'>If <code>&lt;sBaseRef&gt;</code> has a child <code>&lt;sBaseRef&gt;</code> its parent must be a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidPortRefSyntax CompInvalidPortRefSyntax@endlink</td>
<td class='meaning'>The 'comp:portRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidIdRefSyntax CompInvalidIdRefSyntax@endlink</td>
<td class='meaning'>The 'comp:idRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidUnitRefSyntax CompInvalidUnitRefSyntax@endlink</td>
<td class='meaning'>The 'comp:unitRef' attribute must have the syntax of an SBML SId</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompInvalidMetaIdRefSyntax CompInvalidMetaIdRefSyntax@endlink</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must have the syntax of an XML ID</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompOneSBaseRefOnly CompOneSBaseRefOnly@endlink</td>
<td class='meaning'>Only one <code>&lt;sbaseRef&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeprecatedSBaseRefSpelling CompDeprecatedSBaseRefSpelling@endlink</td>
<td class='meaning'>The spelling 'sbaseRef' is deprecated</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSBaseRefMustReferenceObject CompSBaseRefMustReferenceObject@endlink</td>
<td class='meaning'>An SBaseRef must reference an object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompSBaseRefMustReferenceOnlyOneObject CompSBaseRefMustReferenceOnlyOneObject@endlink</td>
<td class='meaning'>An SBaseRef must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompNoMultipleReferences CompNoMultipleReferences@endlink</td>
<td class='meaning'>Objects may not be referenced by mutiple SBaseRef constructs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompPortMustReferenceObject CompPortMustReferenceObject@endlink</td>
<td class='meaning'>Port must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompPortMustReferenceOnlyOneObject CompPortMustReferenceOnlyOneObject@endlink</td>
<td class='meaning'>Port must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompPortAllowedAttributes CompPortAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on a Port</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompPortReferencesUnique CompPortReferencesUnique@endlink</td>
<td class='meaning'>Port definitions must be unique.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeletionMustReferenceObject CompDeletionMustReferenceObject@endlink</td>
<td class='meaning'>Deletion must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeletionMustReferOnlyOneObject CompDeletionMustReferOnlyOneObject@endlink</td>
<td class='meaning'>Deletion must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeletionAllowedAttributes CompDeletionAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on a Deletion</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementMustRefObject CompReplacedElementMustRefObject@endlink</td>
<td class='meaning'>ReplacedElement must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementMustRefOnlyOne CompReplacedElementMustRefOnlyOne@endlink</td>
<td class='meaning'>ReplacedElement must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementAllowedAttributes CompReplacedElementAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on <code>&lt;replacedElement&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementSubModelRef CompReplacedElementSubModelRef@endlink</td>
<td class='meaning'>The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementDeletionRef CompReplacedElementDeletionRef@endlink</td>
<td class='meaning'>The 'comp:deletion' attribute must point to a <code>&lt;deletion&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementConvFactorRef CompReplacedElementConvFactorRef@endlink</td>
<td class='meaning'>The 'comp:conversionFactor attribute must point to a <code>&lt;parameter&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementSameReference CompReplacedElementSameReference@endlink</td>
<td class='meaning'>No <code>&lt;replacedElement&gt;</code> refer to same object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedElementNoDelAndConvFact CompReplacedElementNoDelAndConvFact@endlink</td>
<td class='meaning'>No <code>&lt;replacedElement&gt;</code> with deletion and conversionfactor</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedByMustRefObject CompReplacedByMustRefObject@endlink</td>
<td class='meaning'>ReplacedBy must reference an object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedByMustRefOnlyOne CompReplacedByMustRefOnlyOne@endlink</td>
<td class='meaning'>ReplacedBy must reference only one other object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedByAllowedAttributes CompReplacedByAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on <code>&lt;replacedBy&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompReplacedBySubModelRef CompReplacedBySubModelRef@endlink</td>
<td class='meaning'>The 'comp:submodelRef' attribute must point to a <code>&lt;submodel&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMustReplaceSameClass CompMustReplaceSameClass@endlink</td>
<td class='meaning'>Replaced classes must match.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMustReplaceIDs CompMustReplaceIDs@endlink</td>
<td class='meaning'>Replaced IDs must be replaced with IDs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMustReplaceMetaIDs CompMustReplaceMetaIDs@endlink</td>
<td class='meaning'>Replaced metaids must be replaced with metaids.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMustReplacePackageIDs CompMustReplacePackageIDs@endlink</td>
<td class='meaning'>Replaced package IDs must be replaced with package IDs.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompUnresolvedReference CompUnresolvedReference@endlink</td>
<td class='meaning'>Unresolved reference.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompNoModelInReference CompNoModelInReference@endlink</td>
<td class='meaning'>No model in referenced document.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompExtModDefBad CompExtModDefBad@endlink</td>
<td class='meaning'>Referenced <code>&lt;externalModelDefinition&gt;</code> unresolvable.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompModelFlatteningFailed CompModelFlatteningFailed@endlink</td>
<td class='meaning'>Model failed to flatten.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatModelNotValid CompFlatModelNotValid@endlink</td>
<td class='meaning'>Flat model not valid.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompLineNumbersUnreliable CompLineNumbersUnreliable@endlink</td>
<td class='meaning'>Line numbers unreliable.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatteningNotRecognisedReqd CompFlatteningNotRecognisedReqd@endlink</td>
<td class='meaning'>Flattening not implemented for required package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatteningNotRecognisedNotReqd CompFlatteningNotRecognisedNotReqd@endlink</td>
<td class='meaning'>Flattening not implemented for unrequired package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatteningNotImplementedNotReqd CompFlatteningNotImplementedNotReqd@endlink</td>
<td class='meaning'>Flattening not implemented for unrequired package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatteningNotImplementedReqd CompFlatteningNotImplementedReqd@endlink</td>
<td class='meaning'>Flattening not implemented for required package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompFlatteningWarning CompFlatteningWarning@endlink</td>
<td class='meaning'>Flattening reference may come from package.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeprecatedDeleteFunction CompDeprecatedDeleteFunction@endlink</td>
<td class='meaning'>The performDeletions functions is deprecated.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeprecatedReplaceFunction CompDeprecatedReplaceFunction@endlink</td>
<td class='meaning'>The performReplacementsAndConversions fuctions is deprecated.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompDeletedReplacement CompDeletedReplacement@endlink</td>
<td class='meaning'>Element deleted before a subelement could be replaced.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#CompIdRefMayReferenceUnknownPackage CompIdRefMayReferenceUnknownPackage@endlink</td>
<td class='meaning'>The 'comp:idRef' attribute must be the 'id' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#CompMetaIdRefMayReferenceUnknownPkg CompMetaIdRefMayReferenceUnknownPkg@endlink</td>
<td class='meaning'>The 'comp:metaIdRef' attribute must be the 'metaid' of a model element</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcUnknown FbcUnknown@endlink</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcNSUndeclared FbcNSUndeclared@endlink</td>
<td class='meaning'>The fbc ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcElementNotInNs FbcElementNotInNs@endlink</td>
<td class='meaning'>Element not in fbc namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcDuplicateComponentId FbcDuplicateComponentId@endlink</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcSBMLSIdSyntax FbcSBMLSIdSyntax@endlink</td>
<td class='meaning'>Invalid 'id' attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcAttributeRequiredMissing FbcAttributeRequiredMissing@endlink</td>
<td class='meaning'>Required fbc:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcAttributeRequiredMustBeBoolean FbcAttributeRequiredMustBeBoolean@endlink</td>
<td class='meaning'>The fbc:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcRequiredFalse FbcRequiredFalse@endlink</td>
<td class='meaning'>The fbc:required attribute must be 'false'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcOnlyOneEachListOf FbcOnlyOneEachListOf@endlink</td>
<td class='meaning'>One of each list of allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcNoEmptyListOfs FbcNoEmptyListOfs@endlink</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcLOFluxBoundsAllowedElements FbcLOFluxBoundsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfFluxBounds</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcLOObjectivesAllowedElements FbcLOObjectivesAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfObjectives</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcLOFluxBoundsAllowedAttributes FbcLOFluxBoundsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on ListOfFluxBounds</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcLOObjectivesAllowedAttributes FbcLOObjectivesAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on ListOfObjectives</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcActiveObjectiveSyntax FbcActiveObjectiveSyntax@endlink</td>
<td class='meaning'>Type of activeObjective attribute</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcActiveObjectiveRefersObjective FbcActiveObjectiveRefersObjective@endlink</td>
<td class='meaning'>ActiveObjective must reference Objective</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcSpeciesAllowedL3Attributes FbcSpeciesAllowedL3Attributes@endlink</td>
<td class='meaning'>Species allowed attributes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcSpeciesChargeMustBeInteger FbcSpeciesChargeMustBeInteger@endlink</td>
<td class='meaning'>Charge must be integer</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcSpeciesFormulaMustBeString FbcSpeciesFormulaMustBeString@endlink</td>
<td class='meaning'>Chemical formula must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundAllowedL3Attributes FbcFluxBoundAllowedL3Attributes@endlink</td>
<td class='meaning'><code>&lt;fluxBound&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundAllowedElements FbcFluxBoundAllowedElements@endlink</td>
<td class='meaning'><code>&lt;fluxBound&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundRequiredAttributes FbcFluxBoundRequiredAttributes@endlink</td>
<td class='meaning'>Invalid attribute found on <code>&lt;fluxBound&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundRectionMustBeSIdRef FbcFluxBoundRectionMustBeSIdRef@endlink</td>
<td class='meaning'>Datatype for 'fbc:reaction' must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundNameMustBeString FbcFluxBoundNameMustBeString@endlink</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundOperationMustBeEnum FbcFluxBoundOperationMustBeEnum@endlink</td>
<td class='meaning'>The attribute 'fbc:operation' must be of data type FbcOperation</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundValueMustBeDouble FbcFluxBoundValueMustBeDouble@endlink</td>
<td class='meaning'>The attribute 'fbc:value' must be of the data type double</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundReactionMustExist FbcFluxBoundReactionMustExist@endlink</td>
<td class='meaning'>'fbc:reaction' must refer to valid reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxBoundsForReactionConflict FbcFluxBoundsForReactionConflict@endlink</td>
<td class='meaning'>Conflicting set of FluxBounds for a reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveAllowedL3Attributes FbcObjectiveAllowedL3Attributes@endlink</td>
<td class='meaning'><code>&lt;objective&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveAllowedElements FbcObjectiveAllowedElements@endlink</td>
<td class='meaning'><code>&lt;objective&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveRequiredAttributes FbcObjectiveRequiredAttributes@endlink</td>
<td class='meaning'>Invalid attribute found on <code>&lt;objective&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveNameMustBeString FbcObjectiveNameMustBeString@endlink</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveTypeMustBeEnum FbcObjectiveTypeMustBeEnum@endlink</td>
<td class='meaning'>The attribute 'fbc:type' must be of data type FbcType.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveOneListOfObjectives FbcObjectiveOneListOfObjectives@endlink</td>
<td class='meaning'>An <code>&lt;objective&gt;</code> must have one <code>&lt;listOfFluxObjectives&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveLOFluxObjMustNotBeEmpty FbcObjectiveLOFluxObjMustNotBeEmpty@endlink</td>
<td class='meaning'><code>&lt;listOfFluxObjectives&gt;</code> subobject must not be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveLOFluxObjOnlyFluxObj FbcObjectiveLOFluxObjOnlyFluxObj@endlink</td>
<td class='meaning'>Invalid element found in <code>&lt;listOfFluxObjectives&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcObjectiveLOFluxObjAllowedAttribs FbcObjectiveLOFluxObjAllowedAttribs@endlink</td>
<td class='meaning'><code>&lt;listOfFluxObjectives&gt;</code> may only have 'metaId' and 'sboTerm' from L3 core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectAllowedL3Attributes FbcFluxObjectAllowedL3Attributes@endlink</td>
<td class='meaning'><code>&lt;fluxObjective&gt;</code> may only have 'metaId' and 'sboTerm' from L3 namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectAllowedElements FbcFluxObjectAllowedElements@endlink</td>
<td class='meaning'><code>&lt;fluxObjective&gt;</code> may only have <code>&lt;notes&gt;</code> and <code>&lt;annotations&gt;</code> from L3 Core</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectRequiredAttributes FbcFluxObjectRequiredAttributes@endlink</td>
<td class='meaning'>Invalid attribute found on <code>&lt;fluxObjective&gt;</code> object</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectNameMustBeString FbcFluxObjectNameMustBeString@endlink</td>
<td class='meaning'>The attribute 'fbc:name' must be of the data type string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectReactionMustBeSIdRef FbcFluxObjectReactionMustBeSIdRef@endlink</td>
<td class='meaning'>Datatype for 'fbc:reaction' must be SIdRef</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectReactionMustExist FbcFluxObjectReactionMustExist@endlink</td>
<td class='meaning'>'fbc:reaction' must refer to valid reaction</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#FbcFluxObjectCoefficientMustBeDouble FbcFluxObjectCoefficientMustBeDouble@endlink</td>
<td class='meaning'>The attribute 'fbc:coefficient' must be of the data type double</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualUnknown QualUnknown@endlink</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#QualNSUndeclared QualNSUndeclared@endlink</td>
<td class='meaning'>The qual ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualElementNotInNs QualElementNotInNs@endlink</td>
<td class='meaning'>Element not in qual namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFunctionTermBool QualFunctionTermBool@endlink</td>
<td class='meaning'>FunctionTerm should return boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#QualMathCSymbolDisallowed QualMathCSymbolDisallowed@endlink</td>
<td class='meaning'>CSymbol time or delay not allowed</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-warning'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDuplicateComponentId QualDuplicateComponentId@endlink</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualAttributeRequiredMissing QualAttributeRequiredMissing@endlink</td>
<td class='meaning'>Required qual:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualAttributeRequiredMustBeBoolean QualAttributeRequiredMustBeBoolean@endlink</td>
<td class='meaning'>The qual:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualRequiredTrueIfTransitions QualRequiredTrueIfTransitions@endlink</td>
<td class='meaning'>The qual:required attribute must be 'true' if math changes</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOneListOfTransOrQS QualOneListOfTransOrQS@endlink</td>
<td class='meaning'>Only one <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualEmptyLONotAllowed QualEmptyLONotAllowed@endlink</td>
<td class='meaning'>Empty <code>&lt;listOfTransitions&gt;</code> or <code>&lt;listOfQualitativeSpeciesgt;</code> not allowed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualLOTransitiondAllowedElements QualLOTransitiondAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualLOQualSpeciesAllowedElements QualLOQualSpeciesAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualLOQualSpeciesAllowedAttributes QualLOQualSpeciesAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfQualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualLOTransitionsAllowedAttributes QualLOTransitionsAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfTransitions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualQualSpeciesAllowedCoreAttributes QualQualSpeciesAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualQualSpeciesAllowedElements QualQualSpeciesAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualQualSpeciesAllowedAttributes QualQualSpeciesAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;qualitativeSpeciesgt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualConstantMustBeBool QualConstantMustBeBool@endlink</td>
<td class='meaning'>Attribute 'constant' on <code>&lt;qualitativeSpeciesgt;</code> must be boolean.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualNameMustBeString QualNameMustBeString@endlink</td>
<td class='meaning'>Attribute 'name' on <code>&lt;qualitativeSpeciesgt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInitialLevelMustBeInt QualInitialLevelMustBeInt@endlink</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualMaxLevelMustBeInt QualMaxLevelMustBeInt@endlink</td>
<td class='meaning'>Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> must be integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualCompartmentMustReferExisting QualCompartmentMustReferExisting@endlink</td>
<td class='meaning'>Attribute 'compartment' on <code>&lt;qualitativeSpeciesgt;</code> must reference compartment.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInitialLevelCannotExceedMax QualInitialLevelCannotExceedMax@endlink</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot exceed maxLevel.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualConstantQSCannotBeOutput QualConstantQSCannotBeOutput@endlink</td>
<td class='meaning'>Constant <code>&lt;qualitativeSpeciesgt;</code> cannot be an Output.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualQSAssignedOnlyOnce QualQSAssignedOnlyOnce@endlink</td>
<td class='meaning'>A <code>&lt;qualitativeSpeciesgt;</code> can only be assigned once.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInitalLevelNotNegative QualInitalLevelNotNegative@endlink</td>
<td class='meaning'>Attribute 'initialLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualMaxLevelNotNegative QualMaxLevelNotNegative@endlink</td>
<td class='meaning'>Attribute 'maxLevel' on <code>&lt;qualitativeSpeciesgt;</code> cannot be negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionAllowedCoreAttributes QualTransitionAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionAllowedElements QualTransitionAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionAllowedAttributes QualTransitionAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionNameMustBeString QualTransitionNameMustBeString@endlink</td>
<td class='meaning'>Attribute 'name' on <code>&lt;transition&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOElements QualTransitionLOElements@endlink</td>
<td class='meaning'>ListOf elements on <code>&lt;transition&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionEmptyLOElements QualTransitionEmptyLOElements@endlink</td>
<td class='meaning'>ListOf elements on <code>&lt;transition&gt;</code> not empty.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOInputElements QualTransitionLOInputElements@endlink</td>
<td class='meaning'>Elements on <code>&lt;listOfInputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOOutputElements QualTransitionLOOutputElements@endlink</td>
<td class='meaning'>Elements on <code>&lt;listOfOutputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOFuncTermElements QualTransitionLOFuncTermElements@endlink</td>
<td class='meaning'>Elements on <code>&lt;listOfFunctionTerms&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOInputAttributes QualTransitionLOInputAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfInputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOOutputAttributes QualTransitionLOOutputAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfOutputs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOFuncTermAttributes QualTransitionLOFuncTermAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfFunctionTerms&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOFuncTermExceedMax QualTransitionLOFuncTermExceedMax@endlink</td>
<td class='meaning'><code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies exceed maxLevel.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualTransitionLOFuncTermNegative QualTransitionLOFuncTermNegative@endlink</td>
<td class='meaning'><code>&lt;listOfFunctionTerms&gt;</code> cannot make qualitativeSpecies negative.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputAllowedCoreAttributes QualInputAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputAllowedElements QualInputAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputAllowedAttributes QualInputAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;input&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputNameMustBeString QualInputNameMustBeString@endlink</td>
<td class='meaning'>Attribute 'name' on <code>&lt;input&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputSignMustBeSignEnum QualInputSignMustBeSignEnum@endlink</td>
<td class='meaning'>Attribute 'sign' on <code>&lt;input&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputTransEffectMustBeInputEffect QualInputTransEffectMustBeInputEffect@endlink</td>
<td class='meaning'>Attribute 'transitionEffect' on <code>&lt;input&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputThreshMustBeInteger QualInputThreshMustBeInteger@endlink</td>
<td class='meaning'>Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputQSMustBeExistingQS QualInputQSMustBeExistingQS@endlink</td>
<td class='meaning'>Attribute 'qualitativeSpecies' on <code>&lt;input&gt;</code> must refer to existing</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputConstantCannotBeConsumed QualInputConstantCannotBeConsumed@endlink</td>
<td class='meaning'>Constant <code>&lt;input&gt;</code> cannot be consumed.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualInputThreshMustBeNonNegative QualInputThreshMustBeNonNegative@endlink</td>
<td class='meaning'>Attribute 'thresholdLevel' on <code>&lt;input&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputAllowedCoreAttributes QualOutputAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputAllowedElements QualOutputAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputAllowedAttributes QualOutputAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;output&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputNameMustBeString QualOutputNameMustBeString@endlink</td>
<td class='meaning'>Attribute 'name' on <code>&lt;output&gt;</code> must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputTransEffectMustBeOutput QualOutputTransEffectMustBeOutput@endlink</td>
<td class='meaning'>Attribute 'transitionEffect' on <code>&lt;output&gt;</code> must be enum.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputLevelMustBeInteger QualOutputLevelMustBeInteger@endlink</td>
<td class='meaning'>Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputQSMustBeExistingQS QualOutputQSMustBeExistingQS@endlink</td>
<td class='meaning'>Attribute 'qualitativeSpecies' on <code>&lt;output&gt;</code> must refer to existing</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputConstantMustBeFalse QualOutputConstantMustBeFalse@endlink</td>
<td class='meaning'>Constant 'qualitativeSpecies' cannot be <code>&lt;output&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputProductionMustHaveLevel QualOutputProductionMustHaveLevel@endlink</td>
<td class='meaning'><code>&lt;output&gt;</code> being produced must have level</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualOutputLevelMustBeNonNegative QualOutputLevelMustBeNonNegative@endlink</td>
<td class='meaning'>Attribute 'outputLevel' on <code>&lt;output&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDefaultTermAllowedCoreAttributes QualDefaultTermAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDefaultTermAllowedElements QualDefaultTermAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDefaultTermAllowedAttributes QualDefaultTermAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;defaultTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDefaultTermResultMustBeInteger QualDefaultTermResultMustBeInteger@endlink</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualDefaultTermResultMustBeNonNeg QualDefaultTermResultMustBeNonNeg@endlink</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;defaultTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermAllowedCoreAttributes QualFuncTermAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermAllowedElements QualFuncTermAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermAllowedAttributes QualFuncTermAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermOnlyOneMath QualFuncTermOnlyOneMath@endlink</td>
<td class='meaning'>Only one <code>&lt;math&gt;</code> on <code>&lt;functionTerm&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermResultMustBeInteger QualFuncTermResultMustBeInteger@endlink</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#QualFuncTermResultMustBeNonNeg QualFuncTermResultMustBeNonNeg@endlink</td>
<td class='meaning'>Attribute 'resultLevel' on <code>&lt;functionTerm&gt;</code> must be non negative integer.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutUnknownError LayoutUnknownError@endlink</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutNSUndeclared LayoutNSUndeclared@endlink</td>
<td class='meaning'>The layout ns is not correctly declared</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutElementNotInNs LayoutElementNotInNs@endlink</td>
<td class='meaning'>Element not in layout namespace</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutDuplicateComponentId LayoutDuplicateComponentId@endlink</td>
<td class='meaning'>Duplicate 'id' attribute value</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSIdSyntax LayoutSIdSyntax@endlink</td>
<td class='meaning'>'id' attribute incorrect syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutXsiTypeAllowedLocations LayoutXsiTypeAllowedLocations@endlink</td>
<td class='meaning'>'xsi:type' allowed locations</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutXsiTypeSyntax LayoutXsiTypeSyntax@endlink</td>
<td class='meaning'>'xsi:type' attribute incorrect syntax</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutAttributeRequiredMissing LayoutAttributeRequiredMissing@endlink</td>
<td class='meaning'>Required layout:required attribute on <code>&lt;sbml&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutAttributeRequiredMustBeBoolean LayoutAttributeRequiredMustBeBoolean@endlink</td>
<td class='meaning'>The layout:required attribute must be Boolean</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRequiredFalse LayoutRequiredFalse@endlink</td>
<td class='meaning'>The layout:required attribute must be 'false'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutOnlyOneLOLayouts LayoutOnlyOneLOLayouts@endlink</td>
<td class='meaning'>Only one listOfLayouts on <code>&lt;model&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOLayoutsNotEmpty LayoutLOLayoutsNotEmpty@endlink</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOLayoutsAllowedElements LayoutLOLayoutsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfLayouts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOLayoutsAllowedAttributes LayoutLOLayoutsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on ListOfLayouts</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLayoutAllowedElements LayoutLayoutAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on Layout</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLayoutAllowedCoreAttributes LayoutLayoutAllowedCoreAttributes@endlink</td>
<td class='meaning'>Allowed core attributes on Layout</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutOnlyOneEachListOf LayoutOnlyOneEachListOf@endlink</td>
<td class='meaning'>Only one each listOf on <code>&lt;layout&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutNoEmptyListOfs LayoutNoEmptyListOfs@endlink</td>
<td class='meaning'>ListOf elements cannot be empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLayoutAllowedAttributes LayoutLayoutAllowedAttributes@endlink</td>
<td class='meaning'><code>&lt;layout&gt;</code> must have 'id' and may have 'name'</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLayoutNameMustBeString LayoutLayoutNameMustBeString@endlink</td>
<td class='meaning'>'name' must be string</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOCompGlyphAllowedAttributes LayoutLOCompGlyphAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOCompGlyphAllowedElements LayoutLOCompGlyphAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfCompartmentGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSpeciesGlyphAllowedAttributes LayoutLOSpeciesGlyphAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSpeciesGlyphAllowedElements LayoutLOSpeciesGlyphAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfSpeciesGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLORnGlyphAllowedAttributes LayoutLORnGlyphAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfReactionGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLORnGlyphAllowedElements LayoutLORnGlyphAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfReactionGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOAddGOAllowedAttribut LayoutLOAddGOAllowedAttribut@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOAddGOAllowedElements LayoutLOAddGOAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfAdditionalGraphicalObjectGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLayoutMustHaveDimensions LayoutLayoutMustHaveDimensions@endlink</td>
<td class='meaning'>Layout must have <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOTextGlyphAllowedAttributes LayoutLOTextGlyphAllowedAttributes@endlink</td>
<td class='meaning'>Attributes allowed on <code>&lt;listOfTextGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOTextGlyphAllowedElements LayoutLOTextGlyphAllowedElements@endlink</td>
<td class='meaning'>Elements allowed on <code>&lt;listOfTextGlyphs&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOAllowedCoreElements LayoutGOAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOAllowedCoreAttributes LayoutGOAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOAllowedElements LayoutGOAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOAllowedAttributes LayoutGOAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;graphicalObject&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOMetaIdRefMustBeIDREF LayoutGOMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOMetaIdRefMustReferenceObject LayoutGOMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGOMustContainBoundingBox LayoutGOMustContainBoundingBox@endlink</td>
<td class='meaning'>A <code>&lt;graphicalObject&gt;</code> must contain a <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGAllowedCoreElements LayoutCGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGAllowedCoreAttributes LayoutCGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGAllowedElements LayoutCGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGAllowedAttributes LayoutCGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;compartmentGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGMetaIdRefMustBeIDREF LayoutCGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGMetaIdRefMustReferenceObject LayoutCGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGCompartmentSyntax LayoutCGCompartmentSyntax@endlink</td>
<td class='meaning'>CompartmentGlyph 'compartment' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGCompartmentMustRefComp LayoutCGCompartmentMustRefComp@endlink</td>
<td class='meaning'>CompartmentGlyph compartment must reference existing compartment.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGNoDuplicateReferences LayoutCGNoDuplicateReferences@endlink</td>
<td class='meaning'>CompartmentGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCGOrderMustBeDouble LayoutCGOrderMustBeDouble@endlink</td>
<td class='meaning'>CompartmentGlyph order must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGAllowedCoreElements LayoutSGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGAllowedCoreAttributes LayoutSGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGAllowedElements LayoutSGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGAllowedAttributes LayoutSGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;speciesGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGMetaIdRefMustBeIDREF LayoutSGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGMetaIdRefMustReferenceObject LayoutSGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGSpeciesSyntax LayoutSGSpeciesSyntax@endlink</td>
<td class='meaning'>SpeciesGlyph 'species' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGSpeciesMustRefSpecies LayoutSGSpeciesMustRefSpecies@endlink</td>
<td class='meaning'>SpeciesGlyph species must reference existing species.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSGNoDuplicateReferences LayoutSGNoDuplicateReferences@endlink</td>
<td class='meaning'>SpeciesGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGAllowedCoreElements LayoutRGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGAllowedCoreAttributes LayoutRGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGAllowedElements LayoutRGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGAllowedAttributes LayoutRGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;reactionGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGMetaIdRefMustBeIDREF LayoutRGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGMetaIdRefMustReferenceObject LayoutRGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGReactionSyntax LayoutRGReactionSyntax@endlink</td>
<td class='meaning'>ReactionGlyph 'reaction' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGReactionMustRefReaction LayoutRGReactionMustRefReaction@endlink</td>
<td class='meaning'>ReactionGlyph reaction must reference existing reaction.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutRGNoDuplicateReferences LayoutRGNoDuplicateReferences@endlink</td>
<td class='meaning'>ReactionGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSpeciesRefGlyphAllowedElements LayoutLOSpeciesRefGlyphAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfSpeciesReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSpeciesRefGlyphAllowedAttribs LayoutLOSpeciesRefGlyphAllowedAttribs@endlink</td>
<td class='meaning'>Allowed attributes on ListOfSpeciesReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSpeciesRefGlyphNotEmpty LayoutLOSpeciesRefGlyphNotEmpty@endlink</td>
<td class='meaning'>ListOfSpeciesReferenceGlyphs not empty</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGAllowedCoreElements LayoutGGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGAllowedCoreAttributes LayoutGGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGAllowedElements LayoutGGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGAllowedAttributes LayoutGGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;generalGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGMetaIdRefMustBeIDREF LayoutGGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGMetaIdRefMustReferenceObject LayoutGGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGReferenceSyntax LayoutGGReferenceSyntax@endlink</td>
<td class='meaning'>GeneralGlyph 'reference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGReferenceMustRefObject LayoutGGReferenceMustRefObject@endlink</td>
<td class='meaning'>GeneralGlyph 'reference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutGGNoDuplicateReferences LayoutGGNoDuplicateReferences@endlink</td>
<td class='meaning'>GeneralGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOReferenceGlyphAllowedElements LayoutLOReferenceGlyphAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOReferenceGlyphAllowedAttribs LayoutLOReferenceGlyphAllowedAttribs@endlink</td>
<td class='meaning'>Allowed attributes on ListOfReferenceGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSubGlyphAllowedElements LayoutLOSubGlyphAllowedElements@endlink</td>
<td class='meaning'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOSubGlyphAllowedAttribs LayoutLOSubGlyphAllowedAttribs@endlink</td>
<td class='meaning'>Allowed attributes on ListOfSubGlyphs</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGAllowedCoreElements LayoutTGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGAllowedCoreAttributes LayoutTGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGAllowedElements LayoutTGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGAllowedAttributes LayoutTGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;textGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGMetaIdRefMustBeIDREF LayoutTGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGMetaIdRefMustReferenceObject LayoutTGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGOriginOfTextSyntax LayoutTGOriginOfTextSyntax@endlink</td>
<td class='meaning'>TextGlyph 'originOfText' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGOriginOfTextMustRefObject LayoutTGOriginOfTextMustRefObject@endlink</td>
<td class='meaning'>TextGlyph 'originOfText' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGNoDuplicateReferences LayoutTGNoDuplicateReferences@endlink</td>
<td class='meaning'>TextGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGGraphicalObjectSyntax LayoutTGGraphicalObjectSyntax@endlink</td>
<td class='meaning'>TextGlyph 'graphicalObject' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGGraphicalObjectMustRefObject LayoutTGGraphicalObjectMustRefObject@endlink</td>
<td class='meaning'>TextGlyph 'graphicalObject' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutTGTextMustBeString LayoutTGTextMustBeString@endlink</td>
<td class='meaning'>TextGlyph 'text' must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGAllowedCoreElements LayoutSRGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGAllowedCoreAttributes LayoutSRGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGAllowedElements LayoutSRGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGAllowedAttributes LayoutSRGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;speciesReferenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGMetaIdRefMustBeIDREF LayoutSRGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGMetaIdRefMustReferenceObject LayoutSRGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGSpeciesReferenceSyntax LayoutSRGSpeciesReferenceSyntax@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesReference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGSpeciesRefMustRefObject LayoutSRGSpeciesRefMustRefObject@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesReference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGNoDuplicateReferences LayoutSRGNoDuplicateReferences@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGSpeciesGlyphSyntax LayoutSRGSpeciesGlyphSyntax@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesGlyph' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGSpeciesGlyphMustRefObject LayoutSRGSpeciesGlyphMustRefObject@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph 'speciesGlyph' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutSRGRoleSyntax LayoutSRGRoleSyntax@endlink</td>
<td class='meaning'>SpeciesReferenceGlyph 'role' must be string from enumeration.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGAllowedCoreElements LayoutREFGAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGAllowedCoreAttributes LayoutREFGAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGAllowedElements LayoutREFGAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGAllowedAttributes LayoutREFGAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;referenceGlyph&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGMetaIdRefMustBeIDREF LayoutREFGMetaIdRefMustBeIDREF@endlink</td>
<td class='meaning'>Layout 'metIdRef' must be IDREF.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGMetaIdRefMustReferenceObject LayoutREFGMetaIdRefMustReferenceObject@endlink</td>
<td class='meaning'>Layout 'metIdRef' must reference existing object.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGReferenceSyntax LayoutREFGReferenceSyntax@endlink</td>
<td class='meaning'>ReferenceGlyph 'reference' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGReferenceMustRefObject LayoutREFGReferenceMustRefObject@endlink</td>
<td class='meaning'>ReferenceGlyph 'reference' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGNoDuplicateReferences LayoutREFGNoDuplicateReferences@endlink</td>
<td class='meaning'>ReferenceGlyph cannot reference two objects.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGGlyphSyntax LayoutREFGGlyphSyntax@endlink</td>
<td class='meaning'>ReferenceGlyph 'glyph' must have SIdRef syntax.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGGlyphMustRefObject LayoutREFGGlyphMustRefObject@endlink</td>
<td class='meaning'>ReferenceGlyph 'glyph' must reference existing element.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutREFGRoleSyntax LayoutREFGRoleSyntax@endlink</td>
<td class='meaning'>ReferenceGlyph 'role' must be string.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutPointAllowedCoreElements LayoutPointAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutPointAllowedCoreAttributes LayoutPointAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutPointAllowedAttributes LayoutPointAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;point&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutPointAttributesMustBeDouble LayoutPointAttributesMustBeDouble@endlink</td>
<td class='meaning'>Layout 'x', 'y' and 'z' must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutBBoxAllowedCoreElements LayoutBBoxAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutBBoxAllowedCoreAttributes LayoutBBoxAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutBBoxAllowedElements LayoutBBoxAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutBBoxAllowedAttributes LayoutBBoxAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;boundingBox&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutBBoxConsistent3DDefinition LayoutBBoxConsistent3DDefinition@endlink</td>
<td class='meaning'>Layout consistent dimensions on a <code>&lt;boundingBox&gt;</code></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCurveAllowedCoreElements LayoutCurveAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCurveAllowedCoreAttributes LayoutCurveAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCurveAllowedElements LayoutCurveAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCurveAllowedAttributes LayoutCurveAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;curve&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOCurveSegsAllowedAttributes LayoutLOCurveSegsAllowedAttributes@endlink</td>
<td class='meaning'>Allowed attributes on ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOCurveSegsAllowedElements LayoutLOCurveSegsAllowedElements@endlink</td>
<td class='meaning'>Allowed elements on ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLOCurveSegsNotEmpty LayoutLOCurveSegsNotEmpty@endlink</td>
<td class='meaning'>No empty ListOfCurveSegments</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLSegAllowedCoreElements LayoutLSegAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLSegAllowedCoreAttributes LayoutLSegAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLSegAllowedElements LayoutLSegAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutLSegAllowedAttributes LayoutLSegAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;lineSegment&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCBezAllowedCoreElements LayoutCBezAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCBezAllowedCoreAttributes LayoutCBezAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCBezAllowedElements LayoutCBezAllowedElements@endlink</td>
<td class='meaning'>Layout elements allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutCBezAllowedAttributes LayoutCBezAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;cubicBezier&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutDimsAllowedCoreElements LayoutDimsAllowedCoreElements@endlink</td>
<td class='meaning'>Core elements allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutDimsAllowedCoreAttributes LayoutDimsAllowedCoreAttributes@endlink</td>
<td class='meaning'>Core attributes allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutDimsAllowedAttributes LayoutDimsAllowedAttributes@endlink</td>
<td class='meaning'>Layout attributes allowed on <code>&lt;dimensions&gt;</code>.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
<tr><td class='code'>@link libsbml#LayoutDimsAttributesMustBeDouble LayoutDimsAttributesMustBeDouble@endlink</td>
<td class='meaning'>Layout 'width', 'height' and 'depth' must be double.</td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-na'></td>
<td class='s-error'></td>
</tr>
</table>
 *
 * @if clike <h3><a class='anchor' name='SBMLErrorCategory_t'>SBMLErrorCategory_t</a></h3>
 *
 * #SBMLErrorCategory_t is an enumeration of category codes for SBMLError
 * diagnostics.  The category can be retrieved from an SBMLError object
 * using the method SBMLError::getCategory().  These enumeration values are
 * distinct from (and in addition to) the
 * #XMLErrorCategory_t codes used by
 * the parent XMLError object.  User programs receiving an SBMLError object
 * can use this distinction to check whether the error represents a
 * low-level XML problem or an SBML problem.
 *
 * The following table lists each possible value and a brief description of
 * its meaning.
 *
 * @endif@if python <h3><a class='anchor' name='SBMLErrorCategory_t'>Category codes associated with SBMLError objects</a></h3>
 *
 * As discussed above, each SBMLError object contains a value for a
 * category identifier, describing the type of issue that the SBMLError
 * object represents.  The category can be retrieved from an SBMLError
 * object using the method SBMLError::getCategory().  The following table
 * lists each possible value and a brief description of its meaning.
 *
 * As is the case with the error codes, in the libSBML Python language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * @link libsbml libsbml@endlink.
 *
 * The following table lists each possible value and a brief description of
 * its meaning.
 *
 * @endif@if java <h3><a class='anchor'
 * name='SBMLErrorCategory_t'>Category codes associated with SBMLError objects</a></h3>
 *
 * As discussed above, each SBMLError object contains a value for a
 * category identifier, describing the type of issue that the SBMLError
 * object represents.  The category can be retrieved from an SBMLError
 * object using the method SBMLError::getCategory().  The following table
 * lists each possible value and a brief description of its meaning.
 *
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * {@link libsbmlConstants}.
 *
 * The following table lists each possible value and a brief description of
 * its meaning.
 *
 * @endif@if csharp <h3><a class='anchor'
 * name='SBMLErrorCategory_t'>Category codes associated with SBMLError objects</a></h3>
 *
 * As discussed above, each SBMLError object contains a value for a
 * category identifier, describing the type of issue that the SBMLError
 * object represents.  The category can be retrieved from an SBMLError
 * object using the method SBMLError::getCategory().  The following table
 * lists each possible value and a brief description of its meaning.
 *
 * As is the case with the error codes, in the libSBML C# language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * {@link libsbmlcs.libsbml}.
 *
 * The following table lists each possible value and a brief description of
 * its meaning.
 *
 * @endif
 *
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='4' border='0'  class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</td>
 *      <th>Meaning</td>
 *  </tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML LIBSBML_CAT_SBML@endlink</td><td>General error not falling into
 * another category below.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L1_COMPAT LIBSBML_CAT_SBML_L1_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model from SBML Level&nbsp;2 to SBML
 * Level&nbsp;1.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L2V1_COMPAT LIBSBML_CAT_SBML_L2V1_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;1.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L2V2_COMPAT LIBSBML_CAT_SBML_L2V2_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;2.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY@endlink</td><td>Category of
 * errors that can occur while validating general SBML constructs.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 2xxxx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink</td><td>Category of
 * errors that can occur while validating symbol identifiers in a model.
 * With respect to the SBML specification, these concern failures in
 * applying the validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY@endlink</td><td>Category of
 * errors that can occur while validating the units of measurement on
 * quantities in a model.  With respect to the SBML specification, these
 * concern failures in applying the validation rules numbered 105xx in the
 * Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY@endlink</td><td>Category of
 * errors that can occur while validating MathML formulas in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 102xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY@endlink</td><td>Category of errors
 * that can occur while validating SBO identifiers in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL@endlink</td><td>Error in the
 * system of equations in the model: the system is overdetermined,
 * therefore violating a tenet of proper SBML.  With respect to the SBML
 * specification, this is validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L2V3_COMPAT LIBSBML_CAT_SBML_L2V3_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;3.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE@endlink</td><td>Category of
 * warnings about recommended good practices involving SBML and
 * computational modeling.  (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_INTERNAL_CONSISTENCY LIBSBML_CAT_INTERNAL_CONSISTENCY@endlink</td><td>Category of
 * errors that can occur while validating libSBML's internal representation
 * of SBML constructs. (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L2V4_COMPAT LIBSBML_CAT_SBML_L2V4_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;4.</td></tr>
 * <tr><td>@link libsbml#LIBSBML_CAT_SBML_L3V1_COMPAT LIBSBML_CAT_SBML_L3V1_COMPAT@endlink</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;3
 * Version&nbsp;1.</td></tr>
 *
 * </table>
 * </center>
 *
 * @if clike
 * <h3><a class='anchor' name='SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a></h3>
 *
 * This is an enumeration of severity codes for SBMLError diagnostics.
 * User programs receiving an SBMLError object can use this distinction to
 * check whether the error represents a low-level XML problem or an SBML
 * problem.
 *
 * In libSBML version @htmlinclude libsbml-version.html
 * there are no additional severity codes in
 * #SBMLErrorSeverity_t beyond those defined in #XMLErrorSeverity_t.
 *
 * <hr>
 * @endif@if java <h3><a class='anchor'
 * name='SBMLErrorSeverity_t'>Severity codes associated with SBMLError
 * objects</h3>
 *
 * In libSBML version @htmlinclude libsbml-version.html
 * there are no additional severity codes beyond those defined by XMLError.
 * They are implemented as static integer constants defined in the interface
 * class <code><a href='libsbml.libsbml.html'>libsbmlConstants</a></code>,
 * and have names beginning with <code>LIBSBML_SEV_</code>.
 * @endif@if python <h3><a class='anchor'
 * name='SBMLErrorSeverity_t'>Severity codes associated with SBMLError
 * objects</h3>
 *
 * In libSBML version @htmlinclude libsbml-version.html
 * there are no additional severity codes beyond those defined by XMLError.
 * They are implemented as static integer constants defined in the
 * interface class @link libsbml libsbml@endlink, and have names beginning
 * with <code>LIBSBML_SEV_</code>.
 * @endif
 */

public class SBMLError : XMLError {
	private HandleRef swigCPtr;
	
	internal SBMLError(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.SBMLError_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.SBMLErrorUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBMLError obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBMLError obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBMLError() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBMLError(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line, long column, long severity, long category, string package, long pkgVersion) : this(libsbmlPINVOKE.new_SBMLError__SWIG_0(errorId, level, version, details, line, column, severity, category, package, pkgVersion), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line, long column, long severity, long category, string package) : this(libsbmlPINVOKE.new_SBMLError__SWIG_1(errorId, level, version, details, line, column, severity, category, package), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line, long column, long severity, long category) : this(libsbmlPINVOKE.new_SBMLError__SWIG_2(errorId, level, version, details, line, column, severity, category), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line, long column, long severity) : this(libsbmlPINVOKE.new_SBMLError__SWIG_3(errorId, level, version, details, line, column, severity), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line, long column) : this(libsbmlPINVOKE.new_SBMLError__SWIG_4(errorId, level, version, details, line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details, long line) : this(libsbmlPINVOKE.new_SBMLError__SWIG_5(errorId, level, version, details, line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version, string details) : this(libsbmlPINVOKE.new_SBMLError__SWIG_6(errorId, level, version, details), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level, long version) : this(libsbmlPINVOKE.new_SBMLError__SWIG_7(errorId, level, version), true) {
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId, long level) : this(libsbmlPINVOKE.new_SBMLError__SWIG_8(errorId, level), true) {
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError(long errorId) : this(libsbmlPINVOKE.new_SBMLError__SWIG_9(errorId), true) {
  }

  
/**
   * Creates a new SBMLError to report that something occurred during SBML
   * processing.
   *
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an SBMLError object.
   * SBMLError objects have identification numbers to indicate the nature
   * of the exception.  @if clike These numbers are drawn from
   * the enumeration <a class='el'
   * href='#SBMLErrorCode_t'>
   * SBMLErrorCode_t</a>.  @endif@if java These numbers are
   * defined as unsigned integer constants in the file
   * 'libsbml.libsbml.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif@if python These
   * numbers are defined as unsigned integer constants in the interface
   * class @link libsbml libsbml@endlink.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings. @endif The argument
   * @p errorId to this constructor @em can be (but does not have to be) a
   * value from this @if clike enumeration. If it @em is a value
   * from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, the
   * SBMLError class assumes the error is a low-level system or SBML layer
   * error and <em>prepends</em> a built-in, predefined error message to
   * any string passed in the argument @p details to this constructor.  In
   * addition, all <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a> errors have associated
   * values for the @p severity and @p category codes, and these fields are
   * filled-in as well from the enumerations <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>,
   * respectively. @else set of constants.  If it @em
   * is one of the predefined error identifiers, the SBMLError class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument @p details to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the
   * @p severity and @p category codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. @endif
   *
   * If the error identifier @p errorId is a number greater than 99999, the
   * SBMLError class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows SBMLError to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the SBMLError facilities.
   *
   * @if clike As mentioned above, there are two other
   * enumerations, <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, used for indicating
   * the severity and category of error for the predefined SBMLError codes.
   * The values passed in @p severity and @p category override the defaults
   * assigned based on the error code.  If the value of @p errorId is a
   * value from <a class='el' href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>,
   * callers do not need to fill in @p severity and @p category.
   * Conversely, if @p errorId is not a value from <a class='el'
   * href='#SBMLErrorCode_t'>SBMLErrorCode_t</a>, callers can use other
   * values (not just those from <a class='el'
   * href='#SBMLErrorSeverity_t'>SBMLErrorSeverity_t</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>SBMLErrorCategory_t</a>, but their own
   * special values) for @p severity and
   * @p category. @else As mentioned above,
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of @p errorId is one of the standard error
   * codes, callers do not need to fill in @p severity and @p category in a
   * call to this constructor.  Conversely, if @p errorId is not an existing
   * SBML-level error code, callers can use other values for @p severity and
   * @p category. @endif
   *
   * Please see the top of the documentation for SBMLError for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   *
   * @param errorId a long integer, the identification number of the error.
   *
   * @param level the SBML Level of the SBML model
   *
   * @param version the SBML Version within the Level of the SBML model
   *
   * @param details a string containing additional details about the error.
   * If the error code in @p errorId is one that is recognized by SBMLError,
   * the given message is @em appended to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   *
   * @param line a long integer, the line number at which the error occured.
   *
   * @param column a long integer, the column number at which the error occured.
   *
   * @param severity an integer indicating severity of the error.
   *
   * @param category an integer indicating the category to which the error
   * belongs.
   *
   * @param package the SBML Level package involved.
   *
   * @param pkgVersion the version of the @p package.
   *
   * @ifnot hasDefaultArgs @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 SBMLError() : this(libsbmlPINVOKE.new_SBMLError__SWIG_10(), true) {
  }

  
/**
   * Copy constructor; creates a copy of this SBMLError.
   */ public
 SBMLError(SBMLError orig) : this(libsbmlPINVOKE.new_SBMLError__SWIG_11(SBMLError.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
