# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.6
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package LibSBML;
use base qw(Exporter);
use base qw(DynaLoader);
package LibSBMLc;
bootstrap LibSBML;
package LibSBML;
@EXPORT = qw();
=head1 NAME

LibSBML  -- interface to the libSBML library

=head1 SYNOPSIS

  # Change the following path to wherever your copy is installed.
  use lib '/usr/local/lib/perl5/site_perl';

  use File::Spec;
  use LibSBML;
  use strict;

  my $file     = File::Spec->rel2abs('FOO.xml');
  my $rd       = new LibSBML::SBMLReader;
  my $document = $rd->readSBML($file);
  
  # Check for reading errors:
  my $errors   = $document->getNumErrors();

  # Print errors, if any, to stderr.
  if ($errors > 0) {
    $document->printErrors();
    die "Errors while reading $file";
  }

  my $model = $document->getModel() || die "No Model found in $file";
  ... 

=head1 DESCRIPTION

The LibSBML.pm package gives access to almost all functions in libSBML
(http://sbml.org). The Perl wrapper is generated using SWIG
http://www.swig.org/ with relatively little manual intervention.  


=head1 AUTHORS

 Christoph Flamm <xtof@tbi.univie.ac.at>
 Rainer Machne   <raim@tbi.univie.ac.at>

=head1 FUNCTION INDEX

=over 8

=item getLibSBMLVersion

Returns the version number of this copy of libSBML as an integer.
Returns the libSBML version as an integer; version 1.2.3 becomes 10203.


=item getLibSBMLDottedVersion

Returns the version number of this copy of libSBML as a string.
Returns the libSBML version as a string; version 1.2.3 becomes
"1.2.3".

@see getLibSBMLVersionString()


=item getLibSBMLVersionString

Returns the version number of this copy of libSBML as a string without
periods.

Returns the libSBML version as a string: version 1.2.3 becomes "10203".
@see getLibSBMLDottedVersion()


=back

=head2 SBMLReader

Methods for reading SBML from files and text strings.
@htmlinclude not-sbml-warning.html
The SBMLReader class provides the main interface for reading SBML
content from files and strings.  The methods for reading SBML all return
an SBMLDocument object representing the results.
In the case of failures (such as if the SBML contains errors or a file
cannot be read), the errors will be recorded with the SBMLErrorLog
object kept in the SBMLDocument returned by SBMLReader.  Consequently,
immediately after calling a method on SBMLReader, callers should always
check for errors and warnings using the methods for this purpose
provided by SBMLDocument.
For convenience as well as easy access from other languages besides C++,
this file also defines two global functions,
libsbml::readSBML(@if java String filename@endif)
and libsbml::readSBMLFromString(@if java String xml@endif).
They are equivalent to creating an SBMLReader
object and then calling the
SBMLReader::readSBML(@if java String filename@endif) or
SBMLReader::readSBMLFromString(@if java String xml@endif)
methods, respectively.
@section compression Support for reading compressed files
LibSBML provides support for reading (as well as writing) compressed
SBML files.  The process is transparent to the calling
application&mdash;the application does not need to do anything
deliberate to invoke the functionality.  If a given SBML filename ends
with an extension for the I<gzip>, I<zip> or I<bzip2> compression
formats (respectively, @c .gz, @c .zip, or @c .bz2), then the methods
SBMLReader::readSBML(@if java String filename@endif) and
SBMLWriter::writeSBML(@if java SBMLDocument d, String filename@endif)
will automatically decompress and compress the file while writing and
reading it.  If the filename has no such extension, it
will be read and written uncompressed as normal.
The compression feature requires that the I<zlib> (for I<gzip> and @em
zip formats) and/or I<bzip2> (for I<bzip2> format) be available on the
system running libSBML, and that libSBML was configured with their
support compiled-in.  Please see the libSBML @if clike <a href="libsbml-installation.html">installation instructions</a> @endif@if python <a href="libsbml-installation.html">installation instructions</a> @endif@if java  <a href="../../../libsbml-installation.html">installation instructions</a> @endif@~ for more information about this.  The methods
@if java SBMLReader::hasZlib()@else hasZlib()@endif@~ and
@if java SBMLReader::hasBzip2()@else hasBzip2()@endif@~
can be used by an application to query at run-time whether support
for the compression libraries is available in the present copy of
libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.

=over


=item SBMLReader::SBMLReader

Creates a new SBMLReader and returns it. 
The libSBML SBMLReader objects offer methods for reading SBML in
XML form from files and text strings.


=item SBMLReader::readSBML

Reads an SBML document from a file.
This method is identical to SBMLReader::readSBMLFromFile(@if java String filename@endif).
If the file named C<filename> does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument::getNumErrors() and
SBMLDocument::getError(@if java long n@endif) to get the errors.  The object returned by
SBMLDocument::getError(@if java long n@endif) is an SBMLError object, and it has methods to
get the error code, category, and severity level of the problem, as
well as a textual description of the problem.  The possible severity
levels range from informational messages to fatal errors; see the
documentation for SBMLError for more information.
If the file C<filename> could not be read, the file-reading error will
appear first.  The error code @if clike (a value drawn from the enumeration
#XMLErrorCode_t) @endif@~ can provide a clue about what happened.  For example,
a file might be unreadable (either because it does not actually exist
or because the user does not have the necessary access priviledges to
read it) or some sort of file operation error may have been reported
by the underlying operating system.  Callers can check for these
situations using a program fragment such as the following:
@if clike
@verbatim
SBMLReader reader;
SBMLDocument  doc  = reader.readSBMLFromFile(filename);
if (doc->getNumErrors() E<gt> 0)
{
if (doc->getError(0)->getErrorId() == XMLError::XMLFileUnreadable)
{
// Handle case of unreadable file here.
} 
else if (doc->getError(0)->getErrorId() == XMLError::XMLFileOperationError)
{
// Handle case of other file operation error here.
}
else
{
// Handle other cases -- see error codes defined in XMLErrorCode_t
// for other possible cases to check.
}
}
@endverbatim
@endif@if java
@verbatim
SBMLReader reader = new SBMLReader();
SBMLDocument doc  = reader.readSBMLFromFile(filename);
if (doc.getNumErrors() E<gt> 0)
{
if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileUnreadable)
{
// Handle case of unreadable file here.
} 
else if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileOperationError)
{
// Handle case of other file operation error here.
}
else
{
// Handle other error cases.
}
}
@endverbatim
@endif@if python
@verbatim
reader = SBMLReader()
doc    = reader.readSBMLFromFile(filename)
if doc.getNumErrors() E<gt> 0:
if doc.getError(0).getErrorId() == libsbml.XMLFileUnreadable:
# Handle case of unreadable file here.
elif doc.getError(0).getErrorId() == libsbml.XMLFileOperationError:
# Handle case of other file error here.
else:
# Handle other error cases here.
@endverbatim
@endif@if csharp
@verbatim
SBMLReader reader = new SBMLReader();
SBMLDocument doc = reader.readSBMLFromFile(filename);
if (doc.getNumErrors() E<gt> 0)
{
if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileUnreadable)
{
// Handle case of unreadable file here.
}
else if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileOperationError)
{
// Handle case of other file operation error here.
}
else
{
// Handle other cases -- see error codes defined in XMLErrorCode_t
// for other possible cases to check.
}
}
@endverbatim
@endif@~
If the given filename ends with the suffix C<">.gz" (for example, @c
"myfile.xml.gz"), the file is assumed to be compressed in I<gzip>
format and will be automatically decompressed upon reading.
Similarly, if the given filename ends with C<">.zip" or C<">.bz2", the
file is assumed to be compressed in I<zip> or I<bzip2> format
(respectively).  Files whose names lack these suffixes will be read
uncompressed.  Note that if the file is in I<zip> format but the
archive contains more than one file, only the first file in the
archive will be read and the rest ignored.
@htmlinclude note-reading-zipped-files.html
@param filename the name or full pathname of the file to be read.
Returns a pointer to the SBMLDocument created from the SBML content.
@note LibSBML versions 2.x and later versions behave differently in
error handling in several respects.  One difference is how early some
errors are caught and whether libSBML continues processing a file in
the face of some early errors.  In general, libSBML versions after 2.x
stop parsing SBML inputs sooner than libSBML version 2.x in the face
of XML errors, because the errors may invalidate any further SBML
content.  For example, a missing XML declaration at the beginning of
the file was ignored by libSBML 2.x but in version 3.x and later, it
will cause libSBML to stop parsing the rest of the input altogether.
While this behavior may seem more severe and intolerant, it was
necessary in order to provide uniform behavior regardless of which
underlying XML parser (Expat, Xerces, libxml2) is being used by
libSBML.  The XML parsers themselves behave differently in their error
reporting, and sometimes libSBML has to resort to the lowest common
denominator.

@see SBMLError


=item SBMLReader::readSBMLFromFile

Reads an SBML document from a file.
This method is identical to SBMLReader::readSBML(@if java String filename@endif).
If the file named C<filename> does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument::getNumErrors() and
SBMLDocument::getError(@if java long n@endif) to get the errors.  The object returned by
SBMLDocument::getError(@if java long n@endif) is an SBMLError object, and it has methods to
get the error code, category, and severity level of the problem, as
well as a textual description of the problem.  The possible severity
levels range from informational messages to fatal errors; see the
documentation for SBMLError for more information.
If the file C<filename> could not be read, the file-reading error will
appear first.  The error code @if clike (a value drawn from the enumeration
#XMLErrorCode_t)@endif@~ can provide a clue about what happened.  For example,
a file might be unreadable (either because it does not actually exist
or because the user does not have the necessary access priviledges to
read it) or some sort of file operation error may have been reported
by the underlying operating system.  Callers can check for these
situations using a program fragment such as the following:
@if clike
@verbatim
SBMLReader  reader = new SBMLReader();
SBMLDocument  doc  = reader.readSBML(filename);
if (doc->getNumErrors() E<gt> 0)
{
if (doc->getError(0)->getErrorId() == XMLError::FileUnreadable)
{
// Handle case of unreadable file here.
} 
else if (doc->getError(0)->getErrorId() == XMLError::FileOperationError)
{
// Handle case of other file operation error here.
}
else
{
// Handle other cases -- see error codes defined in XMLErrorCode_t
// for other possible cases to check.
}
}
@endverbatim
@endif@if java
@verbatim
SBMLReader reader = new SBMLReader();
SBMLDocument doc  = reader.readSBMLFromFile(filename);
if (doc.getNumErrors() E<gt> 0)
{
if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileUnreadable)
{
// Handle case of unreadable file here.
} 
else if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileOperationError)
{
// Handle case of other file operation error here.
}
else
{
// Handle other error cases.
}
}
@endverbatim
@endif@if python
@verbatim
reader = SBMLReader()
doc    = reader.readSBMLFromFile(filename)
if doc.getNumErrors() E<gt> 0:
if doc.getError(0).getErrorId() == libsbml.XMLFileUnreadable:
# Handle case of unreadable file here.
elif doc.getError(0).getErrorId() == libsbml.XMLFileOperationError:
# Handle case of other file error here.
else:
# Handle other error cases here.
@endverbatim
@endif@~
If the given filename ends with the suffix C<">.gz" (for example, @c
"myfile.xml.gz"), the file is assumed to be compressed in I<gzip>
format and will be automatically decompressed upon reading.
Similarly, if the given filename ends with C<">.zip" or C<">.bz2", the
file is assumed to be compressed in I<zip> or I<bzip2> format
(respectively).  Files whose names lack these suffixes will be read
uncompressed.  Note that if the file is in I<zip> format but the
archive contains more than one file, only the first file in the
archive will be read and the rest ignored.
@htmlinclude note-reading-zipped-files.html
@param filename the name or full pathname of the file to be read.
Returns a pointer to the SBMLDocument created from the SBML content.
@note LibSBML versions 2.x and later versions behave differently in
error handling in several respects.  One difference is how early some
errors are caught and whether libSBML continues processing a file in
the face of some early errors.  In general, libSBML versions after 2.x
stop parsing SBML inputs sooner than libSBML version 2.x in the face
of XML errors, because the errors may invalidate any further SBML
content.  For example, a missing XML declaration at the beginning of
the file was ignored by libSBML 2.x but in version 3.x and later, it
will cause libSBML to stop parsing the rest of the input altogether.
While this behavior may seem more severe and intolerant, it was
necessary in order to provide uniform behavior regardless of which
underlying XML parser (Expat, Xerces, libxml2) is being used by
libSBML.  The XML parsers themselves behave differently in their error
reporting, and sometimes libSBML has to resort to the lowest common
denominator.

@see SBMLError
@see SBMLDocument


=item SBMLReader::readSBMLFromString

Reads an SBML document from the given XML string.
This method is flexible with respect to the presence of an XML
declaration at the beginning of the string.  In particular, if the
string in C<xml> does not begin with the XML declaration
C<&lt;?xml version='1.0' encoding='UTF-8'?&gt;>, then this
method will automatically prepend the declaration to C<xml>.
This method will log a fatal error if the content given in the
parameter C<xml> is not SBML.  See the method documentation for
SBMLReader::readSBML(@if java String filename@endif)
for an example of code for testing the returned error code.
@param xml a string containing a full SBML model
Returns a pointer to the SBMLDocument created from the SBML content.
@see SBMLReader::readSBML(@if java String filename@endif)


=item SBMLReader::hasZlib

Static method; returns C<true> if this copy of libSBML supports
<i>gzip</I> and <i>zip</i> format compression.
Returns C<true> if libSBML has been linked with the <i>zlib</i>
library, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLReader), and the other
will be a standalone top-level function with the name
SBMLReader_hasZlib(). They are functionally identical. @endif@~
@see @if clike hasBzip2() @else SBMLReader::hasBzip2() @endif@~


=item SBMLReader::hasBzip2

Static method; returns C<true> if this copy of libSBML supports
<i>bzip2</i> format compression.
Returns C<true> if libSBML is linked with the <i>bzip2</i>
libraries, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLReader), and the other
will be a standalone top-level function with the name
SBMLReader_hasBzip2(). They are functionally identical. @endif@~
@see @if clike hasZlib() @else SBMLReader::hasZlib() @endif@~


=item SBMLReader::readInternal

@internal

Used by readSBML() and readSBMLFromString().
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item readSBML

Reads an SBML document from the given file C<filename>.
If C<filename> does not exist, or it is not an SBML file, an error will
be logged in the error log of the SBMLDocument object returned by this
method.  Calling programs can inspect this error log to determine
the nature of the problem.  Please refer to the definition of
SBMLDocument for more information about the error reporting mechanism.
Returns a pointer to the SBMLDocument read.


=item readSBMLFromFile

Reads an SBML document from the given file C<filename>.
If C<filename> does not exist, or it is not an SBML file, an error will
be logged in the error log of the SBMLDocument object returned by this
method.  Calling programs can inspect this error log to determine
the nature of the problem.  Please refer to the definition of
SBMLDocument for more information about the error reporting mechanism.
Returns a pointer to the SBMLDocument read.


=item readSBMLFromString

Reads an SBML document from a string assumed to be in XML format.
If the string does not begin with XML declaration,
@verbatim
<?xml version='1.0' encoding='UTF-8'?>
@endverbatim
an XML declaration string will be prepended.
This method will report an error if the given string C<xml> is not SBML.
The error will be logged in the error log of the SBMLDocument object
returned by this method.  Calling programs can inspect this error log to
determine the nature of the problem.  Please refer to the definition of
SBMLDocument for more information about the error reporting mechanism.
Returns a pointer to the SBMLDocument read.


=back

=head2 SBMLWriter

Methods for writing SBML to files and text strings.
@htmlinclude not-sbml-warning.html
The SBMLWriter class is the converse of SBMLReader, and provides the
main interface for serializing SBML models into XML and writing the
result to files and text strings.  The methods for writing SBML all take
an SBMLDocument object and a destination.  They return a boolean or
integer value to indicate success or failure.
@section compression Support for writing compressed files
LibSBML provides support for writing (as well as reading) compressed
SBML files.  The process is transparent to the calling
application&mdash;the application does not need to do anything
deliberate to invoke the functionality.  If a given SBML filename ends
with an extension for the I<gzip>, I<zip> or I<bzip2> compression
formats (respectively, C<&quot;.gz&quot;>,
C<&quot;.zip&quot;>, or C<&quot;.bz2&quot;>),
then the methods
SBMLWriter::writeSBML(@if java SBMLDocument d, String filename@endif)
and SBMLReader::readSBML(@if java String filename@endif)
will automatically compress and decompress the file while writing and
reading it.  If the filename has no such extension, it
will be written and read uncompressed as normal.
The compression feature requires that the I<zlib> (for I<gzip> and @em
zip formats) and/or I<bzip2> (for I<bzip2> format) be available on the
system running libSBML, and that libSBML was configured with their
support compiled-in.  Please see the libSBML @if clike <a href="libsbml-installation.html">installation instructions</a>@endif@if python <a href="libsbml-installation.html">installation instructions</a>@endif@if java  <a href="../../../libsbml-installation.html">installation instructions</a>@endif@~ for 
more information about this.  The methods
SBMLWriter::hasZlib() and
SBMLWriter::hasBzip2()
can be used by an application to query at run-time whether support
for the compression libraries is available in the present copy of
libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.

=over


=item SBMLWriter::SBMLWriter

Creates a new SBMLWriter.
The libSBML SBMLWriter objects offer methods for writing SBML in
XML form to files and text strings.


=item SBMLWriter::setProgramName

Sets the name of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program name and version are set (see
SBMLWriter::setProgramVersion(@if java String version@endif)), the
following XML comment, intended for human consumption, will be written
at the beginning of the XML document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->
@endverbatim

If the program name and version are not set at some point before
calling the writeSBML() methods, no such comment is written out.
@param name the name of this program (where "this program" refers to
program in which libSBML is embedded, not libSBML itself!)
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see setProgramVersion(const std::string& version)


=item SBMLWriter::setProgramVersion

Sets the version of this program, i.e., the program that is about to
write out the SBMLDocument.
If the program version and name are set (see
SBMLWriter::setProgramName(@if java String name@endif)), the
following XML comment, intended for human consumption, will be written
at the beginning of the document:
@verbatim
<!-- Created by <program name> version <program version>
on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->
@endverbatim

If the program version and name are not set at some point before
calling the writeSBML() methods, no such comment is written out.
@param version the version of this program (where "this program"
refers to program in which libSBML is embedded, not libSBML itself!)
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBML

Writes the given SBML document to filename.
@htmlinclude assuming-compressed-file.html
@param d the SBML document to be written
@param filename the name or full pathname of the file where the SBML
is to be written. 
Returns C<true> on success and C<false> if the filename could not be
opened for writing.
@note @htmlinclude note-writing-zipped-files.html
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBML

Writes the given SBML document to the output stream.
@param d the SBML document to be written
@param stream the stream object where the SBML is to be written.
Returns C<true> on success and C<false> if one of the underlying
parser components fail (rare).
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeToString

@internal

Writes the given SBML document to an in-memory string and returns a
pointer to it.
The string is owned by the caller and should be freed (with C<free>())
when no longer needed.
@param d the SBML document to be written
Returns the string on success and C<0> if one of the underlying parser
components fail.
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBMLToFile

Writes the given SBML document to filename.
@htmlinclude assuming-compressed-file.html
@param d the SBML document to be written
@param filename the name or full pathname of the file where the SBML
is to be written. 
Returns C<true> on success and C<false> if the filename could not be
opened for writing.
@note @htmlinclude note-writing-zipped-files.html
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::writeSBMLToString

Writes the given SBML document to an in-memory string and returns a
pointer to it.
The string is owned by the caller and should be freed (with C<free>())
when no longer needed.
@param d the SBML document to be written
Returns the string on success and C<0> if one of the underlying parser
components fail.
@see setProgramVersion(const std::string& version)
@see setProgramName(const std::string& name)


=item SBMLWriter::hasZlib

Predicate returning C<true> if this copy of libSBML has been linked
with the <em>zlib</em> library.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLWriter), and the other
will be a standalone top-level function with the name
SBMLWriter_hasZlib(). They are functionally identical. @endif@~
Returns C<true> if libSBML is linked with zlib, C<false> otherwise.
@see @if clike hasBzip2() @else SBMLWriter::hasBzip2() @endif@~


=item SBMLWriter::hasBzip2

Predicate returning C<true> if this copy of libSBML has been linked
with the <em>bzip2</em> library.
LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLWriter), and the other
will be a standalone top-level function with the name
SBMLWriter_hasZlib(). They are functionally identical. @endif@~
Returns C<true> if libSBML is linked with bzip2, C<false> otherwise.
@see @if clike hasZlib() @else SBMLWriter::hasZlib() @endif@~


=item writeSBML

Writes the given SBML document C<d> to the file named by C<filename>.
This function is identical to @if clike SBMLWriter::writeSBMLToFile (const SBMLDocument_t  d, const char  filename)@endif@if java <a href="#writeSBMLToFile(org.sbml.libsbml.SBMLDocument, java.lang.String)">C<writeSBMLToFile(SBMLDocument d, String filename)></a>@endif.
@htmlinclude assuming-compressed-file.html
@param d the SBMLDocument object to be written out in XML format
@param filename a string giving the path to a file where the XML
content is to be written.
Returns C<1> on success and C<0> (zero) if C<filename> could not be
written.  Some possible reasons for failure include (a) being unable to
open the file, and (b) using a filename that indicates a compressed SBML
file (i.e., a filename ending in C<&quot;.zip&quot;> or
similar) when the compression functionality has not been enabled in
the underlying copy of libSBML.
@if clike @warning Note that the string is owned by the caller and
should be freed (with the normal string C<free()> C++
function) after it is no longer needed.@endif@~
@see SBMLWriter::hasZlib()
@see SBMLWriter::hasBzip2()


=item writeSBMLToString

Writes the given SBML document C<d> to an in-memory string and
returns the string.
This is a convenience function that uses the
SBMLWriter::writeSBMLToString(const SBMLDocument  d) method internally,
yet does not require the caller to create an SBMLWriter object first.
@param d an SBMLDocument object to be written out in XML format
Returns the string on success and C<NULL> if one of the underlying parser
components fail.
@if clike @warning Note that the string is owned by the caller and
should be freed (with the normal string C<free()> C++
function) after it is no longer needed.@endif@~


=item writeSBMLToFile

Writes the given SBML document C<d> to the file C<filename>.
This is a convenience function that uses the
SBMLWriter::writeSBMLToFile(const SBMLDocument  d, const std::string&
filename) method internally, yet does not require the caller to create
an SBMLWriter object first.
@htmlinclude assuming-compressed-file.html
@param d an SBMLDocument object to be written out in XML format
@param filename a string giving the path to a file where the XML
content is to be written.
Returns C<1> on success and C<0> (zero) if C<filename> could not be
written.  Some possible reasons for failure include (a) being unable to
open the file, and (b) using a filename that indicates a compressed SBML
file (i.e., a filename ending in C<&quot;.zip&quot;> or
similar) when the compression functionality has not been enabled in
the underlying copy of libSBML.
@if clike @warning Note that the string is owned by the caller and
should be freed (with the normal string C<free()> C++
function) after it is no longer needed.@endif@~
@see SBMLWriter::hasZlib()
@see SBMLWriter::hasBzip2()


=item SBMLTypeCode_toString

This method takes an SBML type code and returns a string representing
the code.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns a human readable name for the given
@if clike #SBMLTypeCode_t value@else SBML type code@endif.
@note The caller does not own the returned string and is therefore not
allowed to modify it.


=back

=head2 SBase

LibSBML implementation of SBase, the base class of most SBML objects.
Most components in SBML are derived from a single abstract base type,
SBase.  In addition to serving as the parent class for most other
classes of objects in SBML, this base type is designed to allow a
modeler or a software package to attach arbitrary information to each
major element or list in an SBML model.
SBase has an optional subelement called "notes".  It is intended to
serve as a place for storing optional information intended to be seen by
humans.  An example use of the "notes" element would be to contain
formatted user comments about the model element in which the "notes"
element is enclosed.  There are certain conditions on the XHTML content
permitted inside the "notes" element; please consult the <a
target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for "notes"
content.

SBase has another optional subelement called "annotation".  Whereas the
"notes" element described above is a container for content to be shown
directly to humans, the "annotation" element is a container for optional
software-generated content I<not> meant to be shown to humans.  The
element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary data content.  SBML places
only a few restrictions on the organization of the content; these are
intended to help software tools read and write the data as well as help
reduce conflicts between annotations added by different tools.  As is
the case with "notes", it is important to refer to the <a
target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for
"annotation" content.
It is worth pointing out that the "annotation" element in the definition
of SBase exists in order that software developers may attach optional
application-specific data to the elements in an SBML model.  However, it
is important that this facility not be misused.  In particular, it is
<em>critical</em> that data essential to a model definition or that can
be encoded in existing SBML elements is <em>not</em> stored in
"annotation". Parameter values, functional dependencies between model
elements, etc., should not be recorded as annotations.  It is crucial to
keep in mind the fact that data placed in annotations can be freely
ignored by software applications.  If such data affects the
interpretation of a model, then software interoperability is greatly
impeded.

SBML Level 2 introduced an optional SBase attribute named "metaid" for
supporting metadata annotations using RDF (<a target="_blank"
href="http://www.w3.org/RDF/">Resource Description Format</a>). The
attribute value has the data type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML identifier
type, which means each "metaid" value must be globally unique within an
SBML file.  (Importantly, this uniqueness criterion applies across any
attribute with type <a href="http://www.w3.org/TR/REC-xml/#id">XML
ID</a>, not just the "metaid" attribute used by SBML&mdash;something to
be aware of if your application-specific XML content inside the
"annotation" subelement happens to use <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)  The "metaid" value
serves to identify a model component for purposes such as referencing
that component from metadata placed within "annotation" subelements.
Beginning with SBML Level 2 Version 3, SBase also has an optional
attribute named "sboTerm" for supporting the use of the Systems Biology
Ontology.  In SBML proper, the data type of the attribute is a string of
the form "SBO:NNNNNNN", where "NNNNNNN" is a seven digit integer number;
libSBML simplifies the representation by only storing the "NNNNNNN"
integer portion.  Thus, in libSBML, the "sboTerm" attribute on SBase has
data type C<int>, and SBO identifiers are stored simply as integers.
(For convenience, SBase offers methods for returning both the integer
form and a text-string form of the SBO identifier.)  SBO terms are a
type of optional annotation, and each different class of SBML object
derived from SBase imposes its own requirements about the values
permitted for "sboTerm".  Please consult the SBML Level&nbsp;2
Version&nbsp;4 specification for more information about the use of SBO
and the "sboTerm" attribute.
Finally, note that, in the list of methods on SBase, there is no public
constructor because SBase is an abstract class.  The constructors reside
in the subclasses derived from SBase.
@section sbase-miriam Standard format for annotations linking data resources
SBML Level 2 Versions 2, 3 and 4, and Level&nbsp;3, define a proposed
regular format for encoding two particular categories of annotations:
(a) references to controlled vocabulary terms and database identifiers
which define and describe biological and biochemical entities in a
model; and (b) descriptions of the provenance of a model, including its
author(s) and modification history.

=over


=item SBase::accept

Accepts the given SBMLVisitor for this SBase object.
@param v the SBMLVisitor instance to be used
Returns the result of calling C<v.visit()>.


=item SBase::clone

Creates and returns a deep copy of this SBase object.
Returns a (deep) copy of this SBase object.


=item SBase::getElementBySId

Returns the first child element found that has the given C<id> in the
model-wide C<SId> namespace, or C<NULL> if no such object is found.
@param id string representing the "id" attribute value of the object
to find.
Returns pointer to the first element found with the given identifier.


=item SBase::getElementByMetaId

Returns the first child element it can find with a specific "metaid"
attribute value, or C<NULL> if no such object is found.
@param metaid string representing the "metaid" attribute value of the
object to find.
Returns pointer to the first element found with the given meta-identifier.


=item SBase::getAllElements

Returns a List of all child SBase objects, including those nested to
an arbitrary depth.
Returns a pointer to a List of pointers to all children objects.


=item SBase::renameSIdRefs

Renames all the C<SIdRef> attributes on this element, including any
found in MathML content (if such exists).
This method works by looking at all attributes and (if appropriate)
mathematical formulas, comparing the identifiers to the value of @p
oldid.  If any matches are found, the matching identifiers are replaced
with C<newid>.  The method does I<not> descend into child elements.
@param oldid the old identifier
@param newid the new identifier


=item SBase::renameMetaIdRefs

Renames all the C<MetaIdRef> attributes on this element.
This method works by looking at all meta-attribute values, comparing
the identifiers to the value of C<oldid>.  If any matches are found,
the matching identifiers are replaced with C<newid>.  The method does
I<not> descend into child elements.
@param oldid the old identifier
@param newid the new identifier


=item SBase::renameUnitSIdRefs

Renames all the C<UnitSIdRef> attributes on this element.
This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing the
unit identifiers to the value of C<oldid>.  If any matches are found,
the matching identifiers are replaced with C<newid>.  The method does
I<not> descend into child elements.
@param oldid the old identifier
@param newid the new identifier


=item SBase::replaceSIDWithFunction

@internal

If this object has a child 'math' object (or anything with ASTNodes in
general), replace all nodes with the name 'id' with the provided
function.

@note This function does nothing itself&mdash;subclasses with ASTNode
subelements must override this function.


=item SBase::divideAssignmentsToSIdByFunction

@internal

If the function of this object is to assign a value has a child 'math'
object (or anything with ASTNodes in general), replace the 'math'
object with the function (existing/function).
@note This function does nothing itself&mdash;subclasses with ASTNode
subelements must override this function.


=item SBase::multiplyAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing function).


=item SBase::getElementFromPluginsBySId

@internal

Returns the first child element found that has the given id in the
model-wide SId namespace from all plug-ins associated with this
element, or C<NULL> if no such object is found.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item SBase::getElementFromPluginsByMetaId

@internal

Returns the first child element it can find with the given metaid from
all plug-ins associated with this element, or C<NULL> if no such object
is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item SBase::hasNonstandardIdentifierBeginningWith

@internal

Check to see if the given prefix is used by any of the IDs defined by
extension elements  excluding  'id' and 'metaid' attributes (as, for
example, the spatial id attributes 'spid').


=item SBase::prependStringToAllIdentifiers

@internal

Add the given string to all identifiers in the object.  If the string
is added to anything other than an id or a metaid, this code is
responsible for tracking down and renaming all  idRefs in the package
extention that identifier comes from.


=item SBase::getAllElementsFromPlugins

Returns a List of all child SBase objects contained in SBML package
plug-ins.

This method walks down the list of all packages used by the enclosing
Model and returns all objects contained in them.
Returns a pointer to a List of pointers to all children objects from
plug-ins.


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this object.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format). The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model
component for purposes such as referencing that component from
metadata placed within "annotation" subelements.
Returns the meta-identifier of this SBML object.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getMetaId

Returns the value of the "metaid" attribute of this object.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model
component for purposes such as referencing that component from
metadata placed within "annotation" subelements.
Returns the meta-identifier of this SBML object, as a string.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getId

@internal

Returns the value of the "metaid" attribute of this object.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model
component for purposes such as referencing that component from
metadata placed within "annotation" subelements.
Returns the meta-identifier of this SBML object, as a string.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getName

@internal

Returns the value of the "metaid" attribute of this object.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model
component for purposes such as referencing that component from
metadata placed within "annotation" subelements.
Returns the meta-identifier of this SBML object, as a string.
@see isSetMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::getNotes

Returns the content of the "notes" subelement of this object as
a tree of XMLNode objects.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
The "notes" element content returned by this method will be in XML
form, but libSBML does not provide an object model specifically for
the content of notes.  Callers will need to traverse the XML tree
structure using the facilities available on XMLNode and related
objects.  For an alternative method of accessing the notes, see
getNotesString().

Returns the content of the "notes" subelement of this SBML object as a
tree structure composed of XMLNode objects.
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::getNotesString

Returns the content of the "notes" subelement of this object as a
string.

The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
For an alternative method of accessing the notes, see getNotes(),
which returns the content as an XMLNode tree structure.  Depending on
an application's needs, one or the other method may be more
convenient.

Returns the content of the "notes" subelement of this SBML object as a
string.

@see getNotes()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::getAnnotation

Returns the content of the "annotation" subelement of this object as
a tree of XMLNode objects.
Whereas the SBML "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
The annotations returned by this method will be in XML form.  LibSBML
provides an object model and related interfaces for certain specific
kinds of annotations, namely model history information and RDF
content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
for more information about the facilities available.
Returns the annotation of this SBML object as a tree of XMLNode objects.
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getAnnotationString

Returns the content of the "annotation" subelement of this object as a
character string.
Whereas the SBML "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
The annotations returned by this method will be in string form.
Returns the annotation of this SBML object as a character string.
@see getAnnotation()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::getNamespaces

Returns a list of the XML Namespaces declared on this SBML document.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in SBML Level&nbsp;3) packages used in addition to SBML Level&nbsp;3
Core.

Returns the XML Namespaces associated with this SBML object
@see getLevel()
@see getVersion()


=item SBase::getSBMLDocument

Returns the SBMLDocument object containing I<this> object instance.
LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
<i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
specifications, but it does not have a direct correspondence in SBML
Level&nbsp;1.  (But, it is created by libSBML no matter whether the
model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
This method allows the caller to obtain the SBMLDocument for the
current object.
Returns the parent SBMLDocument object of this SBML object.
@see getParentSBMLObject()
@see getModel()


=item SBase::getSBMLDocument

Returns the SBMLDocument object containing I<this> object instance.
LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
<i>SBML</i> defined in the SBML Level&nbsp;3 and Level&nbsp;2
specifications, but it does not have a direct correspondence in SBML
Level&nbsp;1.  (But, it is created by libSBML no matter whether the
model is Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)
This method allows the caller to obtain the SBMLDocument for the
current object.
Returns the parent SBMLDocument object of this SBML object.
@see getParentSBMLObject()
@see getModel()


=item SBase::getParentSBMLObject

Returns the parent SBML object containing this object.
This returns the immediately-containing object.  This method is
convenient when holding an object nested inside other objects in an
SBML model.  
Returns the parent SBML object of this SBML object.
@see getSBMLDocument()
@see getModel()


=item SBase::getParentSBMLObject

Returns the parent SBML object containing this object.
This returns the immediately-containing object.  This method is
convenient when holding an object nested inside other objects in an
SBML model.  
Returns the parent SBML object of this SBML object.
@see getSBMLDocument()
@see getModel()


=item SBase::getAncestorOfType

Returns the first ancestor object that has the given SBML type code.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
This method searches the tree of objects that are parents of this
object, and returns the first one that has the given SBML type code.
If the optional argument C<pkgName> is given, it will cause the search
to be limited to the SBML Level&nbsp;3 package given.
@param type the SBML type code of the object sought
@param pkgName (optional) the short name of an SBML Level&nbsp;3
package to which the sought-after object must belong
Returns the ancestor SBML object of this SBML object that corresponds
to the given @if clike #SBMLTypeCode_t value@else SBML object type
code@endif, or C<NULL> if no ancestor exists.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getAncestorOfType

Returns the first ancestor object that has the given SBML type code.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
This method searches the tree of objects that are parents of this
object, and returns the first one that has the given SBML type code.
If the optional argument C<pkgName> is given, it will cause the search
to be limited to the SBML Level&nbsp;3 package given.
@param type the SBML type code of the object sought
@param pkgName (optional) the short name of an SBML Level&nbsp;3
package to which the sought-after object must belong
Returns the ancestor SBML object of this SBML object that corresponds
to the given @if clike #SBMLTypeCode_t value@else SBML object type
code@endif, or C<NULL> if no ancestor exists.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getSBOTerm

Returns the integer portion of the value of the "sboTerm" attribute of
this object.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  (For convenience, libSBML offers
methods for returning both the integer form and a text-string form of
the SBO identifier.)
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
Returns the value of the "sboTerm" attribute as an integer, or C<-1>
if the value is not set.


=item SBase::getSBOTermID

Returns the string representation of the "sboTerm" attribute of
this object.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  This method returns the entire SBO
identifier as a text string in the form "SBO:NNNNNNN".
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
Returns the value of the "sboTerm" attribute as a string (its value
will be of the form "SBO:NNNNNNN"), or an empty string if
the value is not set.


=item SBase::getSBOTermAsURL

Returns the identifiers.org URL representation of the "sboTerm" attribute of
this object.
This method returns the entire SBO
identifier as a text string in the form 
"http://identifiers.org/biomodels.sbo/SBO:NNNNNNN".

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
Returns the value of the "sboTerm" attribute as an identifiers.org URL
(its value will be of the form 
"http://identifiers.org/biomodels.sbo/SBO:NNNNNNN"), or an empty string if
the value is not set.


=item SBase::getLine

Returns the line number on which this object first appears in the XML
representation of the SBML document.
Returns the line number of this SBML object.
@note The line number for each construct in an SBML model is set upon
reading the model.  The accuracy of the line number depends on the
correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real line number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of <a target="_blank"
href="http://xmlsoft.org">libxml2</a>, <a target="_blank"
href="http://expat.sourceforge.net/">Expat</a> and <a target="_blank"
href="http://xerces.apache.org/xerces-c/">Xerces</a>.)

@see getColumn()


=item SBase::getColumn

Returns the column number on which this object first appears in the XML
representation of the SBML document.
Returns the column number of this SBML object.
@note The column number for each construct in an SBML model is set
upon reading the model.  The accuracy of the column number depends on
the correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real column number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of <a target="_blank"
href="http://xmlsoft.org">libxml2</a>, <a target="_blank"
href="http://expat.sourceforge.net/">Expat</a> and <a target="_blank"
href="http://xerces.apache.org/xerces-c/">Xerces</a>.)

@see getLine()


=item SBase::getModelHistory

Returns the ModelHistory object, if any, attached to this object.
Returns the ModelHistory object attached to this object, or C<NULL> if
none exist.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::getModelHistory

Returns the ModelHistory object, if any, attached to this object.
Returns the ModelHistory object attached to this object, or C<NULL> if
none exist.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::isSetMetaId

Predicate returning C<true> if this object's "metaid" attribute is set.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format). The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model component for purposes
such as referencing that component from metadata placed within
"annotation" subelements.
Returns C<true> if the "metaid" attribute of this SBML object is
set, C<false> otherwise.
@see getMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::isSetId

@internal

Predicate returning C<true> if this object's "metaid" attribute is set.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format). The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model component for purposes
such as referencing that component from metadata placed within
"annotation" subelements.
Returns C<true> if the "metaid" attribute of this SBML object is
set, C<false> otherwise.
@see getMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::isSetName

@internal

Predicate returning C<true> if this object's "metaid" attribute is set.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format). The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model component for purposes
such as referencing that component from metadata placed within
"annotation" subelements.
Returns C<true> if the "metaid" attribute of this SBML object is
set, C<false> otherwise.
@see getMetaId()
@see setMetaId(const std::string& metaid)


=item SBase::isSetNotes

Predicate returning C<true> if this
object's "notes" subelement exists and has content.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
Returns C<true> if a "notes" subelement exists, C<false> otherwise.
@see getNotes()
@see getNotesString()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::isSetAnnotation

Predicate returning C<true> if this
object's "annotation" subelement exists and has content.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Returns C<true> if a "annotation" subelement exists, C<false>
otherwise.

@see getAnnotation()
@see getAnnotationString()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::isSetSBOTerm

Predicate returning C<true> if this
object's "sboTerm" attribute is set.
Returns C<true> if the "sboTerm" attribute of this SBML object is
set, C<false> otherwise.


=item SBase::setMetaId

Sets the value of the "metaid" attribute of this object.
The string C<metaid> is copied.  The value of C<metaid> must be an
identifier conforming to the syntax defined by the XML 1.0 data type
<a href="http://www.w3.org/TR/REC-xml/#id">ID</a>.  Among other
things, this type requires that a value is unique among all the values
of type XML ID in an SBMLDocument.  Although SBML only uses <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a> for the "metaid"
attribute, callers should be careful if they use
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>'s in XML
portions of a model that are not defined by SBML, such as in the
application-specific content of the "annotation" subelement.
@param metaid the identifier string to use as the value of the
"metaid" attribute
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@see getMetaId()
@see isSetMetaId()


=item SBase::isSetModelHistory

Predicate returning C<true> if this
object has a ModelHistory object attached to it.
Returns C<true> if the ModelHistory of this object is set, @c
false otherwise.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setId

@internal

Predicate returning C<true> if this
object has a ModelHistory object attached to it.
Returns C<true> if the ModelHistory of this object is set, @c
false otherwise.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setName

@internal

Predicate returning C<true> if this
object has a ModelHistory object attached to it.
Returns C<true> if the ModelHistory of this object is set, @c
false otherwise.
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object.
The content of C<annotation> is copied, and any previous content of
this object's "annotation" subelement is deleted.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Call this method will result in any existing content of the
"annotation" subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the @p
annotation that is about to be assigned, it is likely that performing
such wholesale replacement is unfriendly towards other software
applications whose annotations are discarded.  An alternative may be
to use SBase::appendAnnotation(const XMLNode  annotation) or
SBase::appendAnnotation(const std::string& annotation).
@param annotation an XML structure that is to be used as the new content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::setAnnotation

Sets the value of the "annotation" subelement of this SBML object.
The content of C<annotation> is copied, and any previous content of
this object's "annotation" subelement is deleted.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Call this method will result in any existing content of the
"annotation" subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the @p
annotation that is about to be assigned, it is likely that performing
such wholesale replacement is unfriendly towards other software
applications whose annotations are discarded.  An alternative may be
to use SBase::appendAnnotation(const XMLNode  annotation) or
SBase::appendAnnotation(const std::string& annotation).
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::appendAnnotation

Appends the given C<annotation> to the "annotation" subelement of this
object.

Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a
target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type "any"</a>,
allowing essentially arbitrary well-formed XML data content.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Unlike SBase::setAnnotation(const XMLNode  annotation) or
SBase::setAnnotation(const std::string& annotation), this method
allows other annotations to be preserved when an application adds its
own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const std::string& annotation)
@see unsetAnnotation()


=item SBase::appendAnnotation

Appends the given C<annotation> to the "annotation" subelement of this
object.

Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a
target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type "any"</a>,
allowing essentially arbitrary well-formed XML data content.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Unlike SBase::setAnnotation(const XMLNode  annotation) or
SBase::setAnnotation(const std::string& annotation), this method
allows other annotations to be preserved when an application adds its
own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see unsetAnnotation()


=item SBase::removeTopLevelAnnotationElement

Removes the top-level element within the "annotation" subelement of this
SBML object with the given name and optional URI.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Calling this method allows a particular annotation element to be removed
whilst the remaining annotations remain intact.
@param elementName a string representing the name of the top level
annotation element that is to be removed
@param elementURI an optional string that is used to check both the name
and URI of the top level element to be removed
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_ANNOTATION_NAME_NOT_FOUND LIBSBML_ANNOTATION_NAME_NOT_FOUND @endlink
@li @link OperationReturnValues_t#LIBSBML_ANNOTATION_NS_NOT_FOUND LIBSBML_ANNOTATION_NS_NOT_FOUND @endlink
@see replaceTopLevelAnnotationElement(const XMLNode  )
@see replaceTopLevelAnnotationElement(const std::string&)


=item SBase::replaceTopLevelAnnotationElement

Replaces the given top-level element within the "annotation" 
subelement of this SBML object and with the annotation element supplied.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling
C< removeTopLevelAnnotationElement(name); appendAnnotation(annotation_with_name);
> with the exception that the placement of the annotation element remains
the same.
@param annotation XMLNode representing the replacement top level annotation 
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@see removeTopLevelAnnotationElement(const std::string elementName, const std::string elementURI)
@see replaceTopLevelAnnotationElement(const std::string&)


=item SBase::replaceTopLevelAnnotationElement

Replaces the given top-level element within the "annotation" 
subelement of this SBML object and with the annotation element supplied.
SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling
C< removeTopLevelAnnotationElement(name); appendAnnotation(annotation_with_name);
> with the exception that the placement of the annotation element remains
the same.
@param annotation string representing the replacement top level annotation 
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@see removeTopLevelAnnotationElement(const std::string elementName, const std::string elementURI)
@see replaceTopLevelAnnotationElement(const XMLNode )


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object.
The content of C<notes> is copied, and any existing content of this
object's "notes" subelement is deleted.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML structure that is to be used as the content of the
"notes" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::setNotes

Sets the value of the "notes" subelement of this SBML object to a copy
of the string C<notes>.
The content of C<notes> is copied, and any existing content of this
object's "notes" subelement is deleted.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
The following code illustrates a very simple way of setting the notes
using this method.  Here, the object being annotated is the whole SBML
document, but that is for illustration purposes only; you could of
course use this same approach to annotate any other SBML component.
@if clike
@verbatim
SBMLDocument  s = new SBMLDocument(3, 1);
s->setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endverbatim
@endif@if java
@verbatim
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endverbatim
@endif@if csharp
@verbatim
SBMLDocument s = new SBMLDocument(3, 1);
s.setNotes("<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>");
@endverbatim
@endif@~

@param notes an XML string that is to be used as the content of the
"notes" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::appendNotes

Appends the given C<notes> to the "notes" subelement of this object.
The content of C<notes> is copied.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML node structure that is to appended to the content
of the "notes" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const std::string& notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::appendNotes

Appends the given C<notes> to the "notes" subelement of this object.
The content of the parameter C<notes> is copied.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
@param notes an XML string that is to appended to the content of
the "notes" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see unsetNotes()
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::setModelHistory

Sets the ModelHistory of this object.
The content of C<history> is copied, and this object's existing model
history content is deleted.
@param history ModelHistory of this object.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument object to use
@see connectToChild()
@if clike
@see enablePackageInternal()
@endif@~


=item SBase::connectToParent

@internal

Sets the parent SBML object of this SBML object.
(Creates a child-parent relationship by the child)
This function is called when a child element is
set/added/created by its parent element (e.g. by setXXX,
addXXX, createXXX, and connectToChild functions of the
parent element).
@param parent the SBML object to use


=item SBase::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor, assignment operator.
@if clike
@see setSBMLDocument()
@see enablePackageInternal()
@endif@~


=item SBase::setSBOTerm

Sets the value of the "sboTerm" attribute.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers. 
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@param value the NNNNNNN integer portion of the SBO identifier
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@see setSBOTerm(@if java String sbo_id@else const std::string &sboid@endif)


=item SBase::setSBOTerm

Sets the value of the "sboTerm" attribute by string.
Beginning with SBML Level 2 Version 3, objects derived from SBase have
an optional attribute named "sboTerm" for supporting the use of the
Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form "SBO:NNNNNNN", where "NNNNNNN" is a
seven digit integer number; libSBML simplifies the representation by
only storing the "NNNNNNN" integer portion.  Thus, in libSBML, the
"sboTerm" attribute on SBase has data type C<int>, and SBO identifiers
are stored simply as integers.  This method lets you set the value of
"sboTerm" as a complete string of the form "SBO:NNNNNNN", whereas
setSBOTerm(int value) allows you to set it using the integer form.
SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for "sboTerm".  Please consult the SBML
Level&nbsp;2 Version&nbsp;4 specification for more information about
the use of SBO and the "sboTerm" attribute.
@param sboid the SBO identifier string of the form "SBO:NNNNNNN"
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@see setSBOTerm(int value)


=item SBase::setNamespaces

Sets the namespaces relevant of this SBML object.
The content of C<xmlns> is copied, and this object's existing
namespace content is deleted.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
@param xmlns the namespaces to set
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item SBase::unsetMetaId

Unsets the value of the "metaid" attribute of this SBML object.
The optional attribute named "metaid", present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format). The attribute value has the data type
<a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, the XML
identifier type, which means each "metaid" value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type <a
href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>, not just the
"metaid" attribute used by SBML&mdash;something to be aware of if your
application-specific XML content inside the "annotation" subelement
happens to use <a href="http://www.w3.org/TR/REC-xml/#id">XML ID</a>.)
The "metaid" value serves to identify a model component for purposes
such as referencing that component from metadata placed within
"annotation" subelements.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::unsetId

Unsets the value of the "id" attribute of this SBML object.
Most (but not all) objects in SBML include two common attributes: "id"
and "name".  The identifier given by an object's "id" attribute value
is used to identify the object within the SBML model definition.
Other objects can refer to the component using this identifier.  The
data type of "id" is always either C<Sid> or
C<UnitSId>, depending on the object in question.  Both
data types are defined as follows:
<pre style="margin-left: 2em; border: none; font-weight: bold; color: black">
letter ::= 'a'..'z','A'..'Z'
digit  ::= '0'..'9'
idChar ::= letter | digit | '_'
SId    ::= ( letter | '_' ) idChar 
</pre>

The equality of C<SId> and C<UnitSId> type values
in SBML is determined by an exact character sequence match; i.e.,
comparisons of these identifiers must be performed in a case-sensitive
manner.  This applies to all uses of C<SId> and
C<UnitSId>.

Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::unsetName

Unsets the value of the "name" attribute of this SBML object.
Most (but not all) objects in SBML include two common attributes: "id"
and "name".  In contrast to the "id" attribute, the "name" attribute is
optional and is not intended to be used for cross-referencing purposes
within a model.  Its purpose instead is to provide a human-readable
label for the component.  The data type of "name" is the type
C<string> defined in XML Schema.  SBML imposes no
restrictions as to the content of "name" attributes beyond those
restrictions defined by the C<string> type in XML Schema.
The recommended practice for handling "name" is as follows.  If a
software tool has the capability for displaying the content of "name"
attributes, it should display this content to the user as a
component's label instead of the component's "id".  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the "name"
attribute is missing on a given component, then the user interface
should display the value of the "id" attribute instead.  (Script
language interpreters are especially likely to display "id" instead of
"name".)

As a consequence of the above, authors of systems that automatically
generate the values of "id" attributes should be aware some systems
may display the "id"'s to the user.  Authors therefore may wish to
take some care to have their software create "id" values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the "id" attribute be an abbreviated
form of the name attribute value.
An additional point worth mentioning is although there are
restrictions on the uniqueness of "id" values, there are no
restrictions on the uniqueness of "name" values in a model.  This
allows software applications leeway in assigning component identifiers.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::unsetNotes

Unsets the value of the "notes" subelement of this SBML object.
The optional SBML element named "notes", present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
"notes" element would be to contain formatted user comments about the
model element in which the "notes" element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for "notes", allowing users considerable freedom when adding
comments to their models.
The format of "notes" elements must be <a target="_blank"
href="http://www.w3.org/TR/xhtml1/">XHTML&nbsp;1.0</a>.  To help
verify the formatting of "notes" content, libSBML provides the static
utility method SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif); however,
readers are urged to consult the appropriate <a target="_blank"
href="http://sbml.org/Documents/Specifications">SBML specification
document</a> for the Level and Version of their model for more
in-depth explanations.  The SBML Level&nbsp;2 and &nbsp;3
specifications have considerable detail about how "notes" element
content must be structured.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see getNotesString()
@see isSetNotes()
@see setNotes(const XMLNode  notes)
@see setNotes(const std::string& notes)
@see appendNotes(const XMLNode  notes)
@see appendNotes(const std::string& notes)
@see SyntaxChecker::hasExpectedXHTMLSyntax(@if java XMLNode xhtml@endif)


=item SBase::unsetAnnotation

Unsets the value of the "annotation" subelement of this SBML object.
Whereas the SBase "notes" subelement is a container for content to be
shown directly to humans, the "annotation" element is a container for
optional software-generated content I<not> meant to be shown to
humans.  Every object derived from SBase can have its own value for
"annotation".  The element's content type is <a target="_blank"
href="http://www.w3.org/TR/2004/REC-xml-20040204/#elemdecls">XML type
"any"</a>, allowing essentially arbitrary well-formed XML data
content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see getAnnotation()
@see getAnnotationString()
@see isSetAnnotation()
@see setAnnotation(const XMLNode  annotation)
@see setAnnotation(const std::string& annotation)
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SBase::unsetSBOTerm

Unsets the value of the "sboTerm" attribute of this SBML object.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item SBase::addCVTerm

Adds a copy of the given CVTerm object to this SBML object.
@param term the CVTerm to assign.
@param newBag if C<true>, creates a new RDF bag with the same identifier
as a previous bag, and if C<false>, adds the term to an existing
RDF bag with the same type of qualifier as the term being added.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink, if
this object lacks a "metaid" attribute
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@note Since the CV Term uses the "metaid" attribute of the object as a
reference, if the object has no "metaid" attribute value set, then the
CVTerm will not be added.
@warning The fact that this method I<copies> the object passed to it
means that the caller will be left holding a physically different
object instance than the one contained in I<this> object.  Changes
made to the original object instance (such as resetting attribute
values) will <em>not affect the instance added here</em>.  In
addition, the caller should make sure to free the original object if
it is no longer being used, or else a memory leak will result.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

Returns the list of CVTerms for this SBML object.


=item SBase::getCVTerms

Returns a list of CVTerm objects in the annotations of this SBML
object.

Returns the list of CVTerms for this SBML object.


=item SBase::getNumCVTerms

Returns the number of CVTerm objects in the annotations of this SBML
object.

Returns the number of CVTerms for this SBML object.


=item SBase::getCVTerm

Returns the nth CVTerm in the list of CVTerms of this SBML
object.

@param n unsigned int the index of the CVTerm to retrieve
Returns the nth CVTerm in the list of CVTerms for this SBML object.


=item SBase::unsetCVTerms

Clears the list of CVTerm objects attached to this SBML object.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::unsetModelHistory

Unsets the ModelHistory object attached to this object.
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note In SBML Level&nbsp;2, model history annotations were only
permitted on the Model element.  In SBML Level&nbsp;3, they are
permitted on all SBML components derived from SBase.


=item SBase::getResourceBiologicalQualifier

Returns the MIRIAM <em>biological qualifier</em> associated with the
given resource.
In <a target="_blank" href="http://biomodels.net/miriam">MIRIAM</a>,
qualifiers are an optional means of indicating the relationship
between a model component and its annotations.  There are two broad
kinds of annotations: <em>model</em> and <em>biological</em>.  The
latter kind is used to qualify the relationship between a model
component and a biological entity which it represents.  Examples of
relationships include "is" and "has part", but many others are
possible.  MIRIAM defines <a target="_blank"
href="http://www.ebi.ac.uk/miriam/main/qualifiers/">numerous
relationship qualifiers</a> to enable different software tools to
qualify biological annotations in the same standardized way.  In
libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
element are represented using lists of CVTerm objects, and the
the MIRIAM biological qualifiers are represented using
values @if clike from the enumeration
type #BiolQualifierType_t.@endif@if python whose
names begin with C<BQB_> in the interface class
@link libsbml libsbml@endlink.@endif@if java whose
names begin with C<BQB_> in the interface class
{@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
This method searches the controlled-vocabulary annotations
(i.e., the list of CVTerm objects) on the present object, then out of
those that have biological qualifiers, looks for an annotation to the
given C<resource>.  If such an annotation is found, it returns the
type of biological qualifier associated with that resource as a 
value @if clike from the enumeration type
#BiolQualifierType_t.@endif@if python whose name begins with
C<BQB_> from the interface
class @link libsbml libsbml@endlink.@endif@if java whose name
begins with C<BQB_> from the interface
class {@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
@param resource string representing the resource; e.g.,
C<"http://www.geneontology.org/#GO:0005892">.

Returns the qualifier associated with the resource,
or @link BiolQualifierType_t#BQB_UNKNOWN BQB_UNKNOWN@endlink if the
resource does not exist.
@if clike
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values in the enumeration
#BiolQualifierType_t are up to date with MIRIAM at the time of a given
libSBML release.  The set of values may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
@endif@if python
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in @link libsbml
libsbml@endlink may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if java
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in {@link libsbmlConstants}
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if csharp
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQB_> constants defined in @link libsbmlcs.libsbml libsbml@endlink
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@~


=item SBase::getResourceModelQualifier

Returns the MIRIAM <em>model qualifier</em> associated with the
given resource.
In <a target="_blank" href="http://biomodels.net/miriam">MIRIAM</a>,
qualifiers are an optional means of indicating the relationship
between a model component and its annotations.  There are two broad
kinds of annotations: <em>model</em> and <em>biological</em>.  The
former kind is used to qualify the relationship between a model
component and another modeling object.  An example qualifier is
"isDerivedFrom", to indicate that a given component of the model is
derived from the modeling object represented by the referenced
resource.  MIRIAM defines <a target="_blank"
href="http://www.ebi.ac.uk/miriam/main/qualifiers/">numerous
relationship qualifiers</a> to enable different software tools to
qualify model annotations in the same standardized way.  In libSBML,
the MIRIAM controlled-vocabulary annotations on an SBML model element
are represented using lists of CVTerm objects, and the 
the MIRIAM model qualifiers are represented using
values @if clike from the enumeration
type #ModelQualifierType_t.@endif@if python whose
names begin with C<BQM_> in the interface class
@link libsbml libsbml@endlink.@endif@if java whose
names begin with C<BQM_> in the interface class
{@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
This method method searches the controlled-vocabulary annotations
(i.e., the list of CVTerm objects) on the present object, then out of
those that have model qualifiers, looks for an annotation to the given
C<resource>.  If such an annotation is found, it returns the type of
type of model qualifier associated with that resource as a 
value @if clike from the enumeration type
#ModelQualifierType_t.@endif@if python whose name begins with
C<BQM_> from the interface
class @link libsbml libsbml@endlink.@endif@if java whose name
begins with C<BQM_> from the interface
class {@link libsbmlConstants}.@endif@if csharp whose
names begin with C<BQB_> in the interface class
@link libsbmlcs.libsbml libsbml@endlink.@endif@~
@param resource string representing the resource; e.g.,
C<"http://www.geneontology.org/#GO:0005892">.

Returns the @if clike #ModelQualifierType_t value@else model qualifier
type@endif@~ associated with the resource, or @link
ModelQualifierType_t#BQM_UNKNOWN BQM_UNKNOWN@endlink if the resource
does not exist.
@if clike
@note The set of MIRIAM biological qualifiers grows over
time, although relatively slowly.  The values in the enumeration
#ModelQualifierType_t are up to date with MIRIAM at the time of a given
libSBML release.  The set of values may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
@endif@if python
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in @link libsbml
libsbml@endlink may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if java
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in {@link libsbmlConstants}
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@if csharp
@note The set of MIRIAM model qualifiers grows over
time, although relatively slowly.  The values are up to date with
MIRIAM at the time of a given libSBML release.  The set of values in
list of C<BQM_> constants defined in @link libsbmlcs.libsbml libsbml@endlink
may be expanded in later libSBML releases, to match
the values defined by MIRIAM at that later time.
@endif@~


=item SBase::getModel

Returns the Model object in which the current object is located.
Returns the parent Model of this SBML object.
@see getParentSBMLObject()
@see getSBMLDocument()


=item SBase::getLevel

Returns the SBML Level of the SBMLDocument object containing this
object.

Returns the SBML level of this SBML object.
@see getVersion()
@see getNamespaces()
@see getPackageVersion()


=item SBase::getVersion

Returns the Version within the SBML Level of the SBMLDocument object
containing this object.
Returns the SBML version of this SBML object.
@see getLevel()
@see getNamespaces()


=item SBase::getPackageVersion

Returns the Version of the SBML Level&nbsp;3 package to which this
element belongs to.
Returns the version of the SBML Level&nbsp;3 package to which this
element belongs. The value C<0> will be returned if this element
belongs to the SBML Level&nbsp;3 Core package.
@see getLevel()
@see getVersion()


=item SBase::getPackageName

Returns the name of the SBML Level&nbsp;3 package in which this
element is defined.
Returns the name of the SBML package in which this element is defined.
The string C<&quot;core&quot;> will be returned if this
element is defined in SBML Level&nbsp;3 Core. The string
C<&quot;unknown&quot;> will be returned if this element is
not defined in any SBML package.


=item SBase::getTypeCode

Returns the libSBML type code for this object.
This method may return the type code of this SBML object, or it may
return @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink.  This
is because subclasses of SBase are not required to implement this
method to return a type code.  This method is meant primarily for the
LibSBML C interface, in which class and subclass information is not
readily available.
Returns the @if clike #SBMLTypeCode_t value@else SBML object type code@endif@~
of this SBML object or
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (the default).
@see getElementName()
@see getPackageName()


=item SBase::hasValidLevelVersionNamespaceCombination

Predicate returning C<true> if this
object's level/version and namespace values correspond to a valid
SBML specification.
The valid combinations of SBML Level, Version and Namespace as of this
release of libSBML are the following:

=over


=item

Level&nbsp;1 Version&nbsp;2: C<"http://www.sbml.org/sbml/level1">

=item

Level&nbsp;2 Version&nbsp;1: C<"http://www.sbml.org/sbml/level2">

=item

Level&nbsp;2 Version&nbsp;2: C<"http://www.sbml.org/sbml/level2/version2">

=item

Level&nbsp;2 Version&nbsp;3: C<"http://www.sbml.org/sbml/level2/version3">

=item

Level&nbsp;2 Version&nbsp;4: C<"http://www.sbml.org/sbml/level2/version4">

=item

Level&nbsp;3 Version&nbsp;1 Core: C<"http://www.sbml.org/sbml/level3/version1/core">

=back


Returns C<true> if the level, version and namespace values of this 
SBML object correspond to a valid set of values, C<false> otherwise.


=item SBase::getElementName

Returns the XML element name of this object.
This is overridden by subclasses to return a string appropriate to the
SBML component.  For example, Model defines it as returning @c
"model", CompartmentType defines it as returning C<"compartmentType">,
and so on.


=item SBase::toSBML

Returns a string consisting of a partial SBML corresponding to just
this object.
Returns the partial SBML that describes this SBML object.
@warning This is primarily provided for testing and debugging
purposes.  It may be removed in a future version of libSBML.


=item SBase::getPlugin

Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
package extension with the given package name or URI.
@param package the name or URI of the package
Returns the plug-in object (the libSBML extension interface) of
a package extension with the given package name or URI.


=item SBase::getPlugin

Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
package extension with the given package name or URI.
@param package the name or URI of the package
Returns the plug-in object (the libSBML extension interface) of a
package extension with the given package name or URI.


=item SBase::getPlugin

Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
@param n the index of the plug-in to return
Returns the plug-in object (the libSBML extension interface) of
a package extension with the given package name or URI.


=item SBase::getPlugin

Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
package extension.
@param n the index of the plug-in to return
Returns the plug-in object (the libSBML extension interface) of a
package extension with the given package name or URI.


=item SBase::getNumPlugins

Returns the number of plug-in objects (extenstion interfaces) for SBML
Level&nbsp;3 package extensions known.
Returns the number of plug-in objects (extension interfaces) of
package extensions known by this instance of libSBML.


=item SBase::enablePackage

Enables or disables the given SBML Level&nbsp;3 package
This method enables or disables the specified package on this object
and other objects connected by child-parent links in the same
SBMLDocument object.
@param pkgURI the URI of the package
@param pkgPrefix the XML prefix of the package
@param flag whether to enable (C<true>) or disable (C<false>) the package
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION @endlink


=item SBase::disablePackage

Disables the given SBML Level&nbsp;3 package
This method enables or disables the specified package on this object
and other objects connected by child-parent links in the same
SBMLDocument object.
@param pkgURI the URI of the package
@param pkgPrefix the XML prefix of the package
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN LIBSBML_PKG_UNKNOWN @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_VERSION_MISMATCH LIBSBML_PKG_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_CONFLICTED_VERSION LIBSBML_PKG_CONFLICTED_VERSION @endlink


=item SBase::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses in which one or more child elements are defined 
must override this function.
@if clike
@see setSBMLDocument()
@endif@~
@see connectToChild()


=item SBase::isPackageURIEnabled

Predicate returning C<true> if an SBML Level&nbsp;3 package with the
given URI is enabled with this object.
@param pkgURI the URI of the package
Returns C<true> if the given package is enabled within this object, @c 
false otherwise.
@see isPackageEnabled(@if java String pkgName@endif)


=item SBase::isPackageEnabled

Predicate returning C<true> if the given SBML Level&nbsp;3 package is
enabled with this object.
The search ignores the package version.
@param pkgName the name of the package
Returns C<true> if the given package is enabled within this object, @c
false otherwise.
@see isPackageURIEnabled(@if java String pkgURI@endif)


=item SBase::isPkgURIEnabled

Predicate returning C<true> if an SBML Level&nbsp;3 package with the
given URI is enabled with this object.
@param pkgURI the URI of the package
Returns C<true> if the given package is enabled within this object, @c 
false otherwise.
@see isPkgEnabled(@if java String pkgName@endif)
@deprecated Replaced in libSBML 5.2.0 by
isPackageURIEnabled(@if java String pkgURI@endif)


=item SBase::isPkgEnabled

Predicate returning C<true> if the given SBML Level&nbsp;3 package is
enabled with this object.
The search ignores the package version.
@param pkgName the name of the package
Returns C<true> if the given package is enabled within this object, @c
false otherwise.
@see isPkgURIEnabled(@if java String pkgURI@endif)
@deprecated Replaced in libSBML 5.2.0 by
isPackageEnabled(@if java String pkgName@endif)


=item SBase::writeExtensionElements

@internal

Writes out contained SBML objects of package extensions (if any)
as XML elements.


=item SBase::read

@internal

Reads (initializes) this SBML object by reading from XMLInputStream.


=item SBase::write

@internal

Writes (serializes) this SBML object by writing it to XMLOutputStream.


=item SBase::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::hasRequiredAttributes

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::hasRequiredElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::setSBMLNamespaces

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::setSBMLNamespacesAndOwn

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::getSBMLNamespaces

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::removeDuplicateAnnotations

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::checkMathMLNamespace

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.  For example:@if clike
<pre>
SBase::writeElements();
mReactans.write(stream);
mProducts.write(stream);
...
</pre>@endif@~


=item SBase::removeFromParentAndDelete

Removes itself from its parent.  If the parent was storing it as a
pointer, it is deleted.  If not, it is simply cleared (as in ListOf
objects).  Pure virutal, as every SBase element has different parents,
and therefore different methods of removing itself.  Will fail (and
not delete itself) if it has no parent object.  This function is
designed to be overridden, but for all objects whose parent is of the
class ListOf, the default implementation will work.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::matchesSBMLNamespaces

Returns C<true> if this object's set of XML namespaces are the same
as the given object's XML namespaces.
@param sb an object to compare with respect to namespaces
Returns boolean, C<true> if this object's collection of namespaces is
the same as C<sb's>, C<false> otherwise.


=item SBase::matchesRequiredSBMLNamespacesForAddition

Returns C<true> if this object's set of XML namespaces are a subset
of the given object's XML namespaces.
@param sb an object to compare with respect to namespaces
Returns boolean, C<true> if this object's collection of namespaces is
a subset of C<sb's>, C<false> otherwise.


=item SBase::setUserData

Sets the user data of this element. This can be used by the application
developer to attach custom information to the node. In case of a deep
copy this attribute will passed as it is. The attribute will be never
interpreted by this class.
@param userData specifies the new user data. 
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SBase::*getUserData

Returns the user data that has been previously set via setUserData().
Returns the user data of this node, or C<NULL> if no user data has been set.
@if clike
@see ASTNode::setUserData(void  userData)
@endif@~


=item SBase::setElementText

When overridden allows SBase elements to use the text included in between
the elements tags. The default implementation does nothing.
@param text the text string found between the element tags.


=item SBase::matchesCoreSBMLNamespace

@internal

When overridden allows SBase elements to use the text included in between
the elements tags. The default implementation does nothing.
@param text the text string found between the element tags.


=item SBase::SBase

@internal

Creates a new SBase object with the given SBML level, version.


=item SBase::SBase

@internal

Creates a new SBase object with the given SBMLNamespaces.
Only subclasses may create SBase objects.


=item SBase::SBase

@internal

Copy constructor. Creates a copy of this SBase object.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item SBase::createObject

@internal

Subclasses should override this method to create, store, and then
return an SBML object corresponding to the next XMLToken in the
XMLInputStream.

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item SBase::hasValidLevelVersionNamespaceCombination

@internal

Predicate returning C<true> if this
object's level/version and namespace values correspond to a valid
SBML specification.
The valid combinations of SBML Level, Version and Namespace as of this
release of libSBML are the following:

=over


=item

Level&nbsp;1 Version&nbsp;2: C<"http://www.sbml.org/sbml/level1">

=item

Level&nbsp;2 Version&nbsp;1: C<"http://www.sbml.org/sbml/level2">

=item

Level&nbsp;2 Version&nbsp;2: C<"http://www.sbml.org/sbml/level2/version2">

=item

Level&nbsp;2 Version&nbsp;3: C<"http://www.sbml.org/sbml/level2/version3">

=item

Level&nbsp;2 Version&nbsp;4: C<"http://www.sbml.org/sbml/level2/version4">

=item

Level&nbsp;3 Version&nbsp;1 Core: C<"http://www.sbml.org/sbml/level3/version1/core">

=back


@param typecode the typecode for this element
@param xmlns the namespaces used by this element.
@note  This function is provided as convenience method to be called from constructors. This 
allows to use it in scenarios where the namespaces or typecode have not yet been initialized. 
Returns C<true> if the level, version and namespace values of this 
SBML object correspond to a valid set of values, C<false> otherwise.


=item SBase::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item SBase::getElementPosition

@internal

The SBML XML Schema is written such that the order of child elements
is significant.  LibSBML can read elements out of order.  If you
override this method to indicate the ordinal position of element with
respect to its siblings, libSBML will log an error if the element is
read out of order.
Returns the ordinal position of the element with respect to its
siblings or C<-1> (the default) to indicate the position is not
significant.


=item SBase::getErrorLog

@internal

Returns the SBMLErrorLog used to log errors during while reading and
validating SBML.


=item SBase::logError

@internal

Convenience method for easily logging problems from within method
implementations.

This is essentially a short form of getErrorLog()->logError(...)
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::logUnknownAttribute

@internal

Helper to log a common type of error.


=item SBase::logUnknownElement

@internal

Helper to log a common type of error.


=item SBase::logEmptyString

@internal

Helper to log a common type of error.


=item SBase::addExpectedAttributes

@internal

Subclasses should override this method to add the list of
expected attributes. Be sure to call your parents implementation 
of this method as well.


=item SBase::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SBase::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...

(NOTICE) this function doesn't write xmlns attributes.
Be sure to implement wirteXMLNS() function to write xmlns attributes.


=item SBase::writeXMLNS

@internal


Subclasses should override this method to write their xmlns attriubutes
(if any) to the XMLOutputStream.


=item SBase::syncAnnotation

@internal

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the 
current CVTerm objects (List  mCVTerm).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.


=item SBase::reconstructRDFAnnotation

@internal

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the 
current CVTerm objects (List  mCVTerm).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.


=item SBase::checkOrderAndLogError

@internal

Checks that the SBML element appears in the expected order.
If C<object> is not in the expected position, an error is logged.


=item SBase::checkListOfPopulated

@internal

Checks that an SBML ListOf element is populated.  
If a listOf element has been declared with no elements, 
an error is logged.


=item SBase::checkUnitSyntax

@internal

Checks the syntax of the unit attribute.
The syntax of an unit is of type UnitSId which is defined as:
- letter ::= 'a'..'z','A'..'Z'
- digit  ::= '0'..'9'
- idChar ::= letter | digit | '_'
- UnitSId    ::= ( letter | '_' ) idChar 
If the syntax of the unit attribute of this object is incorrect, 
an error is logged
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item SBase::checkDefaultNamespace

@internal

Checks that the given default namespace in the given element is valid.
If the given default namespace is not valid, an error is logged.


=item SBase::checkAnnotation

@internal

Checks the annotation does not declare an sbml namespace.
If the annotation declares an sbml namespace an error is logged.


=item SBase::checkXHTML

@internal

Checks that the XHTML is valid.
If the xhtml does not conform to the specification of valid xhtml within
an sbml document, an error is logged.


=item SBase::loadPlugins

@internal

Checks that the XHTML is valid.
If the xhtml does not conform to the specification of valid xhtml within
an sbml document, an error is logged.


=item SBase::createExtensionObject

@internal

Create, store, and then return an SBML object of package extensions
corresponding to the next XMLToken in the XMLInputStream.
Returns the SBML object of package extensions corresponding to next 
XMLToken in the XMLInputStream or C<NULL> if the token was not recognized.


=item SBase::setElementNamespace

@internal

Sets the XML namespace to which this element belongs to.
For example, all elements that belong to SBML Level 3 Version 1 Core
must set the namespace to "http://www.sbml.org/sbml/level3/version1/core"; 
all elements that belong to Layout Extension Version 1 for SBML Level 3
Version 1 Core must set the namespace to 
"http://www.sbml.org/sbml/level3/version1/layout/version1/"

Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item SBase::getElementNamespace

@internal

Gets the XML namespace (URI) to which this element belongs to.


=item SBase::getURI

@internal

Gets the URI to which this element belongs to.
For example, all elements that belong to SBML Level 3 Version 1 Core
must would have the URI "http://www.sbml.org/sbml/level3/version1/core"; 
all elements that belong to Layout Extension Version 1 for SBML Level 3
Version 1 Core must would have the URI
"http://www.sbml.org/sbml/level3/version1/layout/version1/"

Unlike getElementNamespace, this function first returns the URI for this 
element by looking into the SBMLNamespaces object of the document with 
the its package name. if not found it will return the result of 
getElementNamespace

Returns the URI this elements  
@see getPackageName
@see getElementNamespace
@see getSBMLNamespaces
@see getSBMLDocument


=item SBase::readExtensionAttributes

@internal

Read attributes of package extensions from the given XMLAttributes 
set into their specific fields. 
Be sure to call your parents implementation of this function as well.  
For example:
@if clike
@verbatim
SBase::readExtensionAttributes(attributes);
@endverbatim
@endif@if java
@verbatim
SBase.readExtensionAttributes(attributes);
@endverbatim
@endif@if java
@verbatim
SBase.readExtensionAttributes(attributes);
@endverbatim
@endif@if python
@verbatim
SBase.readExtensionAttributes(attributes);
@endverbatim
@endif@~


=item SBase::writeExtensionAttributes

@internal

Write attributes of package extensions to the XMLOutputStream.  
Be sure to call your parents implementation of this function as well.  
For example:
SBase::writeExtensionAttributes(stream);


=item SBase::storeUnknownExtAttribute

@internal

Stores the given attribute to the list of ignored attributes if
the given attribute belongs to some unknown package extension.
Unknown attribute error will be logged if the "required" attribute
of the package is "true" in SBMLDocument element.
The stored attributes will be written out as-is when writing the 
SBMLDocument to a string or a file (i.e. Attributes and elements of 
unknown package extensions will not be lost when reading/writing 
a file/sting containing them.)
@param element the string of element which contains the given attribute
@param xattr the XMLAttributes object which is contained in the given 
element
@param index the index of the target attribute in the given XMLAttributes
object.

Returns true will be returned if the given attribute belongs
to some unknown package extension, otherwise false will be returned.


=item SBase::storeUnknownExtElement

@internal

Stores the element of next token if the element belongs to some 
unknown package extension. Unknown element error will be logged if
the "required" attribute of the package is "true" in SBMLDocument 
element.

The stored elements will be written out as-is when writing the 
SBMLDocument to a string or a file (i.e. Attributes and elements of 
unknown package extensions will not be lost when reading/writing 
a file/sting containing them.)
Returns true will be returned if the element of next token belongs
to some unknown package extension, otherwise false will be returned.


=item SBase::getPrefix

@internal

Return the prefix of this element.


=item SBase::getSBMLPrefix

@internal

Return the SBML prefix of this element. This will be the same as getPrefix()
unless the element in question is an element of an SBML extension class.


=item SBase::getRootElement

@internal

Returns the root element of the node tree to which this element is connected.
@note The root element may not be an SBMLDocument element. For example,
this element is the root element if this element doesn't have a parent
SBML object (i.e. mParentSBMLObject is NULL)
@see enablePackageInternal


=item SBase::getHasBeenDeleted

@internal

Returns the root element of the node tree to which this element is connected.
@note The root element may not be an SBMLDocument element. For example,
this element is the root element if this element doesn't have a parent
SBML object (i.e. mParentSBMLObject is NULL)
@see enablePackageInternal


=item SBase::setSBaseFields

@internal

Stores the location (line and column) and any XML namespaces (for
roundtripping) declared on this SBML (XML) element.


=item SBase::readAnnotation

@internal

Returns true if read an <annotation> element from the stream


=item SBase::removeDuplicatedResources

@internal

removes resources from the term object that alread exist on this object


=item SBase::addTermToExistingBag

@internal

adds the given term to an existing bag. Returns 1 if added, 0 otherwise.


=item SBase::readNotes

@internal

Returns true if read a <notes> element from the stream


=back

=head2 ListOf

Parent class for the various SBML "ListOfXYZ" classes.
@htmlinclude not-sbml-warning.html
SBML defines various ListOf___ classes that are containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the attributes and subelements of
SBase, such as "metaid" as and "annotation".  The ListOf___ classes do
not add any attributes of their own.
The ListOf class in libSBML is a utility class that serves as the parent
class for implementing the ListOf__ classes.  It provides methods for
working generically with the various SBML lists of objects in a program.
LibSBML uses this separate list class rather than ordinary
@if clike C&#43;&#43; @endif@if java Java@endif@if python Python@endif@~ lists,
so that it can provide the methods and features associated with SBase.
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item ListOf::ListOf

Creates a new ListOf object.
@param level the SBML Level; if not assigned, defaults to the
value of SBML_DEFAULT_LEVEL.
@param version the Version within the SBML Level; if not assigned,
defaults to the value of SBML_DEFAULT_VERSION.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item ListOf::ListOf

Creates a new ListOf with SBMLNamespaces object.
@param sbmlns the set of namespaces that this ListOf should contain.


=item ListOf::ListOf

Copy constructor;  creates a copy of this ListOf.
@param orig the ListOf instance to copy.


=item ListOf::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next item in the
list.


=item ListOf::clone

Creates and returns a deep copy of this ListOf.
Returns a (deep) copy of this ListOf.


=item ListOf::append

Adds item to the end of this ListOf.
This variant of the method makes a clone of the C<item> handed to it.
This means that when the ListOf is destroyed, the original items will
not be destroyed.
@param item the item to be added to the list.
@see appendAndOwn(SBase  item)


=item ListOf::appendAndOwn

Adds item to the end of this ListOf.
This variant of the method does not clone the C<item> handed to it;
instead, it assumes ownership of it.  This means that when the ListOf
is destroyed, the item will be destroyed along with it.
@param item the item to be added to the list.
@see append(const SBase  item)


=item ListOf::appendFrom

Adds a clone of all items in the provided ListOf to this object.  This means that when this ListOf is destroyed, the original items will not be destroyed.
@param list A list of items to be added.
@see append(const SBase  item)


=item ListOf::insert

Inserts the item at the given position of this ListOf
This variant of the method makes a clone of the C<item> handet to it. 
This means that when the ListOf is destroyed, the original items will
not be destroyed. 
@param location the location where to insert the item
@param item the item to be inserted to the list
@see insertAndOwn(int location, SBase  item)


=item ListOf::insertAndOwn

Inserts the item at the given position of this ListOf
This variant of the method makes a clone of the C<item> handet to it. 
This means that when the ListOf is destroyed, the original items will
not be destroyed. 
@param location the location where to insert the item
@param item the item to be inserted to the list
@see insert(int location, const SBase  item)


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
Returns the nth item in this ListOf items.
@see size()


=item ListOf::get

Get an item from the list.
@param n the index number of the item to get.
Returns the nth item in this ListOf items.
@see size()


=item ListOf::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item ListOf::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item ListOf::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item ListOf::get

Get an item from the list based on its identifier.
@param sid a string representing the the identifier of the item to get.
Returns item in this ListOf items with the given id or C<NULL> if no such
item exists.
@see get(unsigned int n)
@see size()


=item ListOf::get

Get an item from the list based on its identifier.
@param sid a string representing the the identifier of the item to get.
Returns item in this ListOf items with the given id or C<NULL> if no such
item exists.
@see get(unsigned int n)
@see size()


=item ListOf::clear

Removes all items in this ListOf object.
If parameter C<doDelete> is C<true> (default), all items in this ListOf
object are deleted and cleared, and thus the caller doesn't have to
delete those items.  Otherwise, all items are just cleared from this
ListOf object and the caller is responsible for deleting all items.  (In
that case, pointers to all items should be stored elsewhere before
calling this function.)
@param doDelete if C<true> (default), all items are deleted and cleared.
Otherwise, all items are just cleared and not deleted.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~


=item ListOf::removeFromParentAndDelete

Because ListOf objects typically live as object children of their parent object and not as pointer children, this function clears itself, but does not attempt to do anything else.  If a particular ListOf subclass does indeed exist as a pointer only, this function will need to be overridden.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item ListOf::remove

Removes the <em>n</em>th item from this ListOf items and returns a
pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOf::remove

Removes item in this ListOf items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOf::size

Get the size of this ListOf.
Returns the number of items in this ListOf items.


=item ListOf::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument that should become the parent of this
ListOf.


=item ListOf::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item ListOf::getTypeCode

Returns the libSBML type code for this object, namely, @c
SBML_LIST_OF.

@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOf::getItemTypeCode

Get the type code of the objects contained in this ListOf.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).


=item ListOf::getElementName

Returns the XML element name of this object, which for ListOf, is
always C<"listOf">.
Returns the XML name of this element.


=item ListOf::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item ListOf::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item ListOf::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item ListOf::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item ListOf::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...


=item ListOf::isValidTypeForList

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.  For example:
SBase::writeAttributes(stream);
stream.writeAttribute( "id"  , mId   );
stream.writeAttribute( "name", mName );
...


=back

=head2 Model

LibSBML implementation of SBML's Model construct.
In an SBML model definition, a single object of class Model serves as
the overall container for the lists of the various model components.
All of the lists are optional, but if a given list container is present
within the model, the list must not be empty; that is, it must have
length one or more.  The following are the components and lists
permitted in different Levels and Versions of SBML in
version @htmlinclude libsbml-version.html
of libSBML:

=over


=item

In SBML Level 1, the components are: UnitDefinition, Compartment,
Species, Parameter, Rule, and Reaction.  Instances of the classes are
placed inside instances of classes ListOfUnitDefinitions,
ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
ListOfReactions.


=item

In SBML Level 2 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
Event.  Instances of the classes are placed inside instances of classes
ListOfFunctionDefinitions, ListOfUnitDefinitions, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfRules, ListOfReactions, and
ListOfEvents.


=item

In SBML Level 2 Versions 2, 3 and 4, the components are:
FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
Reaction and Event.  Instances of the classes are placed inside
instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.

=item

In SBML Level 3 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, InitialAssignment,
Rule, Constraint, Reaction and Event.  Instances of the classes are
placed inside instances of classes ListOfFunctionDefinitions,
ListOfUnitDefinitions, ListOfCompartments, ListOfSpecies,
ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.  

=back


Although all the lists are optional, there are dependencies between SBML
components such that defining some components requires defining others.
An example is that defining a species requires defining a compartment,
and defining a reaction requires defining a species.  The dependencies
are explained in more detail in the SBML specifications.
In addition to the above lists and attributes, the Model class in both
SBML Level&nbsp;2 and Level&nbsp;3 has the usual two attributes of "id"
and "name", and both are optional.  As is the case for other SBML
components with "id" and "name" attributes, they must be used according
to the guidelines described in the SBML specifications.  (Within the
frameworks of SBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1 Core, a
Model object identifier has no assigned meaning, but extension packages
planned for SBML Level&nbsp;3 are likely to make use of this
identifier.)

Finally, SBML Level&nbsp;3 has introduced a number of additional Model
attributes.  They are discussed in a separate section below.
@section approaches Approaches to creating objects using the libSBML API
LibSBML provides two main mechanisms for creating objects: class
constructors
(e.g., @if java <a href="org/sbml/libsbml/Species.html">Species()</a> @else Species::Species() @endif), 
and <code>create<span class="placeholder"><em>Object</em></span>()</code>
methods (such as Model::createSpecies()) provided by certain <span
class="placeholder"><em>Object</em></span> classes such as Model.  These
multiple mechanisms are provided by libSBML for flexibility and to
support different use-cases, but they also have different implications
for the overall model structure.
In general, the recommended approach is to use the <code>create<span
class="placeholder"><em>Object</em></span>()</code> methods.  These
methods both create an object I<and> link it to the parent in one step.
Here is an example:@if clike
@verbatim
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument  sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Model  model = sbmlDoc->createModel();
model->setId("BestModelEver");
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Species  sp = model->createSpecies();
sp->setId("MySpecies");
@endverbatim
@endif@if java
@verbatim
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that
// the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.
Model model = sbmlDoc.createModel();
model.setId(&#34;BestModelEver&#34;);
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that, like
// with Model, the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.
Species sp = model.createSpecies();
sp.setId(&#34;BestSpeciesEver&#34;);
@endverbatim
@endif@if python
@verbatim
# Create an SBMLDocument object in Level 3 Version 1 format:
sbmlDoc = SBMLDocument(3, 1)
# Create a Model object inside the SBMLDocument object and set
# its identifier.  The call to setId() returns a status code
# to indicate whether the assignment was successful.  Code 0
# means success; see the documentation for Model's setId() for 
# more information.
model = sbmlDoc.createModel()
model.setId(&#34;BestModelEver&#34;)
# Create a Species object inside the Model and set its identifier.
# Again, the setId() returns a status code to indicate whether the
# assignment was successful.  Code 0 means success; see the
# documentation for Specie's setId() for more information.
sp = model.createSpecies()
sp.setId(&#34;BestSpeciesEver&#34;)
@endverbatim
@endif@if csharp
@verbatim
// Create an SBMLDocument object in Level 3 Version 1 format:
SBMLDocument sbmlDoc = new SBMLDocument(3, 1);
// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Model model = sbmlDoc.createModel();
model.setId("BestModelEver");
// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).
Species sp = model.createSpecies();
sp.setId("MySpecies");
@endverbatim
@endif@~

The <code>create<span
class="placeholder"><em>Object</em></span>()</code> methods return a
pointer to the object created, but they also add the object to the
relevant list of object instances contained in the parent.  (These lists
become the <code>&lt;listOf<span
class="placeholder"><em>Object</em></span>s&gt;</code> elements in the
finished XML rendition of SBML.)  In the example above,
Model::createSpecies() adds the created species directly to the
<code>&lt;listOfSpecies<i></i>&gt;</code> list in the model.  Subsequently,
methods called on the species change the species in the model (which is
what is expected in most situations).
@section checking Consistency and adherence to SBML specifications
To make it easier for applications to do whatever they need,
libSBML version @htmlinclude libsbml-version.html
is relatively lax when it comes to enforcing correctness and
completeness of models I<during> model construction and editing.
Essentially, libSBML I<will> I<not> in most cases check automatically
that a model's components have valid attribute values, or that the
overall model is consistent and free of errors&mdash;even obvious errors
such as duplication of identifiers.  This allows applications great
leeway in how they build their models, but it means that software
authors must take deliberate steps to ensure that the model will be, in
the end, valid SBML.  These steps include such things as keeping track
of the identifiers used in a model, manually performing updates in
certain situations where an entity is referenced in more than one place
(e.g., a species that is referenced by multiple SpeciesReference
objects), and so on.
That said, libSBML does provide powerful features for deliberately
performing validation of SBML when an application decides it is time to
do so.  The interfaces to these facilities are on the SBMLDocument
class, in the form of SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  Please refer to the documentation for
SBMLDocument for more information about this.
While applications may play fast and loose and live like free spirits
during the construction and editing of SBML models, they should always
make sure to call SBMLDocument::checkInternalConsistency() and/or
SBMLDocument::checkConsistency() before writing out the final version of
an SBML model.
@section model-l3-attrib Model attributes introduced in SBML Level&nbsp;3
As mentioned above, the Model class has a number of optional attributes
in SBML Level&nbsp;3 Version&nbsp;1 Core.  These are "substanceUnits",
"timeUnits", "volumeUnits", "areaUnits", "lengthUnits", "extentUnits",
and "conversionFactor.  The following provide more information about
them.

@subsection model-l3-substanceunits The "substanceUnits" attribute
The "substanceUnits" attribute is used to specify the unit of
measurement associated with substance quantities of Species objects that
do not specify units explicitly.  If a given Species object definition
does not specify its unit of substance quantity via the "substanceUnits"
attribute on the Species object instance, then that species inherits the
value of the Model "substanceUnits" attribute.  If the Model does not
define a value for this attribute, then there is no unit to inherit, and
all species that do not specify individual "substanceUnits" attribute
values then have <em>no</em> declared units for their quantities.  The
SBML Level&nbsp;3 Version&nbsp;1 Core specification provides more
details.

Note that when the identifier of a species appears in a model's
mathematical expressions, the unit of measurement associated with that
identifier is <em>not solely determined</em> by setting "substanceUnits"
on Model or Species.  Please see the discussion about units given in
the documentation for the Species class.
@subsection model-l3-timeunits The "timeUnits" attribute
The "timeUnits" attribute on SBML Level&nbsp;3's Model object is used to
specify the unit in which time is measured in the model.  This attribute
on Model is the <em>only</em> way to specify a unit for time in a model.
It is a global attribute; time is measured in the model everywhere in
the same way.  This is particularly relevant to Reaction and RateRule
objects in a model: all Reaction and RateRule objects in SBML define
per-time values, and the unit of time is given by the "timeUnits"
attribute on the Model object instance.  If the Model "timeUnits"
attribute has no value, it means that the unit of time is not defined
for the model's reactions and rate rules.  Leaving it unspecified in an
SBML model does not result in an invalid model in SBML Level&nbsp;3;
however, as a matter of best practice, we strongly recommend that all
models specify units of measurement for time.
@subsection model-l3-voletc The "volumeUnits", "areaUnits", and "lengthUnits" attributes
The attributes "volumeUnits", "areaUnits" and "lengthUnits" together are
used to set the units of measurements for the sizes of Compartment
objects in an SBML Level&nbsp;3 model when those objects do not
otherwise specify units.  The three attributes correspond to the most
common cases of compartment dimensions: "volumeUnits" for compartments
having a "spatialDimensions" attribute value of C<"3">, "areaUnits" for
compartments having a "spatialDimensions" attribute value of C<"2">, and
"lengthUnits" for compartments having a "spatialDimensions" attribute
value of C<"1">.  The attributes are not applicable to compartments
whose "spatialDimensions" attribute values are I<not> one of C<"1">, @c
"2" or C<"3">.
If a given Compartment object instance does not provide a value for its
"units" attribute, then the unit of measurement of that compartment's
size is inherited from the value specified by the Model "volumeUnits",
"areaUnits" or "lengthUnits" attribute, as appropriate based on the
Compartment object's "spatialDimensions" attribute value.  If the Model
object does not define the relevant attribute, then there are no units
to inherit, and all Compartment objects that do not set a value for
their "units" attribute then have <em>no</em> units associated with
their compartment sizes.
The use of three separate attributes is a carry-over from SBML
Level&nbsp;2.  Note that it is entirely possible for a model to define a
value for two or more of the attributes "volumeUnits", "areaUnits" and
"lengthUnits" simultaneously, because SBML models may contain
compartments with different numbers of dimensions.
@subsection model-l3-extentunits The "extentUnits" attribute
Reactions are processes that occur over time.  These processes involve
events of some sort, where a single ``reaction event'' is one in which
some set of entities (known as reactants, products and modifiers in
SBML) interact, once.  The <em>extent</em> of a reaction is a measure of
how many times the reaction has occurred, while the time derivative of
the extent gives the instantaneous rate at which the reaction is
occurring.  Thus, what is colloquially referred to as the "rate of the
reaction" is in fact equal to the rate of change of reaction extent.
In SBML Level&nbsp;3, the combination of "extentUnits" and "timeUnits"
defines the units of kinetic laws in SBML and establishes how the
numerical value of each KineticLaw object's mathematical formula is
meant to be interpreted in a model.  The units of the kinetic laws are
taken to be "extentUnits" divided by "timeUnits".
Note that this embodies an important principle in SBML Level&nbsp;3
models: <em>all reactions in an SBML model must have the same units</em>
for the rate of change of extent.  In other words, the units of all
reaction rates in the model <em>must be the same</em>.  There is only
one global value for "extentUnits" and one global value for "timeUnits".
@subsection model-l3-convfactor The "conversionFactor" attribute
The attribute "conversionFactor" in SBML Level&nbsp;3's Model object
defines a global value inherited by all Species object instances that do
not define separate values for their "conversionFactor" attributes.  The
value of this attribute must refer to a Parameter object instance
defined in the model.  The Parameter object in question must be a
constant; ie it must have its "constant" attribute value set to @c
"true".

If a given Species object definition does not specify a conversion
factor via the "conversionFactor" attribute on Species, then the species
inherits the conversion factor specified by the Model "conversionFactor"
attribute.  If the Model does not define a value for this attribute,
then there is no conversion factor to inherit.  More information about
conversion factors is provided in the SBML Level&nbsp;3 Version&nbsp;1
specification.

=over


=item Model::Model

Creates a new Model using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Model
@param version an unsigned int, the SBML Version to assign to this
Model

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Model object to an SBMLDocument
(e.g., using SBMLDocument::setModel(@if java Model m@endif)), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the Model object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a Model is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item Model::Model

Creates a new Model using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Model object to an SBMLDocument (e.g.,
using SBMLDocument::setModel(@if java Model m@endif)), the SBML XML namespace of the document @em
overrides the value used when creating the Model object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a Model is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Model::Model

Copy constructor; creates a (deep) copy of the given Model object.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Model::accept

Accepts the given SBMLVisitor for this instance of Constraint.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Model::clone

Creates and returns a deep copy of this Model object.
Returns a (deep) copy of this Model.


=item Model::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find.
Returns pointer to the first element found with the given id.


=item Model::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item Model::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item Model::getId

Returns the value of the "id" attribute of this Model.
Returns the id of this Model.


=item Model::getName

Returns the value of the "name" attribute of this Model.
Returns the name of this Model.


=item Model::getSubstanceUnits

Returns the value of the "substanceUnits" attribute of this Model.
Returns the substanceUnits of this Model.
@note The "substanceUnits" attribute is available in
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getTimeUnits

Returns the value of the "timeUnits" attribute of this Model.
Returns the timeUnits of this Model.
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getVolumeUnits

Returns the value of the "volumeUnits" attribute of this Model.
Returns the volumeUnits of this Model.
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getAreaUnits

Returns the value of the "areaUnits" attribute of this Model.
Returns the areaUnits of this Model.
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getLengthUnits

Returns the value of the "lengthUnits" attribute of this Model.
Returns the lengthUnits of this Model.
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getExtentUnits

Returns the value of the "extentUnits" attribute of this Model.
Returns the extentUnits of this Model.
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::getConversionFactor

Returns the value of the "conversionFactor" attribute of this Model.
Returns the conversionFactor of this Model.
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetId

Predicate returning C<true> if this
Model's "id" attribute is set.
Returns C<true> if the "id" attribute of this Model is
set, C<false> otherwise.


=item Model::isSetName

Predicate returning C<true> if this
Model's "name" attribute is set.
Returns C<true> if the "name" attribute of this Model is
set, C<false> otherwise.


=item Model::isSetSubstanceUnits

Predicate returning C<true> if this
Model's "substanceUnits" attribute is set.
Returns C<true> if the "substanceUnits" attribute of this Model is
set, C<false> otherwise.
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetTimeUnits

Predicate returning C<true> if this
Model's "timeUnits" attribute is set.
Returns C<true> if the "timeUnits" attribute of this Model is
set, C<false> otherwise.
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetVolumeUnits

Predicate returning C<true> if this
Model's "volumeUnits" attribute is set.
Returns C<true> if the "volumeUnits" attribute of this Model is
set, C<false> otherwise.
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetAreaUnits

Predicate returning C<true> if this
Model's "areaUnits" attribute is set.
Returns C<true> if the "areaUnits" attribute of this Model is
set, C<false> otherwise.
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetLengthUnits

Predicate returning C<true> if this
Model's "lengthUnits" attribute is set.
Returns C<true> if the "lengthUnits" attribute of this Model is
set, C<false> otherwise.
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetExtentUnits

Predicate returning C<true> if this
Model's "extentUnits" attribute is set.
Returns C<true> if the "extentUnits" attribute of this Model is
set, C<false> otherwise.
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::isSetConversionFactor

Predicate returning C<true> if this
Model's "conversionFactor" attribute is set.
Returns C<true> if the "conversionFactor" attribute of this Model is
set, C<false> otherwise.
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setId

Sets the value of the "id" attribute of this Model.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Model::setName

Sets the value of the "name" attribute of this Model.
The string in C<name> is copied.
@param name the new name for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Model::setSubstanceUnits

Sets the value of the "substanceUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new substanceUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setTimeUnits

Sets the value of the "timeUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new timeUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setVolumeUnits

Sets the value of the "volumeUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new volumeUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setAreaUnits

Sets the value of the "areaUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new areaUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setLengthUnits

Sets the value of the "lengthUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new lengthUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setExtentUnits

Sets the value of the "extentUnits" attribute of this Model.
The string in C<units> is copied.
@param units the new extentUnits for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::setConversionFactor

Sets the value of the "conversionFactor" attribute of this Model.
The string in C<units> is copied.
@param units the new conversionFactor for the Model
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetId

Unsets the value of the "id" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Model::unsetName

Unsets the value of the "name" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Model::unsetSubstanceUnits

Unsets the value of the "substanceUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "substanceUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetTimeUnits

Unsets the value of the "timeUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "timeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetVolumeUnits

Unsets the value of the "volumeUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "volumeUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetAreaUnits

Unsets the value of the "areaUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "areaUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetLengthUnits

Unsets the value of the "lengthUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "lengthUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetExtentUnits

Unsets the value of the "extentUnits" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "extentUnits" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::unsetConversionFactor

Unsets the value of the "conversionFactor" attribute of this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "conversionFactor" attribute is available in 
SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.


=item Model::addFunctionDefinition

Adds a copy of the given FunctionDefinition object to this Model.
@param fd the FunctionDefinition to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createFunctionDefinition()
for a method that does not lead to these issues.
@see createFunctionDefinition()


=item Model::addUnitDefinition

Adds a copy of the given UnitDefinition object to this Model.
@param ud the UnitDefinition object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createUnitDefinition() for
a method that does not lead to these issues.
@see createUnitDefinition()


=item Model::addCompartmentType

Adds a copy of the given CompartmentType object to this Model.
@param ct the CompartmentType object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createCompartmentType()
for a method that does not lead to these issues.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see createCompartmentType()


=item Model::addSpeciesType

Adds a copy of the given SpeciesType object to this Model.
@param st the SpeciesType object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createSpeciesType() for a
method that does not lead to these issues.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see createSpeciesType()


=item Model::addCompartment

Adds a copy of the given Compartment object to this Model.
@param c the Compartment object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createCompartment() for a
method that does not lead to these issues.
@see createCompartment()


=item Model::addSpecies

Adds a copy of the given Species object to this Model.
@param s the Species object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createSpecies() for a
method that does not lead to these issues.
@see createSpecies()


=item Model::addParameter

Adds a copy of the given Parameter object to this Model.
@param p the Parameter object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createParameter() for a
method that does not lead to these issues.
@see createParameter()


=item Model::addInitialAssignment

Adds a copy of the given InitialAssignment object to this Model.
@param ia the InitialAssignment object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createInitialAssignment()
for a method that does not lead to these issues.
@see createInitialAssignment()


=item Model::addRule

Adds a copy of the given Rule object to this Model.
@param r the Rule object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see the methods
Model::createAlgebraicRule(), Model::createAssignmentRule() and
Model::createRateRule() for methods that do not lead to these issues.
@see createAlgebraicRule()
@see createAssignmentRule()
@see createRateRule()


=item Model::addConstraint

Adds a copy of the given Constraint object to this Model.
@param c the Constraint object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createConstraint() for a
method that does not lead to these issues.
@see createConstraint()


=item Model::addReaction

Adds a copy of the given Reaction object to this Model.
@param r the Reaction object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createReaction() for a
method that does not lead to these issues.
@see createReaction()


=item Model::addEvent

Adds a copy of the given Event object to this Model.
@param e the Event object to add
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Model.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Model</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Model::createEvent() for a method
that does not lead to these issues.
@see createEvent()


=item Model::createFunctionDefinition

Creates a new FunctionDefinition inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the FunctionDefinition object created
@see addFunctionDefinition(const FunctionDefinition  fd)


=item Model::createUnitDefinition

Creates a new UnitDefinition inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the UnitDefinition object created
@see addUnitDefinition(const UnitDefinition  ud)


=item Model::createUnit

Creates a new Unit object within the last UnitDefinition object
created in this model and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the UnitDefinition was created is not
significant.  If a UnitDefinition object does not exist in this model,
a new Unit is I<not> created and C<NULL> is returned instead.
Returns the Unit object created
@see addUnitDefinition(const UnitDefinition  ud)


=item Model::createCompartmentType

Creates a new CompartmentType inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the CompartmentType object created
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see addCompartmentType(const CompartmentType  ct)


=item Model::createSpeciesType

Creates a new SpeciesType inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the SpeciesType object created
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.
@see addSpeciesType(const SpeciesType  st)


=item Model::createCompartment

Creates a new Compartment inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Compartment object created
@see addCompartment(const Compartment  c)


=item Model::createSpecies

Creates a new Species inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Species object created
@see addSpecies(const Species  s)


=item Model::createParameter

Creates a new Parameter inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Parameter object created
@see addParameter(const Parameter  p)


=item Model::createInitialAssignment

Creates a new InitialAssignment inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the InitialAssignment object created
@see addInitialAssignment(const InitialAssignment  ia)


=item Model::createAlgebraicRule

Creates a new AlgebraicRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the AlgebraicRule object created
@see addRule(const Rule  r)


=item Model::createAssignmentRule

Creates a new AssignmentRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the AssignmentRule object created
@see addRule(const Rule  r)


=item Model::createRateRule

Creates a new RateRule inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the RateRule object created
@see addRule(const Rule  r)


=item Model::createConstraint

Creates a new Constraint inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Constraint object created
@see addConstraint(const Constraint  c)


=item Model::createReaction

Creates a new Reaction inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Reaction object created
@see addReaction(const Reaction  r)


=item Model::createReactant

Creates a new SpeciesReference object for a reactant inside the last
Reaction object in this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is I<not>
created and C<NULL> is returned instead.
Returns the SpeciesReference object created


=item Model::createProduct

Creates a new SpeciesReference object for a product inside the last
Reaction object in this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is I<not>
created and C<NULL> is returned instead.
Returns the SpeciesReference object created


=item Model::createModifier

Creates a new ModifierSpeciesReference object for a modifier species
inside the last Reaction object in this Model, and returns a pointer
to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new ModifierSpeciesReference is @em
not created and C<NULL> is returned instead.
Returns the SpeciesReference object created


=item Model::createKineticLaw

Creates a new KineticLaw inside the last Reaction object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, or a Reaction exists but already has a
KineticLaw, a new KineticLaw is I<not> created and C<NULL> is returned
instead.

Returns the KineticLaw object created


=item Model::createKineticLawParameter

Creates a new local Parameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The last KineticLaw object in this Model could have been created in a
variety of ways.  For example, it could have been added using
createKineticLaw(), or it could be the result of using
Reaction::createKineticLaw() on the Reaction object created by a
createReaction().  If a Reaction does not exist for this model, or the
last Reaction does not contain a KineticLaw object, a new Parameter is
I<not> created and C<NULL> is returned instead.
Returns the Parameter object created


=item Model::createKineticLawLocalParameter

Creates a new LocalParameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The last KineticLaw object in this Model could have been created in a
variety of ways.  For example, it could have been added using
createKineticLaw(), or it could be the result of using
Reaction::createKineticLaw() on the Reaction object created by a
createReaction().  If a Reaction does not exist for this model, or the
last Reaction does not contain a KineticLaw object, a new Parameter is
I<not> created and C<NULL> is returned instead.
Returns the Parameter object created


=item Model::createEvent

Creates a new Event inside this Model and returns it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
Returns the Event object created


=item Model::createEventAssignment

Creates a new EventAssignment inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Event object in this model was created
is not significant.  It could have been created in a variety of ways,
for example by using createEvent().  If no Event object exists in this
Model object, a new EventAssignment is I<not> created and C<NULL> is
returned instead.
Returns the EventAssignment object created


=item Model::createTrigger

Creates a new Trigger inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Event object in this model was created
is not significant.  It could have been created in a variety of ways,
for example by using createEvent().  If no Event object exists in this
Model object, a new Trigger is I<not> created and C<NULL> is
returned instead.
Returns the Trigger object created


=item Model::createDelay

Creates a new Delay inside the last Event object created in
this Model, and returns a pointer to it.
The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this
object's corresponding attributes.
The mechanism by which the last Event object in this model was created
is not significant.  It could have been created in a variety of ways,
for example by using createEvent().  If no Event object exists in this
Model object, a new Delay is I<not> created and C<NULL> is
returned instead.
Returns the Delay object created


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see appendAnnotation(const XMLNode  annotation)


=item Model::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see appendAnnotation(const std::string& annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see setAnnotation(const XMLNode  annotation)


=item Model::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike setAnnotation(), this 
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see setAnnotation(const std::string& annotation)


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
Returns the list of FunctionDefinitions for this Model.


=item Model::getListOfFunctionDefinitions

Get the ListOfFunctionDefinitions object in this Model.
Returns the list of FunctionDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
Returns the list of UnitDefinitions for this Model.


=item Model::getListOfUnitDefinitions

Get the ListOfUnitDefinitions object in this Model.
Returns the list of UnitDefinitions for this Model.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
Returns the list of CompartmentTypes for this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfCompartmentTypes

Get the ListOfCompartmentTypes object in this Model.
Returns the list of CompartmentTypes for this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
Returns the list of SpeciesTypes for this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfSpeciesTypes

Get the ListOfSpeciesTypes object in this Model.
Returns the list of SpeciesTypes for this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
Returns the list of Compartments for this Model.


=item Model::getListOfCompartments

Get the ListOfCompartments object in this Model.
Returns the list of Compartments for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
Returns the list of Species for this Model.


=item Model::getListOfSpecies

Get the ListOfSpecies object in this Model.
Returns the list of Species for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
Returns the list of Parameters for this Model.


=item Model::getListOfParameters

Get the ListOfParameters object in this Model.
Returns the list of Parameters for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
Returns the list of InitialAssignments for this Model.


=item Model::getListOfInitialAssignments

Get the ListOfInitialAssignments object in this Model.
Returns the list of InitialAssignment for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
Returns the list of Rules for this Model.


=item Model::getListOfRules

Get the ListOfRules object in this Model.
Returns the list of Rules for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
Returns the list of Constraints for this Model.


=item Model::getListOfConstraints

Get the ListOfConstraints object in this Model.
Returns the list of Constraints for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
Returns the list of Reactions for this Model.


=item Model::getListOfReactions

Get the ListOfReactions object in this Model.
Returns the list of Reactions for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
Returns the list of Events for this Model.


=item Model::getListOfEvents

Get the ListOfEvents object in this Model.
Returns the list of Events for this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
Returns the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get the nth FunctionDefinitions object in this Model.
Returns the nth FunctionDefinition of this Model.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
Returns the FunctionDefinition in this Model with the identifier
C<sid> or C<NULL> if no such FunctionDefinition exists.


=item Model::getFunctionDefinition

Get a FunctionDefinition object based on its identifier.
Returns the FunctionDefinition in this Model with the identifier
C<sid> or C<NULL> if no such FunctionDefinition exists.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
Returns the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get the nth UnitDefinition object in this Model.
Returns the nth UnitDefinition of this Model.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
Returns the UnitDefinition in this Model with the identifier C<sid> or
C<NULL> if no such UnitDefinition exists.


=item Model::getUnitDefinition

Get a UnitDefinition based on its identifier.
Returns the UnitDefinition in this Model with the identifier C<sid> or
C<NULL> if no such UnitDefinition exists.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
Returns the nth CompartmentType of this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get the nth CompartmentType object in this Model.
Returns the nth CompartmentType of this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
Returns the CompartmentType in this Model with the identifier C<sid>
or C<NULL> if no such CompartmentType exists.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartmentType

Get a CompartmentType object based on its identifier.
Returns the CompartmentType in this Model with the identifier C<sid>
or C<NULL> if no such CompartmentType exists.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
Returns the nth SpeciesType of this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get the nth SpeciesType object in this Model.
Returns the nth SpeciesType of this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
Returns the SpeciesType in this Model with the identifier C<sid> or
C<NULL> if no such SpeciesType exists.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getSpeciesType

Get a SpeciesType object based on its identifier.
Returns the SpeciesType in this Model with the identifier C<sid> or
C<NULL> if no such SpeciesType exists.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getCompartment

Get the nth Compartment object in this Model.
Returns the nth Compartment of this Model.


=item Model::getCompartment

Get the nth Compartment object in this Model.
Returns the nth Compartment of this Model.


=item Model::getCompartment

Get a Compartment object based on its identifier.
Returns the Compartment in this Model with the identifier C<sid> or
C<NULL> if no such Compartment exists.


=item Model::getCompartment

Get a Compartment object based on its identifier.
Returns the Compartment in this Model with the identifier C<sid> or
C<NULL> if no such Compartment exists.


=item Model::getSpecies

Get the nth Species object in this Model.
Returns the nth Species of this Model.


=item Model::getSpecies

Get the nth Species object in this Model.
Returns the nth Species of this Model.


=item Model::getSpecies

Get a Species object based on its identifier.
Returns the Species in this Model with the identifier C<sid> or C<NULL>
if no such Species exists.


=item Model::getSpecies

Get a Species object based on its identifier.
Returns the Species in this Model with the identifier C<sid> or C<NULL>
if no such Species exists.


=item Model::getParameter

Get the nth Parameter object in this Model.
Returns the nth Parameter of this Model.


=item Model::getParameter

Get the nth Parameter object in this Model.
Returns the nth Parameter of this Model.


=item Model::getParameter

Get a Parameter object based on its identifier.
Returns the Parameter in this Model with the identifier C<sid> or C<NULL>
if no such Parameter exists.


=item Model::getParameter

Get a Parameter object based on its identifier.
Returns the Parameter in this Model with the identifier C<sid> or C<NULL>
if no such Parameter exists.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
Returns the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get the nth InitialAssignment object in this Model.
Returns the nth InitialAssignment of this Model.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
Returns the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getInitialAssignment

Get an InitialAssignment object based on the symbol to which it
assigns a value.
Returns the InitialAssignment in this Model with the given "symbol"
attribute value or C<NULL> if no such InitialAssignment exists.


=item Model::getRule

Get the nth Rule object in this Model.
Returns the nth Rule of this Model.


=item Model::getRule

Get the nth Rule object in this Model.
Returns the nth Rule of this Model.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
Returns the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getRule

Get a Rule object based on the variable to which it assigns a value.
Returns the Rule in this Model with the given "variable" attribute
value or C<NULL> if no such Rule exists.


=item Model::getConstraint

Get the nth Constraint object in this Model.
Returns the nth Constraint of this Model.


=item Model::getConstraint

Get the nth Constraint object in this Model.
Returns the nth Constraint of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
Returns the nth Reaction of this Model.


=item Model::getReaction

Get the nth Reaction object in this Model.
Returns the nth Reaction of this Model.


=item Model::getReaction

Get a Reaction object based on its identifier.
Returns the Reaction in this Model with the identifier C<sid> or C<NULL>
if no such Reaction exists.


=item Model::getReaction

Get a Reaction object based on its identifier.
Returns the Reaction in this Model with the identifier C<sid> or C<NULL>
if no such Reaction exists.


=item Model::getSpeciesReference

Get a SpeciesReference object based on its identifier.
Returns the SpeciesReference in this Model with the identifier C<sid> or C<NULL>
if no such SpeciesReference exists.


=item Model::getSpeciesReference

Get a SpeciesReference object based on its identifier.
Returns the SpeciesReference in this Model with the identifier C<sid> or C<NULL>
if no such SpeciesReference exists.


=item Model::getEvent

Get the nth Event object in this Model.
Returns the nth Event of this Model.


=item Model::getEvent

Get the nth Event object in this Model.
Returns the nth Event of this Model.


=item Model::getEvent

Get an Event object based on its identifier.
Returns the Event in this Model with the identifier C<sid> or C<NULL> if
no such Event exists.


=item Model::getEvent

Get an Event object based on its identifier.
Returns the Event in this Model with the identifier C<sid> or C<NULL> if
no such Event exists.


=item Model::getNumFunctionDefinitions

Get the number of FunctionDefinition objects in this Model.
Returns the number of FunctionDefinitions in this Model.


=item Model::getNumUnitDefinitions

Get the number of UnitDefinition objects in this Model.
Returns the number of UnitDefinitions in this Model.


=item Model::getNumCompartmentTypes

Get the number of CompartmentType objects in this Model.
Returns the number of CompartmentTypes in this Model.
@note The CompartmentType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getNumSpeciesTypes

Get the number of SpeciesType objects in this Model.
Returns the number of SpeciesTypes in this Model.
@note The SpeciesType object class is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
Level&nbsp;1 nor Level&nbsp;3.


=item Model::getNumCompartments

Get the number of Compartment objects in this Model.
Returns the number of Compartments in this Model.


=item Model::getNumSpecies

Get the number of Specie objects in this Model.
Returns the number of Species in this Model.


=item Model::getNumSpeciesWithBoundaryCondition

Get the number of Species in this Model having their
"boundaryCondition" attribute value set to C<true>.
Returns the number of Species in this Model with boundaryCondition set
to true.


=item Model::getNumParameters

Get the number of Parameter objects in this Model.
Returns the number of Parameters in this Model.  Parameters defined in
KineticLaws are not included.


=item Model::getNumInitialAssignments

Get the number of InitialAssignment objects in this Model.
Returns the number of InitialAssignments in this Model.


=item Model::getNumRules

Get the number of Rule objects in this Model.
Returns the number of Rules in this Model.


=item Model::getNumConstraints

Get the number of Constraint objects in this Model.
Returns the number of Constraints in this Model.


=item Model::getNumReactions

Get the number of Reaction objects in this Model.
Returns the number of Reactions in this Model.


=item Model::getNumEvents

Get the number of Event objects in this Model.
Returns the number of Events in this Model.


=item Model::removeFromParentAndDelete

Finds this Model's parent SBMLDocument and calls setModel(NULL) on it, indirectly deleting itself.  Overridden from the SBase function since the parent is not a ListOf.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Model::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Model::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Model::isBoolean

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL1ToL2

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL1ToL3

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL2ToL3

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL2ToL1

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL3ToL1

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertL3ToL2

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::addModifiers

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::addConstantAttribute

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::setSpatialDimensions

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::addDefinitionsForDefaultUnits

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertParametersToLocals

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::setSpeciesReferenceConstantValueAndStoichiometry

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeMetaId

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeSBOTerms

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeHasOnlySubstanceUnits

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeSBOTermsNotInL2V2

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeDuplicateTopLevelAnnotations

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::removeParameterRuleUnits

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertStoichiometryMath

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::assignRequiredValues

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::dealWithModelUnits

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::dealWithStoichiometry

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::dealWithEvents

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::convertToL2Strict

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::setSBMLDocument

@internal

Predicate returning C<true> if the
given ASTNode is a boolean.
Often times, this question can be answered with the ASTNode's own
isBoolean() method, but if the AST is an expression that calls a
function defined in the Model's ListOfFunctionDefinitions, the model
is needed for lookup context.
Returns true if the given ASTNode is a boolean.


=item Model::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item Model::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Model::getElementName

Returns the XML element name of this object, which for Model, is
always C<"model">.
Returns the name of this element, i.e., C<"model">.


=item Model::getElementPosition

@internal

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.


=item Model::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Model::populateListFormulaUnitsData

Populates the list of FormulaDataUnits with the units derived 
for the model. The list contains elements of class
FormulaUnitsData. 

The first element of the list refers to the default units
of 'substance per time' derived from the model and has the
unitReferenceId 'subs_per_time'. This facilitates the comparison of units
derived from mathematical formula with the expected units.
The next elements of the list record the units of the 
compartments and species established from either explicitly
declared or default units.
The next elements record the units of any parameters.
Subsequent elements of the list record the units derived for
each mathematical expression encountered within the model.
@note This function is utilised by the Unit Consistency Validator.
The list is populated prior to running the validation and thus
the consistency of units can be checked by accessing the members
of the list and comparing the appropriate data.


=item Model::isPopulatedListFormulaUnitsData

Predicate returning C<true> if 
the list of FormulaUnitsData is populated.
Returns C<true> if the list of FormulaUnitsData is populated, 
C<false> otherwise.


=item Model::addFormulaUnitsData

@internal

Adds a copy of the given FormulaUnitsData object to this Model.
@param fud the FormulaUnitsData to add


=item Model::createFormulaUnitsData

@internal

Creates a new FormulaUnitsData inside this Model and returns it.
Returns the FormulaUnitsData object created


=item Model::getFormulaUnitsData

@internal

Get the nth FormulaUnitsData object in this Model.
Returns the nth FormulaUnitsData of this Model.


=item Model::getFormulaUnitsData

@internal

Get the nth FormulaUnitsData object in this Model.
Returns the nth FormulaUnitsData of this Model.


=item Model::getFormulaUnitsData

@internal

Get a FormulaUnitsData object based on its unitReferenceId and typecode.
Returns the FormulaUnitsData in this Model with the unitReferenceId C<sid> 
and the typecode (int) C<typecode> or C<NULL>
if no such FormulaUnitsData exists.
@note The typecode (int) parameter is necessary as the unitReferenceId
of the FormulaUnitsData need not be unique. For example if a Species
with id 's' is assigned by an AssignmentRule there will be two 
elements of the FormulaUnitsData list with the unitReferenceId 's'; 
one with
typecode 'SBML_SPECIES' referring to the units related to the species, 
the other with typecode 'SBML_ASSIGNMENT_RULE' referring to the units
derived from the math element of the AssignmentRule.


=item Model::getFormulaUnitsData

@internal

Get a FormulaUnitsData object based on its unitReferenceId and typecode.
Returns the FormulaUnitsData in this Model with the unitReferenceId C<sid> 
and the typecode (int) C<typecode> or C<NULL>
if no such FormulaUnitsData exists.
@note The typecode (int) parameter is necessary as the unitReferenceId
of the FormulaUnitsData need not be unique. For example if a Species
with id 's' is assigned by an AssignmentRule there will be two 
elements of the FormulaUnitsData list with the unitReferenceId 's'; 
one with
typecode 'SBML_SPECIES' referring to the units related to the species, 
the other with typecode 'SBML_ASSIGNMENT_RULE' referring to the units
derived from the math element of the AssignmentRule.


=item Model::getNumFormulaUnitsData

@internal

Get the number of FormulaUnitsData objects in this Model.
Returns the number of FormulaUnitsData in this Model.


=item Model::getListFormulaUnitsData

@internal

Get the list of FormulaUnitsData object in this Model.
Returns the list of FormulaUnitsData for this Model.


=item Model::getListFormulaUnitsData

@internal

Get the list of FormulaUnitsData object in this Model.
Returns the list of FormulaUnitsData for this Model.


=item Model::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Model object
have been set.
@note The required elements for a Model object are:
listOfCompartments (L1 only); listOfSpecies (L1V1 only);
listOfReactions(L1V1 only)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Model::removeFunctionDefinition

Removes the nth FunctionDefinition object from this Model object and 
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the FunctionDefinition object to remove
Returns the FunctionDefinition object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeFunctionDefinition

Removes the FunctionDefinition object with the given identifier from this Model 
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the FunctionDefinition objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the FunctionDefinition object to remove
Returns the FunctionDefinition object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no FunctionDefinition
object with the identifier exists in this Model object.


=item Model::removeUnitDefinition

Removes the nth UnitDefinition object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the UnitDefinition object to remove
Returns the UnitDefinition object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeUnitDefinition

Removes the UnitDefinition object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the UnitDefinition objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the UnitDefinition object to remove
Returns the UnitDefinition object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no UnitDefinition
object with the identifier exists in this Model object.


=item Model::removeCompartmentType

Removes the nth CompartmentType object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the CompartmentType object to remove
Returns the ComapartmentType object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeCompartmentType

Removes the CompartmentType object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the CompartmentType objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the object to remove
Returns the CompartmentType object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no CompartmentType
object with the identifier exists in this Model object.


=item Model::removeSpeciesType

Removes the nth SpeciesType object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the SpeciesType object to remove
Returns the SpeciesType object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeSpeciesType

Removes the SpeciesType object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the SpeciesType objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the SpeciesType object to remove
Returns the SpeciesType object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no SpeciesType
object with the identifier exists in this Model object.


=item Model::removeCompartment

Removes the nth Compartment object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Compartment object to remove
Returns the Compartment object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeCompartment

Removes the Compartment object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Compartment objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the Compartment object to remove
Returns the Compartment object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Compartment
object with the identifier exists in this Model object.


=item Model::removeSpecies

Removes the nth Species object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Species object to remove
Returns the Species object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeSpecies

Removes the Species object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Species objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the Species object to remove
Returns the Species object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Species
object with the identifier exists in this Model object.


=item Model::removeParameter

Removes the nth Parameter object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Parameter object to remove
Returns the Parameter object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeParameter

Removes the Parameter object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Parameter objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the Parameter object to remove
Returns the Parameter object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Parameter
object with the identifier exists in this Model object.


=item Model::removeInitialAssignment

Removes the nth InitialAssignment object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the InitialAssignment object to remove
Returns the InitialAssignment object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeInitialAssignment

Removes the InitialAssignment object with the given "symbol" attribute 
from this Model object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the InitialAssignment objects in this Model object have the
"symbol" attribute C<symbol>, then C<NULL> is returned.
@param symbol the "symbol" attribute of the InitialAssignment object to remove
Returns the InitialAssignment object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no InitialAssignment
object with the "symbol" attribute exists in this Model object.


=item Model::removeRule

Removes the nth Rule object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Rule object to remove
Returns the Rule object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeRule

Removes the Rule object with the given "variable" attribute from this Model 
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Rule objects in this Model object have the "variable" attribute
C<variable>, then C<NULL> is returned.
@param variable the "variable" attribute of the Rule object to remove
Returns the Rule object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Rule
object with the "variable" attribute exists in this Model object.


=item Model::removeConstraint

Removes the nth Constraint object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Constraint object to remove
Returns the Constraint object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeReaction

Removes the nth Reaction object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Reaction object to remove
Returns the Reaction object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeReaction

Removes the Reaction object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Reaction objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the Reaction object to remove
Returns the Reaction object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Reaction
object with the identifier exists in this Model object.


=item Model::removeEvent

Removes the nth Event object from this Model object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Event object to remove
Returns the Event object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Model::removeEvent

Removes the Event object with the given identifier from this Model
object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the Event objects in this Model object have the identifier 
C<sid>, then C<NULL> is returned.
@param sid the identifier of the Event object to remove
Returns the Event object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Event
object with the identifier exists in this Model object.


=item Model::appendFrom

Takes the contents of the passed-in Model, makes copies of everything, and appends those copies to the appropriate places in this Model.  Also calls 'appendFrom' on all plugin objects.
@param model the Model to merge with this one.


=item Model::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item Model::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item Model::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item Model::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Model::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Model::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Model::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Model::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Model::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Model::syncAnnotation

@internal

Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm), ModelHistory object 
(ModelHistory  mHistory) and ListOfLayouts object (ListOfLayouts mLayouts).
Currently, this method is called in getAnnotation, isSetAnnotation,
and writeElements methods.


=back

=head2 SBMLDocument

Container for an SBML document and interface for global operations
on SBML documents.
@if clike LibSBML uses the class SBMLDocument as a
top-level container for storing SBML content and data associated with it
(such as warnings and error messages).  The two primary means of reading
an SBML model, SBMLReader::readSBML() and
SBMLReader::readSBMLFromString(), both return a pointer to an
SBMLDocument object.  From there, callers can inquire about any errors
encountered (e.g., using SBMLDocument::getNumErrors()), access the Model
object, and perform other actions such as consistency-checking and model
translation.
@endif@if python LibSBML uses the class SBMLDocument as a
top-level container for storing SBML content and data associated with it
(such as warnings and error messages).  The two primary means of reading
an SBML model, SBMLReader::readSBML() and
SBMLReader::readSBMLFromString(), both return a pointer to an
SBMLDocument object.  From there, callers can inquire about any errors
encountered (e.g., using SBMLDocument::getNumErrors()), access the Model
object, and perform other actions such as consistency-checking and model
translation.
@endif@if java LibSBML uses the class SBMLDocument as a top-level
container for storing SBML content and data associated with it (such as
warnings and error messages).  The two primary means of reading an SBML
model, SBMLReader::readSBML(String filename) and
SBMLReader::readSBMLFromString(String xml), both return an SBMLDocument
object.  From there, callers can inquire about any errors encountered
(e.g., using SBMLDocument::getNumErrors()), access the Model object, and
perform other actions such as consistency-checking and model
translation.
@endif@~
When creating fresh models programmatically, the starting point is
typically the creation of an SBMLDocument object instance.  The
SBMLDocument constructor accepts arguments for the SBML Level and
Version of the model to be created.  After creating the SBMLDocument
object, calling programs then typically call SBMLDocument::createModel()
almost immediately, and then proceed to call the methods on the Model
object to fill out the model's contents.
SBMLDocument corresponds roughly to the class <i>Sbml</i> defined in the
SBML Level&nbsp;2 specification and <i>SBML</i> in the Level&nbsp;3
specification.  It does not have a direct correspondence in SBML
Level&nbsp;1.  (However, to make matters simpler for applications,
libSBML creates an SBMLDocument no matter whether the model is
Level&nbsp;1, Level&nbsp;2 or Level&nbsp;3.)  In its barest form, when written out in
XML format for (e.g.) SBML Level&nbsp;2 Version&nbsp;4, the corresponding
structure is the following:
@verbatim
<sbml xmlns="http://www.sbml.org/sbml/level2/version4" level="2" version="4">
...
</sbml>@endverbatim
SBMLDocument is derived from SBase, and therefore contains the usual SBase
attributes (in SBML Level&nbsp;2 and Level&nbsp;3) of "metaid" and "sboTerm", as
well as the subelements "notes" and "annotation".  It also contains the
attributes "level" and "version" indicating the Level and Version of the
SBML data structure.  These can be accessed using the methods defined by
the SBase class for that purpose.
@section checking Checking consistency and adherence to SBML specifications
One of the most important features of libSBML is its ability to perform
SBML validation to ensure that a model adheres to the SBML specification
for whatever Level+Version combination the model uses.  SBMLDocument
provides the methods for running consistency-checking and validation
rules on the SBML content.
First, a brief explanation of the rationale is in order.  In libSBML
versions up to and including the version&nbsp;3.3.x series, the
individual methods for creating and setting attributes and other
components were quite lenient, and allowed a caller to compose SBML
entities that might not, in the end, represent valid SBML.  This allowed
applications the freedom to do things such as save incomplete models
(which is useful when models are being developed over long periods of
time).  In the version&nbsp;4.x series, libSBML is somewhat stricter,
but still permits structures to be created independently and the results
to be combined in a separate step.  In all these cases, it means that a
separate validation step is necessary when a calling program finally
wants to finish a complete SBML document.
The primary interface to this validation facility is SBMLDocument's
SBMLDocument::checkInternalConsistency() and
SBMLDocument::checkConsistency().  The former verifies the basic
internal consistency and syntax of an SBML document, and the latter
implements more elaborate validation rules (both those defined by the
SBML specifications, as well as additional rules offered by libSBML).
@if clike The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks().  Applications can
selectively disable specific kinds of checks that they may not be
interested in, by calling SBMLDocument::setConsistencyChecks() with
appropriate parameters.
@endif@if python The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks().  Applications can
selectively disable specific kinds of checks that they may not be
interested in, by calling SBMLDocument::setConsistencyChecks() with
appropriate parameters.
@endif@if java The checks performed by SBMLDocument::checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the validation
performed by SBMLDocument::checkConsistency() is under program control
using the method SBMLDocument::setConsistencyChecks(int categ, boolean
onoff).  Applications can selectively disable specific kinds of checks
that they may not be interested by calling
SBMLDocument::setConsistencyChecks(int categ, boolean onoff) with
appropriate parameters.
@endif@~

These methods have slightly different relevance depending on whether a
model is created programmaticaly from scratch, or whether it is read in
from a file or data stream.  The following list summarizes the possible
scenarios.

<em>Scenario 1: Creating a model from scratch</em>.  Before writing out
the model, 
@li Call SBMLDocument::checkInternalConsistency(), then inquire about
the results by calling SBMLDocument::getNumErrors()
@li Call @if java SBMLDocument::setConsistencyChecks(int categ, boolean
onoff) @else SBMLDocument::setConsistencyChecks() @endif@~ to configure
which checks will be performed by SBMLDocument::checkConsistency()
@li Call SBMLDocument::checkConsistency(), then inquire about the results by
calling SBMLDocument::getNumErrors()
<em>Scenario 2: Reading a model from a file or data stream.</em> After
reading the model,
@li Basic consistency checks will have been performed automatically by
libSBML upon reading the content, so you only need to inquire about the
results by using SBMLDocument::getNumErrors()
@li Call @if java SBMLDocument::setConsistencyChecks(int categ, boolean
onoff) @else SBMLDocument::setConsistencyChecks() @endif@~ to configure
which checks are performed by SBMLDocument::checkConsistency()
@li Call SBMLDocument::checkConsistency(), then inquire about the results
by calling SBMLDocument::getNumErrors()
@if clike An example of using the consistency-checking
and validation facilities is provided in this manual in the
section @ref libsbml-example. @endif@~
@section converting Converting documents between Levels and Versions of SBML
LibSBML provides facilities for limited translation of SBML between
Levels and Versions of the SBML specifications.  The method for doing is
is @if java SBMLDocument::setLevelAndVersion(long lev, long ver, boolean strict) @else setLevelAndVersion() @endif.  In 
general, models can be converted upward without difficulty (e.g., from
SBML Level&nbsp;1 to Level&nbsp;2, or from an earlier Version of
Level&nbsp;2 to the latest Version of Level&nbsp;2).  Sometimes models
can be translated downward as well, if they do not use constructs
specific to more advanced Levels of SBML.
Calling @if java SBMLDocument::setLevelAndVersion(long lev, long ver, boolean strict) @else SBMLDocument::setLevelAndVersion() @endif@~ will not I<necessarily> lead
to a successful conversion.  The method will return a boolean value
to indicate success or failure.  Callers must check the error log (see 
next section) attached to the SBMLDocument object after calling
@if java SBMLDocument::setLevelAndVersion(long lev, long ver) @else SBMLDocument::setLevelAndVersion() @endif@~ in order to assess whether any
problems arose.
If an application is interested in translating to a lower Level and/or
Version of SBML within a Level, the following methods allow for prior
assessment of whether there is sufficient compatibility to make a
translation possible:

=over


=item

SBMLDocument::checkL1Compatibility(),

=item

SBMLDocument::checkL2v1Compatibility(),

=item

SBMLDocument::checkL2v2Compatibility(),

=item

SBMLDocument::checkL2v3Compatibility(), 

=item

SBMLDocument::checkL2v4Compatibility(), and

=item

SBMLDocument::checkL3v1Compatibility().

=back


Some changes between Versions of SBML Level&nbsp;2 may lead to
unexpected behaviors when attempting conversions in either direction.
For example, SBML Level&nbsp;2 Version&nbsp;4 relaxed the requirement
for consistency in units of measurement between expressions annd
quantities in a model.  As a result, a model written in Version&nbsp;4,
if converted to Version&nbsp;3 with no other changes, may fail
validation as a Version&nbsp;3 model because Version&nbsp;3 imposed
stricter requirements on unit consistency.
Other changes between SBML Level 2 and Level 3 make downward conversions
challenging.  In some cases, it means that a model converted to
Level&nbsp;2 from Level&nbsp;3 will contain attributes that were not
explicitly given in the Level&nbsp;3 model, because in Level&nbsp;2
these attributes may have been optional or have default values.
@section errors Error handling
Upon reading a model, SBMLDocument logs any problems encountered while
reading the model from the file or data stream.  The log contains
objects that record diagnostic information about any notable issues that
arose.  Whether the problems are warnings or errors, they are both
reported through a single common interface involving the object class
SBMLError.

The methods SBMLDocument::getNumErrors(), @if java SBMLDocument::getError(long n) @else SBMLDocument::getError() @endif@~ and
SBMLDocument::printErrors() allow callers to interact with the warnings
or errors logged.  Alternatively, callers may retrieve the entire log as
an SBMLErrorLog object using the method SBMLDocument::getErrorLog().
The SBMLErrorLog object provides some alternative methods for
interacting with the set of errors and warnings.  In either case,
applications typically should first call SBMLDocument::getNumErrors() to
find out if any issues have been logged after specific libSBML
operations such as the ones discussed in the sections above.  If they
have, then an application will should proceed to inspect the individual
reports using either the direct interfaces on SBMLDocument or using the
methods on the SBMLErrorLog object.
@if clike An example of using the error facility is
provided in this manual in the
section @ref libsbml-example. @endif@~

=over


=item SBMLDocument::getDefaultLevel

The default SBML Level of new SBMLDocument objects.
This "default Level" corresponds to the most recent SBML specification
Level available at the time libSBML version @htmlinclude libsbml-version.html
was released.  For this copy of libSBML, the value is C<3>.
The default Level is used by SBMLDocument if no Level is explicitly
specified at the time of the construction of an SBMLDocument instance.
Returns an integer indicating the most recent SBML specification Level
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLDocument), and the
other will be a standalone top-level function with the name
SBMLDocument_getDefaultLevel(). They are functionally
identical. @endif@~
@see @if clike getDefaultVersion() @else SBMLDocument::getDefaultVersion() @endif@~


=item SBMLDocument::getDefaultVersion

The default Version of new SBMLDocument objects.
This "default Version" corresponds to the most recent Version
within the most recent Level of SBML available at the time libSBML
version @htmlinclude libsbml-version.html
was released.  For this copy of libSBML, the value is C<1>
(where the default Level of SBML is C<3>).  The default
Version is used by SBMLDocument if no Version is explicitly specified
at the time of the construction of an SBMLDocument instance.
Returns an integer indicating the most recent SBML specification
Version

@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., SBMLDocument), and the
other will be a standalone top-level function with the name
SBMLDocument_getDefaultVersion(). They are functionally
identical. @endif@~
@see @if clike getDefaultLevel() @else SBMLDocument::getDefaultLevel() @endif@~


=item SBMLDocument::SBMLDocument

Creates a new SBMLDocument, optionally with given values for the SBML
Level and Version.
If <em>both</em> the SBML Level and Version attributes are not
specified, the SBML document is treated as having the latest Level and
Version of SBML as determined by SBMLDocument::getDefaultLevel() and
SBMLDocument::getDefaultVersion(); <em>however</em>, the SBMLDocument
object is otherwise left blank.  In particular, the blank SBMLDocument
object has no associated XML attributes, including (but not limited
to) an XML namespace declaration.  The XML namespace declaration is
not added until the model is written out, <em>or</em> the method
SBMLDocument::setLevelAndVersion(@if java long lev, long ver, boolean strict@endif)
is called.  This may be important to keep in mind
if an application needs to add additional XML namespace declarations
on the C<&lt;sbml&gt;> element.  Application writers should
either provide values for C<level> and C<version> on the call to this
constructor, or else call
SBMLDocument::setLevelAndVersion(@if java long lev, long ver, boolean strict@endif)
shortly after creating the SBMLDocument object.
@param level an integer for the SBML Level
@param version an integer for the Version within the SBML Level
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~
@see SBMLDocument::setLevelAndVersion(@if java long lev, long ver, boolean strict@endif)
@see getDefaultLevel()
@see getDefaultVersion()


=item SBMLDocument::SBMLDocument

Creates a new SBMLDocument using the given SBMLNamespaces object 
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.


=item SBMLDocument::SBMLDocument

Copy constructor; creates a copy of this SBMLDocument.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item SBMLDocument::accept

Accepts the given SBMLVisitor for this instance of SBMLDocument.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SBMLDocument::clone

Creates and returns a deep copy of this SBMLDocument.
Returns a (deep) copy of this SBMLDocument.


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model m@endif).
This method returns C<NULL> if a model does not yet exist.
Returns the Model contained in this SBMLDocument.
@see createModel()


=item SBMLDocument::getModel

Returns the Model object stored in this SBMLDocument.
It is important to note that this method <em>does not create</em> a
Model instance.  The model in the SBMLDocument must have been created
at some prior time, for example using SBMLDocument::createModel() 
or SBMLDocument::setModel(@if java Model m@endif).
This method returns C<NULL> if a model does not yet exist.
Returns the Model contained in this SBMLDocument.
@see createModel()


=item SBMLDocument::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item SBMLDocument::getElementByMetaId

Returns the first child element it can find with the given metaid, or itself if it has the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item SBMLDocument::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item SBMLDocument::expandFunctionDefinitions

Removes FunctionDefinition constructs from the document and expands
any instances of their use within C<&lt;math&gt;> elements.
For example, suppose a Model contains a FunctionDefinition with
identifier C<"f"> representing the math expression: <em>f(x, y) = x  
y</em>.  Suppose further that there is a reaction in which the
C<&lt;math&gt;> element of the KineticLaw object contains
C<f(s, p)>, where C<s> and C<p> are other identifiers
defined in the model.  The outcome of invoking this method is that the
C<&lt;math&gt;> of the KineticLaw now represents the
expression <em>s   p</em> and the model no longer contains any
FunctionDefinition objects.
Returns bool C<true> if the transformation was successful, 
C<false>, otherwise.
@note This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return @c
false.


=item SBMLDocument::expandInitialAssignments

Removes InitialAssignment constructs from the document and
replaces them with appropriate values.
For example, suppose a Model contains a InitialAssignment to a symbol
C<"k"> where C<"k"> is the identifier of a Parameter.  The outcome of
invoking this method is that the "value" attribute of the Parameter
definition is set to the result calculated using the InitialAssignment
object's C<&lt;math&gt;> formula, and the corresponding
InitialAssignment is then removed from the Model.
Returns bool C<true> if the transformation was successful, 
C<false>, otherwise.
@note This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return @c
false.  As part of that process, this method will check that it has
values for any components referred to by the C<&lt;math&gt;>
elements of InitialAssignment objects.  In cases where not all of the
values have been declared (e.g., if the mathematical expression refers
to model entities that have no declared values), the InitialAssignment
in question will I<not> be removed and this method will return @c
false.


=item SBMLDocument::setLevelAndVersion

Sets the SBML Level and Version of this SBMLDocument instance,
attempting to convert the model as needed.
This method is the principal way in libSBML to convert models between
Levels and Versions of SBML.  Generally, models can be converted
upward without difficulty (e.g., from SBML Level&nbsp;1 to
Level&nbsp;2, or from an earlier Version of Level&nbsp;2 to the latest
Version of Level&nbsp;2).  Sometimes models can be translated downward
as well, if they do not use constructs specific to more advanced
Levels of SBML.
Before calling this method, callers may check compatibility directly
using the methods SBMLDocument::checkL1Compatibility(),
SBMLDocument::checkL2v1Compatibility(),
SBMLDocument::checkL2v2Compatibility(),
SBMLDocument::checkL2v3Compatibility(),
SBMLDocument::checkL2v4Compatibility(), and
SBMLDocument::checkL3v1Compatibility().

The valid combinations of SBML Level and Version as of this release
of libSBML are the following: 

=over


=item

Level&nbsp;1 Version&nbsp;2

=item

Level&nbsp;2 Version&nbsp;1

=item

Level&nbsp;2 Version&nbsp;2

=item

Level&nbsp;2 Version&nbsp;3

=item

Level&nbsp;2 Version&nbsp;4

=item

Level&nbsp;3 Version&nbsp;1

=back


Strict conversion applies the additional criteria that both the
source and the target model must be consistent SBML.  Users can
control the consistency checks that are applied using the
SBMLDocument::setConsistencyChecksForConversion(@if java int categ, boolean onoff@endif) method.  If either
the source or the potential target model have validation errors, the
conversion is not performed.  When a strict conversion is successful,
the underlying SBML object model is altered to reflect the new level
and version.  Thus, information that cannot be converted
(e.g. sboTerms) will be lost.
@param level the desired SBML Level
@param version the desired Version within the SBML Level
@param strict boolean indicating whether to check consistency
of both the source and target model when performing
conversion (defaults to C< true >)
Returns C<true> if the level and version of the document were
successfully set to the requested values (which may have required
conversion of the model), C<false> otherwise.
@note Calling this method will not I<necessarily> lead to a successful
conversion.  If the conversion fails, it will be logged in the error
list associated with this SBMLDocument.  Callers should consult
getNumErrors() to find out if the conversion succeeded without
problems.  For conversions from Level&nbsp;2 to Level&nbsp;1, callers
can also check the Level of the model after calling this method to
find out whether it is Level&nbsp;1.  (If the conversion to
Level&nbsp;1 failed, the Level of this model will be left unchanged.)
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~
@see checkL1Compatibility()
@see checkL2v1Compatibility()
@see checkL2v2Compatibility()
@see checkL2v3Compatibility()
@see checkL2v4Compatibility()
@see checkL3v1Compatibility()
@see checkL3v1Compatibility()


=item SBMLDocument::updateSBMLNamespace

@internal

@param package
@param level
@param version


=item SBMLDocument::setModel

Sets the Model for this SBMLDocument to a copy of the given Model.
@param m the new Model to use.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@see createModel()
@see getModel()


=item SBMLDocument::createModel

Creates a new Model inside this SBMLDocument, and returns a pointer to
it.

In SBML Level&nbsp;2, the use of an identifier on a Model object is
optional.  This method takes an optional argument, C<sid>, for setting
the identifier.  If not supplied, the identifier attribute on the
Model instance is not set.
@param sid the identifier of the new Model to create.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~
@see getModel()
@see SBMLDocument::setModel(@if java Model m@endif)


=item SBMLDocument::setLocationURI

Sets the location of this SBMLDocument.  Called automatically when
readSBMLFromFile is used, but may be set manually as well.


=item SBMLDocument::getLocationURI

Get the location of this SBMLDocument.  If this document was 
read from a file or had its location set manually, that filename
or set location will be returned, otherwise, an empty string is returned.


=item SBMLDocument::setConsistencyChecks

Controls the consistency checks that are performed when
SBMLDocument::checkConsistency() is called.
This method works by adding or subtracting consistency checks from the
set of all possible checks that SBMLDocument::checkConsistency() knows
how to perform.  This method may need to be called multiple times in
order to achieve the desired combination of checks.  The first
argument (C<category>) in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument (C<apply>, a boolean) indicates whether to turn it on
(value of C<true>) or off (value of C<false>).
@if clike
The possible categories (values to the argument C<category>) are the
set of values from the enumeration #SBMLErrorCategory_t.
The following are the possible choices:
@endif@if java
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class {@link libsbmlConstants}.
The following are the possible choices:
@endif@if python 
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class @link libsbml libsbml@endlink.
The following are the possible choices:
@endif@~

=over


=item

@link SBMLErrorCategory_t#LIBSBML_CAT_GENERAL_CONSISTENCY
LIBSBML_CAT_GENERAL_CONSISTENCY@endlink: Correctness and consistency
of specific SBML language constructs.  Performing this set of checks
is highly recommended.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 2xxxx in
the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1
specifications.


=item

@link SBMLErrorCategory_t#LIBSBML_CAT_IDENTIFIER_CONSISTENCY
LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink: Correctness and
consistency of identifiers used for model entities.  An example of
inconsistency would be using a species identifier in a reaction rate
formula without first having declared the species.  With respect to
the SBML specification, these concern failures in applying the
validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
and Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_UNITS_CONSISTENCY
LIBSBML_CAT_UNITS_CONSISTENCY@endlink: Consistency of measurement
units associated with quantities in a model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 105xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_MATHML_CONSISTENCY
LIBSBML_CAT_MATHML_CONSISTENCY@endlink: Syntax of MathML constructs.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 102xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_SBO_CONSISTENCY
LIBSBML_CAT_SBO_CONSISTENCY@endlink: Consistency and validity of SBO
identifiers (if any) used in the model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_OVERDETERMINED_MODEL
LIBSBML_CAT_OVERDETERMINED_MODEL@endlink: Static analysis of whether
the system of equations implied by a model is mathematically
overdetermined.  With respect to the SBML specification, this is
validation rule #10601 in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and
Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_MODELING_PRACTICE
LIBSBML_CAT_MODELING_PRACTICE@endlink: Additional checks for
recommended good modeling practice. (These are tests performed by
libSBML and do not have equivalent SBML validation rules.)

=back


<em>By default, all validation checks are applied</em> to the model in
an SBMLDocument object I<unless>
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
is called to indicate that only a subset should be applied.  Further,
this default (i.e., performing all checks) applies separately to
<em>each new SBMLDocument object</em> created.  In other words, each
time a model is read using SBMLReader::readSBML(@if java String filename@endif),
SBMLReader::readSBMLFromString(@if java String xml@endif),
or the global functions readSBML() and readSBMLFromString(), a new
SBMLDocument is created and for that document, a call to
SBMLDocument::checkConsistency() will default to applying all possible checks.
Calling programs must invoke
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
for each such new model if they wish to change the consistency checks
applied.

@param category a value drawn from @if clike #SBMLErrorCategory_t@else
the set of SBML error categories@endif@~ indicating the
consistency checking/validation to be turned on or off.
@param apply a boolean indicating whether the checks indicated by
C<category> should be applied or not.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::setConsistencyChecksForConversion

Controls the consistency checks that are performed when
SBMLDocument::setLevelAndVersion(@if java long lev, long ver, boolean strict@endif) is called.
This method works by adding or subtracting consistency checks from the
set of all possible checks that may be performed to avoid conversion
to or from an invalid document.  This method may need to be called 
multiple times in
order to achieve the desired combination of checks.  The first
argument (C<category>) in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument (C<apply>, a boolean) indicates whether to turn it on
(value of C<true>) or off (value of C<false>).
@if clike
The possible categories (values to the argument C<category>) are the
set of values from the enumeration #SBMLErrorCategory_t.
The following are the possible choices:
@endif@if java
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class {@link libsbmlConstants}.
The following are the possible choices:
@endif@if python 
The possible categories (values to the argument C<category>) are the
set of constants whose names begin with the characters C<LIBSBML_CAT_>
in the interface class @link libsbml libsbml@endlink.
The following are the possible choices:
@endif@~

=over


=item

@link SBMLErrorCategory_t#LIBSBML_CAT_GENERAL_CONSISTENCY
LIBSBML_CAT_GENERAL_CONSISTENCY@endlink: Correctness and consistency
of specific SBML language constructs.  Performing this set of checks
is highly recommended.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 2xxxx in
the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1
specifications.


=item

@link SBMLErrorCategory_t#LIBSBML_CAT_IDENTIFIER_CONSISTENCY
LIBSBML_CAT_IDENTIFIER_CONSISTENCY@endlink: Correctness and
consistency of identifiers used for model entities.  An example of
inconsistency would be using a species identifier in a reaction rate
formula without first having declared the species.  With respect to
the SBML specification, these concern failures in applying the
validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
and Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_UNITS_CONSISTENCY
LIBSBML_CAT_UNITS_CONSISTENCY@endlink: Consistency of measurement
units associated with quantities in a model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 105xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_MATHML_CONSISTENCY
LIBSBML_CAT_MATHML_CONSISTENCY@endlink: Syntax of MathML constructs.
With respect to the SBML specification, these concern failures in
applying the validation rules numbered 102xx in the Level&nbsp;2
Versions&nbsp;2&ndash;4 and Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_SBO_CONSISTENCY
LIBSBML_CAT_SBO_CONSISTENCY@endlink: Consistency and validity of SBO
identifiers (if any) used in the model.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and Level&nbsp;3
Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_OVERDETERMINED_MODEL
LIBSBML_CAT_OVERDETERMINED_MODEL@endlink: Static analysis of whether
the system of equations implied by a model is mathematically
overdetermined.  With respect to the SBML specification, this is
validation rule #10601 in the Level&nbsp;2 Versions&nbsp;2&ndash;4 and
Level&nbsp;3 Version&nbsp;1 specifications.

=item

@link SBMLErrorCategory_t#LIBSBML_CAT_MODELING_PRACTICE
LIBSBML_CAT_MODELING_PRACTICE@endlink: Additional checks for
recommended good modeling practice. (These are tests performed by
libSBML and do not have equivalent SBML validation rules.)

=back


<em>By default, all validation checks are applied</em> to the model in
an SBMLDocument object I<unless>
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
is called to indicate that only a subset should be applied.  Further,
this default (i.e., performing all checks) applies separately to
<em>each new SBMLDocument object</em> created.  In other words, each
time a model is read using SBMLReader::readSBML(@if java String filename@endif),
SBMLReader::readSBMLFromString(@if java String xml@endif),
or the global functions readSBML() and readSBMLFromString(), a new
SBMLDocument is created and for that document, a call to
SBMLDocument::checkConsistency() will default to applying all possible checks.
Calling programs must invoke
SBMLDocument::setConsistencyChecks(@if java int categ, boolean onoff@endif)
for each such new model if they wish to change the consistency checks
applied.

@param category a value drawn from @if clike #SBMLErrorCategory_t@else
the set of SBML error categories@endif@~ indicating the consistency
checking/validation to be turned on or off.
@param apply a boolean indicating whether the checks indicated by
C<category> should be applied or not.
@see SBMLDocument::setLevelAndVersion(@if java long lev, long ver, boolean strict@endif)


=item SBMLDocument::checkConsistency

Performs consistency checking and validation on this SBML document.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
SBMLDocument::getError(@if java long n@endif) to determine the nature of the failures.
Returns the number of failed checks (errors) encountered.
@see SBMLDocument::checkInternalConsistency()


=item SBMLDocument::validateSBML

Performs consistency checking and validation on this SBML document.
If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings I<or> errors.  Callers should inspect the severity
flag in the individual SBMLError objects returned by
SBMLDocument::getError(@if java long n@endif) to determine the nature of the failures.
@note unlike checkConsistency this method will write the document
in order to determine all errors for the document. This will 
also clear the error log. 
Returns the number of failed checks (errors) encountered.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkInternalConsistency

Performs consistency checking on libSBML's internal representation of 
an SBML Model.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.
The distinction between this method and
SBMLDocument::checkConsistency() is that this method reports on
fundamental syntactic and structural errors that violate the XML
Schema for SBML; by contrast, SBMLDocument::checkConsistency()
performs more elaborate model verifications and also validation
according to the validation rules written in the appendices of the
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 specification documents.
@see SBMLDocument::checkConsistency()


=item SBMLDocument::checkL1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;1 and can be converted
to Level&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;1 and can
be converted to Level&nbsp;2 Version&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v2Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;2 and can
be converted to Level&nbsp;2 Version&nbsp;2.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v3Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;3 and can
be converted to Level&nbsp;2 Version&nbsp;3.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL2v4Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;2 Version&nbsp;4 and can
be converted to Level&nbsp;2 Version&nbsp;4.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::checkL3v1Compatibility

Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level&nbsp;3 Version&nbsp;1 and can
be converted to Level&nbsp;3 Version&nbsp;1.
Callers should query the results of the consistency check by calling
SBMLDocument::getError(@if java long n@endif).
Returns the number of failed checks (errors) encountered.


=item SBMLDocument::getError

Returns the nth error or warning encountered during parsing,
consistency checking, or attempted translation of this model.
Callers can use method XMLError::getSeverity() on the result to assess
the severity of the problem.  The possible severity levels range from
informational messages to fatal errors.
Returns the error or warning indexed by integer C<n>, or return @c
NULL if C<n &gt; (getNumErrors() - 1)>.
@param n the integer index of the error sought.
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNumErrors

Returns the number of errors or warnings encountered during parsing,
consistency checking, or attempted translation of this model.
Returns the number of errors or warnings encountered
@see SBMLDocument::getError(unsigned int n)


=item SBMLDocument::printErrors

Prints all the errors or warnings encountered trying to parse,
check, or translate this SBML document.
It prints the text to the stream given by the optional parameter @p
stream.  If no parameter is given, it prints the output to the
standard error stream.
If no errors have occurred, i.e., C<getNumErrors() == 0>, no
output will be sent to the stream.
The format of the output is:
@verbatim
N error(s):
line NNN: (id) message
@endverbatim

@param stream the ostream or ostringstream object indicating where
the output should be printed.
@if notcpp @htmlinclude warn-default-args-in-docs.html @endif@~
@see getNumErrors()
@see getErrorLog()
@see SBMLDocument::getError(unsigned int n)


=item SBMLDocument::setSBMLDocument

@internal

No-op; it is provided for consistency with the method available on
other libSBML object classes but has no effect on SBMLDocument.


=item SBMLDocument::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item SBMLDocument::convert

@internal

Converts this document using the converter that best matches
the given conversion properties. 
@param props the conversion properties to use
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED  @endlink
@li @link OperationReturnValues_t#LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE  @endlink


=item SBMLDocument::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item SBMLDocument::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see SBMLDocument::getElementName()


=item SBMLDocument::getElementName

Returns the XML element name of this object, which for SBMLDocument,
is always C<"sbml">.
Returns the name of this element, i.e., C<"sbml">.


=item SBMLDocument::getErrorLog

Returns the list of errors or warnings logged during parsing, 
consistency checking, or attempted translation of this model.
Returns the SBMLErrorLog used for this SBMLDocument
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getErrorLog

Returns a constant pointer to the list of errors or warnings 
logged during parsing, consistency checking, or attempted translation 
of this model.
Returns the SBMLErrorLog used for this SBMLDocument
@see SBMLDocument::getNumErrors()


=item SBMLDocument::getNamespaces

Returns a list of XML Namespaces associated with the XML content
of this SBML document.
Returns the XML Namespaces associated with this SBML object


=item SBMLDocument::enableDefaultNS

Set/unset default namespace to each top-level element defined in the
given package extension.
This works by adding a C<xmlns=&quot;...&quot;> attribute.  No
prefix will be written when writing elements defined in the given
package extension if C<true> is given as second argument.
@param package the name or URI of the package extension.
@param flag boolean value to indicate whether to write a namespace
prefix.

Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION @endlink


=item SBMLDocument::isEnabledDefaultNS

Returns C<true> if a default namespace is added to each top-level
element defined in the given package extension, otherwise returns
C<false>.
This basically checks if the attribute
C<xmlns=&quot;...&quot;> is present.
@param package the name or URI of the package extension.
Returns a boolean


=item SBMLDocument::setPackageRequired

Sets the C<required> attribute value of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@param flag Boolean value indicating whether the package is required.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION @endlink


=item SBMLDocument::getPackageRequired

Returns the C<required> attribute of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
Returns Boolean flag indicating whether the package is flagged as
being required.


=item SBMLDocument::isSetPackageRequired

Returns C<true> if the required attribute of the given package extension
is defined, otherwise returns C<false>.
@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
Returns a Boolean


=item SBMLDocument::isIgnoredPackage

Returns C<true> if the given package extension is one of an ignored
packages, otherwise returns C<false>.
An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.
@param pkgURI the URI of the package extension.
Returns a Boolean, C<true> if the package is being ignored and
C<false> otherwise.


=item SBMLDocument::setPkgRequired

Sets the value of the C<required> attribute for the given
package.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
@param flag a Boolean value.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_PKG_UNKNOWN_VERSION LIBSBML_PKG_UNKNOWN_VERSION @endlink
@deprecated Replaced in libSBML 5.2.0 by
setPackageRequired(@if java String package, boolean flag@endif)


=item SBMLDocument::getPkgRequired

Returns the C<required> attribute of the given package
extension.

@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
Returns a Boolean value indicating whether the package is flagged as
being required in this SBML document.
@deprecated Replaced in libSBML 5.2.0 by
getPackageRequired(@if java String package flag@endif)


=item SBMLDocument::isSetPkgRequired

Returns C<true> if the required attribute of the given package extension
is defined, otherwise returns C<false>.
@note The name of package must not be given if the package is not
enabled.

@param package the name or URI of the package extension.
Returns a Boolean value.
@deprecated Replaced in libSBML 5.2.0 by
isSetPackageRequired(@if java String package flag@endif)


=item SBMLDocument::isIgnoredPkg

Returns C<true> if the given package extension is one of ignored
packages, otherwise returns C<false>.
An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.
@param pkgURI the URI of the package extension.
Returns a boolean
@deprecated Replaced in libSBML 5.2.0 by
isIgnoredPackage(@if java String pkgURI flag@endif)


=item SBMLDocument::getElementPosition

@internal

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.


=item SBMLDocument::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item SBMLDocument::getApplicableValidators

@internal

Validation system.


=item SBMLDocument::getConversionValidators

@internal

Validation system.


=item SBMLDocument::setApplicableValidators

@internal

Validation system.


=item SBMLDocument::setConversionValidators

@internal

Validation system.


=item SBMLDocument::getNumValidators

@internal

Validation system.


=item SBMLDocument::clearValidators

@internal

Validation system.


=item SBMLDocument::addValidator

@internal

Validation system.


=item SBMLDocument::getValidator

@internal

Validation system.


=item SBMLDocument::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item SBMLDocument::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item SBMLDocument::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SBMLDocument::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item SBMLDocument::writeXMLNS

@internal


Subclasses should override this method to write their xmlns attriubutes
(if any) to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=back

=head2 FunctionDefinition

LibSBML implementation of SBML's FunctionDefinition construct.
The FunctionDefinition structure associates an identifier with a
function definition.  This identifier can then be used as the function
called in subsequent MathML content elsewhere in an SBML model.
FunctionDefinition has one required attribute, "id", to give the
function a unique identifier by which other parts of an SBML model
definition can refer to it.  A FunctionDefinition instance can also have
an optional "name" attribute of type C<string>.  Identifiers and names
must be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

FunctionDefinition has a required "math" subelement containing a MathML
expression defining the function body.  The content of this element can
only be a MathML "lambda" element.  The "lambda" element must begin with
zero or more "bvar" elements, followed by any other of the elements in
the MathML subset allowed in SBML Level 2 I<except> "lambda" (i.e., a
"lambda" element cannot contain another "lambda" element).  This is the
only place in SBML where a "lambda" element can be used.  The function
defined by a FunctionDefinition is only available for use in other
MathML elements that I<follow> the FunctionDefinition definition in the
model.  (These restrictions prevent recursive and mutually-recursive
functions from being expressed.)
A further restriction on the content of "math" is that it cannot contain
references to variables other than the variables declared to the
"lambda" itself.  That is, the contents of MathML "ci" elements inside
the body of the "lambda" can only be the variables declared by its
"bvar" elements, or the identifiers of other FunctionDefinition
instances in the model.  This means must be written so that all
variables or parameters used in the MathML content are passed to them
via their function parameters.  In SBML Level&nbsp;2, this restriction
applies also to the MathML C<csymbol> elements for I<time> and @em
delay; in SBML Level&nbsp;3, it additionally applies to the C<csymbol>
element for I<avogadro>.
@note Function definitions (also informally known as user-defined
functions) were introduced in SBML Level 2.  They have purposefully
limited capabilities.  A function cannot reference parameters or other
model quantities outside of itself; values must be passed as parameters
to the function.  Moreover, recursive and mutually-recursive functions
are not permitted.  The purpose of these limitations is to balance power
against complexity of implementation.  With the restrictions as they
are, function definitions could be implemented as textual
substitutions&mdash;they are simply macros.  Software implementations
therefore do not need the full function-definition machinery typically
associated with programming languages.
<br><br>
Another important point to note is FunctionDefinition does not
have a separate attribute for defining the units of the value returned
by the function.  The units associated with the function's return value,
when the function is called from within MathML expressions elsewhere in
SBML, are simply the overall units of the expression in
FunctionDefinition's "math" subelement when applied to the arguments
supplied in the call to the function.  Ascertaining these units requires
performing dimensional analysis on the expression.  (Readers may wonder
why there is no attribute.  The reason is that having a separate
attribute for declaring the units would not only be redundant, but also
lead to the potential for having conflicting information.  In the case
of a conflict between the declared units and those of the value actually
returned by the function, the only logical resolution rule would be to
assume that the correct units are those of the expression anyway.)
<!---------------------------------------------------------------------- -->

=over


=back

=head2 ListOfFunctionDefinitions

LibSBML implementation of SBML's ListOfFunctionDefinitions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this FunctionDefinition
@param version an unsigned int, the SBML Version to assign to this
FunctionDefinition

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a FunctionDefinition object to an
SBMLDocument (e.g., using Model::addFunctionDefinition(@if java FunctionDefinition f@endif)), the SBML
Level, SBML Version and XML namespace of the document @em
override the values used when creating the FunctionDefinition object
via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a FunctionDefinition is
an important aid to producing valid SBML.  Knowledge of the intented
SBML Level and Version determine whether it is valid to assign a
particular value to an attribute, or whether it is valid to add an
object to an existing SBMLDocument.


=item FunctionDefinition::FunctionDefinition

Creates a new FunctionDefinition using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a FunctionDefinition object to an
SBMLDocument (e.g., using Model::addFunctionDefinition(@if java FunctionDefinition f@endif)), the SBML
XML namespace of the document I<overrides> the value used when
creating the FunctionDefinition object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a FunctionDefinition is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item FunctionDefinition::FunctionDefinition

Copy constructor; creates a copy of this FunctionDefinition.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item FunctionDefinition::accept

Accepts the given SBMLVisitor for this instance of FunctionDefinition.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next FunctionDefinition in
the list of function definitions.


=item FunctionDefinition::clone

Creates and returns a deep copy of this FunctionDefinition.
Returns a (deep) copy of this FunctionDefinition.


=item FunctionDefinition::getId

Returns the value of the "id" attribute of this FunctionDefinition.
Returns the id of this FunctionDefinition.


=item FunctionDefinition::getName

Returns the value of the "name" attribute of this FunctionDefinition.
Returns the name of this FunctionDefinition.


=item FunctionDefinition::getMath

Get the mathematical formula of this FunctionDefinition.
Returns an ASTNode, the value of the "math" subelement of this
FunctionDefinition


=item FunctionDefinition::isSetId

Predicate returning C<true> if this
FunctionDefinition's "id" attribute is set.
Returns C<true> if the "id" attribute of this FunctionDefinition is
set, C<false> otherwise.


=item FunctionDefinition::isSetName

Predicate returning C<true> if this
FunctionDefinition's "name" attribute is set.
Returns C<true> if the "name" attribute of this FunctionDefinition is
set, C<false> otherwise.


=item FunctionDefinition::isSetMath

Predicate returning C<true> if this
FunctionDefinition's "math" subelement contains a value.
Returns C<true> if the "math" for this FunctionDefinition is set,
C<false> otherwise.


=item FunctionDefinition::setId

Sets the value of the "id" attribute of this FunctionDefinition.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this FunctionDefinition
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item FunctionDefinition::setName

Sets the value of the "name" attribute of this FunctionDefinition.
The string in C<name> is copied.
@param name the new name for the FunctionDefinition
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item FunctionDefinition::setMath

Sets the "math" subelement of this FunctionDefinition to the Abstract
Syntax Tree given in C<math>.
@param math an AST containing the mathematical expression to
be used as the formula for this FunctionDefinition.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink


=item FunctionDefinition::unsetName

Unsets the value of the "name" attribute of this FunctionDefinition.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item FunctionDefinition::getArgument

Get the C<n>th argument to this function.
Callers should first find out the number of arguments to the function
by calling getNumArguments().
@param n an integer index for the argument sought.
Returns the nth argument (bound variable) passed to this
FunctionDefinition.

@see getNumArguments()


=item FunctionDefinition::getArgument

Get the argument named C<name> to this FunctionDefinition.
@param name the exact name (case-sensitive) of the sought-after
argument

Returns the argument (bound variable) having the given name, or C<NULL> if
no such argument exists.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
Returns the body of this FunctionDefinition as an Abstract Syntax
Tree, or C<NULL> if no body is defined.


=item FunctionDefinition::getBody

Get the mathematical expression that is the body of this
FunctionDefinition object.
Returns the body of this FunctionDefinition as an Abstract Syntax
Tree, or C<NULL> if no body is defined.


=item FunctionDefinition::isSetBody

Predicate returning C<true> if the body of this
FunctionDefinition has set.
Returns C<true> if the body of this FunctionDefinition is 
set, C<false> otherwise.


=item FunctionDefinition::getNumArguments

Get the number of arguments (bound variables) taken by this
FunctionDefinition.

Returns the number of arguments (bound variables) that must be passed
to this FunctionDefinition.


=item FunctionDefinition::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item FunctionDefinition::getElementName

Returns the XML element name of this object, which for
FunctionDefinition, is always C<"functionDefinition">.
Returns the name of this element, i.e., C<"functionDefinition">.


=item FunctionDefinition::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item FunctionDefinition::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this FunctionDefinition object
have been set.
@note The required attributes for a FunctionDefinition object are:
@li "id"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item FunctionDefinition::hasRequiredElements

Predicate returning C<true> if
all the required elements for this FunctionDefinition object
have been set.
@note The required elements for a FunctionDefinition object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item FunctionDefinition::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item FunctionDefinition::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item FunctionDefinition::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item FunctionDefinition::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item FunctionDefinition::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item FunctionDefinition::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item FunctionDefinition::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfFunctionDefinitions::ListOfFunctionDefinitions

Creates a new ListOfFunctionDefinitions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfFunctionDefinitions::ListOfFunctionDefinitions

Creates a new ListOfFunctionDefinitions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfFunctionDefinitions object to be created.


=item ListOfFunctionDefinitions::clone

Creates and returns a deep copy of this ListOfFunctionDefinitions instance.
Returns a (deep) copy of this ListOfFunctionDefinitions.


=item ListOfFunctionDefinitions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfFunctionDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., FunctionDefinition objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfFunctionDefinitions::getElementName

Returns the XML element name of this object.
For ListOfFunctionDefinitions, the XML element name is @c
"listOfFunctionDefinitions".

Returns the name of this element, i.e., C<"listOfFunctionDefinitions">.


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions.
@param n the index number of the FunctionDefinition to get.
Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
Returns FunctionDefinition in this ListOfFunctionDefinitions
with the given id or C<NULL> if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::get

Get a FunctionDefinition from the ListOfFunctionDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the FunctionDefinition to get.
Returns FunctionDefinition in this ListOfFunctionDefinitions
with the given id or C<NULL> if no such
FunctionDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfFunctionDefinitions::remove

Removes the nth item from this ListOfFunctionDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfFunctionDefinitions::remove

Removes item in this ListOfFunctionDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfFunctionDefinitions::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfFunctionDefinitions in a model is (in SBML Level 2 Version 4)
the first ListOf___.  (However, it differs for different Levels and
Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfFunctionDefinitions::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item UnitKind_equals

Tests for logical equality between two given C<UNIT_KIND_>
code values.
This function behaves exactly like C's C<==> operator, except
for the following two cases:

=over

<li>@link UnitKind_t#UNIT_KIND_LITER UNIT_KIND_LITER@endlink C<==> @link UnitKind_t#UNIT_KIND_LITRE UNIT_KIND_LITRE@endlink
<li>@link UnitKind_t#UNIT_KIND_METER UNIT_KIND_METER@endlink C<==> @link UnitKind_t#UNIT_KIND_METRE UNIT_KIND_METRE@endlink

=back


In the two cases above, C equality comparison would yield C<false>
(because each of the above is a distinct enumeration value), but
this function returns C<true>.
@param uk1 a C<UNIT_KIND_> value 
@param uk2 a second C<UNIT_KIND_> value to compare to C<uk1>
Returns nonzero (for C<true>) if C<uk1> is logically equivalent to @p
uk2, zero (for C<false>) otherwise.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.


=item UnitKind_forName

Converts a text string naming a kind of unit to its corresponding
libSBML C<UNIT_KIND_> constant/enumeration value.
@param name a string, the name of a predefined base unit in SBML
Returns @if clike a value from UnitKind_t corresponding to the given
string C<name> (determined in a case-insensitive manner).
@endif@if python a value the set of C<UNIT_KIND_> codes
defined in class @link libsbml libsbml@endlink, corresponding to the
string C<name> (determined in a case-insensitive
manner).@endif@if java a value the set of C<UNIT_KIND_> codes
defined in class {@link libsbmlConstants}, corresponding to the string
C<name> (determined in a case-insensitive manner).@endif@~
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.


=item UnitKind_toString

Converts a unit code to a text string equivalent.
@param uk @if clike a value from the UnitKind_t enumeration
@endif@if python a value from the set of C<UNIT_KIND_> codes
defined in the class @link libsbml libsbml@endlink
@endif@if java a value from the set of C<UNIT_KIND_> codes
defined in the class {@link libsbmlConstants}
@endif@~

Returns the name corresponding to the given unit code.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.
@warning The string returned is a static data value.  The caller does not
own the returned string and is therefore not allowed to modify it.


=item UnitKind_isValidUnitKindString

Predicate for testing whether a given string corresponds to a
predefined libSBML unit code.
@param str a text string naming a base unit defined by SBML
@param level the Level of SBML
@param version the Version within the Level of SBML
Returns nonzero (for C<true>) if string is the name of a valid
C<UNIT_KIND_> value, zero (for C<false>) otherwise.
@note For more information about the libSBML unit codes, please refer to
the class documentation for Unit.


=back

=head2 Unit

LibSBML implementation of SBML's Unit construct.
The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
A Unit structure has four attributes named "kind", "exponent", "scale"
and "multiplier".  It represents a (possibly transformed) reference to a
base unit.  The attribute "kind" on Unit indicates the chosen base unit.
Its value must be one of the text strings listed below; this list
corresponds to SBML Level&nbsp;3 Version&nbsp;1 Core:
@htmlinclude base-units.html
A few small differences exist between the Level&nbsp;3 list of base
units and the list defined in other Level/Version combinations of SBML.
Specifically, Levels of SBML before Level&nbsp;3 do not define @c
avogadro; conversely, Level&nbsp;2 Version&nbsp;1 defines C<Celsius>,
and Level&nbsp;1 defines C<celsius>, C<meter>, and C<liter>, none of
which are available in Level&nbsp;3.  In libSBML, each of the predefined
base unit names is represented by an enumeration value @if clike in
#UnitKind_t@else whose name begins with the characters
C<UNIT_KIND_>@endif, discussed in a separate section below.
The attribute named "exponent" on Unit represents an exponent on the
unit.  In SBML Level&nbsp;2, the attribute is optional and has a default
value of C<1> (one); in SBML Level&nbsp;3, the attribute is mandatory
and there is no default value.  A Unit structure also has an attribute
called "scale"; its value must be an integer exponent for a power-of-ten
multiplier used to set the scale of the unit.  For example, a unit
having a "kind" value of C<gram> and a "scale" value of C<-3> signifies
10<sup>&nbsp;&ndash;3</sup> \f$\times\f$ gram, or milligrams.  In SBML
Level&nbsp;2, the attribute is optional and has a default value of C<0>
(zero), because 10<sup> 0</sup> = 1; in SBML Level&nbsp;3, the attribute
is mandatory and has no default value.  Lastly, the attribute named
"multiplier" can be used to multiply the unit by a real-numbered factor;
this enables the definition of units that are not power-of-ten multiples
of SI units.  For instance, a multiplier of 0.3048 could be used to
define C<foot> as a measure of length in terms of a C<metre>.  The
"multiplier" attribute is optional in SBML Level&nbsp;2, where it has a
default value of C<1> (one); in SBML Level&nbsp;3, the attribute is
mandatory and has not default value.
@if clike
<h3><a class="anchor" name="UnitKind_t">UnitKind_t</a></h3>
@else
<h3><a class="anchor" name="UnitKind_t">%Unit identification codes</a></h3>
@endif@~

As discussed above, SBML defines a set of base units which serves as the
starting point for new unit definitions.  This set of base units
consists of the SI units and a small number of additional convenience
units.

@if clike Until SBML Level&nbsp;2 Version&nbsp;3, there
existed a data type in the SBML specifications called C<UnitKind>,
enumerating the possible SBML base units.  Although SBML Level&nbsp;2
Version&nbsp;3 removed this type from the language specification,
libSBML maintains the corresponding enumeration type #UnitKind_t as a
convenience and as a way to provide backward compatibility to previous
SBML Level/Version specifications.  (The removal in SBML Level&nbsp;2
Version&nbsp;3 of the enumeration C<UnitKind> was also accompanied by
the redefinition of the data type C<UnitSId> to include the previous @c
UnitKind values as reserved symbols in the C<UnitSId> space.  This
change has no net effect on permissible models, their representation or
their syntax.  The purpose of the change in the SBML specification was
simply to clean up an inconsistency about the contexts in which these
values were usable.)
@endif@if java In SBML Level&nbsp;2 Versions before
Version&nbsp;3, there existed an enumeration of units called @c
UnitKind.  In Version&nbsp;3, this enumeration was removed and the
identifier class C<UnitSId> redefined to include the previous @c
UnitKind values as reserved symbols.  This change has no net effect on
permissible models, their representation or their syntax.  The purpose
of the change in the SBML specification was simply to clean up an
inconsistency about the contexts in which these values were usable.
However, libSBML maintains UnitKind in the form of of a set of static
integer constants whose names begin with the characters
C<UNIT_KIND_>.  These constants are defined in the class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python In SBML Level&nbsp;2 Versions before
Version&nbsp;3, there existed an enumeration of units called @c
UnitKind.  In Version&nbsp;3, this enumeration was removed and the
identifier class C<UnitSId> redefined to include the previous @c
UnitKind values as reserved symbols.  This change has no net effect on
permissible models, their representation or their syntax.  The purpose
of the change in the SBML specification was simply to clean up an
inconsistency about the contexts in which these values were usable.
However, libSBML maintains UnitKind in the form of of a set of static
integer constants whose names begin with the characters
C<UNIT_KIND_>.  These constants are defined in the class
@link libsbml libsbml@endlink.
@endif@~

As a consequence of the fact that libSBML supports models in all Levels
and Versions of SBML, libSBML's set of C<UNIT_KIND_> values is a union
of all the possible base unit names defined in the different SBML
specifications.  However, not every base unit is allowed in every
Level+Version combination of SBML.  Note in particular the following
exceptions:

=over


=item

The alternate spelling C<"meter"> is included in
addition to the official SI spelling C<"metre">.  This spelling is only
permitted in SBML Level&nbsp;1 models.

=item

The alternate spelling C<"liter"> is included in addition to the
official SI spelling C<"litre">.  This spelling is only permitted in
SBML Level&nbsp;1 models.

=item

The unit C<"Celsius"> is included because of its presence in
specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;3.

=item

The unit C<avogadro> was introduced in SBML Level&nbsp;3, and
is only permitted for use in SBML Level&nbsp;3 models.

=back


@if clike The table below lists the symbols defined in the
C<UnitKind_t> enumeration, and their
meanings. @else The table below lists the unit
constants defined in libSBML, and their meanings. @endif@~
@htmlinclude unitkind-table.html
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfUnits

LibSBML implementation of SBML's ListOfUnits construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
ListOfUnits is entirely contained within UnitDefinition.

=over


=item Unit::Unit

Creates a new Unit using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Unit
@param version an unsigned int, the SBML Version to assign to this
Unit

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Unit object to an SBMLDocument, the SBML
Level, SBML Version and XML namespace of the document @em
override the values used when creating the Unit object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a Unit is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Unit::Unit

Creates a new Unit using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Unit object to an SBMLDocument, the SBML
XML namespace of the document I<overrides> the value used when
creating the Unit object via this constructor.  This is necessary to
ensure that an SBML document is a consistent structure.  Nevertheless,
the ability to supply the values at the time of creation of a Unit is
an important aid to producing valid SBML.  Knowledge of the intented
SBML Level and Version determine whether it is valid to assign a
particular value to an attribute, or whether it is valid to add an
object to an existing SBMLDocument.


=item Unit::Unit

Copy constructor; creates a copy of this Unit.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Unit::accept

Accepts the given SBMLVisitor for this instance of Unit.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Unit in the list
of units within which this Unit is embedded (i.e., in the ListOfUnits
located in the enclosing UnitDefinition instance).


=item Unit::clone

Creates and returns a deep copy of this Unit.
Returns a (deep) copy of this Unit.


=item Unit::initDefaults

Initializes the fields of this Unit object to "typical" default
values.

The SBML Unit component has slightly different aspects and default
attribute values in different SBML Levels and Versions.  This method
sets the values to certain common defaults, based mostly on what they
are in SBML Level&nbsp;2.  Specifically:

=over


=item

Sets attribute "exponent" to C<1>

=item

Sets attribute "scale" to C<0>

=item

Sets attribute "multiplier" to C<1>.0

=back


The "kind" attribute is left unchanged.


=item Unit::getKind

Returns the "kind" of Unit this is.
@if clike
Returns the value of the "kind" attribute of this Unit as a
value from the <a class="el" href="#UnitKind_t">UnitKind_t</a> enumeration.
@endif@if java
Returns the value of the "kind" attribute of this Unit as a
value from the set of constants whose names begin
with C<UNIT_KIND_> defined in the class
<code><a href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python
Returns the value of the "kind" attribute of this Unit as a
value from the set of constants whose names begin
with C<UNIT_KIND_> defined in the class
@link libsbml libsbml@endlink.
@endif@~


=item Unit::getExponent

Returns the value of the "exponent" attribute of this unit.
Returns the "exponent" value of this Unit, as an integer.


=item Unit::getExponentAsDouble

Returns the value of the "exponent" attribute of this unit.
Returns the "exponent" value of this Unit, as a double.


=item Unit::getScale

Returns the value of the "scale" attribute of this unit.
Returns the "scale" value of this Unit, as an integer.


=item Unit::getMultiplier

Returns the value of the "multiplier" attribute of this Unit.
Returns the "multiplier" value of this Unit, as a double.


=item Unit::getOffset

Returns the value of the "offset" attribute of this Unit.
@warning The "offset" attribute is only available in SBML Level&nbsp;2
Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
Version&nbsp;2 or above.  When producing SBML models using these later
specifications, modelers and software tools need to account for units
with offsets explicitly.  The SBML specification document offers a
number of suggestions for how to achieve this.  LibSBML methods such
as this one related to "offset" are retained for compatibility with
earlier versions of SBML Level&nbsp;2, but their use is strongly
discouraged.

Returns the "offset" value of this Unit, as a double.


=item Unit::isAmpere

Predicate for testing whether this Unit is of the kind C<ampere>.
Returns C<true> if the kind of this Unit is C<ampere>, C<false>
otherwise.


=item Unit::isAvogadro

Predicate for testing whether this Unit is of the kind C<avogadro>.
Returns C<true> if the kind of this Unit is C<avogadro>, C<false>
otherwise.

@note The unit C<avogadro> was introduced in SBML Level&nbsp;3, and
is only permitted for use in SBML Level&nbsp;3 models.


=item Unit::isBecquerel

Predicate for testing whether this Unit is of the kind C<becquerel>
Returns C<true> if the kind of this Unit is C<becquerel>, C<false>
otherwise.


=item Unit::isCandela

Predicate for testing whether this Unit is of the kind C<candela>
Returns C<true> if the kind of this Unit is C<candela>, C<false>
otherwise.


=item Unit::isCelsius

Predicate for testing whether this Unit is of the kind C<Celsius>
Returns C<true> if the kind of this Unit is C<Celsius>, C<false>
otherwise. 

@warning The predefined unit C<Celsius> was removed from the list of
predefined units in SBML Level&nbsp;2 Version&nbsp;2 at the same time
that the "offset" attribute was removed from Unit definitions.
LibSBML methods such as this one related to C<Celsius> are retained in
order to support SBML Level&nbsp;2 Version&nbsp;1, but their use is
strongly discouraged.


=item Unit::isCoulomb

Predicate for testing whether this Unit is of the kind C<coulomb>
Returns C<true> if the kind of this Unit is C<coulomb>, C<false>
otherwise.


=item Unit::isDimensionless

Predicate for testing whether this Unit is of the kind @c
dimensionless.

Returns C<true> if the kind of this Unit is C<dimensionless>, C<false>
otherwise.


=item Unit::isFarad

Predicate for testing whether this Unit is of the kind C<farad>
Returns C<true> if the kind of this Unit is C<farad>, C<false>
otherwise.


=item Unit::isGram

Predicate for testing whether this Unit is of the kind C<gram>
Returns C<true> if the kind of this Unit is C<gram>, C<false>
otherwise.


=item Unit::isGray

Predicate for testing whether this Unit is of the kind C<gray>
Returns C<true> if the kind of this Unit is C<gray>, C<false>
otherwise.


=item Unit::isHenry

Predicate for testing whether this Unit is of the kind C<henry>
Returns C<true> if the kind of this Unit is C<henry>, C<false>
otherwise.


=item Unit::isHertz

Predicate for testing whether this Unit is of the kind C<hertz>
Returns C<true> if the kind of this Unit is C<hertz>, C<false>
otherwise.


=item Unit::isItem

Predicate for testing whether this Unit is of the kind C<item>
Returns C<true> if the kind of this Unit is C<item>, C<false>
otherwise.


=item Unit::isJoule

Predicate for testing whether this Unit is of the kind C<joule>
Returns C<true> if the kind of this Unit is C<joule>, C<false>
otherwise.


=item Unit::isKatal

Predicate for testing whether this Unit is of the kind C<katal>
Returns C<true> if the kind of this Unit is C<katal>, C<false>
otherwise.


=item Unit::isKelvin

Predicate for testing whether this Unit is of the kind C<kelvin>
Returns C<true> if the kind of this Unit is C<kelvin>, C<false>
otherwise.


=item Unit::isKilogram

Predicate for testing whether this Unit is of the kind C<kilogram>
Returns C<true> if the kind of this Unit is C<kilogram>, C<false>
otherwise.


=item Unit::isLitre

Predicate for testing whether this Unit is of the kind C<litre>
Returns C<true> if the kind of this Unit is C<litre> or 'liter', @c
false 
otherwise.


=item Unit::isLumen

Predicate for testing whether this Unit is of the kind C<lumen>
Returns C<true> if the kind of this Unit is C<lumen>, C<false>
otherwise.


=item Unit::isLux

Predicate for testing whether this Unit is of the kind C<lux>
Returns C<true> if the kind of this Unit is C<lux>, C<false>
otherwise.


=item Unit::isMetre

Predicate for testing whether this Unit is of the kind C<metre>
Returns C<true> if the kind of this Unit is C<metre> or 'meter', @c
false 
otherwise.


=item Unit::isMole

Predicate for testing whether this Unit is of the kind C<mole>
Returns C<true> if the kind of this Unit is C<mole>, C<false>
otherwise.


=item Unit::isNewton

Predicate for testing whether this Unit is of the kind C<newton>
Returns C<true> if the kind of this Unit is C<newton>, C<false>
otherwise.


=item Unit::isOhm

Predicate for testing whether this Unit is of the kind C<ohm>
Returns C<true> if the kind of this Unit is C<ohm>, C<false>
otherwise.


=item Unit::isPascal

Predicate for testing whether this Unit is of the kind C<pascal>
Returns C<true> if the kind of this Unit is C<pascal>, C<false>
otherwise.


=item Unit::isRadian

Predicate for testing whether this Unit is of the kind C<radian>
Returns C<true> if the kind of this Unit is C<radian>, C<false>
otherwise.


=item Unit::isSecond

Predicate for testing whether this Unit is of the kind C<second>
Returns C<true> if the kind of this Unit is C<second>, C<false>
otherwise.


=item Unit::isSiemens

Predicate for testing whether this Unit is of the kind C<siemens>
Returns C<true> if the kind of this Unit is C<siemens>, C<false>
otherwise.


=item Unit::isSievert

Predicate for testing whether this Unit is of the kind C<sievert>
Returns C<true> if the kind of this Unit is C<sievert>, C<false>
otherwise.


=item Unit::isSteradian

Predicate for testing whether this Unit is of the kind C<steradian>
Returns C<true> if the kind of this Unit is C<steradian>, C<false>
otherwise.


=item Unit::isTesla

Predicate for testing whether this Unit is of the kind C<tesla>
Returns C<true> if the kind of this Unit is C<tesla>, C<false>
otherwise.


=item Unit::isVolt

Predicate for testing whether this Unit is of the kind C<volt>
Returns C<true> if the kind of this Unit is C<volt>, C<false>
otherwise.


=item Unit::isWatt

Predicate for testing whether this Unit is of the kind C<watt>
Returns C<true> if the kind of this Unit is C<watt>, C<false>
otherwise.


=item Unit::isWeber

Predicate for testing whether this Unit is of the kind C<weber>
Returns C<true> if the kind of this Unit is C<weber>, C<false>
otherwise.


=item Unit::isSetKind

Predicate to test whether the "kind" attribute of this Unit is set.
Returns C<true> if the "kind" attribute of this Unit is set, @c
false otherwise.


=item Unit::isSetExponent

Predicate to test whether the "exponent" attribute of this Unit 
is set.
Returns C<true> if the "exponent" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::isSetScale

Predicate to test whether the "scale" attribute of this Unit 
is set.
Returns C<true> if the "scale" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::isSetMultiplier

Predicate to test whether the "multiplier" attribute of this Unit 
is set.
Returns C<true> if the "multiplier" attribute of this Unit is set, 
C<false> otherwise.


=item Unit::setKind

Sets the "kind" attribute value of this Unit.
@if clike
@param kind a value from the <a class="el"
href="#UnitKind_t">UnitKind_t</a> enumeration.
@endif@if java
@param kind a unit identifier chosen from the set of constants whose
names begin with C<UNIT_KIND_> in <code><a
href="libsbmlConstants.html">libsbmlConstants</a></code>.
@endif@if python
@param kind a unit identifier chosen from the set of constants whose
names begin with C<UNIT_KIND_> in @link libsbml libsbml@endlink.
@endif@~

Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Unit::setExponent

Sets the "exponent" attribute value of this Unit.
@param value the integer to which the attribute "exponent" should be set
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Unit::setExponent

Sets the "exponent" attribute value of this Unit.
@param value the double to which the attribute "exponent" should be set
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Unit::setScale

Sets the "scale" attribute value of this Unit.
@param value the integer to which the attribute "scale" should be set
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Unit::setMultiplier

Sets the "multipler" attribute value of this Unit.
@param value the floating-point value to which the attribute
"multiplier" should be set
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Unit::setOffset

Sets the "offset" attribute value of this Unit.
@param value the float-point value to which the attribute "offset"
should set
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@warning The "offset" attribute is only available in SBML Level&nbsp;2
Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
Version&nbsp;2 or above.  When producing SBML models using these later
specifications, modelers and software tools need to account for units
with offsets explicitly.  The SBML specification document offers a
number of suggestions for how to achieve this.  LibSBML methods such
as this one related to "offset" are retained for compatibility with
earlier versions of SBML Level&nbsp;2, but their use is strongly
discouraged.


=item Unit::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Unit::getElementName

Returns the XML element name of this object, which for Unit, is
always C<"unit">.
Returns the name of this element, i.e., C<"unit">.


=item Unit::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Unit::isBuiltIn

Predicate to test whether a given string is the name of a
predefined SBML unit.
@param name a string to be tested against the predefined unit names
@param level the Level of SBML for which the determination should be
made.  This is necessary because there are a few small differences
in allowed units between SBML Level&nbsp;1 and Level&nbsp;2.
Returns C<true> if C<name> is one of the five SBML predefined unit
identifiers (C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time"), C<false> otherwise.
@note The predefined unit identifiers C<"length"> and C<"area"> were
added in Level&nbsp;2 Version&nbsp;1.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_isBuiltIn(). They are functionally
identical. @endif@~


=item Unit::isUnitKind

Predicate to test whether a given string is the name of a valid
base unit in SBML (such as C<"gram"> or C<"mole">).
This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
an enumeration called C<UnitKind> was defined by SBML.  This enumeration
was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
folded into the space of values of a type called C<UnitSId>.  This method
therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
and Level&nbsp;2 Version&nbsp;4, but remains for backward
compatibility and support for reading models in older Versions of
Level&nbsp;2.

@param name a string to be tested
@param level an unsigned int representing the SBML specification
Level 

@param version an unsigned int representing the SBML specification
Version

Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise
@note The allowed unit names differ between SBML Levels&nbsp;1
and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
and&nbsp;2.

@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_isUnitKind(). They are functionally
identical. @endif@~


=item Unit::areIdentical

Predicate returning C<true> if two
Unit objects are identical.
Two Unit objects are considered to be I<identical> if they match in
all attributes.  (Contrast this to the method areEquivalent(@if java
Unit u1, Unit u2@endif), which compares Unit objects only with respect
to certain attributes.)
@param unit1 the first Unit object to compare
@param unit2 the second Unit object to compare
Returns C<true> if all the attributes of unit1 are identical
to the attributes of unit2, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_areIdentical(). They are functionally
identical. @endif@~
@see @if clike areEquivalent() @else Unit::areEquivalent(Unit u1, Unit u2) @endif@~


=item Unit::areEquivalent

Predicate returning C<true> if 
Unit objects are equivalent.
Two Unit objects are considered to be I<equivalent> either if (1) both
have a "kind" attribute value of C<dimensionless>, or (2) their "kind",
"exponent" and (for SBML Level&nbsp;2 Version&nbsp;1) "offset"
attribute values are equal. (Contrast this to the method
areIdentical(@if java Unit u1, Unit u2@endif), which compares Unit objects with respect to all
attributes, not just the "kind" and "exponent".)
@param unit1 the first Unit object to compare
@param unit2 the second Unit object to compare
Returns C<true> if the "kind" and "exponent" attributes of unit1 are
identical to the kind and exponent attributes of unit2, C<false>
otherwise.

@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_areEquivalent(). They are functionally
identical. @endif@~
@see @if clike areIdentical() @else Unit::areIdentical(Unit u1, Unit u2) @endif@~


=item Unit::removeScale

Manipulates the attributes of the Unit to express the unit with the 
value of the scale attribute reduced to zero.
For example, 1 millimetre can be expressed as a Unit with kind=@c
"metre" multiplier=C<"1"> scale=C<"-3"> exponent=C<"1">. It can also be
expressed as a Unit with kind=C<"metre">
multiplier=C<"0.001"> scale=C<"0"> exponent=C<"1">.
@param unit the Unit object to manipulate.
Returns integer value indicating success/failure of the function.  The
possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_removeScale(). They are functionally
identical. @endif@~
@see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif@~
@see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif@~


=item Unit::merge

Merges two Unit objects with the same "kind" attribute value into a
single Unit.
For example, the following,
@verbatim
<unit kind="metre" exponent="2"/>
<unit kind="metre" exponent="1"/>
@endverbatim
would be merged to become
@verbatim
<unit kind="metre" exponent="3"/>
@endverbatim

@param unit1 the first Unit object; the result of the operation is
left as a new version of this unit, modified in-place.
@param unit2 the second Unit object to merge with the first
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_merge(). They are functionally
identical. @endif@~
@see @if clike convertToSI() @else Unit::convertToSI(Unit u) @endif@~
@see @if clike removeScale() @else Unit::removeScale(Unit u) @endif@~


=item Unit::convertToSI

Returns a UnitDefinition object containing the given C<unit> converted
to the appropriate SI unit.
This method exists because some units can be expressed in terms of
others when the same physical dimension is involved.  For example, one
hertz is identical to 1&nbsp;sec<sup>-1</sup>, one litre is equivalent
to 1 cubic decametre, and so on.
@param unit the Unit object to convert to SI
Returns a UnitDefinition object containing the SI unit.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., Unit), and the
other will be a standalone top-level function with the name
Unit_convertToSI(). They are functionally
identical. @endif@~
@see @if clike merge() @else Unit::merge(Unit u1, Unit u2) @endif@~


=item Unit::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::setExponentUnitChecking

@internal

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::getExponentUnitChecking

@internal

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::getExponentUnitChecking

@internal

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::isUnitChecking

@internal

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::isUnitChecking

@internal

Predicate returning C<true> if
all the required attributes for this Unit object
have been set.
@note The required attributes for a Unit object are:
@li "kind"
@li "exponent" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "multiplier" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
@li "scale" (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Unit::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Unit::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Unit::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Unit::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Unit::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Unit::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Unit::isL1UnitKind

@internal

Predicate to test whether a given string is the name of a valid
base unit in SBML Level 1 (such as C<"gram"> or C<"mole">)
@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isL2V1UnitKind

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isL2UnitKind

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;2 Version&nbsp;2, 3 or 4 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isL3UnitKind

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;3 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isExplicitlySetExponent

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;3 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isExplicitlySetMultiplier

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;3 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isExplicitlySetScale

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;3 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item Unit::isExplicitlySetOffset

@internal

Predicate to test whether a given string is the name of a valid base
unit in SBML Level&nbsp;3 Version&nbsp;1 (such as C<"gram"> or @c
"mole")

@param name a string to be tested
Returns C<true> if name is a valid SBML UnitKind, C<false> otherwise


=item ListOfUnits::ListOfUnits

Creates a new ListOfUnits object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfUnits::ListOfUnits

Creates a new ListOfUnits object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfUnits object to be created.


=item ListOfUnits::clone

Creates and returns a deep copy of this ListOfUnits.
Returns a (deep) copy of this ListOfUnits.


=item ListOfUnits::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfUnits::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Unit objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfUnits::getElementName

Returns the XML element name of this object.
For ListOfUnits, the XML element name is C<"listOfUnits">.
Returns the name of this element, i.e., C<"listOfUnits">.


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
Returns the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::get

Get a Unit from the ListOfUnits.
@param n the index number of the Unit to get.
Returns the nth Unit in this ListOfUnits.
@see size()


=item ListOfUnits::remove

Removes the nth item from this ListOfUnits items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfUnits::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfUnits::createObject

@internal

Create a ListOfUnits object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.


=back

=head2 UnitDefinition

LibSBML implementation of SBML's UnitDefinition construct.
Units of measurement may be supplied in a number of contexts in an SBML
model.  The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
constructed by combining a Unit object representing <em>meter</em> with
another Unit object representing <em>second<sup> &ndash;2</sup></em>.
The combination is wrapped inside a UnitDefinition, which provides for
assigning an identifier and optional name to the combination.  The
identifier can then be referenced from elsewhere in a model.  Thus, the
UnitDefinition class is the container, and Unit instances are placed
inside UnitDefinition instances.
Two points are worth discussing in the context of SBML units.  First,
unit declarations in SBML models are I<optional>.  The consequence of
this is that a model must be numerically self-consistent independently
of unit declarations, for the benefit of software tools that cannot
interpret or manipulate units.  Unit declarations in SBML are thus more
akin to a type of annotation; they can indicate intentions, and can be
used by model readers for checking the consistency of the model,
labeling simulation output, etc., but any transformations of values
implied by different units must be incorporated I<explicitly> into a
model.

Second, the vast majority of situations that require new SBML unit
definitions involve simple multiplicative combinations of base units and
factors.  An example is <em>moles per litre per second</em>.  What
distinguishes these sorts of unit definitions from more complex ones is
that they may be expressed without the use of an additive offset from a
zero point.  The use of offsets complicates all unit definition systems,
yet in the domain of SBML, the real-life cases requiring offsets are few
(and in fact, to the best of our knowledge, only involve temperature).
Consequently, the SBML unit system has been consciously designed to
simplify implementation of unit support for the most common cases in
systems biology.  The cost of this simplification is to require units
with offsets to be handled explicitly by the modeler.
@section unitdef-summary Summary of the UnitDefinition construct
UnitDefinition has two attributes and one subelement.  The two
attributes are "id" and "name", and the subelement is ListOfUnits.
The required attribute "id" and optional attribute "name" are both
strings.  The "id" attribute is used to give the defined unit a unique
identifier by which other parts of an SBML model definition can refer to
it.  The "name" attribute is intended to be used for giving the unit
definition an optional human-readable name.  Please see the <a
href="#unitdef-id">next section</a> for information about the values
permitted for "id".
A UnitDefinition must contain exactly one ListOfUnits, and this list
must contain one or more Unit definitions; see the definitions of these
other object classes for more information about them.  The following
example illustrates a complete unit definition (when written in XML)
when they all the pieces are combined together.  This defines "mmls"
to be millimoles per litre per second.
@verbatim
<listOfUnitDefinitions>
<unitDefinition id="mmls">
<listOfUnits>
<unit kind="mole"   scale="-3"/>
<unit kind="litre"  exponent="-1"/>
<unit kind="second" exponent="-1"/>
</listOfUnits>
</unitDefinition>
</listOfUnitDefinitions>
@endverbatim
@section unitdef-id Special considerations for Unit object identifiers
The attribute "id" in UnitDefinition cannot be given simply any value,
and the precise details of the values permitted differ slightly between
Levels of SBML:

=over



=item

The "id" of a UnitDefinition must I<not> contain a value from the
list of SBML's predefined base unit names (i.e., the strings C<gram>, @c
litre, etc.).  In SBML Level&nbsp;3, this list consists of the
following:

@htmlinclude base-units.html
This list of predefined base units is nearly identical in SBML
Level&nbsp;2 Version&nbsp;4, the exception being that Level&nbsp;2 does
not define C<avogadro>.  SBML Level&nbsp;2 Version&nbsp;1 (and I<only>
this Level+Version combination) provides an additional predefined unit
name, C<Celsius>, not available in Level&nbsp;3.  Finally, SBML
Level&nbsp;1 Versions&nbsp;2&ndash;3 provide two more additional
predefined unit names, C<meter> and C<liter>.  This is explained in
somewhat greater detail in the description of the Unit class.

=item

In SBML Level&nbsp;2 (all Versions), there is an additional set of
reserved identifiers: C<substance>, C<volume>, C<area>, C<length>, and
C<time>.  Using one of these values for the attribute "id" of a
UnitDefinition has the effect of redefining the model-wide default units
for the corresponding quantities.  The list of special unit names in
SBML Level&nbsp;2 is given in the table below:
@htmlinclude predefined-units.html
Also, SBML Level&nbsp;2 imposes two limitations on redefining the
predefined unit C<substance>, C<volume>, C<area>, C<length>, and @c
time: (1) The UnitDefinition of a predefined SBML unit can only contain
a single Unit object within it.  (2) The value of the "kind" attribute
in a Unit instance must be drawn from one of the values in the second
column of the table above.
The special unit names C<substance>, C<volume>, C<area>, C<length>, and
C<time> are not defined by SBML Level&nbsp;3, which uses a different
approach to setting model-wide inherited units.

=back



@section sbml-units-limits Further comments about SBML's unit definition system
The vast majority of modeling situations requiring new SBML unit
definitions involve simple multiplicative combinations of base units and
factors.  An example of this might be <em>moles per litre per
second</em>.  What distinguishes these sorts of simpler unit definitions
from more complex ones is that they may be expressed without the use of
an additive offset from a zero point.  The use of offsets complicates
all unit definition systems, yet in the domain of SBML the real-life
cases requiring offsets are few (and in fact, to the best of our
knowledge, only involve temperature).  Consequently, the SBML unit
system has been consciously designed in a way that attempts to simplify
implementation of unit support for the most common cases in systems
biology.

As of SBML Level&nbsp;2 Version&nbsp;2, Unit no longer has the
attribute called "offset" introduced in SBML Level&nbsp;2
Version&nbsp;1.  It turned out that the general case involving units
with offsets was incorrectly defined, and few (if any) developers even
attempted to support offset-based units in their software.  In the
development of Level&nbsp;2 Version&nbsp;2, a consensus among SBML
developers emerged that a fully generalized unit scheme is I<so>
confusing and complicated that it actually I<impedes> interoperability.
SBML Level&nbsp;2 Version&nbsp;2, Version&nbsp;3 and Version&nbsp;4 acknowledge this
reality by reducing and simplifying the unit system, specifically by
removing the "offset" attribute on Unit and C<Celsius> as a pre-defined
unit.

The following guidelines suggest methods for handling units that do
require the use of zero offsets for their definitions:

=over


=item

<em>Handling Celsius</em>.  A model in which certain quantities are
temperatures measured in degrees Celsius can be converted
straightforwardly to a model in which those temperatures are in
kelvin.  A software tool could do this by performing a straightforward
substitution using the following relationship: <em>T<sub> kelvin</sub> =
T<sub>Celsius</sub> + 273.15</em>.  In every mathematical formula of the
model where a quantity (call it I<x>) in degrees Celsius appears,
replace I<x> with <em>x<sub>k</sub>+ 273.15</em>, where
<em>x<sub>k</sub></em> is now in kelvin.  An alternative approach would 
be to use a FunctionDefinition object to define a function encapsulating this
relationship above and then using that in the rest of the model as
needed.  Since Celsius is a commonly-used unit, software tools could
help users by providing users with the ability to express temperatures
in Celsius in the tools' interfaces, and making substitutions
automatically when writing out the SBML.

=item

<em>Other units requiring offsets</em>.  One approach to handling
other kinds of units is to use a FunctionDefinition to define a function
encapsulating the necessary mathematical relationship, then
substituting a call to this function wherever the original quantity
appeared in the model.  For example, here is a possible definition for
converting Fahrenheit to Celsius degrees:
@verbatim
<functionDefinition id="Fahrenheit_to_kelvin">
<math xmlns="http://www.w3.org/1998/Math/MathML">
<lambda>
<bvar><ci> temp_in_fahrenheit </ci></bvar>
<apply>
<divide/>
<apply>
<plus/>
<ci> temp_in_fahrenheit </ci>
<cn> 459.67 </cn>
</apply>
<cn> 1.8 </cn>
</apply>
</lambda>
</math>
</functionDefinition>
@endverbatim


=item

An alternative approach not requiring the use of function definitions
is to use an AssignmentRule for each variable in Fahrenheit units.
The AssignmentRule could compute the conversion from Fahrenheit to
(say) kelvin, assign its value to a variable (in Kelvin units), and
then that variable could be used elsewhere in the model.

=item

Still another approach is to rewrite the mathematical formulas of a
model to directly incorporate the conversion formula wherever the
original quantity appeared.

=back


Please consult the SBML specifications for more information about this
and other issues involving units.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfUnitDefinitions

LibSBML implementation of SBML's ListOfUnitDefinitions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this UnitDefinition
@param version an unsigned int, the SBML Version to assign to this
UnitDefinition

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a UnitDefinition object to an SBMLDocument
(e.g., using Model::addUnitDefinition(@if java UnitDefinition ud@endif)), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the UnitDefinition object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a UnitDefinition is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item UnitDefinition::UnitDefinition

Creates a new UnitDefinition using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a UnitDefinition object to an SBMLDocument
(e.g., using Model::addUnitDefinition(@if java UnitDefinition ud@endif)), the SBML XML namespace of
the document I<overrides> the value used when creating the
UnitDefinition object via this constructor.  This is necessary to
ensure that an SBML document is a consistent structure.  Nevertheless,
the ability to supply the values at the time of creation of a
UnitDefinition is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item UnitDefinition::UnitDefinition

Copy constructor; creates a copy of this UnitDefinition.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item UnitDefinition::accept

Accepts the given SBMLVisitor for this instance of UnitDefinition.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next UnitDefinition in the
list of units within which this UnitDefinition is embedded (i.e., in
the ListOfUnitDefinitions located in the enclosing Model instance).


=item UnitDefinition::clone

Creates and returns a deep copy of this UnitDefinition.
Returns a (deep) copy of this UnitDefinition.


=item UnitDefinition::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find.
Returns pointer to the first element found with the given id.


=item UnitDefinition::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item UnitDefinition::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item UnitDefinition::getId

Returns the value of the "id" attribute of this UnitDefinition.
Returns the id of this UnitDefinition.


=item UnitDefinition::getName

Returns the value of the "name" attribute of this UnitDefinition.
Returns the name of this UnitDefinition.


=item UnitDefinition::isSetId

Predicate returning C<true> if this
UnitDefinition's "id" attribute is set.
Returns C<true> if the "id" attribute of this UnitDefinition is
set, C<false> otherwise.


=item UnitDefinition::isSetName

Predicate returning C<true> if this
UnitDefinition's "name" attribute is set.
Returns C<true> if the "name" attribute of this UnitDefinition is
set, C<false> otherwise.


=item UnitDefinition::setId

Sets the value of the "id" attribute of this UnitDefinition.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this UnitDefinition
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item UnitDefinition::setName

Sets the value of the "name" attribute of this UnitDefinition.
The string in C<name> is copied.
@param name the new name for the UnitDefinition
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item UnitDefinition::unsetName

Unsets the value of the "name" attribute of this UnitDefinition.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item UnitDefinition::isVariantOfArea

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"area">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<area>, meaning square metres with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfLength

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"length">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<length>, meaning metres with only abritrary variations in scale
or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstance

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"substance">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<substance>, meaning moles or items (and grams or kilograms from
SBML Level&nbsp;2 Version&nbsp;2 onwards) with only abritrary variations
in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"time">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<time>, meaning seconds with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfVolume

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"volume">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<volume>, meaning litre or cubic metre with only abritrary
variations in scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfDimensionless

Convenience function for testing if a given unit definition is a
variant of the unit C<"dimensionless">.
Returns C<true> if this UnitDefinition is a variant of @c
dimensionless, meaning dimensionless with only abritrary variations in
scale or multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfMass

Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier C<"mass">.
Returns C<true> if this UnitDefinition is a variant of mass units,
meaning gram or kilogram with only abritrary variations in scale or
multiplier values; C<false> otherwise.


=item UnitDefinition::isVariantOfSubstancePerTime

Convenience function for testing if a given unit definition is a
variant of the predefined unit C<"substance"> divided by the predefined
unit C<"time">.
Returns C<true> if this UnitDefinition is a variant of the predefined
unit C<substance> per predefined unit C<time>, meaning it contains two
units one of which is a variant of substance and the other is a
variant of time which an exponent of -1; C<false> otherwise.


=item UnitDefinition::addUnit

Adds a copy of the given Unit to this UnitDefinition.
@param u the Unit instance to add to this UnitDefinition.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this UnitDefinition.  Changes made to the original
object instance (such as resetting attribute values) will <em>not
affect the instance in the UnitDefinition</em>.  In addition, the
caller should make sure to free the original object if it is no longer
being used, or else a memory leak will result.  Please see
UnitDefinition::createUnit() for a method that does not lead to these
issues.

@see createUnit()


=item UnitDefinition::createUnit

Creates a new and empty Unit, adds it to this UnitDefinition's list of
units, and returns it.
Returns a newly constructed (and empty) Unit instance.
@note It is worth emphasizing that the attribute "kind" value of a
Unit is a required attribute for a valid Unit definition.  The
createUnit() method does not assign a valid kind to the constructed
unit (instead, it sets the "kind" to @link UnitKind_t#UNIT_KIND_INVALID UNIT_KIND_INVALID@endlink).
Callers are cautioned to set the newly-constructed Unit's kind using
Unit::setKind(@if java int kind@endif) soon after calling this method.
@see addUnit(const Unit  u)


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
Returns the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getListOfUnits

Returns the list of Units for this UnitDefinition instance.
Returns the ListOfUnits value for this UnitDefinition.


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
Returns the nth Unit of this UnitDefinition.
@see getNumUnits()


=item UnitDefinition::getUnit

Returns a specific Unit instance belonging to this UnitDefinition.
@param n an integer, the index of the Unit to be returned.
Returns the nth Unit of this UnitDefinition.


=item UnitDefinition::getNumUnits

Returns the number of Unit objects contained within this
UnitDefinition.

Returns an integer representing the number of Units in this
UnitDefinition.


=item UnitDefinition::removeUnit

Removes the nth Unit object from this UnitDefinition object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Unit object to remove
Returns the Unit object removed, or C<NULL> if the given index 
is out of range.


=item UnitDefinition::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use


=item UnitDefinition::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item UnitDefinition::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item UnitDefinition::getTypeCode

Returns the libSBML type code for this object instance.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item UnitDefinition::getElementName

Returns the XML element name of this object, which for UnitDefinition,
is always C<"unitDefinition">.
Returns the name of this element, i.e., C<"unitDefinition">.


=item UnitDefinition::simplify

Simplifies the UnitDefinition such that any given kind of Unit object
occurs only once in the ListOfUnits.
For example, the following definition,
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="metre" exponent="2"/>
</listOfUnits>
<unitDefinition>
@endverbatim
will be simplified to 
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="3"/>
</listOfUnits>
<unitDefinition>
@endverbatim

@param ud the UnitDefinition object to be simplified.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_simplify(). They are functionally identical. @endif@~


=item UnitDefinition::reorder

Alphabetically orders the Unit objects within the ListOfUnits of a
UnitDefinition.

@param ud the UnitDefinition object whose units are to be reordered.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_reorder(). They are functionally identical. @endif@~


=item UnitDefinition::convertToSI

Convert a given UnitDefinition into a new UnitDefinition object
that uses SI units.
@param ud the UnitDefinition object to convert to SI
Returns a new UnitDefinition object representing the results of the
conversion.

@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_convertToSI(). They are functionally identical. @endif@~


=item UnitDefinition::areIdentical

Predicate returning C<true> if two
UnitDefinition objects are identical.
For the purposes of performing this comparison, two UnitDefinition
objects are considered identical when they contain identical lists of
Unit objects.  Pairs of Unit objects in the lists are in turn
considered identical if they satisfy the predicate
Unit::areIdentical(@if java Unit u1, Unit u2@endif).
The predicate compares every attribute of the
Unit objects.
@param ud1 the first UnitDefinition object to compare
@param ud2 the second UnitDefinition object to compare
Returns C<true> if all the Unit objects in ud1 are identical to the
Unit objects of ud2, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_areIdentical(). They are functionally identical. @endif@~
@see UnitDefinition::areEquivalent(const UnitDefinition   ud1, const UnitDefinition   ud2)
@see Unit::areIdentical(Unit   unit1, Unit   unit2)


=item UnitDefinition::areEquivalent

Predicate returning C<true> if two
UnitDefinition objects are equivalent.
For the purposes of performing this comparison, two UnitDefinition
objects are considered equivalent when they contain I<equivalent>
list of Unit objects.  Unit objects are in turn considered equivalent
if they satisfy the predicate
Unit::areEquivalent(@if java Unit u1, Unit u2@endif).
The predicate tests a subset of the objects's attributes.
@param ud1 the first UnitDefinition object to compare
@param ud2 the second UnitDefinition object to compare
Returns C<true> if all the Unit objects in ud1 are equivalent
to the Unit objects in ud2, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_areEquivalent(). They are functionally identical. @endif@~
@see UnitDefinition::areIdentical(const UnitDefinition   ud1, const UnitDefinition   ud2)
@see Unit::areEquivalent(Unit   unit1, Unit   unit2)


=item UnitDefinition::areIdenticalSIUnits

@internal

Predicate returning C<true> if two
UnitDefinition objects are equivalent.
For the purposes of performing this comparison, two UnitDefinition
objects are considered equivalent when they contain I<equivalent>
list of Unit objects.  Unit objects are in turn considered equivalent
if they satisfy the predicate
Unit::areEquivalent(@if java Unit u1, Unit u2@endif).
The predicate tests a subset of the objects's attributes.
@param ud1 the first UnitDefinition object to compare
@param ud2 the second UnitDefinition object to compare
Returns C<true> if all the Unit objects in ud1 are equivalent
to the Unit objects in ud2, C<false> otherwise.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_areEquivalent(). They are functionally identical. @endif@~
@see UnitDefinition::areIdentical(const UnitDefinition   ud1, const UnitDefinition   ud2)
@see Unit::areEquivalent(Unit   unit1, Unit   unit2)


=item UnitDefinition::combine

Combines two UnitDefinition objects into a single UnitDefinition.
This takes UnitDefinition objects C<ud1> and C<ud2>, and creates a
UnitDefinition object that expresses the product of the units of @p
ud1 and C<ud2>.
@param ud1 the first UnitDefinition object 
@param ud2 the second UnitDefinition object
Returns a UnitDefinition which represents the product of the 
units of the two argument UnitDefinitions.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_combine(). They are functionally identical. @endif@~


=item UnitDefinition::printUnits

Expresses the given definition in a plain-text form.
For example,
UnitDefinition::printUnits(@if java UnitDefinition u@endif)
applied to
@verbatim
<unitDefinition>
<listOfUnits>
<unit kind="metre" exponent="1"/>
<unit kind="second" exponent="-2"/>
</listOfUnits>
<unitDefinition>
@endverbatim
will return the string C<"metre (exponent = 1, multiplier = 1,
scale = 0) second (exponent = -2, multiplier = 1, scale = 0)">
or, if the optional parameter C<compact> is given the value C<true>,
the string C<"(1 metre)^1 (1 second)^-2">.  This method may
be useful for printing unit information to human users, or in
debugging software, or other situations.
@param ud the UnitDefinition object
@param compact boolean indicating whether the compact form
should be used (defaults to false)
Returns a string expressing the unit definition defined by the given
UnitDefinition object C<ud>.
@if notclike @note Because this is a I<static> method, the
non-C++ language interfaces for libSBML will contain two variants.  One
will be a static method on the class (i.e., UnitDefinition), and the
other will be a standalone top-level function with the name
UnitDefinition_printUnits(). They are functionally identical. @endif@~


=item UnitDefinition::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item UnitDefinition::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this UnitDefinition object
have been set.
@note The required attributes for a UnitDefinition object are:
@li "id"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item UnitDefinition::hasRequiredElements

Predicate returning C<true> if
all the required elements for this UnitDefinition object
have been set.
@note The required elements for a Constraint object are:
@li "listOfUnits" (required in SBML Level&nbsp;2 only, optional in Level&nbsp;3)
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item UnitDefinition::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item UnitDefinition::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item UnitDefinition::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item UnitDefinition::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item UnitDefinition::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item UnitDefinition::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item UnitDefinition::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfUnitDefinitions::ListOfUnitDefinitions

Creates a new ListOfUnitDefinitions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfUnitDefinitions::ListOfUnitDefinitions

Creates a new ListOfUnitDefinitions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfUnitDefinitions object to be created.


=item ListOfUnitDefinitions::clone

Creates and returns a deep copy of this ListOfUnitDefinitions instance.
Returns a (deep) copy of this ListOfUnitDefinitions.


=item ListOfUnitDefinitions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfUnitDefinitions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., UnitDefinition objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfUnitDefinitions::getElementName

Returns the XML element name of this object.
For ListOfUnitDefinitions, the XML element name is @c
"listOfUnitDefinitions".

Returns the name of this element, i.e., C<"listOfUnitDefinitions">.


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
Returns the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions.
@param n the index number of the UnitDefinition to get.
Returns the nth UnitDefinition in this ListOfUnitDefinitions.
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
Returns UnitDefinition in this ListOfUnitDefinitions
with the given id or C<NULL> if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::get

Get a UnitDefinition from the ListOfUnitDefinitions
based on its identifier.
@param sid a string representing the identifier 
of the UnitDefinition to get.
Returns UnitDefinition in this ListOfUnitDefinitions
with the given id or C<NULL> if no such
UnitDefinition exists.
@see get(unsigned int n)
@see size()


=item ListOfUnitDefinitions::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.  Note that UnitDefinitions themselves are in the UnitId namespace, not the SId namespace, so no UnitDefinition object will be returned from this function (and is the reason we override the base ListOf::getElementBySId function here).
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item ListOfUnitDefinitions::remove

Removes the nth item from this ListOfUnitDefinitions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfUnitDefinitions::remove

Removes item in this ListOfUnitDefinitions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfUnitDefinitions::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfUnitDefinitions in a model is (in SBML Level&nbsp;2
Version&nbsp;4) the second ListOf___.  (However, it differs for
different Levels and Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfUnitDefinitions::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or NULL if the token was not recognized.


=back

=head2 CompartmentType

LibSBML implementation of SBML's Level&nbsp;2's CompartmentType construct.
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 provide the <em>compartment
type</em> as a grouping construct that can be used to establish a
relationship between multiple Compartment objects.  A CompartmentType
object only has an identity, and this identity can only be used to
indicate that particular Compartment objects in the model belong to this
type.  This may be useful for conveying a modeling intention, such as
when a model contains many similar compartments, either by their
biological function or the reactions they carry.  Without a compartment
type construct, it would be impossible within SBML itself to indicate
that all of the compartments share an underlying conceptual relationship
because each SBML compartment must be given a unique and separate
identity.  Compartment types have no mathematical meaning in
SBML&mdash;they have no effect on a model's mathematical interpretation.
Simulators and other numerical analysis software may ignore
CompartmentType definitions and references to them in a model.
There is no mechanism in SBML Level 2 for representing hierarchies of
compartment types.  One CompartmentType instance cannot be the subtype
of another CompartmentType instance; SBML provides no means of defining
such relationships.
As with other major structures in SBML, CompartmentType has a mandatory
attribute, "id", used to give the compartment type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  CompartmentType also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specification (e.g.,
Section 3.3 in the Level 2 Version 4 specification).
CompartmentType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;1 nor in Level&nbsp;3.
@see Compartment
@see ListOfCompartmentTypes
@see SpeciesType
@see ListOfSpeciesTypes

=over


=back

=head2 ListOfCompartmentTypes

LibSBML implementation of SBML's ListOfCompartmentTypes construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item CompartmentType::CompartmentType

Creates a new CompartmentType using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this CompartmentType
@param version an unsigned int, the SBML Version to assign to this
CompartmentType

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a CompartmentType object to an SBMLDocument
(e.g., using Model::addCompartmentType(@if java CompartmentType ct@endif)), the SBML Level, SBML
Version and XML namespace of the document I<override> the
values used when creating the CompartmentType object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a CompartmentType is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item CompartmentType::CompartmentType

Creates a new CompartmentType using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a CompartmentType is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method setId(@if java String id@endif).
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a CompartmentType object to an SBMLDocument
(e.g., using Model::addCompartmentType(@if java CompartmentType ct@endif)), the SBML XML namespace of
the document I<overrides> the value used when creating the
CompartmentType object via this constructor.  This is necessary to
ensure that an SBML document is a consistent structure.  Nevertheless,
the ability to supply the values at the time of creation of a
CompartmentType is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item CompartmentType::CompartmentType

Copy constructor; creates a copy of this CompartmentType.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item CompartmentType::accept

Accepts the given SBMLVisitor for this instance of CompartmentType.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next CompartmentType in
the list of compartment types.


=item CompartmentType::clone

Creates and returns a deep copy of this CompartmentType.
Returns a (deep) copy of this CompartmentType.


=item CompartmentType::getId

Returns the value of the "id" attribute of this CompartmentType.
Returns the id of this CompartmentType.


=item CompartmentType::getName

Returns the value of the "name" attribute of this CompartmentType.
Returns the name of this CompartmentType.


=item CompartmentType::isSetId

Predicate returning C<true> if this
CompartmentType's "id" attribute is set.
Returns C<true> if the "id" attribute of this CompartmentType is
set, C<false> otherwise.


=item CompartmentType::isSetName

Predicate returning C<true> if this
CompartmentType's "name" attribute is set.
Returns C<true> if the "name" attribute of this CompartmentTypeType is
set, C<false> otherwise.


=item CompartmentType::setId

Sets the value of the "id" attribute of this CompartmentType.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this CompartmentType
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item CompartmentType::setName

Sets the value of the "name" attribute of this CompartmentType.
The string in C<name> is copied.
@param name the new name for the CompartmentType
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item CompartmentType::unsetName

Unsets the value of the "name" attribute of this CompartmentType.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item CompartmentType::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item CompartmentType::getElementName

Returns the XML element name of this object, which for
CompartmentType, is always C<"compartmentType">.
Returns the name of this element, i.e., C<"compartmentType">.


=item CompartmentType::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item CompartmentType::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this CompartmentType object
have been set.
@note The required attributes for a CompartmentType object are:
@li "id"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item CompartmentType::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item CompartmentType::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.


=item CompartmentType::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.


=item CompartmentType::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@param stream the XMLOutputStream to use.


=item ListOfCompartmentTypes::ListOfCompartmentTypes

Creates a new ListOfCompartmentTypes object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfCompartmentTypes::ListOfCompartmentTypes

Creates a new ListOfCompartmentTypes object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfCompartmentTypes object to be created.


=item ListOfCompartmentTypes::clone

Creates and returns a deep copy of this ListOfCompartmentTypes instance.
Returns a (deep) copy of this ListOfCompartmentTypes.


=item ListOfCompartmentTypes::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfCompartmentTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., CompartmentType objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfCompartmentTypes::getElementName

Returns the XML element name of this object.
For ListOfCompartmentTypes, the XML element name is @c
"listOfCompartmentTypes".

Returns the name of this element, i.e., C<"listOfCompartmentTypes">.


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType to get.
Returns the nth CompartmentType in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes.
@param n the index number of the CompartmentType to get.
Returns the nth CompartmentType in this ListOfCompartmentTypes.
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier 
of the CompartmentType to get.
Returns CompartmentType in this ListOfCompartmentTypes
with the given id or C<NULL> if no such
CompartmentType exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::get

Get a CompartmentType from the ListOfCompartmentTypes
based on its identifier.
@param sid a string representing the identifier 
of the CompartmentType to get.
Returns CompartmentType in this ListOfCompartmentTypes
with the given id or C<NULL> if no such
CompartmentType exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartmentTypes::remove

Removes the nth item from this ListOfCompartmentTypes items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfCompartmentTypes::remove

Removes item in this ListOfCompartmentTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartmentTypes::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  For example, the
ListOfCompartmentTypes in a model (in SBML Level 2 Version 4) is the
third ListOf___.  (However, it differs for different Levels and
Versions of SBML, so calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfCompartmentTypes::createObject

@internal

Create a ListOfCompartmentTypes object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.


=back

=head2 SpeciesType

LibSBML implementation of SBML Level&nbsp;2's SpeciesType construct.
The term I<species> I<type> refers to reacting entities independent of
location.  These include simple ions (e.g., protons, calcium), simple
molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
polysaccharides, and proteins), and others.
SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 provide an explicit
SpeciesType class of object to enable Species objects of the same type
to be related together.  SpeciesType is a conceptual construct; the
existence of SpeciesType objects in a model has no effect on the model's
numerical interpretation.  Except for the requirement for uniqueness of
species/species type combinations located in compartments, simulators
and other numerical analysis software may ignore SpeciesType definitions
and references to them in a model.
There is no mechanism in SBML Level 2 for representing hierarchies of
species types.  One SpeciesType object cannot be the subtype of another
SpeciesType object; SBML provides no means of defining such
relationships.

As with other major structures in SBML, SpeciesType has a mandatory
attribute, "id", used to give the species type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  SpeciesType also has an optional "name" attribute,
of type C<string>.  The "id" and "name" must be used according to the
guidelines described in the SBML specification (e.g., Section 3.3 in
the Level&nbsp;2 Version&nbsp;4 specification).
SpeciesType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;1 nor in Level&nbsp;3.
@see Species
@see ListOfSpeciesTypes
@see CompartmentType
@see ListOfCompartmentTypes
<!---------------------------------------------------------------------- -->

=over


=back

=head2 ListOfSpeciesTypes

LibSBML implementation of SBML's ListOfSpeciesTypes construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item SpeciesType::SpeciesType

Creates a new SpeciesType using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this SpeciesType
@param version an unsigned int, the SBML Version to assign to this
SpeciesType

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a SpeciesType object to an SBMLDocument
(e.g., using Model::addSpeciesType(@if java SpeciesType st@endif)),
the SBML Level, SBML Version and XML namespace of the document @em
override the values used when creating the SpeciesType object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a SpeciesType is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item SpeciesType::SpeciesType

Creates a new SpeciesType using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a SpeciesType object is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method SBase::setId(@if java String id@endif).
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a SpeciesType object to an SBMLDocument
(e.g., using Model::addSpeciesType(@if java SpeciesType st@endif)),
the SBML XML namespace of the document I<overrides> the value used
when creating the SpeciesType object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a SpeciesType is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item SpeciesType::SpeciesType

Copy constructor; creates a copy of this SpeciesType.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item SpeciesType::accept

Accepts the given SBMLVisitor for this instance of SpeciesType.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next SpeciesType in
the list of compartment types.


=item SpeciesType::clone

Creates and returns a deep copy of this SpeciesType.
Returns a (deep) copy of this SpeciesType.


=item SpeciesType::getId

Returns the value of the "id" attribute of this SpeciesType.
Returns the id of this SpeciesType.


=item SpeciesType::getName

Returns the value of the "name" attribute of this SpeciesType.
Returns the name of this SpeciesType.


=item SpeciesType::isSetId

Predicate returning C<true> if this
SpeciesType's "id" attribute is set.
Returns C<true> if the "id" attribute of this SpeciesType is
set, C<false> otherwise.


=item SpeciesType::isSetName

Predicate returning C<true> if this
SpeciesType's "name" attribute is set.
Returns C<true> if the "name" attribute of this SpeciesType is
set, C<false> otherwise.


=item SpeciesType::setId

Sets the value of the "id" attribute of this SpeciesType.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this SpeciesType
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item SpeciesType::setName

Sets the value of the "name" attribute of this SpeciesType.
The string in C<name> is copied.
@param name the new name for the SpeciesType
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item SpeciesType::unsetName

Unsets the value of the "name" attribute of this SpeciesType.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SpeciesType::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item SpeciesType::getElementName

Returns the XML element name of this object, which for
SpeciesType, is always C<"compartmentType">.
Returns the name of this element, i.e., C<"compartmentType">.


=item SpeciesType::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item SpeciesType::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this SpeciesType object
have been set.
@note The required attributes for a SpeciesType object are:
@li "id"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item SpeciesType::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item SpeciesType::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.


=item SpeciesType::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.
@param attributes the XMLAttributes to use.


=item SpeciesType::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.
@param stream the XMLOutputStream to use.


=item ListOfSpeciesTypes::ListOfSpeciesTypes

Creates a new ListOfSpeciesTypes object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfSpeciesTypes::ListOfSpeciesTypes

Creates a new ListOfSpeciesTypes object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpeciesTypes object to be created.


=item ListOfSpeciesTypes::clone

Creates and returns a deep copy of this ListOfSpeciesTypes instance.
Returns a (deep) copy of this ListOfSpeciesTypes.


=item ListOfSpeciesTypes::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpeciesTypes::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesType objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpeciesTypes::getElementName

Returns the XML element name of this object.
For ListOfSpeciesTypes, the XML element name is @c
"listOfSpeciesTypes".

Returns the name of this element, i.e., C<"listOfSpeciesTypes">.


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
Returns the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes.
@param n the index number of the SpeciesType to get.
Returns the nth SpeciesType in this ListOfSpeciesTypes.
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
Returns SpeciesType in this ListOfSpeciesTypes
with the given id or C<NULL> if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::get

Get a SpeciesType from the ListOfSpeciesTypes
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesType to get.
Returns SpeciesType in this ListOfSpeciesTypes
with the given id or C<NULL> if no such
SpeciesType exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesTypes::remove

Removes the nth item from this ListOfSpeciesTypes items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpeciesTypes::remove

Removes item in this ListOfSpeciesTypes items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesTypes::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  For example, the
ListOfSpeciesTypes in a model (in SBML Level 2 Version 4) is the
third ListOf___.  (However, it differs for different Levels and
Versions of SBML, so calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfSpeciesTypes::createObject

@internal

Create a ListOfSpeciesTypes object corresponding to the next token
in the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.


=back

=head2 Compartment

LibSBML implementation of SBML's Compartment construct.
A compartment in SBML represents a bounded space in which species are
located.  Compartments do not necessarily have to correspond to actual
structures inside or outside of a biological cell.
It is important to note that although compartments are optional in the
overall definition of Model, every species in an SBML model must be
located in a compartment.  This in turn means that if a model defines
any species, the model must also define at least one compartment.  The
reason is simply that species represent physical things, and therefore
must exist I<somewhere>.  Compartments represent the I<somewhere>.
Compartment has one required attribute, "id", to give the compartment a
unique identifier by which other parts of an SBML model definition can
refer to it.  A compartment can also have an optional "name" attribute
of type C<string>.  Identifiers and names must be used according to the
guidelines described in the SBML specifications.
Compartment also has an optional attribute "spatialDimensions" that is
used to indicate the number of spatial dimensions possessed by the
compartment.  Most modeling scenarios involve compartments with integer
values of "spatialDimensions" of C<3> (i.e., a three-dimensional
compartment, which is to say, a volume), or 2 (a two-dimensional
compartment, a surface), or C<1> (a one-dimensional compartment, a
line).  In SBML Level&nbsp;3, the type of this attribute is C<double>,
there are no restrictions on the permitted values of the
"spatialDimensions" attribute, and there are no default values.  In SBML
Level&nbsp;2, the value must be a positive C<integer>, and the default
value is C<3>; the permissible values in SBML Level&nbsp;2 are C<3>, @c
2, C<1>, and C<0> (for a point).
Another optional attribute on Compartment is "size", representing the
I<initial> total size of that compartment in the model.  The "size"
attribute must be a floating-point value and may represent a volume (if
the compartment is a three-dimensional one), or an area (if the
compartment is two-dimensional), or a length (if the compartment is
one-dimensional).  There is no default value of compartment size in SBML
Level&nbsp;2 or Level&nbsp;3.  In particular, a missing "size" value
<em>does not imply that the compartment size is 1</em>.  (This is unlike
the definition of compartment "volume" in SBML Level&nbsp;1.)  When the
compartment's "spatialDimensions" attribute does not have a value of @c
0, a missing value of "size" for a given compartment signifies that the
value either is unknown, or to be obtained from an external source, or
determined by an InitialAssignment, AssignmentRule, AlgebraicRule or
RateRule elsewhere in the model.  In SBML Level&nbsp;2, there are
additional special requirements on the values of "size"; we discuss them
in a <a href="#comp-l2">separate section below</a>.
The units associated with a compartment's "size" attribute value may be
set using the optional attribute "units".  The rules for setting and
using compartment size units differ between SBML Level&nbsp;2 and
Level&nbsp;3, and are discussed separately below.
Finally, the optional Compartment attribute named "constant" is used to
indicate whether the compartment's size stays constant after simulation
begins.  A value of C<true> indicates the compartment's "size" cannot be
changed by any other construct except InitialAssignment; a value of @c
false indicates the compartment's "size" can be changed by other
constructs in SBML.  In SBML Level&nbsp;2, there is an additional
explicit restriction that if "spatialDimensions"=C<"0">, the value
cannot be changed by InitialAssignment either.  Further, in
Level&nbsp;2, "constant" has a default value of C<true>.  In SBML
Level&nbsp;3, there is no default value for the "constant" attribute.
@section comp-l2 Additional considerations in SBML Level&nbsp;2
In SBML Level&nbsp;2, the default units of compartment size, and the
kinds of units allowed as values of the attribute "units", interact with
the number of spatial dimensions of the compartment.  The value of the
"units" attribute of a Compartment object must be one of the base units
(see Unit), or the predefined unit identifiers C<volume>, C<area>, @c
length or C<dimensionless>, or a new unit defined by a UnitDefinition
object in the enclosing Model, subject to the restrictions detailed in
the following table:
@htmlinclude compartment-size-restrictions.html 
In SBML Level&nbsp;2, the units of the compartment size, as defined by the
"units" attribute or (if "units" is not set) the default value listed in
the table above, are used in the following ways when the compartment has
a "spatialDimensions" value greater than C<0>:

=over


=item

The value of the "units" attribute is used as the units of the
compartment identifier when the identifier appears as a numerical
quantity in a mathematical formula expressed in MathML.

=item

The C<math> element of an AssignmentRule or InitialAssignment
referring to this compartment must have identical units.

=item

In RateRule objects that set the rate of change of the compartment's
size, the units of the rule's C<math> element must be identical to the
compartment's "units" attribute divided by the default I<time> units.
(In other words, the units for the rate of change of compartment size
are <em>compartment size</em>/<em>time</em> units.

=item

When a Species is to be treated in terms of concentrations or
density, the units of the spatial size portion of the concentration
value (i.e., the denominator in the units formula I<substance>/@em
size) are those indicated by the value of the "units" attribute on the
compartment in which the species is located.

=back


Compartments with "spatialDimensions"=C<0> require special treatment in
this framework.  As implied above, the "size" attribute must not have a
value on an SBML Level&nbsp;2 Compartment object if the
"spatialDimensions" attribute has a value of C<0>.  An additional
related restriction is that the "constant" attribute must default to or
be set to C<true> if the value of the "spatialDimensions" attribute is
C<0>, because a zero-dimensional compartment cannot ever have a size.
If a compartment has no size or dimensional units, how should such a
compartment's identifier be interpreted when it appears in mathematical
formulas?  The answer is that such a compartment's identifier should not
appear in mathematical formulas in the first place&mdash;it has no
value, and its value cannot change.  Note also that a zero-dimensional
compartment is a point, and species located at points can only be
described in terms of amounts, not spatially-dependent measures such as
concentration.  Since SBML KineticLaw formulas are already in terms of
I<substance>/I<time> and not (say) I<concentration>/I<time>, volume
or other factors in principle are not needed for species located in
zero-dimensional compartments.
Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
model may optionally be designated as belonging to a particular
compartment I<type>.  The optional attribute "compartmentType" is used
identify the compartment type represented by the Compartment structure.
The "compartmentType" attribute's value must be the identifier of a
CompartmentType instance defined in the model.  If the "compartmentType"
attribute is not present on a particular compartment definition, a
unique virtual compartment type is assumed for that compartment, and no
other compartment can belong to that compartment type.  The values of
"compartmentType" attributes on compartments have no effect on the
numerical interpretation of a model.  Simulators and other numerical
analysis software may ignore "compartmentType" attributes.  The
"compartmentType" attribute and the CompartmentType class of objects are
not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
@section comp-l3 Additional considerations in SBML Level&nbsp;3
One difference between SBML Level&nbsp;3 and lower Levels of SBML is
that there are no restrictions on the permissible values of the
"spatialDimensions" attribute, and there is no default value defined for
the attribute.  The value of "spatialDimensions" does not have to be an
integer, either; this is to allow for the possibility of representing
structures with fractal dimensions.
The number of spatial dimensions possessed by a compartment cannot enter
into mathematical formulas, and therefore cannot directly alter the
numerical interpretation of a model.  However, the value of
"spatialDimensions" I<does> affect the interpretation of the units
associated with a compartment's size.  Specifically, the value of
"spatialDimensions" is used to select among the Model attributes
"volumeUnits", "areaUnits" and "lengthUnits" when a Compartment object
does not define a value for its "units" attribute.
The "units" attribute may be left unspecified for a given compartment in
a model; in that case, the compartment inherits the unit of measurement
specified by one of the attributes on the enclosing Model object
instance.  The applicable attribute on Model depends on the value of the
compartment's "spatialDimensions" attribute; the relationship is shown
in the table below.  If the Model object does not define the relevant
attribute ("volumeUnits", "areaUnits" or "lengthUnits") for a given
"spatialDimensions" value, the unit associated with that Compartment
object's size is undefined.  If I<both> "spatialDimensions" and "units"
are left unset on a given Compartment object instance, then no unit can
be chosen from among the Model's "volumeUnits", "areaUnits" or
"lengthUnits" attributes (even if the Model instance provides values for
those attributes), because there is no basis to select between them and
there is no default value of "spatialDimensions".  Leaving the units of
compartments' sizes undefined in an SBML model does not render the model
invalid; however, as a matter of best practice, we strongly recommend
that all models specify the units of measurement for all compartment
sizes.

@htmlinclude compartment-size-recommendations.html
The unit of measurement associated with a compartment's size, as defined
by the "units" attribute or (if "units" is not set) the inherited value
from Model according to the table above, is used in the following ways:

=over



=item

When the identifier of the compartment appears as a numerical
quantity in a mathematical formula expressed in MathML, it represents
the size of the compartment, and the unit associated with the size is
the value of the "units" attribute.

=item

When a Species is to be treated in terms of concentrations or
density, the unit associated with the spatial size portion of the
concentration value (i.e., the denominator in the formula
<em>amount</em>/<em>size</em>) is specified by the value of the "units"
attribute on the compartment in which the species is located.

=item

The "math" elements of AssignmentRule, InitialAssignment and
EventAssignment objects setting the value of the compartment size
should all have the same units as the unit associated with the
compartment's size.

=item

In a RateRule object that defines a rate of change for a
compartment's size, the unit of the rule's "math" element should be
identical to the compartment's "units" attribute divided by the
model-wide unit of <em>time</em>.  (In other words, {<em>unit of
compartment size</em>}/{<em>unit of time</em>}.)

=back



@section comp-other Other aspects of Compartment
In SBML Level&nbsp;1 and Level&nbsp;2, Compartment has an optional
attribute named "outside", whose value can be the identifier of another
Compartment object defined in the enclosing Model object.  Doing so
means that the other compartment contains it or is outside of it.  This
enables the representation of simple topological relationships between
compartments, for those simulation systems that can make use of the
information (e.g., for drawing simple diagrams of compartments).  It is
worth noting that in SBML, there is no relationship between compartment
sizes when compartment positioning is expressed using the "outside"
attribute.  The size of a given compartment does not in any sense
include the sizes of other compartments having it as the value of their
"outside" attributes.  In other words, if a compartment I<B> has the
identifier of compartment I<A> as its "outside" attribute value, the
size of I<A> does not include the size of I<B>.  The compartment sizes
are separate.
In Level&nbsp;2, there are two restrictions on the "outside" attribute.
First, because a compartment with "spatialDimensions" of C<0> has no
size, such a compartment cannot act as the container of any other
compartment I<except> compartments that I<also> have
"spatialDimensions" values of C<0>.  Second, the directed graph formed
by representing Compartment structures as vertexes and the "outside"
attribute values as edges must be acyclic.  The latter condition is
imposed to prevent a compartment from being contained inside itself.  In
the absence of a value for "outside", compartment definitions in SBML
Level&nbsp;2 do not have any implied spatial relationships between each
other.


<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfCompartments

LibSBML implementation of SBML Level&nbsp;2's ListOfCompartments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Compartment::Compartment

Creates a new Compartment using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Compartment
@param version an unsigned int, the SBML Version to assign to this
Compartment

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Compartment object to an SBMLDocument
(e.g., using Model::addCompartment(@if java Compartment c@endif)), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the Compartment object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a Compartment is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item Compartment::Compartment

Creates a new Compartment using the given SBMLNamespaces object 
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Compartment is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method @if java Compartment::setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Compartment object to an SBMLDocument
(e.g., using Model::addCompartment(@if java Compartment c@endif)), the SBML XML namespace of the
document I<overrides> the value used when creating the Compartment
object via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a Compartment is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item Compartment::Compartment

Copy constructor; creates a copy of a Compartment.
@param orig the Compartment instance to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Compartment::accept

Accepts the given SBMLVisitor for this instance of Compartment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Compartment in the
list of compartments within which this Compartment is embedded (i.e.,
the ListOfCompartments in the parent Model).


=item Compartment::clone

Creates and returns a deep copy of this Compartment object.
Returns a (deep) copy of this Compartment.


=item Compartment::initDefaults

Initializes the fields of this Compartment object to "typical" default
values.

The SBML Compartment component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:

=over


=item

Sets attribute "spatialDimensions" to C<3>

=item

Sets attribute "constant" to C<true>

=item

(Applies to Level&nbsp;1 models only) Sets attribute "volume" to C<1>.0

=item

(Applies to Level&nbsp;3 models only) Sets attribute "units" to C<litre>

=back


=item Compartment::getId

Returns the value of the "id" attribute of this Compartment object.
Returns the id of this Compartment.


=item Compartment::getName

Returns the value of the "name" attribute of this Compartment object.
Returns the name of this Compartment.


=item Compartment::getCompartmentType

Get the value of the "compartmentType" attribute of this Compartment
object.

Returns the value of the "compartmentType" attribute of this
Compartment as a string.
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Compartment::getSpatialDimensions

Get the number of spatial dimensions of this Compartment object.
@note In SBML Level&nbsp;3, the data type of the "spatialDimensions"
attribute is C<double>, whereas in Level&nbsp;2, it is C<integer>.
LibSBML provides a separate method for obtaining the value as a double,
for models where it is relevant.
Returns the value of the "spatialDimensions" attribute of this
Compartment as an unsigned integer
@see getSpatialDimensionsAsDouble()


=item Compartment::getSpatialDimensionsAsDouble

Get the number of spatial dimensions of this Compartment object
as a double.
@note In SBML Level&nbsp;3, the data type of the "spatialDimensions"
attribute is C<double>, whereas in Level&nbsp;2, it is C<integer>.  To
avoid backward compatibility issues, libSBML provides a separate
method for obtaining the value as a double, for models where it is
relevant.

Returns the value of the "spatialDimensions" attribute of this
Compartment as a double, or C<NaN> if this model is not in SBML
Level&nbsp;3 format.
@see getSpatialDimensions()


=item Compartment::getSize

Get the size of this Compartment.
This method is identical to
@if java Compartment::getVolume()@else getVolume()@endif.
In SBML Level&nbsp;1, compartments are always three-dimensional
constructs and only have volumes, whereas in SBML Level&nbsp;2,
compartments may be other than three-dimensional and therefore the
"volume" attribute is named "size" in Level&nbsp;2.  LibSBML provides
both
@if java Compartment::getSize()@else getSize()@endif@~ and
@if java Compartment::getVolume()@else getVolume()@endif@~ for
easier compatibility between SBML Levels.
Returns the value of the "size" attribute ("volume" in Level&nbsp;1) of
this Compartment as a float-point number.
@see isSetSize()
@see getVolume()


=item Compartment::getVolume

Get the volume of this Compartment.
This method is identical to
@if java Compartment::getSize()@else getSize()@endif.  In
SBML Level&nbsp;1, compartments are always three-dimensional
constructs and only have volumes, whereas in SBML Level&nbsp;2,
compartments may be other than three-dimensional and therefore the
"volume" attribute is named "size" in Level&nbsp;2.  LibSBML provides
both
@if java Compartment::getSize()@else getSize()@endif@~ and
@if java Compartment::getVolume()@else getVolume()@endif@~
for easier compatibility between SBML Levels.
Returns the value of the "volume" attribute ("size" in Level&nbsp;2) of
this Compartment, as a floating-point number.
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".
@see isSetVolume()
@see getSize()


=item Compartment::getUnits

Get the units of this compartment's size.
The value of an SBML compartment's "units" attribute establishes the
unit of measurement associated with the compartment's size.
Returns the value of the "units" attribute of this Compartment, as a
string.  An empty string indicates that no units have been assigned to
the value of the size.
@note @htmlinclude unassigned-units-are-not-a-default.html
@see isSetUnits()
@see @if java Compartment::setUnits(String sid)@else setUnits()@endif@~
@see getSize()


=item Compartment::getOutside

Get the identifier, if any, of the compartment that is designated
as being outside of this one.
Returns the value of the "outside" attribute of this Compartment.
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
Core.


=item Compartment::getConstant

Get the value of the "constant" attribute of this Compartment.
Returns C<true> if this Compartment's size is flagged as being
constant, C<false> otherwise.


=item Compartment::isSetId

Predicate returning C<true> if this
Compartment's "id" attribute is set.
Returns C<true> if the "id" attribute of this Compartment is 
set, C<false> otherwise.


=item Compartment::isSetName

Predicate returning C<true> if this
Compartment's "name" attribute is set.
Returns C<true> if the "name" attribute of this Compartment is
set, C<false> otherwise.


=item Compartment::isSetCompartmentType

Predicate returning C<true> if this
Compartment's "compartmentType" attribute is set.
Returns C<true> if the "compartmentType" attribute of this Compartment
is set, C<false> otherwise.
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Compartment::isSetSize

Predicate returning C<true> if this
Compartment's "size" attribute is set.
This method is similar but not identical to
@if java Compartment::isSetVolume()@else isSetVolume()@endif.  The latter
should be used in the context of SBML Level&nbsp;1 models instead of
@if java Compartment::isSetSize()@else isSetSize()@endif@~
because @if java Compartment::isSetVolume()@else isSetVolume()@endif@~
performs extra processing to take into account the difference in
default values between SBML Levels 1 and 2.
Returns C<true> if the "size" attribute ("volume" in Level&nbsp;2) of
this Compartment is set, C<false> otherwise.
@see isSetVolume()
@see setSize(double value)


=item Compartment::isSetVolume

Predicate returning C<true> if this Compartment's
"volume" attribute is set.
This method is similar but not identical to
@if java Compartment::isSetSize()@else isSetSize()@endif.  The latter
should not be used in the context of SBML Level&nbsp;1 models because this
method performs extra processing to take into account
the difference in default values between SBML Levels 1 and 2.
Returns C<true> if the "volume" attribute ("size" in Level&nbsp;2 and
above) of this Compartment is set, C<false> otherwise.
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".  In SBML Level&nbsp;1, a compartment's volume has a
default value (C<1>.0) and therefore this method will always return @c
true.  In Level 2, a compartment's size (the equivalent of SBML
Level&nbsp;1's "volume") is optional and has no default value, and
therefore may or may not be set.
@see isSetSize()
@see @if java Compartment::setVolume(double value)@else setVolume()@endif@~


=item Compartment::isSetUnits

Predicate returning C<true> if this
Compartment's "units" attribute is set.
Returns C<true> if the "units" attribute of this Compartment is
set, C<false> otherwise.
@note @htmlinclude unassigned-units-are-not-a-default.html


=item Compartment::isSetOutside

Predicate returning C<true> if this
Compartment's "outside" attribute is set.
Returns C<true> if the "outside" attribute of this Compartment is
set, C<false> otherwise.
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
Core.


=item Compartment::isSetSpatialDimensions

Predicate returning C<true> if this
Compartment's "spatialDimensions" attribute is set.
Returns C<true> if the "spatialDimensions" attribute of this
Compartment is set, C<false> otherwise.


=item Compartment::isSetConstant

Predicate returning C<true> if this
Compartment's "constant" attribute is set.
Returns C<true> if the "constant" attribute of this Compartment is
set, C<false> otherwise.


=item Compartment::setId

Sets the value of the "id" attribute of this Compartment.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Compartment
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Compartment::setName

Sets the value of the "name" attribute of this Compartment.
The string in C<name> is copied.
@param name the new name for the Compartment
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Compartment::setCompartmentType

Sets the "compartmentType" attribute of this Compartment.
@param sid the identifier of a CompartmentType object defined
elsewhere in this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Compartment::setSpatialDimensions

Sets the "spatialDimensions" attribute of this Compartment.
If C<value> is not one of C<0>, C<1>, C<2>, or C<3>, this method will
have no effect (i.e., the "spatialDimensions" attribute will not be
set).

@param value an unsigned integer indicating the number of dimensions
of this compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Compartment::setSpatialDimensions

Sets the "spatialDimensions" attribute of this Compartment as a double.
@param value a double indicating the number of dimensions
of this compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Compartment::setSize

Sets the "size" attribute (or "volume" in SBML Level&nbsp;1) of this
Compartment.

This method is identical to
@if java Compartment::setVolume(double value)@else setVolume()@endif@~
and is provided for compatibility between
SBML Level&nbsp;1 and Level&nbsp;2.
@param value a C<double> representing the size of this compartment
instance in whatever units are in effect for the compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".


=item Compartment::setVolume

Sets the "volume" attribute (or "size" in SBML Level&nbsp;2) of this
Compartment.

This method is identical to
@if java Compartment::setVolume(double value)@else setVolume()@endif@~
and is provided for compatibility between SBML Level&nbsp;1 and
Level&nbsp;2.

@param value a C<double> representing the volume of this compartment
instance in whatever units are in effect for the compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".


=item Compartment::setUnits

Sets the "units" attribute of this Compartment.
@param sid the identifier of the defined units to use.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Compartment::setOutside

Sets the "outside" attribute of this Compartment.
@param sid the identifier of a compartment that encloses this one.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
Core.


=item Compartment::setConstant

Sets the value of the "constant" attribute of this Compartment.
@param value a boolean indicating whether the size/volume of this
compartment should be considered constant (C<true>) or variable
(C<false>)
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Compartment::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Compartment::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Compartment::unsetName

Unsets the value of the "name" attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Compartment::unsetCompartmentType

Unsets the value of the "compartmentType"
attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The "compartmentType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.
@see setCompartmentType(const std::string& sid)
@see isSetCompartmentType()


=item Compartment::unsetSize

Unsets the value of the "size" attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".


=item Compartment::unsetVolume

Unsets the value of the "volume" attribute of this
Compartment.

In SBML Level&nbsp;1, a Compartment volume has a default value (C<1>.0) and
therefore <em>should always be set</em>.  In Level&nbsp;2, "size" is
optional with no default value and as such may or may not be set.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The attribute "volume" only exists by that name in SBML
Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
named "size".


=item Compartment::unsetUnits

Unsets the value of the "units" attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Compartment::unsetOutside

Unsets the value of the "outside" attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "outside" attribute is defined in SBML Level&nbsp;1 and
Level&nbsp;2, but does not exist in SBML Level&nbsp;3 Version&nbsp;1
Core.


=item Compartment::unsetSpatialDimensions

Unsets the value of the "spatialDimensions" attribute of this Compartment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note This function is only valid for SBML Level&nbsp;3.


=item Compartment::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment's designated size.
Compartments in SBML have an attribute ("units") for declaring the
units of measurement intended for the value of the compartment's size.
In the absence of a value given for this attribute, the units are
inherited from values either defined on the enclosing Model (in SBML
Level&nbsp;3) or in defaults (in SBML Level&nbsp;2).  This method
returns a UnitDefinition object based on how this compartment's units
are interpreted according to the relevant SBML guidelines, or it
returns C<NULL> if no units have been declared and no defaults are
defined by the relevant SBML specification.
Note that unit declarations for Compartment objects are specified in
terms of the I<identifier> of a unit (e.g., using
@if java Compartment::setUnits(String sid)@else setUnits()@endif), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the special SBML
Level&nbsp;2 unit identifiers C<"substance">, C<"volume">, C<"area">,
C<"length"> or C<"time">.  Callers may find this useful in conjunction
with the helper methods provided by the UnitDefinition class for
comparing different UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Compartment, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Compartment object has not yet been added
to a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()
@see getUnits()


=item Compartment::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment's designated size.
Compartments in SBML have an attribute ("units") for declaring the
units of measurement intended for the value of the compartment's size.
In the absence of a value given for this attribute, the units are
inherited from values either defined on the enclosing Model (in SBML
Level&nbsp;3) or in defaults (in SBML Level&nbsp;2).  This method
returns a UnitDefinition object based on how this compartment's units
are interpreted according to the relevant SBML guidelines, or it
returns C<NULL> if no units have been declared and no defaults are
defined by the relevant SBML specification.
Note that unit declarations for Compartment objects are specified in
terms of the I<identifier> of a unit (e.g., using setUnits(@if java String sid@endif)), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the special SBML
Level&nbsp;2 unit identifiers C<"substance">, C<"volume">, C<"area">,
C<"length"> or C<"time">.  Callers may find this useful in conjunction
with the helper methods provided by the UnitDefinition class for
comparing different UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Compartment, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Compartment object has not yet been added
to a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()
@see getUnits()


=item Compartment::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Compartment::getElementName

Returns the XML element name of this object, which for Compartment, is
always C<"compartment">.
Returns the name of this element, i.e., C<"compartment">.


=item Compartment::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Compartment::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Compartment object
have been set.
@note The required attributes for a Compartment object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "constant" (in SBML Level&nbsp;3 only)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item Compartment::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Compartment::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Compartment::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Compartment::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Compartment::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Compartment::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Compartment::isExplicitlySetSpatialDimensions

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Compartment::isExplicitlySetConstant

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfCompartments::ListOfCompartments

Creates a new ListOfCompartments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfCompartments::ListOfCompartments

Creates a new ListOfCompartments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfCompartments object to be created.


=item ListOfCompartments::clone

Creates and returns a deep copy of this ListOfCompartments instance.
Returns a (deep) copy of this ListOfCompartments.


=item ListOfCompartments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfCompartments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Compartment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfCompartments::getElementName

Returns the XML element name of this object.
For ListOfCompartments, the XML element name is C<"listOfCompartments">.
Returns the name of this element, i.e., C<"listOfCompartments">.


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments.
@param n the index number of the Compartment to get.
Returns the nth Compartment in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments.
@param n the index number of the Compartment to get.
Returns the nth Compartment in this ListOfCompartments.
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier 
of the Compartment to get.
Returns Compartment in this ListOfCompartments
with the given id or C<NULL> if no such
Compartment exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::get

Get a Compartment from the ListOfCompartments
based on its identifier.
@param sid a string representing the identifier 
of the Compartment to get.
Returns Compartment in this ListOfCompartments
with the given id or C<NULL> if no such
Compartment exists.
@see get(unsigned int n)
@see size()


=item ListOfCompartments::remove

Removes the nth item from this ListOfCompartments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfCompartments::remove

Removes item in this ListOfCompartments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
C<NULL> is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfCompartments::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfCompartments
in a model is (in SBML Level&nbsp;2 Version&nbsp;4) the fifth
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfCompartments::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 Species

LibSBML implementation of SBML's Species construct.
A I<species> in SBML refers to a pool of entities that (a) are
considered indistinguishable from each other for the purposes of the
model, (b) participate in reactions, and (c) are located in a specific
I<compartment>.  The SBML Species object class is intended to represent
these pools.
As with other major constructs in SBML, Species has a mandatory
attribute, "id", used to give the species type an identifier in the
model.  The identifier must be a text string conforming to the identifer
syntax permitted in SBML.  Species also has an optional "name"
attribute, of type C<string>.  The "id" and "name" must be used
according to the guidelines described in the SBML specifications.
The required attribute "compartment" is used to identify the compartment
in which the species is located.  The attribute's value must be the
identifier of an existing Compartment object.  It is important to note
that there is no default value for the "compartment" attribute on
Species; every species in an SBML model must be assigned a compartment
I<explicitly>.  (This also implies that every model with one or more
Species objects must define at least one Compartment object.)
@section species-amounts The initial amount and concentration of a species
The optional attributes "initialAmount" and "initialConcentration", both
having a data type of C<double>, can be used to set the I<initial>
quantity of the species in the compartment where the species is located.
These attributes are mutually exclusive; i.e., <em>only one</em> can
have a value on any given instance of a Species object.  Missing
"initialAmount" and "initialConcentration" values implies that their
values either are unknown, or to be obtained from an external source, or
determined by an InitialAssignment or other SBML construct elsewhere in
the model.
A species' initial quantity in SBML is set by the "initialAmount" or
"initialConcentration" attribute exactly once.  If the "constant"
attribute is C<true>, then the value of the species' quantity is fixed
and cannot be changed except by an InitialAssignment.  These methods
differ in that the "initialAmount" and "initialConcentration" attributes
can only be used to set the species quantity to a literal floating-point
number, whereas the use of an InitialAssignment object allows the value
to be set using an arbitrary mathematical expression (which, thanks to
MathML's expressiveness, may evaluate to a rational number).  If the
species' "constant" attribute is C<false>, the species' quantity value
may be overridden by an InitialAssignment or changed by AssignmentRule
or AlgebraicRule, and in addition, for <em>t &gt; 0</em>, it may also be
changed by a RateRule, Event objects, and as a result of being a
reactant or product in one or more Reaction objects.  (However, some
constructs are mutually exclusive; see the SBML specifications for the
precise details.)  It is not an error to define "initialAmount" or
"initialConcentration" on a species and also redefine the value using an
InitialAssignment, but the "initialAmount" or "initialConcentration"
setting in that case is ignored.  The SBML specifications provide
additional information about the semantics of assignments, rules and
values for simulation time <em>t</em> \f$\leq\f$ <em>0</em>.
SBML Level&nbsp;2 additionally stipulates that in cases where a species'
compartment has a "spatialDimensions" value of C<0> (zero), the species
cannot have a value for "initialConcentration" because the concepts of
concentration and density break down when a container has zero
dimensions.

@section species-units The units of a species' amount or concentration
When the attribute "initialAmount" is set, the unit of measurement
associated with the value of "initialAmount" is specified by the Species
attribute "substanceUnits".  When the "initialConcentration" attribute
is set, the unit of measurement associated with this concentration value
is {<em>unit of amount</em>} divided by {<em>unit of size</em>}, where
the {<em>unit of amount</em>} is specified by the Species
"substanceUnits" attribute, and the {<em>unit of size</em>} is specified
by the "units" attribute of the Compartment object in which the species
is located.  Note that in either case, a unit of <em>amount</em> is
involved and determined by the "substanceUnits" attribute.  Note
<strong>these two attributes alone do not determine the units of the
species when the species identifier appears in a mathematical
expression</strong>; <em>that</em> aspect is determined by the attribute
"hasOnlySubstanceUnits" discussed below.
In SBML Level&nbsp;3, if the "substanceUnits" attribute is not set on a
given Species object instance, then the unit of <em>amount</em> for that
species is inherited from the "substanceUnits" attribute on the
enclosing Model object instance.  If that attribute on Model is not set
either, then the unit associated with the species' quantity is
undefined.

In SBML Level&nbsp;2, if the "substanceUnits" attribute is not set on a
given Species object instance, then the unit of <em>amount</em> for that
species is taken from the predefined SBML unit identifier @c
"substance".  The value assigned to "substanceUnits" must be chosen from
one of the following possibilities: one of the base unit identifiers
defined in SBML, the built-in unit identifier C<"substance">, or the
identifier of a new unit defined in the list of unit definitions in the
enclosing Model object.  The chosen units for "substanceUnits" must be
be C<"dimensionless">, C<"mole">, C<"item">, C<"kilogram">, C<"gram">,
or units derived from these.
As noted at the beginning of this section, simply setting
"initialAmount" or "initialConcentration" alone does I<not> determine
whether a species identifier represents an amount or a concentration
when it appears elsewhere in an SBML model.  The role of the attribute
"hasOnlySubstanceUnits" is to indicate whether the units of the species,
when the species identifier appears in mathematical formulas, are
intended to be concentration or amount.  The attribute takes on a
boolean value.  In SBML Level&nbsp;3, the attribute has no default value
and must always be set in a model; in SBML Level&nbsp;2, it has a
default value of C<false>.
The <em>units of the species</em> are used in the following ways:

=over



=item

When the species' identifier appears in a MathML formula, it
represents the species' quantity, and the unit of measurement associated
with the quantity is as described above.

=item

The "math" elements of AssignmentRule, InitialAssignment and
EventAssignment objects referring to this species should all have the
same units as the unit of measurement associated with the species
quantity.


=item

In a RateRule object that defines the rate of change of the
species' quantity, the unit associated with the rule's "math" element
should be equal to the unit of the species' quantity divided by the
model-wide unit of <em>time</em>; in other words, {<em>unit of species
quantity</em>}/{<em>unit of time</em>}.

=back



@section species-constant The "constant" and "boundaryCondition" attributes
The Species object class has two boolean attributes named "constant" and
"boundaryCondition", used to indicate whether and how the quantity of
that species can vary during a simulation.  In SBML Level&nbsp;2 they
are optional; in SBML Level&nbsp;3 they are mandatory.  The following
table shows how to interpret the combined values of these attributes.
@htmlinclude species-boundarycondition.html
By default, when a species is a product or reactant of one or more
reactions, its quantity is determined by those reactions.  In SBML, it
is possible to indicate that a given species' quantity is <em>not</em>
determined by the set of reactions even when that species occurs as a
product or reactant; i.e., the species is on the <em>boundary</em> of
the reaction system, and its quantity is not determined by the
reactions.  The boolean attribute "boundaryCondition" can be used to
indicate this.  A value of C<false> indicates that the species I<is>
part of the reaction system.  In SBML Level&nbsp;2, the attribute has a
default value of C<false>, while in SBML Level&nbsp;3, it has no
default.

The "constant" attribute indicates whether the species' quantity can be
changed at all, regardless of whether by reactions, rules, or constructs
other than InitialAssignment.  A value of C<false> indicates that the
species' quantity can be changed.  (This is also a common value because
the purpose of most simulations is precisely to calculate changes in
species quantities.)  In SBML Level&nbsp;2, the attribute has a default
value of C<false>, while in SBML Level&nbsp;3, it has no default.  Note
that the initial quantity of a species can be set by an
InitialAssignment irrespective of the value of the "constant" attribute.
In practice, a "boundaryCondition" value of C<true> means a differential
equation derived from the reaction definitions should not be generated
for the species.  However, the species' quantity may still be changed by
AssignmentRule, RateRule, AlgebraicRule, Event, and InitialAssignment
constructs if its "constant" attribute is C<false>.  Conversely, if the
species' "constant" attribute is C<true>, then its value cannot be
changed by anything except InitialAssignment.
A species having "boundaryCondition"=C<false> and "constant"=C<false>
can appear as a product and/or reactant of one or more reactions in the
model.  If the species is a reactant or product of a reaction, it must
I<not> also appear as the target of any AssignmentRule or RateRule
object in the model.  If instead the species has "boundaryCondition"=@c
false and "constant"=C<true>, then it cannot appear as a reactant or
product, or as the target of any AssignmentRule, RateRule or
EventAssignment object in the model.
@section species-l2-convfactor The conversionFactor attribute in SBML Level&nbsp;3
In SBML Level&nbsp;3, Species has an additional optional attribute,
"conversionFactor", that defines a conversion factor that applies to a
particular species.  The value must be the identifier of a Parameter
object instance defined in the model.  That Parameter object must be a
constant, meaning its "constant" attribute must be set to C<true>.
If a given Species object definition defines a value for its
"conversionFactor" attribute, it takes precedence over any factor
defined by the Model object's "conversionFactor" attribute.
The unit of measurement associated with a species' quantity can be
different from the unit of extent of reactions in the model.  SBML
Level&nbsp;3 avoids implicit unit conversions by providing an explicit
way to indicate any unit conversion that might be required.  The use of
a conversion factor in computing the effects of reactions on a species'
quantity is explained in detail in the SBML Level&nbsp;3 specification
document.  Because the value of the "conversionFactor" attribute is the
identifier of a Parameter object, and because parameters can have units
attached to them, the transformation from reaction extent units to
species units can be completely specified using this approach.
Note that the unit conversion factor is <strong>only applied when
calculating the effect of a reaction on a species</strong>.  It is not
used in any rules or other SBML constructs that affect the species, and
it is also not used when the value of the species is referenced in a
mathematical expression.
@section species-l2-type The speciesType attribute in SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
In SBML Level&nbsp;2 Versions&nbsp;2&ndash;4, each species in a model
may optionally be designated as belonging to a particular species type.
The optional attribute "speciesType" is used to identify the species
type of the chemical entities that make up the pool represented by the
Species objects.  The attribute's value must be the identifier of an
existing SpeciesType object in the model.  If the "speciesType"
attribute is not present on a particular species definition, it means
the pool contains chemical entities of a type unique to that pool; in
effect, a virtual species type is assumed for that species, and no other
species can belong to that species type.  The value of "speciesType"
attributes on species have no effect on the numerical interpretation of
a model; simulators and other numerical analysis software may ignore
"speciesType" attributes.
There can be only one species of a given species type in any given
compartment of a model.  More specifically, for all Species objects
having a value for the "speciesType" attribute, the pair
<center>
("speciesType" attribute value, "compartment" attribute value)
</center>

must be unique across the set of all Species object in a model.
@section species-other The spatialSizeUnits attribute in SBML Level&nbsp;2 Versions&nbsp;1&ndash;2
In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because many software
tools do no properly interpret this unit declaration and it is
incompatible with all SBML specifications after Level&nbsp;2
Version&nbsp;3.


@section species-math Additional considerations for interpreting the numerical value of a species
Species are unique in SBML in that they have a kind of duality: a
species identifier may stand for either substance amount (meaning, a
count of the number of individual entities) or a concentration or
density (meaning, amount divided by a compartment size).  The previous
sections explain the meaning of a species identifier when it is
referenced in a mathematical formula or in rules or other SBML
constructs; however, it remains to specify what happens to a species
when the compartment in which it is located changes in size.
When a species definition has a "hasOnlySubstanceUnits" attribute value
of C<false> and the size of the compartment in which the species is
located changes, the default in SBML is to assume that it is the
concentration that must be updated to account for the size change.  This
follows from the principle that, all other things held constant, if a
compartment simply changes in size, the size change does not in itself
cause an increase or decrease in the number of entities of any species
in that compartment.  In a sense, the default is that the I<amount> of
a species is preserved across compartment size changes.  Upon such size
changes, the value of the concentration or density must be recalculated
from the simple relationship <em>concentration = amount / size</em> if
the value of the concentration is needed (for example, if the species
identifier appears in a mathematical formula or is otherwise referenced
in an SBML construct).  There is one exception: if the species' quantity
is determined by an AssignmentRule, RateRule, AlgebraicRule, or an
EventAssignment and the species has a "hasOnlySubstanceUnits" attribute
value of C<false>, it means that the <em>concentration</em> is assigned
by the rule or event; in that case, the <em>amount</em> must be
calculated when the compartment size changes.  (Events also require
additional care in this situation, because an event with multiple
assignments could conceivably reassign both a species quantity and a
compartment size simultaneously.  Please refer to the SBML
specifications for the details.)
Note that the above only matters if a species has a
"hasOnlySubstanceUnits" attribute value of C<false>, meaning that the
species identifier refers to a concentration wherever the identifier
appears in a mathematical formula.  If instead the attribute's value is
C<true>, then the identifier of the species <em>always</em> stands for
an amount wherever it appears in a mathematical formula or is referenced
by an SBML construct.  In that case, there is never a question about
whether an assignment or event is meant to affect the amount or
concentration: it is always the amount.
A particularly confusing situation can occur when the species has
"constant" attribute value of C<true> in combination with a
"hasOnlySubstanceUnits" attribute value of C<false>.  Suppose this
species is given a value for "initialConcentration".  Does a "constant"
value of C<true> mean that the concentration is held constant if the
compartment size changes?  No; it is still the amount that is kept
constant across a compartment size change.  The fact that the species
was initialized using a concentration value is irrelevant.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfSpecies

LibSBML implementation of SBML Level&nbsp;2's ListOfSpecies construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Species::Species

Creates a new Species using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Species
@param version an unsigned int, the SBML Version to assign to this
Species

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Species object to an SBMLDocument (e.g.,
using Model::addSpecies(@if java Species s@endif)), the SBML Level, SBML Version and XML
namespace of the document I<override> the values used when creating
the Species object via this constructor.  This is necessary to ensure
that an SBML document is a consistent structure.  Nevertheless, the
ability to supply the values at the time of creation of a Species is
an important aid to producing valid SBML.  Knowledge of the intented
SBML Level and Version determine whether it is valid to assign a
particular value to an attribute, or whether it is valid to add an
object to an existing SBMLDocument.


=item Species::Species

Creates a new Species using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Species is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method Species::setId(@if java String id@endif).
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Species object to an SBMLDocument (e.g.,
using Model::addSpecies(@if java Species s@endif)), the SBML XML namespace of the document @em
overrides the value used when creating the Species object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a Species is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Species::Species

Copy constructor; creates a copy of this Species object.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Species::accept

Accepts the given SBMLVisitor for this instance of Species.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Species::clone

Creates and returns a deep copy of this Species object.
Returns a (deep) copy of this Species object.


=item Species::initDefaults

Initializes the fields of this Species object to "typical" defaults
values.

The SBML Species component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:

=over


=item

Sets "boundaryCondition" to C<false>

=item

Sets "constant" to C<false>

=item

sets "hasOnlySubstanceUnits" to C<false>

=item

(Applies to Level&nbsp;3 models only) Sets attribute "substanceUnits" to C<mole>

=back


=item Species::getId

Returns the value of the "id" attribute of this Species object.
Returns the id of this Species object.


=item Species::getName

Returns the value of the "name" attribute of this Species object.
Returns the name of this Species object.


=item Species::getSpeciesType

Get the type of this Species object object.
Returns the value of the "speciesType" attribute of this
Species as a string.
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::getCompartment

Get the compartment in which this species is located.
The compartment is designated by its identifier.
Returns the value of the "compartment" attribute of this Species
object, as a string.


=item Species::getInitialAmount

Get the value of the "initialAmount" attribute.
Returns the initialAmount of this Species, as a float-point number.


=item Species::getInitialConcentration

Get the value of the "initialConcentration" attribute.
Returns the initialConcentration of this Species,, as a float-point
number.

@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::getSubstanceUnits

Get the value of the "substanceUnits" attribute.
Returns the value of the "substanceUnits" attribute of this Species,
as a string.  An empty string indicates that no units have been
assigned.

@note @htmlinclude unassigned-units-are-not-a-default.html
@see isSetSubstanceUnits()
@see setSubstanceUnits(const std::string& sid)


=item Species::getSpatialSizeUnits

Get the value of the "spatialSizeUnits" attribute.
Returns the value of the "spatialSizeUnits" attribute of this Species
object, as a string.
@warning In versions of SBML Level&nbsp;2 before Version&nbsp;3, the
class Species included an attribute called "spatialSizeUnits", which
allowed explicitly setting the units of size for initial
concentration.  This attribute was removed in SBML Level&nbsp;2
Version&nbsp;3.  LibSBML retains this attribute for compatibility with
older definitions of Level&nbsp;2, but its use is strongly discouraged
because it is incompatible with Level&nbsp;2 Version&nbsp;3 and
Level&nbsp;2 Version&nbsp;4.


=item Species::getUnits

Get the value of the "units" attribute.
Returns the units of this Species (L1 only).
@note The "units" attribute is defined only in SBML Level&nbsp;1.  In
SBML Level&nbsp;2 and Level&nbsp;3, it has been replaced by a
combination of "substanceUnits" and the units of the Compartment
object in which a species is located.  In SBML Level&nbsp;2
Versions&nbsp;1&ndash;2, an additional attribute "spatialSizeUnits"
helps determine the units of the species quantity, but this attribute
was removed in later versions of SBML Level&nbsp;2.


=item Species::getHasOnlySubstanceUnits

Get the value of the "hasOnlySubstanceUnits" attribute.
Returns C<true> if this Species' "hasOnlySubstanceUnits" attribute
value is nonzero, C<false> otherwise.
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::getBoundaryCondition

Get the value of the "boundaryCondition" attribute.
Returns C<true> if this Species' "boundaryCondition" attribute value
is nonzero, C<false> otherwise.


=item Species::getCharge

Get the value of the "charge" attribute.
Returns the charge of this Species object.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species is deprecated and in SBML Level&nbsp;3 it does
not exist at all.  Its use strongly discouraged.  Its presence is
considered a misfeature in earlier definitions of SBML because its
implications for the mathematics of a model were never defined, and in
any case, no known modeling system ever used it.  Instead, models take
account of charge values directly in their definitions of species by
(for example) having separate species identities for the charged and
uncharged versions of the same species.  This allows the condition to
affect model mathematics directly.  LibSBML retains this method for
easier compatibility with SBML Level&nbsp;1.


=item Species::getConstant

Get the value of the "constant" attribute.
Returns C<true> if this Species's "constant" attribute value is
nonzero, C<false> otherwise.
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::getConversionFactor

Get the value of the "conversionFactor" attribute.
Returns the conversionFactor of this Species, as a string.
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::isSetId

Predicate returning C<true> if this
Species object's "id" attribute is set.
Returns C<true> if the "id" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetName

Predicate returning C<true> if this
Species object's "name" attribute is set.
Returns C<true> if the "name" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetSpeciesType

Predicate returning C<true> if this Species object's
"speciesType" attribute is set.
Returns C<true> if the "speciesType" attribute of this Species is
set, C<false> otherwise.
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::isSetCompartment

Predicate returning C<true> if this
Species object's "compartment" attribute is set.
Returns C<true> if the "compartment" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetInitialAmount

Predicate returning C<true> if this
Species object's "initialAmount" attribute is set.
Returns C<true> if the "initialAmount" attribute of this Species is
set, C<false> otherwise.
@note In SBML Level&nbsp;1, Species' "initialAmount" is required and
therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
attribute has no default value either, so this method will not return
C<true> until a value has been assigned.)  In SBML Level&nbsp;2,
"initialAmount" is optional and as such may or may not be set.


=item Species::isSetInitialConcentration

Predicate returning C<true> if this
Species object's "initialConcentration" attribute is set.
Returns C<true> if the "initialConcentration" attribute of this Species is
set, C<false> otherwise.
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::isSetSubstanceUnits

Predicate returning C<true> if this
Species object's "substanceUnits" attribute is set.
Returns C<true> if the "substanceUnits" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetSpatialSizeUnits

Predicate returning C<true> if this
Species object's "spatialSizeUnits" attribute is set.
Returns C<true> if the "spatialSizeUnits" attribute of this Species is
set, C<false> otherwise.
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::isSetUnits

Predicate returning C<true> if
this Species object's "units" attribute is set.
Returns C<true> if the "units" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetCharge

Predicate returning C<true> if this
Species object's "charge" attribute is set.
Returns C<true> if the "charge" attribute of this Species is
set, C<false> otherwise.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and in SBML Level&nbsp;3 it
does not exist at all.  Its use strongly discouraged.  Its presence is
considered a misfeature in earlier definitions of SBML because its
implications for the mathematics of a model were never defined, and in
any case, no known modeling system ever used it.  Instead, models take
account of charge values directly in their definitions of species by
(for example) having separate species identities for the charged and
uncharged versions of the same species.  This allows the condition to
affect model mathematics directly.  LibSBML retains this method for
easier compatibility with SBML Level&nbsp;1.


=item Species::isSetConversionFactor

Predicate returning C<true> if this
Species object's "conversionFactor" attribute is set.
Returns C<true> if the "conversionFactor" attribute of this Species is
set, C<false> otherwise.
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::isSetBoundaryCondition

Predicate returning C<true> if this
Species object's "boundaryCondition" attribute is set.
Returns C<true> if the "boundaryCondition" attribute of this Species is
set, C<false> otherwise.


=item Species::isSetHasOnlySubstanceUnits

Predicate returning C<true> if this
Species object's "hasOnlySubstanceUnits" attribute is set.
Returns C<true> if the "hasOnlySubstanceUnits" attribute of this Species is
set, C<false> otherwise.
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::isSetConstant

Predicate returning C<true> if this
Species object's "constant" attribute is set.
Returns C<true> if the "constant" attribute of this Species is
set, C<false> otherwise.
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setId

Sets the value of the "id" attribute of this Species object.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Species
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Species::setName

Sets the value of the "name" attribute of this Species object.
The string in C<name> is copied.
@param name the new name for the Species
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Species::setSpeciesType

Sets the "speciesType" attribute of this Species object.
@param sid the identifier of a SpeciesType object defined elsewhere
in this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The "speciesType" attribute is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::setCompartment

Sets the "compartment" attribute of this Species object.
@param sid the identifier of a Compartment object defined elsewhere
in this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Species::setInitialAmount

Sets the "initialAmount" attribute of this Species and marks the field
as set.
This method also unsets the "initialConcentration" attribute.
@param value the value to which the "initialAmount" attribute should
be set.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Species::setInitialConcentration

Sets the "initialConcentration" attribute of this Species and marks
the field as set.
This method also unsets the "initialAmount" attribute.
@param value the value to which the "initialConcentration" attribute
should be set.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setSubstanceUnits

Sets the "substanceUnits" attribute of this Species object.
@param sid the identifier of the unit to use.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Species::setSpatialSizeUnits

(SBML Level&nbsp;2 Versions&nbsp;1&ndash;2) Sets the "spatialSizeUnits" attribute of this Species object.
@param sid the identifier of the unit to use.
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Species::setUnits

(SBML Level&nbsp;1 only) Sets the units of this Species object.
@param sname the identifier of the unit to use.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Species::setHasOnlySubstanceUnits

Sets the "hasOnlySubstanceUnits" attribute of this Species object.
@param value boolean value for the "hasOnlySubstanceUnits" attribute.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The "hasOnlySubstanceUnits" attribute does not exist in SBML
Level&nbsp;1.


=item Species::setBoundaryCondition

Sets the "boundaryCondition" attribute of this Species object.
@param value boolean value for the "boundaryCondition" attribute.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Species::setCharge

Sets the "charge" attribute of this Species object.
@param value an integer to which to set the "charge" to.
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and its use strongly
discouraged, and it does not exist in SBML Level&nbsp;3 at all.  Its
presence is considered a misfeature in earlier definitions of SBML
because its implications for the mathematics of a model were never
defined, and in any case, no known modeling system ever used it.
Instead, models take account of charge values directly in their
definitions of species by (for example) having separate species
identities for the charged and uncharged versions of the same species.
This allows the condition to affect model mathematics directly.
LibSBML retains this method for easier compatibility with SBML
Level&nbsp;1.

Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Species::setConstant

Sets the "constant" attribute of this Species object.
@param value a boolean value for the "constant" attribute
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attribute "constant" is only available in SBML Levels&nbsp;2
and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::setConversionFactor

Sets the value of the "conversionFactor" attribute of this Species object.
The string in C<sid> is copied.
@param sid the new conversionFactor for the Species
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::unsetName

Unsets the value of the "name" attribute of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Species::unsetSpeciesType

Unsets the "speciesType" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The attribute "speciesType" is only available in SBML
Level&nbsp;2 Versions&nbsp;2&ndash;4.


=item Species::unsetInitialAmount

Unsets the "initialAmount" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Species::unsetInitialConcentration

Unsets the "initialConcentration" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The attribute "initialConcentration" is only available in SBML
Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.


=item Species::unsetSubstanceUnits

Unsets the "substanceUnits" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Species::unsetSpatialSizeUnits

Unsets the "spatialSizeUnits" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@warning In versions of SBML Level~2 before Version&nbsp;3, the class
Species included an attribute called "spatialSizeUnits", which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML
retains this attribute for compatibility with older definitions of
Level&nbsp;2, but its use is strongly discouraged because it is
incompatible with Level&nbsp;2 Version&nbsp;3 and Level&nbsp;2 Version&nbsp;4.


=item Species::unsetUnits

Unsets the "units" attribute value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Species::unsetCharge

Unsets the "charge" attribute
value of this Species object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the "charge"
attribute on Species in SBML is deprecated and its use strongly
discouraged, and it does not exist in SBML Level&nbsp;3 at all.  Its
presence is considered a misfeature in earlier definitions of SBML
because its implications for the mathematics of a model were never
defined, and in any case, no known modeling system ever used it.
Instead, models take account of charge values directly in their
definitions of species by (for example) having separate species
identities for the charged and uncharged versions of the same species.
This allows the condition to affect model mathematics directly.
LibSBML retains this method for easier compatibility with SBML
Level&nbsp;1.


=item Species::unsetConversionFactor

Unsets the "conversionFactor" attribute value of this Species object.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "conversionFactor" attribute was introduced in SBML
Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
and&nbsp;2.


=item Species::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.
Species in SBML have an attribute ("substanceUnits") for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
"substanceUnits", the units are taken from the enclosing Model's
definition of C<"substance"> or C<"substance">/<em>(size of the
compartment)</em> in which the species is located, or finally, if
these are not redefined by the Model, the relevant SBML default units
for those quantities.  Following that procedure, the method
@if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
Note also that unit declarations for Species are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.
In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
includes an additional attribute named "spatialSizeUnits", which
allows explicitly setting the units of size for initial concentration.
The @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
takes this into account for models
expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
Returns a UnitDefinition that expresses the units of this 
Species, or C<NULL> if one cannot be constructed.
@see getSubstanceUnits()


=item Species::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.
Species in SBML have an attribute ("substanceUnits") for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
"substanceUnits", the units are taken from the enclosing Model's
definition of C<"substance"> or C<"substance">/<em>(size of the
compartment)</em> in which the species is located, or finally, if
these are not redefined by the Model, the relevant SBML default units
for those quantities.  Following that procedure, the method
@if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
Note also that unit declarations for Species are in terms of the @em
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.
In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
includes an additional attribute named "spatialSizeUnits", which
allows explicitly setting the units of size for initial concentration.
The @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
takes this into account for models
expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
Returns a UnitDefinition that expresses the units of this 
Species, or C<NULL> if one cannot be constructed.
@see getSubstanceUnits()


=item Species::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Species::getElementName

Returns the XML element name of this object, which for Species, is
always C<"species">.
Returns the name of this element, i.e., C<"species">.


=item Species::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Species::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Species object
have been set.
@note The required attributes for a Species object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "compartment"
@li "initialAmount" (required in SBML Level&nbsp;1 only; optional otherwise)
@li "hasOnlySubstanceUnits" (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
@li "boundaryCondition" (required in SBML Level&nbsp;3; optional in Levels&nbsp;1 and&nbsp;2)
@li "constant" (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item Species::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Species::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Species::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Species::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Species::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Species::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Species::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Species::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Species::isExplicitlySetBoundaryCondition

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Species::isExplicitlySetConstant

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Species::isExplicitlySetHasOnlySubsUnits

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfSpecies::ListOfSpecies

Creates a new ListOfSpecies object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfSpecies::ListOfSpecies

Creates a new ListOfSpecies object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpecies object to be created.


=item ListOfSpecies::clone

Creates and returns a deep copy of this ListOfSpeciess instance.
Returns a (deep) copy of this ListOfSpeciess.


=item ListOfSpecies::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpecies::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Species objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpecies::getElementName

Returns the XML element name of this object.
For ListOfSpeciess, the XML element name is C<"listOfSpeciess">.
Returns the name of this element, i.e., C<"listOfSpeciess">.


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
Returns the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies.
@param n the index number of the Species to get.
Returns the nth Species in this ListOfSpecies.
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
Returns Species in this ListOfSpecies
with the given id or C<NULL> if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::get

Get a Species from the ListOfSpecies
based on its identifier.
@param sid a string representing the identifier 
of the Species to get.
Returns Species in this ListOfSpecies
with the given id or C<NULL> if no such
Species exists.
@see get(unsigned int n)
@see size()


=item ListOfSpecies::remove

Removes the nth item from this ListOfSpeciess items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpecies::remove

Removes item in this ListOfSpeciess items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpecies::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfSpeciess in
a model is (in SBML Level&nbsp;2 Version&nbsp;4) the sixth
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfSpecies::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 Parameter

LibSBML implementation of SBML's Parameter construct.
A Parameter is used in SBML to define a symbol associated with a value;
this symbol can then be used in mathematical formulas in a model.  By
default, parameters have constant value for the duration of a
simulation, and for this reason are called I<parameters> instead of @em
variables in SBML, although it is crucial to understand that <em>SBML
parameters represent both concepts</em>.  Whether a given SBML
parameter is intended to be constant or variable is indicated by the
value of its "constant" attribute.
SBML's Parameter has a required attribute, "id", that gives the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
"name" attribute of type C<string>.  Identifiers and names must be used
according to the guidelines described in the SBML specifications.
The optional attribute "value" determines the value (of type C<double>)
assigned to the parameter.  A missing value for "value" implies that
the value either is unknown, or to be obtained from an external source,
or determined by an initial assignment.  The unit of measurement
associated with the value of the parameter can be specified using the
optional attribute "units".  Here we only mention briefly some notable
points about the possible unit choices, but readers are urged to consult
the SBML specification documents for more information:

=over



=item

In SBML Level&nbsp;3, there are no constraints on the units that
can be assigned to parameters in a model; there are also no units to
inherit from the enclosing Model object (unlike the case for, e.g.,
Species and Compartment).

=item

In SBML Level&nbsp;2, the value assigned to the parameter's "units"
attribute must be chosen from one of the following possibilities: one of
the base unit identifiers defined in SBML; one of the built-in unit
identifiers C<"substance">, C<"time">, C<"volume">, C<"area"> or @c
"length"; or the identifier of a new unit defined in the list of unit
definitions in the enclosing Model structure.  There are no constraints
on the units that can be chosen from these sets.  There are no default
units for parameters.

=back


The Parameter structure has another boolean attribute named "constant"
that is used to indicate whether the parameter's value can vary during a
simulation.  (In SBML Level&nbsp;3, the attribute is mandatory and must
be given a value; in SBML Levels below Level&nbsp;3, the attribute is
optional.)  A value of C<true> indicates the parameter's value cannot be
changed by any construct except InitialAssignment.  Conversely, if the
value of "constant" is C<false>, other constructs in SBML, such as rules
and events, can change the value of the parameter.
SBML Level&nbsp;3 uses a separate object class, LocalParameter, for
parameters that are local to a Reaction's KineticLaw.  In Levels prior
to SBML Level&nbsp;3, the Parameter class is used both for definitions
of global parameters, as well as reaction-local parameters stored in a
list within KineticLaw objects.  Parameter objects that are local to a
reaction (that is, those defined within the KineticLaw structure of a
Reaction) cannot be changed by rules and therefore are <em>implicitly
always constant</em>; consequently, in SBML Level&nbsp;2, parameter
definitions within Reaction structures should I<not> have their
"constant" attribute set to C<false>.
What if a global parameter has its "constant" attribute set to C<false>,
but the model does not contain any rules, events or other constructs
that ever change its value over time?  Although the model may be
suspect, this situation is not strictly an error.  A value of C<false>
for "constant" only indicates that a parameter I<can> change value, not
that it I<must>.
As with all other major SBML components, Parameter is derived from
SBase, and the methods defined on SBase are available on Parameter.
@note The use of the term I<parameter> in SBML sometimes leads to
confusion among readers who have a particular notion of what something
called "parameter" should be.  It has been the source of heated debate,
but despite this, no one has yet found an adequate replacement term that
does not have different connotations to different people and hence leads
to confusion among I<some> subset of users.  Perhaps it would have been
better to have two constructs, one called I<constants> and the other
called I<variables>.  The current approach in SBML is simply more
parsimonious, using a single Parameter construct with the boolean flag
"constant" indicating which flavor it is.  In any case, readers are
implored to look past their particular definition of a I<parameter> and
simply view SBML's Parameter as a single mechanism for defining both
constants and (additional) variables in a model.  (We write @em
additional because the species in a model are usually considered to be
the central variables.)  After all, software tools are not required to
expose to users the actual names of particular SBML constructs, and
thus tools can present to their users whatever terms their designers
feel best matches their target audience.
@see ListOfParameters
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfParameters

LibSBML implementation of SBML's ListOfParameters construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Parameter::Parameter

Creates a new Parameter using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Parameter
@param version an unsigned int, the SBML Version to assign to this
Parameter

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Parameter object to an SBMLDocument
(e.g., using Model::addParameter(@if java Parameter p@endif)), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the Parameter object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a Parameter is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item Parameter::Parameter

Creates a new Parameter using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a Parameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method
@if java setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Parameter object to an SBMLDocument
(e.g., using Model::addParameter(@if java Parameter p@endif)), the SBML XML namespace of the
document I<overrides> the value used when creating the Parameter
object via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a Parameter is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item Parameter::Parameter

Copy constructor; creates a copy of a Parameter.
@param orig the Parameter instance to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Parameter::accept

Accepts the given SBMLVisitor for this instance of Parameter.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, indicating
whether the Visitor would like to visit the next Parameter object in
the list of parameters within which I<the> present object is
embedded.


=item Parameter::clone

Creates and returns a deep copy of this Parameter.
Returns a (deep) copy of this Parameter.


=item Parameter::initDefaults

Initializes the fields of this Parameter object to "typical" defaults
values.

The SBML Parameter component has slightly different aspects and
default attribute values in different SBML Levels and Versions.  Many
SBML object classes defined by libSBML have an initDefaults() method
to set the values to certain common defaults, based mostly on what
they are in SBML Level&nbsp;2.  In the case of Parameter, this method
only sets the value of the "constant" attribute to C<true>.
@see getConstant()
@see isSetConstant()
@see setConstant(@if java boolean flag@endif)


=item Parameter::getId

Returns the value of the "id" attribute of this Parameter.
Returns the id of this Parameter.


=item Parameter::getName

Returns the value of the "name" attribute of this Parameter.
Returns the name of this Parameter.


=item Parameter::getValue

Gets the numerical value of this Parameter.
Returns the value of the "value" attribute of this Parameter, as a
number of type C<double>.
@note B<It is crucial> that callers not blindly call
Parameter::getValue() without first using Parameter::isSetValue() to
determine whether a value has ever been set.  Otherwise, the value
return by Parameter::getValue() may not actually represent a value
assigned to the parameter.  The reason is simply that the data type
C<double> in a program always has I<some> value.  A separate test is
needed to determine whether the value is a true model value, or
uninitialized data in a computer's memory location.
@see isSetValue()
@see setValue(double value)
@see getUnits()


=item Parameter::getUnits

Gets the units defined for this Parameter.
The value of an SBML parameter's "units" attribute establishes the
unit of measurement associated with the parameter's value.
Returns the value of the "units" attribute of this Parameter, as a
string.  An empty string indicates that no units have been assigned.
@note @htmlinclude unassigned-units-are-not-a-default.html
@see isSetUnits()
@see setUnits(@if java String units@endif)
@see getValue()


=item Parameter::getConstant

Gets the value of the "constant" attribute of this Parameter instance.
Returns C<true> if this Parameter is declared as being constant,
C<false> otherwise.
@note Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level&nbsp;3, where
LocalParameter is derived directly from SBase and not Parameter.  We
believe this arrangement makes it easier for libSBML users to program
applications that work with both SBML Level&nbsp;2 and SBML
Level&nbsp;3, but programmers should also keep in mind this difference
exists.  A side-effect of libSBML's scheme is that certain methods on
LocalParameter that are inherited from Parameter do not actually have
relevance to LocalParameter objects.  An example of this is the
methods pertaining to Parameter's attribute "constant" (i.e.,
isSetConstant(), setConstant(), and getConstant()).
@see isSetConstant()
@see setConstant(@if java boolean flag@endif)


=item Parameter::isSetId

Predicate returning C<true> if this
Parameter's "id" attribute is set.
Returns C<true> if the "id" attribute of this Parameter is
set, C<false> otherwise.


=item Parameter::isSetName

Predicate returning C<true> if this
Parameter's "name" attribute is set.
Returns C<true> if the "name" attribute of this Parameter is
set, C<false> otherwise.


=item Parameter::isSetValue

Predicate returning C<true> if the
"value" attribute of this Parameter is set.
In SBML definitions after SBML Level&nbsp;1 Version&nbsp;1,
parameter values are optional and have no defaults.  If a model read
from a file does not contain a setting for the "value" attribute of a
parameter, its value is considered unset; it does not default to any
particular value.  Similarly, when a Parameter object is created in
libSBML, it has no value until given a value.  The
Parameter::isSetValue() method allows calling applications to
determine whether a given parameter's value has ever been set.
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In Level&nbsp;1 Version&nbsp;2 and beyond, the value is
optional and as such, the "value" attribute may or may not be set.
Returns C<true> if the value of this Parameter is set,
C<false> otherwise.
@see getValue()
@see setValue(double value)


=item Parameter::isSetUnits

Predicate returning C<true> if the
"units" attribute of this Parameter is set.
Returns C<true> if the "units" attribute of this Parameter is
set, C<false> otherwise.
@note @htmlinclude unassigned-units-are-not-a-default.html


=item Parameter::isSetConstant

Predicate returning C<true> if the
"constant" attribute of this Parameter is set.
Returns C<true> if the "constant" attribute of this Parameter is
set, C<false> otherwise.
@note Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level&nbsp;3, where
LocalParameter is derived directly from SBase and not Parameter.  We
believe this arrangement makes it easier for libSBML users to program
applications that work with both SBML Level&nbsp;2 and SBML
Level&nbsp;3, but programmers should also keep in mind this difference
exists.  A side-effect of libSBML's scheme is that certain methods on
LocalParameter that are inherited from Parameter do not actually have
relevance to LocalParameter objects.  An example of this is the
methods pertaining to Parameter's attribute "constant" (i.e.,
isSetConstant(), setConstant(), and getConstant()).
@see getConstant()
@see setConstant(@if java boolean flag@endif)


=item Parameter::setId

Sets the value of the "id" attribute of this Parameter.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Parameter
Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Parameter::setName

Sets the value of the "name" attribute of this Parameter.
The string in C<name> is copied.
@param name the new name for the Parameter
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Parameter::setValue

Sets the "value" attribute of this Parameter to the given C<double>
value and marks the attribute as set.
@param value a C<double>, the value to assign
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Parameter::setUnits

Sets the "units" attribute of this Parameter to a copy of the given
units identifier C<units>.
@param units a string, the identifier of the units to assign to this
Parameter instance
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Parameter::setConstant

Sets the "constant" attribute of this Parameter to the given boolean
C<flag>.
@param flag a boolean, the value for the "constant" attribute of this
Parameter instance
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level&nbsp;3, where
LocalParameter is derived directly from SBase and not Parameter.  We
believe this arrangement makes it easier for libSBML users to program
applications that work with both SBML Level&nbsp;2 and SBML
Level&nbsp;3, but programmers should also keep in mind this difference
exists.  A side-effect of libSBML's scheme is that certain methods on
LocalParameter that are inherited from Parameter do not actually have
relevance to LocalParameter objects.  An example of this is the
methods pertaining to Parameter's attribute "constant" (i.e.,
isSetConstant(), setConstant(), and getConstant()).
@see getConstant()
@see isSetConstant()


=item Parameter::unsetName

Unsets the value of the "name" attribute of this Parameter.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Parameter::unsetValue

Unsets the "value" attribute of this Parameter instance.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
In SBML Level&nbsp;1 Version&nbsp;1, parameters are required to have
values and therefore, the value of a Parameter B<should always be
set>.  In SBML Level&nbsp;1 Version&nbsp;2 and beyond, the value
is optional and as such, the "value" attribute may or may not be set.


=item Parameter::unsetUnits

Unsets the "units" attribute of this Parameter instance.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Parameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.
Parameters in SBML have an attribute ("units") for declaring the units
of measurement intended for the parameter's value.  B<No defaults are
defined> by SBML in the absence of a definition for "units".  This
method returns a UnitDefinition object based on the units declared for
this Parameter using its "units" attribute, or it returns C<NULL> if
no units have been declared.
Note that unit declarations for Parameter objects are specified in
terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.For SBML Level&nbsp;2 models, it will do this even when
the value of the "units" attribute is one of the special SBML
Level&nbsp;2 unit identifiers C<"substance">, C<"volume">, C<"area">,
C<"length"> or C<"time">.  Callers may find this useful in conjunction
with the helper methods provided by the UnitDefinition class for
comparing different UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Parameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Parameter object has not yet been added to
a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item Parameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.
Parameters in SBML have an attribute ("units") for declaring the units
of measurement intended for the parameter's value.  B<No defaults are
defined> by SBML in the absence of a definition for "units".  This
method returns a UnitDefinition object based on the units declared for
this Parameter using its "units" attribute, or it returns C<NULL> if
no units have been declared.
Note that unit declarations for Parameter objects are specified in
terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the predefined SBML
units C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time".  Callers may find this useful in conjunction with the helper
methods provided by the UnitDefinition class for comparing different
UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
Parameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Parameter object has not yet been added to
a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item Parameter::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or
@link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Parameter::getElementName

Returns the XML element name of this object, which for Parameter, is
always C<"parameter">.
Returns the name of this element, i.e., C<"parameter">.


=item Parameter::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Parameter::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this Parameter object
have been set.
@note The required attributes for a Parameter object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "value" (required in Level&nbsp;1, optional otherwise)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item Parameter::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Parameter::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Parameter::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Parameter::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Parameter::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Parameter::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Parameter::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Parameter::isExplicitlySetConstant

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfParameters::ListOfParameters

Creates a new ListOfParameters object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfParameters::ListOfParameters

Creates a new ListOfParameters object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfParameters object to be created.


=item ListOfParameters::clone

Creates and returns a deep copy of this ListOfParameters instance.
Returns a (deep) copy of this ListOfParameters.


=item ListOfParameters::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfParameters::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Parameter objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink
(default).

@see getElementName()


=item ListOfParameters::getElementName

Returns the XML element name of this object.
For ListOfParameters, the XML element name is C<"listOfParameters">.
Returns the name of this element, i.e., C<"listOfParameters">.


=item ListOfParameters::get

Returns the Parameter object located at position C<n> within this
ListOfParameters instance.
@param n the index number of the Parameter to get.
Returns the nth Parameter in this ListOfParameters.  If the index C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfParameters::get

Returns the Parameter object located at position C<n> within this
ListOfParameters instance.
@param n the index number of the Parameter to get.
Returns the nth Parameter in this ListOfParameters.  If the index C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfParameters::get

Returns the first Parameter object matching the given identifier.
@param sid a string, the identifier of the Parameter to get.
Returns the Parameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfParameters::get

Returns the first Parameter object matching the given identifier.
@param sid a string representing the identifier of the Parameter to
get.

Returns the Parameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfParameters::remove

Removes the nth item from this ListOfParameters, and returns a pointer
to it.
@param n the index of the item to remove
Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number C<n> is out of
bounds for the length of the list, then C<NULL> is returned.
@see size()


=item ListOfParameters::remove

Removes the first Parameter object in this ListOfParameters
matching the given identifier, and returns a pointer to it.
@param sid the identifier of the item to remove.
Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching C<sid>, then C<NULL> is returned.


=item ListOfParameters::getElementPosition

@internal

Gets the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfParameters
in a model is (in SBML Level&nbsp;2 Version&nbsp;4) the seventh
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfParameters::createObject

@internal

Create a ListOfParameters object corresponding to the next token in
the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.


=back

=head2 LocalParameter

LibSBML implementation of SBML Level&nbsp;3's LocalParameter construct.
LocalParameter has been introduced in SBML Level&nbsp;3 to serve as the
object class for parameter definitions that are intended to be local to
a Reaction.  Objects of class LocalParameter never appear at the Model
level; they are always contained within ListOfLocalParameters lists
which are in turn contained within KineticLaw objects.
Like its global Parameter counterpart, the LocalParameter object class
is used to define a symbol associated with a value; this symbol can then
be used in a model's mathematical formulas (and specifically, for
LocalParameter, reaction rate formulas).  Unlike Parameter, the
LocalParameter class does not have a "constant" attribute: local
parameters within reactions are I<always> constant.
LocalParameter has one required attribute, "id", to give the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
"name" attribute of type C<string>.  Identifiers and names must be used
according to the guidelines described in the SBML specifications.
The optional attribute "value" determines the value (of type C<double>)
assigned to the parameter.  A missing value for "value" implies that
the value either is unknown, or to be obtained from an external source,
or determined by an initial assignment.  The unit of measurement
associated with the value of the parameter can be specified using the
optional attribute "units".  Here we only mention briefly some notable
points about the possible unit choices, but readers are urged to consult
the SBML specification documents for more information:

=over



=item

In SBML Level&nbsp;3, there are no constraints on the units that
can be assigned to parameters in a model; there are also no units to
inherit from the enclosing Model object.

=item

In SBML Level&nbsp;2, the value assigned to the parameter's "units"
attribute must be chosen from one of the following possibilities: one of
the base unit identifiers defined in SBML; one of the built-in unit
identifiers C<"substance">, C<"time">, C<"volume">, C<"area"> or @c
"length"; or the identifier of a new unit defined in the list of unit
definitions in the enclosing Model structure.  There are no constraints
on the units that can be chosen from these sets.  There are no default
units for local parameters.

=back


As with all other major SBML components, LocalParameter is derived from
SBase, and the methods defined on SBase are available on LocalParameter.
@warning LibSBML derives LocalParameter from Parameter; however, this
does not precisely match the object hierarchy defined by SBML
Level&nbsp;3, where LocalParameter is derived directly from SBase and not
Parameter.  We believe this arrangement makes it easier for libSBML
users to program applications that work with both SBML Level&nbsp;2 and
SBML Level&nbsp;3, but programmers should also keep in mind this
difference exists.  A side-effect of libSBML's scheme is that certain
methods on LocalParameter that are inherited from Parameter do not
actually have relevance to LocalParameter objects.  An example of this
is the methods pertaining to Parameter's attribute "constant"
(i.e., isSetConstant(), setConstant(), and getConstant()).
@see ListOfLocalParameters
@see KineticLaw
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfLocalParameters

LibSBML implementation of SBML Level&nbsp;3's ListOfLocalParameters construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
ListOfLocalParameters is a subsidiary object class used only within
KineticLaw in SBML Level&nbsp;3.  It is not defined in SBML Levels
1&ndash;2.  In Level&nbsp;3, a KineticLaw object can have a single
object of class ListOfLocalParameters containing a set of local
parameters used in that kinetic law definition.
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item LocalParameter::LocalParameter

Creates a new LocalParameter object with the given SBML C<level> and
C<version> values.
@param level an unsigned int, the SBML Level to assign to this
LocalParameter.

@param version an unsigned int, the SBML Version to assign to this
LocalParameter.

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a LocalParameter object to an SBMLDocument
(e.g., using KineticLaw::addLocalParameter(@if java LocalParameter p@endif)), the SBML Level, SBML
Version and XML namespace of the document I<override> the
values used when creating the LocalParameter object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a LocalParameter is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item LocalParameter::LocalParameter

Creates a new LocalParameter object with the given SBMLNamespaces
object C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level&nbsp;2 and beyond, the "id"
(identifier) attribute of a LocalParameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method
@if java setId(String id)@else setId()@endif.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a LocalParameter object to an SBMLDocument
(e.g., using KineticLaw::addLocalParameter(@if java LocalParameter p@endif)), the SBML XML namespace of
the document I<overrides> the value used when creating the
LocalParameter object via this constructor.  This is necessary to
ensure that an SBML document is a consistent structure.  Nevertheless,
the ability to supply the values at the time of creation of a
LocalParameter is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item LocalParameter::LocalParameter

Copy constructor; creates a copy of a given LocalParameter object.
@param orig the LocalParameter instance to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item LocalParameter::LocalParameter

Copy constructor; creates a LocalParameter object by copying
the attributes of a given Parameter object.
@param orig the Parameter instance to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item LocalParameter::accept

Accepts the given SBMLVisitor for this instance of LocalParameter.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next LocalParameter in the list
of parameters within which this LocalParameter is embedded (i.e., either
the list of parameters in the parent Model or the list of parameters
in the enclosing KineticLaw).


=item LocalParameter::clone

Creates and returns a deep copy of this LocalParameter.
Returns a (deep) copy of this LocalParameter.


=item LocalParameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this LocalParameter's value.
LocalParameters in SBML have an attribute ("units") for declaring the
units of measurement intended for the parameter's value.  B<No
defaults are defined> by SBML in the absence of a definition for
"units".  This method returns a UnitDefinition object based on the
units declared for this LocalParameter using its "units" attribute, or
it returns C<NULL> if no units have been declared.
Note that unit declarations for LocalParameter objects are specified
in terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the predefined SBML
units C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time".  Callers may find this useful in conjunction with the helper
methods provided by the UnitDefinition class for comparing different
UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
LocalParameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the LocalParameter object has not yet been
added to a model, or the model itself is incomplete, unit analysis is
not possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item LocalParameter::getDerivedUnitDefinition

Constructs and returns a UnitDefinition that corresponds to the units
of this LocalParameter's value.
LocalParameters in SBML have an attribute ("units") for declaring the
units of measurement intended for the parameter's value.  B<No
defaults are defined> by SBML in the absence of a definition for
"units".  This method returns a UnitDefinition object based on the
units declared for this LocalParameter using its "units" attribute, or
it returns C<NULL> if no units have been declared.
Note that unit declarations for LocalParameter objects are specified
in terms of the I<identifier> of a unit (e.g., using setUnits()), but
I<this> method returns a UnitDefinition object, not a unit
identifier.  It does this by constructing an appropriate
UnitDefinition.  For SBML Level&nbsp;2 models, it will do this even
when the value of the "units" attribute is one of the predefined SBML
units C<"substance">, C<"volume">, C<"area">, C<"length"> or @c
"time".  Callers may find this useful in conjunction with the helper
methods provided by the UnitDefinition class for comparing different
UnitDefinition objects.
Returns a UnitDefinition that expresses the units of this 
LocalParameter, or C<NULL> if one cannot be constructed.
@note The libSBML system for unit analysis depends on the model as a
whole.  In cases where the LocalParameter object has not yet been
added to a model, or the model itself is incomplete, unit analysis is
not possible, and consequently this method will return C<NULL>.
@see isSetUnits()


=item LocalParameter::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item LocalParameter::getElementName

Returns the XML element name of this object, which for LocalParameter,
is always C<"localParameter">.
Returns the name of this element, i.e., C<"localParameter">.


=item LocalParameter::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this LocalParameter object
have been set.
@note The required attributes for a LocalParameter object are:
@li "id"
@li "value"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item LocalParameter::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item LocalParameter::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item LocalParameter::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item LocalParameter::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfLocalParameters::ListOfLocalParameters

Creates a new ListOfLocalParameters object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfLocalParameters::ListOfLocalParameters

Creates a new ListOfLocalParameters object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfLocalParameters object to be created.


=item ListOfLocalParameters::clone

Creates and returns a deep copy of this ListOfLocalParameters object.
Returns a (deep) copy of this ListOfLocalParameters.


=item ListOfLocalParameters::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfLocalParameters::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., LocalParameter objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink
(default).

@see getElementName()


=item ListOfLocalParameters::getElementName

Returns the XML element name of this object.
For ListOfLocalParameters, the XML element name is C<"listOfLocalParameters">.
Returns the name of this element, i.e., C<"listOfLocalParameters">.


=item ListOfLocalParameters::get

Returns the LocalParameter object located at position C<n> within this
ListOfLocalParameters instance.
@param n the index number of the LocalParameter to get.
Returns the nth LocalParameter in this ListOfLocalParameters.  If the
index C<n> is out of bounds for the length of the list, then C<NULL>
is returned.
@see size()
@see get(const std::string& sid)


=item ListOfLocalParameters::get

Returns the LocalParameter object located at position C<n> within this
ListOfLocalParameters instance.
@param n the index number of the LocalParameter to get.
Returns the item at position C<n>.  The caller owns the returned
object and is responsible for deleting it.  If the index number C<n>
is out of bounds for the length of the list, then C<NULL> is returned.
@see size()
@see get(const std::string& sid)


=item ListOfLocalParameters::get

Returns the first LocalParameter object matching the given identifier.
@param sid a string, the identifier of the LocalParameter to get.
Returns the LocalParameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfLocalParameters::get

Returns the first LocalParameter object matching the given identifier.
@param sid a string representing the identifier of the LocalParameter
to get.
Returns the LocalParameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching C<sid>, then C<NULL> is returned.
@see get(unsigned int n)
@see size()


=item ListOfLocalParameters::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.  Note that LocalParameters, while they use the SId namespace, are not in the model-wide SId namespace, so no LocalParameter object will be returned from this function (and is the reason we override the base ListOf::getElementBySId function here).
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item ListOfLocalParameters::remove

Removes the nth item from this ListOfLocalParameters, and returns a
pointer to it.
@param n the index of the item to remove.  
Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number C<n> is out of
bounds for the length of the list, then C<NULL> is returned.
@see size()
@see remove(const std::string& sid)


=item ListOfLocalParameters::remove

Removes the first LocalParameter object in this ListOfLocalParameters
matching the given identifier, and returns a pointer to it.
@param sid the identifier of the item to remove.
Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching C<sid>, then C<NULL> is returned.


=item ListOfLocalParameters::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfLocalParameters
in a model is (in SBML Level&nbsp;2 Version&nbsp;4) the seventh
ListOf___.  (However, it differs for different Levels and Versions of
SBML.)

Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfLocalParameters::createObject

@internal

Create a ListOfLocalParameters object corresponding to the next token in
the XML input stream.
Returns the SBML object corresponding to next XMLToken in the
XMLInputStream, or C<NULL> if the token was not recognized.


=back

=head2 InitialAssignment

LibSBML implementation of SBML's InitialAssignment construct.
SBML Level 2 Versions 2&ndash;4 and SBML Level&nbsp;3 provide two ways of assigning initial
values to entities in a model.  The simplest and most basic is to set
the values of the appropriate attributes in the relevant components; for
example, the initial value of a model parameter (whether it is a
constant or a variable) can be assigned by setting its "value" attribute
directly in the model definition.  However, this approach is not
suitable when the value must be calculated, because the initial value
attributes on different components such as species, compartments, and
parameters are single values and not mathematical expressions.  In those
situations, the InitialAssignment construct can be used; it permits the
calculation of the value of a constant or the initial value of a
variable from the values of I<other> quantities in a model.
As explained below, the provision of InitialAssignment does not mean
that models necessarily must use this construct when defining initial
values of quantities in a model.  If a value can be set directly using
the relevant attribute of a component in a model, then that
approach may be more efficient and more portable to other software
tools.  InitialAssignment should be used when the other mechanism is
insufficient for the needs of a particular model.
The InitialAssignment construct has some similarities to AssignmentRule.
The main differences are: (a) an InitialAssignment can set the value of
a constant whereas an AssignmentRule cannot, and (b) unlike
AssignmentRule, an InitialAssignment definition only applies up to and
including the beginning of simulation time, i.e., <em>t \f$\leq\f$ 0</em>,
while an AssignmentRule applies at all times.
InitialAssignment has a required attribute, "symbol", whose value must
follow the guidelines for identifiers described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).  The value of this attribute in an InitialAssignment
object can be the identifier of a Compartment, Species or global
Parameter elsewhere in the model.  The InitialAssignment defines the
initial value of the constant or variable referred to by the "symbol"
attribute.  (The attribute's name is "symbol" rather than "variable"
because it may assign values to constants as well as variables in a
model.)  Note that an initial assignment cannot be made to reaction
identifiers, that is, the "symbol" attribute value of an
InitialAssignment cannot be an identifier that is the "id" attribute
value of a Reaction object in the model.  This is identical to a
restriction placed on rules.
InitialAssignment also has a required "math" subelement that contains a
MathML expression used to calculate the value of the constant or the
initial value of the variable.  The units of the value computed by the
formula in the "math" subelement should (in SBML Level&nbsp;2
Version&nbsp;4 and in SBML Level&nbsp;3) or must (in previous Versions) be identical to be the
units associated with the identifier given in the "symbol" attribute.
(That is, the units are the units of the species, compartment, or
parameter, as appropriate for the kind of object identified by the value
of "symbol".)
InitialAssignment was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level&nbsp;2 Version&nbsp;1 nor in any version of Level 1.
@section initassign-semantics Semantics of Initial Assignments
The value calculated by an InitialAssignment object overrides the value
assigned to the given symbol by the object defining that symbol.  For
example, if a compartment's "size" attribute is set in its definition,
and the model also contains an InitialAssignment having that
compartment's identifier as its "symbol" attribute value, then the
interpretation is that the "size" assigned in the Compartment object
should be ignored and the value assigned based on the computation
defined in the InitialAssignment.  Initial assignments can take place
for Compartment, Species and global Parameter objects regardless of the
value of their "constant" attribute.
The actions of all InitialAssignment objects are in general terms
the same, but differ in the precise details depending on the type
of variable being set:

=over


=item

<em>In the case of a species</em>, an InitialAssignment sets the
referenced species' initial quantity (concentration or amount of
substance) to the value determined by the formula in the "math"
subelement.    The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units specified for the species.

=item

<em>In the case of a compartment</em>, an InitialAssignment sets
the referenced compartment's initial size to the size determined by the
formula in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units specified for the size of the compartment.

=item

<em>In the case of a parameter</em>, an InitialAssignment sets the
referenced parameter's initial value to that determined by the formula
in "math".  The overall units of the formula should (in SBML
Level&nbsp;2 Version&nbsp;4 and SBML Level&nbsp;3) or must (in previous Versions) be the same
as the units defined for the parameter.  
=back

In the context of a simulation, initial assignments establish values
that are in effect prior to and including the start of simulation time,
i.e., <em>t \f$\leq\f$ 0</em>.  Section 3.4.8 in the SBML Level 2
Version 4  and SBML Level&nbsp;3 Version&nbsp;1 Core specifications provides information about the interpretation of
assignments, rules, and entity values for simulation time up to and
including the start time <em>t = 0</em>; this is important for
establishing the initial conditions of a simulation if the model
involves expressions containing the <em>delay</em> "csymbol".
There cannot be two initial assignments for the same symbol in a model;
that is, a model must not contain two or more InitialAssignment objects
that both have the same identifier as their "symbol" attribute value.  A
model must also not define initial assignments <em>and</em> assignment
rules for the same entity.  That is, there cannot be <em>both</em> an
InitialAssignment and an AssignmentRule for the same symbol in a model,
because both kinds of constructs apply prior to and at the start of
simulated time&mdash;allowing both to exist for a given symbol would
result in indeterminism).
The ordering of InitialAssignment objects is not significant.  The
combined set of InitialAssignment, AssignmentRule and KineticLaw
objects form a set of assignment statements that must be considered as a
whole.  The combined set of assignment statements should not contain
algebraic loops: a chain of dependency between these statements should
terminate.  (More formally, consider the directed graph of assignment
statements where nodes are a model's assignment statements and directed
arcs exist for each occurrence of a symbol in an assignment statement
"math" attribute.  The directed arcs in this graph start from the
statement assigning the symbol and end at the statement that contains
the symbol in their math elements.  Such a graph must be acyclic.)
Finally, it is worth being explicit about the expected behavior in the
following situation.  Suppose (1) a given symbol has a value <em>x</em>
assigned to it in its definition, and (2) there is an initial assignment
having the identifier as its "symbol" value and reassigning the value to
<em>y</em>, <em>and</em> (3) the identifier is also used in the
mathematical formula of a second initial assignment.  What value should
the second initial assignment use?  It is <em>y</em>, the value assigned
to the symbol by the first initial assignment, not whatever value was
given in the symbol's definition.  This follows directly from the
behavior described above: if an InitialAssignment object exists for a
given symbol, then the symbol's value is overridden by that initial
assignment.

<!---------------------------------------------------------------------- -->

=over


=back

=head2 ListOfInitialAssignments

LibSBML implementation of SBML's ListOfInitialAssignments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this InitialAssignment
@param version an unsigned int, the SBML Version to assign to this
InitialAssignment

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a InitialAssignment object to an
SBMLDocument (e.g., using Model::addInitialAssignment(@if java InitialAssignment ia@endif)), the SBML
Level, SBML Version and XML namespace of the document @em
override the values used when creating the InitialAssignment object
via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a InitialAssignment is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item InitialAssignment::InitialAssignment

Creates a new InitialAssignment using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a InitialAssignment object to an
SBMLDocument (e.g., using Model::addInitialAssignment(@if java InitialAssignment ia@endif)), the SBML XML
namespace of the document I<overrides> the value used when creating
the InitialAssignment object via this constructor.  This is necessary
to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a InitialAssignment is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item InitialAssignment::InitialAssignment

Copy constructor; creates a copy of this InitialAssignment.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item InitialAssignment::accept

Accepts the given SBMLVisitor for this instance of InitialAssignment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next InitialAssignment in
the list of compartment types.


=item InitialAssignment::clone

Creates and returns a deep copy of this InitialAssignment.
Returns a (deep) copy of this InitialAssignment.


=item InitialAssignment::getSymbol

Get the value of the "symbol" attribute of this InitialAssignment.
Returns the identifier string stored as the "symbol" attribute value
in this InitialAssignment.


=item InitialAssignment::getMath

Get the mathematical formula of this InitialAssignment.
Returns an ASTNode, the value of the "math" subelement of this
InitialAssignment


=item InitialAssignment::isSetSymbol

Predicate returning C<true> if this
InitialAssignment's "symbol" attribute is set.
Returns C<true> if the "symbol" attribute of this InitialAssignment
is set, C<false> otherwise.


=item InitialAssignment::isSetMath

Predicate returning C<true> if this
InitialAssignment's "math" subelement contains a value.
Returns C<true> if the "math" for this InitialAssignment is set,
C<false> otherwise.


=item InitialAssignment::setSymbol

Sets the "symbol" attribute value of this InitialAssignment.
@param sid the identifier of a Species, Compartment or Parameter
object defined elsewhere in this Model.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item InitialAssignment::setMath

Sets the "math" subelement of this InitialAssignment.
The AST passed in C<math> is copied.
@param math an AST containing the mathematical expression to
be used as the formula for this InitialAssignment.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink


=item InitialAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
InitialAssignment.

The units are calculated based on the mathematical expression in the
InitialAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
InitialAssignment contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
only returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java InitialAssignment::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers
may wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this InitialAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item InitialAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
InitialAssignment.

The units are calculated based on the mathematical expression in the
InitialAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
InitialAssignment contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
only returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java InitialAssignment::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers
may wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this InitialAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item InitialAssignment::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this InitialAssignment contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this InitialAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item InitialAssignment::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this InitialAssignment contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this InitialAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java InitialAssignment::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item InitialAssignment::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item InitialAssignment::getElementName

Returns the XML element name of this object, which for
InitialAssignment, is always C<"initialAssignment">.
Returns the name of this element, i.e., C<"initialAssignment">.


=item InitialAssignment::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item InitialAssignment::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this InitialAssignment object
have been set.
@note The required attributes for an InitialAssignment object are:
@li "symbol"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item InitialAssignment::hasRequiredElements

Predicate returning C<true> if
all the required elements for this InitialAssignment object
have been set.
@note The required elements for a InitialAssignment object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item InitialAssignment::getId

Predicate returning C<true> if
all the required elements for this InitialAssignment object
have been set.
@note The required elements for a InitialAssignment object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item InitialAssignment::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item InitialAssignment::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item InitialAssignment::replaceSIDWithFunction

@internal

Replace all nodes with the name 'id' from the child 'math' object with the provided function.


=item InitialAssignment::divideAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing/function).


=item InitialAssignment::multiplyAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing function).


=item InitialAssignment::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item InitialAssignment::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item InitialAssignment::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item InitialAssignment::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item InitialAssignment::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item InitialAssignment::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfInitialAssignments::ListOfInitialAssignments

Creates a new ListOfInitialAssignments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfInitialAssignments::ListOfInitialAssignments

Creates a new ListOfInitialAssignments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfInitialAssignments object to be created.


=item ListOfInitialAssignments::clone

Creates and returns a deep copy of this ListOfInitialAssignments instance.
Returns a (deep) copy of this ListOfInitialAssignments.


=item ListOfInitialAssignments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfInitialAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., InitialAssignment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfInitialAssignments::getElementName

Returns the XML element name of this object.
For ListOfInitialAssignments, the XML element name is @c
"listOfInitialAssignments".

Returns the name of this element, i.e., C<"listOfInitialAssignments">.


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
Returns the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments.
@param n the index number of the InitialAssignment to get.
Returns the nth InitialAssignment in this ListOfInitialAssignments.
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
Returns InitialAssignment in this ListOfInitialAssignments
with the given id or C<NULL> if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::get

Get a InitialAssignment from the ListOfInitialAssignments
based on its identifier.
@param sid a string representing the identifier 
of the InitialAssignment to get.
Returns InitialAssignment in this ListOfInitialAssignments
with the given id or C<NULL> if no such
InitialAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfInitialAssignments::remove

Removes the nth item from this ListOfInitialAssignments items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfInitialAssignments::remove

Removes item in this ListOfInitialAssignments items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfInitialAssignments::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.  Note that InitialAssignments do not actually have IDs, though the libsbml interface pretends that they do:  no initial assignment is returned by this function.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item ListOfInitialAssignments::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the
ListOfInitialAssignments in a model is (in SBML Level 2 Version 4)
the eighth ListOf___.  (However, it differs for different Levels and
Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfInitialAssignments::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 Rule

LibSBML implementation of SBML's Rule construct.
In SBML, I<rules> provide additional ways to define the values of
variables in a model, their relationships, and the dynamical behaviors
of those variables.  They enable encoding relationships that cannot be
expressed using Reaction nor InitialAssignment objects alone.
The libSBML implementation of rules mirrors the SBML Level&nbsp;3
Version&nbsp;1 Core definition (which is in turn is very similar to the
Level&nbsp;2 Version&nbsp;4 definition), with Rule being the parent
class of three subclasses as explained below.  The Rule class itself
cannot be instantiated by user programs and has no constructor; only the
subclasses AssignmentRule, AlgebraicRule and RateRule can be
instantiated directly.
@section general General summary of SBML rules
@htmlinclude rules-general-summary.html
@section additional-restrictions Additional restrictions on SBML rules
@htmlinclude rules-additional-restrictions.html
@section RuleType_t Rule types for SBML Level 1
SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration of 3 values.  LibSBML supports this using methods
that work @if clike a libSBML enumeration type, RuleType_t, whose values
are @else with the enumeration values @endif@~ listed below.
@li @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink: Indicates
the rule is a "rate" rule.
@li @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink:
Indicates the rule is a "scalar" rule.
@li @link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink:
Indicates the rule type is unknown or not yet set.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfRules

LibSBML implementation of SBML's ListOfRules construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;3 and later versions
of SBML Level&nbsp;2 as well):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Rule::Rule

Copy constructor; creates a copy of this Rule.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Rule::accept

Accepts the given SBMLVisitor for this instance of Rule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Rule object in the
list of rules within which I<the> present object is embedded.


=item Rule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item Rule::getFormula

Returns the mathematical expression of this Rule in text-string form.
The text string is produced by
@if java <code><a href="libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)">libsbml.formulaToString()</a></code>@else SBML_formulaToString()@endif; please consult
the documentation for that function to find out more about the format
of the text-string formula.
Returns the formula text string for this Rule.
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see getMath()


=item Rule::getMath

Get the mathematical formula of this Rule as an ASTNode tree.
Returns an ASTNode, the value of the "math" subelement of this Rule.
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see getFormula()


=item Rule::getVariable

Get the value of the "variable" attribute of this Rule object.
In SBML Level&nbsp;1, the different rule types each have a different
name for the attribute holding the reference to the object
constituting the left-hand side of the rule.  (E.g., for
SBML Level&nbsp;1's SpeciesConcentrationRule the attribute is "species", for
CompartmentVolumeRule it is "compartment", etc.)  In SBML
Levels&nbsp;2 and&nbsp;3, the only two types of Rule objects with a
left-hand side object reference are AssignmentRule and RateRule, and
both of them use the same name for attribute: "variable".  In order to
make it easier for application developers to work with all Levels of
SBML, libSBML uses a uniform name for all of such attributes, and it
is "variable", regardless of whether Level&nbsp;1 rules or
Level&nbsp;2&ndash;3 rules are being used.
Returns the identifier string stored as the "variable" attribute value
in this Rule, or C<NULL> if this object is an AlgebraicRule object.


=item Rule::getUnits

Returns the units for the
mathematical formula of this Rule.
Returns the identifier of the units for the expression of this Rule.
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::isSetFormula

Predicate returning C<true> if this
Rule's mathematical expression is set.
This method is equivalent to isSetMath().  This version is present for
easier compatibility with SBML Level&nbsp;1, in which mathematical
formulas were written in text-string form.
Returns C<true> if the mathematical formula for this Rule is
set, C<false> otherwise.
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see isSetMath()


=item Rule::isSetMath

Predicate returning C<true> if this
Rule's mathematical expression is set.
This method is equivalent to isSetFormula().
Returns C<true> if the formula (or equivalently the math) for this
Rule is set, C<false> otherwise.
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see isSetFormula()


=item Rule::isSetVariable

Predicate returning C<true> if this
Rule's "variable" attribute is set.
In SBML Level&nbsp;1, the different rule types each have a different
name for the attribute holding the reference to the object
constituting the left-hand side of the rule.  (E.g., for
SBML Level&nbsp;1's SpeciesConcentrationRule the attribute is "species", for
CompartmentVolumeRule it is "compartment", etc.)  In SBML
Levels&nbsp;2 and&nbsp;3, the only two types of Rule objects with a
left-hand side object reference are AssignmentRule and RateRule, and
both of them use the same name for attribute: "variable".  In order to
make it easier for application developers to work with all Levels of
SBML, libSBML uses a uniform name for all such attributes, and it is
"variable", regardless of whether Level&nbsp;1 rules or
Level&nbsp;2&ndash;3 rules are being used.
Returns C<true> if the "variable" attribute value of this Rule is
set, C<false> otherwise.


=item Rule::isSetUnits

Predicate returning C<true>
if this Rule's "units" attribute is set.
Returns C<true> if the units for this Rule is set, C<false>
otherwise

@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::setFormula

Sets the "math" subelement of this Rule to an expression in
text-string form.
This is equivalent to setMath(const ASTNode  math).  The provision of
using text-string formulas is retained for easier SBML Level&nbsp;1
compatibility.  The formula is converted to an ASTNode internally.
@param formula a mathematical formula in text-string form.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@note The attribute "formula" is specific to SBML Level&nbsp;1; in
higher Levels of SBML, it has been replaced with a subelement named
"math".  However, libSBML provides a unified interface to the
underlying math expression and this method can be used for models
of all Levels of SBML.
@see setMath(const ASTNode  math)


=item Rule::setMath

Sets the "math" subelement of this Rule to a copy of the given
ASTNode.

@param math the ASTNode structure of the mathematical formula.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@note The subelement "math" is present in SBML Levels&nbsp;2
and&nbsp;3.  In SBML Level&nbsp;1, the equivalent construct is the
attribute named "formula".  LibSBML provides a unified interface to
the underlying math expression and this method can be used for models
of all Levels of SBML.
@see setFormula(const std::string& formula)


=item Rule::setVariable

Sets the "variable" attribute value of this Rule object.
In SBML Level&nbsp;1, the different rule types each have a different
name for the attribute holding the reference to the object
constituting the left-hand side of the rule.  (E.g., for
SBML Level&nbsp;1's SpeciesConcentrationRule the attribute is "species", for
CompartmentVolumeRule it is "compartment", etc.)  In SBML
Levels&nbsp;2 and&nbsp;3, the only two types of Rule objects with a
left-hand side object reference are AssignmentRule and RateRule, and
both of them use the same name for attribute: "variable".  In order to
make it easier for application developers to work with all Levels of
SBML, libSBML uses a uniform name for all such attributes, and it is
"variable", regardless of whether Level&nbsp;1 rules or
Level&nbsp;2&ndash;3 rules are being used.
@param sid the identifier of a Compartment, Species or Parameter
elsewhere in the enclosing Model object.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Rule::setUnits

Sets the units for this Rule.
@param sname the identifier of the units
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::unsetUnits

Unsets the "units" for this Rule.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attribute "units" exists on SBML Level&nbsp;1 ParameterRule
objects only.  It is not present in SBML Levels&nbsp;2 and&nbsp;3.


=item Rule::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this Rule.
The units are calculated based on the mathematical expression in the
Rule and the model quantities referenced by C<&lt;ci&gt;>
elements used within that expression.  The getDerivedUnitDefinition()
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the Rule
contains pure numbers or parameters with undeclared units.  In those
cases, it is not possible to calculate the units of the overall
expression without making assumptions.  LibSBML does not make
assumptions about the units, and getDerivedUnitDefinition() only
returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java Rule::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers may
wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this Rule, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Rule::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the "math" expression of this Rule.
The units are calculated based on the mathematical expression in the
Rule and the model quantities referenced by C<&lt;ci&gt;>
elements used within that expression.  The getDerivedUnitDefinition()
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the Rule
contains pure numbers or parameters with undeclared units.  In those
cases, it is not possible to calculate the units of the overall
expression without making assumptions.  LibSBML does not make
assumptions about the units, and getDerivedUnitDefinition() only
returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java Rule::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers
may wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this Rule, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item Rule::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this Rule contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this Rule
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item Rule::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this Rule contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this Rule
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.
@see getDerivedUnitDefinition()


=item Rule::getType

Get the type of rule this is.
Returns the rule type (a value drawn from the enumeration <a
class="el" href="#RuleType_t">RuleType_t</a>) of this Rule.  The value
will be either @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink
or @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink.
@note The attribute "type" on Rule objects is present only in SBML
Level&nbsp;1.  In SBML Level&nbsp;2 and later, the type has been
replaced by subclassing the Rule object.


=item Rule::isAlgebraic

Predicate returning C<true> if this
Rule is an AlgebraicRule.
Returns C<true> if this Rule is an AlgebraicRule, C<false> otherwise.


=item Rule::isAssignment

Predicate returning C<true> if this
Rule is an AssignmentRule.
Returns C<true> if this Rule is an AssignmentRule, C<false> otherwise.


=item Rule::isCompartmentVolume

Predicate returning C<true> if this Rule is an CompartmentVolumeRule
or equivalent.
This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit CompartmentVolumeRule), as well as other Levels of
SBML.  For Levels above Level&nbsp;1, this method checks the symbol
being affected by the rule, and returns C<true> if the symbol is the
identifier of a Compartment object defined in the model.
Returns C<true> if this Rule is a CompartmentVolumeRule, C<false>
otherwise.


=item Rule::isParameter

Predicate returning C<true> if this Rule is an ParameterRule or
equivalent.

This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit ParameterRule), as well as other Levels of
SBML.  For Levels above Level&nbsp;1, this method checks the symbol
being affected by the rule, and returns C<true> if the symbol is the
identifier of a Parameter object defined in the model.
Returns C<true> if this Rule is a ParameterRule, C<false>
otherwise.


=item Rule::isRate

Predicate returning C<true> if this Rule
is a RateRule (SBML Levels&nbsp;2&ndash;3) or has a "type" attribute
value of C<"rate"> (SBML Level&nbsp;1).
Returns C<true> if this Rule is a RateRule (Level&nbsp;2) or has
type "rate" (Level&nbsp;1), C<false> otherwise.


=item Rule::isScalar

Predicate returning C<true> if this Rule
is an AssignmentRule (SBML Levels&nbsp;2&ndash;3) or has a "type"
attribute value of C<"scalar"> (SBML Level&nbsp;1).
Returns C<true> if this Rule is an AssignmentRule (Level&nbsp;2) or has
type "scalar" (Level&nbsp;1), C<false> otherwise.


=item Rule::isSpeciesConcentration

Predicate returning C<true> if this Rule is a
SpeciesConcentrationRule or equivalent.
This libSBML method works for SBML Level&nbsp;1 models (where there is
such a thing as an explicit SpeciesConcentrationRule), as well as
other Levels of SBML.  For Levels above Level&nbsp;1, this method
checks the symbol being affected by the rule, and returns C<true> if
the symbol is the identifier of a Species object defined in the model.
Returns C<true> if this Rule is a SpeciesConcentrationRule, C<false>
otherwise.


=item Rule::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Rule::getL1TypeCode

Returns the SBML Level&nbsp;1 type code for this Rule object.
This method only applies to SBML Level&nbsp;1 model objects.  If this
is not an SBML Level&nbsp;1 rule object, this method will return @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink.
Returns the SBML Level&nbsp;1 type code for this Rule (namely, @link
SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE
SBML_COMPARTMENT_VOLUME_RULE@endlink, @link
SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, @link
SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE
SBML_SPECIES_CONCENTRATION_RULE@endlink, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink).


=item Rule::getElementName

Returns the XML element name of this object
The returned value can be any of a number of different strings,
depending on the SBML Level in use and the kind of Rule object this
is.  The rules as of libSBML version @htmlinclude libsbml-version.html
are the following:

=over


=item

(Level&nbsp;2 and&nbsp;3) RateRule: returns C<"rateRule">

=item

(Level&nbsp;2 and&nbsp;3) AssignmentRule: returns C<"assignmentRule"> 

=item

(Level&nbsp;2 and&nbsp;3) AlgebraicRule: returns C<"algebraicRule">

=item

(Level&nbsp;1 Version&nbsp;1) SpecieConcentrationRule: returns C<"specieConcentrationRule">

=item

(Level&nbsp;1 Version&nbsp;2) SpeciesConcentrationRule: returns C<"speciesConcentrationRule">

=item

(Level&nbsp;1) CompartmentVolumeRule: returns C<"compartmentVolumeRule">

=item

(Level&nbsp;1) ParameterRule: returns C<"parameterRule">

=item

Unknown rule type: returns C<"unknownRule">

=back


Beware that the last (C<"unknownRule">) is not a valid SBML element
name.

Returns the name of this element


=item Rule::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Rule::setL1TypeCode

Sets the SBML Level&nbsp;1 type code for this Rule.
@param type the SBML Level&nbsp;1 type code for this Rule. The
allowable values are @link SBMLTypeCode_t#SBML_COMPARTMENT_VOLUME_RULE
SBML_COMPARTMENT_VOLUME_RULE@endlink, @link
SBMLTypeCode_t#SBML_PARAMETER_RULE SBML_PARAMETER_RULE@endlink, and
@link SBMLTypeCode_t#SBML_SPECIES_CONCENTRATION_RULE
SBML_SPECIES_CONCENTRATION_RULE@endlink.

Returns integer value indicating success/failure of the
function.  The possible values returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
if given C<type> value is not one of the above.


=item Rule::hasRequiredElements

Predicate returning C<true> if all the
required elements for this Rule object have been set.
The only required element for a Rule object is the "math" subelement.
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Rule::hasRequiredAttributes

Predicate returning C<true> if all the
required attributes for this Rule object have been set.
The required attributes for a Rule object depend on the type of Rule
it is.  For AssignmentRule and RateRule objects (and SBML
Level&nbsp1's SpeciesConcentrationRule, CompartmentVolumeRule, and
ParameterRule objects), the required attribute is "variable"; for
AlgebraicRule objects, there is no required attribute.
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Rule::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Rule::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Rule::getInternalId

@internal

Renames all the UnitSIdRef attributes on this element


=item Rule::setInternalId

@internal

Renames all the UnitSIdRef attributes on this element


=item Rule::getId

Renames all the UnitSIdRef attributes on this element


=item Rule::replaceSIDWithFunction

@internal

Replace all nodes with the name 'id' from the child 'math' object with the provided function.


=item Rule::divideAssignmentsToSIdByFunction

@internal

If this rule assigns a value or a change to the 'id' element, replace the 'math' object with the function (existing/function).


=item Rule::multiplyAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing function).


=item Rule::Rule

@internal

Only subclasses may create Rules.


=item Rule::Rule

@internal

Only subclasses may create Rules.


=item Rule::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item Rule::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Rule::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Rule::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Rule::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Rule::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Rule::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfRules::ListOfRules

Creates a new ListOfRules object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfRules::ListOfRules

Creates a new ListOfRules object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfRules object to be created.


=item ListOfRules::clone

Creates and returns a deep copy of this ListOfRules instance.
Returns a (deep) copy of this ListOfRules.


=item ListOfRules::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfRules::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Rule objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfRules::getElementName

Returns the XML element name of this object.
For ListOfRules, the XML element name is C<"listOfRules">.
Returns the name of this element, i.e., C<"listOfRules">.


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
Returns the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules.
@param n the index number of the Rule to get.
Returns the nth Rule in this ListOfRules.
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules
based on its identifier.
@param sid a string representing the identifier 
of the Rule to get.
Returns Rule in this ListOfRules
with the given id or C<NULL> if no such
Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::get

Get a Rule from the ListOfRules
based on its identifier.
@param sid a string representing the identifier 
of the Rule to get.
Returns Rule in this ListOfRules
with the given id or C<NULL> if no such
Rule exists.
@see get(unsigned int n)
@see size()


=item ListOfRules::remove

Removes the nth item from this ListOfRules items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfRules::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.  Note that AssignmentRules and RateRules do not actually have IDs, but the libsbml interface pretends that they do:  no assignment rule or rate rule is returned by this function.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item ListOfRules::remove

Removes item in this ListOfRules items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfRules::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfRules::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item ListOfRules::isValidTypeForList

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 AlgebraicRule

LibSBML implementation of SBML's AlgebraicRule construct.
The rule type AlgebraicRule is derived from the parent class Rule.  It
is used to express equations that are neither assignments of model
variables nor rates of change.  AlgebraicRule does not add any
attributes to the basic Rule; its role is simply to distinguish this
case from the other cases.
In the context of a simulation, algebraic rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the delay "csymbol" (see the SBML
specification), algebraic rules are considered to apply also at
<em>t</em> \f$\leq\f$ <em>0</em>.  Please consult the relevant SBML
specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
An SBML model must not be overdetermined.  The ability to define
arbitrary algebraic expressions in an SBML model introduces the
possibility that a model is mathematically overdetermined by the overall
system of equations constructed from its rules, reactions and events.
Therefore, if an algebraic rule is introduced in a model, for at least
one of the entities referenced in the rule's "math" element the value of
that entity must not be completely determined by other constructs in the
model.  This means that at least this entity must not have the attribute
"constant"=C<true> and there must also not be a rate rule or assignment
rule for it.  Furthermore, if the entity is a Species object, its value
must not be determined by reactions, which means that it must either
have the attribute "boundaryCondition"=C<true> or else not be involved
in any reaction at all.  These restrictions are explained in more detail
in the SBML specification documents.
In SBML Levels 2 and&nbsp;3, Reaction object identifiers can be
referenced in the "math" expression of an algebraic rule, but reaction
rates can never be <em>determined</em> by algebraic rules.  This is true
even when a reaction does not contain a KineticLaw element.  (In such
cases of missing KineticLaw elements, the model is valid but incomplete;
the rates of reactions lacking kinetic laws are simply undefined, and
not determined by the algebraic rule.)
@section general General summary of SBML rules
@htmlinclude rules-general-summary.html
@section additional-restrictions Additional restrictions on SBML rules
@htmlinclude rules-additional-restrictions.html
@section RuleType_t Rule types for SBML Level 1
SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration of 3 values.  LibSBML supports this using methods
that work @if clike a libSBML enumeration type, RuleType_t, whose values
are @else with the enumeration values @endif@~ listed below.
@li @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink: Indicates
the rule is a "rate" rule.
@li @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink:
Indicates the rule is a "scalar" rule.
@li @link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink:
Indicates the rule type is unknown or not yet set.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule using the given SBML C<level> and C<version
>
values.
    
@param level an unsigned int, the SBML Level to assign to this AlgebraicRule
@param version an unsigned int, the SBML Version to assign to this
AlgebraicRule
    
@throws @if python ValueError @else SBMLConstructorException @endif
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of an AlgebraicRule object to an SBMLDocument
(e.g., using&nbsp; @if java Model::addRule(Rule r)@else Model::addRule()@endif), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the AlgebraicRule object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a AlgebraicRule is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item AlgebraicRule::AlgebraicRule

Creates a new AlgebraicRule using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a AlgebraicRule object to an SBMLDocument
(e.g., using&nbsp; @if java Model::addRule(Rule r)@else Model::addRule()@endif, the SBML XML namespace of the
document I<overrides> the value used when creating the AlgebraicRule
object via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a AlgebraicRule is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item AlgebraicRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item AlgebraicRule::accept

Accepts the given SBMLVisitor for this instance of AlgebraicRule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next AlgebraicRule object
in the list of rules within which I<the> present object is embedded.


=item AlgebraicRule::setInternalIdOnly

@internal
  
sets the mInternalIdOnly flag


=item AlgebraicRule::getInternalIdOnly

@internal
  
sets the mInternalIdOnly flag


=item AlgebraicRule::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this AlgebraicRule object
have been set.
@note In SBML Levels&nbsp;2&ndash;3, there is no required attribute
for an AlgebraicRule object.  For Level&nbsp;1, the only required
attribute is "formula".
Returns C<true> if the required attributes have been set, C<false
>
otherwise.


=back

=head2 AssignmentRule

LibSBML implementation of SBML's AssignmentRule construct.
The rule type AssignmentRule is derived from the parent class Rule.  It
is used to express equations that set the values of variables.  The
left-hand side (the attribute named "variable") of an assignment rule
can refer to the identifier of a Species, SpeciesReference (in SBML
Level&nbsp;3), Compartment, or Parameter object in the model (but not a
Reaction).  The entity identified must have its "constant" attribute set
to C<false>.  The effects of an AssignmentRule are in general terms the
same, but differ in the precise details depending on the type of
variable being set: 
=over


=item

<em>In the case of a species</em>, an AssignmentRule sets the
referenced species' quantity (whether a "concentration" or "amount") to
the value determined by the formula in the MathML subelement "math".
The unit associated with the value produced by the "math" formula I<
>
should (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or I<must> (in
SBML releases prior to Level&nbsp;2 version&nbsp;4) be equal to the unit
associated with the species' quantity.  <em>Restrictions</em>: There
must not be both an AssignmentRule "variable" attribute and a
SpeciesReference "species" attribute having the same value, unless the
referenced Species object has its "boundaryCondition" attribute set to
C<true>.  In other words, an assignment rule cannot be defined for a
species that is created or destroyed in a reaction unless that species
is defined as a boundary condition in the model.

=item

(For SBML Level&nbsp;3 only) <em>In the case of a species
reference</em>, an AssignmentRule sets the stoichiometry of the
referenced reactant or product to the value determined by the formula in
"math".  The unit associated with the value produced by the "math"
formula should be consistent with the unit "dimensionless", because
reactant and product stoichiometries in reactions are dimensionless
quantities.
   

=item

<em>In the case of a compartment</em>, an AssignmentRule sets the
referenced compartment's size to the value determined by the formula in
the "math" subelement of the AssignmentRule object.  The overall units
of the formula in "math" I<should> (in SBML Level&nbsp;2 Version&nbsp;4
and in SBML Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the same as the units of the size of the compartment.

=item

<em>In the case of a parameter</em>, an AssignmentRule sets the
referenced parameter's value to that determined by the formula in the
"math" subelement of the AssignmentRule object.  The overall units of
the formula in the "math" subelement I<should> (in SBML Level&nbsp;2
Version&nbsp;4 and in SBML Level&nbsp;3) or I<must> (in SBML releases prior to
Level&nbsp;2 version&nbsp;4) be the same as the units defined for the
parameter.  
=back

In the context of a simulation, assignment rules are in effect at all
times, <em>t</em> \f$\geq\f$ <em>0</em>.  For purposes of evaluating
expressions that involve the <em>delay</em> "csymbol" (see the SBML
Level&nbsp;2 specification), assignment rules are considered to apply
also at <em>t</em> \f$\leq\f$ <em>0</em>.  Please consult the relevant
SBML specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
A model must not contain more than one AssignmentRule or RateRule
object having the same value of "variable"; in other words, in the set
of all assignment rules and rate rules in an SBML model, each variable
appearing in the left-hand sides can only appear once.  This simply
follows from the fact that an indeterminate system would result if a
model contained more than one assignment rule for the same variable or
both an assignment rule and a rate rule for the same variable.
Similarly, a model must also not contain <em>both</em> an AssignmentRule
and an InitialAssignment for the same variable, because both kinds of
constructs apply prior to and at the start of simulation time, i.e.,
<em>t</em> \f$\leq\f$ <em>0</em>.  If a model contained both an initial
assignment and an assignment rule for the same variable, an
indeterminate system would result.
The value calculated by an AssignmentRule object overrides the value
assigned to the given symbol by the object defining that symbol.  For
example, if a Compartment object's "size" attribute value is set in its
definition, and the model also contains an AssignmentRule object having
that compartment's "id" as its "variable" value, then the "size"
assigned in the Compartment object definition is ignored and the value
assigned based on the computation defined in the AssignmentRule.  This
does <em>not</em> mean that a definition for a given symbol can be
omitted if there is an AssignmentRule object for it.  For example, there
must be a Parameter definition for a given parameter if there is an
AssignmentRule for that parameter.  It is only a question of which value
definition takes precedence.
@section general General summary of SBML rules
@htmlinclude rules-general-summary.html
@section additional-restrictions Additional restrictions on SBML rules
@htmlinclude rules-additional-restrictions.html
@section RuleType_t Rule types for SBML Level 1
SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration of 3 values.  LibSBML supports this using methods
that work @if clike a libSBML enumeration type, RuleType_t, whose values
are @else with the enumeration values @endif@~ listed below.
@li @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink: Indicates
the rule is a "rate" rule.
@li @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink:
Indicates the rule is a "scalar" rule.
@li @link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink:
Indicates the rule type is unknown or not yet set.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule using the given SBML C<level> and C<version
>
values.
    
@param level an unsigned int, the SBML Level to assign to this AssignmentRule
@param version an unsigned int, the SBML Version to assign to this
AssignmentRule
    
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of an AssignmentRule object to an SBMLDocument
(e.g., using&nbsp; @if java Model::addRule(Rule r)@else Model::addRule()@endif, the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the AssignmentRule object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a AssignmentRule is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item AssignmentRule::AssignmentRule

Creates a new AssignmentRule using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a AssignmentRule object to an SBMLDocument
(e.g., using&nbsp; @if java Model::addRule(Rule r)@else Model::addRule()@endif, the SBML XML namespace of
the document I<overrides> the value used when creating the
AssignmentRule object via this constructor.  This is necessary to
ensure that an SBML document is a consistent structure.  Nevertheless,
the ability to supply the values at the time of creation of a
AssignmentRule is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item AssignmentRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item AssignmentRule::accept

Accepts the given SBMLVisitor for this instance of AssignmentRule.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next AssignmentRule object
in the list of rules within which I<the> present object is embedded.


=item AssignmentRule::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this AssignmentRule object
have been set.
@note In SBML Levels&nbsp;2&ndash;3, the only required attribute for
an AssignmentRule object is "variable".  For Level&nbsp;1, where the
equivalent attribute is known by different names ("compartment",
"species", or "name", depending on the type of object), there is an
additional required attribute called "formula".
Returns C<true> if the required attributes have been set, C<false
>
otherwise.


=item AssignmentRule::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=back

=head2 RateRule

LibSBML implementation of SBML's RateRule construct.
The rule type RateRule is derived from the parent class Rule.  It is
used to express equations that determine the rates of change of
variables.  The left-hand side (the "variable" attribute) can refer to
the identifier of a species, compartment, or parameter (but not a
reaction).  The entity identified must have its "constant" attribute set
to C<false>.  The effects of a RateRule are in general terms the same,
but differ in the precise details depending on which variable is being
set:
   

=over
 
=item

<em>In the case of a species</em>, a RateRule sets the rate of
change of the species' quantity (<em>concentration</em> or <em>amount of
substance</em>) to the value determined by the formula in the "math"
subelement of the RateRule object.  The overall units of the formula in
"math" I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3) or I<
>
must (in SBML releases prior to Level&nbsp;2 version&nbsp;4) be equal to
the unit of <em>species quantity</em> divided by the model-wide unit of
<em>time</em>.  <em>Restrictions</em>: There must not be both a RateRule
"variable" attribute and a SpeciesReference "species" attribute having
the same value, unless that species has its "boundaryCondition"
attribute is set to C<true>.  This means a rate rule cannot be defined
for a species that is created or destroyed in a reaction, unless that
species is defined as a boundary condition in the model.

=item

(For SBML Level&nbsp;3 only) <em>In the case of a species
reference</em>, a RateRule sets the rate of change of the stoichiometry
of the referenced reactant or product to the value determined by the
formula in "math".  The unit associated with the value produced by the
"math" formula should be consistent with the unit "dimensionless"
divided by the model-wide unit of <em>time</em>.

=item

<em>In the case of a compartment</em>, a RateRule sets the rate of
change of the compartment's size to the value determined by the formula
in the "math" subelement of the RateRule object.  The overall units of
the formula I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML
Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the units of the compartment's <em>size</em> divided
by the model-wide unit of <em>time</em>.

=item

<em>In the case of a parameter</em>, a RateRule sets the rate of
change of the parameter's value to that determined by the formula in the
"math" subelement of the RateRule object.  The overall units of the
formula I<should> (in SBML Level&nbsp;2 Version&nbsp;4 and in SBML
Level&nbsp;3) or I<must> (in SBML releases prior to Level&nbsp;2
version&nbsp;4) be the Parameter object's "unit" attribute value divided
by the model-wide unit of <em>time</em>.  
=back

In the context of a simulation, rate rules are in effect for simulation
time <em>t</em> &lt; <em>0</em>.  Please consult the relevant SBML
specification for additional information about the semantics of
assignments, rules, and entity values for simulation time <em>t</em>
\f$\leq\f$ <em>0</em>.
As mentioned in the description of AssignmentRule, a model must not
contain more than one RateRule or AssignmentRule object having the same
value of "variable"; in other words, in the set of all assignment rules
and rate rules in an SBML model, each variable appearing in the
left-hand sides can only appear once.  This simply follows from the fact
that an indeterminate system would result if a model contained more than
one assignment rule for the same variable or both an assignment rule and
a rate rule for the same variable.
@section general General summary of SBML rules
@htmlinclude rules-general-summary.html
@section additional-restrictions Additional restrictions on SBML rules
@htmlinclude rules-additional-restrictions.html
@section RuleType_t Rule types for SBML Level 1
SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration of 3 values.  LibSBML supports this using methods
that work @if clike a libSBML enumeration type, RuleType_t, whose values
are @else with the enumeration values @endif@~ listed below.
@li @link RuleType_t#RULE_TYPE_RATE RULE_TYPE_RATE@endlink: Indicates
the rule is a "rate" rule.
@li @link RuleType_t#RULE_TYPE_SCALAR RULE_TYPE_SCALAR@endlink:
Indicates the rule is a "scalar" rule.
@li @link RuleType_t#RULE_TYPE_INVALID RULE_TYPE_INVALID@endlink:
Indicates the rule type is unknown or not yet set.
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=item RateRule::RateRule

Creates a new RateRule using the given SBML C<level> and C<version
>
values.
    
@param level an unsigned int, the SBML Level to assign to this RateRule
@param version an unsigned int, the SBML Version to assign to this
RateRule
    
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a RateRule object to an SBMLDocument
(e.g., using&nbsp; @if java Model::addRule(Rule r)@else Model::addRule()@endif, the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the RateRule object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a RateRule is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item RateRule::RateRule

Creates a new RateRule using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a RateRule object to an SBMLDocument (e.g.,
using @if java Model::addRule(Rule r)@else Model::addRule()@endif, the SBML XML namespace of the document
I<overrides> the value used when creating the RateRule object via
this constructor.  This is necessary to ensure that an SBML document
is a consistent structure.  Nevertheless, the ability to supply the
values at the time of creation of a RateRule is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item RateRule::clone

Creates and returns a deep copy of this Rule.
Returns a (deep) copy of this Rule.


=item RateRule::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next RateRule object
in the list of rules within which I<the> present object is embedded.


=item RateRule::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this RateRule object
have been set.
@note In SBML Levels&nbsp;2&ndash;3, the only required attribute for a
RateRule object is "variable".  For Level&nbsp;1, where the equivalent
attribute is known by different names ("compartment", "species", or
"name", depending on the type of object), there is an additional
required attribute called "formula".
Returns C<true> if the required attributes have been set, C<false
>
otherwise.


=item RateRule::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=back

=head2 Constraint

LibSBML implementation of SBML's Constraint construct.
The Constraint object class was introduced in SBML Level&nbsp;2
Version&nbsp;2 as a mechanism for stating the assumptions under which a
model is designed to operate.  The <em>constraints</em> are statements
about permissible values of different quantities in a model.
Constraints are not used to compute dynamical values for simulation or
analysis, but rather, they serve an advisory role for
simulation/analysis tools.
SBML's Constraint object class has one required attribute, "id", to
give the parameter a unique identifier by which other parts of an SBML
model definition can refer to it.  A Constraint object can also have an
optional "name" attribute of type C<string>.  Identifiers and names must
be used according to the guidelines described in the SBML specification
(e.g., Section 3.3 in the Level&nbsp;2 Version 4 specification).  
Constraint has one required subelement, "math", containing a MathML
formula defining the condition of the constraint.  This formula must
return a boolean value of C<true> when the model is a <em>valid</em>
state.  The formula can be an arbitrary expression referencing the
variables and other entities in an SBML model.  The evaluation of "math"
and behavior of constraints are described in more detail below.
A Constraint structure also has an optional subelement called "message".
This can contain a message in XHTML format that may be displayed to the
user when the condition of the formula in the "math" subelement
evaluates to a value of C<false>.  Software tools are not required to
display the message, but it is recommended that they do so as a matter
of best practice.  The XHTML content within a "message" subelement must
follow the same restrictions as for the "notes" element on SBase
described in in the SBML Level&nbsp;2 specification; please consult the
<a target="_blank" href="http://sbml.org/Documents/Specifications">SBML
specification document</a> corresponding to the SBML Level and Version
of your model for more information about the requirements for "notes"
content.

Constraint was introduced in SBML Level&nbsp;2 Version&nbsp;2.  It is
not available in earlier versions of Level&nbsp;2 nor in any version of
Level&nbsp;1.

@section constraint-semantics Semantics of Constraints
In the context of a simulation, a Constraint has effect at all times
<em>t \f$\geq\f$ 0</em>.  Each Constraint's "math" subelement is first
evaluated after any InitialAssignment definitions in a model at <em>t =
0</em> and can conceivably trigger at that point.  (In other words, a
simulation could fail a constraint immediately.)
Constraint structures <em>cannot and should not</em> be used to compute
the dynamical behavior of a model as part of, for example, simulation.
Constraints may be used as input to non-dynamical analysis, for instance
by expressing flux constraints for flux balance analysis.
The results of a simulation of a model containing a constraint are
invalid from any simulation time at and after a point when the function
given by the "math" subelement returns a value of C<false>.  Invalid
simulation results do not make a prediction of the behavior of the
biochemical reaction network represented by the model.  The precise
behavior of simulation tools is left undefined with respect to
constraints.  If invalid results are detected with respect to a given
constraint, the "message" subelement may optionally be displayed to the
user.  The simulation tool may also halt the simulation or clearly
delimit in output data the simulation time point at which the simulation
results become invalid.
SBML does not impose restrictions on duplicate Constraint definitions or
the order of evaluation of Constraint objects in a model.  It is
possible for a model to define multiple constraints all with the same
mathematical expression.  Since the failure of any constraint indicates
that the model simulation has entered an invalid state, a system is not
required to attempt to detect whether other constraints in the model
have failed once any one constraint has failed.
<!---------------------------------------------------------------------- -->

=over


=back

=head2 ListOfConstraints

LibSBML implementation of SBML's ListOfConstraints construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Constraint::Constraint

Creates a new Constraint using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Constraint
@param version an unsigned int, the SBML Version to assign to this
Constraint

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Constraint object to an SBMLDocument
(e.g., using Model::addConstraint(@if java Constraint c@endif)), the
SBML Level, SBML Version and XML namespace of the document @em
override the values used when creating the Constraint object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a Constraint is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Constraint::Constraint

Creates a new Constraint using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Constraint object to an SBMLDocument
(e.g., using Model::addConstraint(@if java Constraint c@endif)), the
SBML XML namespace of the document I<overrides> the value used when
creating the Constraint object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a Constraint is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item Constraint::Constraint

Copy constructor; creates a copy of this Constraint.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Constraint::accept

Accepts the given SBMLVisitor for this instance of Constraint.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Constraint in the
list of constraints within which this Constraint is embedded (i.e., in
the ListOfConstraints located in the enclosing Model instance).


=item Constraint::clone

Creates and returns a deep copy of this Constraint.
Returns a (deep) copy of this Constraint.


=item Constraint::getMessage

Get the message, if any, associated with this Constraint
Returns the message for this Constraint, as an XMLNode.


=item Constraint::getMessageString

Get the message string, if any, associated with this Constraint
Returns the message for this Constraint, as a string.


=item Constraint::getMath

Get the mathematical expression of this Constraint
Returns the math for this Constraint, as an ASTNode.


=item Constraint::isSetMessage

Predicate returning C<true> if a
message is defined for this Constraint.
Returns C<true> if the message of this Constraint is set,
C<false> otherwise.


=item Constraint::isSetMath

Predicate returning C<true> if a
mathematical formula is defined for this Constraint.
Returns C<true> if the "math" subelement for this Constraint is
set, C<false> otherwise.


=item Constraint::setMessage

Sets the message of this Constraint.
The XMLNode tree passed in C<xhtml> is copied.
@param xhtml an XML tree containing XHTML content.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink


=item Constraint::setMath

Sets the mathematical expression of this Constraint to a copy of the
AST given as C<math>.
@param math an ASTNode expression to be assigned as the "math"
subelement of this Constraint
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink


=item Constraint::unsetMessage

Unsets the "message" subelement of this Constraint.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Constraint::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Constraint::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item Constraint::replaceSIDWithFunction

@internal

Replace all nodes with the name 'id' from the child 'math' object with the provided function.


=item Constraint::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Constraint::getElementName

Returns the XML element name of this object, which for Constraint, is
always C<"constraint">.
Returns the name of this element, i.e., C<"constraint">.


=item Constraint::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Constraint::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Constraint object
have been set.
@note The required elements for a Constraint object are:
@li 'math'
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item Constraint::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item Constraint::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Constraint::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Constraint::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Constraint::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Constraint::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfConstraints::ListOfConstraints

Creates a new ListOfConstraints object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfConstraints::ListOfConstraints

Creates a new ListOfConstraints object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfConstraints object to be created.


=item ListOfConstraints::clone

Creates and returns a deep copy of this ListOfConstraints instance.
Returns a (deep) copy of this ListOfConstraints.


=item ListOfConstraints::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfConstraints::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Constraint objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfConstraints::getElementName

Returns the XML element name of this object.
For ListOfConstraints, the XML element name is C<"listOfConstraints">.
Returns the name of this element, i.e., C<"listOfConstraints">.


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
Returns the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::get

Get a Constraint from the ListOfConstraints.
@param n the index number of the Constraint to get.
Returns the nth Constraint in this ListOfConstraints.
@see size()


=item ListOfConstraints::remove

Removes the nth item from this ListOfConstraints items and returns a
pointer to it.
The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfConstraints::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfConstraints
in a model is (in SBML Level&nbsp;2 Version 4) the tenth ListOf___.
(However, it differs for different Levels and Versions of SBML.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfConstraints::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 Reaction

LibSBML implementation of SBML's Reaction construct.
A I<reaction> represents any transformation, transport or binding
process, typically a chemical reaction, that can change the quantity of
one or more species.  In SBML, a reaction is defined primarily in terms
of the participating reactants and products (and their corresponding
stoichiometries), along with optional modifier species, an optional rate
at which the reaction takes place, and optional parameters.  
As with other major object in SBML, Reaction has a mandatory attribute,
"id", used to give the compartment type an identifier.  The identifier
must be a text string conforming to the identifer syntax permitted in
SBML.  In SBML Level&nbsp;2 and Level&nbsp;3, the reaction "id"
identifier can be used in mathematical formulas elsewhere in an SBML
model to represent the rate of that reaction; this usage is explained
below.  Reaction also has an optional "name" attribute, of type @c
string.  The "id" and "name" must be used according to the guidelines
described in the SBML specification.
The species participating as reactants, products, and/or modifiers in a
reaction are declared using lists of SpeciesReference and/or
ModifierSpeciesReference instances stored in subelements
"listOfReactants", "listOfProducts" and "listOfModifiers".  Certain
restrictions are placed on the appearance of species in reaction
definitions:

=over


=item

The ability of a species to appear as a reactant or product of any
reaction in a model is governed by certain flags in that species'
definition; see the definition of Species for more information.

=item

Any species appearing in the mathematical formula of the subelement
"kineticLaw" (described below) of a Reaction must be declared in at
least one of that Reaction's lists of reactants, products, and/or
modifiers.  Put another way, it is an error for a reaction's kinetic law
formula to refer to species that have not been declared for that
reaction.


=item

A reaction definition can contain an empty list of reactants
<em>or</em> an empty list of products, but it must have at least one
reactant or product; in other words, a reaction without any reactant or
product species is not permitted.  (This restriction does not apply to
modifier species, which remain optional in all cases.)

=back


A reaction can contain up to one KineticLaw object in a subelement named
"kineticLaw".  It defines the speed at which the process defined by the
reaction takes place.  The description of KineticLaw provides more
details about its use.  Note that although the inclusion of a KineticLaw
object in an instance of a Reaction component is optional, there is no
useful default that can be substituted in place of a missing rate
expression in a reaction.  Moreover, a reaction's rate cannot be defined
in any other way in SBML&mdash;InitialAssignment, AssignmentRule,
RateRule, AlgebraicRule, Event, and other constructs in SBML cannot be
used to set the reaction rate separately.  Nevertheless, for some
modeling applications, reactions without any defined rate can be
perfectly acceptable.
Reaction also has a boolean attribute named "reversible" for indicating
whether the reaction is reversible.  This attribute is optional in SBML
Level&nbsp;2, with a default of C<true>; it is mandatory in SBML
Level&nbsp;3 (with no default value).  To say that a reaction is @em
reversible is to say it can proceed in either the forward or the reverse
direction.  Although the reversibility of a reaction can sometimes be
deduced by inspecting its rate expression, this is not always the case,
especially for complicated expressions.  Moreover, the need in SBML to
allow rate expressions (i.e., KineticLaw) to be optional leads to the
need for a separate flag indicating reversibility.  Note that labeling a
reaction as irreversible is an assertion that the reaction always
proceeds in the given forward direction.  (Why else would it be flagged
as irreversible?)  This implies the rate expression in the KineticLaw
always has a non-negative value during simulations.  Software tools
could provide a means of optionally testing that this condition holds.
The presence of reversibility information in two places (i.e., the rate
expression and the "reversible" attribute on Reaction) leaves open the
possibility that a model could contain contradictory information, but
the creation of such a model would be an error on the part of the
software generating it.
The Reaction object class has another boolean attribute called "fast".
This attribute is optional in SBML Level&nbsp;2, with a default of @c
false; it is mandatory in SBML Level&nbsp;3 (with no default value).  It
is used to indicate that a reaction occurs on a vastly faster time scale
than others in a system.  Readers are directed to the SBML Level&nbsp;2
Version&nbsp;4 specification, which provides more detail about the
conditions under which a reaction can be considered to be fast in this
sense.  The attribute's default value is C<false>.  SBML Level&nbsp;1
and Level&nbsp;2 Version&nbsp;1 incorrectly claimed that software tools
could ignore this attribute if they did not implement support for the
corresponding concept; however, further research in SBML has revealed
that this is not true, and "fast" <em>cannot be ignored</em> if it is
set to C<true>.  SBML Level&nbsp;2 Versions&nbsp;2&ndash;4 therefore
stipulate that if a model has any reactions with "fast" set to C<true>,
a software tool must be able to respect the attribute or else indicate
to the user that it does not have the capacity to do so.  Analysis
software cannot ignore the value of the "fast" attribute because doing
so may lead to different results as compared to a software system that
<em>does</em> make use of "fast".
In SBML Level&nbsp;3 Version&nbsp;1, the Reaction object has an
additional optional attribute named "compartment", whose value must be
the identifier of a compartment defined in the enclosing Model object.
The "compartment" attribute can be used to indicate the compartment in
which the reaction is assumed to take place.  If the attribute is
present, its value must be the identifier of a Compartment object
defined in the enclosing Model object.  Similar to the "reversible"
attribute, the value of the "compartment" attribute has no direct impact
on the construction of mathematical equations for the SBML model.  When
a kinetic law is given for a reaction, the compartment location may
already be implicit in the kinetic law (although this cannot always be
guaranteed).  Nevertheless, software tools may find the "compartment"
attribute value useful for such purposes as analyzing the structure of
the model, guiding the modeler in constructing correct rate formulas,
and visualization purposes.
Readers are urged to read the SBML specification for more details about
the proper use of Reaction.

=over


=back

=head2 ListOfReactions

LibSBML implementation of SBML's ListOfReactions construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Reaction::Reaction

Creates a new Reaction using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Reaction
@param version an unsigned int, the SBML Version to assign to this
Reaction

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Reaction object to an SBMLDocument (e.g.,
using Model::addReaction(@if java Reaction r@endif)), the SBML Level, SBML Version and
XML namespace of the document I<override> the values used when
creating the Reaction object via this constructor.  This is necessary
to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a Reaction is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item Reaction::Reaction

Creates a new Reaction using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a Reaction object to an SBMLDocument (e.g.,
using Model::addReaction(@if java Reaction r@endif)), the SBML XML namespace of the document
I<overrides> the value used when creating the Reaction object via
this constructor.  This is necessary to ensure that an SBML document
is a consistent structure.  Nevertheless, the ability to supply the
values at the time of creation of a Reaction is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Reaction::Reaction

Copy constructor; creates a copy of this Reaction.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Reaction::accept

Accepts the given SBMLVisitor for this instance of Reaction.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item Reaction::clone

Creates and returns a deep copy of this Reaction.
Returns a (deep) copy of this Reaction.


=item Reaction::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find.
Returns pointer to the first element found with the given id.


=item Reaction::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item Reaction::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item Reaction::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item Reaction::initDefaults

Initializes the fields of this Reaction object to "typical" default
values.

The SBML Reaction component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:

=over


=item

Sets the "reversible" attribute to C<true>

=item

Sets the "fast" attribute to C<false>

=item

Marks the "fast" attribute as I<not> having been set

=back


@warning The "fast" attribute must be used with care.  SBML
definitions before SBML Level&nbsp;2 Version&nbsp;2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  Beginning with
SBML Level&nbsp;2 Versions&nbsp;2, the SBML specifications therefore
stipulate that if a model has any reactions with "fast" set to @c
true, a software tool must be able to respect the attribute or else
indicate to the user that it does not have the capacity to do so.
Readers are directed to the SBML specifications, which provides more
detail about the conditions under which a reaction can be considered
to be fast in this sense.


=item Reaction::getId

Returns the value of the "id" attribute of this Reaction.
Returns the id of this Reaction.


=item Reaction::getName

Returns the value of the "name" attribute of this Reaction.
Returns the name of this Reaction.


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
Returns the KineticLaw instance.


=item Reaction::getKineticLaw

Returns the KineticLaw object contained in this Reaction.
Returns the KineticLaw instance.


=item Reaction::getReversible

Returns the value of the "reversible" attribute on the Reaction as a
boolean value.
Returns the reversibility status of this Reaction.


=item Reaction::getFast

Returns the value of the "fast" attribute of this Reaction.
Returns the "fast" status of this Reaction.
@warning SBML definitions before SBML Level&nbsp;2 Version&nbsp;2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level&nbsp;2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level&nbsp;2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.


=item Reaction::getCompartment

(SBML Level&nbsp;3 only) Returns the value of the "compartment"
attribute on the Reaction.
Returns the compartment of this Reaction.
@note The "compartment" attribute is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present on Reaction in lower Levels of
SBML.


=item Reaction::isSetId

Predicate returning C<true> if this
Reaction's "id" attribute is set.
Returns C<true> if the "id" attribute of this Reaction is
set, C<false> otherwise.


=item Reaction::isSetName

Predicate returning C<true> if this
Reaction's "name" attribute is set.
Returns C<true> if the "name" attribute of this Reaction is
set, C<false> otherwise.


=item Reaction::isSetKineticLaw

Predicate returning C<true> if this
Reaction contains a kinetic law object.
Returns C<true> if a KineticLaw is present in this Reaction,, C<false>
otherwise.


=item Reaction::isSetFast

Predicate returning C<true> if the value of
the "fast" attribute on this Reaction.
Returns C<true> if the "fast" attribute is true, C<false> otherwise.
@warning SBML definitions before SBML Level&nbsp;2 Version&nbsp;2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level&nbsp;2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level&nbsp;2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.  Note
also that in SBML Level&nbsp;1, "fast" is defined as optional with a
default of C<false>, which means it is effectively always set.


=item Reaction::isSetCompartment

Predicate returning C<true> if this
Reaction's "compartment" attribute is set.
Returns C<true> if the "compartment" attribute of this Reaction is
set, C<false> otherwise.
@note The "compartment" attribute is available in SBML
Level&nbsp;3 Version&nbsp;1 Core, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::isSetReversible

Predicate returning C<true> if this
Reaction's "reversible" attribute is set.
Returns C<true> if the "reversible" attribute of this Reaction is
set, C<false> otherwise.


=item Reaction::setId

Sets the value of the "id" attribute of this Reaction.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Reaction
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Reaction::setName

Sets the value of the "name" attribute of this Reaction.
The string in C<name> is copied.
@param name the new name for the Reaction
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Reaction::setKineticLaw

Sets the "kineticLaw" subelement of this Reaction to a copy of the
given KineticLaw object.
@param kl the KineticLaw object to use.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink


=item Reaction::setReversible

Sets the value of the "reversible" attribute of this Reaction.
@param value the value of the "reversible" attribute.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item Reaction::setFast

Sets the value of the "fast" attribute of this Reaction.
@param value the value of the "fast" attribute.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@warning SBML definitions before SBML Level&nbsp;2 Version&nbsp;2 incorrectly
indicated that software tools could ignore this attribute if they did
not implement support for the corresponding concept; however, further
research in SBML has revealed that this is not true, and "fast"
<em>cannot be ignored</em> if it is set to C<true>.  SBML Level&nbsp;2
Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
with "fast" set to C<true>, a software tool must be able to respect
the attribute or else indicate to the user that it does not have the
capacity to do so.  Readers are directed to the SBML Level&nbsp;2 Version
4 specification, which provides more detail about the conditions under
which a reaction can be considered to be fast in this sense.


=item Reaction::setCompartment

Sets the value of the "compartment" attribute of this Reaction.
The string C<sid> is copied.  
@param sid the string to use as the compartment of this Reaction
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@note The "compartment" attribute is available in SBML
Level&nbsp;3 Version&nbsp;1 Core, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::unsetName

Unsets the value of the "name" attribute of this Reaction.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Reaction::unsetKineticLaw

Unsets the "kineticLaw" subelement of this Reaction.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Reaction::unsetFast

Unsets the value of the "fast" attribute of this Reaction.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@warning In SBML Level&nbsp;1, "fast" is optional with a default of @c
false, which means it is effectively always set (and reset to C<false>
if this method is called).  Further, SBML definitions before SBML
Level&nbsp;2 Version&nbsp;2 incorrectly indicated that software tools could
ignore this attribute if they did not implement support for the
corresponding concept; however, further research in SBML has revealed
that this is not true, and "fast" <em>cannot be ignored</em> if it is
set to C<true>.  SBML Level&nbsp;2 Versions 2, 3 and 4 therefore stipulate
that if a model has any reactions with "fast" set to C<true>, a
software tool must be able to respect the attribute or else indicate
to the user that it does not have the capacity to do so.  Readers are
directed to the SBML Level&nbsp;2 Version&nbsp;4 specification, which provides
more detail about the conditions under which a reaction can be
considered to be fast in this sense.


=item Reaction::unsetCompartment

Unsets the value of the "compartment" attribute of this Reaction.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The "compartment" attribute is available in SBML
Level&nbsp;3 Version&nbsp;1 Core, but is not present on Reaction in
lower Levels of SBML.


=item Reaction::addReactant

Adds a given SpeciesReference object as a reactant in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createReactant()
for a method that does not lead to these issues.
@see createReactant()


=item Reaction::addProduct

Adds a given SpeciesReference object as a product in this Reaction.
The SpeciesReference instance in C<sr> is copied.
@param sr a SpeciesReference object referring to a Species in the
enclosing Model
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createProduct()
for a method that does not lead to these issues.
@see createProduct()


=item Reaction::addModifier

Adds a given ModifierSpeciesReference object as a product in this
Reaction.

The ModifierSpeciesReference instance in C<msr> is copied.
@param msr a ModifierSpeciesReference object referring to a Species in
the enclosing Model
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Reaction.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Reaction</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see Reaction::createModifier()
for a method that does not lead to these issues.
@see createModifier()


=item Reaction::createReactant

Creates a new SpeciesReference, adds it to this Reaction's list of
reactants, and returns it.
Returns a new SpeciesReference object.


=item Reaction::createProduct

Creates a new SpeciesReference, adds it to this Reaction's list of
products, and returns it.
Returns a new SpeciesReference object.


=item Reaction::createModifier

Creates a new ModifierSpeciesReference, adds it to this Reaction's
list of modifiers and returns it.
Returns a new ModifierSpeciesReference object.


=item Reaction::createKineticLaw

Creates a new KineticLaw object, installs it as this Reaction's
"kineticLaw" subelement, and returns it.
If this Reaction had a previous KineticLaw, it will be destroyed.
Returns the new KineticLaw object


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction


=item Reaction::getListOfReactants

Returns the list of reactants in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as reactants in this reaction


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction


=item Reaction::getListOfProducts

Returns the list of products in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as products in this reaction


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction


=item Reaction::getListOfModifiers

Returns the list of modifiers in this Reaction object.
Returns the ListOfSpeciesReferences containing the references to the
species acting as modifiers in this reaction


=item Reaction::getReactant

Returns the nth reactant species (as a SpeciesReference object) in 
the list of reactants in this Reaction.
Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
Returns the nth reactant (as a SpeciesReference object) of this
Reaction.


=item Reaction::getReactant

Returns the nth reactant species (as a SpeciesReference object) 
in the list of reactants in this Reaction.
Callers should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant sought.
Returns the nth reactant (as a SpeciesReference object) of this
Reaction.


=item Reaction::getReactant

Returns the reactant species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the reactant Species ("species" 
attribute of the reactant SpeciesReference object)
Returns a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getReactant

Returns the reactant species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the reactant Species ("species" 
attribute of the reactant SpeciesReference object)
Returns a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a reactant in this Reaction.


=item Reaction::getProduct

Returns the nth product species (as a SpeciesReference object) in 
the list of products in this Reaction.
Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
Returns the nth product (as a SpeciesReference object) of this
Reaction.


=item Reaction::getProduct

Returns the nth product species (as a SpeciesReference object) 
in the list of products in this Reaction.
Callers should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product sought.
Returns the nth product (as a SpeciesReference object) of this
Reaction.


=item Reaction::getProduct

Returns the product species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the product Species ("species"
attribute of the product SpeciesReference object)
Returns a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getProduct

Returns the product species (as a SpeciesReference object) having 
a specific identifier in this Reaction.
@param species the identifier of the product Species ("species"
attribute of the product SpeciesReference object)
Returns a SpeciesReference object, or C<NULL> if no species with the
given identifier C<species> appears as a product in this Reaction.


=item Reaction::getModifier

Returns the nth modifier species (as a ModifierSpeciesReference object) 
in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought
Returns the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the nth modifier species (as a ModifierSpeciesReference object) 
in the list of modifiers of this Reaction.
Callers should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the modifier species sought
Returns the nth modifier (as a ModifierSpeciesReference object) of
this Reaction.


=item Reaction::getModifier

Returns the modifier species (as a ModifierSpeciesReference object) 
having a specific identifier in this Reaction.
@param species the identifier of the modifier Species ("species" 
attribute of the ModifierSpeciesReference object)
Returns a ModifierSpeciesReference object, or C<NULL> if no species with
the given identifier C<species> appears as a modifier in this
Reaction.


=item Reaction::getModifier

Returns the modifier species (as a ModifierSpeciesReference object) 
having a specific identifier in this Reaction.
@param species the identifier of the modifier Species ("species" 
attribute of the ModifierSpeciesReference object)
Returns a ModifierSpeciesReference object, or C<NULL> if no species with
the given identifier C<species> appears as a modifier in this
Reaction.


=item Reaction::getNumReactants

Returns the number of reactant species in this Reaction.
Returns the number of reactants in this Reaction.


=item Reaction::getNumProducts

Returns the number of product species in this Reaction.
Returns the number of products in this Reaction.


=item Reaction::getNumModifiers

Returns the number of modifier species in this Reaction.
Returns the number of modifiers in this Reaction.


=item Reaction::removeReactant

Removes the nth reactant species (SpeciesReference object) in the list of 
reactants in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumReactants() to find out how many
reactants there are, to avoid using an invalid index number.
@param n the index of the reactant SpeciesReference object to remove
Returns the removed reactant SpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeReactant

Removes the reactant species (SpeciesReference object) having the given  
"species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the reactant SpeciesReference 
object

Returns the removed reactant SpeciesReference object, or C<NULL> if no 
reactant SpeciesReference object with the given "species" attribute 
C<species> exists in this Reaction.


=item Reaction::removeProduct

Removes the nth product species (SpeciesReference object) in the list of 
products in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumProducts() to find out how many
products there are, to avoid using an invalid index number.
@param n the index of the product SpeciesReference object to remove
Returns the removed product SpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeProduct

Removes the product species (SpeciesReference object) having the given  
"species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the product SpeciesReference 
object

Returns the removed product SpeciesReference object, or C<NULL> if no 
product SpeciesReference object with the given "species" attribute 
C<species> exists in this Reaction.


=item Reaction::removeModifier

Removes the nth modifier species (ModifierSpeciesReference object) in 
the list of  modifiers in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
The caller should first call getNumModifiers() to find out how many
modifiers there are, to avoid using an invalid index number.
@param n the index of the ModifierSpeciesReference object to remove
Returns the removed ModifierSpeciesReference object, or C<NULL> if the 
given index is out of range.


=item Reaction::removeModifier

Removes the modifier species (ModifierSpeciesReference object) having 
the given "species" attribute in this Reaction and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param species the "species" attribute of the ModifierSpeciesReference 
object

Returns the removed ModifierSpeciesReference object, or C<NULL> if no 
ModifierSpeciesReference object with the given "species" attribute @p 
species exists in this Reaction.


=item Reaction::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.


=item Reaction::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item Reaction::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item Reaction::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Reaction::getElementName

Returns the XML element name of this object, which for Reaction, is
always C<"reaction">.
Returns the name of this element, i.e., C<"reaction">.


=item Reaction::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Reaction::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
Reaction object have been set.
@note The required attributes for a Reaction object are:
@li "id" (or "name" in SBML Level&nbsp;1)
@li "fast" (in Level&nbsp;3 only, where it is defined as a required attribute)
@li "reversible" (in Level&nbsp;3 only, where it is defined as a required attribute)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item Reaction::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item Reaction::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Reaction::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Reaction::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Reaction::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Reaction::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Reaction::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Reaction::isExplicitlySetReversible

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Reaction::isExplicitlySetFast

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfReactions::ListOfReactions

Creates a new ListOfReactions object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfReactions::ListOfReactions

Creates a new ListOfReactions object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfReactions object to be created.


=item ListOfReactions::clone

Creates and returns a deep copy of this ListOfReactions instance.
Returns a (deep) copy of this ListOfReactions.


=item ListOfReactions::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfReactions::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Reaction objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfReactions::getElementName

Returns the XML element name of this object
For ListOfReactions, the XML element name is C<"listOfReactions">.
Returns the name of this element, i.e., C<"listOfReactions">.


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
Returns the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions.
@param n the index number of the Reaction to get.
Returns the nth Reaction in this ListOfReactions.
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions
based on its identifier.
@param sid a string representing the identifier 
of the Reaction to get.
Returns Reaction in this ListOfReactions
with the given id or C<NULL> if no such
Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::get

Get a Reaction from the ListOfReactions
based on its identifier.
@param sid a string representing the identifier 
of the Reaction to get.
Returns Reaction in this ListOfReactions
with the given id or C<NULL> if no such
Reaction exists.
@see get(unsigned int n)
@see size()


=item ListOfReactions::remove

Removes the nth item from this ListOfReactions items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfReactions::remove

Removes item in this ListOfReactions items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
C<NULL> is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfReactions::getElementPosition

@internal

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.


=item ListOfReactions::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 KineticLaw

LibSBML implementation of SBML's KineticLaw construct.
An object of class KineticLaw is used to describe the rate at which the
process defined by a given Reaction takes place.  KineticLaw has
subelements called "math" (for MathML content) and "listOfParameters"
(of class ListOfParameters), in addition to the attributes and
subelements it inherits from SBase.
KineticLaw's "math" subelement for holding a MathML formula defines the
rate of the reaction.  The formula may refer to other entities in a
model as well as local parameter definitions within the scope of the
Reaction (see below).  It is important to keep in mind, however, that
the only Species identifiers that can be used in this formula are those
declared in the lists of reactants, products and modifiers in the
Reaction structure.  (In other words, before a species can be referenced
in the KineticLaw, it must be declared in one of those lists.)
KineticLaw provides a way to define I<local> parameters whose
identifiers can be used in the "math" formula of that KineticLaw
instance.  Prior to SBML Level&nbsp;3, these parameter definitions are
stored inside a "listOfParameters" subelement containing Parameter
objects; in SBML Level&nbsp;3, this is achieved using a specialized
object class called LocalParameter and the containing subelement is
called "listOfLocalParameters".  In both cases, the parameters so
defined are only visible within the KineticLaw; they cannot be accessed
outside.  A local parameter within one reaction is not visible from
within another reaction, nor is it visible to any other construct
outside of the KineticLaw in which it is defined.  In addition, another
important feature is that if such a Parameter (or in Level&nbsp;3,
LocalParameter) object has the same identifier as another object in the
scope of the enclosing Model, the definition inside the KineticLaw takes
precedence.  In other words, within the KineticLaw's "math" formula,
references to local parameter identifiers <strong>shadow any identical
global identifiers</strong>.
The values of local parameters defined within KineticLaw objects cannot
change.  In SBML Level&nbsp;3, this quality is built into the
LocalParameter construct.  In Level&nbsp;2, where the same kind of
Parameter object class is used as for global parameters, the Parameter
objects' "constant" attribute must always have a value of C<true>
(either explicitly or left to its default value).
@section shadowing-warning A warning about identifier shadowing
A common misconception is that different classes of objects (e.g.,
species, compartments, parameters) in SBML have different identifier
scopes.  They do not.  The implication is that if a KineticLaw's local
parameter definition uses an identifier identical to I<any> other
identifier defined in the model outside the KineticLaw, even if the
other identifier does I<not> belong to a parameter type of object, the
local parameter's identifier takes precedence within that KineticLaw's
"math" formula.  It is not an error in SBML for identifiers to shadow
each other this way, but can lead to confusing and subtle errors.
@section version-diffs SBML Level/Version differences
In SBML Level&nbsp;2 Version&nbsp;1, the SBML specification
included two additional attributes on KineticLaw called "substanceUnits"
and "timeUnits".  They were removed beginning with SBML Level&nbsp;2
Version&nbsp;2 because further research determined they introduced many
problems.  The most significant problem was that their use could easily
lead to the creation of valid models whose reactions nevertheless could
not be integrated into a system of equations without outside knowledge
for converting the quantities used.  Examination of real-life models
revealed that a common reason for using "substanceUnits" on KineticLaw
was to set the units of all reactions to the same set of substance
units, something that is better achieved by using UnitDefinition to
redefine C<"substance"> for the whole Model.
As mentioned above, in SBML Level&nbsp;2 Versions 2&ndash;4, local
parameters are of class Parameter.  In SBML Level&nbsp;3, the class of
object is LocalParameter.

=over


=item KineticLaw::KineticLaw

Creates a new KineticLaw using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this KineticLaw
@param version an unsigned int, the SBML Version to assign to this
KineticLaw

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a KineticLaw object to an SBMLDocument
(e.g., using Reaction::setKineticLaw(@if java KineticLaw kl@endif)), the SBML Level, SBML Version
and XML namespace of the document I<override> the values used
when creating the KineticLaw object via this constructor.  This is
necessary to ensure that an SBML document is a consistent structure.
Nevertheless, the ability to supply the values at the time of creation
of a KineticLaw is an important aid to producing valid SBML.  Knowledge
of the intented SBML Level and Version determine whether it is valid
to assign a particular value to an attribute, or whether it is valid
to add an object to an existing SBMLDocument.


=item KineticLaw::KineticLaw

Creates a new KineticLaw using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a KineticLaw object to an SBMLDocument
(e.g., using Reaction::setKineticLaw(@if java KineticLaw kl@endif)), the SBML XML namespace of the
document I<overrides> the value used when creating the KineticLaw
object via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a KineticLaw is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item KineticLaw::KineticLaw

Copy constructor; creates a copy of this KineticLaw.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item KineticLaw::accept

Accepts the given SBMLVisitor for this instance of KineticLaw.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item KineticLaw::clone

Creates and returns a deep copy of this KineticLaw object.
Returns a (deep) copy of this KineticLaw.


=item KineticLaw::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find.
Returns pointer to the first element found with the given id.


=item KineticLaw::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item KineticLaw::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth
Returns a List  of pointers to all children objects.


=item KineticLaw::getFormula

Returns the mathematical formula for this KineticLaw object and return
it as as a text string.
This is fundamentally equivalent to
@if java KineticLaw::getMath()@else getMath()@endif.
This variant is provided principally for compatibility compatibility
with SBML Level&nbsp;1.
Returns a string representing the formula of this KineticLaw.
@note @htmlinclude level-1-uses-text-string-math.html
@see getMath()


=item KineticLaw::getMath

Returns the mathematical formula for this KineticLaw object and return
it as as an AST.
This is fundamentally equivalent to
@if java KineticLaw::getFormula()@else getFormula()@endif.
The latter is provided principally for compatibility compatibility
with SBML Level&nbsp;1, which represented mathematical formulas in
text-string form.
Returns the ASTNode representation of the mathematical formula.
@see getFormula()


=item KineticLaw::getTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
"timeUnits" attribute of this KineticLaw object.
Returns the "timeUnits" attribute value.
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::getSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
"substanceUnits" attribute of this KineticLaw object.
Returns the "substanceUnits" attribute value.
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::isSetFormula

Predicate returning C<true> if this
KineticLaw's "formula" attribute is set.
This is functionally identical to the method
@if java KineticLaw::isSetMath()@else isSetMath()@endif.  It is
provided in order to mirror the parallel between
@if java KineticLaw::getFormula()@else getFormula()@endif@~ and
@if java KineticLaw::getMath()@else getMath()@endif.
Returns C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw is set, C<false> otherwise.
@note @htmlinclude level-1-uses-text-string-math.html
@see isSetMath()


=item KineticLaw::isSetMath

Predicate returning C<true> if this
Kinetic's "math" subelement is set.
This is identical to the method
@if java KineticLaw::isSetFormula()@else isSetFormula()@endif.
It is provided in order to mirror the parallel between
@if java KineticLaw::getFormula()@else getFormula()@endif@~ and
@if java KineticLaw::getMath()@else getMath()@endif.
Returns C<true> if the formula (meaning the C<math> subelement) of
this KineticLaw is set, C<false> otherwise.
@see isSetFormula()


=item KineticLaw::isSetTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning C<true> if
this SpeciesReference's "timeUnits" attribute is set.
Returns C<true> if the "timeUnits" attribute of this KineticLaw object
is set, C<false> otherwise.
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::isSetSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning C<true> if
this SpeciesReference's "substanceUnits" attribute is set.
Returns C<true> if the "substanceUnits" attribute of this KineticLaw
object is set, C<false> otherwise.
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::setFormula

Sets the mathematical expression of this KineticLaw instance to the
given C<formula>.
The given C<formula> string is copied.  Internally, libSBML stores the
mathematical expression as an ASTNode.
@param formula the mathematical expression to use, represented in
text-string form.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@note @htmlinclude level-1-uses-text-string-math.html
@see setMath(const ASTNode  math)


=item KineticLaw::setMath

Sets the mathematical expression of this KineticLaw instance to a copy
of the given ASTNode.
This is fundamentally identical to
@if java KineticLaw::setFormula(String formula)@else getFormula()@endif.
The latter is provided principally for compatibility compatibility with
SBML Level&nbsp;1, which represented mathematical formulas in text-string
form.

@param math an ASTNode representing a formula tree.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@see setFormula(const std::string& formula)


=item KineticLaw::setTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Sets the "timeUnits" attribute
of this KineticLaw object to a copy of the identifier in C<sid>.
@param sid the identifier of the units to use.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::setSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Sets the "substanceUnits"
attribute of this KineticLaw object to a copy of the identifier given
in C<sid>.
@param sid the identifier of the units to use.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::unsetTimeUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the "timeUnits"
attribugte of this KineticLaw object.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::unsetSubstanceUnits

(SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the "substanceUnits"
attribute of this KineticLaw object.
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The attributes "timeUnits" and "substanceUnits" are present only
in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
Version&nbsp;2, the "timeUnits" and "substanceUnits" attributes were
removed.  For compatibility with new versions of SBML, users are
cautioned to avoid these attributes.


=item KineticLaw::addParameter

Adds a copy of the given Parameter object to the list of local
parameters in this KineticLaw.
@param p the Parameter to add
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this KineticLaw.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the KineticLaw</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see
@if java KineticLaw::createParameter()@else createParameter()@endif@~
for a method that does not lead to these issues.
@see createParameter()


=item KineticLaw::addLocalParameter

Adds a copy of the given LocalParameter object to the list of local
parameters in this KineticLaw.
@param p the LocalParameter to add
Returns integer value indicating success/failure of the
function. The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this KineticLaw.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the KineticLaw</em>.  In addition, the caller should make
sure to free the original object if it is no longer being used, or
else a memory leak will result.  Please see
@if java KineticLaw::createParameter()@else createParameter()@endif@~
for a method that does not lead to these issues.
@see createLocalParameter()


=item KineticLaw::createParameter

Creates a new Parameter object, adds it to this KineticLaw's list of
local parameters, and returns the Parameter object created.
Returns a new Parameter object instance
@see addParameter(const Parameter  p)


=item KineticLaw::createLocalParameter

Creates a new LocalParameter object, adds it to this KineticLaw's list
of local parameters, and returns the LocalParameter object created.
Returns a new LocalParameter object instance
@see addLocalParameter(const LocalParameter  p)


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of Parameters for this KineticLaw.


=item KineticLaw::getListOfParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of Parameters for this KineticLaw.


=item KineticLaw::getListOfLocalParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of LocalParameters for this KineticLaw.


=item KineticLaw::getListOfLocalParameters

Returns the list of local parameters in this KineticLaw object.
Returns the list of LocalParameters for this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought
Returns the nth Parameter of this KineticLaw.


=item KineticLaw::getParameter

Returns the nth Parameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the Parameter object sought
Returns the nth Parameter of this KineticLaw.


=item KineticLaw::getLocalParameter

Returns the nth LocalParameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the LocalParameter object sought
Returns the nth LocalParameter of this KineticLaw.


=item KineticLaw::getLocalParameter

Returns the nth LocalParameter object in the list of local parameters in
this KineticLaw instance.
@param n the index of the LocalParameter object sought
Returns the nth LocalParameter of this KineticLaw.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
Returns the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the Parameter being sought.
Returns the Parameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such Parameter exists.


=item KineticLaw::getLocalParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the LocalParameter being sought.
Returns the LocalParameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such LocalParameter exists.


=item KineticLaw::getLocalParameter

Returns a local parameter based on its identifier.
@param sid the identifier of the LocalParameter being sought.
Returns the LocalParameter object in this KineticLaw instace having the
given "id", or C<NULL> if no such LocalParameter exists.


=item KineticLaw::getNumParameters

Returns the number of local parameters in this KineticLaw instance.
Returns the number of Parameters in this KineticLaw.


=item KineticLaw::getNumLocalParameters

Returns the number of local parameters in this KineticLaw instance.
Returns the number of LocalParameters in this KineticLaw.


=item KineticLaw::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
KineticLaw.

The units are calculated based on the mathematical expression in the
KineticLaw and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
KineticLaw contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
only returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java KineticLaw::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers may
wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this KineticLaw, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item KineticLaw::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
KineticLaw.

The units are calculated based on the mathematical expression in the
KineticLaw and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
method returns the calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
KineticLaw contains pure numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
only returns the units as far as it is able to determine them.  For
example, in an expression <em>X + Y</em>, if <em>X</em> has
unambiguously-defined units and <em>Y</em> does not, it will return
the units of <em>X</em>.  <strong>It is important that callers also
invoke the method</strong>
@if java KineticLaw::containsUndeclaredUnits()@else containsUndeclaredUnits()@endif@~
<strong>to determine whether this situation holds</strong>.  Callers
may wish to take suitable actions in those scenarios.
Returns a UnitDefinition that expresses the units of the math 
expression of this KineticLaw, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item KineticLaw::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this KineticLaw contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this KineticLaw
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item KineticLaw::containsUndeclaredUnits

Predicate returning C<true> if 
the math expression of this KineticLaw contains
parameters/numbers with undeclared units.
Returns C<true> if the math expression of this KineticLaw
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by
@if java KineticLaw::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif@~
may not accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item KineticLaw::removeParameter

Removes the nth Parameter object in the list of local parameters 
in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the Parameter object to remove
Returns the Parameter object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item KineticLaw::removeLocalParameter

Removes the nth LocalParameter object in the list of local parameters 
in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the LocalParameter object to remove
Returns the LocalParameter object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item KineticLaw::removeParameter

Removes a Parameter object with the given identifier in the list of
local parameters in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the Parameter to remove
Returns the Parameter object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no Parameter
object with the identifier exists in this KineticLaw instance.


=item KineticLaw::removeLocalParameter

Removes a LocalParameter object with the given identifier in the list of
local parameters in this KineticLaw instance and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param sid the identifier of the LocalParameter to remove
Returns the LocalParameter object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no LocalParameter
object with the identifier exists in this KineticLaw instance.


=item KineticLaw::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use.


=item KineticLaw::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item KineticLaw::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item KineticLaw::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link
SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item KineticLaw::getElementName

Returns the XML element name of this object, which for Species, is
always C<"kineticLaw">.
Returns the name of this element, i.e., C<"kineticLaw">.


=item KineticLaw::getElementPosition

@internal

Returns the ordinal position of the element with respect to its
siblings or -1 (default) to indicate the position is not significant.


=item KineticLaw::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item KineticLaw::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this KineticLaw object
have been set.
@note The required attributes for a KineticLaw object are:
@li "formula" (SBML Level&nbsp;1 only)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item KineticLaw::hasRequiredElements

Predicate returning C<true> if
all the required elements for this KineticLaw object
have been set.
@note The required elements for a KineticLaw object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item KineticLaw::removeFromParentAndDelete

Finds this KineticLaw's Reaction parent and calls unsetKineticLaw() on it, indirectly deleting itself.  Overridden from the SBase function since the parent is not a ListOf.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item KineticLaw::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item KineticLaw::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item KineticLaw::getInternalId

@internal

Renames all the UnitSIdRef attributes on this element


=item KineticLaw::setInternalId

@internal

Renames all the UnitSIdRef attributes on this element


=item KineticLaw::replaceSIDWithFunction

@internal

Replace all nodes with the name 'id' from the child 'math' object with the provided function.


=item KineticLaw::divideAssignmentsToSIdByFunction

@internal

If this reaction id matches the provided 'id' string, replace the 'math' object with the function (existing/function).


=item KineticLaw::multiplyAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing function).


=item KineticLaw::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item KineticLaw::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item KineticLaw::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item KineticLaw::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item KineticLaw::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item KineticLaw::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item KineticLaw::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item KineticLaw::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=back

=head2 SimpleSpeciesReference

LibSBML implementation of SBML's SimpleSpeciesReference construct.
As mentioned in the description of Reaction, every species that enters
into a given reaction must appear in that reaction's lists of reactants,
products and/or modifiers.  In an SBML model, all species that may
participate in any reaction are listed in the "listOfSpecies" element of
the top-level Model object.  Lists of products, reactants and modifiers
in Reaction objects do not introduce new species, but rather, they refer
back to those listed in the model's top-level "listOfSpecies".  For
reactants and products, the connection is made using SpeciesReference
objects; for modifiers, it is made using ModifierSpeciesReference
objects.  SimpleSpeciesReference is an abstract type that serves as the
parent class of both SpeciesReference and ModifierSpeciesReference.  It
is used simply to hold the attributes and elements that are common to
the latter two structures.
The SimpleSpeciesReference structure has a mandatory attribute,
"species", which must be a text string conforming to the identifer
syntax permitted in SBML.  This attribute is inherited by the
SpeciesReference and ModifierSpeciesReference subclasses derived from
SimpleSpeciesReference.  The value of the "species" attribute must be
the identifier of a species defined in the enclosing Model.  The species
is thereby declared as participating in the reaction being defined.  The
precise role of that species as a reactant, product, or modifier in the
reaction is determined by the subclass of SimpleSpeciesReference (i.e.,
either SpeciesReference or ModifierSpeciesReference) in which the
identifier appears.
SimpleSpeciesReference also contains an optional attribute, "id",
allowing instances to be referenced from other structures.  No SBML
structures currently do this; however, such structures are anticipated
in future SBML Levels.

=over


=item SimpleSpeciesReference::SimpleSpeciesReference

Creates a new SimpleSpeciesReference using the given SBML C<level> and C<version
>
values.
    
@param level an unsigned int, the SBML Level to assign to this SimpleSpeciesReference
@param version an unsigned int, the SBML Version to assign to this
SimpleSpeciesReference
    
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.


=item SimpleSpeciesReference::SimpleSpeciesReference

Copy constructor; creates a copy of this SimpleSpeciesReference.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item SimpleSpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SimpleSpeciesReference::getId

Returns the value of the "id" attribute of this SimpleSpeciesReference.
Returns the id of this SimpleSpeciesReference.


=item SimpleSpeciesReference::getName

Returns the value of the "name" attribute of this SimpleSpeciesReference.
Returns the name of this SimpleSpeciesReference.


=item SimpleSpeciesReference::getSpecies

Get the value of the "species" attribute.
Returns the value of the attribute "species" for this
SimpleSpeciesReference.


=item SimpleSpeciesReference::isSetId

Predicate returning C<true> if this
SimpleSpeciesReference's "id" attribute is set.
Returns C<true> if the "id" attribute of this SimpleSpeciesReference is
set, C<false> otherwise.


=item SimpleSpeciesReference::isSetName

Predicate returning C<true> if this
SimpleSpeciesReference's "name" attribute is set.
Returns C<true> if the "name" attribute of this SimpleSpeciesReference is
set, C<false> otherwise.


=item SimpleSpeciesReference::isSetSpecies

Predicate returning C<true> if this
SimpleSpeciesReference's "species" attribute is set.
Returns C<true> if the "species" attribute of this
SimpleSpeciesReference is set, C<false> otherwise.


=item SimpleSpeciesReference::setSpecies

Sets the "species" attribute of this SimpleSpeciesReference.
The identifier string passed in C<sid> is copied.
@param sid the identifier of a species defined in the enclosing
Model's ListOfSpecies.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item SimpleSpeciesReference::setId

Sets the value of the "id" attribute of this SimpleSpeciesReference.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this SimpleSpeciesReference
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item SimpleSpeciesReference::setName

Sets the value of the "name" attribute of this SimpleSpeciesReference.
The string in C<name> is copied.
@param name the new name for the SimpleSpeciesReference
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item SimpleSpeciesReference::unsetId

Unsets the value of the "id" attribute of this SimpleSpeciesReference.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SimpleSpeciesReference::unsetName

Unsets the value of the "name" attribute of this SimpleSpeciesReference.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item SimpleSpeciesReference::isModifier

Predicate returning C<true> if this
is a ModifierSpeciesReference.
Returns C<true> if this SimpleSpeciesReference's subclass is
ModiferSpeciesReference, C<false> if it is a plain SpeciesReference.


=item SimpleSpeciesReference::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item SimpleSpeciesReference::hasRequiredAttributes

@internal
  
Renames all the SIdRef attributes on this element, including any found in MathML


=item SimpleSpeciesReference::SimpleSpeciesReference

@internal
  
Creates a new SimpleSpeciesReference using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@note Upon the addition of a SimpleSpeciesReference object to an
SBMLDocument (e.g., using Model::addSimpleSpeciesReference()), the
SBML XML namespace of the document I<overrides> the value used when
creating the SimpleSpeciesReference object via this constructor.  This
is necessary to ensure that an SBML document is a consistent
structure.  Nevertheless, the ability to supply the values at the time
of creation of a SimpleSpeciesReference is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item SimpleSpeciesReference::addExpectedAttributes

@internal
  
Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item SimpleSpeciesReference::readAttributes

@internal
  
Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SimpleSpeciesReference::readL1Attributes

@internal
  
Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SimpleSpeciesReference::readL2Attributes

@internal
  
Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SimpleSpeciesReference::readL3Attributes

@internal
  
Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SimpleSpeciesReference::writeAttributes

@internal
  
Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=back

=head2 SpeciesReference

LibSBML implementation of SBML's SpeciesReference construct.
The Reaction structure provides a way to express which species act as
reactants and which species act as products in a reaction.  In a given
reaction, references to those species acting as reactants and/or
products are made using instances of SpeciesReference structures in a
Reaction object's lists of reactants and products.
A species can occur more than once in the lists of reactants and
products of a given Reaction instance.  The effective stoichiometry for
a species in a reaction is the sum of the stoichiometry values given on
the SpeciesReference object in the list of products minus the sum of
stoichiometry values given on the SpeciesReference objects in the list
of reactants.  A positive value indicates the species is effectively a
product and a negative value indicates the species is effectively a
reactant.  SBML places no restrictions on the effective stoichiometry of
a species in a reaction; for example, it can be zero.  In the following
SBML fragment, the two reactions have the same effective stoichiometry
for all their species:
@verbatim
<reaction id="x">
<listOfReactants>
<speciesReference species="a"/>
<speciesReference species="a"/>
<speciesReference species="b"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
<speciesReference species="b"/>
</listProducts>
</reaction>
<reaction id="y">
<listOfReactants>
<speciesReference species="a" stoichiometry="2"/>
</listOfReactants>
<listOfProducts>
<speciesReference species="c"/>
</listProducts>
</reaction>
@endverbatim

The precise structure of SpeciesReference differs between SBML
Level&nbsp;2 and Level&nbsp;3.  We discuss the two variants in separate
sections below.
@section spr-l2 SpeciesReference in SBML Level 2
The mandatory "species" attribute of SpeciesReference must have as its
value the identifier of an existing species defined in the enclosing
Model.  The species is thereby designated as a reactant or product in
the reaction.  Which one it is (i.e., reactant or product) is indicated
by whether the SpeciesReference appears in the Reaction's "reactant" or
"product" lists.
Product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The "stoichiometry" attribute is of type
double and should contain values greater than zero (0).  The
"stoichiometryMath" element is implemented as an element containing a
MathML expression.  These two are mutually exclusive; only one of
"stoichiometry" or "stoichiometryMath" should be defined in a given
SpeciesReference instance.  When neither the attribute nor the element
is present, the value of "stoichiometry" in the SpeciesReference
instance defaults to C<1>.
For maximum interoperability, the "stoichiometry" attribute should be
used in preference to "stoichiometryMath" when a species' stoichiometry
is a simple scalar number (integer or decimal).  When the stoichiometry
is a rational number, or when it is a more complicated formula,
"stoichiometryMath" must be used.  The MathML expression in
"stoichiometryMath" may also refer to identifiers of entities in a model
(except reaction identifiers).  However, the only species identifiers
that can be used in "stoichiometryMath" are those referenced in the
Reaction list of reactants, products and modifiers.
The following is a simple example of a species reference for species @c
X0, with stoichiometry C<2>, in a list of reactants within a reaction
having the identifier C<J1>:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0" stoichiometry="2">
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim
The following is a more complex example of a species reference for
species X0, with a stoichiometry formula consisting of the parameter
C<x>:
@verbatim
<model>
...
<listOfReactions>
<reaction id="J1">
<listOfReactants>
<speciesReference species="X0">
<stoichiometryMath>
<math xmlns="http://www.w3.org/1998/Math/MathML">
<ci>x</ci>
</math>
</stoichiometryMath>
</speciesReference>
</listOfReactants>
...
</reaction>
...
</listOfReactions>
...
</model>
@endverbatim
@section spr-l3 SpeciesReference in SBML Level 3
In Level 2's definition of a reaction, the stoichiometry attribute of a
SpeciesReference is actually a combination of two factors, the standard
biochemical stoichiometry and a conversion factor that may be needed to
translate the units of the species quantity to the units of the reaction
rate. Unfortunately, Level&nbsp;2 offers no direct way of decoupling
these two factors, or for explicitly indicating the units. The only way
to do it in Level&nbsp;2 is to use the StoichiometryMath object
associated with SpeciesReferences, and to reference SBML Parameter
objects from within the StoichiometryMath formula. This works because
Parameter offers a way to attach units to a numerical value, but the
solution is indirect and awkward for something that should be a simple
matter.  Moreover, the question of how to properly encode
stoichiometries in SBML reactions has caused much confusion among
implementors of SBML software.
SBML Level&nbsp;3 approaches this problem differently.  It (1) extends
the the use of the SpeciesReference identifier to represent the value of
the "stoichiometry" attribute, (2) makes the "stoichiometry" attribute
optional, (3) removes StoichiometryMath, and (4) adds a new "constant"
boolean attribute on SpeciesReference.
As in Level&nbsp;2, the "stoichiometry" attribute is of type
C<double> and should contain values greater than zero (C<0>).  A
missing "stoichiometry" implies that the stoichiometry is either
unknown, or to be obtained from an external source, or determined by an
InitialAssignment object or other SBML construct elsewhere in the model.
A species reference's stoichiometry is set by its "stoichiometry"
attribute exactly once.  If the SpeciesReference object's "constant"
attribute has the value C<true>, then the stoichiometry is fixed and
cannot be changed except by an InitialAssignment object.  These two
methods of setting the stoichiometry (i.e., using "stoichiometry"
directly, or using InitialAssignment) differ in that the "stoichiometry"
attribute can only be set to a literal floating-point number, whereas
InitialAssignment allows the value to be set using an arbitrary
mathematical expression.  (As an example, the approach could be used to
set the stoichiometry to a rational number of the form I<p>/I<q>,
where I<p> and I<q> are integers, something that is occasionally
useful in the context of biochemical reaction networks.)  If the species
reference's "constant" attribute has the value C<false>, the species
reference's value may be overridden by an InitialAssignment or changed
by AssignmentRule or AlgebraicRule, and in addition, for simulation time
<em>t &gt; 0</em>, it may also be changed by a RateRule or Event
objects.  (However, some of these constructs are mutually exclusive; see
the SBML Level&nbsp;3 Version&nbsp;1 Core specifiation for more
details.)  It is not an error to define "stoichiometry" on a species
reference and also redefine the stoichiometry using an
InitialAssignment, but the "stoichiometry" attribute in that case is
ignored.

The value of the "id" attribute of a SpeciesReference can be used as the
content of a C<&lt;ci&gt;> element in MathML formulas
elsewhere in the model.  When the identifier appears in a MathML
C<&lt;ci&gt;> element, it represents the stoichiometry of the
corresponding species in the reaction where the SpeciesReference object
instance appears.  More specifically, it represents the value of the
"stoichiometry" attribute on the SpeciesReference object.
In SBML Level 3, the unit of measurement associated with the value of a
species' stoichiometry is always considered to be C<dimensionless>.
This has the following implications:

=over



=item

When a species reference's identifier appears in mathematical
formulas elsewhere in the model, the unit associated with that value is
C<dimensionless>.

=item

The units of the "math" elements of AssignmentRule,
InitialAssignment and EventAssignment objects setting the stoichiometry
of the species reference should be C<dimensionless>.

=item

If a species reference's identifier is the subject of a RateRule,
the unit associated with the RateRule object's value should be
C<dimensionless>/<em>time</em>, where <em>time</em> is the
model-wide unit of time set on the Model object.

=back


<!---------------------------------------------------------------------- -->

=over


=back

=head2 ListOfSpeciesReferences

LibSBML implementation of SBML's ListOfSpeciesReferences construct.
The ListOfSpeciesReferences class is used to store lists of reactants
and products in a Reaction object.
As with the various other ListOf___ classes in SBML, the
ListOfSpeciesReferences is merely a container used for organizing
instances of other objects, in this case SpeciesReference objects.
ListOfSpeciesReferences is derived from the abstract class SBase, and
inherit the various attributes and subelements of SBase, such as
"metaid" as and "annotation".  The ListOf___ classes do not add any
attributes of their own.

=over


=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this SpeciesReference
@param version an unsigned int, the SBML Version to assign to this
SpeciesReference

@note Upon the addition of a SpeciesReference object to a Model (e.g.,
using Reaction::addReactant(const SpeciesReference  sr) or
Reaction::addProduct(const SpeciesReference  sr)), the SBML Level,
SBML Version and XML namespace of the document I<override> the values
used when creating the SpeciesReference object via this constructor.
This is necessary to ensure that an SBML document is a consistent
structure.  Nevertheless, the ability to supply the values at the time
of creation of a SpeciesReference is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item SpeciesReference::SpeciesReference

Creates a new SpeciesReference using the given SBMLNamespaces object
C<sbmlns>.
@param sbmlns an SBMLNamespaces object.
@note Upon the addition of a SpeciesReference object to a Model (e.g.,
using Reaction::addReactant(const SpeciesReference  sr) or
Reaction::addProduct(const SpeciesReference  sr)), the SBML Level,
SBML Version and XML namespace of the document I<override> the values
used when creating the SpeciesReference object via this constructor.
This is necessary to ensure that an SBML document is a consistent
structure.  Nevertheless, the ability to supply the values at the time
of creation of a SpeciesReference is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item SpeciesReference::SpeciesReference

Copy constructor; creates a copy of this SpeciesReference.
@param orig the SpeciesReference instance to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item SpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item SpeciesReference::clone

Creates and returns a deep copy of this SpeciesReference instance.
Returns a (deep) copy of this SpeciesReference.


=item SpeciesReference::initDefaults

Initializes the fields of this SpeciesReference object to "typical"
default values.
The SBML SpeciesReference component has slightly different aspects and
default attribute values in different SBML Levels and Versions.
This method sets the values to certain common defaults, based
mostly on what they are in SBML Level&nbsp;2.  Specifically:

=over


=item

Sets attribute "stoichiometry" to C<1>.0

=item

(Applies to Level&nbsp;1 models only) Sets attribute "denominator" to C<1>

=back


@see getDenominator()
@see setDenominator(int value)
@see getStoichiometry()
@see setStoichiometry(double value)
@see getStoichiometryMath()
@see setStoichiometryMath(const StoichiometryMath  math)


=item SpeciesReference::getStoichiometry

Get the value of the "stoichiometry" attribute.
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
Returns the value of the (scalar) "stoichiometry" attribute of this
SpeciesReference.

@see getStoichiometryMath()


=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

The "stoichiometryMath" element exists only in SBML Level 2.  There,
product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
Returns the content of the "stoichiometryMath" subelement of this
SpeciesReference.


=item SpeciesReference::getStoichiometryMath

Get the content of the "stoichiometryMath" subelement as an ASTNode
tree.

The "stoichiometryMath" element exists only in SBML Level 2.  There,
product and reactant stoichiometries can be specified using
<em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or decimal).
Returns the content of the "stoichiometryMath" subelement of this
SpeciesReference.

@see getStoichiometry()


=item SpeciesReference::getDenominator

Get the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
The "denominator" attribute is only actually written out in the case
of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode structure.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level&nbsp;1, or a
"stoichiometryMath" subelement in the case of SBML Level&nbsp;2).
Returns the value of the "denominator" attribute of this
SpeciesReference.


=item SpeciesReference::getConstant

Get the value of the "constant" attribute.
Returns the value of the "constant" attribute of this
SpeciesReference.


=item SpeciesReference::isSetStoichiometryMath

Predicate returning C<true> if this
SpeciesReference's "stoichiometryMath" subelement is set
Returns C<true> if the "stoichiometryMath" subelement of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::isSetConstant

Predicate returning C<true> if this
SpeciesReference's "constant" attribute is set
Returns C<true> if the "constant" attribute of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::isSetStoichiometry

Predicate returning C<true> if this
SpeciesReference's "stoichiometry" attribute is set.
Returns C<true> if the "stoichiometry" attribute of this
SpeciesReference is set, C<false> otherwise.


=item SpeciesReference::setStoichiometry

Sets the value of the "stoichiometry" attribute of this
SpeciesReference.

In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@param value the new value of the "stoichiometry" attribute
@note In SBML Level&nbsp;2, the "stoichiometryMath" subelement of this
SpeciesReference object will be unset because the "stoichiometry"
attribute and the stoichiometryMath" subelement are mutually
exclusive.

Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item SpeciesReference::setStoichiometryMath

Sets the "stoichiometryMath" subelement of this SpeciesReference.
The Abstract Syntax Tree in C<math> is copied.
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@param math the StoichiometryMath expression that is to be copied as the
content of the "stoichiometryMath" subelement.
@note In SBML Level&nbsp;2, the "stoichiometry" attribute of this
SpeciesReference object will be unset (isSetStoichiometry() will
return C<false> although getStoichiometry() will return C<1>.0) if the
given math is not null because the "stoichiometry" attribute and the
stoichiometryMath" subelement are mutually exclusive.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink


=item SpeciesReference::setDenominator

Set the value of the "denominator" attribute, for the case of a
rational-numbered stoichiometry or a model in SBML Level&nbsp;1.
The "denominator" attribute is only actually written out in the case
of an SBML Level&nbsp;1 model.  In SBML Level&nbsp;2, rational-number
stoichiometries are written as MathML elements in the
"stoichiometryMath" subelement.  However, as a convenience to users,
libSBML allows the creation and manipulation of rational-number
stoichiometries by supplying the numerator and denominator directly
rather than having to manually create an ASTNode structure.  LibSBML
will write out the appropriate constructs (either a combination of
"stoichiometry" and "denominator" in the case of SBML Level&nbsp;1, or
a "stoichiometryMath" subelement in the case of SBML Level&nbsp;2).
@param value the scalar value 
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink


=item SpeciesReference::setConstant

Sets the "constant" attribute of this SpeciesReference to the given boolean
C<flag>.
@param flag a boolean, the value for the "constant" attribute of this
SpeciesReference instance
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item SpeciesReference::unsetStoichiometryMath

Unsets the "stoichiometryMath" subelement of this SpeciesReference.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
In SBML Level 2, product and reactant stoichiometries can be specified
using <em>either</em> "stoichiometry" or "stoichiometryMath" in a
SpeciesReference object.  The former is to be used when a
stoichiometry is simply a scalar number, while the latter is for
occasions when it needs to be a rational number or it needs to
reference other mathematical expressions.  The "stoichiometry"
attribute is of type C<double> and should contain values greater than
zero (C<0>).  The "stoichiometryMath" element is implemented as an
element containing a MathML expression.  These two are mutually
exclusive; only one of "stoichiometry" or "stoichiometryMath" should
be defined in a given SpeciesReference instance.  When neither the
attribute nor the element is present, the value of "stoichiometry" in
the SpeciesReference instance defaults to C<1>.  For maximum
interoperability between different software tools, the "stoichiometry"
attribute should be used in preference to "stoichiometryMath" when a
species' stoichiometry is a simple scalar number (integer or
decimal).

In SBML Level 3, there is no StoichiometryMath, and SpeciesReference
objects have only the "stoichiometry" attribute.
@note In SBML Level&nbsp;2, the "stoichiometry" attribute of this
SpeciesReference object will be reset to a default value (C<1>.0) if
the "stoichiometry" attribute has not been set.


=item SpeciesReference::unsetStoichiometry

Unsets the "stoichiometry" attribute of this SpeciesReference.
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note In SBML Level&nbsp;1, the "stoichiometry" attribute of this
SpeciesReference object will be just reset to a default value (C<1>.0)
and isSetStoichiometry() will still return C<true>.  In SBML
Level&nbsp;2, the "stoichiometry" attribute of this object will be
unset (which will result in isSetStoichiometry() returning C<false>,
although getStoichiometry() will return C<1>.0) if the
"stoichiometryMath" subelement is set, otherwise the attribute
will be just reset to the default value (C<1>.0) (and
isSetStoichiometry() will still return C<true>).  In SBML
Level&nbsp;3, the "stoichiometry" attribute of this object will be set
to C<NaN> and isSetStoichiometry() will return C<false>.


=item SpeciesReference::createStoichiometryMath

Creates a new, empty StoichiometryMath object, adds it to this
SpeciesReference, and returns it.
Returns the newly created StoichiometryMath object instance
@see Reaction::addReactant(const SpeciesReference  sr)
@see Reaction::addProduct(const SpeciesReference  sr)


=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML structure that is to be used as the content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SpeciesReference::setAnnotation

Sets the value of the "annotation" subelement of this SBML object to a
copy of C<annotation>.
Any existing content of the "annotation" subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the C<annotation> that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().
@param annotation an XML string that is to be used as the content
of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see appendAnnotation(const XMLNode  annotation)
@see appendAnnotation(const std::string& annotation)


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike
SpeciesReference::setAnnotation(@if java String annotation@endif),
this method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML structure that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see setAnnotation(const std::string& annotation)
@see setAnnotation(const XMLNode  annotation)


=item SpeciesReference::appendAnnotation

Appends annotation content to any existing content in the "annotation"
subelement of this object.
The content in C<annotation> is copied.  Unlike
SpeciesReference::setAnnotation(@if java String annotation@endif), this
method allows other annotations to be preserved when an application
adds its own data.
@param annotation an XML string that is to be copied and appended
to the content of the "annotation" subelement of this object
Returns integer value indicating success/failure of the
function.  The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@see setAnnotation(const std::string& annotation)
@see setAnnotation(const XMLNode  annotation)


=item SpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item SpeciesReference::getElementName

Returns the XML element name of this object, which for
SpeciesReference, is always C<"speciesReference">.
Returns the name of this element, i.e., C<"speciesReference">.


=item SpeciesReference::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item SpeciesReference::sortMath

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item SpeciesReference::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this SpeciesReference object
have been set.
@note The required attributes for a SpeciesReference object are:
@li "species"
@li "constant" (only available SBML Level&nbsp;3)
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item SpeciesReference::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item SpeciesReference::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item SpeciesReference::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item SpeciesReference::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SpeciesReference::readL1Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SpeciesReference::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SpeciesReference::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item SpeciesReference::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item SpeciesReference::syncAnnotation

@internal


Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation(), isSetAnnotation(),
and writeElements() methods.


=item SpeciesReference::isExplicitlySetStoichiometry

@internal


Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation(), isSetAnnotation(),
and writeElements() methods.


=item SpeciesReference::isExplicitlySetDenominator

@internal


Synchronizes the annotation of this SBML object.
Annotation element (XMLNode  mAnnotation) is synchronized with the
current CVTerm objects (List  mCVTerm) and id string (std::string mId)
Currently, this method is called in getAnnotation(), isSetAnnotation(),
and writeElements() methods.


=item ListOfSpeciesReferences::ListOfSpeciesReferences

Creates a new, empty ListOfSpeciesReferences object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfSpeciesReferences::ListOfSpeciesReferences

Creates a new ListOfSpeciesReferences object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfSpeciesReferences object to be created.


=item ListOfSpeciesReferences::clone

Creates and returns a deep copy of this ListOfSpeciesReferences
instance.

Returns a (deep) copy of this ListOfSpeciesReferences.


=item ListOfSpeciesReferences::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpeciesReferences::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesReference objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfSpeciesReferences::getElementName

Returns the XML element name of this object.
For ListOfSpeciesReferences, the XML element name is @c
"listOfSpeciesReferences".

Returns the name of this element, i.e., C<"listOfSpeciesReferences">.


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
Returns the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences.
@param n the index number of the SpeciesReference to get.
Returns the nth SpeciesReference in this ListOfSpeciesReferences.
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
Returns SpeciesReference in this ListOfSpeciesReferences
with the given id or C<NULL> if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::get

Get a SpeciesReference from the ListOfSpeciesReferences
based on its identifier.
@param sid a string representing the identifier 
of the SpeciesReference to get.
Returns SpeciesReference in this ListOfSpeciesReferences
with the given id or C<NULL> if no such
SpeciesReference exists.
@see get(unsigned int n)
@see size()


=item ListOfSpeciesReferences::remove

Removes the nth item from this ListOfSpeciesReferences items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfSpeciesReferences::remove

Removes item in this ListOfSpeciesReferences items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then @c
NULL is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfSpeciesReferences::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfSpeciesReferences::setType

@internal

Sets type of this ListOfSpeciesReferences.


=item ListOfSpeciesReferences::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 ModifierSpeciesReference

LibSBML implementation of SBML's ModifierSpeciesReference construct.
Sometimes a species appears in the kinetic rate formula of a reaction
but is itself neither created nor destroyed in that reaction (for
example, because it acts as a catalyst or inhibitor).  In SBML, all such
species are simply called I<modifiers> without regard to the detailed
role of those species in the model.  The Reaction structure provides a
way to express which species act as modifiers in a given reaction.  This
is the purpose of the list of modifiers available in Reaction.  The list
contains instances of ModifierSpeciesReference structures.
The ModifierSpeciesReference structure inherits the mandatory attribute
"species" and optional attributes "id" and "name" from the parent class
SimpleSpeciesReference.  See the description of SimpleSpeciesReference
for more information about these.
The value of the "species" attribute must be the identifier of a species
defined in the enclosing Model; this species is designated as a modifier
for the current reaction.  A reaction may have any number of modifiers.
It is permissible for a modifier species to appear simultaneously in the
list of reactants and products of the same reaction where it is
designated as a modifier, as well as to appear in the list of reactants,
products and modifiers of other reactions in the model.

=over


=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModifierSpeciesReference using the given SBML C<level> and C<version
>
values.
    
@param level an unsigned int, the SBML Level to assign to this ModifierSpeciesReference
@param version an unsigned int, the SBML Version to assign to this
ModifierSpeciesReference
     
@note Upon the addition of a ModifierSpeciesReference object to an
SBMLDocument (e.g., using Reaction::addModifier(@if java ModifierSpeciesReference msr@endif)), the
SBML Level, SBML Version and XML namespace of the document I<
>
override the values used when creating the ModifierSpeciesReference
object via this constructor.  This is necessary to ensure that an SBML
document is a consistent structure.  Nevertheless, the ability to
supply the values at the time of creation of a
ModifierSpeciesReference is an important aid to producing valid SBML.
Knowledge of the intented SBML Level and Version determine whether it
is valid to assign a particular value to an attribute, or whether it
is valid to add an object to an existing SBMLDocument.


=item ModifierSpeciesReference::ModifierSpeciesReference

Creates a new ModifierSpeciesReference using the given SBMLNamespaces object
C<sbmlns>.
@param sbmlns an SBMLNamespaces object.
@note Upon the addition of a ModifierSpeciesReference object to an
SBMLDocument (e.g., using Reaction::addModifier(@if java ModifierSpeciesReference msr@endif)), the
SBML XML namespace of the document I<overrides> the value used when
creating the ModifierSpeciesReference object via this constructor.
This is necessary to ensure that an SBML document is a consistent
structure.  Nevertheless, the ability to supply the values at the time
of creation of a ModifierSpeciesReference is an important aid to
producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item ModifierSpeciesReference::accept

Accepts the given SBMLVisitor.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>.


=item ModifierSpeciesReference::clone

Creates and returns a deep copy of this ModifierSpeciesReference
instance.
    
Returns a (deep) copy of this ModifierSpeciesReference.


=item ModifierSpeciesReference::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters C<
>
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ModifierSpeciesReference::getElementName

Returns the XML element name of this object, which for Species, is
always C<"modifierSpeciesReference">.
Returns the name of this element, i.e., C<"modifierSpeciesReference">.


=item ModifierSpeciesReference::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this ModifierSpeciesReference object
have been set.
@note The required attributes for a ModifierSpeciesReference object are:
species


=back

=head2 Event

LibSBML implementation of SBML's Event construct.
An SBML Event object defines when the event can occur, the variables
that are affected by it, how the variables are affected, and the event's
relationship to other events.  The effect of the event can optionally be
delayed after the occurrence of the condition which invokes it.
The operation of Event is divided into two phases (even when the event
is not delayed): one when the event is I<triggered>, and the other when
the event is I<executed>.  Trigger objects define the conditions for
triggering an event, Delay objects define when the event is actually
executed, EventAssignment objects define the effects of executing the
event, and (in SBML Level&nbsp;3) Priority objects influence the order
of EventAssignment performance in cases of simultaneous events.  Please
consult the descriptions of Trigger, Delay, EventAssignment and Priority
for more information.
@section version-diffs SBML Level/Version differences
@subsection sbml-l3 SBML Level 3
SBML Level 3 introduces several changes to the structure and components
of Events compared to SBML Level&nbsp;2.  These changes fall into two
main categories: changes to what is optional or required, and additions
of new attributes and elements.

=over


=item

The attribute "useValuesFromTriggerTime" on Event is mandatory (it
was optional in Level&nbsp;2);

=item

Event's "listOfEventAssignments" element (of class
ListOfEventAssignments) is optional (it was mandatory in Level&nbsp;2);

=item

Event's "priority" element (of class Priority) is new in
Level&nbsp;3; and

=item

The Trigger object gains new mandatory attributes (described as part
of the definition of Trigger).

=back


The changes to the attributes of Event are described below; the changes
to Trigger and Priority are described in their respective sections.
@subsection sbml-l2 SBML Level 2
In SBML Level&nbsp;2 versions before Version&nbsp;4, the semantics of
Event time delays were defined such that the expressions in the event's
assignments were always evaluated at the time the event was
<em>triggered</em>.  This definition made it difficult to define an event
whose assignment formulas were meant to be evaluated at the time the
event was <em>executed</em> (i.e., after the time period defined by the
value of the Delay element).  In SBML Level&nbsp;2 Version&nbsp;4 and in
Level&nbsp;3, the attribute "useValuesFromTriggerTime" on Event allows a
model to indicate the time at which the event's assignments are intended
the values of the assignment formulas are computed at the moment the
event is triggered, not after the delay.  If "useValuesFromTriggerTime"=@c
false, it means that the formulas in the event's assignments are to be
computed I<after> the delay, at the time the event is executed.
The definition of Event in SBML Level&nbsp;2 Versions 1 and 2 includes
an additional attribute called "timeUnits", which allowed the time units
of the Delay to be set explicitly.  Later Versions of SBML Level&nbsp;2
as well as SBML Level&nbsp;3 do not define this attribute.  LibSBML
supports this attribute for compatibility with previous versions of SBML
Level&nbsp;2; however, if a model in SBML Level&nbsp;3 or Level&nbsp;2
Versions&nbsp;3&ndash;4 format sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will report
an error.
The attribute "useValuesFromTriggerTime" was introduced in SBML
Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
Level&nbsp;2 cannot use this attribute, and
SBMLDocument::checkConsistency() will report an error if they do.
@section semantics Semantics of events in SBML Level 3 Version&nbsp;1
The detailed semantics of events are described in the specification
documents for each SBML Level/Version.  Here we include the description
from the SBML Level&nbsp;1 Version&nbsp;1.
Any transition of a Trigger object's "math" formula from the value @c
false to C<true> will cause the enclosing Event object to
<em>trigger</em>.  Such a transition is not possible at the very start
of a simulation (i.e., at time <em>t = 0</em>) unless the Trigger
object's "initialValue" attribute has a value of C<false>; this defines
the value of the trigger formula to be C<false> immediately prior to the
start of simulation, thereby giving it the potential to change in value
from C<false> to C<true> when the formula is evaluated at <em>t =
0</em>.  If "initialValue"=C<true>, then the trigger expression cannot
transition from C<false> to C<true> at <em>t = 0</em> but may do so at
some time <em>t E<gt> 0</em>.
Consider an Event object definition <EM>E</EM> with delay <em>d</em> in
which the Trigger object's "math" formula makes a transition in value
from C<false> to C<true> at times <em>t<sub>1</sub></em> and
<em>t<sub>2</sub></em>.  The EventAssignment within the Event object
will have effect at <em>t<sub>1</sub> + d</em> and
<em>t<sub>2</sub> + d</em> irrespective of the relative times of
<em>t<sub>1</sub></em> and <em>t<sub>2</sub></em>.  For example, events
can "overlap" so that <em>t<sub>1</sub> E<lt> t<sub>2</sub> <
t<sub>1</sub> + d</em> still causes an event assignments to occur at
<em>t<sub>1</sub> + d</em> and <em>t<sub>2</sub> + d</em>.
It is entirely possible for two events to be executed simultaneously,
and it is possible for events to trigger other events (i.e., an event
assignment can cause an event to trigger).  This leads to several
points:

=over


=item

A software package should retest all event triggers after executing
an event assignment in order to account for the possibility that the
assignment causes another event trigger to transition from C<false> to
C<true>.  This check should be made after each individual Event object's
execution, even when several events are to be executed simultaneously.

=item

Any Event object whose Trigger "persistent" attribute has the value
C<false> must have its trigger expression reevaluated continuously
between when the event is triggered and when it is executed.  If
its trigger expression ever evaluates to C<false>, it must be removed
from the queue of events pending execution and treated as any other
event whose trigger expression evaluates to C<false>.

=item

Although the precise time at which events are executed is not
resolved beyond the given execution point in simulated time, it is
assumed that the order in which the events occur <em>is</em> resolved.
This order can be significant in determining the overall outcome of a
given simulation.  When an event <EM>X</EM> <em>triggers</em> another
event <EM>Y</EM> and event <EM>Y</EM> has zero delay, then event
<EM>Y</EM> is added to the existing set of simultaneous events that are
pending <em>execution</em>.  Events <EM>X</EM> and <EM>Y</EM> form a
cascade of events at the same point in simulation time.  An event such
as <EM>Y</EM> may have a special priority if it contains a Priority
subobject.


=item

All events in a model are open to being in a cascade.  The position
of an event in the event queue does not affect whether it can be in the
cascade: event <EM>Y</EM> can be triggered whether it is before or after
<EM>X</EM> in the queue of events pending execution.  A cascade of
events can be potentially infinite (never terminate); when this occurs a
simulator should indicate this has occurred&mdash;it is incorrect for a
simulator to break a cascade arbitrarily and continue the simulation
without at least indicating that the infinite cascade occurred.

=item

Simultaneous events having no defined priorities are executed in an
undefined order.  This does not mean that the behavior of the simulation
is completely undefined; merely that the <em>order</em> of execution of
these particular events is undefined.  A given simulator may use any
algorithm to choose an order as long as every event is executed exactly
once.


=item

Events with defined priorities are executed in the order implied by
their Priority "math" formula values, with events having higher
priorities being executed ahead of events with lower priorities, and
events with identical priorities being executed in a random order with
respect to one another (as determined at run-time by some random
algorithm equivalent to coin-flipping).  Newly-triggered events that are
to be executed immediately (i.e., if they define no delays) should be
inserted into the queue of events pending execution according to their
priorities: events with higher priority values value must be inserted
ahead of events with lower priority values and after any pending events
with even higher priorities, and inserted randomly among pending events
with the same priority values.  Events without Priority objects must be
inserted into the queue in some fashion, but the algorithm used to place
it in the queue is undefined.  Similarly, there is no restriction on the
order of a newly-inserted event with a defined Priority with respect to
any other pending Event without a defined Priority.

=item

A model variable that is the target of one or more event
assignments can change more than once when simultaneous events are
processed at some time point <em>t</em>.  The model's behavior (output)
for such a variable is the value of the variable at the end of
processing all the simultaneous events at time <em>t</em>.

=back


@see Trigger
@see Priority
@see Delay
@see EventAssignment
<!-- leave this next break as-is to work around some doxygen bug -->

=over


=back

=head2 ListOfEvents

LibSBML implementation of SBML's ListOfEvents construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level&nbsp;2 Version&nbsp;4):
@image html listof-illustration.jpg "ListOf___ elements in an SBML Model"
@image latex listof-illustration.jpg "ListOf___ elements in an SBML Model"
Readers may wonder about the motivations for using the ListOf___
containers.  A simpler approach in XML might be to place the components
all directly at the top level of the model definition.  The choice made
in SBML is to group them within XML elements named after
ListOf<em>Classname</em>, in part because it helps organize the
components.  More importantly, the fact that the container classes are
derived from SBase means that software tools can add information I<about>
the lists themselves into each list container's "annotation".
@see ListOfFunctionDefinitions
@see ListOfUnitDefinitions
@see ListOfCompartmentTypes
@see ListOfSpeciesTypes
@see ListOfCompartments
@see ListOfSpecies
@see ListOfParameters
@see ListOfInitialAssignments
@see ListOfRules
@see ListOfConstraints
@see ListOfReactions
@see ListOfEvents

=over


=item Event::Event

Creates a new Event using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this Event
@param version an unsigned int, the SBML Version to assign to this
Event

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of an Event object to an SBMLDocument (e.g.,
using Model::addEvent(@if java Event e@endif)), the SBML Level, SBML Version and XML
namespace of the document I<override> the values used when creating
the Event object via this constructor.  This is necessary to ensure
that an SBML document is a consistent structure.  Nevertheless, the
ability to supply the values at the time of creation of an Event is an
important aid to producing valid SBML.  Knowledge of the intented SBML
Level and Version determine whether it is valid to assign a particular
value to an attribute, or whether it is valid to add an object to an
existing SBMLDocument.


=item Event::Event

Creates a new Event using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of an Event object to an SBMLDocument (e.g.,
using Model::addEvent(@if java Event e@endif)), the SBML XML namespace of the document @em
overrides the value used when creating the Event object via this
constructor.  This is necessary to ensure that an SBML document is a
consistent structure.  Nevertheless, the ability to supply the values
at the time of creation of a Event is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item Event::Event

Copy constructor; creates a copy of this Event.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item Event::accept

Accepts the given SBMLVisitor for this instance of Event.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next Event in the list
of events within which this Event is embedded.


=item Event::clone

Creates and returns a deep copy of this Event.
Returns a (deep) copy of this Event.


=item Event::getElementBySId

Returns the first child element found that has the given id in the model-wide SId namespace, or NULL if no such object is found.
@param id string representing the id of objects to find
Returns pointer to the first element found with the given id.


=item Event::getElementByMetaId

Returns the first child element it can find with the given metaid, or NULL if no such object is found.
@param metaid string representing the metaid of objects to find
Returns pointer to the first element found with the given metaid.


=item Event::getAllElements

Returns a List of all child SBase  objects, including those nested to an arbitrary depth.
Returns a List  of pointers to all children objects.


=item Event::getId

Returns the value of the "id" attribute of this Event.
Returns the id of this Event.


=item Event::getName

Returns the value of the "name" attribute of this Event.
Returns the name of this Event.


=item Event::getTrigger

Get the event trigger portion of this Event.
Returns the Trigger object of this Event.


=item Event::getTrigger

Get the event trigger portion of this Event.
Returns the Trigger object of this Event.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
Returns the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getDelay

Get the assignment delay portion of this Event, if there is one.
Returns the delay of this Event if one is defined, or C<NULL> if none
is defined.


=item Event::getPriority

(SBML Level&nbsp;3 only) Get the event priority portion of this
Event.

Returns the Priority object of this Event.
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::getPriority

(SBML Level&nbsp;3 only) Get the event priority portion of this
Event.

Returns the Priority object of this Event.
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::getTimeUnits

Get the value of the "timeUnits" attribute of this Event, if it has one.
Returns the value of the attribute "timeUnits" as a string.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::getUseValuesFromTriggerTime

Get the value of the "useValuesFromTriggerTime" attribute of this Event.
The optional Delay on Event means there are two times to consider when
computing the results of an event: the time at which the event is
<em>triggered</em>, and the time at which assignments are
<em>executed</em>.  It is also possible to distinguish between the
time at which the EventAssignment's expression is calculated, and the
time at which the assignment is made: the expression could be
evaluated at the same time the assignments are performed, i.e., when
the event is <em>executed</em>, but it could also be defined to be
evaluated at the time the event is <em>triggered</em>.
In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
of Event time delays were defined such that the expressions in the
event's assignments were always evaluated at the time the event was
<em>triggered</em>.  This definition made it difficult to define an
event whose assignment formulas were meant to be evaluated at the time
the event was <em>executed</em> (i.e., after the time period defined
by the value of the Delay element).  In SBML Level&nbsp;2
Version&nbsp;4, the attribute "useValuesFromTriggerTime" on Event
allows a model to indicate the time at which the event's assignments
are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
a default value of C<true>, which corresponds to the interpretation of
event assignments prior to Version&nbsp;4: the values of the
assignment formulas are computed at the moment the event is triggered,
not after the delay.  If "useValuesFromTriggerTime"=C<false>, it means
that the formulas in the event's assignments are to be computed after
the delay, at the time the event is executed.  In SBML Level&nbsp;3,
the attribute is mandatory, not optional, and all events must specify
a value for it.
Returns the value of the attribute "useValuesFromTriggerTime" as a boolean.
@warning The attribute "useValuesFromTriggerTime" was introduced in
SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will
report an error.


=item Event::isSetId

Predicate returning C<true> if this
Event's "id" attribute is set.
Returns C<true> if the "id" attribute of this Event is
set, C<false> otherwise.


=item Event::isSetName

Predicate returning C<true> if this
Event's "name" attribute is set.
Returns C<true> if the "name" attribute of this Event is
set, C<false> otherwise.


=item Event::isSetTrigger

Predicate for testing whether the trigger for this Event is set.
Returns C<true> if the trigger of this Event is set, C<false>
otherwise.


=item Event::isSetDelay

Predicate for testing whether the delay for this Event is set.
Returns C<true> if the delay of this Event is set, C<false>
otherwise.


=item Event::isSetPriority

(SBML Level&nbsp;3 only) Predicate for testing whether the priority
for this Event is set.
Returns C<true> if the priority of this Event is set, C<false>
otherwise.

@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::isSetTimeUnits

Predicate for testing whether the "timeUnits" attribute of this Event
is set.
Returns C<true> if the "timeUnits" attribute of this Event is
set, C<false> otherwise.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::isSetUseValuesFromTriggerTime

Predicate for testing whether the "useValuesFromTriggerTime" attribute of this Event
is set.
Returns C<true> if the "useValuesFromTriggerTime" attribute of this Event is
set, C<false> otherwise.
@note In SBML Level&nbsp;2, this attribute is optional and has a default value of
C<true>, whereas in Level&nbsp;3 Version&nbsp;1, this optional is mandatory and
has no default value.


=item Event::setId

Sets the value of the "id" attribute of this Event.
The string C<sid> is copied.  Note that SBML has strict requirements
for the syntax of identifiers.  @htmlinclude id-syntax.html
@param sid the string to use as the identifier of this Event
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Event::setName

Sets the value of the "name" attribute of this Event.
The string in C<name> is copied.
@param name the new name for the Event
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item Event::setTrigger

Sets the trigger definition of this Event to a copy of the given
Trigger object instance.
@param trigger the Trigger object instance to use.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink


=item Event::setDelay

Sets the delay definition of this Event to a copy of the given Delay
object instance.
@param delay the Delay object instance to use
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink


=item Event::setPriority

(SBML Level&nbsp;3 only) Sets the priority definition of this Event
to a copy of the given Priority object instance.
@param priority the Priority object instance to use
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::setTimeUnits

Sets the "timeUnits" attribute of this Event to a copy of C<sid>.
@param sid the identifier of the time units to use.
@warning Definitions of Event in SBML Level 2 Versions&nbsp;1
and&nbsp;2 included the additional attribute called "timeUnits", but
it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
this attribute for compatibility with previous versions of SBML
Level&nbsp;2, but its use is discouraged since models in Level 2
Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
or&nbsp;4 model sets the attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink


=item Event::setUseValuesFromTriggerTime

Sets the "useValuesFromTriggerTime" attribute of this Event to a C<value>.
The optional Delay on Event means there are two times to consider when
computing the results of an event: the time at which the event is
<em>triggered</em>, and the time at which assignments are
<em>executed</em>.  It is also possible to distinguish between the
time at which the EventAssignment's expression is calculated, and the
time at which the assignment is made: the expression could be
evaluated at the same time the assignments are performed, i.e., when
the event is <em>executed</em>, but it could also be defined to be
evaluated at the time the event is <em>triggered</em>.
In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
of Event time delays were defined such that the expressions in the
event's assignments were always evaluated at the time the event was
<em>triggered</em>.  This definition made it difficult to define an
event whose assignment formulas were meant to be evaluated at the time
the event was <em>executed</em> (i.e., after the time period defined
by the value of the Delay element).  In SBML Level&nbsp;2
Version&nbsp;4, the attribute "useValuesFromTriggerTime" on Event
allows a model to indicate the time at which the event's assignments
are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
a default value of C<true>, which corresponds to the interpretation of
event assignments prior to Version&nbsp;4: the values of the
assignment formulas are computed at the moment the event is triggered,
not after the delay.  If "useValuesFromTriggerTime"=C<false>, it means
that the formulas in the event's assignments are to be computed after
the delay, at the time the event is executed.  In SBML Level&nbsp;3,
the attribute is mandatory, not optional, and all events must specify
a value for it.
@param value the value of useValuesFromTriggerTime to use.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@warning The attribute "useValuesFromTriggerTime" was introduced in
SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
consistency-checking method SBMLDocument::checkConsistency() will
report an error.


=item Event::unsetId

Unsets the value of the "id" attribute of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Event::unsetName

Unsets the value of the "name" attribute of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Event::unsetDelay

Unsets the Delay of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink


=item Event::unsetPriority

(SBML Level&nbsp;3 only) Unsets the Priority of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::unsetTrigger

Unsets the Trigger of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::unsetTimeUnits

Unsets the "timeUnits" attribute of this Event.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@warning Definitions of Event in SBML Level&nbsp;2 Versions 1 and 2
included the attribute called "timeUnits", but it was removed in SBML
Level&nbsp;2 Version&nbsp;3.  LibSBML supports this attribute for
compatibility with previous versions of SBML Level&nbsp;2, but its use
is discouraged since models in Level&nbsp;2 Version&nbsp;3 and
Version&nbsp;4 cannot contain it.  If a Version&nbsp;3 or&nbsp;4 model
sets this attribute, the consistency-checking method
SBMLDocument::checkConsistency() will report an error.


=item Event::addEventAssignment

Appends a copy of the given EventAssignment to this Event.
@param ea the EventAssignment object to add.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH @endlink
@li @link OperationReturnValues_t#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID @endlink
@li @link OperationReturnValues_t#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
@note This method should be used with some caution.  The fact that
this method I<copies> the object passed to it means that the caller
will be left holding a physically different object instance than the
one contained in this Event.  Changes made to the original object
instance (such as resetting attribute values) will <em>not affect the
instance in the Event</em>.  In addition, the caller should make sure
to free the original object if it is no longer being used, or else a
memory leak will result.  Please see Event::createEventAssignment()
for a method that does not lead to these issues.
@see createEventAssignment()


=item Event::createEventAssignment

Creates a new, empty EventAssignment, adds it to this Event's list of
event assignments and returns the EventAssignment.
Returns the newly created EventAssignment object instance
@see addEventAssignment(const EventAssignment  ea)


=item Event::createTrigger

Creates a new, empty Trigger, adds it to this Event and 
returns the Trigger.
Returns the newly created Trigger object instance


=item Event::createDelay

Creates a new, empty Delay, adds it to this Event and 
returns the Delay.
Returns the newly created Delay object instance


=item Event::createPriority

(SBML Level&nbsp;3 only) Creates a new, empty Priority, adds it to this
Event and returns the Priority.
Returns the newly created Priority object instance
@note The element "priority" is available in SBML Level&nbsp;3
Version&nbsp;1 Core, but is not present in lower Levels of SBML.


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
Returns the list of EventAssignments for this Event.


=item Event::getListOfEventAssignments

Returns the list of event assignments for this Event.
Returns the list of EventAssignments for this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return
Returns the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return a specific EventAssignment object of this Event.
@param n an integer, the index of the EventAssignment object to return
Returns the C<n>th EventAssignment of this Event.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
Returns the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getEventAssignment

Return the event assignment indicated by the given C<variable>.
@param variable a string, the identifier of the variable whose
EventAssignment is being sought.
Returns the EventAssignment for the given C<variable>, or C<NULL> if
no such EventAssignment exits.


=item Event::getNumEventAssignments

Returns the number of EventAssignment objects attached to this
Event.

Returns the number of EventAssignments in this Event.


=item Event::removeEventAssignment

Removes the nth EventAssignment object from this Event object and
returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
@param n the index of the EventAssignment object to remove
Returns the EventAssignment object removed.  As mentioned above, 
the caller owns the returned item. C<NULL> is returned if the given index 
is out of range.


=item Event::removeEventAssignment

Removes the EventAssignment object with the given "variable" attribute 
from this Event object and returns a pointer to it.
The caller owns the returned object and is responsible for deleting it.
If none of the EventAssignment objects in this Event object have the 
"variable" attribute C<variable>, then C<NULL> is returned.
@param variable the "variable" attribute of the EventAssignment object 
to remove
Returns the EventAssignment object removed.  As mentioned above, the 
caller owns the returned object. C<NULL> is returned if no EventAssignment
object with the "variable" attribute exists in this Event object.


=item Event::setSBMLDocument

@internal

Sets the parent SBMLDocument of this SBML object.
@param d the SBMLDocument to use


=item Event::connectToChild

@internal

Sets this SBML object to child SBML objects (if any).
(Creates a child-parent relationship by the parent)
Subclasses must override this function if they define
one ore more child elements.
Basically, this function needs to be called in
constructor, copy constructor and assignment operator.
@see setSBMLDocument
@see enablePackageInternal


=item Event::enablePackageInternal

@internal

Enables/Disables the given package with this element and child
elements (if any).
(This is an internal implementation for enablePackage function)
@note Subclasses of the SBML Core package in which one or more child
elements are defined must override this function.


=item Event::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item Event::getElementName

Returns the XML element name of this object, which for Event, is
always C<"event">.
Returns the name of this element, i.e., C<"event">.


=item Event::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item Event::setInternalIdOnly

@internal

sets the mInternalIdOnly flag


=item Event::hasRequiredAttributes

Predicate returning C<true> if all the required attributes for this
Event object have been set.
@note The required attributes for a Event object are:
@li "useValuesfromTriggerTime" (required in SBML Level&nbsp;3)


=item Event::hasRequiredElements

Predicate returning C<true> if
all the required elements for this Event object
have been set.
@note The required elements for a Event object are:
@li "trigger"
@li "listOfEventAssignments" (required in SBML Level&nbsp;2, optional in Level&nbsp;3)


=item Event::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=item Event::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item Event::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Event::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Event::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item Event::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item Event::isExplicitlySetUVFTT

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfEvents::ListOfEvents

Creates a new ListOfEvents object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfEvents::ListOfEvents

Creates a new ListOfEvents object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfEvents object to be created.


=item ListOfEvents::clone

Creates and returns a deep copy of this ListOfEvents.
Returns a (deep) copy of this ListOfEvents.


=item ListOfEvents::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfEvents::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., Event objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfEvents::getElementName

Returns the XML element name of this object.
For ListOfEvents, the XML element name is C<"listOfEvents">.
Returns the name of this element, i.e., C<"listOfEvents">.


=item ListOfEvents::get

Get a Event from the ListOfEvents.
@param n the index number of the Event to get.
Returns the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents.
@param n the index number of the Event to get.
Returns the C<n>th Event in this ListOfEvents.
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
Returns Event in this ListOfEvents
with the given id or C<NULL> if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::get

Get a Event from the ListOfEvents
based on its identifier.
@param sid a string representing the identifier 
of the Event to get.
Returns Event in this ListOfEvents
with the given id or C<NULL> if no such
Event exists.
@see get(unsigned int n)
@see size()


=item ListOfEvents::remove

Removes the nth item from this ListOfEvents items and returns a pointer to
it.

The caller owns the returned item and is responsible for deleting it.
@param n the index of the item to remove
@see size()


=item ListOfEvents::remove

Removes item in this ListOfEvents items with the given identifier.
The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier C<sid>, then
C<NULL> is returned.
@param sid the identifier of the item to remove
Returns the item removed.  As mentioned above, the caller owns the
returned item.


=item ListOfEvents::getElementPosition

@internal

Get the ordinal position of this element in the containing object
(which in this case is the Model object).
The ordering of elements in the XML form of SBML is generally fixed
for most components in SBML.  So, for example, the ListOfEvents in a
model is (in SBML Level&nbsp;2 Version&nbsp;4) the twelfth ListOf___.
(However, it differs for different Levels and Versions of SBML, so
calling code should not hardwire this number.)
Returns the ordinal position of the element with respect to its
siblings, or C<-1> (default) to indicate the position is not significant.


=item ListOfEvents::createObject

@internal

Returns the SBML object corresponding to next XMLToken in the
XMLInputStream or C<NULL> if the token was not recognized.


=back

=head2 EventAssignment

LibSBML implementation of SBML's EventAssignment construct for Event.
Event contains an optional element called "listOfEventAssignments", of
class ListOfEventAssignments.  In every instance of an event definition
in a model, the object's "listOfEventAssignments" element must have a
non-empty list of one or more "eventAssignment" elements of class
EventAssignment.  The object class EventAssignment has one required
attribute, "variable", and a required element, "math".  Being derived
from SBase, it also has all the usual attributes and elements of its
parent class.
An Event object defines when the event can occur, the variables that are
affected by the event, and how the variables are affected.  The purpose
of the EventAssignment object class is to define how variables are
affected by an Event.  In SBML Level&nbsp;2, every Event object instance
must have a nonempty list of event assignments; in SBML Level&nbsp;3,
the list of assignments is optional.
The operation of an Event is divided into two phases (regardless of
whether a delay is involved): one phase when the event is I<triggered>,
and the other when the event is I<executed>.   EventAssignment objects
are interpreted when an event is executed.  The effects are described
below.

@section event-variable The attribute "variable"
The EventAssignment attribute "variable" must be the identifier of an
existing Compartment, Species, SpeciesReference, or Parameter
instance defined in the model.  When the event is executed, the value of
the model component identified by "variable" is changed by the
EventAssignment to the value computed by the "math" element; that is, a
species' quantity, species reference's stoichiometry, compartment's size
or parameter's value are reset to the value computed by "math".
Certain restrictions are placed on what can appear in "variable":

=over


=item

The object identified by the value of the EventAssignment attribute
"variable" must not have its "constant" attribute set to or default to
C<true>.  (Constants cannot be affected by events.)

=item

The "variable" attribute must not contain the identifier of a
reaction; only species, species references, compartment and parameter
values may be set by an Event.

=item

The value of every "variable" attribute must be unique among the set
of EventAssignment structures within a given Event structure.  In other
words, a single event cannot have multiple EventAssignment objects
assigning the same variable.  (All of them would be performed at the
same time when that particular Event triggers, resulting in
indeterminacy.)  However, I<separate> Event instances can refer to the
same variable.

=item

A variable cannot be assigned a value in an EventAssignment object
instance and also be assigned a value by an AssignmentRule; i.e., the
value of an EventAssignment's "variable" attribute cannot be the same as
the value of a AssignmentRule' "variable" attribute.  (Assignment rules
hold at all times, therefore it would be inconsistent to also define an
event that reassigns the value of the same variable.)

=back


Note that the time of assignment of the object identified by the
value of the "variable" attribute is always the time at which the Event
is <em>executed</em>, not when it is <em>triggered</em>.  The timing is
controlled by the optional Delay in an Event.  The time of
assignment is not affected by the "useValuesFromTriggerTime"
attribute on Event&mdash;that attribute affects the time at which the
EventAssignment's "math" expression is I<evaluated>.  In other
words, SBML allows decoupling the time at which the
"variable" is assigned from the time at which its value
expression is calculated.
@section event-math The "math" subelement in an EventAssignment
The MathML expression contained in an EventAssignment defines the new
value of the variable being assigned by the Event.
As mentioned above, the time at which the expression in "math" is
evaluated is determined by the attribute "useValuesFromTriggerTime" on
Event.  If the attribute value is C<true>, the expression must be
evaluated when the event is I<triggered>; more precisely, the values of
identifiers occurring in MathML C<&lt;ci&gt;> elements in the
EventAssignment's "math" expression are the values they have at the
point when the event I<triggered>.  If, instead,
"useValuesFromTriggerTime"'s value is C<false>, it means the values at
I<execution> time should be used; that is, the values of identifiers
occurring in MathML C<&lt;ci&gt;> elements in the
EventAssignment's "math" expression are the values they have at the
point when the event I<executed>.
@section version-diffs SBML Level/Version differences
Between Version&nbsp;4 and previous versions of SBML Level&nbsp;2, the
requirements regarding the matching of units between an
EvengAssignment's formula and the units of the object identified by the
"variable" attribute changed.  Previous versions required consistency,
but in SBML Level&nbsp;2 Version&nbsp;4 and in SBML Level&nbsp;3, unit
consistency is only I<recommended>.  More precisely:

=over



=item

In the case of a species, an EventAssignment sets the referenced
species' quantity (concentration or amount of substance) to the value
determined by the formula in the EventAssignment's "math" subelement.
The units of the "math" formula should (in SBML Level&nbsp;2
Version&nbsp;4 and in Level&nbsp;3) or must (in previous Versions of
Level&nbsp;2) be identical to the units of the species.

=item

(SBML Level&nbsp;3 only.) In the case of a species reference, an
EventAssignment sets the stoichiometry of the reactant or product
referenced by the SpeciesReference object to the value determined by the
formula in the "math" element.  The unit associated with the value
produced by the "math" formula should be C<dimensionless>, because
reactant and product stoichiometries in reactions are dimensionless
quantities.


=item

In the case of a compartment, an EventAssignment sets the
referenced compartment's size to the size determined by the formula in
the "math" subelement of the EventAssignment.  The overall units of the
formula should (in SBML Level&nbsp;2 Version&nbsp;4 and in Level&nbsp;3)
or must (in previous Versions of Level&nbsp;2) be identical to the units
specified for the size of the compartment identified by the
EventAssignment's "variable" attribute.

=item

In the case of a parameter, an EventAssignment sets the referenced
parameter's value to that determined by the formula in "math".  The
overall units of the formula should (in SBML Level&nbsp;2 Version&nbsp;4
and Level&nbsp;3) or must (in previous Versions of Level&nbsp;2) be
identical to the units defined for the parameter.

=back


Note that the formula placed in the "math" element <em>has no assumed
units</em>.  The consistency of the units of the formula, and the units
of the entity which the assignment affects, must be explicitly
established just as in the case of the value of the Delay subelement.
An approach similar to the one discussed in the context of Delay may be
used for the formula of an EventAssignment.
@see Event

=over


=back

=head2 ListOfEventAssignments

LibSBML implementation of SBML's ListOfEventAssignments construct.
The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  All are derived from
the abstract class SBase, and inherit the various attributes and
subelements of SBase, such as "metaid" as and "annotation".  The
ListOf___ classes do not add any attributes of their own.
ListOfEventAssignments is entirely contained within Event.

=over


=item EventAssignment::EventAssignment

Creates a new EventAssignment using the given SBML C<level> and C<version>
values.

@param level an unsigned int, the SBML Level to assign to this EventAssignment
@param version an unsigned int, the SBML Version to assign to this
EventAssignment

@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a EventAssignment object to an SBMLDocument
(e.g., using Event::addEventAssignment(@if java EventAssignment ea@endif)), 
the SBML Level, SBML Version and XML namespace of the document @em
override the values used when creating the EventAssignment object via
this constructor.  This is necessary to ensure that an SBML document
is a consistent structure.  Nevertheless, the ability to supply the
values at the time of creation of a EventAssignment is an important
aid to producing valid SBML.  Knowledge of the intented SBML Level and
Version determine whether it is valid to assign a particular value to
an attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item EventAssignment::EventAssignment

Creates a new EventAssignment using the given SBMLNamespaces object
C<sbmlns>.
The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
A common approach to using this class constructor is to create an
SBMLNamespaces object somewhere in a program, once, then pass it to
object constructors such as this one when needed.
@param sbmlns an SBMLNamespaces object.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the given C<level> and C<version> combination, or this kind
of SBML object, are either invalid or mismatched with respect to the
parent SBMLDocument object.
@note Upon the addition of a EventAssignment object to an SBMLDocument
(e.g., using Event::addEventAssignment(@if java EventAssignment ea@endif)),
the SBML XML namespace of the document I<overrides> the value used
when creating the EventAssignment object via this constructor.  This
is necessary to ensure that an SBML document is a consistent
structure.  Nevertheless, the ability to supply the values at the time
of creation of a EventAssignment is an important aid to producing
valid SBML.  Knowledge of the intented SBML Level and Version
determine whether it is valid to assign a particular value to an
attribute, or whether it is valid to add an object to an existing
SBMLDocument.


=item EventAssignment::EventAssignment

Copy constructor; creates a copy of this EventAssignment.
@param orig the object to copy.
@throws @if python ValueError @else SBMLConstructorException @endif@~
Thrown if the argument C<orig> is C<NULL>.


=item EventAssignment::accept

Accepts the given SBMLVisitor for this instance of EventAssignment.
@param v the SBMLVisitor instance to be used.
Returns the result of calling C<v.visit()>, which indicates
whether the Visitor would like to visit the next EventAssignment in
the list within which this EventAssignment is embedded (i.e., in the
ListOfEventAssignments located in the enclosing Event instance).


=item EventAssignment::clone

Creates and returns a deep copy of this EventAssignment.
Returns a (deep) copy of this EventAssignment.


=item EventAssignment::getVariable

Get the value of this EventAssignment's "variable" attribute.
Returns the identifier stored in the "variable" attribute of this
EventAssignment.


=item EventAssignment::getMath

Get the mathematical expression in this EventAssignment's "math"
subelement.

Returns the top ASTNode of an abstract syntax tree representing the
mathematical formula in this EventAssignment.


=item EventAssignment::isSetVariable

Predicate for testing whether the attribute "variable" of this
EventAssignment is set.
Returns C<true> if the "variable" attribute of this EventAssignment
is set, C<false> otherwise.


=item EventAssignment::isSetMath

Predicate for testing whether the "math" subelement of this
EventAssignment is set.
Returns C<true> if this EventAssignment has a "math" subelement,
C<false> otherwise.


=item EventAssignment::setVariable

Sets the attribute "variable" of this EventAssignment to a copy of
the given identifier string.
@param sid the identifier of a Compartment, Species or (global)
Parameter defined in this model.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink


=item EventAssignment::setMath

Sets the "math" subelement of this EventAssignment to a copy of the
given ASTNode.
@param math an ASTNode that will be copied and stored as the
mathematical formula for this EventAssignment.
Returns integer value indicating success/failure of the
function.  @if clike The value is drawn from the
enumeration #OperationReturnValues_t. @endif@~ The possible values
returned by this function are:
@li @link OperationReturnValues_t#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
@li @link OperationReturnValues_t#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink


=item EventAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
EventAssignment.

The units are calculated based on the mathematical expression in the
EventAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
EventAssignment::getDerivedUnitDefinition() method returns the
calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
EventAssignment contains literal numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
EventAssignment::getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When
using this method, <strong>it is critical that callers also invoke the
method</strong> EventAssignment::containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers should take
suitable action in those situations.
Returns a UnitDefinition that expresses the units of the math 
expression of this EventAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item EventAssignment::getDerivedUnitDefinition

Calculates and returns a UnitDefinition that expresses the units
of measurement assumed for the "math" expression of this
EventAssignment.

The units are calculated based on the mathematical expression in the
EventAssignment and the model quantities referenced by
C<&lt;ci&gt;> elements used within that expression.  The
EventAssignment::getDerivedUnitDefinition() method returns the
calculated units.
Note that the functionality that facilitates unit analysis depends 
on the model as a whole.  Thus, in cases where the object has not 
been added to a model or the model itself is incomplete,
unit analysis is not possible and this method will return C<NULL>.
@warning Note that it is possible the "math" expression in the
EventAssignment contains literal numbers or parameters with undeclared
units.  In those cases, it is not possible to calculate the units of
the overall expression without making assumptions.  LibSBML does not
make assumptions about the units, and
EventAssignment::getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression
<em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
<em>Y</em> does not, it will return the units of <em>X</em>.  When
using this method, <strong>it is critical that callers also invoke the
method</strong> EventAssignment::containsUndeclaredUnits() <strong>to
determine whether this situation holds</strong>.  Callers should take
suitable action in those situations.
Returns a UnitDefinition that expresses the units of the math 
expression of this EventAssignment, or C<NULL> if one cannot be constructed.
@see containsUndeclaredUnits()


=item EventAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math
expression of this EventAssignment contains literal numbers or
parameters with undeclared units.
The EventAssignment::getDerivedUnitDefinition() method returns what
libSBML computes to be the units of the "math", to the extent that
libSBML can compute them.  However, if the expression contains literal
numbers or parameters with undeclared units, libSBML may not be able
to compute the full units of the expression and will only return what
it can compute.  Callers should always use
EventAssignment::containsUndeclaredUnits() when using
EventAssignment::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
Returns C<true> if the math expression of this EventAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by EventAssignment::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item EventAssignment::containsUndeclaredUnits

Predicate returning C<true> if the math
expression of this EventAssignment contains literal numbers or
parameters with undeclared units.
The EventAssignment::getDerivedUnitDefinition() method returns what
libSBML computes to be the units of the "math", to the extent that
libSBML can compute them.  However, if the expression contains literal
numbers or parameters with undeclared units, libSBML may not be able
to compute the full units of the expression and will only return what
it can compute.  Callers should always use
EventAssignment::containsUndeclaredUnits() when using
EventAssignment::getDerivedUnitDefinition() to decide whether the
returned units may be incomplete.
Returns C<true> if the math expression of this EventAssignment
includes parameters/numbers 
with undeclared units, C<false> otherwise.
@note A return value of C<true> indicates that the UnitDefinition
returned by EventAssignment::getDerivedUnitDefinition() may not
accurately represent the units of the expression.
@see getDerivedUnitDefinition()


=item EventAssignment::getTypeCode

Returns the libSBML type code of this object instance.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item EventAssignment::getElementName

Returns the XML element name of this object, which for
EventAssignment, is always C<"eventAssignment">.
Returns the name of this element, i.e., C<"eventAssignment">.


=item EventAssignment::writeElements

@internal

Subclasses should override this method to write out their contained
SBML objects as XML elements.  Be sure to call your parents
implementation of this method as well.


=item EventAssignment::hasRequiredAttributes

Predicate returning C<true> if
all the required attributes for this EventAssignment object
have been set.
@note The required attributes for a EventAssignment object are:
@li "variable"
Returns a boolean value indicating whether all the required
attributes for this object have been defined.


=item EventAssignment::hasRequiredElements

Predicate returning C<true> if
all the required elements for this EventAssignment object
have been set.
@note The required elements for a EventAssignment object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item EventAssignment::getId

@internal

Predicate returning C<true> if
all the required elements for this EventAssignment object
have been set.
@note The required elements for a EventAssignment object are:
@li "math"
Returns a boolean value indicating whether all the required
elements for this object have been defined.


=item EventAssignment::renameSIdRefs

Renames all the SIdRef attributes on this element, including any found in MathML


=item EventAssignment::renameUnitSIdRefs

Renames all the UnitSIdRef attributes on this element


=item EventAssignment::replaceSIDWithFunction

@internal

Replace all nodes with the name 'id' from the child 'math' object with the provided function.


=item EventAssignment::divideAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing/function).


=item EventAssignment::multiplyAssignmentsToSIdByFunction

@internal

If this assignment assigns a value to the 'id' element, replace the 'math' object with the function (existing function).


=item EventAssignment::readOtherXML

@internal

Subclasses should override this method to read (and store) XHTML,
MathML, etc. directly from the XMLInputStream.
Returns true if the subclass read from the stream, false otherwise.


=item EventAssignment::addExpectedAttributes

@internal

Subclasses should override this method to get the list of
expected attributes.
This function is invoked from corresponding readAttributes()
function.


=item EventAssignment::readAttributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item EventAssignment::readL2Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item EventAssignment::readL3Attributes

@internal

Subclasses should override this method to read values from the given
XMLAttributes set into their specific fields.  Be sure to call your
parents implementation of this method as well.


=item EventAssignment::writeAttributes

@internal

Subclasses should override this method to write their XML attributes
to the XMLOutputStream.  Be sure to call your parents implementation
of this method as well.


=item ListOfEventAssignments::ListOfEventAssignments

Creates a new ListOfEventAssignments object.
The object is constructed such that it is valid for the given SBML
Level and Version combination.
@param level the SBML Level
@param version the Version within the SBML Level


=item ListOfEventAssignments::ListOfEventAssignments

Creates a new ListOfEventAssignments object.
The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in @p
sbmlns.

@param sbmlns an SBMLNamespaces object that is used to determine the
characteristics of the ListOfEventAssignments object to be created.


=item ListOfEventAssignments::clone

Creates and returns a deep copy of this ListOfEventAssignments.
Returns a (deep) copy of this ListOfEventAssignments.


=item ListOfEventAssignments::getTypeCode

Returns the libSBML type code for this SBML object.
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfEventAssignments::getItemTypeCode

Returns the libSBML type code for the objects contained in this ListOf
(i.e., EventAssignment objects, if the list is non-empty).
@if clike LibSBML attaches an identifying code to every kind of SBML
object.  These are known as <em>SBML type codes</em>.  The set of
possible type codes is defined in the enumeration #SBMLTypeCode_t.
The names of the type codes all begin with the characters @c
SBML_. @endif@if java LibSBML attaches an identifying code to every
kind of SBML object.  These are known as <em>SBML type codes</em>.  In
other languages, the set of type codes is stored in an enumeration; in
the Java language interface for libSBML, the type codes are defined as
static integer constants in the interface class {@link
libsbmlConstants}.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if python LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the Python language interface for libSBML, the type
codes are defined as static integer constants in the interface class
@link libsbml@endlink.  The names of the type codes all begin with the
characters C<SBML_>. @endif@if csharp LibSBML attaches an identifying
code to every kind of SBML object.  These are known as <em>SBML type
codes</em>.  In the C# language interface for libSBML, the type codes
are defined as static integer constants in the interface class @link
libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
the characters C<SBML_>. @endif@~
Returns the SBML type code for the objects contained in this ListOf
instance, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
@see getElementName()


=item ListOfEventAssignments::getElementName

Returns the XML element name of this object.
For ListOfEventAssignments, the XML element name is @c
"listOfEventAssignments".

Returns the name of this element, i.e., C<"listOfEventAssignments">.


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
Returns the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments.
@param n the index number of the EventAssignment to get.
Returns the nth EventAssignment in this ListOfEventAssignments.
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
Returns EventAssignment in this ListOfEventAssignments
with the given id or C<NULL> if no such
EventAssignment exists.
@see get(unsigned int n)
@see size()


=item ListOfEventAssignments::get

Get a EventAssignment from the ListOfEventAssignments
based on its identifier.
@param sid a string representing the identifier 
of the EventAssignment to get.
Returns EventAssignment in this ListOfEventAssi