#ifndef SBSMS_SINCCOEFFS_H
#define SBSMS_SINCCOEFFS_H

#include "sbsms.h"
#define SBSMS_SINC_SIZE 4096
#ifdef SBSMS_REAL_FLOAT
#define SBSMS_SINC_RES 128.0f
#define SBSMS_SINC_SAMPLES 32.0f
#else
#define SBSMS_SINC_RES 128.0
#define SBSMS_SINC_SAMPLES 32.0
#endif

namespace _sbsms_ {
real sincTable[SBSMS_SINC_SIZE] = 
{
0.9489208574f,
0.9488349531f,
0.9485772683f,
0.9481478871f,
0.9475469497f,
0.9467746523f,
0.9458312468f,
0.9447170414f,
0.9434323995f,
0.9419777403f,
0.9403535385f,
0.9385603238f,
0.936598681f,
0.9344692496f,
0.9321727239f,
0.9297098522f,
0.9270814368f,
0.9242883338f,
0.9213314525f,
0.9182117552f,
0.9149302568f,
0.9114880246f,
0.9078861774f,
0.9041258854f,
0.90020837f,
0.8961349027f,
0.891906805f,
0.8875254479f,
0.8829922513f,
0.8783086834f,
0.87347626f,
0.8684965444f,
0.8633711463f,
0.8581017213f,
0.8526899703f,
0.847137639f,
0.8414465169f,
0.8356184369f,
0.8296552745f,
0.8235589469f,
0.8173314126f,
0.8109746702f,
0.8044907582f,
0.7978817536f,
0.7911497716f,
0.7842969645f,
0.777325521f,
0.7702376654f,
0.7630356564f,
0.7557217867f,
0.748298382f,
0.7407677998f,
0.7331324289f,
0.7253946882f,
0.7175570259f,
0.7096219186f,
0.7015918703f,
0.6934694113f,
0.6852570975f,
0.6769575094f,
0.6685732507f,
0.6601069479f,
0.651561249f,
0.6429388223f,
0.6342423559f,
0.6254745562f,
0.616638147f,
0.6077358688f,
0.5987704771f,
0.5897447421f,
0.5806614471f,
0.5715233878f,
0.5623333709f,
0.5530942134f,
0.5438087414f,
0.5344797889f,
0.5251101971f,
0.515702813f,
0.5062604882f,
0.4967860785f,
0.4872824421f,
0.477752439f,
0.4681989299f,
0.4586247749f,
0.4490328324f,
0.4394259586f,
0.4298070059f,
0.4201788219f,
0.4105442486f,
0.4009061212f,
0.3912672672f,
0.381630505f,
0.3719986434f,
0.36237448f,
0.3527608008f,
0.3431603787f,
0.3335759726f,
0.3240103267f,
0.3144661691f,
0.3049462109f,
0.2954531457f,
0.285989648f,
0.2765583725f,
0.2671619533f,
0.2578030027f,
0.2484841105f,
0.2392078431f,
0.2299767423f,
0.2207933249f,
0.2116600811f,
0.2025794745f,
0.1935539406f,
0.1845858863f,
0.1756776889f,
0.1668316953f,
0.1580502213f,
0.1493355509f,
0.1406899351f,
0.1321155916f,
0.1236147041f,
0.115189421f,
0.1068418553f,
0.09857408356f,
0.09038814547f,
0.08228604295f,
0.0742697396f,
0.06634116013f,
0.05850218966f,
0.05075467317f,
0.04310041494f,
0.03554117794f,
0.02807868333f,
0.02071460994f,
0.01345059374f,
0.006288227356f,
-0.0007709403579f,
-0.007725404808f,
-0.01457370607f,
-0.0213144293f,
-0.02794620512f,
-0.03446771f,
-0.0408776666f,
-0.04717484409f,
-0.05335805848f,
-0.0594261729f,
-0.06537809786f,
-0.07121279152f,
-0.07692925991f,
-0.08252655716f,
-0.08800378565f,
-0.09336009623f,
-0.09859468831f,
-0.1037068101f,
-0.1086957585f,
-0.1135608795f,
-0.118301568f,
-0.1229172679f,
-0.1274074724f,
-0.1317717236f,
-0.1360096126f,
-0.1401207797f,
-0.1441049143f,
-0.1479617544f,
-0.1516910871f,
-0.1552927482f,
-0.1587666221f,
-0.1621126416f,
-0.1653307877f,
-0.1684210897f,
-0.1713836247f,
-0.1742185174f,
-0.1769259401f,
-0.1795061119f,
-0.1819592992f,
-0.1842858147f,
-0.1864860173f,
-0.1885603121f,
-0.1905091495f,
-0.1923330251f,
-0.1940324793f,
-0.1956080971f,
-0.197060507f,
-0.1983903815f,
-0.1995984358f,
-0.2006854277f,
-0.2016521573f,
-0.2024994661f,
-0.2032282367f,
-0.2038393922f,
-0.2043338957f,
-0.2047127496f,
-0.2049769951f,
-0.2051277118f,
-0.2051660168f,
-0.2050930642f,
-0.2049100442f,
-0.2046181832f,
-0.2042187421f,
-0.2037130165f,
-0.2031023356f,
-0.2023880616f,
-0.2015715887f,
-0.2006543431f,
-0.1996377813f,
-0.1985233903f,
-0.1973126861f,
-0.1960072133f,
-0.1946085446f,
-0.1931182791f,
-0.1915380427f,
-0.1898694862f,
-0.1881142854f,
-0.1862741396f,
-0.1843507711f,
-0.1823459244f,
-0.1802613653f,
-0.1780988801f,
-0.1758602745f,
-0.1735473732f,
-0.1711620186f,
-0.1687060704f,
-0.1661814041f,
-0.163589911f,
-0.1609334964f,
-0.1582140794f,
-0.1554335917f,
-0.152593977f,
-0.1496971898f,
-0.1467451946f,
-0.1437399653f,
-0.1406834838f,
-0.1375777397f,
-0.134424729f,
-0.1312264534f,
-0.1279849194f,
-0.1247021373f,
-0.1213801205f,
-0.1180208845f,
-0.1146264463f,
-0.1111988228f,
-0.1077400311f,
-0.1042520864f,
-0.100737002f,
-0.09719678809f,
-0.09363345105f,
-0.09004899244f,
-0.08644540825f,
-0.08282468809f,
-0.07918881432f,
-0.07553976126f,
-0.07187949434f,
-0.06820996933f,
-0.06453313152f,
-0.06085091494f,
-0.05716524156f,
-0.05347802055f,
-0.04979114748f,
-0.0461065036f,
-0.04242595507f,
-0.03875135222f,
-0.03508452884f,
-0.03142730149f,
-0.02778146873f,
-0.02414881049f,
-0.02053108735f,
-0.01693003988f,
-0.01334738799f,
-0.009784830282f,
-0.006244043388f,
-0.002726681379f,
0.0007656248602f,
0.004231268228f,
0.007668665991f,
0.01107626035f,
0.01445251902f,
0.01779593573f,
0.0211050308f,
0.02437835165f,
0.02761447327f,
0.03081199875f,
0.0339695597f,
0.03708581679f,
0.04015946009f,
0.0431892096f,
0.04617381557f,
0.04911205897f,
0.05200275182f,
0.05484473759f,
0.0576368915f,
0.06037812093f,
0.06306736564f,
0.06570359817f,
0.06828582404f,
0.07081308206f,
0.07328444457f,
0.07569901768f,
0.07805594149f,
0.08035439028f,
0.0825935727f,
0.08477273195f,
0.08689114591f,
0.08894812733f,
0.09094302386f,
0.09287521824f,
0.09474412836f,
0.09654920729f,
0.09828994341f,
0.09996586038f,
0.1015765172f,
0.1031215083f,
0.1046004632f,
0.106013047f,
0.1073589599f,
0.1086379374f,
0.1098497499f,
0.1109942033f,
0.1120711379f,
0.1130804291f,
0.1140219871f,
0.1148957562f,
0.1157017155f,
0.1164398779f,
0.1171102906f,
0.1177130342f,
0.1182482232f,
0.1187160049f,
0.1191165601f,
0.1194501021f,
0.1197168766f,
0.1199171616f,
0.1200512669f,
0.1201195338f,
0.1201223346f,
0.1200600728f,
0.119933182f,
0.1197421261f,
0.1194873985f,
0.119169522f,
0.1187890481f,
0.118346557f,
0.1178426568f,
0.117277983f,
0.1166531983f,
0.1159689921f,
0.1152260798f,
0.1144252025f,
0.1135671266f,
0.1126526428f,
0.1116825664f,
0.1106577357f,
0.1095790127f,
0.1084472814f,
0.1072634479f,
0.1060284398f,
0.1047432055f,
0.1034087134f,
0.1020259519f,
0.1005959283f,
0.09911966823f,
0.09759821536f,
0.09603263055f,
0.09442399127f,
0.09277339101f,
0.09108193863f,
0.08935075774f,
0.08758098608f,
0.08577377483f,
0.08393028804f,
0.08205170191f,
0.08013920422f,
0.07819399361f,
0.07621727898f,
0.07421027878f,
0.07217422044f,
0.07011033962f,
0.06801987962f,
0.0659040907f,
0.0637642294f,
0.06160155791f,
0.05941734343f,
0.05721285746f,
0.05498937516f,
0.05274817474f,
0.05049053675f,
0.04821774343f,
0.0459310781f,
0.04363182448f,
0.04132126605f,
0.03900068539f,
0.03667136357f,
0.03433457949f,
0.03199160928f,
0.0296437256f,
0.02729219709f,
0.02493828772f,
0.02258325616f,
0.0202283552f,
0.01787483112f,
0.01552392311f,
0.01317686268f,
0.01083487306f,
0.008499168625f,
0.006170954345f,
0.003851425201f,
0.001541765637f,
-0.0007568509855f,
-0.00304326293f,
-0.005316320614f,
-0.007574887132f,
-0.009817838766f,
-0.0120440655f,
-0.01425247149f,
-0.01644197561f,
-0.01861151183f,
-0.02076002981f,
-0.02288649523f,
-0.02498989035f,
-0.02706921436f,
-0.02912348388f,
-0.03115173333f,
-0.03315301536f,
-0.03512640124f,
-0.03707098124f,
-0.03898586505f,
-0.04087018206f,
-0.0427230818f,
-0.04454373424f,
-0.04633133011f,
-0.04808508126f,
-0.04980422091f,
-0.05148800399f,
-0.05313570741f,
-0.05474663032f,
-0.05632009437f,
-0.05785544395f,
-0.05935204646f,
-0.06080929245f,
-0.0622265959f,
-0.06360339439f,
-0.06493914925f,
-0.06623334576f,
-0.06748549332f,
-0.06869512553f,
-0.06986180039f,
-0.07098510034f,
-0.07206463245f,
-0.07310002845f,
-0.07409094479f,
-0.07503706279f,
-0.07593808861f,
-0.07679375332f,
-0.07760381295f,
-0.07836804846f,
-0.07908626578f,
-0.07975829581f,
-0.08038399433f,
-0.08096324205f,
-0.08149594452f,
-0.08198203207f,
-0.08242145977f,
-0.08281420729f,
-0.08316027888f,
-0.08345970321f,
-0.08371253324f,
-0.08391884615f,
-0.08407874315f,
-0.08419234931f,
-0.08425981345f,
-0.08428130792f,
-0.0842570284f,
-0.08418719374f,
-0.08407204572f,
-0.08391184882f,
-0.08370689f,
-0.08345747846f,
-0.08316394537f,
-0.0828266436f,
-0.08244594746f,
-0.08202225241f,
-0.08155597477f,
-0.08104755138f,
-0.08049743935f,
-0.07990611569f,
-0.07927407699f,
-0.07860183909f,
-0.07788993671f,
-0.07713892315f,
-0.07634936986f,
-0.0755218661f,
-0.07465701859f,
-0.07375545106f,
-0.07281780393f,
-0.07184473386f,
-0.07083691336f,
-0.06979503038f,
-0.0687197879f,
-0.06761190349f,
-0.06647210889f,
-0.06530114955f,
-0.06409978423f,
-0.06286878451f,
-0.06160893436f,
-0.06032102969f,
-0.05900587785f,
-0.05766429722f,
-0.05629711667f,
-0.05490517514f,
-0.05348932115f,
-0.0520504123f,
-0.0505893148f,
-0.04910690298f,
-0.04760405882f,
-0.04608167142f,
-0.04454063652f,
-0.04298185605f,
-0.04140623757f,
-0.03981469382f,
-0.0382081422f,
-0.03658750429f,
-0.03495370536f,
-0.03330767384f,
-0.03165034086f,
-0.02998263975f,
-0.02830550551f,
-0.02661987439f,
-0.02492668332f,
-0.02322686949f,
-0.0215213698f,
-0.01981112041f,
-0.01809705627f,
-0.01638011059f,
-0.0146612144f,
-0.01294129606f,
-0.01122128079f,
-0.009502090192f,
-0.007784641778f,
-0.006069848522f,
-0.004358618386f,
-0.002651853869f,
-0.000950451554f,
0.0007446983427f,
0.002432712411f,
0.004112714485f,
0.005783836079f,
0.007445216807f,
0.009096004812f,
0.01073535717f,
0.01236244032f,
0.01397643042f,
0.01557651381f,
0.01716188732f,
0.01873175872f,
0.02028534705f,
0.02182188301f,
0.02334060929f,
0.02484078095f,
0.02632166573f,
0.02778254444f,
0.02922271121f,
0.03064147386f,
0.0320381542f,
0.03341208833f,
0.03476262693f,
0.03608913553f,
0.03739099484f,
0.03866760095f,
0.03991836563f,
0.04114271658f,
0.04234009766f,
0.04350996913f,
0.04465180786f,
0.04576510758f,
0.04684937905f,
0.04790415027f,
0.04892896667f,
0.04992339128f,
0.0508870049f,
0.05181940627f,
0.05272021218f,
0.05358905766f,
0.05442559606f,
0.05522949919f,
0.05600045744f,
0.05673817982f,
0.05744239411f,
0.05811284689f,
0.05874930364f,
0.05935154875f,
0.05991938562f,
0.06045263661f,
0.06095114318f,
0.06141476578f,
0.06184338395f,
0.06223689626f,
0.06259522029f,
0.06291829267f,
0.06320606894f,
0.06345852361f,
0.06367565003f,
0.06385746037f,
0.06400398551f,
0.06411527501f,
0.06419139697f,
0.06423243795f,
0.06423850288f,
0.06420971489f,
0.06414621524f,
0.06404816316f,
0.0639157357f,
0.06374912757f,
0.06354855101f,
0.06331423559f,
0.06304642803f,
0.06274539202f,
0.06241140804f,
0.0620447731f,
0.06164580061f,
0.06121482005f,
0.06075217685f,
0.06025823207f,
0.05973336219f,
0.05917795884f,
0.05859242857f,
0.05797719253f,
0.05733268626f,
0.05665935934f,
0.05595767515f,
0.05522811057f,
0.05447115566f,
0.05368731337f,
0.05287709923f,
0.05204104103f,
0.0511796785f,
0.05029356298f,
0.0493832571f,
0.04844933443f,
0.04749237918f,
0.04651298579f,
0.04551175864f,
0.04448931169f,
0.04344626811f,
0.04238325991f,
0.04130092762f,
0.04019991988f,
0.0390808931f,
0.03794451108f,
0.03679144464f,
0.03562237123f,
0.03443797454f,
0.03323894417f,
0.03202597516f,
0.0307997677f,
0.02956102665f,
0.02831046122f,
0.02704878453f,
0.02577671324f,
0.02449496715f,
0.02320426882f,
0.02190534315f,
0.02059891701f,
0.01928571882f,
0.0179664782f,
0.01664192552f,
0.01531279158f,
0.01397980714f,
0.01264370262f,
0.01130520762f,
0.009965050634f,
0.008623958586f,
0.007282656505f,
0.005941867122f,
0.004602310508f,
0.003264703698f,
0.001929760325f,
0.0005981902535f,
-0.0007293007828f,
-0.002052011538f,
-0.003369245612f,
-0.004680311801f,
-0.005984524449f,
-0.007281203791f,
-0.008569676296f,
-0.009849275003f,
-0.01111933986f,
-0.01237921804f,
-0.01362826428f,
-0.01486584121f,
-0.01609131963f,
-0.01730407887f,
-0.01850350705f,
-0.01968900141f,
-0.02085996859f,
-0.02201582493f,
-0.02315599672f,
-0.02427992052f,
-0.02538704339f,
-0.02647682318f,
-0.02754872875f,
-0.02860224025f,
-0.02963684936f,
-0.03065205947f,
-0.031647386f,
-0.03262235653f,
-0.03357651105f,
-0.03450940216f,
-0.03542059527f,
-0.03630966877f,
-0.03717621425f,
-0.03801983661f,
-0.03884015429f,
-0.03963679939f,
-0.04040941786f,
-0.04115766958f,
-0.04188122856f,
-0.04257978304f,
-0.04325303561f,
-0.04390070336f,
-0.04452251791f,
-0.04511822559f,
-0.04568758751f,
-0.0462303796f,
-0.04674639275f,
-0.04723543282f,
-0.04769732075f,
-0.04813189258f,
-0.04853899949f,
-0.04891850786f,
-0.04927029929f,
-0.04959427058f,
-0.0498903338f,
-0.05015841623f,
-0.05039846042f,
-0.0506104241f,
-0.05079428021f,
-0.05095001683f,
-0.05107763718f,
-0.05117715952f,
-0.05124861713f,
-0.05129205823f,
-0.0513075459f,
-0.05129515802f,
-0.05125498716f,
-0.0511871405f,
-0.05109173969f,
-0.05096892081f,
-0.05081883419f,
-0.05064164431f,
-0.05043752966f,
-0.05020668263f,
-0.04994930933f,
-0.04966562947f,
-0.04935587619f,
-0.04902029589f,
-0.04865914809f,
-0.04827270522f,
-0.04786125245f,
-0.04742508753f,
-0.04696452055f,
-0.04647987378f,
-0.04597148144f,
-0.04543968949f,
-0.04488485544f,
-0.04430734807f,
-0.04370754727f,
-0.04308584373f,
-0.04244263877f,
-0.04177834404f,
-0.04109338128f,
-0.0403881821f,
-0.03966318766f,
-0.03891884845f,
-0.038155624f,
-0.0373739826f,
-0.03657440102f,
-0.03575736427f,
-0.03492336526f,
-0.03407290453f,
-0.03320648997f,
-0.03232463651f,
-0.03142786586f,
-0.03051670615f,
-0.02959169168f,
-0.02865336261f,
-0.02770226464f,
-0.0267389487f,
-0.02576397068f,
-0.02477789108f,
-0.02378127472f,
-0.02277469042f,
-0.0217587107f,
-0.02073391147f,
-0.01970087166f,
-0.018660173f,
-0.01761239962f,
-0.01655813776f,
-0.01549797547f,
-0.01443250226f,
-0.0133623088f,
-0.0122879866f,
-0.01121012767f,
-0.01012932423f,
-0.009046168377f,
-0.007961251748f,
-0.006875165234f,
-0.005788498644f,
-0.004701840395f,
-0.003615777198f,
-0.002530893748f,
-0.001447772413f,
-0.0003669929259f,
0.0007108679144f,
0.001785236549f,
0.002855542955f,
0.00392122094f,
0.004981708435f,
0.006036447781f,
0.007084886011f,
0.008126475136f,
0.009160672416f,
0.01018694064f,
0.01120474838f,
0.01221357027f,
0.01321288728f,
0.01420218694f,
0.0151809636f,
0.01614871871f,
0.01710496104f,
0.01804920692f,
0.01898098048f,
0.0198998139f,
0.0208052476f,
0.0216968305f,
0.02257412025f,
0.02343668337f,
0.02428409556f,
0.02511594182f,
0.0259318167f,
0.02673132448f,
0.02751407935f,
0.0282797056f,
0.02902783778f,
0.0297581209f,
0.03047021057f,
0.03116377316f,
0.03183848595f,
0.03249403728f,
0.03313012668f,
0.033746465f,
0.03434277453f,
0.03491878912f,
0.03547425429f,
0.03600892733f,
0.03652257738f,
0.03701498554f,
0.03748594495f,
0.03793526084f,
0.03836275065f,
0.038768244f,
0.03915158287f,
0.03951262152f,
0.03985122665f,
0.04016727735f,
0.04046066517f,
0.04073129414f,
0.04097908079f,
0.04120395416f,
0.0414058558f,
0.04158473977f,
0.04174057265f,
0.04187333351f,
0.0419830139f,
0.04206961781f,
0.04213316165f,
0.04217367422f,
0.04219119664f,
0.04218578229f,
0.04215749681f,
0.04210641794f,
0.04203263553f,
0.04193625141f,
0.04181737932f,
0.04167614481f,
0.04151268515f,
0.0413271492f,
0.04111969731f,
0.04089050121f,
0.04063974387f,
0.04036761938f,
0.04007433278f,
0.03976009998f,
0.03942514755f,
0.0390697126f,
0.03869404261f,
0.0382983953f,
0.0378830384f,
0.03744824956f,
0.03699431611f,
0.0365215349f,
0.03603021213f,
0.03552066317f,
0.03499321233f,
0.0344481927f,
0.03388594595f,
0.03330682211f,
0.03271117935f,
0.03209938383f,
0.03147180943f,
0.03082883752f,
0.0301708568f,
0.02949826303f,
0.0288114588f,
0.02811085329f,
0.02739686208f,
0.02666990686f,
0.02593041518f,
0.02517882026f,
0.02441556067f,
0.02364108015f,
0.02285582728f,
0.02206025527f,
0.02125482171f,
0.02043998827f,
0.01961622047f,
0.0187839874f,
0.01794376146f,
0.01709601811f,
0.01624123558f,
0.01537989464f,
0.0145124783f,
0.01363947155f,
0.01276136113f,
0.01187863524f,
0.01099178326f,
0.01010129552f,
0.009207663009f,
0.008311377148f,
0.00741292949f,
0.00651281148f,
0.005611514192f,
0.004709528065f,
0.003807342647f,
0.002905446332f,
0.00200432611f,
0.001104467299f,
0.0002063532981f,
-0.0006895346729f,
-0.001582717827f,
-0.00247272006f,
-0.003359068207f,
-0.004241292287f,
-0.005118925751f,
-0.00599150573f,
-0.006858573277f,
-0.007719673604f,
-0.008574356322f,
-0.009422175675f,
-0.01026269077f,
-0.0110954658f,
-0.01192007027f,
-0.01273607923f,
-0.01354307346f,
-0.0143406397f,
-0.01512837085f,
-0.01590586619f,
-0.01667273154f,
-0.01742857949f,
-0.01817302957f,
-0.01890570842f,
-0.01962625001f,
-0.02033429576f,
-0.02102949478f,
-0.02171150395f,
-0.02237998817f,
-0.02303462045f,
-0.02367508208f,
-0.02430106283f,
-0.024912261f,
-0.02550838365f,
-0.02608914669f,
-0.02665427501f,
-0.02720350263f,
-0.02773657281f,
-0.02825323816f,
-0.02875326077f,
-0.02923641231f,
-0.02970247411f,
-0.03015123731f,
-0.03058250289f,
-0.0309960818f,
-0.03139179503f,
-0.03176947365f,
-0.03212895894f,
-0.03247010239f,
-0.03279276579f,
-0.03309682127f,
-0.03338215133f,
-0.03364864889f,
-0.03389621731f,
-0.03412477045f,
-0.03433423261f,
-0.03452453861f,
-0.03469563377f,
-0.03484747391f,
-0.03498002534f,
-0.03509326487f,
-0.03518717975f,
-0.0352617677f,
-0.03531703684f,
-0.03535300571f,
-0.03536970316f,
-0.03536716837f,
-0.03534545078f,
-0.03530461006f,
-0.03524471601f,
-0.03516584855f,
-0.03506809761f,
-0.03495156312f,
-0.03481635485f,
-0.03466259242f,
-0.03449040515f,
-0.03429993201f,
-0.03409132149f,
-0.03386473154f,
-0.03362032941f,
-0.0333582916f,
-0.03307880369f,
-0.03278206027f,
-0.03246826476f,
-0.03213762929f,
-0.03179037462f,
-0.03142672989f,
-0.0310469326f,
-0.03065122833f,
-0.03023987069f,
-0.02981312111f,
-0.02937124866f,
-0.02891452993f,
-0.02844324882f,
-0.02795769639f,
-0.02745817069f,
-0.02694497652f,
-0.02641842533f,
-0.02587883499f,
-0.02532652962f,
-0.02476183936f,
-0.02418510025f,
-0.02359665398f,
-0.02299684772f,
-0.02238603391f,
-0.02176457007f,
-0.02113281859f,
-0.02049114656f,
-0.01983992551f,
-0.01917953123f,
-0.01851034357f,
-0.01783274624f,
-0.01714712653f,
-0.01645387518f,
-0.0157533861f,
-0.01504605618f,
-0.01433228505f,
-0.01361247488f,
-0.01288703014f,
-0.01215635737f,
-0.01142086496f,
-0.01068096292f,
-0.009937062647f,
-0.009189576715f,
-0.008438918618f,
-0.007685502561f,
-0.006929743223f,
-0.006172055532f,
-0.005412854439f,
-0.004652554688f,
-0.003891570598f,
-0.003130315836f,
-0.002369203197f,
-0.001608644384f,
-0.0008490497921f,
-9.082829173e-05f,
0.0006656129852f,
0.001419868857f,
0.002171536301f,
0.002920214665f,
0.00366550587f,
0.004407014614f,
0.005144348581f,
0.005877118634f,
0.006604939021f,
0.007327427569f,
0.00804420588f,
0.008754899528f,
0.009459138248f,
0.01015655613f,
0.01084679181f,
0.01152948863f,
0.01220429488f,
0.01287086391f,
0.01352885437f,
0.01417793033f,
0.01481776149f,
0.01544802336f,
0.01606839737f,
0.01667857108f,
0.01727823833f,
0.01786709937f,
0.01844486104f,
0.01901123688f,
0.01956594729f,
0.02010871967f,
0.02063928853f,
0.02115739563f,
0.02166279009f,
0.0221552285f,
0.02263447505f,
0.02310030162f,
0.02355248788f,
0.0239908214f,
0.02441509773f,
0.02482512047f,
0.0252207014f,
0.02560166052f,
0.02596782615f,
0.02631903497f,
0.02665513213f,
0.02697597128f,
0.02728141464f,
0.02757133307f,
0.0278456061f,
0.02810412198f,
0.02834677776f,
0.02857347926f,
0.02878414119f,
0.02897868708f,
0.02915704941f,
0.02931916954f,
0.02946499779f,
0.02959449341f,
0.02970762458f,
0.02980436846f,
0.02988471111f,
0.02994864753f,
0.02999618163f,
0.03002732618f,
0.03004210282f,
0.030040542f,
0.03002268293f,
0.02998857356f,
0.02993827053f,
0.02987183909f,
0.02978935305f,
0.02969089473f,
0.02957655489f,
0.02944643262f,
0.02930063533f,
0.02913927861f,
0.02896248619f,
0.02877038982f,
0.02856312921f,
0.02834085191f,
0.02810371325f,
0.02785187619f,
0.02758551127f,
0.02730479647f,
0.02700991712f,
0.02670106577f,
0.02637844208f,
0.02604225272f,
0.0256927112f,
0.02533003781f,
0.02495445942f,
0.02456620938f,
0.0241655274f,
0.02375265934f,
0.02332785715f,
0.02289137865f,
0.02244348741f,
0.02198445257f,
0.0215145487f,
0.02103405564f,
0.02054325831f,
0.02004244654f,
0.01953191492f,
0.01901196261f,
0.01848289317f,
0.01794501437f,
0.01739863804f,
0.01684407984f,
0.01628165913f,
0.01571169876f,
0.01513452489f,
0.01455046682f,
0.01395985677f,
0.01336302976f,
0.01276032335f,
0.01215207752f,
0.01153863444f,
0.01092033831f,
0.01029753517f,
0.009670572701f,
0.009039800051f,
0.008405567642f,
0.007768226982f,
0.007128130477f,
0.00648563124f,
0.005841082899f,
0.005194839409f,
0.004547254856f,
0.003898683268f,
0.003249478421f,
0.002599993644f,
0.001950581627f,
0.00130159423f,
0.0006533822874f,
6.295417862e-06f,
-0.0006393181668f,
-0.001283111851f,
-0.001924740804f,
-0.002563862166f,
-0.003200135232f,
-0.003833221634f,
-0.00446278552f,
-0.005088493733f,
-0.005710015983f,
-0.006327025019f,
-0.006939196798f,
-0.007546210651f,
-0.008147749443f,
-0.008743499736f,
-0.009333151943f,
-0.009916400484f,
-0.01049294394f,
-0.01106248519f,
-0.01162473157f,
-0.01217939501f,
-0.01272619219f,
-0.01326484466f,
-0.01379507897f,
-0.01431662684f,
-0.01482922526f,
-0.01533261665f,
-0.01582654893f,
-0.01631077574f,
-0.01678505647f,
-0.01724915644f,
-0.01770284699f,
-0.0181459056f,
-0.01857811602f,
-0.01899926833f,
-0.01940915911f,
-0.01980759149f,
-0.02019437526f,
-0.02056932697f,
-0.02093226999f,
-0.02128303464f,
-0.02162145822f,
-0.0219473851f,
-0.0222606668f,
-0.02256116204f,
-0.0228487368f,
-0.02312326435f,
-0.02338462535f,
-0.02363270785f,
-0.02386740734f,
-0.0240886268f,
-0.0242962767f,
-0.02449027507f,
-0.02467054748f,
-0.02483702708f,
-0.02498965463f,
-0.02512837848f,
-0.0252531546f,
-0.02536394658f,
-0.02546072566f,
-0.02554347068f,
-0.02561216811f,
-0.02566681203f,
-0.02570740415f,
-0.02573395374f,
-0.02574647768f,
-0.02574500037f,
-0.02572955376f,
-0.0257001773f,
-0.0256569179f,
-0.02559982992f,
-0.02552897507f,
-0.02544442242f,
-0.02534624835f,
-0.02523453643f,
-0.02510937743f,
-0.02497086922f,
-0.02481911669f,
-0.0246542317f,
-0.02447633299f,
-0.02428554609f,
-0.02408200325f,
-0.02386584332f,
-0.02363721168f,
-0.02339626013f,
-0.02314314681f,
-0.02287803605f,
-0.02260109831f,
-0.02231251006f,
-0.02201245364f,
-0.02170111718f,
-0.02137869449f,
-0.0210453849f,
-0.02070139318f,
-0.02034692943f,
-0.0199822089f,
-0.01960745193f,
-0.01922288378f,
-0.01882873454f,
-0.01842523896f,
-0.01801263635f,
-0.01759117043f,
-0.01716108918f,
-0.01672264475f,
-0.01627609325f,
-0.01582169467f,
-0.01535971268f,
-0.01489041452f,
-0.01441407082f,
-0.01393095546f,
-0.0134413454f,
-0.01294552054f,
-0.01244376354f,
-0.01193635966f,
-0.01142359661f,
-0.01090576435f,
-0.01038315497f,
-0.009856062481f,
-0.009324782665f,
-0.008789612907f,
-0.00825085202f,
-0.007708800085f,
-0.007163758276f,
-0.006616028699f,
-0.006065914222f,
-0.005513718316f,
-0.004959744884f,
-0.004404298104f,
-0.003847682265f,
-0.003290201607f,
-0.00273216016f,
-0.002173861588f,
-0.001615609027f,
-0.001057704933f,
-0.0005004509179f,
5.585240057e-05f,
0.0006109055592f,
0.001164410404f,
0.001716070245f,
0.002265590014f,
0.00281267642f,
0.003357038102f,
0.003898385785f,
0.004436432437f,
0.004970893419f,
0.005501486639f,
0.006027932707f,
0.00654995508f,
0.007067280215f,
0.007579637715f,
0.008086760475f,
0.008588384819f,
0.009084250649f,
0.009574101574f,
0.01005768505f,
0.0105347525f,
0.01100505945f,
0.01146836566f,
0.01192443523f,
0.01237303671f,
0.01281394323f,
0.01324693262f,
0.01367178746f,
0.01408829526f,
0.01449624849f,
0.01489544472f,
0.01528568669f,
0.01566678241f,
0.01603854525f,
0.01640079402f,
0.01675335305f,
0.01709605227f,
0.0174287273f,
0.01775121953f,
0.01806337616f,
0.0183650503f,
0.01865610105f,
0.01893639353f,
0.01920579898f,
0.0194641948f,
0.01971146463f,
0.01994749835f,
0.02017219223f,
0.02038544886f,
0.02058717731f,
0.02077729308f,
0.02095571817f,
0.02112238113f,
0.02127721705f,
0.02142016761f,
0.02155118109f,
0.02167021236f,
0.02177722293f,
0.02187218092f,
0.02195506107f,
0.02202584473f,
0.02208451987f,
0.02213108103f,
0.02216552933f,
0.02218787246f,
0.02219812463f,
0.02219630653f,
0.02218244537f,
0.02215657475f,
0.02211873472f,
0.02206897167f,
0.02200733835f,
0.02193389376f,
0.02184870319f,
0.02175183809f,
0.0216433761f,
0.02152340093f,
0.02139200235f,
0.02124927612f,
0.02109532395f,
0.02093025339f,
0.02075417783f,
0.02056721636f,
0.02036949377f,
0.02016114043f,
0.01994229221f,
0.01971309041f,
0.01947368167f,
0.01922421789f,
0.0189648561f,
0.01869575841f,
0.01841709185f,
0.01812902832f,
0.01783174446f,
0.01752542153f,
0.01721024528f,
0.0168864059f,
0.01655409782f,
0.01621351964f,
0.015864874f,
0.01550836746f,
0.01514421035f,
0.01477261668f,
0.014393804f,
0.01400799326f,
0.01361540872f,
0.01321627778f,
0.0128108309f,
0.01239930143f,
0.0119819255f,
0.01155894192f,
0.01113059198f,
0.0106971194f,
0.01025877015f,
0.009815792318f,
0.009368436008f,
0.008916953175f,
0.008461597501f,
0.008002624254f,
0.007540290149f,
0.007074853207f,
0.006606572609f,
0.006135708555f,
0.005662522116f,
0.005187275086f,
0.004710229836f,
0.004231649164f,
0.003751796146f,
0.003270933987f,
0.00278932587f,
0.002307234812f,
0.001824923509f,
0.001342654196f,
0.0008606884997f,
0.0003792872919f,
-0.0001012894493f,
-0.0005807827808f,
-0.001058934933f,
-0.001535489443f,
-0.002010191294f,
-0.002482787039f,
-0.002953024938f,
-0.00342065508f,
-0.003885429513f,
-0.004347102362f,
-0.00480542996f,
-0.005260170961f,
-0.005711086463f,
-0.00615794013f,
-0.006600498304f,
-0.007038530127f,
-0.007471807653f,
-0.007900105969f,
-0.008323203307f,
-0.008740881155f,
-0.009152924379f,
-0.009559121327f,
-0.009959263946f,
-0.01035314789f,
-0.01074057263f,
-0.01112134156f,
-0.01149526209f,
-0.01186214578f,
-0.0122218084f,
-0.01257407007f,
-0.0129187553f,
-0.01325569312f,
-0.01358471717f,
-0.01390566575f,
-0.01421838193f,
-0.0145227136f,
-0.01481851356f,
-0.01510563958f,
-0.01538395445f,
-0.01565332606f,
-0.01591362745f,
-0.01616473685f,
-0.01640653774f,
-0.01663891887f,
-0.01686177437f,
-0.0170750037f,
-0.01727851175f,
-0.01747220886f,
-0.01765601085f,
-0.01782983904f,
-0.0179936203f,
-0.01814728707f,
-0.01829077739f,
-0.0184240349f,
-0.01854700891f,
-0.01865965436f,
-0.01876193189f,
-0.01885380783f,
-0.0189352542f,
-0.01900624878f,
-0.01906677503f,
-0.01911682215f,
-0.01915638507f,
-0.01918546445f,
-0.01920406665f,
-0.01921220373f,
-0.01920989346f,
-0.01919715924f,
-0.01917403013f,
-0.0191405408f,
-0.01909673148f,
-0.01904264796f,
-0.01897834151f,
-0.01890386885f,
-0.01881929212f,
-0.01872467878f,
-0.01862010163f,
-0.01850563866f,
-0.01838137307f,
-0.01824739318f,
-0.01810379233f,
-0.0179506689f,
-0.01778812614f,
-0.0176162722f,
-0.01743521998f,
-0.01724508713f,
-0.01704599591f,
-0.01683807318f,
-0.01662145029f,
-0.01639626301f,
-0.01616265147f,
-0.01592076005f,
-0.01567073734f,
-0.01541273602f,
-0.0151469128f,
-0.01487342833f,
-0.01459244708f,
-0.0143041373f,
-0.01400867088f,
-0.01370622326f,
-0.01339697335f,
-0.01308110339f,
-0.01275879888f,
-0.01243024844f,
-0.01209564369f,
-0.01175517918f,
-0.01140905222f,
-0.01105746279f,
-0.01070061343f,
-0.01033870907f,
-0.009971956947f,
-0.009600566481f,
-0.009224749132f,
-0.008844718288f,
-0.008460689139f,
-0.008072878556f,
-0.007681504965f,
-0.007286788228f,
-0.006888949524f,
-0.006488211227f,
-0.006084796785f,
-0.005678930607f,
-0.005270837942f,
-0.004860744761f,
-0.004448877641f,
-0.004035463651f,
-0.00362073023f,
-0.003204905071f,
-0.002788216007f,
-0.002370890884f,
-0.001953157452f,
-0.001535243236f,
-0.001117375418f,
-0.0006997807157f,
-0.0002826852585f,
0.0001336855372f,
0.0005491070917f,
0.0009633557869f,
0.001376209092f,
0.001787445686f,
0.002196845588f,
0.002604190275f,
0.003009262805f,
0.003411847945f,
0.003811732281f,
0.004208704345f,
0.004602554723f,
0.00499307617f,
0.005380063724f,
0.005763314807f,
0.006142629334f,
0.006517809811f,
0.006888661437f,
0.007254992195f,
0.007616612951f,
0.007973337536f,
0.008324982841f,
0.008671368901f,
0.009012318974f,
0.009347659629f,
0.009677220822f,
0.01000083598f,
0.01031834206f,
0.01062957968f,
0.0109343931f,
0.01123263041f,
0.0115241435f,
0.01180878823f,
0.01208642441f,
0.01235691594f,
0.01262013086f,
0.0128759414f,
0.01312422408f,
0.01336485975f,
0.01359773366f,
0.01382273554f,
0.01403975962f,
0.01424870471f,
0.01444947425f,
0.01464197635f,
0.01482612384f,
0.01500183431f,
0.01516903013f,
0.0153276385f,
0.01547759148f,
0.01561882597f,
0.0157512838f,
0.01587491168f,
0.01598966126f,
0.01609548911f,
0.01619235673f,
0.01628023055f,
0.01635908195f,
0.01642888725f,
0.01648962769f,
0.01654128942f,
0.01658386355f,
0.01661734607f,
0.01664173787f,
0.01665704476f,
0.0166632774f,
0.01666045133f,
0.01664858695f,
0.01662770948f,
0.01659784896f,
0.01655904026f,
0.016511323f,
0.01645474155f,
0.01638934505f,
0.0163151873f,
0.01623232678f,
0.01614082662f,
0.01604075451f,
0.01593218272f,
0.015815188f,
0.01568985158f,
0.01555625906f,
0.01541450039f,
0.01526466979f,
0.01510686572f,
0.01494119074f,
0.01476775153f,
0.01458665872f,
0.0143980269f,
0.01420197448f,
0.01399862364f,
0.01378810025f,
0.01357053378f,
0.01334605719f,
0.01311480691f,
0.0128769227f,
0.01263254759f,
0.01238182779f,
0.01212491261f,
0.01186195437f,
0.01159310833f,
0.01131853258f,
0.01103838799f,
0.0107528381f,
0.01046204903f,
0.0101661894f,
0.009865430251f,
0.009559944953f,
0.009249909095f,
0.008935500404f,
0.008616898648f,
0.008294285537f,
0.00796784462f,
0.00763776118f,
0.007304222135f,
0.006967415923f,
0.006627532396f,
0.006284762707f,
0.005939299196f,
0.005591335279f,
0.005241065329f,
0.004888684562f,
0.00453438892f,
0.004178374958f,
0.003820839723f,
0.003461980647f,
0.00310199543f,
0.002741081926f,
0.00237943804f,
0.002017261613f,
0.001654750317f,
0.001292101555f,
0.0009295123516f,
0.0005671792577f,
0.000205298248f,
-0.0001559353756f,
-0.0005163270808f,
-0.0008756832007f,
-0.001233811028f,
-0.001590518912f,
-0.001945616348f,
-0.002298914076f,
-0.002650224173f,
-0.002999360149f,
-0.003346137041f,
-0.00369037151f,
-0.004031881935f,
-0.004370488514f,
-0.004706013358f,
-0.005038280588f,
-0.005367116436f,
-0.005692349339f,
-0.006013810034f,
-0.006331331659f,
-0.006644749842f,
-0.006953902795f,
-0.007258631406f,
-0.007558779326f,
-0.007854193053f,
-0.008144722016f,
-0.008430218657f,
-0.008710538499f,
-0.008985540228f,
-0.009255085754f,
-0.009519040282f,
-0.00977727237f,
-0.01002965399f,
-0.01027606058f,
-0.01051637111f,
-0.01075046811f,
-0.01097823773f,
-0.01119956979f,
-0.01141435782f,
-0.01162249909f,
-0.01182389467f,
-0.01201844946f,
-0.01220607224f,
-0.01238667568f,
-0.01256017641f,
-0.01272649505f,
-0.01288555624f,
-0.01303728867f,
-0.01318162514f,
-0.01331850256f,
-0.01344786201f,
-0.01356964878f,
-0.01368381236f,
-0.0137903065f,
-0.01388908922f,
-0.01398012286f,
-0.01406337405f,
-0.01413881376f,
-0.01420641732f,
-0.01426616438f,
-0.01431803898f,
-0.01436202949f,
-0.01439812864f,
-0.01442633351f,
-0.01444664549f,
-0.01445907032f,
-0.01446361799f,
-0.01446030279f,
-0.01444914325f,
-0.01443016213f,
-0.01440338635f,
-0.01436884702f,
-0.01432657935f,
-0.01427662265f,
-0.01421902028f,
-0.01415381962f,
-0.01408107201f,
-0.01400083276f,
-0.01391316108f,
-0.01381812004f,
-0.01371577654f,
-0.01360620127f,
-0.01348946868f,
-0.01336565693f,
-0.01323484784f,
-0.01309712687f,
-0.01295258306f,
-0.01280130897f,
-0.01264340068f,
-0.01247895766f,
-0.0123080828f,
-0.01213088228f,
-0.01194746556f,
-0.01175794529f,
-0.01156243724f,
-0.01136106025f,
-0.01115393612f,
-0.01094118958f,
-0.01072294816f,
-0.01049934215f,
-0.01027050447f,
-0.01003657063f,
-0.009797678619f,
-0.009553968798f,
-0.009305583847f,
-0.009052668646f,
-0.0087953702f,
-0.00853383754f,
-0.00826822164f,
-0.007998675325f,
-0.007725353186f,
-0.007448411491f,
-0.007168008101f,
-0.006884302387f,
-0.006597455144f,
-0.006307628509f,
-0.00601498588f,
-0.005719691831f,
-0.005421912033f,
-0.005121813168f,
-0.004819562848f,
-0.004515329529f,
-0.004209282425f,
-0.003901591423f,
-0.003592426992f,
-0.003281960093f,
-0.002970362086f,
-0.002657804637f,
-0.002344459618f,
-0.002030499015f,
-0.001716094822f,
-0.001401418946f,
-0.001086643103f,
-0.0007719387154f,
-0.0004574768115f,
-0.0001434279226f,
0.0001700380176f,
0.0004827517732f,
0.0007945449049f,
0.001105249867f,
0.0014147001f,
0.001722730127f,
0.002029175639f,
0.002333873586f,
0.002636662257f,
0.002937381364f,
0.003235872124f,
0.003531977327f,
0.003825541419f,
0.00411641057f,
0.004404432744f,
0.004689457768f,
0.004971337401f,
0.005249925403f,
0.005525077596f,
0.005796651934f,
0.006064508572f,
0.006328509926f,
0.006588520747f,
0.006844408183f,
0.007096041852f,
0.007343293907f,
0.007586039105f,
0.007824154878f,
0.0080575214f,
0.008286021654f,
0.008509541502f,
0.00872796975f,
0.00894119821f,
0.009149121764f,
0.009351638427f,
0.009548649398f,
0.009740059119f,
0.009925775321f,
0.01010570908f,
0.01027977484f,
0.01044789048f,
0.01060997733f,
0.01076596021f,
0.01091576745f,
0.01105933091f,
0.01119658605f,
0.01132747187f,
0.01145193097f,
0.01156990958f,
0.01168135752f,
0.01178622828f,
0.01188447894f,
0.01197607026f,
0.01206096665f,
0.01213913617f,
0.01221055055f,
0.0122751852f,
0.01233301922f,
0.01238403539f,
0.01242822018f,
0.01246556377f,
0.01249606004f,
0.0125197066f,
0.01253650476f,
0.01254645956f,
0.01254957973f,
0.01254587776f,
0.01253536981f,
0.01251807577f,
0.01249401919f,
0.01246322734f,
0.01242573109f,
0.01238156499f,
0.01233076718f,
0.01227337936f,
0.01220944679f,
0.01213901822f,
0.01206214588f,
0.01197888538f,
0.01188929574f,
0.01179343927f,
0.01169138155f,
0.0115831914f,
0.01146894077f,
0.01134870472f,
0.01122256138f,
0.01109059186f,
0.01095288021f,
0.01080951337f,
0.01066058112f,
0.01050617602f,
0.01034639333f,
0.01018133103f,
0.01001108969f,
0.009835772468f,
0.009655485038f,
0.009470335544f,
0.009280434545f,
0.009085894963f,
0.008886832022f,
0.008683363196f,
0.008475608144f,
0.008263688651f,
0.008047728559f,
0.0078278537f,
0.007604191827f,
0.007376872536f,
0.00714602719f,
0.006911788838f,
0.006674292135f,
0.006433673254f,
0.006190069803f,
0.005943620731f,
0.005694466244f,
0.005442747713f,
0.005188607585f,
0.004932189289f,
0.004673637154f,
0.004413096314f,
0.004150712627f,
0.003886632585f,
0.003621003237f,
0.0033539721f,
0.003085687089f,
0.002816296434f,
0.002545948605f,
0.002274792242f,
0.002002976081f,
0.001730648882f,
0.001457959364f,
0.001185056128f,
0.0009120875938f,
0.0006392019285f,
0.0003665469752f,
9.427018272e-05f,
-0.0001774814673f,
-0.0004485615341f,
-0.0007188241935f,
-0.000988124315f,
-0.001256317541f,
-0.001523260365f,
-0.001788810218f,
-0.002052825546f,
-0.002315165897f,
-0.002575692004f,
-0.002834265871f,
-0.003090750853f,
-0.003345011742f,
-0.003596914849f,
-0.003846328079f,
-0.004093121016f,
-0.004337164992f,
-0.004578333161f,
-0.004816500569f,
-0.005051544218f,
-0.005283343129f,
-0.005511778402f,
-0.005736733268f,
-0.005958093147f,
-0.006175745689f,
-0.006389580828f,
-0.006599490824f,
-0.006805370302f,
-0.007007116297f,
-0.007204628291f,
-0.00739780825f,
-0.007586560667f,
-0.007770792596f,
-0.007950413691f,
-0.008125336245f,
-0.008295475233f,
-0.008460748345f,
-0.008621076034f,
-0.008776381551f,
-0.008926590994f,
-0.009071633344f,
-0.009211440509f,
-0.009345947366f,
-0.009475091802f,
-0.009598814753f,
-0.009717060239f,
-0.009829775405f,
-0.009936910545f,
-0.01003841914f,
-0.01013425789f,
-0.0102243867f,
-0.01030876875f,
-0.01038737049f,
-0.01046016162f,
-0.01052711513f,
-0.01058820732f,
-0.01064341774f,
-0.01069272924f,
-0.01073612791f,
-0.01077360314f,
-0.01080514753f,
-0.01083075693f,
-0.0108504304f,
-0.01086417019f,
-0.01087198174f,
-0.01087387364f,
-0.01086985763f,
-0.01085994858f,
-0.01084416444f,
-0.01082252628f,
-0.01079505824f,
-0.01076178751f,
-0.01072274434f,
-0.01067796199f,
-0.01062747677f,
-0.01057132796f,
-0.01050955785f,
-0.01044221168f,
-0.01036933766f,
-0.01029098692f,
-0.01020721348f,
-0.01011807428f,
-0.01002362909f,
-0.009923940477f,
-0.009819073823f,
-0.009709097235f,
-0.009594081518f,
-0.009474100124f,
-0.009349229104f,
-0.009219547049f,
-0.009085135034f,
-0.008946076559f,
-0.008802457483f,
-0.008654365962f,
-0.008501892383f,
-0.008345129296f,
-0.008184171353f,
-0.008019115236f,
-0.007850059595f,
-0.007677104981f,
-0.007500353786f,
-0.00731991018f,
-0.00713588005f,
-0.006948370945f,
-0.006757492013f,
-0.006563353952f,
-0.006366068953f,
-0.006165750646f,
-0.005962514048f,
-0.00575647551f,
-0.005547752662f,
-0.005336464363f,
-0.005122730641f,
-0.004906672639f,
-0.004688412557f,
-0.004468073586f,
-0.00424577985f,
-0.004021656335f,
-0.003795828823f,
-0.003568423816f,
-0.003339568467f,
-0.003109390496f,
-0.002878018117f,
-0.002645579951f,
-0.002412204949f,
-0.002178022304f,
-0.001943161369f,
-0.001707751574f,
-0.001471922341f,
-0.001235803003f,
-0.0009995227256f,
-0.0007632104234f,
-0.0005269946895f,
-0.0002910037195f,
-5.536524143e-05f,
0.0001797935514f,
0.0004143460654f,
0.000648166368f,
0.0008811292469f,
0.001113110267f,
0.001343985824f,
0.001573633198f,
0.001801930606f,
0.002028757251f,
0.002253993373f,
0.002477520302f,
0.002699220503f,
0.002918977637f,
0.003136676607f,
0.003352203615f,
0.00356544622f,
0.003776293395f,
0.003984635588f,
0.004190364781f,
0.004393374553f,
0.004593560149f,
0.004790818537f,
0.004985048478f,
0.005176150589f,
0.005364027405f,
0.005548583446f,
0.005729725271f,
0.005907361542f,
0.006081403077f,
0.006251762903f,
0.006418356302f,
0.006581100862f,
0.006739916511f,
0.006894725558f,
0.007045452726f,
0.00719202518f,
0.007334372553f,
0.007472426969f,
0.00760612306f,
0.007735397986f,
0.007860191449f,
0.007980445704f,
0.008096105576f,
0.008207118466f,
0.00831343437f,
0.008415005884f,
0.008511788222f,
0.008603739228f,
0.00869081939f,
0.008772991858f,
0.008850222463f,
0.008922479729f,
0.008989734901f,
0.009051961958f,
0.009109137636f,
0.009161241447f,
0.0092082557f,
0.009250165516f,
0.009286958846f,
0.009318626483f,
0.009345162075f,
0.00936656213f,
0.009382826024f,
0.009393955995f,
0.009399957145f,
0.009400837429f,
0.009396607641f,
0.009387281402f,
0.009372875132f,
0.009353408032f,
0.009328902052f,
0.009299381864f,
0.009264874823f,
0.009225410939f,
0.009181022835f,
0.00913174571f,
0.009077617305f,
0.009018677864f,
0.008954970094f,
0.008886539134f,
0.008813432519f,
0.008735700146f,
0.008653394244f,
0.008566569344f,
0.008475282249f,
0.008379592012f,
0.008279559902f,
0.008175249387f,
0.0080667261f,
0.007954057822f,
0.007837314448f,
0.007716567962f,
0.007591892406f,
0.00746336385f,
0.007331060352f,
0.007195061922f,
0.007055450483f,
0.006912309817f,
0.006765725524f,
0.006615784965f,
0.006462577204f,
0.006306192949f,
0.006146724491f,
0.005984265634f,
0.005818911629f,
0.005650759106f,
0.005479906f,
0.005306451483f,
0.005130495889f,
0.00495214065f,
0.00477148822f,
0.004588642012f,
0.004403706333f,
0.004216786318f,
0.004027987873f,
0.003837417615f,
0.003645182816f,
0.003451391354f,
0.003256151661f,
0.003059572672f,
0.00286176378f,
0.002662834792f,
0.00246289588f,
0.002262057537f,
0.002060430534f,
0.001858125866f,
0.001655254712f,
0.001451928378f,
0.001248258247f,
0.001044355723f,
0.000840332174f,
0.0006362988691f,
0.0004323669162f,
0.0002286471951f,
2.525028906e-05f,
-0.0001777135862f,
-0.0003801346544f,
-0.0005819036521f,
-0.0007829119026f,
-0.0009830513893f,
-0.001182214829f,
-0.001380295741f,
-0.001577188522f,
-0.001772788507f,
-0.001966992038f,
-0.002159696522f,
-0.00235080049f,
-0.00254020365f,
-0.002727806936f,
-0.002913512558f,
-0.003097224037f,
-0.003278846251f,
-0.003458285469f,
-0.003635449383f,
-0.003810247142f,
-0.003982589383f,
-0.004152388255f,
-0.004319557456f,
-0.004484012256f,
-0.00464566953f,
-0.00480444779f,
-0.004960267213f,
-0.005113049683f,
-0.005262718822f,
-0.005409200032f,
-0.005552420532f,
-0.005692309406f,
-0.005828797642f,
-0.005961818182f,
-0.006091305963f,
-0.006217197968f,
-0.006339433269f,
-0.006457953075f,
-0.006572700771f,
-0.006683621961f,
-0.00679066451f,
-0.006893778572f,
-0.006992916627f,
-0.007088033505f,
-0.007179086411f,
-0.00726603494f,
-0.007348841096f,
-0.007427469295f,
-0.007501886376f,
-0.007572061598f,
-0.007637966642f,
-0.007699575601f,
-0.007756864978f,
-0.007809813671f,
-0.007858402969f,
-0.007902616535f,
-0.007942440399f,
-0.007977862946f,
-0.008008874907f,
-0.008035469352f,
-0.008057641682f,
-0.008075389627f,
-0.008088713242f,
-0.008097614907f,
-0.008102099329f,
-0.008102173545f,
-0.008097846924f,
-0.008089131176f,
-0.00807604035f,
-0.008058590845f,
-0.008036801406f,
-0.008010693133f,
-0.007980289471f,
-0.007945616214f,
-0.007906701492f,
-0.007863575762f,
-0.00781627179f,
-0.007764824634f,
-0.007709271618f,
-0.007649652301f,
-0.007586008448f,
-0.007518383988f,
-0.007446824978f,
-0.007371379553f,
-0.007292097883f,
-0.007209032124f,
-0.007122236366f,
-0.007031766584f,
-0.006937680584f,
-0.006840037956f,
-0.006738900023f,
-0.006634329794f,
-0.006526391918f,
-0.006415152639f,
-0.00630067976f,
-0.006183042601f,
-0.006062311966f,
-0.005938560105f,
-0.005811860691f,
-0.005682288785f,
-0.005549920807f,
-0.005414834513f,
-0.005277108964f,
-0.005136824499f,
-0.004994062703f,
-0.00484890638f,
-0.004701439517f,
-0.004551747246f,
-0.004399915806f,
-0.004246032498f,
-0.004090185637f,
-0.003932464504f,
-0.003772959286f,
-0.003611761021f,
-0.003448961532f,
-0.003284653367f,
-0.003118929727f,
-0.002951884398f,
-0.002783611684f,
-0.002614206331f,
-0.002443763459f,
-0.002272378494f,
-0.002100147099f,
-0.001927165107f,
-0.001753528461f,
-0.001579333151f,
-0.00140467516f,
-0.001229650413f,
-0.001054354722f,
-0.0008788837483f,
-0.0007033329544f,
-0.0005277975681f,
-0.0003523725451f,
-0.0001771525351f,
-2.231848127e-06f,
0.0001722955766f,
0.000346336203f,
0.0005197969306f,
0.0006925851278f,
0.0008646086672f,
0.001035775963f,
0.001205996011f,
0.001375178431f,
0.001543233515f,
0.001710072272f,
0.001875606484f,
0.002039748761f,
0.002202412595f,
0.002363512424f,
0.002522963688f,
0.002680682895f,
0.002836587681f,
0.002990596871f,
0.00314263054f,
0.00329261007f,
0.003440458206f,
0.003586099108f,
0.0037294584f,
0.00387046321f,
0.004009042216f,
0.004145125676f,
0.004278645461f,
0.004409535079f,
0.004537729701f,
0.004663166171f,
0.004785783031f,
0.004905520524f,
0.005022320607f,
0.005136126961f,
0.005246884996f,
0.00535454186f,
0.005459046447f,
0.005560349407f,
0.005658403154f,
0.005753161887f,
0.005844581596f,
0.00593262009f,
0.006017237012f,
0.006098393867f,
0.006176054045f,
0.006250182853f,
0.006320747542f,
0.006387717341f,
0.006451063484f,
0.006510759244f,
0.006566779964f,
0.006619103081f,
0.006667708154f,
0.006712576883f,
0.006753693132f,
0.00679104294f,
0.006824614527f,
0.006854398306f,
0.006880386873f,
0.006902575011f,
0.006920959669f,
0.006935539955f,
0.006946317114f,
0.006953294505f,
0.006956477574f,
0.00695587383f,
0.006951492814f,
0.006943346067f,
0.006931447104f,
0.006915811384f,
0.006896456283f,
0.006873401065f,
0.006846666866f,
0.006816276666f,
0.006782255278f,
0.006744629331f,
0.006703427258f,
0.006658679289f,
0.006610417443f,
0.006558675522f,
0.00650348911f,
0.006444895569f,
0.006382934033f,
0.006317645404f,
0.006249072348f,
0.006177259283f,
0.006102252367f,
0.006024099483f,
0.00594285022f,
0.005858555843f,
0.00577126927f,
0.005681045032f,
0.005587939239f,
0.005492009529f,
0.005393315029f,
0.005291916295f,
0.005187875263f,
0.00508125519f,
0.004972120597f,
0.004860537205f,
0.004746571882f,
0.004630292582f,
0.004511768286f,
0.004391068951f,
0.004268265457f,
0.004143429556f,
0.004016633831f,
0.003887951652f,
0.003757457139f,
0.00362522513f,
0.003491331148f,
0.003355851376f,
0.003218862627f,
0.003080442328f,
0.00294066849f,
0.002799619691f,
0.00265737505f,
0.002514014208f,
0.002369617294f,
0.002224264905f,
0.002078038066f,
0.001931018203f,
0.001783287095f,
0.001634926836f,
0.001486019782f,
0.001336648503f,
0.001186895726f,
0.001036844271f,
0.0008865769937f,
0.000736176719f,
0.0005857261733f,
0.0004353079192f,
0.0002850042879f,
0.0001348973137f,
-1.493132978e-05f,
-0.0001644003912f,
-0.0003134290994f,
-0.0004619372175f,
-0.0006098450929f,
-0.0007570737024f,
-0.0009035446928f,
-0.001049180417f,
-0.001193903965f,
-0.00133763919f,
-0.001480310734f,
-0.001621844047f,
-0.001762165401f,
-0.001901201913f,
-0.002038881554f,
-0.002175133167f,
-0.00230988648f,
-0.002443072128f,
-0.002574621667f,
-0.0027044676f,
-0.002832543398f,
-0.002958783536f,
-0.003083123518f,
-0.003205499918f,
-0.003325850421f,
-0.003444113862f,
-0.003560230275f,
-0.003674140942f,
-0.003785788441f,
-0.003895116699f,
-0.004002071041f,
-0.004106598238f,
-0.004208646561f,
-0.004308165817f,
-0.004405107401f,
-0.004499424325f,
-0.004591071254f,
-0.004680004537f,
-0.004766182223f,
-0.004849564083f,
-0.00493011162f,
-0.005007788074f,
-0.005082558425f,
-0.00515438939f,
-0.005223249417f,
-0.005289108673f,
-0.005351939037f,
-0.005411714082f,
-0.00546840907f,
-0.00552200093f,
-0.005572468257f,
-0.005619791296f,
-0.005663951938f,
-0.005704933721f,
-0.005742721823f,
-0.005777303074f,
-0.005808665961f,
-0.005836800637f,
-0.005861698939f,
-0.005883354407f,
-0.005901762298f,
-0.005916919611f,
-0.005928825108f,
-0.005937479333f,
-0.005942884634f,
-0.005945045177f,
-0.005943966966f,
-0.005939657847f,
-0.00593212752f,
-0.005921387536f,
-0.005907451296f,
-0.005890334038f,
-0.005870052822f,
-0.005846626513f,
-0.005820075748f,
-0.005790422909f,
-0.005757692086f,
-0.005721909038f,
-0.005683101152f,
-0.005641297397f,
-0.005596528282f,
-0.005548825812f,
-0.005498223441f,
-0.005444756034f,
-0.005388459827f,
-0.00532937239f,
-0.005267532597f,
-0.005202980595f,
-0.005135757784f,
-0.005065906795f,
-0.004993471473f,
-0.004918496868f,
-0.004841029225f,
-0.004761115976f,
-0.004678805737f,
-0.004594148303f,
-0.004507194641f,
-0.004417996891f,
-0.004326608352f,
-0.004233083477f,
-0.004137477853f,
-0.004039848189f,
-0.00394025229f,
-0.003838749028f,
-0.00373539831f,
-0.003630261036f,
-0.00352339906f,
-0.003414875134f,
-0.003304752858f,
-0.003193096623f,
-0.003079971548f,
-0.00296544342f,
-0.002849578627f,
-0.002732444098f,
-0.002614107239f,
-0.002494635871f,
-0.00237409817f,
-0.002252562618f,
-0.002130097946f,
-0.002006773091f,
-0.001882657158f,
-0.001757819375f,
-0.001632329072f,
-0.001506255649f,
-0.001379668556f,
-0.001252637275f,
-0.001125231304f,
-0.000997520147f,
-0.0008695732991f,
-0.0007414602382f,
-0.0006132504123f,
-0.0004850132267f,
-0.000356818028f,
-0.0002287340853f,
-0.0001008305673f,
2.682348492e-05f,
0.0001541591903f,
0.0002811078651f,
0.0004076010648f,
0.0005335706315f,
0.0006589487451f,
0.0007836679786f,
0.0009076613562f,
0.001030862414f,
0.001153205263f,
0.001274624649f,
0.001395056015f,
0.001514435562f,
0.001632700303f,
0.00174978812f,
0.001865637808f,
0.001980189123f,
0.002093382817f,
0.00220516067f,
0.00231546552f,
0.002424241276f,
0.00253143294f,
0.002636986612f,
0.002740849496f,
0.002842969901f,
0.002943297243f,
0.003041782036f,
0.003138375893f,
0.00323303152f,
0.003325702713f,
0.003416344362f,
0.003504912449f,
0.003591364058f,
0.003675657384f,
0.003757751751f,
0.003837607631f,
0.00391518667f,
0.003990451716f,
0.004063366856f,
0.004133897451f,
0.004202010178f,
0.00426767307f,
0.004330855558f,
0.004391528516f,
0.004449664301f,
0.004505236789f,
0.004558221415f,
0.004608595199f,
0.004656336772f,
0.004701426401f,
0.004743845995f,
0.004783579118f,
0.004820610986f,
0.004854928462f,
0.004886520046f,
0.004915375855f,
0.004941487601f,
0.004964848568f,
0.00498545358f,
0.005003298971f,
0.005018382557f,
0.0050307036f,
0.005040262781f,
0.005047062174f,
0.00505110522f,
0.00505239671f,
0.005050942769f,
0.005046750842f,
0.005039829697f,
0.005030189418f,
0.005017841411f,
0.005002798416f,
0.004985074516f,
0.004964685154f,
0.004941647149f,
0.004915978715f,
0.004887699475f,
0.004856830481f,
0.004823394225f,
0.004787414645f,
0.004748917138f,
0.004707928552f,
0.00466447718f,
0.004618592754f,
0.004570306415f,
0.004519650696f,
0.004466659484f,
0.004411367982f,
0.004353812666f,
0.004294031237f,
0.004232062568f,
0.00416794665f,
0.004101724533f,
0.004033438276f,
0.003963130887f,
0.00389084627f,
0.00381662918f,
0.003740525169f,
0.003662580555f,
0.003582842378f,
0.003501358373f,
0.003418176947f,
0.003333347158f,
0.003246918704f,
0.003158941913f,
0.003069467739f,
0.002978547761f,
0.002886234185f,
0.002792579841f,
0.002697638194f,
0.002601463334f,
0.002504109981f,
0.002405633478f,
0.002306089781f,
0.00220553544f,
0.002104027584f,
0.00200162389f,
0.001898382548f,
0.001794362224f,
0.001689622012f,
0.001584221379f,
0.001478220115f,
0.001371678265f,
0.001264656068f,
0.001157213891f,
0.001049412165f,
0.0009413113134f,
0.0008329716941f,
0.0007244535353f,
0.0006158168799f,
0.0005071215334f,
0.0003984270184f,
0.0002897925343f,
0.0001812769252f,
7.293865271e-05f,
-3.516422337e-05f,
-0.0001429740588f,
-0.000250433633f,
-0.0003574861526f,
-0.0004640752509f,
-0.0005701449849f,
-0.0006756398312f,
-0.0007805046809f,
-0.0008846848364f,
-0.0009881260102f,
-0.001090774326f,
-0.001192576327f,
-0.001293478986f,
-0.00139342972f,
-0.001492376422f,
-0.001590267479f,
-0.001687051818f,
-0.001782678943f,
-0.00187709898f,
-0.001970262735f,
-0.002062121741f,
-0.002152628322f,
-0.002241735648f,
-0.002329397794f,
-0.002415569798f,
-0.002500207713f,
-0.002583268661f,
-0.002664710875f,
-0.002744493741f,
-0.002822577828f,
-0.002898924916f,
-0.002973498014f,
-0.003046261368f,
-0.003117180469f,
-0.003186222044f,
-0.003253354052f,
-0.003318545665f,
-0.003381767251f,
-0.003442990354f,
-0.003502187668f,
-0.003559333012f,
-0.003614401313f,
-0.003667368581f,
-0.003718211891f,
-0.003766909378f,
-0.003813440219f,
-0.003857784642f,
-0.003899923924f,
-0.003939840406f,
-0.00397751751f,
-0.00401293976f,
-0.004046092816f,
-0.0040769635f,
-0.00410553984f,
-0.004131811104f,
-0.004155767839f,
-0.004177401912f,
-0.004196706547f,
-0.004213676356f,
-0.004228307373f,
-0.004240597073f,
-0.00425054439f,
-0.004258149731f,
-0.004263414972f,
-0.004266343457f,
-0.004266939983f,
-0.004265210776f,
-0.004261163467f,
-0.004254807053f,
-0.004246151863f,
-0.004235209504f,
-0.004221992826f,
-0.004206515865f,
-0.004188793797f,
-0.004168842895f,
-0.004146680478f,
-0.004122324879f,
-0.004095795402f,
-0.004067112299f,
-0.004036296743f,
-0.004003370816f,
-0.003968357496f,
-0.003931280659f,
-0.003892165079f,
-0.003851036441f,
-0.003807921355f,
-0.00376284737f,
-0.003715842999f,
-0.003666937739f,
-0.003616162088f,
-0.003563547567f,
-0.003509126735f,
-0.003452933197f,
-0.003395001609f,
-0.003335367678f,
-0.00327406815f,
-0.003211140792f,
-0.003146624369f,
-0.003080558606f,
-0.003012984151f,
-0.002943942525f,
-0.002873476064f,
-0.002801627865f,
-0.002728441721f,
-0.002653962052f,
-0.002578233844f,
-0.00250130258f,
-0.002423214178f,
-0.002344014932f,
-0.002263751455f,
-0.00218247063f,
-0.002100219573f,
-0.00201704559f,
-0.001932996158f,
-0.001848118899f,
-0.001762461577f,
-0.001676072082f,
-0.001588998444f,
-0.001501288829f,
-0.001412991558f,
-0.001324155115f,
-0.001234828166f,
-0.00114505957f,
-0.001054898391f,
-0.0009643939109f,
-0.0008735956289f,
-0.0007825532627f,
-0.0006913167391f,
-0.0005999361781f,
-0.0005084618688f,
-0.0004169442372f,
-0.0003254338063f,
-0.0002339811484f,
-0.000142636831f,
-5.145135644e-05f,
3.952490234e-05f,
0.0001302417698f,
0.0002206493369f,
0.0003106980309f,
0.0004003386826f,
0.0004895225916f,
0.0005782015861f,
0.0006663280772f,
0.0007538551059f,
0.0008407363828f,
0.0009269263188f,
0.001012380047f,
0.001097053437f,
0.001180903098f,
0.001263886377f,
0.001345961352f,
0.00142708681f,
0.001507222233f,
0.001586327774f,
0.001664364229f,
0.001741293017f,
0.00181707616f,
0.001891676257f,
0.001965056477f,
0.002037180551f,
0.002108012765f,
0.002177517977f,
0.002245661624f,
0.002312409747f,
0.002377729027f,
0.002441586819f,
0.002503951199f,
0.002564791016f,
0.002624075947f,
0.002681776553f,
0.002737864343f,
0.002792311825f,
0.00284509257f,
0.002896181259f,
0.002945553733f,
0.002993187029f,
0.003039059418f,
0.003083150424f,
0.003125440838f,
0.003165912725f,
0.003204549417f,
0.0032413355f,
0.003276256792f,
0.003309300311f,
0.003340454239f,
0.003369707888f,
0.003397051647f,
0.003422476944f,
0.003445976199f,
0.003467542785f,
0.003487170986f,
0.003504855966f,
0.003520593744f,
0.003534381172f,
0.003546215929f,
0.003556096515f,
0.00356402226f,
0.003569993337f,
0.00357401079f,
0.003576076558f,
0.003576193514f,
0.003574365503f,
0.003570597386f,
0.00356489508f,
0.003557265603f,
0.003547717115f,
0.003536258947f,
0.003522901635f,
0.00350765694f,
0.003490537861f,
0.003471558638f,
0.003450734749f,
0.003428082886f,
0.003403620939f,
0.003377367952f,
0.003349344081f,
0.003319570544f,
0.003288069563f,
0.0032548643f,
0.003219978791f,
0.003183437887f,
0.003145267182f,
0.003105492954f,
0.00306414211f,
0.003021242133f,
0.00297682104f,
0.002930907344f,
0.002883530031f,
0.002834718545f,
0.002784502777f,
0.002732913071f,
0.002679980233f,
0.002625735549f,
0.002570210811f,
0.002513438343f,
0.002455451034f,
0.002396282373f,
0.002335966472f,
0.002274538106f,
0.002212032725f,
0.002148486481f,
0.002083936229f,
0.002018419536f,
0.001951974663f,
0.001884640552f,
0.001816456795f,
0.001747463589f,
0.001677701694f,
0.001607212367f,
0.001536037304f,
0.001464218561f,
0.001391798488f,
0.001318819643f,
0.001245324721f,
0.001171356473f,
0.001096957641f,
0.001022170887f,
0.0009470387379f,
0.000871603533f,
0.0007959073852f,
0.0007199921505f,
0.0006438994086f,
0.0005676704547f,
0.0004913462999f,
0.0004149676824f,
0.0003385750857f,
0.0002622087639f,
0.0001859087719f,
0.0001097149983f,
3.366719952e-05f,
-4.219496705e-05f,
-0.0001178319133f,
-0.0001932040954f,
-0.0002682719953f,
-0.0003429961112f,
-0.0004173369561f,
-0.0004912550678f,
-0.0005647110286f,
-0.0006376654963f,
-0.0007100792453f,
-0.0007819132171f,
-0.0008531285799f,
-0.0009236867946f,
-0.0009935496869f,
-0.001062679522f,
-0.001131039082f,
-0.001198591742f,
-0.00126530154f,
-0.001331133252f,
-0.001396052445f,
-0.001460025537f,
-0.001523019836f,
-0.001585003574f,
-0.001645945927f,
-0.001705817027f,
-0.001764587955f,
-0.00182223073f,
-0.001878718287f,
-0.001934024442f,
-0.001988123855f,
-0.002040991983f,
-0.002092605038f,
-0.002142939931f,
-0.002191974231f,
-0.002239686117f,
-0.002286054345f,
-0.002331058209f,
-0.002374677528f,
-0.002416892626f,
-0.002457684334f,
-0.002497033999f,
-0.002534923505f,
-0.002571335306f,
-0.002606252464f,
-0.002639658705f,
-0.002671538469f,
-0.002701876979f,
-0.002730660306f,
-0.00275787543f,
-0.002783510315f,
-0.002807553961f,
-0.002829996468f,
-0.002850829079f,
-0.002870044222f,
-0.002887635538f,
-0.002903597893f,
-0.002917927387f,
-0.002930621344f,
-0.002941678285f,
-0.002951097904f,
-0.002958881017f,
-0.002965029511f,
-0.002969546287f,
-0.002972435191f,
-0.002973700948f,
-0.002973349093f,
-0.002971385903f,
-0.002967818335f,
-0.002962653972f,
-0.002955900969f,
-0.002947568019f,
-0.002937664325f,
-0.00292619958f,
-0.002913183969f,
-0.002898628173f,
-0.002882543391f,
-0.00286494137f,
-0.002845834446f,
-0.002825235586f,
-0.002803158447f,
-0.002779617428f,
-0.002754627727f,
-0.002728205395f,
-0.002700367386f,
-0.002671131602f,
-0.002640516929f,
-0.00260854326f,
-0.002575231509f,
-0.002540603612f,
-0.002504682515f,
-0.002467492148f,
-0.002429057382f,
-0.002389403984f,
-0.002348558549f,
-0.002306548434f,
-0.002263401673f,
-0.0022191469f,
-0.00217381326f,
-0.002127430324f,
-0.002080028003f,
-0.002031636477f,
-0.001982286116f,
-0.001932007427f,
-0.001880830997f,
-0.00182878746f,
-0.001775907471f,
-0.001722221693f,
-0.001667760802f,
-0.001612555501f,
-0.001556636544f,
-0.001500034773f,
-0.001442781166f,
-0.00138490688f,
-0.001326443308f,
-0.001267422131f,
-0.001207875372f,
-0.001147835438f,
-0.001087335165f,
-0.001026407846f,
-0.0009650872493f,
-0.0009034076286f,
-0.0008414037143f,
-0.0007791106937f,
-0.000716564176f,
-0.0006538001443f,
-0.0005908548945f,
-0.0005277649639f,
-0.0004645670499f,
-0.0004012979219f,
-0.0003379943291f,
-0.0002746929062f,
-0.0002114300805f,
-0.0001482419819f,
-8.516436051e-05f,
-2.223251187e-05f,
4.05187862e-05f,
0.0001030553245f,
0.0001653434994f,
0.0002273503352f,
0.0002890434914f,
0.000350391256f,
0.0004113625241f,
0.0004719267648f,
0.0005320539772f,
0.0005917146379f,
0.0006508796424f,
0.0007095202435f,
0.0007676079886f,
0.0008251146603f,
0.0008820122211f,
0.0009382727669f,
0.0009938684897f,
0.001048771653f,
0.001102954579f,
0.001156389654f,
0.001209049345f,
0.001260906232f,
0.001311933054f,
0.001362102774f,
0.001411388646f,
0.001459764296f,
0.001507203811f,
0.00155368183f,
0.001599173637f,
0.001643655251f,
0.001687103511f,
0.001729496159f,
0.0017708119f,
0.001811030465f,
0.001850132651f,
0.001888100343f,
0.001924916529f,
0.001960565292f,
0.001995031787f,
0.002028302204f,
0.002060363719f,
0.002091204431f,
0.002120813291f,
0.002149180029f,
0.002176295067f,
0.002202149446f,
0.002226734744f,
0.002250043009f,
0.002272066691f,
0.002292798599f,
0.002312231855f,
0.002330359876f,
0.002347176366f,
0.002362675322f,
0.002376851065f,
0.002389698271f,
0.002401212035f,
0.002411387929f,
0.00242022208f,
0.002427711253f,
0.002433852937f,
0.00243864543f,
0.002442087922f,
0.002444180576f,
0.002444924597f,
0.002444322285f,
0.002442377085f,
0.002439093612f,
0.002434477663f,
0.002428536209f,
0.002421277376f,
0.002412710398f,
0.002402845563f,
0.002391694146f,
0.002379268317f,
0.00236558106f,
0.002350646066f,
0.002334477639f,
0.002317090594f,
0.002298500159f,
0.002278721888f,
0.002257771585f,
0.002235665235f,
0.002212418953f,
0.002188048951f,
0.002162571522f,
0.00213600304f,
0.002108359976f,
0.002079658938f,
0.002049916717f,
0.002019150348f,
0.001987377188f,
0.001954614992f,
0.001920881995f,
0.001886197f,
0.001850579453f,
0.001814049519f,
0.001776628149f,
0.001738337124f,
0.001699199094f,
0.001659237597f,
0.001618477058f,
0.001576942771f,
0.001534660859f,
0.001491658219f,
0.001447962452f,
0.001403601769f,
0.001358604898f,
0.001313000973f,
0.001266819419f,
0.001220089833f,
0.001172841878f,
0.001125105162f,
0.001076909147f,
0.001028283055f,
0.0009792557957f,
0.000929855908f,
0.0008801115232f,
0.0008300503452f,
0.0007796996506f,
0.0007290863094f,
0.0006782368225f,
0.0006271773757f,
0.0005759339081f,
0.0005245321902f,
0.00047299791f,
0.0004213567627f,
0.0003696345402f,
0.0003178572164f,
0.000266051025f,
0.0002142425264f,
0.0001624586596f,
0.0001107267783f,
5.907466706e-05f,
7.530538934e-06f,
-4.387698876e-05f,
-9.511893827e-05f,
-0.0001461660348f,
-0.0001969887875f,
-0.0002475575862f,
-0.0002978428096f,
-0.0003478149436f,
-0.0003974447042f,
-0.0004467031617f,
-0.0004955618622f,
-0.0005439929426f,
-0.0005919692345f,
-0.0006394643544f,
-0.0006864527777f,
-0.0007329098922f,
-0.0007788120316f,
-0.0008241364874f,
-0.0008688614985f,
-0.0009129662196f,
-0.0009564306703f,
-0.0009992356661f,
-0.001041362735f,
-0.001082794023f,
-0.00112351219f,
-0.001163500306f,
-0.001202741745f,
-0.001241220084f,
-0.001278919011f,
-0.001315822248f,
-0.001351913489f,
-0.00138717635f,
-0.001421594356f,
-0.001455150928f,
-0.001487829413f,
-0.001519613122f,
-0.001550485398f,
-0.001580429694f,
-0.001609429675f,
-0.00163746933f,
-0.001664533093f,
-0.001690605966f,
-0.001715673648f,
-0.001739722658f,
-0.001762740446f,
-0.001784715497f,
-0.001805637415f,
-0.001825496989f,
-0.00184428624f,
-0.001861998441f,
-0.001878628113f,
-0.001894170999f,
-0.001908624015f,
-0.001921985179f,
-0.001934253518f,
-0.001945428963f,
-0.001955512232f,
-0.001964504703f,
-0.001972408288f,
-0.001979225301f,
-0.001984958342f,
-0.001989610183f,
-0.001993183675f,
-0.001995681669f,
-0.00199710696f,
-0.001997462256f,
-0.001996750165f,
-0.001994973216f,
-0.001992133894f,
-0.00198823471f,
-0.001983278277f,
-0.001977267416f,
-0.001970205269f,
-0.001962095423f,
-0.001952942037f,
-0.001942749973f,
-0.001931524914f,
-0.001919273484f,
-0.00190600334f,
-0.001891723256f,
-0.00187644318f,
-0.001860174269f,
-0.001842928898f,
-0.001824720642f,
-0.001805564231f,
-0.001785475478f,
-0.001764471193f,
-0.001742569059f,
-0.001719787513f,
-0.001696145598f,
-0.001671662813f,
-0.001646358965f,
-0.001620254016f,
-0.001593367947f,
-0.001565720623f,
-0.001537331688f,
-0.001508220473f,
-0.001478405926f,
-0.001447906579f,
-0.001416740533f,
-0.001384925471f,
-0.001352478702f,
-0.00131941723f,
-0.001285757841f,
-0.001251517215f,
-0.001216712045f,
-0.001181359171f,
-0.00114547572f,
-0.001109079238f,
-0.001072187823f,
-0.00103482024f,
-0.0009969960263f,
-0.0009587355677f,
-0.0009200601576f,
-0.000880992025f,
-0.0008415543352f,
-0.0008017711607f,
-0.0007616674227f,
-0.0007212688058f,
-0.0006806016469f,
-0.000639692803f,
-0.0005985695012f,
-0.0005572591763f,
-0.0005157893018f,
-0.0004741872187f,
-0.000432479969f,
-0.0003906941398f,
-0.0003488557219f,
-0.0003069899894f,
-0.0002651214032f,
-0.000223273542f,
-0.0001814690637f,
-0.0001397296969f,
-9.807626444e-05f,
-5.652873636e-05f,
-1.510631073e-05f,
2.617248078e-05f,
6.728964689e-05f,
0.0001082275952f,
0.0001489689804f,
0.0001894965487f,
0.0002297929839f,
0.0002698407617f,
0.0003096220175f,
0.0003491184335f,
0.00038831115f,
0.0004271807039f,
0.0004657069977f,
0.000503869301f,
0.0005416462843f,
0.0005790160855f,
0.0006159564062f,
0.0006524446352f,
0.0006884579961f,
0.0007239737123f,
0.0007589691852f,
0.0007934221797f,
0.0008273110088f,
0.0008606147132f,
0.0008933132272f,
0.0009253875274f,
0.0009568197567f,
0.0009875933206f,
0.001017692952f,
0.001047104742f,
0.001075816134f,
0.001103815888f,
0.001131094002f,
0.001157641615f,
0.001183450869f,
0.001208514763f,
0.001232826977f,
0.001256381698f,
0.00127917343f,
0.001301196818f,
0.001322446477f,
0.001342916835f,
0.001362602006f,
0.001381495682f,
0.001399591064f,
0.001416880821f,
0.001433357092f,
0.001449011518f,
0.001463835317f,
0.001477819387f,
0.001490954442f,
0.00150323117f,
0.001514640418f,
0.00152517338f,
0.0015348218f,
0.001543578171f,
0.001551435924f,
0.001558389606f,
0.001564435028f,
0.001569569398f,
0.001573791409f,
0.001577101298f,
0.001579500864f,
0.001580993448f,
0.001581583869f,
0.001581278327f,
0.001580084274f,
0.001578010246f,
0.001575065681f,
0.001571260713f,
0.001566605956f,
0.00156111229f,
0.001554790646f,
0.001547651808f,
0.001539706232f,
0.001530963894f,
0.001521434166f,
0.001511125736f,
0.001500046561f,
0.001488203863f,
0.00147560417f,
0.001462253395f,
0.001448156952f,
0.001433319907f,
0.001417747156f,
0.001401443629f,
0.001384414497f,
0.001366665397f,
0.001348202649f,
0.001329033461f,
0.00130916612f,
0.001288610154f,
0.001267376463f,
0.001245477408f,
0.001222926868f,
0.001199740242f,
0.001175934412f,
0.001151527663f,
0.001126539553f,
0.001100990752f,
0.001074902849f,
0.001048298127f,
0.001021199318f,
0.0009936293625f,
0.0009656111448f,
0.0009371672552f,
0.0009083197575f,
0.0008790899843f,
0.0008494983631f,
0.0008195642809f,
0.0007893059911f,
0.0007587405668f,
0.0007278839018f,
0.0006967507604f,
0.0006653548722f,
0.0006337090709f,
0.0006018254694f,
0.0005697156677f,
0.0005373909824f,
0.0005048626928f,
0.0004721422912f,
0.0004392417305f,
0.0004061736573f,
0.0003729516234f,
0.0003395902659f,
0.0003061054502f,
0.0002725143679f,
0.0002388355872f,
0.0002050890521f,
0.0001712960301f,
0.000137479009f,
0.000103661546f,
6.986807423e-05f,
3.612367251e-05f,
2.453806297e-06f,
-3.111595112e-05f,
-6.456020775e-05f,
-9.785404197e-05f,
-0.0001309732814f,
-0.0001638947616f,
-0.0001965965552f,
-0.000229058163f,
-0.0002612606604f,
-0.0002931867933f,
-0.0003248210202f,
-0.0003561494979f,
-0.0003871600126f,
-0.0004178418572f,
-0.0004481856602f,
-0.000478183172f,
-0.0005078270155f,
-0.0005371104115f,
-0.0005660268883f,
-0.0005945699862f,
-0.0006227329675f,
-0.0006505085449f,
-0.0006778886355f,
-0.0007048641534f,
-0.0007314248461f,
-0.0007575591833f,
-0.0007832543026f,
-0.0008084960133f,
-0.0008332688615f,
-0.0008575562527f,
-0.0008813406291f,
-0.0009046036963f,
-0.00092732669f,
-0.0009494906762f,
-0.0009710768709f,
-0.000992066972f,
-0.001012443487f,
-0.001032190051f,
-0.001051291711f,
-0.001069735186f,
-0.001087509071f,
-0.001104603993f,
-0.001121012708f,
-0.001136730126f,
-0.001151753284f,
-0.001166081245f,
-0.001179714936f,
-0.001192656932f,
-0.001204911194f,
-0.001216482759f,
-0.001227377412f,
-0.001237601331f,
-0.001247160736f,
-0.001256061543f,
-0.001264309039f,
-0.001271907595f,
-0.001278860419f,
-0.001285169367f,
-0.001290834812f,
-0.001295855584f,
-0.001300228978f,
-0.001303950832f,
-0.001307015676f,
-0.001309416937f,
-0.001311147213f,
-0.00131219858f,
-0.001312562947f,
-0.001312232424f,
-0.001311199712f,
-0.001309458474f,
-0.001307003703f,
-0.001303832047f,
-0.001299942095f,
-0.001295334608f,
-0.001290012681f,
-0.001283981841f,
-0.001277250064f,
-0.001269827712f,
-0.001261727404f,
-0.001252963806f,
-0.001243553356f,
-0.00123351394f,
-0.001222864512f,
-0.00121162469f,
-0.001199814333f,
-0.001187453114f,
-0.001174560104f,
-0.001161153388f,
-0.00114724972f,
-0.001132864237f,
-0.001118010235f,
-0.001102699019f,
-0.00108693984f,
-0.001070739908f,
-0.001054104496f,
-0.00103703712f,
-0.001019539795f,
-0.00100161336f,
-0.0009832578532f,
-0.0009644729339f,
-0.0009452583245f,
-0.0009256142676f,
-0.0009055419734f,
-0.0008850440439f,
-0.0008641248576f,
-0.0008427908993f,
-0.0008210510216f,
-0.0007989166291f,
-0.0007764017755f,
-0.0007535231693f,
-0.0007303000876f,
-0.0007067541982f,
-0.0006829092959f,
-0.0006587909614f,
-0.0006344261543f,
-0.000609842753f,
-0.000585069059f,
-0.0005601332818f,
-0.0005350630229f,
-0.0005098847787f,
-0.0004846234787f,
-0.0004593020771f,
-0.0004339412137f,
-0.0004085589553f,
-0.0003831706297f,
-0.0003577887581f,
-0.0003324230891f,
-0.0003070807356f,
-0.0002817664086f,
-0.0002564827412f,
-0.0002312306922f,
-0.0002060100144f,
-0.000180819771f,
-0.0001556588822f,
-0.0001305266816f,
-0.0001054234615f,
-8.035098718e-05f,
-5.531296097e-05f,
-3.031541695e-05f,
-5.367031918e-06f,
1.952066077e-05f,
4.433316377e-05f,
6.905302015e-05f,
9.365993136e-05f,
0.0001181309861f,
0.0001424409932f,
0.0001665629085f,
0.0001904683407f,
0.0002141281198f,
0.0002375129076f,
0.000260593829f,
0.0002833431018f,
0.0003057346413f,
0.000327744618f,
0.0003493519474f,
0.000370538693f,
0.0003912903675f,
0.0004115961182f,
0.0004314487908f,
0.0004508448659f,
0.0004697842696f,
0.0004882700639f,
0.0005063080258f,
0.0005239061306f,
0.0005410739552f,
0.0005578220246f,
0.0005741611231f,
0.0005901015953f,
0.0006056526639f,
0.0006208217879f,
0.0006356140867f,
0.0006500318514f,
0.0006640741636f,
0.0006777366361f,
0.0006910112877f,
0.0007038865587f,
0.0007163474686f,
0.0007283759114f,
0.0007399510819f,
0.0007510500173f,
0.000761648237f,
0.0007717204584f,
0.000781241364f,
0.0007901863919f,
0.0007985325216f,
0.0008062590262f,
0.000813348162f,
0.0008197857713f,
0.0008255617728f,
0.0008306705214f,
0.0008351110213f,
0.000838886983f,
0.0008420067192f,
0.0008444828811f,
0.0008463320422f,
0.0008475741426f,
0.0008482318111f,
0.0008483295899f,
0.0008478930861f,
0.0008469480822f,
0.0008455196361f,
0.0008436312041f,
0.0008413038186f,
0.0008385553524f,
0.0008353998968f,
0.0008318472792f,
0.0008279027389f,
0.0008235667768f,
0.0008188351858f,
0.0008136992649f,
0.0008081462114f,
0.0008021596799f,
0.0007957204907f,
0.0007888074628f,
0.0007813983441f,
0.0007734708068f,
0.0007650034695f,
0.0007559769134f,
0.0007463746504f,
0.0007361840104f,
0.0007253969116f,
0.0007140104839f,
0.00070202752f,
0.0006894567347f,
0.0006763128181f,
0.0006626162792f,
0.0006483930788f,
0.0006336740639f,
0.0006184942187f,
0.0006028917574f,
0.0005869070879f,
0.0005705816824f,
0.0005539568946f,
0.0005370727651f,
0.0005199668582f,
0.0005026731745f,
0.0004852211777f,
0.0004676349762f,
0.0004499326898f,
0.0004321260294f,
0.0004142201075f,
0.0003962134928f,
0.000378098509f,
0.0003598617727f,
0.0003414849548f,
0.0003229457419f,
0.0003042189651f,
0.00028527786f,
0.000266095411f,
0.0002466457362f,
0.0002269054586f,
0.0002068550158f,
0.000186479858f,
0.000165771487f,
0.0001447282964f,
0.0001233561766f,
0.0001016688577f,
7.968797315e-05f,
5.74428337e-05f,
3.496991619e-05f,
1.231207768e-05f,
-1.048248133e-05f,
-3.336147243e-05f,
-5.62699525e-05f,
-7.915188619e-05f,
-0.0001019517835f,
-0.0001246163542f,
-0.0001470961197f,
-0.0001693469221f,
-0.0001913312733f,
-0.0002130194919f,
-0.0002343905815f,
-0.0002554328125f,
-0.0002761439806f,
-0.0002965313237f,
-0.0003166110953f,
-0.0003364077994f,
-0.0003559531098f,
-0.0003752845049f,
-0.0003944436616f,
-0.0004134746619f,
-0.0004324220733f,
-0.000451328971f,
-0.0004702349712f,
-0.0004891743504f,
-0.0005081743191f,
-0.0005272535187f,
-0.0005464208012f,
-0.000565674343f,
-0.0005850011351f,
-0.0006043768758f,
-0.0006237662813f,
-0.000643123813f,
-0.0006623948059f,
-0.0006815169664f,
-0.0007004221955f,
-0.0007190386786f,
-0.0007372931729f,
-0.0007551134139f,
-0.0007724305568f,
-0.0007891815649f,
-0.0008053114561f,
-0.0008207753218f,
-0.0008355400394f,
-0.000849585607f,
-0.0008629060419f,
-0.0008755097975f,
-0.0008874196714f,
-0.0008986721934f,
-0.0009093165006f,
-0.0009194127277f,
-0.0009290299557f,
-0.0009382437826f,
-0.000947133593f,
-0.0009557796176f,
-0.0009642598835f,
-0.0009726471624f,
-0.0009810060299f,
-0.0009893901426f,
-0.0009978398429f,
-0.001006380184f,
-0.001015019466f,
-0.001023748339f,
-0.001032539548f,
-0.001041348313f,
-0.001050113392f,
-0.001058758769f,
-0.001067195956f,
-0.001075326838f,
-0.001083046955f,
-0.001090249151f,
-0.001096827441f,
-0.001102680975f,
-0.001107717957f,
-0.001111859375f,
-0.001115042405f,
-0.001117223339f,
-0.001118379942f,
-0.001118513097f,
-0.001117647688f,
-0.001115832644f,
-0.001113140105f,
-0.001109663733f,
-0.00110551617f,
-0.001100825729f,
-0.001095732388f,
-0.001090383216f,
-0.001084927375f,
-0.00107951086f,
-0.00107427115f,
-0.001069331977f,
-0.001064798376f,
-0.001060752246f,
-0.001057248556f,
-0.001054312397f,
-0.001051936999f,
-0.001050082826f,
-0.001048677837f,
-0.001047618931f,
-0.001046774602f,
-0.001045988738f,
-0.001045085483f,
-0.001043875042f,
-0.001042160255f,
-0.001039743741f,
-0.001036435385f,
-0.001032059913f,
-0.001026464295f,
-0.001019524694f,
-0.001011152711f,
-0.001001300644f,
-0.0009899655542f,
-0.0009771919183f,
-0.0009630727129f,
-0.0009477488098f,
-0.0009314066204f,
-0.0009142739828f,
-0.0008966143449f,
-0.0008787193594f,
-0.0008609000659f,
-0.0008434768947f,
-0.0008267687761f,
-0.0008110816887f,
-0.0007966970122f,
-0.0007838600814f,
-0.0007727693485f,
-0.0007635665655f,
-0.0007563283846f,
-0.0007510597525f,
-0.0007476894325f,
-0.0007460679377f,
-0.000745968097f,
-0.0007470883973f,
-0.0007490591678f,
-0.0007514515768f,
-0.0007537893242f,
-0.0007555628132f,
-0.0007562454928f,
-0.0007553119746f,
-0.0007522574434f,
-0.0007466178098f,
-0.0007379899949f,
-0.0007260516891f,
-0.0007105799043f,
-0.0006914676255f,
-0.0006687378813f,
-0.0006425545826f,
-0.0006132295306f,
-0.0005812250668f,
-0.0005471519262f,
-0.0005117619638f,
-0.0004759355438f,
-0.0004406635165f,
-0.00040702385f,
-0.0003761531299f,
-0.0003492132918f,
-0.000327354098f,
-0.000311672008f,
-0.0003031662267f,
-0.0003026928256f,
-0.0003109179346f,
-0.0003282710744f,
-0.0003548997573f,
-0.0003906265097f,
-0.0004349094665f,
-0.0004868076654f,
-0.0005449521047f,
-0.0006075235484f,
-0.0006722379481f,
-0.0007363402138f,
-0.0007966069084f,
-0.0008493582639f,
-0.0008904797221f,
-0.0009154530048f,
-0.0009193965046f,
-0.0008971145833f,
-0.0008431551576f,
-0.0007518747549f,
-0.0006175100432f,
-0.000434254675f,
-0.0001963401425f,
0.0001018807659f,
0.0004658494099f,
0.0009007171884f,
0.001411263447f,
0.002001816954f,
0.002676182443f,
0.003437573643f,
0.004288554093f,
0.005230986901f,
0.006265994424f,
0.007393928667f,
0.008614352983f,
0.009926035406f,
0.01132695377f
};

}

#endif
