/*  
 *  Copyright (c) 2003 Dan Gudmundsson
 *  See the file "license.terms" for information on usage and redistribution
 *  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 *     $Id: esdl_glext.h,v 1.4 2003/08/29 13:31:47 dgud Exp $
 *
 */

#ifdef ESDL_DEFINE_EXTS
# define ESDL_EXTERN
#else
# define ESDL_EXTERN extern
#endif

enum { glBlendColorFunc = OPENGL_EXTS_H + 0 };
typedef void (APIENTRY * ESDLGLBLENDCOLORPROC)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
ESDL_EXTERN ESDLGLBLENDCOLORPROC esdl_glBlendColor;
void egl_blendColor (sdl_data *, int, char *); 
enum { glBlendEquationFunc = OPENGL_EXTS_H + 1 };
typedef void (APIENTRY * ESDLGLBLENDEQUATIONPROC)(GLenum mode);
ESDL_EXTERN ESDLGLBLENDEQUATIONPROC esdl_glBlendEquation;
void egl_blendEquation (sdl_data *, int, char *); 
enum { glDrawRangeElementsFunc = OPENGL_EXTS_H + 2 };
typedef void (APIENTRY * ESDLGLDRAWRANGEELEMENTSPROC)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type,  const GLvoid * indices);
ESDL_EXTERN ESDLGLDRAWRANGEELEMENTSPROC esdl_glDrawRangeElements;
void egl_drawRangeElements (sdl_data *, int, char *); 
enum { glColorTableFunc = OPENGL_EXTS_H + 3 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPROC)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type,  const GLvoid * table);
ESDL_EXTERN ESDLGLCOLORTABLEPROC esdl_glColorTable;
void egl_colorTable (sdl_data *, int, char *); 
enum { glColorTableParameterfvFunc = OPENGL_EXTS_H + 4 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPARAMETERFVPROC)(GLenum target, GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLCOLORTABLEPARAMETERFVPROC esdl_glColorTableParameterfv;
void egl_colorTableParameterfv (sdl_data *, int, char *); 
enum { glColorTableParameterivFunc = OPENGL_EXTS_H + 5 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPARAMETERIVPROC)(GLenum target, GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLCOLORTABLEPARAMETERIVPROC esdl_glColorTableParameteriv;
void egl_colorTableParameteriv (sdl_data *, int, char *); 
enum { glCopyColorTableFunc = OPENGL_EXTS_H + 6 };
typedef void (APIENTRY * ESDLGLCOPYCOLORTABLEPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCOLORTABLEPROC esdl_glCopyColorTable;
void egl_copyColorTable (sdl_data *, int, char *); 
enum { glGetColorTableFunc = OPENGL_EXTS_H + 7 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPROC)(GLenum target, GLenum format, GLenum type, GLvoid * table);
ESDL_EXTERN ESDLGLGETCOLORTABLEPROC esdl_glGetColorTable;
void egl_getColorTable (sdl_data *, int, char *); 
enum { glGetColorTableParameterfvFunc = OPENGL_EXTS_H + 8 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETCOLORTABLEPARAMETERFVPROC esdl_glGetColorTableParameterfv;
void egl_getColorTableParameterfv (sdl_data *, int, char *); 
enum { glGetColorTableParameterivFunc = OPENGL_EXTS_H + 9 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETCOLORTABLEPARAMETERIVPROC esdl_glGetColorTableParameteriv;
void egl_getColorTableParameteriv (sdl_data *, int, char *); 
enum { glColorSubTableFunc = OPENGL_EXTS_H + 10 };
typedef void (APIENTRY * ESDLGLCOLORSUBTABLEPROC)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOLORSUBTABLEPROC esdl_glColorSubTable;
void egl_colorSubTable (sdl_data *, int, char *); 
enum { glCopyColorSubTableFunc = OPENGL_EXTS_H + 11 };
typedef void (APIENTRY * ESDLGLCOPYCOLORSUBTABLEPROC)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCOLORSUBTABLEPROC esdl_glCopyColorSubTable;
void egl_copyColorSubTable (sdl_data *, int, char *); 
enum { glConvolutionFilter1DFunc = OPENGL_EXTS_H + 12 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONFILTER1DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type,  const GLvoid * image);
ESDL_EXTERN ESDLGLCONVOLUTIONFILTER1DPROC esdl_glConvolutionFilter1D;
void egl_convolutionFilter1D (sdl_data *, int, char *); 
enum { glConvolutionFilter2DFunc = OPENGL_EXTS_H + 13 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONFILTER2DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type,  const GLvoid * image);
ESDL_EXTERN ESDLGLCONVOLUTIONFILTER2DPROC esdl_glConvolutionFilter2D;
void egl_convolutionFilter2D (sdl_data *, int, char *); 
enum { glConvolutionParameterfFunc = OPENGL_EXTS_H + 14 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERFPROC)(GLenum target, GLenum pname, GLfloat params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERFPROC esdl_glConvolutionParameterf;
void egl_convolutionParameterf (sdl_data *, int, char *); 
enum { glConvolutionParameterfvFunc = OPENGL_EXTS_H + 15 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERFVPROC)(GLenum target, GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERFVPROC esdl_glConvolutionParameterfv;
void egl_convolutionParameterfv (sdl_data *, int, char *); 
enum { glConvolutionParameteriFunc = OPENGL_EXTS_H + 16 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERIPROC)(GLenum target, GLenum pname, GLint params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERIPROC esdl_glConvolutionParameteri;
void egl_convolutionParameteri (sdl_data *, int, char *); 
enum { glConvolutionParameterivFunc = OPENGL_EXTS_H + 17 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERIVPROC)(GLenum target, GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERIVPROC esdl_glConvolutionParameteriv;
void egl_convolutionParameteriv (sdl_data *, int, char *); 
enum { glCopyConvolutionFilter1DFunc = OPENGL_EXTS_H + 18 };
typedef void (APIENTRY * ESDLGLCOPYCONVOLUTIONFILTER1DPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCONVOLUTIONFILTER1DPROC esdl_glCopyConvolutionFilter1D;
void egl_copyConvolutionFilter1D (sdl_data *, int, char *); 
enum { glCopyConvolutionFilter2DFunc = OPENGL_EXTS_H + 19 };
typedef void (APIENTRY * ESDLGLCOPYCONVOLUTIONFILTER2DPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
ESDL_EXTERN ESDLGLCOPYCONVOLUTIONFILTER2DPROC esdl_glCopyConvolutionFilter2D;
void egl_copyConvolutionFilter2D (sdl_data *, int, char *); 
enum { glGetConvolutionFilterFunc = OPENGL_EXTS_H + 20 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONFILTERPROC)(GLenum target, GLenum format, GLenum type, GLvoid * image);
ESDL_EXTERN ESDLGLGETCONVOLUTIONFILTERPROC esdl_glGetConvolutionFilter;
void egl_getConvolutionFilter (sdl_data *, int, char *); 
enum { glGetConvolutionParameterfvFunc = OPENGL_EXTS_H + 21 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETCONVOLUTIONPARAMETERFVPROC esdl_glGetConvolutionParameterfv;
void egl_getConvolutionParameterfv (sdl_data *, int, char *); 
enum { glGetConvolutionParameterivFunc = OPENGL_EXTS_H + 22 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETCONVOLUTIONPARAMETERIVPROC esdl_glGetConvolutionParameteriv;
void egl_getConvolutionParameteriv (sdl_data *, int, char *); 
enum { glGetSeparableFilterFunc = OPENGL_EXTS_H + 23 };
typedef void (APIENTRY * ESDLGLGETSEPARABLEFILTERPROC)(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span);
ESDL_EXTERN ESDLGLGETSEPARABLEFILTERPROC esdl_glGetSeparableFilter;
void egl_getSeparableFilter (sdl_data *, int, char *); 
enum { glSeparableFilter2DFunc = OPENGL_EXTS_H + 24 };
typedef void (APIENTRY * ESDLGLSEPARABLEFILTER2DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type,  const GLvoid * row,  const GLvoid * column);
ESDL_EXTERN ESDLGLSEPARABLEFILTER2DPROC esdl_glSeparableFilter2D;
void egl_separableFilter2D (sdl_data *, int, char *); 
enum { glGetHistogramFunc = OPENGL_EXTS_H + 25 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPROC)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values);
ESDL_EXTERN ESDLGLGETHISTOGRAMPROC esdl_glGetHistogram;
void egl_getHistogram (sdl_data *, int, char *); 
enum { glGetHistogramParameterfvFunc = OPENGL_EXTS_H + 26 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETHISTOGRAMPARAMETERFVPROC esdl_glGetHistogramParameterfv;
void egl_getHistogramParameterfv (sdl_data *, int, char *); 
enum { glGetHistogramParameterivFunc = OPENGL_EXTS_H + 27 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETHISTOGRAMPARAMETERIVPROC esdl_glGetHistogramParameteriv;
void egl_getHistogramParameteriv (sdl_data *, int, char *); 
enum { glGetMinmaxFunc = OPENGL_EXTS_H + 28 };
typedef void (APIENTRY * ESDLGLGETMINMAXPROC)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values);
ESDL_EXTERN ESDLGLGETMINMAXPROC esdl_glGetMinmax;
void egl_getMinmax (sdl_data *, int, char *); 
enum { glGetMinmaxParameterfvFunc = OPENGL_EXTS_H + 29 };
typedef void (APIENTRY * ESDLGLGETMINMAXPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETMINMAXPARAMETERFVPROC esdl_glGetMinmaxParameterfv;
void egl_getMinmaxParameterfv (sdl_data *, int, char *); 
enum { glGetMinmaxParameterivFunc = OPENGL_EXTS_H + 30 };
typedef void (APIENTRY * ESDLGLGETMINMAXPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETMINMAXPARAMETERIVPROC esdl_glGetMinmaxParameteriv;
void egl_getMinmaxParameteriv (sdl_data *, int, char *); 
enum { glHistogramFunc = OPENGL_EXTS_H + 31 };
typedef void (APIENTRY * ESDLGLHISTOGRAMPROC)(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
ESDL_EXTERN ESDLGLHISTOGRAMPROC esdl_glHistogram;
void egl_histogram (sdl_data *, int, char *); 
enum { glMinmaxFunc = OPENGL_EXTS_H + 32 };
typedef void (APIENTRY * ESDLGLMINMAXPROC)(GLenum target, GLenum internalformat, GLboolean sink);
ESDL_EXTERN ESDLGLMINMAXPROC esdl_glMinmax;
void egl_minmax (sdl_data *, int, char *); 
enum { glResetHistogramFunc = OPENGL_EXTS_H + 33 };
typedef void (APIENTRY * ESDLGLRESETHISTOGRAMPROC)(GLenum target);
ESDL_EXTERN ESDLGLRESETHISTOGRAMPROC esdl_glResetHistogram;
void egl_resetHistogram (sdl_data *, int, char *); 
enum { glResetMinmaxFunc = OPENGL_EXTS_H + 34 };
typedef void (APIENTRY * ESDLGLRESETMINMAXPROC)(GLenum target);
ESDL_EXTERN ESDLGLRESETMINMAXPROC esdl_glResetMinmax;
void egl_resetMinmax (sdl_data *, int, char *); 
enum { glTexImage3DFunc = OPENGL_EXTS_H + 35 };
typedef void (APIENTRY * ESDLGLTEXIMAGE3DPROC)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type,  const GLvoid * pixels);
ESDL_EXTERN ESDLGLTEXIMAGE3DPROC esdl_glTexImage3D;
void egl_texImage3D (sdl_data *, int, char *); 
enum { glTexSubImage3DFunc = OPENGL_EXTS_H + 36 };
typedef void (APIENTRY * ESDLGLTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type,  const GLvoid * pixels);
ESDL_EXTERN ESDLGLTEXSUBIMAGE3DPROC esdl_glTexSubImage3D;
void egl_texSubImage3D (sdl_data *, int, char *); 
enum { glCopyTexSubImage3DFunc = OPENGL_EXTS_H + 37 };
typedef void (APIENTRY * ESDLGLCOPYTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
ESDL_EXTERN ESDLGLCOPYTEXSUBIMAGE3DPROC esdl_glCopyTexSubImage3D;
void egl_copyTexSubImage3D (sdl_data *, int, char *); 
enum { glActiveTextureFunc = OPENGL_EXTS_H + 38 };
typedef void (APIENTRY * ESDLGLACTIVETEXTUREPROC)(GLenum texture);
ESDL_EXTERN ESDLGLACTIVETEXTUREPROC esdl_glActiveTexture;
void egl_activeTexture (sdl_data *, int, char *); 
enum { glClientActiveTextureFunc = OPENGL_EXTS_H + 39 };
typedef void (APIENTRY * ESDLGLCLIENTACTIVETEXTUREPROC)(GLenum texture);
ESDL_EXTERN ESDLGLCLIENTACTIVETEXTUREPROC esdl_glClientActiveTexture;
void egl_clientActiveTexture (sdl_data *, int, char *); 
enum { glMultiTexCoord1dvFunc = OPENGL_EXTS_H + 40 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1DVPROC esdl_glMultiTexCoord1dv;
void egl_multiTexCoord1dv (sdl_data *, int, char *); 
enum { glMultiTexCoord1fvFunc = OPENGL_EXTS_H + 41 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1FVPROC esdl_glMultiTexCoord1fv;
void egl_multiTexCoord1fv (sdl_data *, int, char *); 
enum { glMultiTexCoord1ivFunc = OPENGL_EXTS_H + 42 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1IVPROC esdl_glMultiTexCoord1iv;
void egl_multiTexCoord1iv (sdl_data *, int, char *); 
enum { glMultiTexCoord1svFunc = OPENGL_EXTS_H + 43 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1SVPROC esdl_glMultiTexCoord1sv;
void egl_multiTexCoord1sv (sdl_data *, int, char *); 
enum { glMultiTexCoord2dvFunc = OPENGL_EXTS_H + 44 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2DVPROC esdl_glMultiTexCoord2dv;
void egl_multiTexCoord2dv (sdl_data *, int, char *); 
enum { glMultiTexCoord2fvFunc = OPENGL_EXTS_H + 45 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2FVPROC esdl_glMultiTexCoord2fv;
void egl_multiTexCoord2fv (sdl_data *, int, char *); 
enum { glMultiTexCoord2ivFunc = OPENGL_EXTS_H + 46 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2IVPROC esdl_glMultiTexCoord2iv;
void egl_multiTexCoord2iv (sdl_data *, int, char *); 
enum { glMultiTexCoord2svFunc = OPENGL_EXTS_H + 47 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2SVPROC esdl_glMultiTexCoord2sv;
void egl_multiTexCoord2sv (sdl_data *, int, char *); 
enum { glMultiTexCoord3dvFunc = OPENGL_EXTS_H + 48 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3DVPROC esdl_glMultiTexCoord3dv;
void egl_multiTexCoord3dv (sdl_data *, int, char *); 
enum { glMultiTexCoord3fvFunc = OPENGL_EXTS_H + 49 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3FVPROC esdl_glMultiTexCoord3fv;
void egl_multiTexCoord3fv (sdl_data *, int, char *); 
enum { glMultiTexCoord3ivFunc = OPENGL_EXTS_H + 50 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3IVPROC esdl_glMultiTexCoord3iv;
void egl_multiTexCoord3iv (sdl_data *, int, char *); 
enum { glMultiTexCoord3svFunc = OPENGL_EXTS_H + 51 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3SVPROC esdl_glMultiTexCoord3sv;
void egl_multiTexCoord3sv (sdl_data *, int, char *); 
enum { glMultiTexCoord4dvFunc = OPENGL_EXTS_H + 52 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4DVPROC esdl_glMultiTexCoord4dv;
void egl_multiTexCoord4dv (sdl_data *, int, char *); 
enum { glMultiTexCoord4fvFunc = OPENGL_EXTS_H + 53 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4FVPROC esdl_glMultiTexCoord4fv;
void egl_multiTexCoord4fv (sdl_data *, int, char *); 
enum { glMultiTexCoord4ivFunc = OPENGL_EXTS_H + 54 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4IVPROC esdl_glMultiTexCoord4iv;
void egl_multiTexCoord4iv (sdl_data *, int, char *); 
enum { glMultiTexCoord4svFunc = OPENGL_EXTS_H + 55 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4SVPROC esdl_glMultiTexCoord4sv;
void egl_multiTexCoord4sv (sdl_data *, int, char *); 
enum { glLoadTransposeMatrixfFunc = OPENGL_EXTS_H + 56 };
typedef void (APIENTRY * ESDLGLLOADTRANSPOSEMATRIXFPROC)( const GLfloat * m);
ESDL_EXTERN ESDLGLLOADTRANSPOSEMATRIXFPROC esdl_glLoadTransposeMatrixf;
void egl_loadTransposeMatrixf (sdl_data *, int, char *); 
enum { glLoadTransposeMatrixdFunc = OPENGL_EXTS_H + 57 };
typedef void (APIENTRY * ESDLGLLOADTRANSPOSEMATRIXDPROC)( const GLdouble * m);
ESDL_EXTERN ESDLGLLOADTRANSPOSEMATRIXDPROC esdl_glLoadTransposeMatrixd;
void egl_loadTransposeMatrixd (sdl_data *, int, char *); 
enum { glMultTransposeMatrixfFunc = OPENGL_EXTS_H + 58 };
typedef void (APIENTRY * ESDLGLMULTTRANSPOSEMATRIXFPROC)( const GLfloat * m);
ESDL_EXTERN ESDLGLMULTTRANSPOSEMATRIXFPROC esdl_glMultTransposeMatrixf;
void egl_multTransposeMatrixf (sdl_data *, int, char *); 
enum { glMultTransposeMatrixdFunc = OPENGL_EXTS_H + 59 };
typedef void (APIENTRY * ESDLGLMULTTRANSPOSEMATRIXDPROC)( const GLdouble * m);
ESDL_EXTERN ESDLGLMULTTRANSPOSEMATRIXDPROC esdl_glMultTransposeMatrixd;
void egl_multTransposeMatrixd (sdl_data *, int, char *); 
enum { glSampleCoverageFunc = OPENGL_EXTS_H + 60 };
typedef void (APIENTRY * ESDLGLSAMPLECOVERAGEPROC)(GLclampf value, GLboolean invert);
ESDL_EXTERN ESDLGLSAMPLECOVERAGEPROC esdl_glSampleCoverage;
void egl_sampleCoverage (sdl_data *, int, char *); 
enum { glCompressedTexImage3DFunc = OPENGL_EXTS_H + 61 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE3DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE3DPROC esdl_glCompressedTexImage3D;
void egl_compressedTexImage3D (sdl_data *, int, char *); 
enum { glCompressedTexImage2DFunc = OPENGL_EXTS_H + 62 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE2DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE2DPROC esdl_glCompressedTexImage2D;
void egl_compressedTexImage2D (sdl_data *, int, char *); 
enum { glCompressedTexImage1DFunc = OPENGL_EXTS_H + 63 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE1DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE1DPROC esdl_glCompressedTexImage1D;
void egl_compressedTexImage1D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage3DFunc = OPENGL_EXTS_H + 64 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE3DPROC esdl_glCompressedTexSubImage3D;
void egl_compressedTexSubImage3D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage2DFunc = OPENGL_EXTS_H + 65 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE2DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE2DPROC esdl_glCompressedTexSubImage2D;
void egl_compressedTexSubImage2D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage1DFunc = OPENGL_EXTS_H + 66 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE1DPROC)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE1DPROC esdl_glCompressedTexSubImage1D;
void egl_compressedTexSubImage1D (sdl_data *, int, char *); 
enum { glGetCompressedTexImageFunc = OPENGL_EXTS_H + 67 };
typedef void (APIENTRY * ESDLGLGETCOMPRESSEDTEXIMAGEPROC)(GLenum target, GLint level, void * img);
ESDL_EXTERN ESDLGLGETCOMPRESSEDTEXIMAGEPROC esdl_glGetCompressedTexImage;
void egl_getCompressedTexImage (sdl_data *, int, char *); 
enum { glBlendFuncSeparateFunc = OPENGL_EXTS_H + 68 };
typedef void (APIENTRY * ESDLGLBLENDFUNCSEPARATEPROC)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
ESDL_EXTERN ESDLGLBLENDFUNCSEPARATEPROC esdl_glBlendFuncSeparate;
void egl_blendFuncSeparate (sdl_data *, int, char *); 
enum { glFogCoordfFunc = OPENGL_EXTS_H + 69 };
typedef void (APIENTRY * ESDLGLFOGCOORDFPROC)(GLfloat coord);
ESDL_EXTERN ESDLGLFOGCOORDFPROC esdl_glFogCoordf;
void egl_fogCoordf (sdl_data *, int, char *); 
enum { glFogCoordfvFunc = OPENGL_EXTS_H + 70 };
typedef void (APIENTRY * ESDLGLFOGCOORDFVPROC)( const GLfloat * coord);
ESDL_EXTERN ESDLGLFOGCOORDFVPROC esdl_glFogCoordfv;
void egl_fogCoordfv (sdl_data *, int, char *); 
enum { glFogCoorddFunc = OPENGL_EXTS_H + 71 };
typedef void (APIENTRY * ESDLGLFOGCOORDDPROC)(GLdouble coord);
ESDL_EXTERN ESDLGLFOGCOORDDPROC esdl_glFogCoordd;
void egl_fogCoordd (sdl_data *, int, char *); 
enum { glFogCoorddvFunc = OPENGL_EXTS_H + 72 };
typedef void (APIENTRY * ESDLGLFOGCOORDDVPROC)( const GLdouble * coord);
ESDL_EXTERN ESDLGLFOGCOORDDVPROC esdl_glFogCoorddv;
void egl_fogCoorddv (sdl_data *, int, char *); 
enum { glFogCoordPointerFunc = OPENGL_EXTS_H + 73 };
typedef void (APIENTRY * ESDLGLFOGCOORDPOINTERPROC)(GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLFOGCOORDPOINTERPROC esdl_glFogCoordPointer;
void egl_fogCoordPointer (sdl_data *, int, char *); 
enum { glMultiDrawArraysFunc = OPENGL_EXTS_H + 74 };
typedef void (APIENTRY * ESDLGLMULTIDRAWARRAYSPROC)(GLenum mode,  const GLint * first,  const GLsizei * count, GLsizei primcount);
ESDL_EXTERN ESDLGLMULTIDRAWARRAYSPROC esdl_glMultiDrawArrays;
void egl_multiDrawArrays (sdl_data *, int, char *); 
enum { glPointParameterfFunc = OPENGL_EXTS_H + 75 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERFPROC)(GLenum pname, GLfloat param);
ESDL_EXTERN ESDLGLPOINTPARAMETERFPROC esdl_glPointParameterf;
void egl_pointParameterf (sdl_data *, int, char *); 
enum { glPointParameterfvFunc = OPENGL_EXTS_H + 76 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERFVPROC)(GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLPOINTPARAMETERFVPROC esdl_glPointParameterfv;
void egl_pointParameterfv (sdl_data *, int, char *); 
enum { glPointParameteriFunc = OPENGL_EXTS_H + 77 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERIPROC)(GLenum pname, GLint param);
ESDL_EXTERN ESDLGLPOINTPARAMETERIPROC esdl_glPointParameteri;
void egl_pointParameteri (sdl_data *, int, char *); 
enum { glPointParameterivFunc = OPENGL_EXTS_H + 78 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERIVPROC)(GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLPOINTPARAMETERIVPROC esdl_glPointParameteriv;
void egl_pointParameteriv (sdl_data *, int, char *); 
enum { glSecondaryColor3bvFunc = OPENGL_EXTS_H + 79 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3BVPROC)( const GLbyte * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3BVPROC esdl_glSecondaryColor3bv;
void egl_secondaryColor3bv (sdl_data *, int, char *); 
enum { glSecondaryColor3dvFunc = OPENGL_EXTS_H + 80 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3DVPROC esdl_glSecondaryColor3dv;
void egl_secondaryColor3dv (sdl_data *, int, char *); 
enum { glSecondaryColor3fvFunc = OPENGL_EXTS_H + 81 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3FVPROC esdl_glSecondaryColor3fv;
void egl_secondaryColor3fv (sdl_data *, int, char *); 
enum { glSecondaryColor3ivFunc = OPENGL_EXTS_H + 82 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3IVPROC esdl_glSecondaryColor3iv;
void egl_secondaryColor3iv (sdl_data *, int, char *); 
enum { glSecondaryColor3svFunc = OPENGL_EXTS_H + 83 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3SVPROC esdl_glSecondaryColor3sv;
void egl_secondaryColor3sv (sdl_data *, int, char *); 
enum { glSecondaryColor3ubvFunc = OPENGL_EXTS_H + 84 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3UBVPROC)( const GLubyte * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3UBVPROC esdl_glSecondaryColor3ubv;
void egl_secondaryColor3ubv (sdl_data *, int, char *); 
enum { glSecondaryColor3uivFunc = OPENGL_EXTS_H + 85 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3UIVPROC)( const GLuint * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3UIVPROC esdl_glSecondaryColor3uiv;
void egl_secondaryColor3uiv (sdl_data *, int, char *); 
enum { glSecondaryColor3usvFunc = OPENGL_EXTS_H + 86 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3USVPROC)( const GLushort * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3USVPROC esdl_glSecondaryColor3usv;
void egl_secondaryColor3usv (sdl_data *, int, char *); 
enum { glSecondaryColorPointerFunc = OPENGL_EXTS_H + 87 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLORPOINTERPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLSECONDARYCOLORPOINTERPROC esdl_glSecondaryColorPointer;
void egl_secondaryColorPointer (sdl_data *, int, char *); 
enum { glWindowPos2dvFunc = OPENGL_EXTS_H + 88 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLWINDOWPOS2DVPROC esdl_glWindowPos2dv;
void egl_windowPos2dv (sdl_data *, int, char *); 
enum { glWindowPos2fvFunc = OPENGL_EXTS_H + 89 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLWINDOWPOS2FVPROC esdl_glWindowPos2fv;
void egl_windowPos2fv (sdl_data *, int, char *); 
enum { glWindowPos2ivFunc = OPENGL_EXTS_H + 90 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLWINDOWPOS2IVPROC esdl_glWindowPos2iv;
void egl_windowPos2iv (sdl_data *, int, char *); 
enum { glWindowPos2svFunc = OPENGL_EXTS_H + 91 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLWINDOWPOS2SVPROC esdl_glWindowPos2sv;
void egl_windowPos2sv (sdl_data *, int, char *); 
enum { glWindowPos3dvFunc = OPENGL_EXTS_H + 92 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLWINDOWPOS3DVPROC esdl_glWindowPos3dv;
void egl_windowPos3dv (sdl_data *, int, char *); 
enum { glWindowPos3fvFunc = OPENGL_EXTS_H + 93 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLWINDOWPOS3FVPROC esdl_glWindowPos3fv;
void egl_windowPos3fv (sdl_data *, int, char *); 
enum { glWindowPos3ivFunc = OPENGL_EXTS_H + 94 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLWINDOWPOS3IVPROC esdl_glWindowPos3iv;
void egl_windowPos3iv (sdl_data *, int, char *); 
enum { glWindowPos3svFunc = OPENGL_EXTS_H + 95 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLWINDOWPOS3SVPROC esdl_glWindowPos3sv;
void egl_windowPos3sv (sdl_data *, int, char *); 
enum { glWeightbvARBFunc = OPENGL_EXTS_H + 96 };
typedef void (APIENTRY * ESDLGLWEIGHTBVARBPROC)(GLint size,  const GLbyte * weights);
ESDL_EXTERN ESDLGLWEIGHTBVARBPROC esdl_glWeightbvARB;
void egl_weightbvARB (sdl_data *, int, char *); 
enum { glWeightsvARBFunc = OPENGL_EXTS_H + 97 };
typedef void (APIENTRY * ESDLGLWEIGHTSVARBPROC)(GLint size,  const GLshort * weights);
ESDL_EXTERN ESDLGLWEIGHTSVARBPROC esdl_glWeightsvARB;
void egl_weightsvARB (sdl_data *, int, char *); 
enum { glWeightivARBFunc = OPENGL_EXTS_H + 98 };
typedef void (APIENTRY * ESDLGLWEIGHTIVARBPROC)(GLint size,  const GLint * weights);
ESDL_EXTERN ESDLGLWEIGHTIVARBPROC esdl_glWeightivARB;
void egl_weightivARB (sdl_data *, int, char *); 
enum { glWeightfvARBFunc = OPENGL_EXTS_H + 99 };
typedef void (APIENTRY * ESDLGLWEIGHTFVARBPROC)(GLint size,  const GLfloat * weights);
ESDL_EXTERN ESDLGLWEIGHTFVARBPROC esdl_glWeightfvARB;
void egl_weightfvARB (sdl_data *, int, char *); 
enum { glWeightdvARBFunc = OPENGL_EXTS_H + 100 };
typedef void (APIENTRY * ESDLGLWEIGHTDVARBPROC)(GLint size,  const GLdouble * weights);
ESDL_EXTERN ESDLGLWEIGHTDVARBPROC esdl_glWeightdvARB;
void egl_weightdvARB (sdl_data *, int, char *); 
enum { glWeightubvARBFunc = OPENGL_EXTS_H + 101 };
typedef void (APIENTRY * ESDLGLWEIGHTUBVARBPROC)(GLint size,  const GLubyte * weights);
ESDL_EXTERN ESDLGLWEIGHTUBVARBPROC esdl_glWeightubvARB;
void egl_weightubvARB (sdl_data *, int, char *); 
enum { glWeightusvARBFunc = OPENGL_EXTS_H + 102 };
typedef void (APIENTRY * ESDLGLWEIGHTUSVARBPROC)(GLint size,  const GLushort * weights);
ESDL_EXTERN ESDLGLWEIGHTUSVARBPROC esdl_glWeightusvARB;
void egl_weightusvARB (sdl_data *, int, char *); 
enum { glWeightuivARBFunc = OPENGL_EXTS_H + 103 };
typedef void (APIENTRY * ESDLGLWEIGHTUIVARBPROC)(GLint size,  const GLuint * weights);
ESDL_EXTERN ESDLGLWEIGHTUIVARBPROC esdl_glWeightuivARB;
void egl_weightuivARB (sdl_data *, int, char *); 
enum { glWeightPointerARBFunc = OPENGL_EXTS_H + 104 };
typedef void (APIENTRY * ESDLGLWEIGHTPOINTERARBPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLWEIGHTPOINTERARBPROC esdl_glWeightPointerARB;
void egl_weightPointerARB (sdl_data *, int, char *); 
enum { glVertexBlendARBFunc = OPENGL_EXTS_H + 105 };
typedef void (APIENTRY * ESDLGLVERTEXBLENDARBPROC)(GLint count);
ESDL_EXTERN ESDLGLVERTEXBLENDARBPROC esdl_glVertexBlendARB;
void egl_vertexBlendARB (sdl_data *, int, char *); 
enum { glCurrentPaletteMatrixARBFunc = OPENGL_EXTS_H + 106 };
typedef void (APIENTRY * ESDLGLCURRENTPALETTEMATRIXARBPROC)(GLint index);
ESDL_EXTERN ESDLGLCURRENTPALETTEMATRIXARBPROC esdl_glCurrentPaletteMatrixARB;
void egl_currentPaletteMatrixARB (sdl_data *, int, char *); 
enum { glMatrixIndexubvARBFunc = OPENGL_EXTS_H + 107 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUBVARBPROC)(GLint size,  const GLubyte * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUBVARBPROC esdl_glMatrixIndexubvARB;
void egl_matrixIndexubvARB (sdl_data *, int, char *); 
enum { glMatrixIndexusvARBFunc = OPENGL_EXTS_H + 108 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUSVARBPROC)(GLint size,  const GLushort * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUSVARBPROC esdl_glMatrixIndexusvARB;
void egl_matrixIndexusvARB (sdl_data *, int, char *); 
enum { glMatrixIndexuivARBFunc = OPENGL_EXTS_H + 109 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUIVARBPROC)(GLint size,  const GLuint * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUIVARBPROC esdl_glMatrixIndexuivARB;
void egl_matrixIndexuivARB (sdl_data *, int, char *); 
enum { glMatrixIndexPointerARBFunc = OPENGL_EXTS_H + 110 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXPOINTERARBPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLMATRIXINDEXPOINTERARBPROC esdl_glMatrixIndexPointerARB;
void egl_matrixIndexPointerARB (sdl_data *, int, char *); 
enum { glVertexAttrib1dvARBFunc = OPENGL_EXTS_H + 111 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1DVARBPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1DVARBPROC esdl_glVertexAttrib1dvARB;
void egl_vertexAttrib1dvARB (sdl_data *, int, char *); 
enum { glVertexAttrib1fvARBFunc = OPENGL_EXTS_H + 112 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1FVARBPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1FVARBPROC esdl_glVertexAttrib1fvARB;
void egl_vertexAttrib1fvARB (sdl_data *, int, char *); 
enum { glVertexAttrib1svARBFunc = OPENGL_EXTS_H + 113 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1SVARBPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1SVARBPROC esdl_glVertexAttrib1svARB;
void egl_vertexAttrib1svARB (sdl_data *, int, char *); 
enum { glVertexAttrib2dvARBFunc = OPENGL_EXTS_H + 114 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2DVARBPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2DVARBPROC esdl_glVertexAttrib2dvARB;
void egl_vertexAttrib2dvARB (sdl_data *, int, char *); 
enum { glVertexAttrib2fvARBFunc = OPENGL_EXTS_H + 115 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2FVARBPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2FVARBPROC esdl_glVertexAttrib2fvARB;
void egl_vertexAttrib2fvARB (sdl_data *, int, char *); 
enum { glVertexAttrib2svARBFunc = OPENGL_EXTS_H + 116 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2SVARBPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2SVARBPROC esdl_glVertexAttrib2svARB;
void egl_vertexAttrib2svARB (sdl_data *, int, char *); 
enum { glVertexAttrib3dvARBFunc = OPENGL_EXTS_H + 117 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3DVARBPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3DVARBPROC esdl_glVertexAttrib3dvARB;
void egl_vertexAttrib3dvARB (sdl_data *, int, char *); 
enum { glVertexAttrib3fvARBFunc = OPENGL_EXTS_H + 118 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3FVARBPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3FVARBPROC esdl_glVertexAttrib3fvARB;
void egl_vertexAttrib3fvARB (sdl_data *, int, char *); 
enum { glVertexAttrib3svARBFunc = OPENGL_EXTS_H + 119 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3SVARBPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3SVARBPROC esdl_glVertexAttrib3svARB;
void egl_vertexAttrib3svARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NbvARBFunc = OPENGL_EXTS_H + 120 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NBVARBPROC)(GLuint index,  const GLbyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NBVARBPROC esdl_glVertexAttrib4NbvARB;
void egl_vertexAttrib4NbvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NivARBFunc = OPENGL_EXTS_H + 121 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NIVARBPROC)(GLuint index,  const GLint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NIVARBPROC esdl_glVertexAttrib4NivARB;
void egl_vertexAttrib4NivARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NsvARBFunc = OPENGL_EXTS_H + 122 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NSVARBPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NSVARBPROC esdl_glVertexAttrib4NsvARB;
void egl_vertexAttrib4NsvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NubARBFunc = OPENGL_EXTS_H + 123 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUBARBPROC)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUBARBPROC esdl_glVertexAttrib4NubARB;
void egl_vertexAttrib4NubARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NubvARBFunc = OPENGL_EXTS_H + 124 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUBVARBPROC)(GLuint index,  const GLubyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUBVARBPROC esdl_glVertexAttrib4NubvARB;
void egl_vertexAttrib4NubvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NuivARBFunc = OPENGL_EXTS_H + 125 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUIVARBPROC)(GLuint index,  const GLuint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUIVARBPROC esdl_glVertexAttrib4NuivARB;
void egl_vertexAttrib4NuivARB (sdl_data *, int, char *); 
enum { glVertexAttrib4NusvARBFunc = OPENGL_EXTS_H + 126 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUSVARBPROC)(GLuint index,  const GLushort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUSVARBPROC esdl_glVertexAttrib4NusvARB;
void egl_vertexAttrib4NusvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4bvARBFunc = OPENGL_EXTS_H + 127 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4BVARBPROC)(GLuint index,  const GLbyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4BVARBPROC esdl_glVertexAttrib4bvARB;
void egl_vertexAttrib4bvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4dvARBFunc = OPENGL_EXTS_H + 128 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4DVARBPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4DVARBPROC esdl_glVertexAttrib4dvARB;
void egl_vertexAttrib4dvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4fvARBFunc = OPENGL_EXTS_H + 129 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4FVARBPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4FVARBPROC esdl_glVertexAttrib4fvARB;
void egl_vertexAttrib4fvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4ivARBFunc = OPENGL_EXTS_H + 130 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4IVARBPROC)(GLuint index,  const GLint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4IVARBPROC esdl_glVertexAttrib4ivARB;
void egl_vertexAttrib4ivARB (sdl_data *, int, char *); 
enum { glVertexAttrib4svARBFunc = OPENGL_EXTS_H + 131 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4SVARBPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4SVARBPROC esdl_glVertexAttrib4svARB;
void egl_vertexAttrib4svARB (sdl_data *, int, char *); 
enum { glVertexAttrib4ubvARBFunc = OPENGL_EXTS_H + 132 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4UBVARBPROC)(GLuint index,  const GLubyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4UBVARBPROC esdl_glVertexAttrib4ubvARB;
void egl_vertexAttrib4ubvARB (sdl_data *, int, char *); 
enum { glVertexAttrib4uivARBFunc = OPENGL_EXTS_H + 133 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4UIVARBPROC)(GLuint index,  const GLuint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4UIVARBPROC esdl_glVertexAttrib4uivARB;
void egl_vertexAttrib4uivARB (sdl_data *, int, char *); 
enum { glVertexAttrib4usvARBFunc = OPENGL_EXTS_H + 134 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4USVARBPROC)(GLuint index,  const GLushort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4USVARBPROC esdl_glVertexAttrib4usvARB;
void egl_vertexAttrib4usvARB (sdl_data *, int, char *); 
enum { glVertexAttribPointerARBFunc = OPENGL_EXTS_H + 135 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIBPOINTERARBPROC)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLVERTEXATTRIBPOINTERARBPROC esdl_glVertexAttribPointerARB;
void egl_vertexAttribPointerARB (sdl_data *, int, char *); 
enum { glEnableVertexAttribArrayARBFunc = OPENGL_EXTS_H + 136 };
typedef void (APIENTRY * ESDLGLENABLEVERTEXATTRIBARRAYARBPROC)(GLuint index);
ESDL_EXTERN ESDLGLENABLEVERTEXATTRIBARRAYARBPROC esdl_glEnableVertexAttribArrayARB;
void egl_enableVertexAttribArrayARB (sdl_data *, int, char *); 
enum { glDisableVertexAttribArrayARBFunc = OPENGL_EXTS_H + 137 };
typedef void (APIENTRY * ESDLGLDISABLEVERTEXATTRIBARRAYARBPROC)(GLuint index);
ESDL_EXTERN ESDLGLDISABLEVERTEXATTRIBARRAYARBPROC esdl_glDisableVertexAttribArrayARB;
void egl_disableVertexAttribArrayARB (sdl_data *, int, char *); 
enum { glProgramStringARBFunc = OPENGL_EXTS_H + 138 };
typedef void (APIENTRY * ESDLGLPROGRAMSTRINGARBPROC)(GLenum target, GLenum format, GLsizei len,  const GLvoid * string);
ESDL_EXTERN ESDLGLPROGRAMSTRINGARBPROC esdl_glProgramStringARB;
void egl_programStringARB (sdl_data *, int, char *); 
enum { glBindProgramARBFunc = OPENGL_EXTS_H + 139 };
typedef void (APIENTRY * ESDLGLBINDPROGRAMARBPROC)(GLenum target, GLuint program);
ESDL_EXTERN ESDLGLBINDPROGRAMARBPROC esdl_glBindProgramARB;
void egl_bindProgramARB (sdl_data *, int, char *); 
enum { glDeleteProgramsARBFunc = OPENGL_EXTS_H + 140 };
typedef void (APIENTRY * ESDLGLDELETEPROGRAMSARBPROC)(GLsizei n,  const GLuint * programs);
ESDL_EXTERN ESDLGLDELETEPROGRAMSARBPROC esdl_glDeleteProgramsARB;
void egl_deleteProgramsARB (sdl_data *, int, char *); 
enum { glGenProgramsARBFunc = OPENGL_EXTS_H + 141 };
typedef void (APIENTRY * ESDLGLGENPROGRAMSARBPROC)(GLsizei n, GLuint * programs);
ESDL_EXTERN ESDLGLGENPROGRAMSARBPROC esdl_glGenProgramsARB;
void egl_genProgramsARB (sdl_data *, int, char *); 
enum { glProgramEnvParameter4dvARBFunc = OPENGL_EXTS_H + 142 };
typedef void (APIENTRY * ESDLGLPROGRAMENVPARAMETER4DVARBPROC)(GLenum target, GLuint index,  const GLdouble * params);
ESDL_EXTERN ESDLGLPROGRAMENVPARAMETER4DVARBPROC esdl_glProgramEnvParameter4dvARB;
void egl_programEnvParameter4dvARB (sdl_data *, int, char *); 
enum { glProgramEnvParameter4fvARBFunc = OPENGL_EXTS_H + 143 };
typedef void (APIENTRY * ESDLGLPROGRAMENVPARAMETER4FVARBPROC)(GLenum target, GLuint index,  const GLfloat * params);
ESDL_EXTERN ESDLGLPROGRAMENVPARAMETER4FVARBPROC esdl_glProgramEnvParameter4fvARB;
void egl_programEnvParameter4fvARB (sdl_data *, int, char *); 
enum { glProgramLocalParameter4dvARBFunc = OPENGL_EXTS_H + 144 };
typedef void (APIENTRY * ESDLGLPROGRAMLOCALPARAMETER4DVARBPROC)(GLenum target, GLuint index,  const GLdouble * params);
ESDL_EXTERN ESDLGLPROGRAMLOCALPARAMETER4DVARBPROC esdl_glProgramLocalParameter4dvARB;
void egl_programLocalParameter4dvARB (sdl_data *, int, char *); 
enum { glProgramLocalParameter4fvARBFunc = OPENGL_EXTS_H + 145 };
typedef void (APIENTRY * ESDLGLPROGRAMLOCALPARAMETER4FVARBPROC)(GLenum target, GLuint index,  const GLfloat * params);
ESDL_EXTERN ESDLGLPROGRAMLOCALPARAMETER4FVARBPROC esdl_glProgramLocalParameter4fvARB;
void egl_programLocalParameter4fvARB (sdl_data *, int, char *); 
enum { glGetProgramEnvParameterdvARBFunc = OPENGL_EXTS_H + 146 };
typedef void (APIENTRY * ESDLGLGETPROGRAMENVPARAMETERDVARBPROC)(GLenum target, GLuint index, GLdouble * params);
ESDL_EXTERN ESDLGLGETPROGRAMENVPARAMETERDVARBPROC esdl_glGetProgramEnvParameterdvARB;
void egl_getProgramEnvParameterdvARB (sdl_data *, int, char *); 
enum { glGetProgramEnvParameterfvARBFunc = OPENGL_EXTS_H + 147 };
typedef void (APIENTRY * ESDLGLGETPROGRAMENVPARAMETERFVARBPROC)(GLenum target, GLuint index, GLfloat * params);
ESDL_EXTERN ESDLGLGETPROGRAMENVPARAMETERFVARBPROC esdl_glGetProgramEnvParameterfvARB;
void egl_getProgramEnvParameterfvARB (sdl_data *, int, char *); 
enum { glGetProgramLocalParameterdvARBFunc = OPENGL_EXTS_H + 148 };
typedef void (APIENTRY * ESDLGLGETPROGRAMLOCALPARAMETERDVARBPROC)(GLenum target, GLuint index, GLdouble * params);
ESDL_EXTERN ESDLGLGETPROGRAMLOCALPARAMETERDVARBPROC esdl_glGetProgramLocalParameterdvARB;
void egl_getProgramLocalParameterdvARB (sdl_data *, int, char *); 
enum { glGetProgramLocalParameterfvARBFunc = OPENGL_EXTS_H + 149 };
typedef void (APIENTRY * ESDLGLGETPROGRAMLOCALPARAMETERFVARBPROC)(GLenum target, GLuint index, GLfloat * params);
ESDL_EXTERN ESDLGLGETPROGRAMLOCALPARAMETERFVARBPROC esdl_glGetProgramLocalParameterfvARB;
void egl_getProgramLocalParameterfvARB (sdl_data *, int, char *); 
enum { glGetProgramivARBFunc = OPENGL_EXTS_H + 150 };
typedef void (APIENTRY * ESDLGLGETPROGRAMIVARBPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETPROGRAMIVARBPROC esdl_glGetProgramivARB;
void egl_getProgramivARB (sdl_data *, int, char *); 
enum { glGetProgramStringARBFunc = OPENGL_EXTS_H + 151 };
typedef void (APIENTRY * ESDLGLGETPROGRAMSTRINGARBPROC)(GLenum target, GLenum pname, GLvoid * string);
ESDL_EXTERN ESDLGLGETPROGRAMSTRINGARBPROC esdl_glGetProgramStringARB;
void egl_getProgramStringARB (sdl_data *, int, char *); 
enum { glGetVertexAttribdvARBFunc = OPENGL_EXTS_H + 152 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBDVARBPROC)(GLuint index, GLenum pname, GLdouble * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBDVARBPROC esdl_glGetVertexAttribdvARB;
void egl_getVertexAttribdvARB (sdl_data *, int, char *); 
enum { glGetVertexAttribfvARBFunc = OPENGL_EXTS_H + 153 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBFVARBPROC)(GLuint index, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBFVARBPROC esdl_glGetVertexAttribfvARB;
void egl_getVertexAttribfvARB (sdl_data *, int, char *); 
enum { glGetVertexAttribivARBFunc = OPENGL_EXTS_H + 154 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBIVARBPROC)(GLuint index, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBIVARBPROC esdl_glGetVertexAttribivARB;
void egl_getVertexAttribivARB (sdl_data *, int, char *); 
enum { glGetVertexAttribPointervARBFunc = OPENGL_EXTS_H + 155 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBPOINTERVARBPROC)(GLuint index, GLenum pname,  GLvoid* *pointer);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBPOINTERVARBPROC esdl_glGetVertexAttribPointervARB;
void egl_getVertexAttribPointervARB (sdl_data *, int, char *); 
enum { glIsProgramARBFunc = OPENGL_EXTS_H + 156 };
typedef GLboolean (APIENTRY * ESDLGLISPROGRAMARBPROC)(GLuint program);
ESDL_EXTERN ESDLGLISPROGRAMARBPROC esdl_glIsProgramARB;
void egl_isProgramARB (sdl_data *, int, char *); 
