/*  
 *  Copyright (c) 2005 Dan Gudmundsson
 *  See the file "license.terms" for information on usage and redistribution
 *  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 *     $Id: esdl_glext.h,v 1.6 2005/03/04 15:15:00 dgud Exp $
 *
 */

#ifdef ESDL_DEFINE_EXTS
# define ESDL_EXTERN
#else
# define ESDL_EXTERN extern
#endif

enum { glBlendColorFunc = OPENGL_EXTS_H + 0 };
typedef void (APIENTRY * ESDLGLBLENDCOLORPROC)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
ESDL_EXTERN ESDLGLBLENDCOLORPROC esdl_glBlendColor;
void egl_blendColor (sdl_data *, int, char *); 
enum { glBlendEquationFunc = OPENGL_EXTS_H + 1 };
typedef void (APIENTRY * ESDLGLBLENDEQUATIONPROC)(GLenum mode);
ESDL_EXTERN ESDLGLBLENDEQUATIONPROC esdl_glBlendEquation;
void egl_blendEquation (sdl_data *, int, char *); 
enum { glDrawRangeElementsFunc = OPENGL_EXTS_H + 2 };
typedef void (APIENTRY * ESDLGLDRAWRANGEELEMENTSPROC)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type,  const GLvoid * indices);
ESDL_EXTERN ESDLGLDRAWRANGEELEMENTSPROC esdl_glDrawRangeElements;
void egl_drawRangeElements (sdl_data *, int, char *); 
enum { glColorTableFunc = OPENGL_EXTS_H + 3 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPROC)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type,  const GLvoid * table);
ESDL_EXTERN ESDLGLCOLORTABLEPROC esdl_glColorTable;
void egl_colorTable (sdl_data *, int, char *); 
enum { glColorTableParameterfvFunc = OPENGL_EXTS_H + 4 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPARAMETERFVPROC)(GLenum target, GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLCOLORTABLEPARAMETERFVPROC esdl_glColorTableParameterfv;
void egl_colorTableParameterfv (sdl_data *, int, char *); 
enum { glColorTableParameterivFunc = OPENGL_EXTS_H + 5 };
typedef void (APIENTRY * ESDLGLCOLORTABLEPARAMETERIVPROC)(GLenum target, GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLCOLORTABLEPARAMETERIVPROC esdl_glColorTableParameteriv;
void egl_colorTableParameteriv (sdl_data *, int, char *); 
enum { glCopyColorTableFunc = OPENGL_EXTS_H + 6 };
typedef void (APIENTRY * ESDLGLCOPYCOLORTABLEPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCOLORTABLEPROC esdl_glCopyColorTable;
void egl_copyColorTable (sdl_data *, int, char *); 
enum { glGetColorTableFunc = OPENGL_EXTS_H + 7 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPROC)(GLenum target, GLenum format, GLenum type, GLvoid * table);
ESDL_EXTERN ESDLGLGETCOLORTABLEPROC esdl_glGetColorTable;
void egl_getColorTable (sdl_data *, int, char *); 
enum { glGetColorTableParameterfvFunc = OPENGL_EXTS_H + 8 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETCOLORTABLEPARAMETERFVPROC esdl_glGetColorTableParameterfv;
void egl_getColorTableParameterfv (sdl_data *, int, char *); 
enum { glGetColorTableParameterivFunc = OPENGL_EXTS_H + 9 };
typedef void (APIENTRY * ESDLGLGETCOLORTABLEPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETCOLORTABLEPARAMETERIVPROC esdl_glGetColorTableParameteriv;
void egl_getColorTableParameteriv (sdl_data *, int, char *); 
enum { glColorSubTableFunc = OPENGL_EXTS_H + 10 };
typedef void (APIENTRY * ESDLGLCOLORSUBTABLEPROC)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOLORSUBTABLEPROC esdl_glColorSubTable;
void egl_colorSubTable (sdl_data *, int, char *); 
enum { glCopyColorSubTableFunc = OPENGL_EXTS_H + 11 };
typedef void (APIENTRY * ESDLGLCOPYCOLORSUBTABLEPROC)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCOLORSUBTABLEPROC esdl_glCopyColorSubTable;
void egl_copyColorSubTable (sdl_data *, int, char *); 
enum { glConvolutionFilter1DFunc = OPENGL_EXTS_H + 12 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONFILTER1DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type,  const GLvoid * image);
ESDL_EXTERN ESDLGLCONVOLUTIONFILTER1DPROC esdl_glConvolutionFilter1D;
void egl_convolutionFilter1D (sdl_data *, int, char *); 
enum { glConvolutionFilter2DFunc = OPENGL_EXTS_H + 13 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONFILTER2DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type,  const GLvoid * image);
ESDL_EXTERN ESDLGLCONVOLUTIONFILTER2DPROC esdl_glConvolutionFilter2D;
void egl_convolutionFilter2D (sdl_data *, int, char *); 
enum { glConvolutionParameterfFunc = OPENGL_EXTS_H + 14 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERFPROC)(GLenum target, GLenum pname, GLfloat params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERFPROC esdl_glConvolutionParameterf;
void egl_convolutionParameterf (sdl_data *, int, char *); 
enum { glConvolutionParameterfvFunc = OPENGL_EXTS_H + 15 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERFVPROC)(GLenum target, GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERFVPROC esdl_glConvolutionParameterfv;
void egl_convolutionParameterfv (sdl_data *, int, char *); 
enum { glConvolutionParameteriFunc = OPENGL_EXTS_H + 16 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERIPROC)(GLenum target, GLenum pname, GLint params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERIPROC esdl_glConvolutionParameteri;
void egl_convolutionParameteri (sdl_data *, int, char *); 
enum { glConvolutionParameterivFunc = OPENGL_EXTS_H + 17 };
typedef void (APIENTRY * ESDLGLCONVOLUTIONPARAMETERIVPROC)(GLenum target, GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLCONVOLUTIONPARAMETERIVPROC esdl_glConvolutionParameteriv;
void egl_convolutionParameteriv (sdl_data *, int, char *); 
enum { glCopyConvolutionFilter1DFunc = OPENGL_EXTS_H + 18 };
typedef void (APIENTRY * ESDLGLCOPYCONVOLUTIONFILTER1DPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
ESDL_EXTERN ESDLGLCOPYCONVOLUTIONFILTER1DPROC esdl_glCopyConvolutionFilter1D;
void egl_copyConvolutionFilter1D (sdl_data *, int, char *); 
enum { glCopyConvolutionFilter2DFunc = OPENGL_EXTS_H + 19 };
typedef void (APIENTRY * ESDLGLCOPYCONVOLUTIONFILTER2DPROC)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
ESDL_EXTERN ESDLGLCOPYCONVOLUTIONFILTER2DPROC esdl_glCopyConvolutionFilter2D;
void egl_copyConvolutionFilter2D (sdl_data *, int, char *); 
enum { glGetConvolutionFilterFunc = OPENGL_EXTS_H + 20 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONFILTERPROC)(GLenum target, GLenum format, GLenum type, GLvoid * image);
ESDL_EXTERN ESDLGLGETCONVOLUTIONFILTERPROC esdl_glGetConvolutionFilter;
void egl_getConvolutionFilter (sdl_data *, int, char *); 
enum { glGetConvolutionParameterfvFunc = OPENGL_EXTS_H + 21 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETCONVOLUTIONPARAMETERFVPROC esdl_glGetConvolutionParameterfv;
void egl_getConvolutionParameterfv (sdl_data *, int, char *); 
enum { glGetConvolutionParameterivFunc = OPENGL_EXTS_H + 22 };
typedef void (APIENTRY * ESDLGLGETCONVOLUTIONPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETCONVOLUTIONPARAMETERIVPROC esdl_glGetConvolutionParameteriv;
void egl_getConvolutionParameteriv (sdl_data *, int, char *); 
enum { glGetSeparableFilterFunc = OPENGL_EXTS_H + 23 };
typedef void (APIENTRY * ESDLGLGETSEPARABLEFILTERPROC)(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span);
ESDL_EXTERN ESDLGLGETSEPARABLEFILTERPROC esdl_glGetSeparableFilter;
void egl_getSeparableFilter (sdl_data *, int, char *); 
enum { glSeparableFilter2DFunc = OPENGL_EXTS_H + 24 };
typedef void (APIENTRY * ESDLGLSEPARABLEFILTER2DPROC)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type,  const GLvoid * row,  const GLvoid * column);
ESDL_EXTERN ESDLGLSEPARABLEFILTER2DPROC esdl_glSeparableFilter2D;
void egl_separableFilter2D (sdl_data *, int, char *); 
enum { glGetHistogramFunc = OPENGL_EXTS_H + 25 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPROC)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values);
ESDL_EXTERN ESDLGLGETHISTOGRAMPROC esdl_glGetHistogram;
void egl_getHistogram (sdl_data *, int, char *); 
enum { glGetHistogramParameterfvFunc = OPENGL_EXTS_H + 26 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETHISTOGRAMPARAMETERFVPROC esdl_glGetHistogramParameterfv;
void egl_getHistogramParameterfv (sdl_data *, int, char *); 
enum { glGetHistogramParameterivFunc = OPENGL_EXTS_H + 27 };
typedef void (APIENTRY * ESDLGLGETHISTOGRAMPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETHISTOGRAMPARAMETERIVPROC esdl_glGetHistogramParameteriv;
void egl_getHistogramParameteriv (sdl_data *, int, char *); 
enum { glGetMinmaxFunc = OPENGL_EXTS_H + 28 };
typedef void (APIENTRY * ESDLGLGETMINMAXPROC)(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values);
ESDL_EXTERN ESDLGLGETMINMAXPROC esdl_glGetMinmax;
void egl_getMinmax (sdl_data *, int, char *); 
enum { glGetMinmaxParameterfvFunc = OPENGL_EXTS_H + 29 };
typedef void (APIENTRY * ESDLGLGETMINMAXPARAMETERFVPROC)(GLenum target, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETMINMAXPARAMETERFVPROC esdl_glGetMinmaxParameterfv;
void egl_getMinmaxParameterfv (sdl_data *, int, char *); 
enum { glGetMinmaxParameterivFunc = OPENGL_EXTS_H + 30 };
typedef void (APIENTRY * ESDLGLGETMINMAXPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETMINMAXPARAMETERIVPROC esdl_glGetMinmaxParameteriv;
void egl_getMinmaxParameteriv (sdl_data *, int, char *); 
enum { glHistogramFunc = OPENGL_EXTS_H + 31 };
typedef void (APIENTRY * ESDLGLHISTOGRAMPROC)(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
ESDL_EXTERN ESDLGLHISTOGRAMPROC esdl_glHistogram;
void egl_histogram (sdl_data *, int, char *); 
enum { glMinmaxFunc = OPENGL_EXTS_H + 32 };
typedef void (APIENTRY * ESDLGLMINMAXPROC)(GLenum target, GLenum internalformat, GLboolean sink);
ESDL_EXTERN ESDLGLMINMAXPROC esdl_glMinmax;
void egl_minmax (sdl_data *, int, char *); 
enum { glResetHistogramFunc = OPENGL_EXTS_H + 33 };
typedef void (APIENTRY * ESDLGLRESETHISTOGRAMPROC)(GLenum target);
ESDL_EXTERN ESDLGLRESETHISTOGRAMPROC esdl_glResetHistogram;
void egl_resetHistogram (sdl_data *, int, char *); 
enum { glResetMinmaxFunc = OPENGL_EXTS_H + 34 };
typedef void (APIENTRY * ESDLGLRESETMINMAXPROC)(GLenum target);
ESDL_EXTERN ESDLGLRESETMINMAXPROC esdl_glResetMinmax;
void egl_resetMinmax (sdl_data *, int, char *); 
enum { glTexImage3DFunc = OPENGL_EXTS_H + 35 };
typedef void (APIENTRY * ESDLGLTEXIMAGE3DPROC)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type,  const GLvoid * pixels);
ESDL_EXTERN ESDLGLTEXIMAGE3DPROC esdl_glTexImage3D;
void egl_texImage3D (sdl_data *, int, char *); 
enum { glTexSubImage3DFunc = OPENGL_EXTS_H + 36 };
typedef void (APIENTRY * ESDLGLTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type,  const GLvoid * pixels);
ESDL_EXTERN ESDLGLTEXSUBIMAGE3DPROC esdl_glTexSubImage3D;
void egl_texSubImage3D (sdl_data *, int, char *); 
enum { glCopyTexSubImage3DFunc = OPENGL_EXTS_H + 37 };
typedef void (APIENTRY * ESDLGLCOPYTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
ESDL_EXTERN ESDLGLCOPYTEXSUBIMAGE3DPROC esdl_glCopyTexSubImage3D;
void egl_copyTexSubImage3D (sdl_data *, int, char *); 
enum { glActiveTextureFunc = OPENGL_EXTS_H + 38 };
typedef void (APIENTRY * ESDLGLACTIVETEXTUREPROC)(GLenum texture);
ESDL_EXTERN ESDLGLACTIVETEXTUREPROC esdl_glActiveTexture;
void egl_activeTexture (sdl_data *, int, char *); 
enum { glClientActiveTextureFunc = OPENGL_EXTS_H + 39 };
typedef void (APIENTRY * ESDLGLCLIENTACTIVETEXTUREPROC)(GLenum texture);
ESDL_EXTERN ESDLGLCLIENTACTIVETEXTUREPROC esdl_glClientActiveTexture;
void egl_clientActiveTexture (sdl_data *, int, char *); 
enum { glMultiTexCoord1dvFunc = OPENGL_EXTS_H + 40 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1DVPROC esdl_glMultiTexCoord1dv;
void egl_multiTexCoord1dv (sdl_data *, int, char *); 
enum { glMultiTexCoord1fvFunc = OPENGL_EXTS_H + 41 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1FVPROC esdl_glMultiTexCoord1fv;
void egl_multiTexCoord1fv (sdl_data *, int, char *); 
enum { glMultiTexCoord1ivFunc = OPENGL_EXTS_H + 42 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1IVPROC esdl_glMultiTexCoord1iv;
void egl_multiTexCoord1iv (sdl_data *, int, char *); 
enum { glMultiTexCoord1svFunc = OPENGL_EXTS_H + 43 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD1SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD1SVPROC esdl_glMultiTexCoord1sv;
void egl_multiTexCoord1sv (sdl_data *, int, char *); 
enum { glMultiTexCoord2dvFunc = OPENGL_EXTS_H + 44 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2DVPROC esdl_glMultiTexCoord2dv;
void egl_multiTexCoord2dv (sdl_data *, int, char *); 
enum { glMultiTexCoord2fvFunc = OPENGL_EXTS_H + 45 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2FVPROC esdl_glMultiTexCoord2fv;
void egl_multiTexCoord2fv (sdl_data *, int, char *); 
enum { glMultiTexCoord2ivFunc = OPENGL_EXTS_H + 46 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2IVPROC esdl_glMultiTexCoord2iv;
void egl_multiTexCoord2iv (sdl_data *, int, char *); 
enum { glMultiTexCoord2svFunc = OPENGL_EXTS_H + 47 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD2SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD2SVPROC esdl_glMultiTexCoord2sv;
void egl_multiTexCoord2sv (sdl_data *, int, char *); 
enum { glMultiTexCoord3dvFunc = OPENGL_EXTS_H + 48 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3DVPROC esdl_glMultiTexCoord3dv;
void egl_multiTexCoord3dv (sdl_data *, int, char *); 
enum { glMultiTexCoord3fvFunc = OPENGL_EXTS_H + 49 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3FVPROC esdl_glMultiTexCoord3fv;
void egl_multiTexCoord3fv (sdl_data *, int, char *); 
enum { glMultiTexCoord3ivFunc = OPENGL_EXTS_H + 50 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3IVPROC esdl_glMultiTexCoord3iv;
void egl_multiTexCoord3iv (sdl_data *, int, char *); 
enum { glMultiTexCoord3svFunc = OPENGL_EXTS_H + 51 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD3SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD3SVPROC esdl_glMultiTexCoord3sv;
void egl_multiTexCoord3sv (sdl_data *, int, char *); 
enum { glMultiTexCoord4dvFunc = OPENGL_EXTS_H + 52 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4DVPROC)(GLenum target,  const GLdouble * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4DVPROC esdl_glMultiTexCoord4dv;
void egl_multiTexCoord4dv (sdl_data *, int, char *); 
enum { glMultiTexCoord4fvFunc = OPENGL_EXTS_H + 53 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4FVPROC)(GLenum target,  const GLfloat * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4FVPROC esdl_glMultiTexCoord4fv;
void egl_multiTexCoord4fv (sdl_data *, int, char *); 
enum { glMultiTexCoord4ivFunc = OPENGL_EXTS_H + 54 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4IVPROC)(GLenum target,  const GLint * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4IVPROC esdl_glMultiTexCoord4iv;
void egl_multiTexCoord4iv (sdl_data *, int, char *); 
enum { glMultiTexCoord4svFunc = OPENGL_EXTS_H + 55 };
typedef void (APIENTRY * ESDLGLMULTITEXCOORD4SVPROC)(GLenum target,  const GLshort * v);
ESDL_EXTERN ESDLGLMULTITEXCOORD4SVPROC esdl_glMultiTexCoord4sv;
void egl_multiTexCoord4sv (sdl_data *, int, char *); 
enum { glLoadTransposeMatrixfFunc = OPENGL_EXTS_H + 56 };
typedef void (APIENTRY * ESDLGLLOADTRANSPOSEMATRIXFPROC)( const GLfloat * m);
ESDL_EXTERN ESDLGLLOADTRANSPOSEMATRIXFPROC esdl_glLoadTransposeMatrixf;
void egl_loadTransposeMatrixf (sdl_data *, int, char *); 
enum { glLoadTransposeMatrixdFunc = OPENGL_EXTS_H + 57 };
typedef void (APIENTRY * ESDLGLLOADTRANSPOSEMATRIXDPROC)( const GLdouble * m);
ESDL_EXTERN ESDLGLLOADTRANSPOSEMATRIXDPROC esdl_glLoadTransposeMatrixd;
void egl_loadTransposeMatrixd (sdl_data *, int, char *); 
enum { glMultTransposeMatrixfFunc = OPENGL_EXTS_H + 58 };
typedef void (APIENTRY * ESDLGLMULTTRANSPOSEMATRIXFPROC)( const GLfloat * m);
ESDL_EXTERN ESDLGLMULTTRANSPOSEMATRIXFPROC esdl_glMultTransposeMatrixf;
void egl_multTransposeMatrixf (sdl_data *, int, char *); 
enum { glMultTransposeMatrixdFunc = OPENGL_EXTS_H + 59 };
typedef void (APIENTRY * ESDLGLMULTTRANSPOSEMATRIXDPROC)( const GLdouble * m);
ESDL_EXTERN ESDLGLMULTTRANSPOSEMATRIXDPROC esdl_glMultTransposeMatrixd;
void egl_multTransposeMatrixd (sdl_data *, int, char *); 
enum { glSampleCoverageFunc = OPENGL_EXTS_H + 60 };
typedef void (APIENTRY * ESDLGLSAMPLECOVERAGEPROC)(GLclampf value, GLboolean invert);
ESDL_EXTERN ESDLGLSAMPLECOVERAGEPROC esdl_glSampleCoverage;
void egl_sampleCoverage (sdl_data *, int, char *); 
enum { glCompressedTexImage3DFunc = OPENGL_EXTS_H + 61 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE3DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE3DPROC esdl_glCompressedTexImage3D;
void egl_compressedTexImage3D (sdl_data *, int, char *); 
enum { glCompressedTexImage2DFunc = OPENGL_EXTS_H + 62 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE2DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE2DPROC esdl_glCompressedTexImage2D;
void egl_compressedTexImage2D (sdl_data *, int, char *); 
enum { glCompressedTexImage1DFunc = OPENGL_EXTS_H + 63 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXIMAGE1DPROC)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXIMAGE1DPROC esdl_glCompressedTexImage1D;
void egl_compressedTexImage1D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage3DFunc = OPENGL_EXTS_H + 64 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE3DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE3DPROC esdl_glCompressedTexSubImage3D;
void egl_compressedTexSubImage3D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage2DFunc = OPENGL_EXTS_H + 65 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE2DPROC)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE2DPROC esdl_glCompressedTexSubImage2D;
void egl_compressedTexSubImage2D (sdl_data *, int, char *); 
enum { glCompressedTexSubImage1DFunc = OPENGL_EXTS_H + 66 };
typedef void (APIENTRY * ESDLGLCOMPRESSEDTEXSUBIMAGE1DPROC)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize,  const GLvoid * data);
ESDL_EXTERN ESDLGLCOMPRESSEDTEXSUBIMAGE1DPROC esdl_glCompressedTexSubImage1D;
void egl_compressedTexSubImage1D (sdl_data *, int, char *); 
enum { glGetCompressedTexImageFunc = OPENGL_EXTS_H + 67 };
typedef void (APIENTRY * ESDLGLGETCOMPRESSEDTEXIMAGEPROC)(GLenum target, GLint level, GLvoid * img);
ESDL_EXTERN ESDLGLGETCOMPRESSEDTEXIMAGEPROC esdl_glGetCompressedTexImage;
void egl_getCompressedTexImage (sdl_data *, int, char *); 
enum { glBlendFuncSeparateFunc = OPENGL_EXTS_H + 68 };
typedef void (APIENTRY * ESDLGLBLENDFUNCSEPARATEPROC)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
ESDL_EXTERN ESDLGLBLENDFUNCSEPARATEPROC esdl_glBlendFuncSeparate;
void egl_blendFuncSeparate (sdl_data *, int, char *); 
enum { glFogCoordfFunc = OPENGL_EXTS_H + 69 };
typedef void (APIENTRY * ESDLGLFOGCOORDFPROC)(GLfloat coord);
ESDL_EXTERN ESDLGLFOGCOORDFPROC esdl_glFogCoordf;
void egl_fogCoordf (sdl_data *, int, char *); 
enum { glFogCoordfvFunc = OPENGL_EXTS_H + 70 };
typedef void (APIENTRY * ESDLGLFOGCOORDFVPROC)( const GLfloat * coord);
ESDL_EXTERN ESDLGLFOGCOORDFVPROC esdl_glFogCoordfv;
void egl_fogCoordfv (sdl_data *, int, char *); 
enum { glFogCoorddFunc = OPENGL_EXTS_H + 71 };
typedef void (APIENTRY * ESDLGLFOGCOORDDPROC)(GLdouble coord);
ESDL_EXTERN ESDLGLFOGCOORDDPROC esdl_glFogCoordd;
void egl_fogCoordd (sdl_data *, int, char *); 
enum { glFogCoorddvFunc = OPENGL_EXTS_H + 72 };
typedef void (APIENTRY * ESDLGLFOGCOORDDVPROC)( const GLdouble * coord);
ESDL_EXTERN ESDLGLFOGCOORDDVPROC esdl_glFogCoorddv;
void egl_fogCoorddv (sdl_data *, int, char *); 
enum { glFogCoordPointerFunc = OPENGL_EXTS_H + 73 };
typedef void (APIENTRY * ESDLGLFOGCOORDPOINTERPROC)(GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLFOGCOORDPOINTERPROC esdl_glFogCoordPointer;
void egl_fogCoordPointer (sdl_data *, int, char *); 
enum { glMultiDrawArraysFunc = OPENGL_EXTS_H + 74 };
typedef void (APIENTRY * ESDLGLMULTIDRAWARRAYSPROC)(GLenum mode,  const GLint * first,  const GLsizei * count, GLsizei primcount);
ESDL_EXTERN ESDLGLMULTIDRAWARRAYSPROC esdl_glMultiDrawArrays;
void egl_multiDrawArrays (sdl_data *, int, char *); 
enum { glPointParameterfFunc = OPENGL_EXTS_H + 75 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERFPROC)(GLenum pname, GLfloat param);
ESDL_EXTERN ESDLGLPOINTPARAMETERFPROC esdl_glPointParameterf;
void egl_pointParameterf (sdl_data *, int, char *); 
enum { glPointParameterfvFunc = OPENGL_EXTS_H + 76 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERFVPROC)(GLenum pname,  const GLfloat * params);
ESDL_EXTERN ESDLGLPOINTPARAMETERFVPROC esdl_glPointParameterfv;
void egl_pointParameterfv (sdl_data *, int, char *); 
enum { glPointParameteriFunc = OPENGL_EXTS_H + 77 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERIPROC)(GLenum pname, GLint param);
ESDL_EXTERN ESDLGLPOINTPARAMETERIPROC esdl_glPointParameteri;
void egl_pointParameteri (sdl_data *, int, char *); 
enum { glPointParameterivFunc = OPENGL_EXTS_H + 78 };
typedef void (APIENTRY * ESDLGLPOINTPARAMETERIVPROC)(GLenum pname,  const GLint * params);
ESDL_EXTERN ESDLGLPOINTPARAMETERIVPROC esdl_glPointParameteriv;
void egl_pointParameteriv (sdl_data *, int, char *); 
enum { glSecondaryColor3bvFunc = OPENGL_EXTS_H + 79 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3BVPROC)( const GLbyte * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3BVPROC esdl_glSecondaryColor3bv;
void egl_secondaryColor3bv (sdl_data *, int, char *); 
enum { glSecondaryColor3dvFunc = OPENGL_EXTS_H + 80 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3DVPROC esdl_glSecondaryColor3dv;
void egl_secondaryColor3dv (sdl_data *, int, char *); 
enum { glSecondaryColor3fvFunc = OPENGL_EXTS_H + 81 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3FVPROC esdl_glSecondaryColor3fv;
void egl_secondaryColor3fv (sdl_data *, int, char *); 
enum { glSecondaryColor3ivFunc = OPENGL_EXTS_H + 82 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3IVPROC esdl_glSecondaryColor3iv;
void egl_secondaryColor3iv (sdl_data *, int, char *); 
enum { glSecondaryColor3svFunc = OPENGL_EXTS_H + 83 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3SVPROC esdl_glSecondaryColor3sv;
void egl_secondaryColor3sv (sdl_data *, int, char *); 
enum { glSecondaryColor3ubvFunc = OPENGL_EXTS_H + 84 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3UBVPROC)( const GLubyte * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3UBVPROC esdl_glSecondaryColor3ubv;
void egl_secondaryColor3ubv (sdl_data *, int, char *); 
enum { glSecondaryColor3uivFunc = OPENGL_EXTS_H + 85 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3UIVPROC)( const GLuint * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3UIVPROC esdl_glSecondaryColor3uiv;
void egl_secondaryColor3uiv (sdl_data *, int, char *); 
enum { glSecondaryColor3usvFunc = OPENGL_EXTS_H + 86 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLOR3USVPROC)( const GLushort * v);
ESDL_EXTERN ESDLGLSECONDARYCOLOR3USVPROC esdl_glSecondaryColor3usv;
void egl_secondaryColor3usv (sdl_data *, int, char *); 
enum { glSecondaryColorPointerFunc = OPENGL_EXTS_H + 87 };
typedef void (APIENTRY * ESDLGLSECONDARYCOLORPOINTERPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLSECONDARYCOLORPOINTERPROC esdl_glSecondaryColorPointer;
void egl_secondaryColorPointer (sdl_data *, int, char *); 
enum { glWindowPos2dvFunc = OPENGL_EXTS_H + 88 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLWINDOWPOS2DVPROC esdl_glWindowPos2dv;
void egl_windowPos2dv (sdl_data *, int, char *); 
enum { glWindowPos2fvFunc = OPENGL_EXTS_H + 89 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLWINDOWPOS2FVPROC esdl_glWindowPos2fv;
void egl_windowPos2fv (sdl_data *, int, char *); 
enum { glWindowPos2ivFunc = OPENGL_EXTS_H + 90 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLWINDOWPOS2IVPROC esdl_glWindowPos2iv;
void egl_windowPos2iv (sdl_data *, int, char *); 
enum { glWindowPos2svFunc = OPENGL_EXTS_H + 91 };
typedef void (APIENTRY * ESDLGLWINDOWPOS2SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLWINDOWPOS2SVPROC esdl_glWindowPos2sv;
void egl_windowPos2sv (sdl_data *, int, char *); 
enum { glWindowPos3dvFunc = OPENGL_EXTS_H + 92 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3DVPROC)( const GLdouble * v);
ESDL_EXTERN ESDLGLWINDOWPOS3DVPROC esdl_glWindowPos3dv;
void egl_windowPos3dv (sdl_data *, int, char *); 
enum { glWindowPos3fvFunc = OPENGL_EXTS_H + 93 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3FVPROC)( const GLfloat * v);
ESDL_EXTERN ESDLGLWINDOWPOS3FVPROC esdl_glWindowPos3fv;
void egl_windowPos3fv (sdl_data *, int, char *); 
enum { glWindowPos3ivFunc = OPENGL_EXTS_H + 94 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3IVPROC)( const GLint * v);
ESDL_EXTERN ESDLGLWINDOWPOS3IVPROC esdl_glWindowPos3iv;
void egl_windowPos3iv (sdl_data *, int, char *); 
enum { glWindowPos3svFunc = OPENGL_EXTS_H + 95 };
typedef void (APIENTRY * ESDLGLWINDOWPOS3SVPROC)( const GLshort * v);
ESDL_EXTERN ESDLGLWINDOWPOS3SVPROC esdl_glWindowPos3sv;
void egl_windowPos3sv (sdl_data *, int, char *); 
enum { glGenQueriesFunc = OPENGL_EXTS_H + 96 };
typedef void (APIENTRY * ESDLGLGENQUERIESPROC)(GLsizei n, GLuint * ids);
ESDL_EXTERN ESDLGLGENQUERIESPROC esdl_glGenQueries;
void egl_genQueries (sdl_data *, int, char *); 
enum { glDeleteQueriesFunc = OPENGL_EXTS_H + 97 };
typedef void (APIENTRY * ESDLGLDELETEQUERIESPROC)(GLsizei n,  const GLuint * ids);
ESDL_EXTERN ESDLGLDELETEQUERIESPROC esdl_glDeleteQueries;
void egl_deleteQueries (sdl_data *, int, char *); 
enum { glIsQueryFunc = OPENGL_EXTS_H + 98 };
typedef GLboolean (APIENTRY * ESDLGLISQUERYPROC)(GLuint id);
ESDL_EXTERN ESDLGLISQUERYPROC esdl_glIsQuery;
void egl_isQuery (sdl_data *, int, char *); 
enum { glBeginQueryFunc = OPENGL_EXTS_H + 99 };
typedef void (APIENTRY * ESDLGLBEGINQUERYPROC)(GLenum target, GLuint id);
ESDL_EXTERN ESDLGLBEGINQUERYPROC esdl_glBeginQuery;
void egl_beginQuery (sdl_data *, int, char *); 
enum { glEndQueryFunc = OPENGL_EXTS_H + 100 };
typedef void (APIENTRY * ESDLGLENDQUERYPROC)(GLenum target);
ESDL_EXTERN ESDLGLENDQUERYPROC esdl_glEndQuery;
void egl_endQuery (sdl_data *, int, char *); 
enum { glGetQueryivFunc = OPENGL_EXTS_H + 101 };
typedef void (APIENTRY * ESDLGLGETQUERYIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETQUERYIVPROC esdl_glGetQueryiv;
void egl_getQueryiv (sdl_data *, int, char *); 
enum { glGetQueryObjectivFunc = OPENGL_EXTS_H + 102 };
typedef void (APIENTRY * ESDLGLGETQUERYOBJECTIVPROC)(GLuint id, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETQUERYOBJECTIVPROC esdl_glGetQueryObjectiv;
void egl_getQueryObjectiv (sdl_data *, int, char *); 
enum { glGetQueryObjectuivFunc = OPENGL_EXTS_H + 103 };
typedef void (APIENTRY * ESDLGLGETQUERYOBJECTUIVPROC)(GLuint id, GLenum pname, GLuint * params);
ESDL_EXTERN ESDLGLGETQUERYOBJECTUIVPROC esdl_glGetQueryObjectuiv;
void egl_getQueryObjectuiv (sdl_data *, int, char *); 
enum { glBindBufferFunc = OPENGL_EXTS_H + 104 };
typedef void (APIENTRY * ESDLGLBINDBUFFERPROC)(GLenum target, GLuint buffer);
ESDL_EXTERN ESDLGLBINDBUFFERPROC esdl_glBindBuffer;
void egl_bindBuffer (sdl_data *, int, char *); 
enum { glDeleteBuffersFunc = OPENGL_EXTS_H + 105 };
typedef void (APIENTRY * ESDLGLDELETEBUFFERSPROC)(GLsizei n,  const GLuint * buffers);
ESDL_EXTERN ESDLGLDELETEBUFFERSPROC esdl_glDeleteBuffers;
void egl_deleteBuffers (sdl_data *, int, char *); 
enum { glGenBuffersFunc = OPENGL_EXTS_H + 106 };
typedef void (APIENTRY * ESDLGLGENBUFFERSPROC)(GLsizei n, GLuint * buffers);
ESDL_EXTERN ESDLGLGENBUFFERSPROC esdl_glGenBuffers;
void egl_genBuffers (sdl_data *, int, char *); 
enum { glIsBufferFunc = OPENGL_EXTS_H + 107 };
typedef GLboolean (APIENTRY * ESDLGLISBUFFERPROC)(GLuint buffer);
ESDL_EXTERN ESDLGLISBUFFERPROC esdl_glIsBuffer;
void egl_isBuffer (sdl_data *, int, char *); 
enum { glBufferDataFunc = OPENGL_EXTS_H + 108 };
typedef void (APIENTRY * ESDLGLBUFFERDATAPROC)(GLenum target, GLsizeiptr size,  const GLvoid * data, GLenum usage);
ESDL_EXTERN ESDLGLBUFFERDATAPROC esdl_glBufferData;
void egl_bufferData (sdl_data *, int, char *); 
enum { glBufferSubDataFunc = OPENGL_EXTS_H + 109 };
typedef void (APIENTRY * ESDLGLBUFFERSUBDATAPROC)(GLenum target, GLintptr offset, GLsizeiptr size,  const GLvoid * data);
ESDL_EXTERN ESDLGLBUFFERSUBDATAPROC esdl_glBufferSubData;
void egl_bufferSubData (sdl_data *, int, char *); 
enum { glGetBufferSubDataFunc = OPENGL_EXTS_H + 110 };
typedef void (APIENTRY * ESDLGLGETBUFFERSUBDATAPROC)(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data);
ESDL_EXTERN ESDLGLGETBUFFERSUBDATAPROC esdl_glGetBufferSubData;
void egl_getBufferSubData (sdl_data *, int, char *); 
enum { glUnmapBufferFunc = OPENGL_EXTS_H + 111 };
typedef GLboolean (APIENTRY * ESDLGLUNMAPBUFFERPROC)(GLenum target);
ESDL_EXTERN ESDLGLUNMAPBUFFERPROC esdl_glUnmapBuffer;
void egl_unmapBuffer (sdl_data *, int, char *); 
enum { glGetBufferParameterivFunc = OPENGL_EXTS_H + 112 };
typedef void (APIENTRY * ESDLGLGETBUFFERPARAMETERIVPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETBUFFERPARAMETERIVPROC esdl_glGetBufferParameteriv;
void egl_getBufferParameteriv (sdl_data *, int, char *); 
enum { glGetBufferPointervFunc = OPENGL_EXTS_H + 113 };
typedef void (APIENTRY * ESDLGLGETBUFFERPOINTERVPROC)(GLenum target, GLenum pname,  GLvoid* *params);
ESDL_EXTERN ESDLGLGETBUFFERPOINTERVPROC esdl_glGetBufferPointerv;
void egl_getBufferPointerv (sdl_data *, int, char *); 
enum { glBlendEquationSeparateFunc = OPENGL_EXTS_H + 114 };
typedef void (APIENTRY * ESDLGLBLENDEQUATIONSEPARATEPROC)(GLenum modeRGB, GLenum modeAlpha);
ESDL_EXTERN ESDLGLBLENDEQUATIONSEPARATEPROC esdl_glBlendEquationSeparate;
void egl_blendEquationSeparate (sdl_data *, int, char *); 
enum { glDrawBuffersFunc = OPENGL_EXTS_H + 115 };
typedef void (APIENTRY * ESDLGLDRAWBUFFERSPROC)(GLsizei n,  const GLenum * bufs);
ESDL_EXTERN ESDLGLDRAWBUFFERSPROC esdl_glDrawBuffers;
void egl_drawBuffers (sdl_data *, int, char *); 
enum { glStencilOpSeparateFunc = OPENGL_EXTS_H + 116 };
typedef void (APIENTRY * ESDLGLSTENCILOPSEPARATEPROC)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
ESDL_EXTERN ESDLGLSTENCILOPSEPARATEPROC esdl_glStencilOpSeparate;
void egl_stencilOpSeparate (sdl_data *, int, char *); 
enum { glStencilFuncSeparateFunc = OPENGL_EXTS_H + 117 };
typedef void (APIENTRY * ESDLGLSTENCILFUNCSEPARATEPROC)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
ESDL_EXTERN ESDLGLSTENCILFUNCSEPARATEPROC esdl_glStencilFuncSeparate;
void egl_stencilFuncSeparate (sdl_data *, int, char *); 
enum { glStencilMaskSeparateFunc = OPENGL_EXTS_H + 118 };
typedef void (APIENTRY * ESDLGLSTENCILMASKSEPARATEPROC)(GLenum face, GLuint mask);
ESDL_EXTERN ESDLGLSTENCILMASKSEPARATEPROC esdl_glStencilMaskSeparate;
void egl_stencilMaskSeparate (sdl_data *, int, char *); 
enum { glAttachShaderFunc = OPENGL_EXTS_H + 119 };
typedef void (APIENTRY * ESDLGLATTACHSHADERPROC)(GLuint program, GLuint shader);
ESDL_EXTERN ESDLGLATTACHSHADERPROC esdl_glAttachShader;
void egl_attachShader (sdl_data *, int, char *); 
enum { glBindAttribLocationFunc = OPENGL_EXTS_H + 120 };
typedef void (APIENTRY * ESDLGLBINDATTRIBLOCATIONPROC)(GLuint program, GLuint index,  const GLchar * name);
ESDL_EXTERN ESDLGLBINDATTRIBLOCATIONPROC esdl_glBindAttribLocation;
void egl_bindAttribLocation (sdl_data *, int, char *); 
enum { glCompileShaderFunc = OPENGL_EXTS_H + 121 };
typedef void (APIENTRY * ESDLGLCOMPILESHADERPROC)(GLuint shader);
ESDL_EXTERN ESDLGLCOMPILESHADERPROC esdl_glCompileShader;
void egl_compileShader (sdl_data *, int, char *); 
enum { glCreateProgramFunc = OPENGL_EXTS_H + 122 };
typedef GLuint (APIENTRY * ESDLGLCREATEPROGRAMPROC)();
ESDL_EXTERN ESDLGLCREATEPROGRAMPROC esdl_glCreateProgram;
void egl_createProgram (sdl_data *, int, char *); 
enum { glCreateShaderFunc = OPENGL_EXTS_H + 123 };
typedef GLuint (APIENTRY * ESDLGLCREATESHADERPROC)(GLenum type);
ESDL_EXTERN ESDLGLCREATESHADERPROC esdl_glCreateShader;
void egl_createShader (sdl_data *, int, char *); 
enum { glDeleteProgramFunc = OPENGL_EXTS_H + 124 };
typedef void (APIENTRY * ESDLGLDELETEPROGRAMPROC)(GLuint program);
ESDL_EXTERN ESDLGLDELETEPROGRAMPROC esdl_glDeleteProgram;
void egl_deleteProgram (sdl_data *, int, char *); 
enum { glDeleteShaderFunc = OPENGL_EXTS_H + 125 };
typedef void (APIENTRY * ESDLGLDELETESHADERPROC)(GLuint shader);
ESDL_EXTERN ESDLGLDELETESHADERPROC esdl_glDeleteShader;
void egl_deleteShader (sdl_data *, int, char *); 
enum { glDetachShaderFunc = OPENGL_EXTS_H + 126 };
typedef void (APIENTRY * ESDLGLDETACHSHADERPROC)(GLuint program, GLuint shader);
ESDL_EXTERN ESDLGLDETACHSHADERPROC esdl_glDetachShader;
void egl_detachShader (sdl_data *, int, char *); 
enum { glDisableVertexAttribArrayFunc = OPENGL_EXTS_H + 127 };
typedef void (APIENTRY * ESDLGLDISABLEVERTEXATTRIBARRAYPROC)(GLuint index);
ESDL_EXTERN ESDLGLDISABLEVERTEXATTRIBARRAYPROC esdl_glDisableVertexAttribArray;
void egl_disableVertexAttribArray (sdl_data *, int, char *); 
enum { glEnableVertexAttribArrayFunc = OPENGL_EXTS_H + 128 };
typedef void (APIENTRY * ESDLGLENABLEVERTEXATTRIBARRAYPROC)(GLuint index);
ESDL_EXTERN ESDLGLENABLEVERTEXATTRIBARRAYPROC esdl_glEnableVertexAttribArray;
void egl_enableVertexAttribArray (sdl_data *, int, char *); 
enum { glGetActiveAttribFunc = OPENGL_EXTS_H + 129 };
typedef void (APIENTRY * ESDLGLGETACTIVEATTRIBPROC)(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
ESDL_EXTERN ESDLGLGETACTIVEATTRIBPROC esdl_glGetActiveAttrib;
void egl_getActiveAttrib (sdl_data *, int, char *); 
enum { glGetActiveUniformFunc = OPENGL_EXTS_H + 130 };
typedef void (APIENTRY * ESDLGLGETACTIVEUNIFORMPROC)(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
ESDL_EXTERN ESDLGLGETACTIVEUNIFORMPROC esdl_glGetActiveUniform;
void egl_getActiveUniform (sdl_data *, int, char *); 
enum { glGetAttachedShadersFunc = OPENGL_EXTS_H + 131 };
typedef void (APIENTRY * ESDLGLGETATTACHEDSHADERSPROC)(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * obj);
ESDL_EXTERN ESDLGLGETATTACHEDSHADERSPROC esdl_glGetAttachedShaders;
void egl_getAttachedShaders (sdl_data *, int, char *); 
enum { glGetAttribLocationFunc = OPENGL_EXTS_H + 132 };
typedef GLint (APIENTRY * ESDLGLGETATTRIBLOCATIONPROC)(GLuint program,  const GLchar * name);
ESDL_EXTERN ESDLGLGETATTRIBLOCATIONPROC esdl_glGetAttribLocation;
void egl_getAttribLocation (sdl_data *, int, char *); 
enum { glGetProgramivFunc = OPENGL_EXTS_H + 133 };
typedef void (APIENTRY * ESDLGLGETPROGRAMIVPROC)(GLuint program, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETPROGRAMIVPROC esdl_glGetProgramiv;
void egl_getProgramiv (sdl_data *, int, char *); 
enum { glGetProgramInfoLogFunc = OPENGL_EXTS_H + 134 };
typedef void (APIENTRY * ESDLGLGETPROGRAMINFOLOGPROC)(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
ESDL_EXTERN ESDLGLGETPROGRAMINFOLOGPROC esdl_glGetProgramInfoLog;
void egl_getProgramInfoLog (sdl_data *, int, char *); 
enum { glGetShaderivFunc = OPENGL_EXTS_H + 135 };
typedef void (APIENTRY * ESDLGLGETSHADERIVPROC)(GLuint shader, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETSHADERIVPROC esdl_glGetShaderiv;
void egl_getShaderiv (sdl_data *, int, char *); 
enum { glGetShaderInfoLogFunc = OPENGL_EXTS_H + 136 };
typedef void (APIENTRY * ESDLGLGETSHADERINFOLOGPROC)(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
ESDL_EXTERN ESDLGLGETSHADERINFOLOGPROC esdl_glGetShaderInfoLog;
void egl_getShaderInfoLog (sdl_data *, int, char *); 
enum { glGetShaderSourceFunc = OPENGL_EXTS_H + 137 };
typedef void (APIENTRY * ESDLGLGETSHADERSOURCEPROC)(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source);
ESDL_EXTERN ESDLGLGETSHADERSOURCEPROC esdl_glGetShaderSource;
void egl_getShaderSource (sdl_data *, int, char *); 
enum { glGetUniformLocationFunc = OPENGL_EXTS_H + 138 };
typedef GLint (APIENTRY * ESDLGLGETUNIFORMLOCATIONPROC)(GLuint program,  const GLchar * name);
ESDL_EXTERN ESDLGLGETUNIFORMLOCATIONPROC esdl_glGetUniformLocation;
void egl_getUniformLocation (sdl_data *, int, char *); 
enum { glGetUniformfvFunc = OPENGL_EXTS_H + 139 };
typedef void (APIENTRY * ESDLGLGETUNIFORMFVPROC)(GLuint program, GLint location, GLfloat * params);
ESDL_EXTERN ESDLGLGETUNIFORMFVPROC esdl_glGetUniformfv;
void egl_getUniformfv (sdl_data *, int, char *); 
enum { glGetUniformivFunc = OPENGL_EXTS_H + 140 };
typedef void (APIENTRY * ESDLGLGETUNIFORMIVPROC)(GLuint program, GLint location, GLint * params);
ESDL_EXTERN ESDLGLGETUNIFORMIVPROC esdl_glGetUniformiv;
void egl_getUniformiv (sdl_data *, int, char *); 
enum { glGetVertexAttribdvFunc = OPENGL_EXTS_H + 141 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBDVPROC)(GLuint index, GLenum pname, GLdouble * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBDVPROC esdl_glGetVertexAttribdv;
void egl_getVertexAttribdv (sdl_data *, int, char *); 
enum { glGetVertexAttribfvFunc = OPENGL_EXTS_H + 142 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBFVPROC)(GLuint index, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBFVPROC esdl_glGetVertexAttribfv;
void egl_getVertexAttribfv (sdl_data *, int, char *); 
enum { glGetVertexAttribivFunc = OPENGL_EXTS_H + 143 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBIVPROC)(GLuint index, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBIVPROC esdl_glGetVertexAttribiv;
void egl_getVertexAttribiv (sdl_data *, int, char *); 
enum { glGetVertexAttribPointervFunc = OPENGL_EXTS_H + 144 };
typedef void (APIENTRY * ESDLGLGETVERTEXATTRIBPOINTERVPROC)(GLuint index, GLenum pname,  GLvoid* *pointer);
ESDL_EXTERN ESDLGLGETVERTEXATTRIBPOINTERVPROC esdl_glGetVertexAttribPointerv;
void egl_getVertexAttribPointerv (sdl_data *, int, char *); 
enum { glIsProgramFunc = OPENGL_EXTS_H + 145 };
typedef GLboolean (APIENTRY * ESDLGLISPROGRAMPROC)(GLuint program);
ESDL_EXTERN ESDLGLISPROGRAMPROC esdl_glIsProgram;
void egl_isProgram (sdl_data *, int, char *); 
enum { glIsShaderFunc = OPENGL_EXTS_H + 146 };
typedef GLboolean (APIENTRY * ESDLGLISSHADERPROC)(GLuint shader);
ESDL_EXTERN ESDLGLISSHADERPROC esdl_glIsShader;
void egl_isShader (sdl_data *, int, char *); 
enum { glLinkProgramFunc = OPENGL_EXTS_H + 147 };
typedef void (APIENTRY * ESDLGLLINKPROGRAMPROC)(GLuint program);
ESDL_EXTERN ESDLGLLINKPROGRAMPROC esdl_glLinkProgram;
void egl_linkProgram (sdl_data *, int, char *); 
enum { glShaderSourceFunc = OPENGL_EXTS_H + 148 };
typedef void (APIENTRY * ESDLGLSHADERSOURCEPROC)(GLuint shader, GLsizei count,  const GLchar* *string,  const GLint * length);
ESDL_EXTERN ESDLGLSHADERSOURCEPROC esdl_glShaderSource;
void egl_shaderSource (sdl_data *, int, char *); 
enum { glUseProgramFunc = OPENGL_EXTS_H + 149 };
typedef void (APIENTRY * ESDLGLUSEPROGRAMPROC)(GLuint program);
ESDL_EXTERN ESDLGLUSEPROGRAMPROC esdl_glUseProgram;
void egl_useProgram (sdl_data *, int, char *); 
enum { glUniform1fFunc = OPENGL_EXTS_H + 150 };
typedef void (APIENTRY * ESDLGLUNIFORM1FPROC)(GLint location, GLfloat v0);
ESDL_EXTERN ESDLGLUNIFORM1FPROC esdl_glUniform1f;
void egl_uniform1f (sdl_data *, int, char *); 
enum { glUniform2fFunc = OPENGL_EXTS_H + 151 };
typedef void (APIENTRY * ESDLGLUNIFORM2FPROC)(GLint location, GLfloat v0, GLfloat v1);
ESDL_EXTERN ESDLGLUNIFORM2FPROC esdl_glUniform2f;
void egl_uniform2f (sdl_data *, int, char *); 
enum { glUniform3fFunc = OPENGL_EXTS_H + 152 };
typedef void (APIENTRY * ESDLGLUNIFORM3FPROC)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
ESDL_EXTERN ESDLGLUNIFORM3FPROC esdl_glUniform3f;
void egl_uniform3f (sdl_data *, int, char *); 
enum { glUniform4fFunc = OPENGL_EXTS_H + 153 };
typedef void (APIENTRY * ESDLGLUNIFORM4FPROC)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
ESDL_EXTERN ESDLGLUNIFORM4FPROC esdl_glUniform4f;
void egl_uniform4f (sdl_data *, int, char *); 
enum { glUniform1iFunc = OPENGL_EXTS_H + 154 };
typedef void (APIENTRY * ESDLGLUNIFORM1IPROC)(GLint location, GLint v0);
ESDL_EXTERN ESDLGLUNIFORM1IPROC esdl_glUniform1i;
void egl_uniform1i (sdl_data *, int, char *); 
enum { glUniform2iFunc = OPENGL_EXTS_H + 155 };
typedef void (APIENTRY * ESDLGLUNIFORM2IPROC)(GLint location, GLint v0, GLint v1);
ESDL_EXTERN ESDLGLUNIFORM2IPROC esdl_glUniform2i;
void egl_uniform2i (sdl_data *, int, char *); 
enum { glUniform3iFunc = OPENGL_EXTS_H + 156 };
typedef void (APIENTRY * ESDLGLUNIFORM3IPROC)(GLint location, GLint v0, GLint v1, GLint v2);
ESDL_EXTERN ESDLGLUNIFORM3IPROC esdl_glUniform3i;
void egl_uniform3i (sdl_data *, int, char *); 
enum { glUniform4iFunc = OPENGL_EXTS_H + 157 };
typedef void (APIENTRY * ESDLGLUNIFORM4IPROC)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
ESDL_EXTERN ESDLGLUNIFORM4IPROC esdl_glUniform4i;
void egl_uniform4i (sdl_data *, int, char *); 
enum { glUniform1fvFunc = OPENGL_EXTS_H + 158 };
typedef void (APIENTRY * ESDLGLUNIFORM1FVPROC)(GLint location, GLsizei count,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORM1FVPROC esdl_glUniform1fv;
void egl_uniform1fv (sdl_data *, int, char *); 
enum { glUniform2fvFunc = OPENGL_EXTS_H + 159 };
typedef void (APIENTRY * ESDLGLUNIFORM2FVPROC)(GLint location, GLsizei count,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORM2FVPROC esdl_glUniform2fv;
void egl_uniform2fv (sdl_data *, int, char *); 
enum { glUniform3fvFunc = OPENGL_EXTS_H + 160 };
typedef void (APIENTRY * ESDLGLUNIFORM3FVPROC)(GLint location, GLsizei count,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORM3FVPROC esdl_glUniform3fv;
void egl_uniform3fv (sdl_data *, int, char *); 
enum { glUniform4fvFunc = OPENGL_EXTS_H + 161 };
typedef void (APIENTRY * ESDLGLUNIFORM4FVPROC)(GLint location, GLsizei count,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORM4FVPROC esdl_glUniform4fv;
void egl_uniform4fv (sdl_data *, int, char *); 
enum { glUniform1ivFunc = OPENGL_EXTS_H + 162 };
typedef void (APIENTRY * ESDLGLUNIFORM1IVPROC)(GLint location, GLsizei count,  const GLint * value);
ESDL_EXTERN ESDLGLUNIFORM1IVPROC esdl_glUniform1iv;
void egl_uniform1iv (sdl_data *, int, char *); 
enum { glUniform2ivFunc = OPENGL_EXTS_H + 163 };
typedef void (APIENTRY * ESDLGLUNIFORM2IVPROC)(GLint location, GLsizei count,  const GLint * value);
ESDL_EXTERN ESDLGLUNIFORM2IVPROC esdl_glUniform2iv;
void egl_uniform2iv (sdl_data *, int, char *); 
enum { glUniform3ivFunc = OPENGL_EXTS_H + 164 };
typedef void (APIENTRY * ESDLGLUNIFORM3IVPROC)(GLint location, GLsizei count,  const GLint * value);
ESDL_EXTERN ESDLGLUNIFORM3IVPROC esdl_glUniform3iv;
void egl_uniform3iv (sdl_data *, int, char *); 
enum { glUniform4ivFunc = OPENGL_EXTS_H + 165 };
typedef void (APIENTRY * ESDLGLUNIFORM4IVPROC)(GLint location, GLsizei count,  const GLint * value);
ESDL_EXTERN ESDLGLUNIFORM4IVPROC esdl_glUniform4iv;
void egl_uniform4iv (sdl_data *, int, char *); 
enum { glUniformMatrix2fvFunc = OPENGL_EXTS_H + 166 };
typedef void (APIENTRY * ESDLGLUNIFORMMATRIX2FVPROC)(GLint location, GLsizei count, GLboolean transpose,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORMMATRIX2FVPROC esdl_glUniformMatrix2fv;
void egl_uniformMatrix2fv (sdl_data *, int, char *); 
enum { glUniformMatrix3fvFunc = OPENGL_EXTS_H + 167 };
typedef void (APIENTRY * ESDLGLUNIFORMMATRIX3FVPROC)(GLint location, GLsizei count, GLboolean transpose,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORMMATRIX3FVPROC esdl_glUniformMatrix3fv;
void egl_uniformMatrix3fv (sdl_data *, int, char *); 
enum { glUniformMatrix4fvFunc = OPENGL_EXTS_H + 168 };
typedef void (APIENTRY * ESDLGLUNIFORMMATRIX4FVPROC)(GLint location, GLsizei count, GLboolean transpose,  const GLfloat * value);
ESDL_EXTERN ESDLGLUNIFORMMATRIX4FVPROC esdl_glUniformMatrix4fv;
void egl_uniformMatrix4fv (sdl_data *, int, char *); 
enum { glValidateProgramFunc = OPENGL_EXTS_H + 169 };
typedef void (APIENTRY * ESDLGLVALIDATEPROGRAMPROC)(GLuint program);
ESDL_EXTERN ESDLGLVALIDATEPROGRAMPROC esdl_glValidateProgram;
void egl_validateProgram (sdl_data *, int, char *); 
enum { glVertexAttrib1dvFunc = OPENGL_EXTS_H + 170 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1DVPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1DVPROC esdl_glVertexAttrib1dv;
void egl_vertexAttrib1dv (sdl_data *, int, char *); 
enum { glVertexAttrib1fvFunc = OPENGL_EXTS_H + 171 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1FVPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1FVPROC esdl_glVertexAttrib1fv;
void egl_vertexAttrib1fv (sdl_data *, int, char *); 
enum { glVertexAttrib1svFunc = OPENGL_EXTS_H + 172 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB1SVPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB1SVPROC esdl_glVertexAttrib1sv;
void egl_vertexAttrib1sv (sdl_data *, int, char *); 
enum { glVertexAttrib2dvFunc = OPENGL_EXTS_H + 173 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2DVPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2DVPROC esdl_glVertexAttrib2dv;
void egl_vertexAttrib2dv (sdl_data *, int, char *); 
enum { glVertexAttrib2fvFunc = OPENGL_EXTS_H + 174 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2FVPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2FVPROC esdl_glVertexAttrib2fv;
void egl_vertexAttrib2fv (sdl_data *, int, char *); 
enum { glVertexAttrib2svFunc = OPENGL_EXTS_H + 175 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB2SVPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB2SVPROC esdl_glVertexAttrib2sv;
void egl_vertexAttrib2sv (sdl_data *, int, char *); 
enum { glVertexAttrib3dvFunc = OPENGL_EXTS_H + 176 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3DVPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3DVPROC esdl_glVertexAttrib3dv;
void egl_vertexAttrib3dv (sdl_data *, int, char *); 
enum { glVertexAttrib3fvFunc = OPENGL_EXTS_H + 177 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3FVPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3FVPROC esdl_glVertexAttrib3fv;
void egl_vertexAttrib3fv (sdl_data *, int, char *); 
enum { glVertexAttrib3svFunc = OPENGL_EXTS_H + 178 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB3SVPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB3SVPROC esdl_glVertexAttrib3sv;
void egl_vertexAttrib3sv (sdl_data *, int, char *); 
enum { glVertexAttrib4NbvFunc = OPENGL_EXTS_H + 179 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NBVPROC)(GLuint index,  const GLbyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NBVPROC esdl_glVertexAttrib4Nbv;
void egl_vertexAttrib4Nbv (sdl_data *, int, char *); 
enum { glVertexAttrib4NivFunc = OPENGL_EXTS_H + 180 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NIVPROC)(GLuint index,  const GLint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NIVPROC esdl_glVertexAttrib4Niv;
void egl_vertexAttrib4Niv (sdl_data *, int, char *); 
enum { glVertexAttrib4NsvFunc = OPENGL_EXTS_H + 181 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NSVPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NSVPROC esdl_glVertexAttrib4Nsv;
void egl_vertexAttrib4Nsv (sdl_data *, int, char *); 
enum { glVertexAttrib4NubFunc = OPENGL_EXTS_H + 182 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUBPROC)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUBPROC esdl_glVertexAttrib4Nub;
void egl_vertexAttrib4Nub (sdl_data *, int, char *); 
enum { glVertexAttrib4NubvFunc = OPENGL_EXTS_H + 183 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUBVPROC)(GLuint index,  const GLubyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUBVPROC esdl_glVertexAttrib4Nubv;
void egl_vertexAttrib4Nubv (sdl_data *, int, char *); 
enum { glVertexAttrib4NuivFunc = OPENGL_EXTS_H + 184 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUIVPROC)(GLuint index,  const GLuint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUIVPROC esdl_glVertexAttrib4Nuiv;
void egl_vertexAttrib4Nuiv (sdl_data *, int, char *); 
enum { glVertexAttrib4NusvFunc = OPENGL_EXTS_H + 185 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4NUSVPROC)(GLuint index,  const GLushort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4NUSVPROC esdl_glVertexAttrib4Nusv;
void egl_vertexAttrib4Nusv (sdl_data *, int, char *); 
enum { glVertexAttrib4bvFunc = OPENGL_EXTS_H + 186 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4BVPROC)(GLuint index,  const GLbyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4BVPROC esdl_glVertexAttrib4bv;
void egl_vertexAttrib4bv (sdl_data *, int, char *); 
enum { glVertexAttrib4dvFunc = OPENGL_EXTS_H + 187 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4DVPROC)(GLuint index,  const GLdouble * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4DVPROC esdl_glVertexAttrib4dv;
void egl_vertexAttrib4dv (sdl_data *, int, char *); 
enum { glVertexAttrib4fvFunc = OPENGL_EXTS_H + 188 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4FVPROC)(GLuint index,  const GLfloat * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4FVPROC esdl_glVertexAttrib4fv;
void egl_vertexAttrib4fv (sdl_data *, int, char *); 
enum { glVertexAttrib4ivFunc = OPENGL_EXTS_H + 189 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4IVPROC)(GLuint index,  const GLint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4IVPROC esdl_glVertexAttrib4iv;
void egl_vertexAttrib4iv (sdl_data *, int, char *); 
enum { glVertexAttrib4svFunc = OPENGL_EXTS_H + 190 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4SVPROC)(GLuint index,  const GLshort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4SVPROC esdl_glVertexAttrib4sv;
void egl_vertexAttrib4sv (sdl_data *, int, char *); 
enum { glVertexAttrib4ubvFunc = OPENGL_EXTS_H + 191 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4UBVPROC)(GLuint index,  const GLubyte * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4UBVPROC esdl_glVertexAttrib4ubv;
void egl_vertexAttrib4ubv (sdl_data *, int, char *); 
enum { glVertexAttrib4uivFunc = OPENGL_EXTS_H + 192 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4UIVPROC)(GLuint index,  const GLuint * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4UIVPROC esdl_glVertexAttrib4uiv;
void egl_vertexAttrib4uiv (sdl_data *, int, char *); 
enum { glVertexAttrib4usvFunc = OPENGL_EXTS_H + 193 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIB4USVPROC)(GLuint index,  const GLushort * v);
ESDL_EXTERN ESDLGLVERTEXATTRIB4USVPROC esdl_glVertexAttrib4usv;
void egl_vertexAttrib4usv (sdl_data *, int, char *); 
enum { glVertexAttribPointerFunc = OPENGL_EXTS_H + 194 };
typedef void (APIENTRY * ESDLGLVERTEXATTRIBPOINTERPROC)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLVERTEXATTRIBPOINTERPROC esdl_glVertexAttribPointer;
void egl_vertexAttribPointer (sdl_data *, int, char *); 
enum { glWeightbvARBFunc = OPENGL_EXTS_H + 195 };
typedef void (APIENTRY * ESDLGLWEIGHTBVARBPROC)(GLint size,  const GLbyte * weights);
ESDL_EXTERN ESDLGLWEIGHTBVARBPROC esdl_glWeightbvARB;
void egl_weightbvARB (sdl_data *, int, char *); 
enum { glWeightsvARBFunc = OPENGL_EXTS_H + 196 };
typedef void (APIENTRY * ESDLGLWEIGHTSVARBPROC)(GLint size,  const GLshort * weights);
ESDL_EXTERN ESDLGLWEIGHTSVARBPROC esdl_glWeightsvARB;
void egl_weightsvARB (sdl_data *, int, char *); 
enum { glWeightivARBFunc = OPENGL_EXTS_H + 197 };
typedef void (APIENTRY * ESDLGLWEIGHTIVARBPROC)(GLint size,  const GLint * weights);
ESDL_EXTERN ESDLGLWEIGHTIVARBPROC esdl_glWeightivARB;
void egl_weightivARB (sdl_data *, int, char *); 
enum { glWeightfvARBFunc = OPENGL_EXTS_H + 198 };
typedef void (APIENTRY * ESDLGLWEIGHTFVARBPROC)(GLint size,  const GLfloat * weights);
ESDL_EXTERN ESDLGLWEIGHTFVARBPROC esdl_glWeightfvARB;
void egl_weightfvARB (sdl_data *, int, char *); 
enum { glWeightdvARBFunc = OPENGL_EXTS_H + 199 };
typedef void (APIENTRY * ESDLGLWEIGHTDVARBPROC)(GLint size,  const GLdouble * weights);
ESDL_EXTERN ESDLGLWEIGHTDVARBPROC esdl_glWeightdvARB;
void egl_weightdvARB (sdl_data *, int, char *); 
enum { glWeightubvARBFunc = OPENGL_EXTS_H + 200 };
typedef void (APIENTRY * ESDLGLWEIGHTUBVARBPROC)(GLint size,  const GLubyte * weights);
ESDL_EXTERN ESDLGLWEIGHTUBVARBPROC esdl_glWeightubvARB;
void egl_weightubvARB (sdl_data *, int, char *); 
enum { glWeightusvARBFunc = OPENGL_EXTS_H + 201 };
typedef void (APIENTRY * ESDLGLWEIGHTUSVARBPROC)(GLint size,  const GLushort * weights);
ESDL_EXTERN ESDLGLWEIGHTUSVARBPROC esdl_glWeightusvARB;
void egl_weightusvARB (sdl_data *, int, char *); 
enum { glWeightuivARBFunc = OPENGL_EXTS_H + 202 };
typedef void (APIENTRY * ESDLGLWEIGHTUIVARBPROC)(GLint size,  const GLuint * weights);
ESDL_EXTERN ESDLGLWEIGHTUIVARBPROC esdl_glWeightuivARB;
void egl_weightuivARB (sdl_data *, int, char *); 
enum { glWeightPointerARBFunc = OPENGL_EXTS_H + 203 };
typedef void (APIENTRY * ESDLGLWEIGHTPOINTERARBPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLWEIGHTPOINTERARBPROC esdl_glWeightPointerARB;
void egl_weightPointerARB (sdl_data *, int, char *); 
enum { glVertexBlendARBFunc = OPENGL_EXTS_H + 204 };
typedef void (APIENTRY * ESDLGLVERTEXBLENDARBPROC)(GLint count);
ESDL_EXTERN ESDLGLVERTEXBLENDARBPROC esdl_glVertexBlendARB;
void egl_vertexBlendARB (sdl_data *, int, char *); 
enum { glCurrentPaletteMatrixARBFunc = OPENGL_EXTS_H + 205 };
typedef void (APIENTRY * ESDLGLCURRENTPALETTEMATRIXARBPROC)(GLint index);
ESDL_EXTERN ESDLGLCURRENTPALETTEMATRIXARBPROC esdl_glCurrentPaletteMatrixARB;
void egl_currentPaletteMatrixARB (sdl_data *, int, char *); 
enum { glMatrixIndexubvARBFunc = OPENGL_EXTS_H + 206 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUBVARBPROC)(GLint size,  const GLubyte * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUBVARBPROC esdl_glMatrixIndexubvARB;
void egl_matrixIndexubvARB (sdl_data *, int, char *); 
enum { glMatrixIndexusvARBFunc = OPENGL_EXTS_H + 207 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUSVARBPROC)(GLint size,  const GLushort * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUSVARBPROC esdl_glMatrixIndexusvARB;
void egl_matrixIndexusvARB (sdl_data *, int, char *); 
enum { glMatrixIndexuivARBFunc = OPENGL_EXTS_H + 208 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXUIVARBPROC)(GLint size,  const GLuint * indices);
ESDL_EXTERN ESDLGLMATRIXINDEXUIVARBPROC esdl_glMatrixIndexuivARB;
void egl_matrixIndexuivARB (sdl_data *, int, char *); 
enum { glMatrixIndexPointerARBFunc = OPENGL_EXTS_H + 209 };
typedef void (APIENTRY * ESDLGLMATRIXINDEXPOINTERARBPROC)(GLint size, GLenum type, GLsizei stride,  const GLvoid * pointer);
ESDL_EXTERN ESDLGLMATRIXINDEXPOINTERARBPROC esdl_glMatrixIndexPointerARB;
void egl_matrixIndexPointerARB (sdl_data *, int, char *); 
enum { glProgramStringARBFunc = OPENGL_EXTS_H + 210 };
typedef void (APIENTRY * ESDLGLPROGRAMSTRINGARBPROC)(GLenum target, GLenum format, GLsizei len,  const GLvoid * string);
ESDL_EXTERN ESDLGLPROGRAMSTRINGARBPROC esdl_glProgramStringARB;
void egl_programStringARB (sdl_data *, int, char *); 
enum { glBindProgramARBFunc = OPENGL_EXTS_H + 211 };
typedef void (APIENTRY * ESDLGLBINDPROGRAMARBPROC)(GLenum target, GLuint program);
ESDL_EXTERN ESDLGLBINDPROGRAMARBPROC esdl_glBindProgramARB;
void egl_bindProgramARB (sdl_data *, int, char *); 
enum { glDeleteProgramsARBFunc = OPENGL_EXTS_H + 212 };
typedef void (APIENTRY * ESDLGLDELETEPROGRAMSARBPROC)(GLsizei n,  const GLuint * programs);
ESDL_EXTERN ESDLGLDELETEPROGRAMSARBPROC esdl_glDeleteProgramsARB;
void egl_deleteProgramsARB (sdl_data *, int, char *); 
enum { glGenProgramsARBFunc = OPENGL_EXTS_H + 213 };
typedef void (APIENTRY * ESDLGLGENPROGRAMSARBPROC)(GLsizei n, GLuint * programs);
ESDL_EXTERN ESDLGLGENPROGRAMSARBPROC esdl_glGenProgramsARB;
void egl_genProgramsARB (sdl_data *, int, char *); 
enum { glProgramEnvParameter4dvARBFunc = OPENGL_EXTS_H + 214 };
typedef void (APIENTRY * ESDLGLPROGRAMENVPARAMETER4DVARBPROC)(GLenum target, GLuint index,  const GLdouble * params);
ESDL_EXTERN ESDLGLPROGRAMENVPARAMETER4DVARBPROC esdl_glProgramEnvParameter4dvARB;
void egl_programEnvParameter4dvARB (sdl_data *, int, char *); 
enum { glProgramEnvParameter4fvARBFunc = OPENGL_EXTS_H + 215 };
typedef void (APIENTRY * ESDLGLPROGRAMENVPARAMETER4FVARBPROC)(GLenum target, GLuint index,  const GLfloat * params);
ESDL_EXTERN ESDLGLPROGRAMENVPARAMETER4FVARBPROC esdl_glProgramEnvParameter4fvARB;
void egl_programEnvParameter4fvARB (sdl_data *, int, char *); 
enum { glProgramLocalParameter4dvARBFunc = OPENGL_EXTS_H + 216 };
typedef void (APIENTRY * ESDLGLPROGRAMLOCALPARAMETER4DVARBPROC)(GLenum target, GLuint index,  const GLdouble * params);
ESDL_EXTERN ESDLGLPROGRAMLOCALPARAMETER4DVARBPROC esdl_glProgramLocalParameter4dvARB;
void egl_programLocalParameter4dvARB (sdl_data *, int, char *); 
enum { glProgramLocalParameter4fvARBFunc = OPENGL_EXTS_H + 217 };
typedef void (APIENTRY * ESDLGLPROGRAMLOCALPARAMETER4FVARBPROC)(GLenum target, GLuint index,  const GLfloat * params);
ESDL_EXTERN ESDLGLPROGRAMLOCALPARAMETER4FVARBPROC esdl_glProgramLocalParameter4fvARB;
void egl_programLocalParameter4fvARB (sdl_data *, int, char *); 
enum { glGetProgramEnvParameterdvARBFunc = OPENGL_EXTS_H + 218 };
typedef void (APIENTRY * ESDLGLGETPROGRAMENVPARAMETERDVARBPROC)(GLenum target, GLuint index, GLdouble * params);
ESDL_EXTERN ESDLGLGETPROGRAMENVPARAMETERDVARBPROC esdl_glGetProgramEnvParameterdvARB;
void egl_getProgramEnvParameterdvARB (sdl_data *, int, char *); 
enum { glGetProgramEnvParameterfvARBFunc = OPENGL_EXTS_H + 219 };
typedef void (APIENTRY * ESDLGLGETPROGRAMENVPARAMETERFVARBPROC)(GLenum target, GLuint index, GLfloat * params);
ESDL_EXTERN ESDLGLGETPROGRAMENVPARAMETERFVARBPROC esdl_glGetProgramEnvParameterfvARB;
void egl_getProgramEnvParameterfvARB (sdl_data *, int, char *); 
enum { glGetProgramLocalParameterdvARBFunc = OPENGL_EXTS_H + 220 };
typedef void (APIENTRY * ESDLGLGETPROGRAMLOCALPARAMETERDVARBPROC)(GLenum target, GLuint index, GLdouble * params);
ESDL_EXTERN ESDLGLGETPROGRAMLOCALPARAMETERDVARBPROC esdl_glGetProgramLocalParameterdvARB;
void egl_getProgramLocalParameterdvARB (sdl_data *, int, char *); 
enum { glGetProgramLocalParameterfvARBFunc = OPENGL_EXTS_H + 221 };
typedef void (APIENTRY * ESDLGLGETPROGRAMLOCALPARAMETERFVARBPROC)(GLenum target, GLuint index, GLfloat * params);
ESDL_EXTERN ESDLGLGETPROGRAMLOCALPARAMETERFVARBPROC esdl_glGetProgramLocalParameterfvARB;
void egl_getProgramLocalParameterfvARB (sdl_data *, int, char *); 
enum { glGetProgramStringARBFunc = OPENGL_EXTS_H + 222 };
typedef void (APIENTRY * ESDLGLGETPROGRAMSTRINGARBPROC)(GLenum target, GLenum pname, GLvoid * string);
ESDL_EXTERN ESDLGLGETPROGRAMSTRINGARBPROC esdl_glGetProgramStringARB;
void egl_getProgramStringARB (sdl_data *, int, char *); 
enum { glDeleteObjectARBFunc = OPENGL_EXTS_H + 223 };
typedef void (APIENTRY * ESDLGLDELETEOBJECTARBPROC)(GLhandleARB obj);
ESDL_EXTERN ESDLGLDELETEOBJECTARBPROC esdl_glDeleteObjectARB;
void egl_deleteObjectARB (sdl_data *, int, char *); 
enum { glGetHandleARBFunc = OPENGL_EXTS_H + 224 };
typedef GLhandleARB (APIENTRY * ESDLGLGETHANDLEARBPROC)(GLenum pname);
ESDL_EXTERN ESDLGLGETHANDLEARBPROC esdl_glGetHandleARB;
void egl_getHandleARB (sdl_data *, int, char *); 
enum { glDetachObjectARBFunc = OPENGL_EXTS_H + 225 };
typedef void (APIENTRY * ESDLGLDETACHOBJECTARBPROC)(GLhandleARB containerObj, GLhandleARB attachedObj);
ESDL_EXTERN ESDLGLDETACHOBJECTARBPROC esdl_glDetachObjectARB;
void egl_detachObjectARB (sdl_data *, int, char *); 
enum { glCreateShaderObjectARBFunc = OPENGL_EXTS_H + 226 };
typedef GLhandleARB (APIENTRY * ESDLGLCREATESHADEROBJECTARBPROC)(GLenum shaderType);
ESDL_EXTERN ESDLGLCREATESHADEROBJECTARBPROC esdl_glCreateShaderObjectARB;
void egl_createShaderObjectARB (sdl_data *, int, char *); 
enum { glCreateProgramObjectARBFunc = OPENGL_EXTS_H + 227 };
typedef GLhandleARB (APIENTRY * ESDLGLCREATEPROGRAMOBJECTARBPROC)();
ESDL_EXTERN ESDLGLCREATEPROGRAMOBJECTARBPROC esdl_glCreateProgramObjectARB;
void egl_createProgramObjectARB (sdl_data *, int, char *); 
enum { glAttachObjectARBFunc = OPENGL_EXTS_H + 228 };
typedef void (APIENTRY * ESDLGLATTACHOBJECTARBPROC)(GLhandleARB containerObj, GLhandleARB obj);
ESDL_EXTERN ESDLGLATTACHOBJECTARBPROC esdl_glAttachObjectARB;
void egl_attachObjectARB (sdl_data *, int, char *); 
enum { glUseProgramObjectARBFunc = OPENGL_EXTS_H + 229 };
typedef void (APIENTRY * ESDLGLUSEPROGRAMOBJECTARBPROC)(GLhandleARB programObj);
ESDL_EXTERN ESDLGLUSEPROGRAMOBJECTARBPROC esdl_glUseProgramObjectARB;
void egl_useProgramObjectARB (sdl_data *, int, char *); 
enum { glGetObjectParameterfvARBFunc = OPENGL_EXTS_H + 230 };
typedef void (APIENTRY * ESDLGLGETOBJECTPARAMETERFVARBPROC)(GLhandleARB obj, GLenum pname, GLfloat * params);
ESDL_EXTERN ESDLGLGETOBJECTPARAMETERFVARBPROC esdl_glGetObjectParameterfvARB;
void egl_getObjectParameterfvARB (sdl_data *, int, char *); 
enum { glGetObjectParameterivARBFunc = OPENGL_EXTS_H + 231 };
typedef void (APIENTRY * ESDLGLGETOBJECTPARAMETERIVARBPROC)(GLhandleARB obj, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETOBJECTPARAMETERIVARBPROC esdl_glGetObjectParameterivARB;
void egl_getObjectParameterivARB (sdl_data *, int, char *); 
enum { glGetInfoLogARBFunc = OPENGL_EXTS_H + 232 };
typedef void (APIENTRY * ESDLGLGETINFOLOGARBPROC)(GLhandleARB obj, GLsizei maxLength, GLsizei * length, GLcharARB * infoLog);
ESDL_EXTERN ESDLGLGETINFOLOGARBPROC esdl_glGetInfoLogARB;
void egl_getInfoLogARB (sdl_data *, int, char *); 
enum { glGetAttachedObjectsARBFunc = OPENGL_EXTS_H + 233 };
typedef void (APIENTRY * ESDLGLGETATTACHEDOBJECTSARBPROC)(GLhandleARB containerObj, GLsizei maxCount, GLsizei * count, GLhandleARB * obj);
ESDL_EXTERN ESDLGLGETATTACHEDOBJECTSARBPROC esdl_glGetAttachedObjectsARB;
void egl_getAttachedObjectsARB (sdl_data *, int, char *); 
enum { glStencilOpSeparateATIFunc = OPENGL_EXTS_H + 234 };
typedef void (APIENTRY * ESDLGLSTENCILOPSEPARATEATIPROC)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
ESDL_EXTERN ESDLGLSTENCILOPSEPARATEATIPROC esdl_glStencilOpSeparateATI;
void egl_stencilOpSeparateATI (sdl_data *, int, char *); 
enum { glStencilFuncSeparateATIFunc = OPENGL_EXTS_H + 235 };
typedef void (APIENTRY * ESDLGLSTENCILFUNCSEPARATEATIPROC)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
ESDL_EXTERN ESDLGLSTENCILFUNCSEPARATEATIPROC esdl_glStencilFuncSeparateATI;
void egl_stencilFuncSeparateATI (sdl_data *, int, char *); 
enum { glIsRenderbufferEXTFunc = OPENGL_EXTS_H + 236 };
typedef GLboolean (APIENTRY * ESDLGLISRENDERBUFFEREXTPROC)(GLuint renderbuffer);
ESDL_EXTERN ESDLGLISRENDERBUFFEREXTPROC esdl_glIsRenderbufferEXT;
void egl_isRenderbufferEXT (sdl_data *, int, char *); 
enum { glBindRenderbufferEXTFunc = OPENGL_EXTS_H + 237 };
typedef void (APIENTRY * ESDLGLBINDRENDERBUFFEREXTPROC)(GLenum target, GLuint renderbuffer);
ESDL_EXTERN ESDLGLBINDRENDERBUFFEREXTPROC esdl_glBindRenderbufferEXT;
void egl_bindRenderbufferEXT (sdl_data *, int, char *); 
enum { glDeleteRenderbuffersEXTFunc = OPENGL_EXTS_H + 238 };
typedef void (APIENTRY * ESDLGLDELETERENDERBUFFERSEXTPROC)(GLsizei n,  const GLuint * renderbuffers);
ESDL_EXTERN ESDLGLDELETERENDERBUFFERSEXTPROC esdl_glDeleteRenderbuffersEXT;
void egl_deleteRenderbuffersEXT (sdl_data *, int, char *); 
enum { glGenRenderbuffersEXTFunc = OPENGL_EXTS_H + 239 };
typedef void (APIENTRY * ESDLGLGENRENDERBUFFERSEXTPROC)(GLsizei n, GLuint * renderbuffers);
ESDL_EXTERN ESDLGLGENRENDERBUFFERSEXTPROC esdl_glGenRenderbuffersEXT;
void egl_genRenderbuffersEXT (sdl_data *, int, char *); 
enum { glRenderbufferStorageEXTFunc = OPENGL_EXTS_H + 240 };
typedef void (APIENTRY * ESDLGLRENDERBUFFERSTORAGEEXTPROC)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
ESDL_EXTERN ESDLGLRENDERBUFFERSTORAGEEXTPROC esdl_glRenderbufferStorageEXT;
void egl_renderbufferStorageEXT (sdl_data *, int, char *); 
enum { glGetRenderbufferParameterivEXTFunc = OPENGL_EXTS_H + 241 };
typedef void (APIENTRY * ESDLGLGETRENDERBUFFERPARAMETERIVEXTPROC)(GLenum target, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETRENDERBUFFERPARAMETERIVEXTPROC esdl_glGetRenderbufferParameterivEXT;
void egl_getRenderbufferParameterivEXT (sdl_data *, int, char *); 
enum { glIsFramebufferEXTFunc = OPENGL_EXTS_H + 242 };
typedef GLboolean (APIENTRY * ESDLGLISFRAMEBUFFEREXTPROC)(GLuint framebuffer);
ESDL_EXTERN ESDLGLISFRAMEBUFFEREXTPROC esdl_glIsFramebufferEXT;
void egl_isFramebufferEXT (sdl_data *, int, char *); 
enum { glBindFramebufferEXTFunc = OPENGL_EXTS_H + 243 };
typedef void (APIENTRY * ESDLGLBINDFRAMEBUFFEREXTPROC)(GLenum target, GLuint framebuffer);
ESDL_EXTERN ESDLGLBINDFRAMEBUFFEREXTPROC esdl_glBindFramebufferEXT;
void egl_bindFramebufferEXT (sdl_data *, int, char *); 
enum { glDeleteFramebuffersEXTFunc = OPENGL_EXTS_H + 244 };
typedef void (APIENTRY * ESDLGLDELETEFRAMEBUFFERSEXTPROC)(GLsizei n,  const GLuint * framebuffers);
ESDL_EXTERN ESDLGLDELETEFRAMEBUFFERSEXTPROC esdl_glDeleteFramebuffersEXT;
void egl_deleteFramebuffersEXT (sdl_data *, int, char *); 
enum { glGenFramebuffersEXTFunc = OPENGL_EXTS_H + 245 };
typedef void (APIENTRY * ESDLGLGENFRAMEBUFFERSEXTPROC)(GLsizei n, GLuint * framebuffers);
ESDL_EXTERN ESDLGLGENFRAMEBUFFERSEXTPROC esdl_glGenFramebuffersEXT;
void egl_genFramebuffersEXT (sdl_data *, int, char *); 
enum { glCheckFramebufferStatusEXTFunc = OPENGL_EXTS_H + 246 };
typedef GLenum (APIENTRY * ESDLGLCHECKFRAMEBUFFERSTATUSEXTPROC)(GLenum target);
ESDL_EXTERN ESDLGLCHECKFRAMEBUFFERSTATUSEXTPROC esdl_glCheckFramebufferStatusEXT;
void egl_checkFramebufferStatusEXT (sdl_data *, int, char *); 
enum { glFramebufferTexture1DEXTFunc = OPENGL_EXTS_H + 247 };
typedef void (APIENTRY * ESDLGLFRAMEBUFFERTEXTURE1DEXTPROC)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
ESDL_EXTERN ESDLGLFRAMEBUFFERTEXTURE1DEXTPROC esdl_glFramebufferTexture1DEXT;
void egl_framebufferTexture1DEXT (sdl_data *, int, char *); 
enum { glFramebufferTexture2DEXTFunc = OPENGL_EXTS_H + 248 };
typedef void (APIENTRY * ESDLGLFRAMEBUFFERTEXTURE2DEXTPROC)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
ESDL_EXTERN ESDLGLFRAMEBUFFERTEXTURE2DEXTPROC esdl_glFramebufferTexture2DEXT;
void egl_framebufferTexture2DEXT (sdl_data *, int, char *); 
enum { glFramebufferTexture3DEXTFunc = OPENGL_EXTS_H + 249 };
typedef void (APIENTRY * ESDLGLFRAMEBUFFERTEXTURE3DEXTPROC)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
ESDL_EXTERN ESDLGLFRAMEBUFFERTEXTURE3DEXTPROC esdl_glFramebufferTexture3DEXT;
void egl_framebufferTexture3DEXT (sdl_data *, int, char *); 
enum { glFramebufferRenderbufferEXTFunc = OPENGL_EXTS_H + 250 };
typedef void (APIENTRY * ESDLGLFRAMEBUFFERRENDERBUFFEREXTPROC)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
ESDL_EXTERN ESDLGLFRAMEBUFFERRENDERBUFFEREXTPROC esdl_glFramebufferRenderbufferEXT;
void egl_framebufferRenderbufferEXT (sdl_data *, int, char *); 
enum { glGetFramebufferAttachmentParameterivEXTFunc = OPENGL_EXTS_H + 251 };
typedef void (APIENTRY * ESDLGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC)(GLenum target, GLenum attachment, GLenum pname, GLint * params);
ESDL_EXTERN ESDLGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC esdl_glGetFramebufferAttachmentParameterivEXT;
void egl_getFramebufferAttachmentParameterivEXT (sdl_data *, int, char *); 
enum { glGenerateMipmapEXTFunc = OPENGL_EXTS_H + 252 };
typedef void (APIENTRY * ESDLGLGENERATEMIPMAPEXTPROC)(GLenum target);
ESDL_EXTERN ESDLGLGENERATEMIPMAPEXTPROC esdl_glGenerateMipmapEXT;
void egl_generateMipmapEXT (sdl_data *, int, char *); 
