/* Copyright (C) 2005 Red Hat, Inc. */

#include "boolean_internal.h"

typedef semanage_bool_key_t record_key_t;
typedef semanage_bool_t record_t;
#define DBASE_RECORD_DEFINED

#include <stddef.h>
#include <semanage/booleans_policy.h>
#include "handle.h"
#include "database.h"

int semanage_bool_query(
	semanage_handle_t* handle,
	semanage_bool_key_t* key,
	semanage_bool_t** response) {

	dbase_config_t* dconfig = semanage_bool_dbase_policy(handle);
	return dbase_query(handle, dconfig, key, response);
}

int semanage_bool_exists(
	semanage_handle_t* handle,
	semanage_bool_key_t* key,
	int* response) {

	dbase_config_t* dconfig = semanage_bool_dbase_policy(handle);
	return dbase_exists(handle, dconfig, key, response);
}

int semanage_bool_count(
	semanage_handle_t* handle,
	unsigned int* response) {

	dbase_config_t* dconfig = semanage_bool_dbase_policy(handle);
	return dbase_count(handle, dconfig, response);
}

int semanage_bool_iterate(
	semanage_handle_t* handle,
	int (*handler) (semanage_bool_t* record,
	                void* varg),
	void* handler_arg) {

	dbase_config_t* dconfig = semanage_bool_dbase_policy(handle);
	return dbase_iterate(handle, dconfig, handler, handler_arg);	
}

int semanage_bool_list(
	semanage_handle_t* handle,
	semanage_bool_t*** records,
	size_t* count) {

	dbase_config_t* dconfig = semanage_bool_dbase_policy(handle);
	return dbase_list(handle, dconfig, records, count);
}
