/* Copyright (C) 2005 Red Hat, Inc. */

#include "user_internal.h"

typedef semanage_user_key_t record_key_t;
typedef semanage_user_t record_t;
#define DBASE_RECORD_DEFINED

#include <stddef.h>
#include <semanage/users_local.h>
#include "handle.h" 
#include "database.h"

int semanage_user_add_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	semanage_user_t* data) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_add(handle, dconfig, key, data);
}

int semanage_user_modify_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	semanage_user_t* data) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);	
	return dbase_modify(handle, dconfig, key, data);
}


int semanage_user_set_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	semanage_user_t* data) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);	
	return dbase_set(handle, dconfig, key, data);
}

int semanage_user_del_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_del(handle, dconfig, key);
}

int semanage_user_query_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	semanage_user_t** response) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_query(handle, dconfig, key, response);
}

int semanage_user_exists_local(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	int* response) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_exists(handle, dconfig, key, response);
}

int semanage_user_count_local(
	semanage_handle_t* handle,
	unsigned int* response) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_count(handle, dconfig, response);
}

int semanage_user_iterate_local(
	semanage_handle_t* handle,
	int (*handler) (semanage_user_t* record,
	                void* varg),
	void* handler_arg) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_iterate(handle, dconfig, handler, handler_arg);
}

int semanage_user_list_local(
	semanage_handle_t* handle,
	semanage_user_t*** records,
	size_t* count) {

	dbase_config_t* dconfig = semanage_user_dbase_local(handle);
	return dbase_list(handle, dconfig, records, count);
}
