/* Copyright (C) 2005 Red Hat, Inc. */

#include "user_internal.h"

typedef semanage_user_key_t record_key_t;
typedef semanage_user_t record_t;
#define DBASE_RECORD_DEFINED

#include <stddef.h>
#include <semanage/users_policy.h>
#include "handle.h" 
#include "database.h"

int semanage_user_query(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	semanage_user_t** response) {

	dbase_config_t* dconfig = semanage_user_dbase_policy(handle);
	return dbase_query(handle, dconfig, key, response);
}

int semanage_user_exists(
	semanage_handle_t* handle,
	semanage_user_key_t* key,
	int* response) {

	dbase_config_t* dconfig = semanage_user_dbase_policy(handle);
	return dbase_exists(handle, dconfig, key, response);
}
hidden_def(semanage_user_exists)

int semanage_user_count(
	semanage_handle_t* handle,
	unsigned int* response) {

	dbase_config_t* dconfig = semanage_user_dbase_policy(handle);
	return dbase_count(handle, dconfig, response);
}

int semanage_user_iterate(
	semanage_handle_t* handle,
	int (*handler) (semanage_user_t* record,
	                void* varg),
	void* handler_arg) {

	dbase_config_t* dconfig = semanage_user_dbase_policy(handle);
	return dbase_iterate(handle, dconfig, handler, handler_arg);	
}

int semanage_user_list(
	semanage_handle_t* handle,
	semanage_user_t*** records,
	size_t* count) {

	dbase_config_t* dconfig = semanage_user_dbase_policy(handle);
	return dbase_list(handle, dconfig, records, count);
}
