////////////////////////////////////////////////////////////
//
// SFML - Simple and Fast Multimedia Library
// Copyright (C) 2007 Laurent Gomila (laurent.gom@gmail.com)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/Window/OpenGLCaps.hpp>
#include <SFML/Window/glew/glew.h>


namespace sf
{
////////////////////////////////////////////////////////////
/// Check whether or not an OpenGL extension is supported
////////////////////////////////////////////////////////////
bool OpenGLCaps::CheckExtension(const std::string& Name)
{
    return glewIsSupported(Name.c_str()) != 0;
}


////////////////////////////////////////////////////////////
/// Return the maximum texture size
////////////////////////////////////////////////////////////
int OpenGLCaps::GetMaxTextureSize()
{
    GLint Capability;
    glGetIntegerv(GL_MAX_TEXTURE_SIZE, &Capability);

    return static_cast<int>(Capability);
}


////////////////////////////////////////////////////////////
/// Return the maximum number of texture units available
////////////////////////////////////////////////////////////
int OpenGLCaps::GetMaxTextureUnits()
{
    GLint Capability;
    glGetIntegerv(GL_MAX_TEXTURE_COORDS_ARB, &Capability);

    return static_cast<int>(Capability);
}


////////////////////////////////////////////////////////////
/// Initialize the capabilities
////////////////////////////////////////////////////////////
void OpenGLCaps::Initialize()
{
    // Initialize GLEW
    glewInit();
}

} // namespace sf
