/* file-dict.c generated by valac 0.14.2, the Vala compiler
 * generated from file-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_FILE_DICT (skk_file_dict_get_type ())
#define SKK_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_FILE_DICT, SkkFileDict))
#define SKK_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_FILE_DICT, SkkFileDictClass))
#define SKK_IS_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_FILE_DICT))
#define SKK_IS_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_FILE_DICT))
#define SKK_FILE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_FILE_DICT, SkkFileDictClass))

typedef struct _SkkFileDict SkkFileDict;
typedef struct _SkkFileDictClass SkkFileDictClass;
typedef struct _SkkFileDictPrivate SkkFileDictPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkFileDict {
	SkkDict parent_instance;
	SkkFileDictPrivate * priv;
};

struct _SkkFileDictClass {
	SkkDictClass parent_class;
};

struct _SkkFileDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_file_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_file_dict_get_type (void) G_GNUC_CONST;
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_FILE_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_FILE_DICT, SkkFileDictPrivate))
enum  {
	SKK_FILE_DICT_DUMMY_PROPERTY,
	SKK_FILE_DICT_READ_ONLY
};
static gchar* skk_file_dict_read_line (SkkFileDict* self, glong* offset);
gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
static gchar* skk_file_dict_read_previous_line (SkkFileDict* self, glong* pos, const gchar* line);
static gchar* skk_file_dict_read_next_line (SkkFileDict* self, glong* pos, const gchar* line);
static gboolean skk_file_dict_read_until (SkkFileDict* self, glong* offset, const gchar* line);
GQuark skk_skk_dict_error_quark (void);
static void skk_file_dict_load (SkkFileDict* self, GError** error);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self, GError** error);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
static void skk_file_dict_real_reload (SkkDict* base, GError** error);
static gboolean skk_file_dict_search_pos (SkkFileDict* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction);
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static gint skk_file_dict_strcmp_prefix (const gchar* a, const gchar* b);
static gchar** skk_file_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b);
SkkFileDict* skk_file_dict_new (const gchar* path, const gchar* encoding, GError** error);
SkkFileDict* skk_file_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type, GFile* file);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_file_dict_finalize (GObject* obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_file_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gchar* skk_file_dict_read_line (SkkFileDict* self, glong* offset) {
	gchar* result = NULL;
	glong _tmp0_;
	SkkMemoryMappedFile* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	SkkMemoryMappedFile* _tmp4_;
	void* _tmp5_;
	void* _tmp6_;
	glong _tmp7_;
	gchar* p;
	glong _tmp14_;
	GString* _tmp17_;
	GString* builder;
	glong _tmp18_;
	glong _offset;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = skk_memory_mapped_file_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp3_, NULL);
	_tmp4_ = self->priv->mmap;
	_tmp5_ = skk_memory_mapped_file_get_memory (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = *offset;
	p = ((gchar*) _tmp6_) + _tmp7_;
	{
		gboolean _tmp8_;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_;
			glong _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				glong _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = *offset;
				*offset = _tmp10_ - 1;
				_tmp11_ = p;
				p = _tmp11_ - 1;
			}
			_tmp8_ = FALSE;
			_tmp12_ = *offset;
			if (!(_tmp12_ > ((glong) 0))) {
				break;
			}
			_tmp13_ = p;
			if ((*_tmp13_) == '\n') {
				break;
			}
		}
	}
	_tmp14_ = *offset;
	if (_tmp14_ > ((glong) 0)) {
		glong _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = *offset;
		*offset = _tmp15_ + 1;
		_tmp16_ = p;
		p = _tmp16_ + 1;
	}
	_tmp17_ = g_string_new ("");
	builder = _tmp17_;
	_tmp18_ = *offset;
	_offset = _tmp18_;
	{
		gboolean _tmp19_;
		_tmp19_ = TRUE;
		while (TRUE) {
			gboolean _tmp20_;
			glong _tmp23_;
			SkkMemoryMappedFile* _tmp24_;
			gsize _tmp25_;
			gsize _tmp26_;
			gchar* _tmp27_;
			GString* _tmp28_;
			gchar* _tmp29_;
			_tmp20_ = _tmp19_;
			if (!_tmp20_) {
				glong _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = _offset;
				_offset = _tmp21_ + 1;
				_tmp22_ = p;
				p = _tmp22_ + 1;
			}
			_tmp19_ = FALSE;
			_tmp23_ = _offset;
			_tmp24_ = self->priv->mmap;
			_tmp25_ = skk_memory_mapped_file_get_length (_tmp24_);
			_tmp26_ = _tmp25_;
			if (!(((gsize) _tmp23_) < _tmp26_)) {
				break;
			}
			_tmp27_ = p;
			if ((*_tmp27_) == '\n') {
				break;
			}
			_tmp28_ = builder;
			_tmp29_ = p;
			g_string_append_c (_tmp28_, *_tmp29_);
		}
	}
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	_g_string_free0 (builder);
	return result;
}


static gchar* skk_file_dict_read_previous_line (SkkFileDict* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	if (_tmp0_ < ((glong) 2)) {
		result = NULL;
		return result;
	}
	_tmp1_ = *pos;
	*pos = _tmp1_ - 2;
	_tmp2_ = skk_file_dict_read_line (self, pos);
	result = _tmp2_;
	return result;
}


static gchar* skk_file_dict_read_next_line (SkkFileDict* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SkkMemoryMappedFile* _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	glong _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->mmap;
	_tmp5_ = skk_memory_mapped_file_get_length (_tmp4_);
	_tmp6_ = _tmp5_;
	if (((gsize) ((_tmp0_ + _tmp3_) + 1)) >= _tmp6_) {
		result = NULL;
		return result;
	}
	_tmp7_ = *pos;
	_tmp8_ = line;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	*pos = _tmp7_ + (_tmp10_ + 1);
	_tmp11_ = skk_file_dict_read_line (self, pos);
	result = _tmp11_;
	return result;
}


static gboolean skk_file_dict_read_until (SkkFileDict* self, glong* offset, const gchar* line) {
	gboolean result = FALSE;
	glong _tmp0_;
	SkkMemoryMappedFile* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = skk_memory_mapped_file_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp3_, NULL);
	while (TRUE) {
		glong _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		SkkMemoryMappedFile* _tmp8_;
		gsize _tmp9_;
		gsize _tmp10_;
		SkkMemoryMappedFile* _tmp11_;
		void* _tmp12_;
		void* _tmp13_;
		glong _tmp14_;
		gchar* p;
		gboolean _tmp15_ = FALSE;
		gchar* _tmp16_;
		gboolean _tmp23_;
		glong _tmp28_;
		_tmp4_ = *offset;
		_tmp5_ = line;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->mmap;
		_tmp9_ = skk_memory_mapped_file_get_length (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!(((gsize) (_tmp4_ + _tmp7_)) < _tmp10_)) {
			break;
		}
		_tmp11_ = self->priv->mmap;
		_tmp12_ = skk_memory_mapped_file_get_memory (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = *offset;
		p = ((gchar*) _tmp13_) + _tmp14_;
		_tmp16_ = p;
		if ((*_tmp16_) == '\n') {
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_ = 0;
			_tmp17_ = p;
			_tmp18_ = line;
			_tmp19_ = line;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = memcmp (_tmp17_ + 1, (void*) _tmp18_, (gsize) _tmp21_);
			_tmp15_ = _tmp22_ == 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp23_ = _tmp15_;
		if (_tmp23_) {
			glong _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp24_ = *offset;
			_tmp25_ = line;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			*offset = _tmp24_ + _tmp27_;
			result = TRUE;
			return result;
		}
		_tmp28_ = *offset;
		*offset = _tmp28_ + 1;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void skk_file_dict_load (SkkFileDict* self, GError** error) {
	SkkMemoryMappedFile* _tmp0_;
	glong offset;
	gchar* _tmp1_ = NULL;
	gchar* line;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* coding;
	const gchar* _tmp6_;
	gboolean _tmp15_ = FALSE;
	glong _tmp17_;
	gboolean _tmp18_ = FALSE;
	glong _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mmap;
	skk_memory_mapped_file_remap (_tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	offset = (glong) 0;
	_tmp1_ = skk_file_dict_read_line (self, &offset);
	line = _tmp1_;
	_tmp2_ = line;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = line;
	_tmp5_ = skk_encoding_converter_extract_coding_system (_tmp4_);
	coding = _tmp5_;
	_tmp6_ = coding;
	if (_tmp6_ != NULL) {
		{
			const gchar* _tmp7_;
			SkkEncodingConverter* _tmp8_;
			SkkEncodingConverter* _converter;
			SkkEncodingConverter* _tmp9_;
			_tmp7_ = coding;
			_tmp8_ = skk_encoding_converter_new_from_coding_system (_tmp7_, &_inner_error_);
			_converter = _tmp8_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_tmp9_ = _converter;
			if (_tmp9_ != NULL) {
				SkkEncodingConverter* _tmp10_;
				SkkEncodingConverter* _tmp11_;
				_tmp10_ = _converter;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp11_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = coding;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("file-dict.vala:105: can't create converter from coding system %s: %s", _tmp12_, _tmp14_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (line);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	offset = (glong) 0;
	_tmp15_ = skk_file_dict_read_until (self, &offset, ";; okuri-ari entries.\n");
	if (!_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = offset;
	self->priv->okuri_ari_offset = _tmp17_;
	_tmp18_ = skk_file_dict_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp18_) {
		GError* _tmp19_;
		_tmp19_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = offset;
	self->priv->okuri_nasi_offset = _tmp20_;
	_g_free0 (coding);
	_g_free0 (line);
}


/**
         * {@inheritDoc}
         */
static void skk_file_dict_real_reload (SkkDict* base, GError** error) {
	SkkFileDict * self;
	gchar* _tmp0_;
	gchar* attributes;
	GFile* _tmp1_;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* info;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			skk_file_dict_load (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch3_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp5_ = g_file_info_get_etag (info);
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp6_;
		}
		goto __finally3;
		__catch3_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("file-dict.vala:140: error loading file dictionary %s %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gboolean skk_file_dict_search_pos (SkkFileDict* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction) {
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	gboolean result = FALSE;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong offset;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		SkkMemoryMappedFile* _tmp6_;
		gsize _tmp7_;
		gsize _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _line;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		gint index;
		gint _tmp12_;
		GCompareFunc _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_ = 0;
		gint _tmp21_;
		gint r;
		gint _tmp22_;
		gint _tmp26_;
		gint _tmp27_;
		glong _tmp33_;
		glong _tmp34_;
		glong _tmp35_;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = offset;
		_tmp6_ = self->priv->mmap;
		_tmp7_ = skk_memory_mapped_file_get_length (_tmp6_);
		_tmp8_ = _tmp7_;
		g_assert (((gsize) _tmp5_) < _tmp8_);
		_tmp9_ = skk_file_dict_read_line (self, &offset);
		_line = _tmp9_;
		_tmp10_ = _line;
		_tmp11_ = string_index_of (_tmp10_, " ", 0);
		index = _tmp11_;
		_tmp12_ = index;
		if (_tmp12_ < 1) {
			const gchar* _tmp13_;
			_tmp13_ = _line;
			g_warning ("file-dict.vala:160: corrupted dictionary entry: %s", _tmp13_);
			_g_free0 (_line);
			break;
		}
		_tmp14_ = cmp;
		_tmp15_ = _line;
		_tmp16_ = index;
		_tmp17_ = string_slice (_tmp15_, (glong) 0, (glong) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = midasi;
		_tmp20_ = _tmp14_ (_tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp18_);
		r = _tmp21_;
		_tmp22_ = r;
		if (_tmp22_ == 0) {
			glong _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp23_ = offset;
			_vala_pos = _tmp23_;
			_tmp24_ = _line;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (_vala_line);
			_vala_line = _tmp25_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		_tmp26_ = r;
		_tmp27_ = direction;
		if ((_tmp26_ * _tmp27_) > 0) {
			glong _tmp28_;
			_tmp28_ = offset;
			end_offset = _tmp28_ - 2;
		} else {
			glong _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp29_ = offset;
			_tmp30_ = _line;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			start_offset = (_tmp29_ + _tmp32_) + 1;
		}
		_tmp33_ = start_offset;
		_tmp34_ = end_offset;
		_tmp35_ = start_offset;
		offset = _tmp33_ + ((_tmp34_ - _tmp35_) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) (-1);
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkFileDict * self;
	SkkCandidate** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gboolean _tmp5_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp21_ = 0;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	glong _tmp24_;
	glong _tmp25_;
	GCompareFunc _tmp26_;
	gint _tmp27_;
	glong _tmp28_ = 0L;
	gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	SkkCandidate** _tmp56_ = NULL;
	SkkCandidate** _tmp57_;
	gint _tmp57__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_ = NULL;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = okuri;
	if (_tmp5_) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = self->priv->okuri_ari_offset;
		start_offset = _tmp6_;
		_tmp7_ = self->priv->okuri_nasi_offset;
		end_offset = _tmp7_;
	} else {
		glong _tmp8_;
		SkkMemoryMappedFile* _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		_tmp8_ = self->priv->okuri_nasi_offset;
		start_offset = _tmp8_;
		_tmp9_ = self->priv->mmap;
		_tmp10_ = skk_memory_mapped_file_get_length (_tmp9_);
		_tmp11_ = _tmp10_;
		end_offset = ((glong) _tmp11_) - 1;
	}
	{
		SkkEncodingConverter* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp12_ = self->priv->converter;
		_tmp13_ = midasi;
		_tmp14_ = skk_encoding_converter_encode (_tmp12_, _tmp13_, &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_free0 (_midasi);
		_midasi = _tmp15_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		SkkCandidate** _tmp19_ = NULL;
		SkkCandidate** _tmp20_;
		gint _tmp20__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = midasi;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("file-dict.vala:202: can't encode %s: %s", _tmp16_, _tmp18_);
		_tmp19_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp20_ = _tmp19_;
		_tmp20__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp20__length1;
		}
		result = _tmp20_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp22_ = okuri;
	if (_tmp22_) {
		_tmp21_ = -1;
	} else {
		_tmp21_ = 1;
	}
	_tmp23_ = _midasi;
	_tmp24_ = start_offset;
	_tmp25_ = end_offset;
	_tmp26_ = g_strcmp0;
	_tmp27_ = _tmp21_;
	_tmp30_ = skk_file_dict_search_pos (self, _tmp23_, _tmp24_, _tmp25_, _tmp26_, &_tmp28_, &_tmp29_, _tmp27_);
	pos = _tmp28_;
	_g_free0 (line);
	line = _tmp29_;
	if (_tmp30_) {
		const gchar* _tmp31_;
		gint _tmp32_ = 0;
		gint index;
		gchar* _line = NULL;
		gint _tmp33_;
		_tmp31_ = line;
		_tmp32_ = string_index_of (_tmp31_, " ", 0);
		index = _tmp32_;
		_tmp33_ = index;
		if (_tmp33_ > 0) {
			const gchar* _tmp50_;
			gboolean _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_ = 0;
			SkkCandidate** _tmp54_ = NULL;
			SkkCandidate** _tmp55_;
			gint _tmp55__length1;
			{
				SkkEncodingConverter* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				const gchar* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp34_ = self->priv->converter;
				_tmp35_ = line;
				_tmp36_ = index;
				_tmp37_ = line;
				_tmp38_ = strlen (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = string_slice (_tmp35_, (glong) _tmp36_, (glong) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = skk_encoding_converter_decode (_tmp34_, _tmp41_, &_inner_error_);
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp41_);
				_tmp44_ = _tmp43_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_g_free0 (_line);
				_line = _tmp44_;
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp45_;
				GError* _tmp46_;
				const gchar* _tmp47_;
				SkkCandidate** _tmp48_ = NULL;
				SkkCandidate** _tmp49_;
				gint _tmp49__length1;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp45_ = line;
				_tmp46_ = e;
				_tmp47_ = _tmp46_->message;
				g_warning ("file-dict.vala:221: can't decode line %s: %s", _tmp45_, _tmp47_);
				_tmp48_ = g_new0 (SkkCandidate*, 0 + 1);
				_tmp49_ = _tmp48_;
				_tmp49__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp49__length1;
				}
				result = _tmp49_;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				return result;
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp50_ = midasi;
			_tmp51_ = okuri;
			_tmp52_ = _line;
			_tmp54_ = skk_dict_split_candidates ((SkkDict*) self, _tmp50_, _tmp51_, _tmp52_, &_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp55__length1 = _tmp53_;
			if (result_length1) {
				*result_length1 = _tmp55__length1;
			}
			result = _tmp55_;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			return result;
		}
		_g_free0 (_line);
	}
	_tmp56_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp57__length1;
	}
	result = _tmp57_;
	_g_free0 (line);
	_g_free0 (_midasi);
	return result;
}


static gint skk_file_dict_strcmp_prefix (const gchar* a, const gchar* b) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = g_strcmp0;
	_tmp4_ = a;
	_tmp5_ = b;
	_tmp6_ = _tmp3_ (_tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = skk_file_dict_strcmp_prefix (a, b);
	return result;
}


static gchar** skk_file_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkFileDict * self;
	gchar** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	GeeArrayList* _tmp5_;
	GeeArrayList* completion;
	glong start_offset = 0L;
	glong end_offset = 0L;
	glong _tmp6_;
	SkkMemoryMappedFile* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp21_;
	glong _tmp22_;
	glong _tmp23_;
	glong _tmp24_ = 0L;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GeeArrayList* _tmp85_;
	gint _tmp86_ = 0;
	gpointer* _tmp87_ = NULL;
	gchar** _tmp88_;
	gint _tmp88__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	completion = _tmp5_;
	_tmp6_ = self->priv->okuri_nasi_offset;
	start_offset = _tmp6_;
	_tmp7_ = self->priv->mmap;
	_tmp8_ = skk_memory_mapped_file_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	end_offset = (glong) _tmp9_;
	{
		SkkEncodingConverter* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp10_ = self->priv->converter;
		_tmp11_ = midasi;
		_tmp12_ = skk_encoding_converter_encode (_tmp10_, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_g_free0 (_midasi);
		_midasi = _tmp13_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_ = 0;
		gpointer* _tmp19_ = NULL;
		gchar** _tmp20_;
		gint _tmp20__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = midasi;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("file-dict.vala:254: can't decode %s: %s", _tmp14_, _tmp16_);
		_tmp17_ = completion;
		_tmp19_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp17_, &_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp20__length1 = _tmp18_;
		if (result_length1) {
			*result_length1 = _tmp20__length1;
		}
		result = _tmp20_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp21_ = _midasi;
	_tmp22_ = start_offset;
	_tmp23_ = end_offset;
	_tmp26_ = skk_file_dict_search_pos (self, _tmp21_, _tmp22_, _tmp23_, _skk_file_dict_strcmp_prefix_gcompare_func, &_tmp24_, &_tmp25_, 1);
	pos = _tmp24_;
	_g_free0 (line);
	line = _tmp25_;
	if (_tmp26_) {
		glong _tmp27_;
		glong _pos;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _line;
		glong _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp27_ = pos;
		_pos = _tmp27_;
		_tmp28_ = line;
		_tmp29_ = g_strdup (_tmp28_);
		_line = _tmp29_;
		{
			gboolean _tmp30_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gboolean _tmp31_;
				const gchar* _tmp40_;
				gint _tmp41_ = 0;
				gint index;
				gint _tmp42_;
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
					gchar* _tmp34_ = NULL;
					const gchar* _tmp35_;
					gboolean _tmp39_;
					_tmp33_ = line;
					_tmp34_ = skk_file_dict_read_previous_line (self, &pos, _tmp33_);
					_g_free0 (line);
					line = _tmp34_;
					_tmp35_ = line;
					if (_tmp35_ != NULL) {
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gboolean _tmp38_ = FALSE;
						_tmp36_ = line;
						_tmp37_ = _midasi;
						_tmp38_ = g_str_has_prefix (_tmp36_, _tmp37_);
						_tmp32_ = _tmp38_;
					} else {
						_tmp32_ = FALSE;
					}
					_tmp39_ = _tmp32_;
					if (!_tmp39_) {
						break;
					}
				}
				_tmp30_ = FALSE;
				_tmp40_ = line;
				_tmp41_ = string_index_of (_tmp40_, " ", 0);
				index = _tmp41_;
				_tmp42_ = index;
				if (_tmp42_ < 0) {
					const gchar* _tmp43_;
					_tmp43_ = line;
					g_warning ("file-dict.vala:274: corrupted dictionary entry: %s", _tmp43_);
				} else {
					const gchar* _tmp44_;
					gint _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* completed;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					_tmp44_ = line;
					_tmp45_ = index;
					_tmp46_ = string_slice (_tmp44_, (glong) 0, (glong) _tmp45_);
					completed = _tmp46_;
					_tmp47_ = completed;
					_tmp48_ = _midasi;
					if (g_strcmp0 (_tmp47_, _tmp48_) != 0) {
						{
							SkkEncodingConverter* _tmp49_;
							const gchar* _tmp50_;
							gchar* _tmp51_ = NULL;
							gchar* decoded;
							GeeArrayList* _tmp52_;
							const gchar* _tmp53_;
							_tmp49_ = self->priv->converter;
							_tmp50_ = completed;
							_tmp51_ = skk_encoding_converter_decode (_tmp49_, _tmp50_, &_inner_error_);
							decoded = _tmp51_;
							if (_inner_error_ != NULL) {
								goto __catch7_g_error;
							}
							_tmp52_ = completion;
							_tmp53_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp52_, 0, _tmp53_);
							_g_free0 (decoded);
						}
						goto __finally7;
						__catch7_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp54_;
							GError* _tmp55_;
							const gchar* _tmp56_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp54_ = line;
							_tmp55_ = e;
							_tmp56_ = _tmp55_->message;
							g_warning ("file-dict.vala:284: can't decode line %s: %s", _tmp54_, _tmp56_);
							_g_error_free0 (e);
						}
						__finally7:
						if (_inner_error_ != NULL) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		_tmp57_ = _pos;
		pos = _tmp57_;
		_tmp58_ = _line;
		_tmp59_ = g_strdup (_tmp58_);
		_g_free0 (line);
		line = _tmp59_;
		while (TRUE) {
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			gchar* _tmp62_ = NULL;
			const gchar* _tmp63_;
			gboolean _tmp67_;
			const gchar* _tmp68_;
			gint _tmp69_ = 0;
			gint index;
			gint _tmp70_;
			_tmp61_ = line;
			_tmp62_ = skk_file_dict_read_next_line (self, &pos, _tmp61_);
			_g_free0 (line);
			line = _tmp62_;
			_tmp63_ = line;
			if (_tmp63_ != NULL) {
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				gboolean _tmp66_ = FALSE;
				_tmp64_ = line;
				_tmp65_ = _midasi;
				_tmp66_ = g_str_has_prefix (_tmp64_, _tmp65_);
				_tmp60_ = _tmp66_;
			} else {
				_tmp60_ = FALSE;
			}
			_tmp67_ = _tmp60_;
			if (!_tmp67_) {
				break;
			}
			_tmp68_ = line;
			_tmp69_ = string_index_of (_tmp68_, " ", 0);
			index = _tmp69_;
			_tmp70_ = index;
			if (_tmp70_ < 0) {
				const gchar* _tmp71_;
				_tmp71_ = line;
				g_warning ("file-dict.vala:299: corrupted dictionary entry: %s", _tmp71_);
			} else {
				const gchar* _tmp72_;
				gint _tmp73_;
				gchar* _tmp74_ = NULL;
				gchar* completed;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				_tmp72_ = line;
				_tmp73_ = index;
				_tmp74_ = string_slice (_tmp72_, (glong) 0, (glong) _tmp73_);
				completed = _tmp74_;
				_tmp75_ = completed;
				_tmp76_ = _midasi;
				if (g_strcmp0 (_tmp75_, _tmp76_) != 0) {
					{
						SkkEncodingConverter* _tmp77_;
						const gchar* _tmp78_;
						gchar* _tmp79_ = NULL;
						gchar* decoded;
						GeeArrayList* _tmp80_;
						const gchar* _tmp81_;
						_tmp77_ = self->priv->converter;
						_tmp78_ = completed;
						_tmp79_ = skk_encoding_converter_decode (_tmp77_, _tmp78_, &_inner_error_);
						decoded = _tmp79_;
						if (_inner_error_ != NULL) {
							goto __catch8_g_error;
						}
						_tmp80_ = completion;
						_tmp81_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp80_, _tmp81_);
						_g_free0 (decoded);
					}
					goto __finally8;
					__catch8_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp82_;
						GError* _tmp83_;
						const gchar* _tmp84_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp82_ = line;
						_tmp83_ = e;
						_tmp84_ = _tmp83_->message;
						g_warning ("file-dict.vala:309: can't decode line %s: %s", _tmp82_, _tmp84_);
						_g_error_free0 (e);
					}
					__finally8:
					if (_inner_error_ != NULL) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp85_ = completion;
	_tmp87_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp85_, &_tmp86_);
	_tmp88_ = _tmp87_;
	_tmp88__length1 = _tmp86_;
	if (result_length1) {
		*result_length1 = _tmp88__length1;
	}
	result = _tmp88_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}


/**
         * Create a new FileDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkFileDict* skk_file_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	SkkFileDict * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	SkkMemoryMappedFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	SkkEncodingConverter* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkFileDict*) skk_dict_construct (object_type);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = self->priv->file;
	_tmp3_ = skk_memory_mapped_file_new (_tmp2_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp4_;
	_tmp5_ = encoding;
	_tmp6_ = skk_encoding_converter_new (_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp7_;
	skk_dict_reload ((SkkDict*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


SkkFileDict* skk_file_dict_new (const gchar* path, const gchar* encoding, GError** error) {
	return skk_file_dict_construct (SKK_TYPE_FILE_DICT, path, encoding, error);
}


static gboolean skk_file_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkFileDict* self;
	self = (SkkFileDict*) base;
	result = TRUE;
	return result;
}


static void skk_file_dict_class_init (SkkFileDictClass * klass) {
	skk_file_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkFileDictPrivate));
	SKK_DICT_CLASS (klass)->reload = skk_file_dict_real_reload;
	SKK_DICT_CLASS (klass)->lookup = skk_file_dict_real_lookup;
	SKK_DICT_CLASS (klass)->complete = skk_file_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_file_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_file_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_file_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_FILE_DICT_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_file_dict_instance_init (SkkFileDict * self) {
	self->priv = SKK_FILE_DICT_GET_PRIVATE (self);
}


static void skk_file_dict_finalize (GObject* obj) {
	SkkFileDict * self;
	self = SKK_FILE_DICT (obj);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_file_dict_parent_class)->finalize (obj);
}


/**
     * Read-only file based implementation of Dict.
     */
GType skk_file_dict_get_type (void) {
	static volatile gsize skk_file_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_file_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkFileDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_file_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkFileDict), 0, (GInstanceInitFunc) skk_file_dict_instance_init, NULL };
		GType skk_file_dict_type_id;
		skk_file_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkFileDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_file_dict_type_id__volatile, skk_file_dict_type_id);
	}
	return skk_file_dict_type_id__volatile;
}


static void _vala_skk_file_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkFileDict * self;
	self = SKK_FILE_DICT (object);
	switch (property_id) {
		case SKK_FILE_DICT_READ_ONLY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



